"""empty message

Revision ID: ee2ba4d37d8b
Revises: 8f12363abaaf
Create Date: 2023-11-09 16:20:23.973472

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm

DeclarativeBase = orm.declarative_base()

# revision identifiers, used by Alembic.
revision = 'ee2ba4d37d8b'
down_revision = '8f12363abaaf'
branch_labels = None
depends_on = None


class Expense(DeclarativeBase):
    __tablename__ = 'expense'
    id = sa.Column(sa.Integer, primary_key=True)
    exclude_from_statistics = sa.Column(sa.Boolean, default=False, nullable=True)

    
def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    bind = op.get_bind()
    session = orm.Session(bind=bind)

    with op.batch_alter_table('expense', schema=None) as batch_op:
        batch_op.add_column(sa.Column('exclude_from_statistics', sa.Boolean(), nullable=True))

    expenses = session.query(Expense).all()
    for expense in expenses:
        expense.exclude_from_statistics = False
    try:
        session.bulk_save_objects(expenses)
        session.commit()
    except Exception as e:
        session.rollback()
        raise e

    with op.batch_alter_table('expense', schema=None) as batch_op:
        batch_op.alter_column('exclude_from_statistics', nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('expense', schema=None) as batch_op:
        batch_op.drop_column('exclude_from_statistics')

    # ### end Alembic commands ###
