"""empty message

Revision ID: bd383e73ef4d
Revises: aa5d56fe28bb
Create Date: 2025-06-27 19:18:54.534958

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm

DeclarativeBase = orm.declarative_base()

class Recipe(DeclarativeBase):
    __tablename__ = 'recipe'
    id = sa.Column(sa.Integer, primary_key=True)
    server_curated = sa.Column(sa.Boolean)
    server_scrapes = sa.Column(sa.Integer)


# revision identifiers, used by Alembic.
revision = 'bd383e73ef4d'
down_revision = 'aa5d56fe28bb'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('household', schema=None) as batch_op:
        batch_op.add_column(sa.Column('description', sa.String(), nullable=True))
        batch_op.add_column(sa.Column('link', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('verified', sa.Boolean(), nullable=True))

    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.add_column(sa.Column('server_curated', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('server_scrapes', sa.Integer(), nullable=True))

    # Data migration
    bind = op.get_bind()
    session = orm.Session(bind=bind)

    recipes = session.query(Recipe).all()
    for recipe in recipes:
        recipe.server_curated = False
        recipe.server_scrapes = 0

    try:
        session.bulk_save_objects(recipes)
        session.commit()
    except Exception as e:
        session.rollback()
        raise e

    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.alter_column('server_curated', nullable=False)
        batch_op.alter_column('server_scrapes', nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.drop_column('server_scrapes')
        batch_op.drop_column('server_curated')

    with op.batch_alter_table('household', schema=None) as batch_op:
        batch_op.drop_column('verified')
        batch_op.drop_column('link')
        batch_op.drop_column('description')

    # ### end Alembic commands ###
