"""empty message

Revision ID: 4acda0d5ca8a
Revises: 0c1f16a519d1
Create Date: 2024-09-04 19:09:24.699528

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm

DeclarativeBase = orm.declarative_base()

class Recipe(DeclarativeBase):
    __tablename__ = 'recipe'
    id = sa.Column(sa.Integer, primary_key=True)
    public = sa.Column(sa.Boolean)


# revision identifiers, used by Alembic.
revision = '4acda0d5ca8a'
down_revision = '0c1f16a519d1'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.add_column(sa.Column('public', sa.Boolean(), nullable=True))

    # Data migration
    bind = op.get_bind()
    session = orm.Session(bind=bind)

    recipes = session.query(Recipe).all()
    for recipe in recipes:
        recipe.public = False

    try:
        session.bulk_save_objects(recipes)
        session.commit()
    except Exception as e:
        session.rollback()
        raise e

    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.alter_column('public', nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('recipe', schema=None) as batch_op:
        batch_op.drop_column('public')

    # ### end Alembic commands ###
