"""empty message

Revision ID: 11c15698c8bf
Revises: e209fcb83993
Create Date: 2022-04-18 15:12:24.971186

"""
from alembic import op
import sqlalchemy as sa

from app.config import DB_URL


# revision identifiers, used by Alembic.
revision = '11c15698c8bf'
down_revision = 'e209fcb83993'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('expense_category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=128), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_expense_category'))
    )
    with op.batch_alter_table('expense', schema=None) as batch_op:
        batch_op.add_column(sa.Column('category_id', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_expense_category_id_expense_category'), 'expense_category', ['category_id'], ['id'])

    if DB_URL.drivername == 'sqlite':
        with op.batch_alter_table('item', schema=None) as batch_op:
            batch_op.create_unique_constraint(batch_op.f('uq_item_name'), ['name'])

        with op.batch_alter_table('shoppinglist', schema=None) as batch_op:
            batch_op.create_unique_constraint(batch_op.f('uq_shoppinglist_name'), ['name'])

        with op.batch_alter_table('user', schema=None) as batch_op:
            batch_op.create_unique_constraint(batch_op.f('uq_user_username'), ['username'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if DB_URL.drivername == 'sqlite':
        with op.batch_alter_table('user', schema=None) as batch_op:
            batch_op.drop_constraint(batch_op.f('uq_user_username'), type_='unique')

        with op.batch_alter_table('shoppinglist', schema=None) as batch_op:
            batch_op.drop_constraint(batch_op.f('uq_shoppinglist_name'), type_='unique')

        with op.batch_alter_table('item', schema=None) as batch_op:
            batch_op.drop_constraint(batch_op.f('uq_item_name'), type_='unique')

    with op.batch_alter_table('expense', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_expense_category_id_expense_category'), type_='foreignkey')
        batch_op.drop_column('category_id')

    op.drop_table('expense_category')
    # ### end Alembic commands ###
