<h1 align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="./docs/docs/img/icon.png">
    <img width="128" src="./docs/docs/img/logo.png" alt="KitchenOwl">
  </picture>
</h1>
<p align="center">
  <p align="center">A smart grocery list and recipe manager.</p>
</p>

<h4 align="center">
  <a href="https://kitchenowl.org">Website</a> |
  <a href="https://docs.kitchenowl.org">Docs</a> |
  <a href="https://docs.kitchenowl.org/latest/self-hosting/">Self-Hosting</a> |
  <a href="https://matrix.to/#/#kitchenowl:matrix.org">Matrix</a>
</h4>

<h4 align="center">
  <a href="https://github.com/TomBursch/kitchenowl">
    <img alt="Stars" src="https://img.shields.io/github/stars/tombursch/kitchenowl" />
  </a>
  <a href="https://hosted.weblate.org/engage/kitchenowl/">
    <img alt="Translation" src="https://hosted.weblate.org/widgets/kitchenowl/-/kitchenowl/svg-badge.svg" />
  </a>
  <a href="https://matrix.to/#/#kitchenowl:matrix.org">
    <img alt="Matrix" src="https://img.shields.io/matrix/kitchenowl:matrix.org">
  </a>
  <a href="LICENSE">
    <img alt="License" src="https://img.shields.io/github/license/TomBursch/kitchenowl" />
  </a>
  <a href="https://github.com/TomBursch/kitchenowl/releases">
    <img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/tombursch/kitchenowl">
  </a>
  <a href="https://hub.docker.com/repository/docker/tombursch/kitchenowl">
    <img alt="Docker pulls" src="https://img.shields.io/docker/pulls/tombursch/kitchenowl" />
  </a>
</h4>

<div align="center">
  <a href='https://play.google.com/store/apps/details?id=com.tombursch.kitchenowl'>
    <img alt='Get it on Google Play' src='docs/docs/img/badges/playstore.png' height="50" />
  </a>
  <a href='https://f-droid.org/packages/com.tombursch.kitchenowl/'>
    <img alt='Get it on F-Droid' src='docs/docs/img/badges/f-droid.png' height="50"/>
  </a>
  <a href='https://apps.apple.com/app/kitchenowl/id1557453670'>
    <img alt='Get it on the AppStore' src='docs/docs/img/badges/appstore.png' height="50" />
  </a>
  <a href='https://my.home-assistant.io/redirect/hacs_repository/?owner=TomBursch&repository=kitchenowl-ha&category=integration'>
    <img alt='Get it on the Home Assistant Community Store' src='docs/docs/img/badges/hacs_repository.svg' height="50" />
  </a>
</div>

<h3 align="center">
 🍫 🥘 🍽
</h3>

KitchenOwl is a smart self-hosted grocery list and recipe manager. Easily add items to your shopping list before you go shopping. You can also create recipes and get suggestions on what you want to cook. Track your expenses so you know how much you've spent.

- Native Mobile/Web/Desktop apps with a great design
- Add items to your shopping list and sync them in real-time with multiple users
- Partial offline support, so you don't lose track of what to buy even when there is no signal
- Manage recipes and add them to your shopping list
- Share recipes with friends and family
- Create a meal plan to always know what you'll be eating
- Manage balances and track expenses of your household

Please keep in mind that this project is still in development.

For a full list check out the [website](https://kitchenowl.org). For a list of planned features, take a look at the [Roadmap](https://github.com/users/TomBursch/projects/1)!

## 📱 Screenshots

<table>
  <tr>
    <td><img alt="Groceries page" src="metadata/en-US/images/phoneScreenshots/groceries.png"/></td>
    <td><img alt="Recipe page" src="metadata/en-US/images/phoneScreenshots/recipe.png"/></td>
    <td><img alt="Plan page" src="metadata/en-US/images/phoneScreenshots/plan.png"/></td>
    <td><img alt="Expense page" src="metadata/en-US/images/phoneScreenshots/expenses.png"/></td>
   </tr>
</table>

## 🤖 App Install

Get it in your favorite store or find the current release for your operating system on the [releases page](https://github.com/TomBursch/kitchenowl/releases).

## 🚀 Get started

Please take a look at the [get started guide](https://docs.kitchenowl.org/latest/self-hosting/).

## 🙌 Contributing

From opening a bug report to creating a pull request: every contribution is appreciated and welcomed. If you're planning to implement a new feature or change the API please create an issue first. This way, we can ensure your work is not in vain.
For more information see [Contributing](CONTRIBUTING.md) or get in contact by joining our [Matrix space](https://matrix.to/#/#kitchenowl:matrix.org).

### 🌍 Translations

You can help translate the App into your language by using [Weblate](https://hosted.weblate.org/engage/kitchenowl/)!

<p align="center">
  <a href="https://hosted.weblate.org/engage/kitchenowl/">
    <img src="https://hosted.weblate.org/widgets/kitchenowl/-/kitchenowl/multi-auto.svg" alt="Translation status" />
  </a>
</p>

## 🛎️ Stay Up-to-Date

KitchenOwl is moving fast, to stay updated consider starring and watching the releases of this repository.

### 💬 Status

- [x] Public Alpha: Still working on stuff (rarely things might break)
- [ ] Public Beta: Stable and most planned features complete
- [ ] Public: Production-ready

## 📚 Related

- [Website](https://kitchenowl.org)
- [Docs](https://docs.kitchenowl.org)
- [KitchenOwl Backend](https://github.com/TomBursch/kitchenowl-backend) Repository
- [KitchenOwl Website](https://github.com/TomBursch/kitchenowl-website) Repository
- [KitchenOwl Python Client](https://github.com/TomBursch/kitchenowl-python) Repository
- [KitchenOwl Home Assistant Integration](https://github.com/TomBursch/kitchenowl-ha) Repository
- [DockerHub](https://hub.docker.com/r/tombursch/kitchenowl)
- [Recipe scrapers](https://github.com/hhursev/recipe-scrapers) used for scraping recipes from the web
- [Weblate](https://weblate.org/) is helping with continuous localization as part of their ongoing support for open-source software projects.

### 🔨 Built With

- [Flask](https://flask.palletsprojects.com/)
- [Flutter](https://flutter.dev/)
- [Docker](https://docs.docker.com/)

## 🍀 Contributors

<a href="https://github.com/tombursch/KitchenOwl/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=tombursch/KitchenOwl" />
</a>

## 📜 License

KitchenOwl is Free Software: You can use, study share and improve it at your will. Specifically you can redistribute and/or modify it under the terms of the AGPL-3.0 License.
