/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.util.zip.Deflater;

public class DeflaterInputStream
extends FilterInputStream {
    protected final Deflater def;
    protected final byte[] buf;
    private byte[] rbuf;
    private boolean usesDefaultDeflater;
    private boolean reachEOF;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public DeflaterInputStream(InputStream inputStream) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Deflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.<init>:()V");
        Deflater deflater = new Deflater();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Deflater;)V");
        this(inputStream, deflater);
        this.usesDefaultDeflater = true;
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Deflater;I)V");
        this(inputStream, deflater, 512);
    }

    public DeflaterInputStream(InputStream inputStream, Deflater deflater, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
        super(inputStream);
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
        this.rbuf = new byte[1];
        this.usesDefaultDeflater = false;
        this.reachEOF = false;
        RuntimeCostAccounter.recordJump();
        if (inputStream == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("Null input");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (deflater == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("Null deflater");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size < 1");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.def = deflater;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in != null) {
            try {
                RuntimeCostAccounter.recordJump();
                if (this.usesDefaultDeflater) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.end:()V");
                    this.def.end();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                this.in.close();
                this.in = null;
            }
            catch (Throwable throwable) {
                this.in = null;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.read:([BII)I");
        int n = this.read(this.rbuf, 0, 1);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            return -1;
        }
        return this.rbuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        block13: {
            block12: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
                    NullPointerException nullPointerException = new NullPointerException("Null buffer for read");
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block12;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block12;
                int n3 = byArray.length - n;
                RuntimeCostAccounter.recordJump();
                if (n2 <= n3) break block13;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (true) {
            int n5;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
            boolean bl = this.def.finished();
            RuntimeCostAccounter.recordJump();
            if (bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.needsInput:()Z");
            boolean bl2 = this.def.needsInput();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                int n6 = this.buf.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                n5 = this.in.read(this.buf, 0, n6);
                RuntimeCostAccounter.recordJump();
                if (n5 < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finish:()V");
                    this.def.finish();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n5 > 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.setInput:([BII)V");
                        this.def.setInput(this.buf, 0, n5);
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.deflate:([BII)I");
            n5 = this.def.deflate(byArray, n, n2);
            n4 += n5;
            n += n5;
            n2 -= n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n4 == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.finished:()Z");
            boolean bl = this.def.finished();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.reachEOF = true;
                n4 = -1;
            }
        }
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("negative skip length");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        int n = this.rbuf.length;
        RuntimeCostAccounter.recordJump();
        if (n < 512) {
            RuntimeCostAccounter.recordArrayAllocation((int)512, (int)1);
            this.rbuf = new byte[512];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        int n2 = (int)Math.min(l, Integer.MAX_VALUE);
        long l2 = 0L;
        while (true) {
            int n3;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            int n4 = this.rbuf.length;
            RuntimeCostAccounter.recordJump();
            if (n2 <= n4) {
                n3 = n2;
                RuntimeCostAccounter.recordJump();
            } else {
                n3 = this.rbuf.length;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.read:([BII)I");
            int n5 = this.read(this.rbuf, 0, n3);
            RuntimeCostAccounter.recordJump();
            if (n5 < 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            l2 += (long)n5;
            n2 -= n5;
            RuntimeCostAccounter.recordJump();
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DeflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark/reset not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }
}

