/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.jar;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.util.jar.Manifest;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry;

    public JarOutputStream(OutputStream outputStream, Manifest manifest) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        this.firstEntry = true;
        RuntimeCostAccounter.recordJump();
        if (manifest == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("man");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.<init>:(Ljava/lang/String;)V");
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.putNextEntry:(Ljava/util/zip/ZipEntry;)V");
        this.putNextEntry(zipEntry);
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.<init>:(Ljava/io/OutputStream;)V");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.write:(Ljava/io/OutputStream;)V");
        manifest.write(bufferedOutputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.closeEntry:()V");
        this.closeEntry();
    }

    public JarOutputStream(OutputStream outputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        this.firstEntry = true;
    }

    @Override
    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        block5: {
            block7: {
                byte[] byArray;
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (!this.firstEntry) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getExtra:()[B");
                    byArray = zipEntry.getExtra();
                    RuntimeCostAccounter.recordJump();
                    if (byArray == null) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.hasMagic:([B)Z");
                    boolean bl = JarOutputStream.hasMagic(byArray);
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block7;
                }
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordArrayAllocation((int)4, (int)1);
                    byArray = new byte[4];
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n = byArray.length + 4;
                    RuntimeCostAccounter.recordArrayAllocation((int)n, (int)1);
                    byte[] byArray2 = new byte[n];
                    int n2 = byArray.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(byArray, 0, byArray2, 4, n2);
                    byArray = byArray2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.set16:([BII)V");
                JarOutputStream.set16(byArray, 0, 51966);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.set16:([BII)V");
                JarOutputStream.set16(byArray, 2, 0);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.setExtra:([B)V");
                zipEntry.setExtra(byArray);
            }
            this.firstEntry = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipOutputStream.putNextEntry:(Ljava/util/zip/ZipEntry;)V");
        super.putNextEntry(zipEntry);
    }

    private static boolean hasMagic(byte[] byArray) {
        try {
            int n = 0;
            while (true) {
                int n2 = byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.get16:([BI)I");
                int n3 = JarOutputStream.get16(byArray, n);
                RuntimeCostAccounter.recordJump();
                if (n3 == 51966) {
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarOutputStream.get16:([BI)I");
                n += JarOutputStream.get16(byArray, n + 2) + 4;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
        return false;
    }

    private static int get16(byte[] byArray, int n) {
        byte by = byArray[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
        int n2 = Byte.toUnsignedInt(by);
        byte by2 = byArray[n + 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
        return n2 | Byte.toUnsignedInt(by2) << 8;
    }

    private static void set16(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
    }
}

