/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.function.LongSupplier;
import sandbox.java.util.function.Supplier;

public final class OptionalLong {
    private static final OptionalLong EMPTY;
    private final boolean isPresent;
    private final long value;

    private OptionalLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = false;
        this.value = 0L;
    }

    public static OptionalLong empty() {
        return EMPTY;
    }

    private OptionalLong(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = true;
        this.value = l;
    }

    public static OptionalLong of(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.<init>:(J)V");
        return new OptionalLong(l);
    }

    public long getAsLong() {
        RuntimeCostAccounter.recordJump();
        if (!this.isPresent) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("No value present");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(LongConsumer longConsumer) {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
            longConsumer.accept(this.value);
        }
    }

    public long orElse(long l) {
        long l2;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            l2 = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = l;
        }
        return l2;
    }

    public long orElseGet(LongSupplier longSupplier) {
        long l;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            l = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongSupplier.getAsLong:()J");
            l = longSupplier.getAsLong();
        }
        return l;
    }

    public <X extends Throwable> long orElseThrow(Supplier<X> supplier) throws X {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            return this.value;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        Throwable throwable = (Throwable)supplier.get();
        RuntimeCostAccounter.recordThrow();
        throw throwable;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl2 = object instanceof OptionalLong;
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            return false;
        }
        OptionalLong optionalLong = (OptionalLong)object;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            boolean bl3 = optionalLong.isPresent;
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                long l = this.value - optionalLong.value;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 == false) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                bl = false;
                RuntimeCostAccounter.recordJump();
                return bl;
            }
        }
        boolean bl4 = optionalLong.isPresent;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent != bl4) return false;
        bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public int hashCode() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.hashCode:(J)I");
            n = Long.hashCode(this.value);
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            objectArray[0] = this.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            string = String.format("OptionalLong[%s]", objectArray);
            RuntimeCostAccounter.recordJump();
        } else {
            string = "OptionalLong.empty";
        }
        return string;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.<init>:()V");
        EMPTY = new OptionalLong();
    }
}

