/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedOutputStream;
import sandbox.java.io.File;
import sandbox.java.io.FileOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.nio.channels.FileChannel;
import sandbox.java.nio.channels.FileLock;
import sandbox.java.nio.file.FileAlreadyExistsException;
import sandbox.java.nio.file.OpenOption;
import sandbox.java.nio.file.Path;
import sandbox.java.nio.file.Paths;
import sandbox.java.nio.file.StandardOpenOption;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.HashMap;
import sandbox.java.util.logging.ErrorManager;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Formatter;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogManager;
import sandbox.java.util.logging.LogRecord;
import sandbox.java.util.logging.StreamHandler;
import sandbox.java.util.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileChannel lockFileChannel;
    private File[] files;
    private static final int MAX_LOCKS = 100;
    private static final HashMap<String, String> locks;

    private void open(File file, boolean bl) throws IOException {
        int n = 0;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.length:()J");
            n = (int)file.length();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.toString:()Ljava/lang/String;");
        String string = file.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/lang/String;Z)V");
        FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.<init>:(Ljava/io/OutputStream;)V");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/FileHandler$MeteredStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler$MeteredStream.<init>:(Ljava/util/logging/FileHandler;Ljava/io/OutputStream;I)V");
        this.meter = new MeteredStream(bufferedOutputStream, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setOutputStream:(Ljava/io/OutputStream;)V");
        this.setOutputStream(this.meter);
    }

    private void configure() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = clazz.getName();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(".pattern");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getStringProperty:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.pattern = logManager.getStringProperty(string2, "%h/java%u.log");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder4 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(".limit");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder6.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getIntProperty:(Ljava/lang/String;I)I");
        this.limit = logManager.getIntProperty(string3, 0);
        RuntimeCostAccounter.recordJump();
        if (this.limit < 0) {
            this.limit = 0;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder7 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(".count");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder9.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getIntProperty:(Ljava/lang/String;I)I");
        this.count = logManager.getIntProperty(string4, 1);
        RuntimeCostAccounter.recordJump();
        if (this.count <= 0) {
            this.count = 1;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder10 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(".append");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string5 = stringBuilder12.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getBooleanProperty:(Ljava/lang/String;Z)Z");
        this.append = logManager.getBooleanProperty(string5, false);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder13 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append(".level");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string6 = stringBuilder15.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
        Level level = logManager.getLevelProperty(string6, Level.ALL);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(level);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder16 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder17 = stringBuilder16.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder18 = stringBuilder17.append(".filter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string7 = stringBuilder18.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFilterProperty:(Ljava/lang/String;Ljava/util/logging/Filter;)Ljava/util/logging/Filter;");
        Filter filter = logManager.getFilterProperty(string7, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setFilter:(Ljava/util/logging/Filter;)V");
        this.setFilter(filter);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder19 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder20 = stringBuilder19.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder21 = stringBuilder20.append(".formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string8 = stringBuilder21.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/XMLFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/XMLFormatter.<init>:()V");
        XMLFormatter xMLFormatter = new XMLFormatter();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFormatterProperty:(Ljava/lang/String;Ljava/util/logging/Formatter;)Ljava/util/logging/Formatter;");
        Formatter formatter = logManager.getFormatterProperty(string8, xMLFormatter);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setFormatter:(Ljava/util/logging/Formatter;)V");
        this.setFormatter(formatter);
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder22 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder23 = stringBuilder22.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder24 = stringBuilder23.append(".encoding");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string9 = stringBuilder24.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getStringProperty:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
            String string10 = logManager.getStringProperty(string9, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setEncoding:(Ljava/lang/String;)V");
            this.setEncoding(string10);
        }
        catch (Exception exception) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setEncoding:(Ljava/lang/String;)V");
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    public FileHandler() throws IOException, SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.configure:()V");
        this.configure();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.openFiles:()V");
        this.openFiles();
    }

    public FileHandler(String string) throws IOException, SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.configure:()V");
        this.configure();
        this.pattern = string;
        this.limit = 0;
        this.count = 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.openFiles:()V");
        this.openFiles();
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.configure:()V");
        this.configure();
        this.pattern = string;
        this.limit = 0;
        this.count = 1;
        this.append = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.openFiles:()V");
        this.openFiles();
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.<init>:()V");
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n2 < 1) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n3 >= 1) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.configure:()V");
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.openFiles:()V");
        this.openFiles();
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.<init>:()V");
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n2 < 1) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n3 >= 1) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.configure:()V");
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.openFiles:()V");
        this.openFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFiles() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
        logManager.checkPermission();
        RuntimeCostAccounter.recordJump();
        if (this.count < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("file count = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.count);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.limit < 0) {
            this.limit = 0;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/FileHandler$InitializationErrorManager");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler$InitializationErrorManager.<init>:(Ljava/util/logging/FileHandler$1;)V");
        InitializationErrorManager initializationErrorManager = new InitializationErrorManager(null);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setErrorManager:(Ljava/util/logging/ErrorManager;)V");
        this.setErrorManager(initializationErrorManager);
        int n = -1;
        while (true) {
            block23: {
                boolean bl;
                block21: {
                    RuntimeCostAccounter.recordJump();
                    if (++n > 100) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Couldn't get lock for ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(this.pattern);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder5.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.generate:(Ljava/lang/String;II)Ljava/io/File;");
                    File file = this.generate(this.pattern, 0, n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.toString:()Ljava/lang/String;");
                    String string = file.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(".lck");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    this.lockFileName = stringBuilder7.toString();
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        String string2 = locks.get(this.lockFileName);
                        RuntimeCostAccounter.recordJump();
                        if (string2 == null) break block21;
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                try {
                    RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
                    String[] stringArray = new String[]{};
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/Paths.get:(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;");
                    Path path = Paths.get((String)this.lockFileName, (String[])stringArray);
                    RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
                    OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.open:(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/nio/channels/FileChannel;");
                    this.lockFileChannel = FileChannel.open((Path)path, (OpenOption[])openOptionArray);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                try {
                    boolean bl2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.tryLock:()Ljava/nio/channels/FileLock;");
                    FileLock fileLock = this.lockFileChannel.tryLock();
                    RuntimeCostAccounter.recordJump();
                    if (fileLock != null) {
                        bl2 = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                }
                catch (IOException iOException) {
                    bl = true;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
                if (!bl) break block23;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                locks.put(this.lockFileName, this.lockFileName);
                break;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.close:()V");
            this.lockFileChannel.close();
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        int n2 = this.count;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.files = new File[n2];
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= this.count) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.generate:(Ljava/lang/String;II)Ljava/io/File;");
            this.files[n3] = this.generate(this.pattern, n3, n);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.append) {
            File file = this.files[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.open:(Ljava/io/File;Z)V");
            this.open(file, true);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.rotate:()V");
            this.rotate();
        }
        Exception exception = initializationErrorManager.lastException;
        RuntimeCostAccounter.recordJump();
        if (exception != null) {
            boolean bl = exception instanceof IOException;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                IOException iOException = (IOException)exception;
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            boolean bl3 = exception instanceof SecurityException;
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                SecurityException securityException = (SecurityException)exception;
                RuntimeCostAccounter.recordThrow();
                throw securityException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder.append("Exception: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(exception);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder9.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException(string);
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/ErrorManager");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/ErrorManager.<init>:()V");
        ErrorManager errorManager = new ErrorManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setErrorManager:(Ljava/util/logging/ErrorManager;)V");
        this.setErrorManager(errorManager);
    }

    private File generate(String string, int n, int n2) throws IOException {
        File file = null;
        String string2 = "";
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n4 = string.length();
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = string.charAt(n3);
            char c2 = '\u0000';
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n5 = string.length();
            RuntimeCostAccounter.recordJump();
            if (++n3 < n5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c3 = string.charAt(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                c2 = Character.toLowerCase(c3);
            }
            RuntimeCostAccounter.recordJump();
            if (c == '/') {
                RuntimeCostAccounter.recordJump();
                if (file == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                    file = new File(string2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                    file = new File(file, string2);
                }
                string2 = "";
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (c == '%') {
                RuntimeCostAccounter.recordJump();
                if (c2 == 't') {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                    String string3 = System.getProperty("java.io.tmpdir");
                    RuntimeCostAccounter.recordJump();
                    if (string3 == null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        string3 = System.getProperty("user.home");
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                    file = new File(string3);
                    ++n3;
                    string2 = "";
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordJump();
                if (c2 == 'h') {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                    String string4 = System.getProperty("user.home");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                    file = new File(string4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.isSetUID:()Z");
                    boolean bl3 = FileHandler.isSetUID();
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("can't use %h in set UID program");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                    ++n3;
                    string2 = "";
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordJump();
                if (c2 == 'g') {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    string2 = stringBuilder3.toString();
                    bl = true;
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordJump();
                if (c2 == 'u') {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    string2 = stringBuilder5.toString();
                    bl2 = true;
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordJump();
                if (c2 == '%') {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append("%");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    string2 = stringBuilder7.toString();
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(c);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string2 = stringBuilder9.toString();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.count > 1) {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder10 = stringBuilder.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder11 = stringBuilder10.append(".");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder12 = stringBuilder11.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string2 = stringBuilder12.toString();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder13 = stringBuilder.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder14 = stringBuilder13.append(".");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder15 = stringBuilder14.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string2 = stringBuilder15.toString();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n6 = string2.length();
        RuntimeCostAccounter.recordJump();
        if (n6 > 0) {
            RuntimeCostAccounter.recordJump();
            if (file == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                file = new File(string2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                file = new File(file, string2);
            }
        }
        return file;
    }

    private synchronized void rotate() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.getLevel:()Ljava/util/logging/Level;");
        Level level = this.getLevel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(Level.OFF);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.close:()V");
        super.close();
        int n = this.count - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            File file = this.files[n];
            File file2 = this.files[n + 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
            boolean bl = file.exists();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                boolean bl2 = file2.exists();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
                    file2.delete();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.renameTo:(Ljava/io/File;)Z");
                file.renameTo(file2);
            }
            --n;
            RuntimeCostAccounter.recordJump();
        }
        try {
            File file = this.files[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.open:(Ljava/io/File;Z)V");
            this.open(file, false);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.reportError:(Ljava/lang/String;Ljava/lang/Exception;I)V");
            this.reportError(null, iOException, 4);
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(level);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        boolean bl = this.isLoggable(logRecord);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.publish:(Ljava/util/logging/LogRecord;)V");
        super.publish(logRecord);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.flush:()V");
        this.flush();
        RuntimeCostAccounter.recordJump();
        if (this.limit > 0) {
            int n = this.meter.written;
            RuntimeCostAccounter.recordJump();
            if (n >= this.limit) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/FileHandler$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler$1.<init>:(Ljava/util/logging/FileHandler;)V");
                PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    public Object run() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.access$100:(Ljava/util/logging/FileHandler;)V");
                        FileHandler.access$100(FileHandler.this);
                        return null;
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
                AccessController.doPrivileged((PrivilegedAction)privilegedAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/StreamHandler.close:()V");
        super.close();
        RuntimeCostAccounter.recordJump();
        if (this.lockFileName == null) {
            return;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.close:()V");
            this.lockFileChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
        HashMap<String, String> hashMap = locks;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            locks.remove(this.lockFileName);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(this.lockFileName);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
        file.delete();
        this.lockFileName = null;
        this.lockFileChannel = null;
    }

    private static native boolean isSetUID();

    static /* synthetic */ void access$100(FileHandler fileHandler) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler.rotate:()V");
        fileHandler.rotate();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        locks = new HashMap();
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/ErrorManager.<init>:()V");
        }

        @Override
        public void error(String string, Exception exception, int n) {
            this.lastException = exception;
        }

        /* synthetic */ InitializationErrorManager(1 var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/FileHandler$InitializationErrorManager.<init>:()V");
            this();
        }
    }

    private class MeteredStream
    extends OutputStream {
        final OutputStream out;
        int written;

        MeteredStream(OutputStream outputStream, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
            this.out = outputStream;
            this.written = n;
        }

        @Override
        public void write(int n) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
            this.out.write(n);
            ++this.written;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([B)V");
            this.out.write(byArray);
            this.written += byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
            this.out.write(byArray, n, n2);
            this.written += n2;
        }

        @Override
        public void flush() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
            this.out.close();
        }
    }
}

