/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.security.AccessControlContext;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.PrivilegedActionException;
import sandbox.java.security.PrivilegedExceptionAction;
import sandbox.java.util.Collection;
import sandbox.java.util.List;
import sandbox.java.util.concurrent.AbstractExecutorService;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.ExecutionException;
import sandbox.java.util.concurrent.ExecutorService;
import sandbox.java.util.concurrent.ForkJoinPool;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.LinkedBlockingQueue;
import sandbox.java.util.concurrent.ScheduledExecutorService;
import sandbox.java.util.concurrent.ScheduledFuture;
import sandbox.java.util.concurrent.ScheduledThreadPoolExecutor;
import sandbox.java.util.concurrent.SynchronousQueue;
import sandbox.java.util.concurrent.ThreadFactory;
import sandbox.java.util.concurrent.ThreadPoolExecutor;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.sun.security.util.SecurityConstants;

public class Executors {
    public static ExecutorService newFixedThreadPool(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:()V");
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V");
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue);
    }

    public static ExecutorService newWorkStealingPool(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Z)V");
        return new ForkJoinPool(n, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    public static ExecutorService newWorkStealingPool() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinPool");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        int n = runtime.availableProcessors();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.<init>:(ILjava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Z)V");
        return new ForkJoinPool(n, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    public static ExecutorService newFixedThreadPool(int n, ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:()V");
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V");
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue, threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$FinalizableDelegatedExecutorService");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:()V");
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$FinalizableDelegatedExecutorService.<init>:(Ljava/util/concurrent/ExecutorService;)V");
        return new FinalizableDelegatedExecutorService(threadPoolExecutor);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$FinalizableDelegatedExecutorService");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:()V");
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue, threadFactory);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$FinalizableDelegatedExecutorService.<init>:(Ljava/util/concurrent/ExecutorService;)V");
        return new FinalizableDelegatedExecutorService(threadPoolExecutor);
    }

    public static ExecutorService newCachedThreadPool() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue.<init>:()V");
        SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V");
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, synchronousQueue);
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadPoolExecutor");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue.<init>:()V");
        SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V");
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, synchronousQueue, threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.<init>:(I)V");
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService.<init>:(Ljava/util/concurrent/ScheduledExecutorService;)V");
        return new DelegatedScheduledExecutorService(scheduledThreadPoolExecutor);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.<init>:(ILjava/util/concurrent/ThreadFactory;)V");
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService.<init>:(Ljava/util/concurrent/ScheduledExecutorService;)V");
        return new DelegatedScheduledExecutorService(scheduledThreadPoolExecutor);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.<init>:(I)V");
        return new ScheduledThreadPoolExecutor(n);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n, ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.<init>:(ILjava/util/concurrent/ThreadFactory;)V");
        return new ScheduledThreadPoolExecutor(n, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executorService) {
        RuntimeCostAccounter.recordJump();
        if (executorService == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$DelegatedExecutorService");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedExecutorService.<init>:(Ljava/util/concurrent/ExecutorService;)V");
        return new DelegatedExecutorService(executorService);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        RuntimeCostAccounter.recordJump();
        if (scheduledExecutorService == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedScheduledExecutorService.<init>:(Ljava/util/concurrent/ScheduledExecutorService;)V");
        return new DelegatedScheduledExecutorService(scheduledExecutorService);
    }

    public static ThreadFactory defaultThreadFactory() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$DefaultThreadFactory");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DefaultThreadFactory.<init>:()V");
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedThreadFactory");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedThreadFactory.<init>:()V");
        return new PrivilegedThreadFactory();
    }

    public static <T> Callable<T> callable(Runnable runnable, T t) {
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$RunnableAdapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$RunnableAdapter.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
        return new RunnableAdapter<T>(runnable, t);
    }

    public static Callable<Object> callable(Runnable runnable) {
        RuntimeCostAccounter.recordJump();
        if (runnable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$RunnableAdapter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$RunnableAdapter.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
        return new RunnableAdapter<Object>(runnable, null);
    }

    public static Callable<Object> callable(final PrivilegedAction<?> privilegedAction) {
        RuntimeCostAccounter.recordJump();
        if (privilegedAction == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$1.<init>:(Ljava/security/PrivilegedAction;)V");
        return new Callable<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public Object call() {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedAction.run:()Ljava/lang/Object;");
                return privilegedAction.run();
            }
        };
    }

    public static Callable<Object> callable(final PrivilegedExceptionAction<?> privilegedExceptionAction) {
        RuntimeCostAccounter.recordJump();
        if (privilegedExceptionAction == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$2.<init>:(Ljava/security/PrivilegedExceptionAction;)V");
        return new Callable<Object>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public Object call() throws Exception {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedExceptionAction.run:()Ljava/lang/Object;");
                return privilegedExceptionAction.run();
            }
        };
    }

    public static <T> Callable<T> privilegedCallable(Callable<T> callable) {
        RuntimeCostAccounter.recordJump();
        if (callable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedCallable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallable.<init>:(Ljava/util/concurrent/Callable;)V");
        return new PrivilegedCallable<T>(callable);
    }

    public static <T> Callable<T> privilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
        RuntimeCostAccounter.recordJump();
        if (callable == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader.<init>:(Ljava/util/concurrent/Callable;)V");
        return new PrivilegedCallableUsingCurrentClassLoader<T>(callable);
    }

    private Executors() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedExecutorService.<init>:(Ljava/util/concurrent/ExecutorService;)V");
            super(scheduledExecutorService);
            this.e = scheduledExecutorService;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledExecutorService.schedule:(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
            return this.e.schedule(runnable, l, timeUnit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledExecutorService.schedule:(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
            return this.e.schedule(callable, l, timeUnit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledExecutorService.scheduleAtFixedRate:(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
            return this.e.scheduleAtFixedRate(runnable, l, l2, timeUnit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledExecutorService.scheduleWithFixedDelay:(Ljava/lang/Runnable;JJLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
            return this.e.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
        }
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executorService) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedExecutorService.<init>:(Ljava/util/concurrent/ExecutorService;)V");
            super(executorService);
        }

        protected void finalize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DelegatedExecutorService.shutdown:()V");
            super.shutdown();
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executorService) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/AbstractExecutorService.<init>:()V");
            this.e = executorService;
        }

        @Override
        public void execute(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.execute:(Ljava/lang/Runnable;)V");
            this.e.execute(runnable);
        }

        @Override
        public void shutdown() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.shutdown:()V");
            this.e.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.shutdownNow:()Ljava/util/List;");
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.isShutdown:()Z");
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.isTerminated:()Z");
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.awaitTermination:(JLjava/util/concurrent/TimeUnit;)Z");
            return this.e.awaitTermination(l, timeUnit);
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.submit:(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;");
            return this.e.submit(runnable);
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.submit:(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;");
            return this.e.submit(callable);
        }

        @Override
        public <T> Future<T> submit(Runnable runnable, T t) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.submit:(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;");
            return this.e.submit(runnable, t);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.invokeAll:(Ljava/util/Collection;)Ljava/util/List;");
            return this.e.invokeAll(collection);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.invokeAll:(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/util/List;");
            return this.e.invokeAll(collection, l, timeUnit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.invokeAny:(Ljava/util/Collection;)Ljava/lang/Object;");
            return this.e.invokeAny(collection);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutorService.invokeAny:(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;");
            return this.e.invokeAny(collection, l, timeUnit);
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final AccessControlContext acc;
        private final ClassLoader ccl;

        PrivilegedThreadFactory() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DefaultThreadFactory.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)SecurityConstants.GET_CLASSLOADER_PERMISSION);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
                RuntimePermission runtimePermission = new RuntimePermission("setContextClassLoader");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)runtimePermission);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.getContext:()Ljava/security/AccessControlContext;");
            this.acc = AccessController.getContext();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
            this.ccl = thread.getContextClassLoader();
        }

        @Override
        public Thread newThread(final Runnable runnable) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedThreadFactory$1");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedThreadFactory$1.<init>:(Ljava/util/concurrent/Executors$PrivilegedThreadFactory;Ljava/lang/Runnable;)V");
            Runnable runnable2 = new Runnable(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                @Override
                public void run() {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedThreadFactory$1$1");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedThreadFactory$1$1.<init>:(Ljava/util/concurrent/Executors$PrivilegedThreadFactory$1;)V");
                    PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
                        {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                        }

                        public Void run() {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                            Thread thread = Thread.currentThread();
                            PrivilegedThreadFactory privilegedThreadFactory = this;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedThreadFactory.access$300:(Ljava/util/concurrent/Executors$PrivilegedThreadFactory;)Ljava/lang/ClassLoader;");
                            ClassLoader classLoader = privilegedThreadFactory.ccl;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setContextClassLoader:(Ljava/lang/ClassLoader;)V");
                            thread.setContextClassLoader(classLoader);
                            Runnable runnable = runnable;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
                            runnable.run();
                            return null;
                        }
                    };
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedThreadFactory.access$400:(Ljava/util/concurrent/Executors$PrivilegedThreadFactory;)Ljava/security/AccessControlContext;");
                    AccessControlContext accessControlContext = acc;
                    RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
                    AccessController.doPrivileged((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$DefaultThreadFactory.newThread:(Ljava/lang/Runnable;)Ljava/lang/Thread;");
            return super.newThread(runnable2);
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber;
        private final ThreadGroup group;
        private final AtomicInteger threadNumber;
        private final String namePrefix;

        DefaultThreadFactory() {
            ThreadGroup threadGroup;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:(I)V");
            this.threadNumber = new AtomicInteger(1);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.getThreadGroup:()Ljava/lang/ThreadGroup;");
                threadGroup = securityManager.getThreadGroup();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getThreadGroup:()Ljava/lang/ThreadGroup;");
                threadGroup = thread.getThreadGroup();
            }
            this.group = threadGroup;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("pool-");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
            int n = poolNumber.getAndIncrement();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("-thread-");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            this.namePrefix = stringBuilder4.toString();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Thread");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(this.namePrefix);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
            int n = this.threadNumber.getAndIncrement();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.<init>:(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;J)V");
            Thread thread = new Thread(this.group, runnable, string, 0L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isDaemon:()Z");
            boolean bl = thread.isDaemon();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setDaemon:(Z)V");
                thread.setDaemon(false);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getPriority:()I");
            int n2 = thread.getPriority();
            RuntimeCostAccounter.recordJump();
            if (n2 != 5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setPriority:(I)V");
                thread.setPriority(5);
            }
            return thread;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:(I)V");
            poolNumber = new AtomicInteger(1);
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final AccessControlContext acc;
        private final ClassLoader ccl;

        PrivilegedCallableUsingCurrentClassLoader(Callable<T> callable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)SecurityConstants.GET_CLASSLOADER_PERMISSION);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
                RuntimePermission runtimePermission = new RuntimePermission("setContextClassLoader");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)runtimePermission);
            }
            this.task = callable;
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.getContext:()Ljava/security/AccessControlContext;");
            this.acc = AccessController.getContext();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
            this.ccl = thread.getContextClassLoader();
        }

        @Override
        public T call() throws Exception {
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader$1.<init>:(Ljava/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader;)V");
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction<T>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T run() throws Exception {
                        Object v;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        Thread thread = Thread.currentThread();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getContextClassLoader:()Ljava/lang/ClassLoader;");
                        ClassLoader classLoader = thread.getContextClassLoader();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader.access$100:(Ljava/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader;)Ljava/lang/ClassLoader;");
                        ClassLoader classLoader2 = ccl;
                        RuntimeCostAccounter.recordJump();
                        if (classLoader2 == classLoader) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader.access$200:(Ljava/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader;)Ljava/util/concurrent/Callable;");
                            Callable callable = task;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                            return callable.call();
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader.access$100:(Ljava/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader;)Ljava/lang/ClassLoader;");
                        ClassLoader classLoader3 = ccl;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setContextClassLoader:(Ljava/lang/ClassLoader;)V");
                        thread.setContextClassLoader(classLoader3);
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader.access$200:(Ljava/util/concurrent/Executors$PrivilegedCallableUsingCurrentClassLoader;)Ljava/util/concurrent/Callable;");
                            Callable callable = task;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                            v = callable.call();
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setContextClassLoader:(Ljava/lang/ClassLoader;)V");
                            thread.setContextClassLoader(classLoader);
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.setContextClassLoader:(Ljava/lang/ClassLoader;)V");
                        thread.setContextClassLoader(classLoader);
                        return v;
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
                return (T)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction, (AccessControlContext)this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
                Exception exception = privilegedActionException.getException();
                RuntimeCostAccounter.recordThrow();
                throw exception;
            }
        }
    }

    static final class PrivilegedCallable<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final AccessControlContext acc;

        PrivilegedCallable(Callable<T> callable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.task = callable;
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.getContext:()Ljava/security/AccessControlContext;");
            this.acc = AccessController.getContext();
        }

        @Override
        public T call() throws Exception {
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/Executors$PrivilegedCallable$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallable$1.<init>:(Ljava/util/concurrent/Executors$PrivilegedCallable;)V");
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction<T>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    public T run() throws Exception {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors$PrivilegedCallable.access$000:(Ljava/util/concurrent/Executors$PrivilegedCallable;)Ljava/util/concurrent/Callable;");
                        Callable callable = task;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                        return callable.call();
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;Ljava/security/AccessControlContext;)Ljava/lang/Object;");
                return (T)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction, (AccessControlContext)this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
                Exception exception = privilegedActionException.getException();
                RuntimeCostAccounter.recordThrow();
                throw exception;
            }
        }
    }

    static final class RunnableAdapter<T>
    implements Callable<T> {
        final Runnable task;
        final T result;

        RunnableAdapter(Runnable runnable, T t) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.task = runnable;
            this.result = t;
        }

        @Override
        public T call() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
            this.task.run();
            return this.result;
        }
    }
}

