/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.Stack;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public final class SuspendableHelper {
    static boolean javaAgent;
    static final Set<Pair<String, String>> waivers;

    public static boolean isJavaAgentActive() {
        return javaAgent;
    }

    public static boolean isInstrumented(Class clazz) {
        return clazz != null && clazz.isAnnotationPresent(Instrumented.class);
    }

    public static Member lookupMethod(ExtendedStackTraceElement ste) {
        if (ste.getDeclaringClass() == null) {
            return null;
        }
        if (ste.getMethod() != null) {
            return ste.getMethod();
        }
        for (Method m : ste.getDeclaringClass().getDeclaredMethods()) {
            if (!m.getName().equals(ste.getMethodName())) continue;
            Instrumented i = SuspendableHelper.getAnnotation(m, Instrumented.class);
            if (!m.isSynthetic() && !SuspendableHelper.isWaiver(m.getDeclaringClass().getName(), m.getName()) && (i == null || ste.getLineNumber() < i.methodStart() || ste.getLineNumber() > i.methodEnd())) continue;
            return m;
        }
        return null;
    }

    public static Pair<Boolean, int[]> isCallSiteInstrumented(Member m, int sourceLine, ExtendedStackTraceElement[] stes, int currentSteIdx) {
        if (m == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        if (SuspendableHelper.isSyntheticAndNotLambda(m)) {
            return new Pair<Boolean, Object>(true, null);
        }
        ExtendedStackTraceElement ste = stes[currentSteIdx];
        if (currentSteIdx - 1 >= 0 && (stes[currentSteIdx - 1].getClassName().equals(Fiber.class.getName()) && stes[currentSteIdx - 1].getMethodName().equals("verifySuspend") || stes[currentSteIdx - 1].getClassName().equals(Stack.class.getName()) && stes[currentSteIdx - 1].getMethodName().equals("popMethod"))) {
            return new Pair<Boolean, Object>(true, null);
        }
        Instrumented i = SuspendableHelper.getAnnotation(m, Instrumented.class);
        if (i != null) {
            int[] scs;
            for (int j : scs = i.suspendableCallSites()) {
                if (j != sourceLine) continue;
                return new Pair<Boolean, int[]>(true, scs);
            }
            return new Pair<Boolean, int[]>(false, scs);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    public static boolean isInstrumented(Member m) {
        return m != null && (SuspendableHelper.isSyntheticAndNotLambda(m) || SuspendableHelper.getAnnotation(m, Instrumented.class) != null);
    }

    public static boolean isSyntheticAndNotLambda(Member m) {
        return m.isSynthetic() && !m.getName().startsWith("lambda$");
    }

    public static boolean isOptimized(Member m) {
        if (m == null) {
            return false;
        }
        Instrumented i = SuspendableHelper.getAnnotation(m, Instrumented.class);
        return i != null && i.methodOptimized();
    }

    private static <T extends Annotation> T getAnnotation(Member m, Class<T> annotationClass) {
        if (m == null || annotationClass == null) {
            return null;
        }
        if (m instanceof Constructor) {
            return ((Constructor)m).getAnnotation(annotationClass);
        }
        return ((Method)m).getAnnotation(annotationClass);
    }

    public static void addWaiver(String className, String methodName) {
        waivers.add(new Pair<String, String>(className, methodName));
    }

    public static boolean isWaiver(String className, String methodName) {
        if (className.startsWith("java.lang.reflect") || className.startsWith("sun.reflect") || className.startsWith("com.sun.proxy") || className.contains("$ByteBuddy$") || className.equals("co.paralleluniverse.strands.SuspendableUtils$VoidSuspendableCallable") && methodName.equals("run") || className.equals("co.paralleluniverse.strands.dataflow.Var") && methodName.equals("set")) {
            return true;
        }
        return waivers.contains(new Pair<String, String>(className, methodName));
    }

    private SuspendableHelper() {
    }

    static {
        waivers = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    }
}

