"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var modal_options_class_1 = require('./modal-options.class');
var ModalBackdropOptions = (function () {
    function ModalBackdropOptions(options) {
        this.animate = true;
        Object.assign(this, options);
    }
    return ModalBackdropOptions;
}());
exports.ModalBackdropOptions = ModalBackdropOptions;
var ModalBackdropComponent = (function () {
    function ModalBackdropComponent(options, element, renderer) {
        this._isShown = false;
        this.element = element;
        this.renderer = renderer;
        this.isAnimated = options.animate !== false;
    }
    Object.defineProperty(ModalBackdropComponent.prototype, "isAnimated", {
        get: function () {
            return this._isAnimated;
        },
        set: function (value) {
            this._isAnimated = value;
            this.renderer.setElementClass(this.element.nativeElement, "" + modal_options_class_1.ClassName.FADE, value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ModalBackdropComponent.prototype, "isShown", {
        get: function () {
            return this._isShown;
        },
        set: function (value) {
            this._isShown = value;
            this.renderer.setElementClass(this.element.nativeElement, "" + modal_options_class_1.ClassName.IN, value);
        },
        enumerable: true,
        configurable: true
    });
    ModalBackdropComponent = __decorate([
        core_1.Component({
            selector: 'bs-modal-backdrop',
            template: '',
            host: { 'class': "" + modal_options_class_1.ClassName.BACKDROP }
        }), 
        __metadata('design:paramtypes', [ModalBackdropOptions, core_1.ElementRef, core_1.Renderer])
    ], ModalBackdropComponent);
    return ModalBackdropComponent;
}());
exports.ModalBackdropComponent = ModalBackdropComponent;
