/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.nio.file.attribute.FileTime;
import sandbox.java.util.Date;
import sandbox.java.util.concurrent.TimeUnit;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;

    ZipUtils() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static final FileTime winTimeToFileTime(long l) {
        long l2 = l / 10L + -11644473600000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.from:(JLjava/util/concurrent/TimeUnit;)Ljava/nio/file/attribute/FileTime;");
        return FileTime.from((long)l2, (TimeUnit)TimeUnit.MICROSECONDS);
    }

    public static final long fileTimeToWinTime(FileTime fileTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.to:(Ljava/util/concurrent/TimeUnit;)J");
        return (fileTime.to(TimeUnit.MICROSECONDS) - -11644473600000000L) * 10L;
    }

    public static final FileTime unixTimeToFileTime(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.from:(JLjava/util/concurrent/TimeUnit;)Ljava/nio/file/attribute/FileTime;");
        return FileTime.from((long)l, (TimeUnit)TimeUnit.SECONDS);
    }

    public static final long fileTimeToUnixTime(FileTime fileTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/attribute/FileTime.to:(Ljava/util/concurrent/TimeUnit;)J");
        return fileTime.to(TimeUnit.SECONDS);
    }

    public static long dosToJavaTime(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Date");
        int n = (int)((l >> 25 & 0x7FL) + 80L);
        int n2 = (int)((l >> 21 & 0xFL) - 1L);
        int n3 = (int)(l >> 16 & 0x1FL);
        int n4 = (int)(l >> 11 & 0x1FL);
        int n5 = (int)(l >> 5 & 0x3FL);
        int n6 = (int)(l << 1 & 0x3EL);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.<init>:(IIIIII)V");
        Date date = new Date(n, n2, n3, n4, n5, n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getTime:()J");
        return date.getTime();
    }

    public static long javaToDosTime(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Date");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.<init>:(J)V");
        Date date = new Date(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getYear:()I");
        int n = date.getYear() + 1900;
        RuntimeCostAccounter.recordJump();
        if (n < 1980) {
            return 0x210000L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getMonth:()I");
        int n2 = n - 1980 << 25 | date.getMonth() + 1 << 21;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getDate:()I");
        int n3 = n2 | date.getDate() << 16;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getHours:()I");
        int n4 = n3 | date.getHours() << 11;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getMinutes:()I");
        int n5 = n4 | date.getMinutes() << 5;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getSeconds:()I");
        return n5 | date.getSeconds() >> 1;
    }

    public static final int get16(byte[] byArray, int n) {
        byte by = byArray[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
        int n2 = Byte.toUnsignedInt(by);
        byte by2 = byArray[n + 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
        return n2 | Byte.toUnsignedInt(by2) << 8;
    }

    public static final long get32(byte[] byArray, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
        long l = ZipUtils.get16(byArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get16:([BI)I");
        return (l | (long)ZipUtils.get16(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    public static final long get64(byte[] byArray, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
        long l = ZipUtils.get32(byArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipUtils.get32:([BI)J");
        return l | ZipUtils.get32(byArray, n + 4) << 32;
    }
}

