/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.Delayed;
import sandbox.java.util.concurrent.Executors;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.FutureTask;
import sandbox.java.util.concurrent.RejectedExecutionHandler;
import sandbox.java.util.concurrent.RunnableScheduledFuture;
import sandbox.java.util.concurrent.ScheduledExecutorService;
import sandbox.java.util.concurrent.ScheduledFuture;
import sandbox.java.util.concurrent.ThreadFactory;
import sandbox.java.util.concurrent.ThreadPoolExecutor;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown;
    private volatile boolean removeOnCancel;
    private static final AtomicLong sequencer;

    final long now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        return System.nanoTime();
    }

    boolean canRunInCurrentRunState(boolean bl) {
        boolean bl2;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            bl2 = this.continueExistingPeriodicTasksAfterShutdown;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = this.executeExistingDelayedTasksAfterShutdown;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.isRunningOrShutdown:(Z)Z");
        return this.isRunningOrShutdown(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void delayedExecute(RunnableScheduledFuture<?> runnableScheduledFuture) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.isShutdown:()Z");
        boolean bl = this.isShutdown();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.reject:(Ljava/lang/Runnable;)V");
            this.reject(runnableScheduledFuture);
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
        BlockingQueue<Runnable> blockingQueue = super.getQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.add:(Ljava/lang/Object;)Z");
        blockingQueue.add(runnableScheduledFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.isShutdown:()Z");
        boolean bl2 = this.isShutdown();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.isPeriodic:()Z");
            boolean bl3 = runnableScheduledFuture.isPeriodic();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.canRunInCurrentRunState:(Z)Z");
            boolean bl4 = this.canRunInCurrentRunState(bl3);
            RuntimeCostAccounter.recordJump();
            if (!bl4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.remove:(Ljava/lang/Runnable;)Z");
                boolean bl5 = this.remove(runnableScheduledFuture);
                RuntimeCostAccounter.recordJump();
                if (bl5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.cancel:(Z)Z");
                    runnableScheduledFuture.cancel(false);
                    RuntimeCostAccounter.recordJump();
                    return;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.ensurePrestart:()V");
        this.ensurePrestart();
    }

    /*
     * Enabled aggressive block sorting
     */
    void reExecutePeriodic(RunnableScheduledFuture<?> runnableScheduledFuture) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.canRunInCurrentRunState:(Z)Z");
        boolean bl = this.canRunInCurrentRunState(true);
        RuntimeCostAccounter.recordJump();
        if (!bl) return;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
        BlockingQueue<Runnable> blockingQueue = super.getQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.add:(Ljava/lang/Object;)Z");
        blockingQueue.add(runnableScheduledFuture);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.canRunInCurrentRunState:(Z)Z");
        boolean bl2 = this.canRunInCurrentRunState(true);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.remove:(Ljava/lang/Runnable;)Z");
            boolean bl3 = this.remove(runnableScheduledFuture);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.cancel:(Z)Z");
                runnableScheduledFuture.cancel(false);
                RuntimeCostAccounter.recordJump();
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.ensurePrestart:()V");
        this.ensurePrestart();
    }

    @Override
    void onShutdown() {
        block8: {
            boolean bl;
            boolean bl2;
            BlockingQueue<Runnable> blockingQueue;
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
                blockingQueue = super.getQueue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.getExecuteExistingDelayedTasksAfterShutdownPolicy:()Z");
                bl2 = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.getContinueExistingPeriodicTasksAfterShutdownPolicy:()Z");
                bl = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
                RuntimeCostAccounter.recordJump();
                if (bl2) break block7;
                RuntimeCostAccounter.recordJump();
                if (bl) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.toArray:()[Ljava/lang/Object;");
                Object[] objectArray = blockingQueue.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    Object object = objectArray[n2];
                    boolean bl3 = object instanceof RunnableScheduledFuture;
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RunnableScheduledFuture runnableScheduledFuture = (RunnableScheduledFuture)object;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.cancel:(Z)Z");
                        runnableScheduledFuture.cancel(false);
                    }
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.clear:()V");
                blockingQueue.clear();
                RuntimeCostAccounter.recordJump();
                break block8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.toArray:()[Ljava/lang/Object;");
            Object[] objectArray = blockingQueue.toArray();
            int n = objectArray.length;
            int n3 = 0;
            while (true) {
                block9: {
                    RunnableScheduledFuture runnableScheduledFuture;
                    block12: {
                        block11: {
                            block10: {
                                RuntimeCostAccounter.recordJump();
                                if (n3 >= n) break;
                                Object object = objectArray[n3];
                                boolean bl4 = object instanceof RunnableScheduledFuture;
                                RuntimeCostAccounter.recordJump();
                                if (!bl4) break block9;
                                runnableScheduledFuture = (RunnableScheduledFuture)object;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.isPeriodic:()Z");
                                boolean bl5 = runnableScheduledFuture.isPeriodic();
                                RuntimeCostAccounter.recordJump();
                                if (!bl5) break block10;
                                RuntimeCostAccounter.recordJump();
                                if (bl) break block11;
                                RuntimeCostAccounter.recordJump();
                                break block12;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break block12;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.isCancelled:()Z");
                        boolean bl6 = runnableScheduledFuture.isCancelled();
                        RuntimeCostAccounter.recordJump();
                        if (!bl6) break block9;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.remove:(Ljava/lang/Object;)Z");
                    boolean bl7 = blockingQueue.remove(runnableScheduledFuture);
                    RuntimeCostAccounter.recordJump();
                    if (bl7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.cancel:(Z)Z");
                        runnableScheduledFuture.cancel(false);
                    }
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.tryTerminate:()V");
        this.tryTerminate();
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        return runnableScheduledFuture;
    }

    public ScheduledThreadPoolExecutor(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.<init>:()V");
        DelayedWorkQueue delayedWorkQueue = new DelayedWorkQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;)V");
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, delayedWorkQueue);
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.removeOnCancel = false;
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.<init>:()V");
        DelayedWorkQueue delayedWorkQueue = new DelayedWorkQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;)V");
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)delayedWorkQueue, threadFactory);
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.removeOnCancel = false;
    }

    public ScheduledThreadPoolExecutor(int n, RejectedExecutionHandler rejectedExecutionHandler) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.<init>:()V");
        DelayedWorkQueue delayedWorkQueue = new DelayedWorkQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/RejectedExecutionHandler;)V");
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)delayedWorkQueue, rejectedExecutionHandler);
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.removeOnCancel = false;
    }

    public ScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.<init>:()V");
        DelayedWorkQueue delayedWorkQueue = new DelayedWorkQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.<init>:(IIJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/BlockingQueue;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/RejectedExecutionHandler;)V");
        super(n, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, delayedWorkQueue, threadFactory, rejectedExecutionHandler);
        this.executeExistingDelayedTasksAfterShutdown = true;
        this.removeOnCancel = false;
    }

    private long triggerTime(long l, TimeUnit timeUnit) {
        long l2;
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            l2 = 0L;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = l;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l3 = timeUnit.toNanos(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(J)J");
        return this.triggerTime(l3);
    }

    long triggerTime(long l) {
        long l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.now:()J");
        long l3 = this.now();
        RuntimeCostAccounter.recordJump();
        if (l < 0x3FFFFFFFFFFFFFFFL) {
            l2 = l;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.overflowFree:(J)J");
            l2 = this.overflowFree(l);
        }
        return l3 + l2;
    }

    private long overflowFree(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
        BlockingQueue<Runnable> blockingQueue = super.getQueue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/BlockingQueue.peek:()Ljava/lang/Object;");
        Delayed delayed = (Delayed)blockingQueue.peek();
        RuntimeCostAccounter.recordJump();
        if (delayed != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
            long l2 = delayed.getDelay(TimeUnit.NANOSECONDS);
            RuntimeCostAccounter.recordJump();
            if (l2 < 0L) {
                RuntimeCostAccounter.recordJump();
                if (l - l2 < 0L) {
                    l = Long.MAX_VALUE + l2;
                }
            }
        }
        return l;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (runnable == null) break block2;
                RuntimeCostAccounter.recordJump();
                if (timeUnit != null) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(JLjava/util/concurrent/TimeUnit;)J");
        long l2 = this.triggerTime(l, timeUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.<init>:(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Ljava/lang/Runnable;Ljava/lang/Object;J)V");
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.decorateTask:(Ljava/lang/Runnable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, scheduledFutureTask);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.delayedExecute:(Ljava/util/concurrent/RunnableScheduledFuture;)V");
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (callable == null) break block2;
                RuntimeCostAccounter.recordJump();
                if (timeUnit != null) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(JLjava/util/concurrent/TimeUnit;)J");
        long l2 = this.triggerTime(l, timeUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.<init>:(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Ljava/util/concurrent/Callable;J)V");
        ScheduledFutureTask<V> scheduledFutureTask = new ScheduledFutureTask<V>(callable, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.decorateTask:(Ljava/util/concurrent/Callable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
        RunnableScheduledFuture<V> runnableScheduledFuture = this.decorateTask(callable, scheduledFutureTask);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.delayedExecute:(Ljava/util/concurrent/RunnableScheduledFuture;)V");
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (runnable == null) break block4;
                RuntimeCostAccounter.recordJump();
                if (timeUnit != null) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(JLjava/util/concurrent/TimeUnit;)J");
        long l3 = this.triggerTime(l, timeUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l4 = timeUnit.toNanos(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.<init>:(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Ljava/lang/Runnable;Ljava/lang/Object;JJ)V");
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l3, l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.decorateTask:(Ljava/lang/Runnable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, scheduledFutureTask);
        scheduledFutureTask.outerTask = runnableScheduledFuture;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.delayedExecute:(Ljava/util/concurrent/RunnableScheduledFuture;)V");
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (runnable == null) break block4;
                RuntimeCostAccounter.recordJump();
                if (timeUnit != null) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(JLjava/util/concurrent/TimeUnit;)J");
        long l3 = this.triggerTime(l, timeUnit);
        long l4 = -l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l5 = timeUnit.toNanos(l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.<init>:(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Ljava/lang/Runnable;Ljava/lang/Object;JJ)V");
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l3, l5);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.decorateTask:(Ljava/lang/Runnable;Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
        RunnableScheduledFuture<Object> runnableScheduledFuture = this.decorateTask(runnable, scheduledFutureTask);
        scheduledFutureTask.outerTask = runnableScheduledFuture;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.delayedExecute:(Ljava/util/concurrent/RunnableScheduledFuture;)V");
        this.delayedExecute(runnableScheduledFuture);
        return runnableScheduledFuture;
    }

    @Override
    public void execute(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.schedule:(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.schedule:(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Executors.callable:(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Callable;");
        Callable<T> callable = Executors.callable(runnable, t);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.schedule:(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.schedule:(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;");
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl) {
        this.continueExistingPeriodicTasksAfterShutdown = bl;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.isShutdown:()Z");
            boolean bl2 = this.isShutdown();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.onShutdown:()V");
                this.onShutdown();
            }
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl) {
        this.executeExistingDelayedTasksAfterShutdown = bl;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.isShutdown:()Z");
            boolean bl2 = this.isShutdown();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.onShutdown:()V");
                this.onShutdown();
            }
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean bl) {
        this.removeOnCancel = bl;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.shutdown:()V");
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.shutdownNow:()Ljava/util/List;");
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadPoolExecutor.getQueue:()Ljava/util/concurrent/BlockingQueue;");
        return super.getQueue();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:()V");
        sequencer = new AtomicLong();
    }

    static class DelayedWorkQueue
    extends AbstractQueue<Runnable>
    implements BlockingQueue<Runnable> {
        private static final int INITIAL_CAPACITY = 16;
        private RunnableScheduledFuture<?>[] queue;
        private final ReentrantLock lock;
        private int size;
        private Thread leader;
        private final Condition available;

        DelayedWorkQueue() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
            RuntimeCostAccounter.recordArrayAllocation((int)16, (int)8);
            this.queue = new RunnableScheduledFuture[16];
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
            this.lock = new ReentrantLock();
            this.size = 0;
            this.leader = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
            this.available = this.lock.newCondition();
        }

        private void setIndex(RunnableScheduledFuture<?> runnableScheduledFuture, int n) {
            boolean bl = runnableScheduledFuture instanceof ScheduledFutureTask;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ((ScheduledFutureTask)runnableScheduledFuture).heapIndex = n;
            }
        }

        private void siftUp(int n, RunnableScheduledFuture<?> runnableScheduledFuture) {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n <= 0) break;
                int n2 = n - 1 >>> 1;
                RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.compareTo:(Ljava/lang/Object;)I");
                int n3 = runnableScheduledFuture.compareTo(runnableScheduledFuture2);
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                this.queue[n] = runnableScheduledFuture2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
                this.setIndex(runnableScheduledFuture2, n);
                n = n2;
                RuntimeCostAccounter.recordJump();
            }
            this.queue[n] = runnableScheduledFuture;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
            this.setIndex(runnableScheduledFuture, n);
        }

        private void siftDown(int n, RunnableScheduledFuture<?> runnableScheduledFuture) {
            int n2 = this.size >>> 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                int n3 = (n << 1) + 1;
                RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[n3];
                int n4 = n3 + 1;
                RuntimeCostAccounter.recordJump();
                if (n4 < this.size) {
                    RunnableScheduledFuture<?> runnableScheduledFuture3 = this.queue[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.compareTo:(Ljava/lang/Object;)I");
                    int n5 = runnableScheduledFuture2.compareTo(runnableScheduledFuture3);
                    RuntimeCostAccounter.recordJump();
                    if (n5 > 0) {
                        n3 = n4;
                        runnableScheduledFuture2 = this.queue[n3];
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.compareTo:(Ljava/lang/Object;)I");
                int n6 = runnableScheduledFuture.compareTo(runnableScheduledFuture2);
                RuntimeCostAccounter.recordJump();
                if (n6 <= 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                this.queue[n] = runnableScheduledFuture2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
                this.setIndex(runnableScheduledFuture2, n);
                n = n3;
                RuntimeCostAccounter.recordJump();
            }
            this.queue[n] = runnableScheduledFuture;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
            this.setIndex(runnableScheduledFuture, n);
        }

        private void grow() {
            int n = this.queue.length;
            int n2 = n + (n >> 1);
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            this.queue = Arrays.copyOf(this.queue, n2);
        }

        private int indexOf(Object object) {
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                boolean bl = object instanceof ScheduledFutureTask;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    int n = ((ScheduledFutureTask)object).heapIndex;
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) {
                        RuntimeCostAccounter.recordJump();
                        if (n < this.size) {
                            RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[n];
                            RuntimeCostAccounter.recordJump();
                            if (runnableScheduledFuture == object) {
                                return n;
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= this.size) break;
                        RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[n];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                        boolean bl2 = object.equals(runnableScheduledFuture);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            return n;
                        }
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            boolean bl;
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                boolean bl2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.indexOf:(Ljava/lang/Object;)I");
                int n = this.indexOf(object);
                RuntimeCostAccounter.recordJump();
                if (n != -1) {
                    bl2 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            int n;
            ReentrantLock reentrantLock;
            block5: {
                boolean bl;
                reentrantLock = this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.indexOf:(Ljava/lang/Object;)I");
                    n = this.indexOf(object);
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) break block5;
                    bl = false;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return bl;
            }
            RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
            this.setIndex(runnableScheduledFuture, -1);
            int n2 = --this.size;
            RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[n2];
            this.queue[n2] = null;
            RuntimeCostAccounter.recordJump();
            if (n2 != n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.siftDown:(ILjava/util/concurrent/RunnableScheduledFuture;)V");
                this.siftDown(n, runnableScheduledFuture2);
                RunnableScheduledFuture<?> runnableScheduledFuture3 = this.queue[n];
                RuntimeCostAccounter.recordJump();
                if (runnableScheduledFuture3 == runnableScheduledFuture2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.siftUp:(ILjava/util/concurrent/RunnableScheduledFuture;)V");
                    this.siftUp(n, runnableScheduledFuture2);
                }
            }
            boolean bl = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl;
        }

        @Override
        public int size() {
            int n;
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                n = this.size;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return n;
        }

        @Override
        public boolean isEmpty() {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.size:()I");
            int n = this.size();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public RunnableScheduledFuture<?> peek() {
            RunnableScheduledFuture<?> runnableScheduledFuture;
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                runnableScheduledFuture = this.queue[0];
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Runnable runnable) {
            RuntimeCostAccounter.recordJump();
            if (runnable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RunnableScheduledFuture runnableScheduledFuture = (RunnableScheduledFuture)runnable;
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n = this.size;
                int n2 = this.queue.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.grow:()V");
                    this.grow();
                }
                this.size = n + 1;
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    this.queue[0] = runnableScheduledFuture;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
                    this.setIndex(runnableScheduledFuture, 0);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.siftUp:(ILjava/util/concurrent/RunnableScheduledFuture;)V");
                    this.siftUp(n, runnableScheduledFuture);
                }
                RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[0];
                RuntimeCostAccounter.recordJump();
                if (runnableScheduledFuture2 == runnableScheduledFuture) {
                    this.leader = null;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.available.signal();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
            return true;
        }

        @Override
        public void put(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.offer:(Ljava/lang/Runnable;)Z");
            this.offer(runnable);
        }

        @Override
        public boolean add(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.offer:(Ljava/lang/Runnable;)Z");
            return this.offer(runnable);
        }

        @Override
        public boolean offer(Runnable runnable, long l, TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.offer:(Ljava/lang/Runnable;)Z");
            return this.offer(runnable);
        }

        private RunnableScheduledFuture<?> finishPoll(RunnableScheduledFuture<?> runnableScheduledFuture) {
            int n = --this.size;
            RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[n];
            this.queue[n] = null;
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.siftDown:(ILjava/util/concurrent/RunnableScheduledFuture;)V");
                this.siftDown(0, runnableScheduledFuture2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
            this.setIndex(runnableScheduledFuture, -1);
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture<?> poll() {
            RunnableScheduledFuture<?> runnableScheduledFuture;
            ReentrantLock reentrantLock;
            block4: {
                RunnableScheduledFuture<?> runnableScheduledFuture2;
                reentrantLock = this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    runnableScheduledFuture = this.queue[0];
                    RuntimeCostAccounter.recordJump();
                    if (runnableScheduledFuture != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                        long l = runnableScheduledFuture.getDelay(TimeUnit.NANOSECONDS) - 0L;
                        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l2 <= 0) break block4;
                    }
                    runnableScheduledFuture2 = null;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return runnableScheduledFuture2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.finishPoll:(Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
            RunnableScheduledFuture<?> runnableScheduledFuture3 = this.finishPoll(runnableScheduledFuture);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return runnableScheduledFuture3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public RunnableScheduledFuture<?> take() throws InterruptedException {
            var1_1 = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
            var1_1.lockInterruptibly();
            while (true) {
                block15: {
                    var2_2 = this.queue[0];
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 != null) break block15;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                    this.available.await();
                    RuntimeCostAccounter.recordJump();
                    ** GOTO lbl69
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                var3_3 = var2_2.getDelay(TimeUnit.NANOSECONDS);
                RuntimeCostAccounter.recordJump();
                if (var3_3 > 0L) break block14;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.finishPoll:(Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
                var5_4 /* !! */  = this.finishPoll(var2_2);
                break;
            }
            catch (Throwable var7_6) {
                RuntimeCostAccounter.recordJump();
                if (this.leader == null) {
                    v0 = this.queue[0];
                    RuntimeCostAccounter.recordJump();
                    if (v0 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                        this.available.signal();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                var1_1.unlock();
                RuntimeCostAccounter.recordThrow();
                throw var7_6;
            }
            {
                block16: {
                    block14: {
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == null) {
                            v1 = this.queue[0];
                            RuntimeCostAccounter.recordJump();
                            if (v1 != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                this.available.signal();
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                        var1_1.unlock();
                        return var5_4 /* !! */ ;
                    }
                    var2_2 = null;
                    RuntimeCostAccounter.recordJump();
                    if (this.leader != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                        this.available.await();
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        var5_4 /* !! */  = Thread.currentThread();
                        this.leader = var5_4 /* !! */ ;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                        this.available.awaitNanos(var3_3);
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == var5_4 /* !! */ ) {
                            this.leader = null;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    break block16;
                    catch (Throwable var6_5) {
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == var5_4 /* !! */ ) {
                            this.leader = null;
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw var6_5;
                    }
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public RunnableScheduledFuture<?> poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
            var4_3 = var3_2.toNanos(var1_1);
            var6_4 = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
            var6_4.lockInterruptibly();
            while (true) {
                var7_5 = this.queue[0];
                RuntimeCostAccounter.recordJump();
                if (var7_5 != null) ** GOTO lbl42
                RuntimeCostAccounter.recordJump();
                if (var4_3 > 0L) break block20;
                var8_9 = null;
                break;
            }
            catch (Throwable var15_11) {
                RuntimeCostAccounter.recordJump();
                if (this.leader == null) {
                    v0 = this.queue[0];
                    RuntimeCostAccounter.recordJump();
                    if (v0 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                        this.available.signal();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                var6_4.unlock();
                RuntimeCostAccounter.recordThrow();
                throw var15_11;
            }
            {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                RuntimeCostAccounter.recordJump();
                                if (this.leader == null) {
                                    v1 = this.queue[0];
                                    RuntimeCostAccounter.recordJump();
                                    if (v1 != null) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                        this.available.signal();
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                                var6_4.unlock();
                                return var8_9;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                            var4_3 = this.available.awaitNanos(var4_3);
                            RuntimeCostAccounter.recordJump();
                            ** GOTO lbl102
lbl42:
                            // 1 sources

                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                            var9_6 = var7_5.getDelay(TimeUnit.NANOSECONDS);
                            RuntimeCostAccounter.recordJump();
                            if (var9_6 > 0L) break block21;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.finishPoll:(Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
                            var11_7 /* !! */  = this.finishPoll(var7_5);
                            RuntimeCostAccounter.recordJump();
                            if (this.leader == null) {
                                v2 = this.queue[0];
                                RuntimeCostAccounter.recordJump();
                                if (v2 != null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                    this.available.signal();
                                }
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                            var6_4.unlock();
                            return var11_7 /* !! */ ;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var4_3 > 0L) break block22;
                        var11_7 /* !! */  = null;
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == null) {
                            v3 = this.queue[0];
                            RuntimeCostAccounter.recordJump();
                            if (v3 != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                                this.available.signal();
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                        var6_4.unlock();
                        return var11_7 /* !! */ ;
                    }
                    var7_5 = null;
                    RuntimeCostAccounter.recordJump();
                    if (var4_3 < var9_6) ** GOTO lbl-1000
                    RuntimeCostAccounter.recordJump();
                    if (this.leader != null) lbl-1000:
                    // 2 sources

                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                        var4_3 = this.available.awaitNanos(var4_3);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                        var11_7 /* !! */  = Thread.currentThread();
                        this.leader = var11_7 /* !! */ ;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.awaitNanos:(J)J");
                        var12_8 = this.available.awaitNanos(var9_6);
                        var4_3 -= var9_6 - var12_8;
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == var11_7 /* !! */ ) {
                            this.leader = null;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    break block23;
                    catch (Throwable var14_10) {
                        RuntimeCostAccounter.recordJump();
                        if (this.leader == var11_7 /* !! */ ) {
                            this.leader = null;
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw var14_10;
                    }
                }
                RuntimeCostAccounter.recordJump();
                continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.size) break;
                    RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[n];
                    RuntimeCostAccounter.recordJump();
                    if (runnableScheduledFuture != null) {
                        this.queue[n] = null;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.setIndex:(Ljava/util/concurrent/RunnableScheduledFuture;I)V");
                        this.setIndex(runnableScheduledFuture, -1);
                    }
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                this.size = 0;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        /*
         * Enabled aggressive block sorting
         */
        private RunnableScheduledFuture<?> peekExpired() {
            RunnableScheduledFuture<?> runnableScheduledFuture;
            RunnableScheduledFuture<?> runnableScheduledFuture2 = this.queue[0];
            RuntimeCostAccounter.recordJump();
            if (runnableScheduledFuture2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/RunnableScheduledFuture.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
                long l = runnableScheduledFuture2.getDelay(TimeUnit.NANOSECONDS) - 0L;
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0) {
                    runnableScheduledFuture = runnableScheduledFuture2;
                    return runnableScheduledFuture;
                }
            }
            runnableScheduledFuture = null;
            RuntimeCostAccounter.recordJump();
            return runnableScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> collection) {
            int n;
            RuntimeCostAccounter.recordJump();
            if (collection == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (collection == this) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.peekExpired:()Ljava/util/concurrent/RunnableScheduledFuture;");
                    RunnableScheduledFuture<?> runnableScheduledFuture = this.peekExpired();
                    RuntimeCostAccounter.recordJump();
                    if (runnableScheduledFuture == null) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                    collection.add(runnableScheduledFuture);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.finishPoll:(Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
                    this.finishPoll(runnableScheduledFuture);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                n = n2;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> collection, int n) {
            int n2;
            RuntimeCostAccounter.recordJump();
            if (collection == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (collection == this) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n <= 0) {
                return 0;
            }
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n3 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.peekExpired:()Ljava/util/concurrent/RunnableScheduledFuture;");
                    RunnableScheduledFuture<?> runnableScheduledFuture = this.peekExpired();
                    RuntimeCostAccounter.recordJump();
                    if (runnableScheduledFuture == null) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                    collection.add(runnableScheduledFuture);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.finishPoll:(Ljava/util/concurrent/RunnableScheduledFuture;)Ljava/util/concurrent/RunnableScheduledFuture;");
                    this.finishPoll(runnableScheduledFuture);
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return n2;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray;
            ReentrantLock reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                objectArray = Arrays.copyOf(this.queue, this.size, Object[].class);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            ReentrantLock reentrantLock;
            block4: {
                T[] TArray2;
                reentrantLock = this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    int n = TArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.size) break block4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = TArray.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                    TArray2 = Arrays.copyOf(this.queue, this.size, clazz);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return TArray2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.queue, 0, TArray, 0, this.size);
            int n = TArray.length;
            RuntimeCostAccounter.recordJump();
            if (n > this.size) {
                TArray[this.size] = null;
            }
            T[] TArray3 = TArray;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return TArray3;
        }

        @Override
        public Iterator<Runnable> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue$Itr");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue$Itr.<init>:(Ljava/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue;[Ljava/util/concurrent/RunnableScheduledFuture;)V");
            return new Itr(Arrays.copyOf(this.queue, this.size));
        }

        private class Itr
        implements Iterator<Runnable> {
            final RunnableScheduledFuture<?>[] array;
            int cursor;
            int lastRet;

            Itr(RunnableScheduledFuture<?>[] runnableScheduledFutureArray) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.cursor = 0;
                this.lastRet = -1;
                this.array = runnableScheduledFutureArray;
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                int n = this.array.length;
                RuntimeCostAccounter.recordJump();
                if (this.cursor < n) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }

            @Override
            public Runnable next() {
                int n = this.array.length;
                RuntimeCostAccounter.recordJump();
                if (this.cursor >= n) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                this.lastRet = this.cursor;
                return this.array[this.cursor++];
            }

            @Override
            public void remove() {
                RuntimeCostAccounter.recordJump();
                if (this.lastRet < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                    IllegalStateException illegalStateException = new IllegalStateException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                RunnableScheduledFuture<?> runnableScheduledFuture = this.array[this.lastRet];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$DelayedWorkQueue.remove:(Ljava/lang/Object;)Z");
                DelayedWorkQueue.this.remove(runnableScheduledFuture);
                this.lastRet = -1;
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;
        int heapIndex;

        ScheduledFutureTask(Runnable runnable, V v, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
            super(runnable, v);
            this.outerTask = this;
            this.time = l;
            this.period = 0L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.access$000:()Ljava/util/concurrent/atomic/AtomicLong;");
            AtomicLong atomicLong = sequencer;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndIncrement:()J");
            this.sequenceNumber = atomicLong.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, V v, long l, long l2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
            super(runnable, v);
            this.outerTask = this;
            this.time = l;
            this.period = l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.access$000:()Ljava/util/concurrent/atomic/AtomicLong;");
            AtomicLong atomicLong = sequencer;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndIncrement:()J");
            this.sequenceNumber = atomicLong.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.<init>:(Ljava/util/concurrent/Callable;)V");
            super(callable);
            this.outerTask = this;
            this.time = l;
            this.period = 0L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.access$000:()Ljava/util/concurrent/atomic/AtomicLong;");
            AtomicLong atomicLong = sequencer;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndIncrement:()J");
            this.sequenceNumber = atomicLong.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.now:()J");
            long l = this.time - ScheduledThreadPoolExecutor.this.now();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.convert:(JLjava/util/concurrent/TimeUnit;)J");
            return timeUnit.convert(l, TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            int n;
            RuntimeCostAccounter.recordJump();
            if (delayed == this) {
                return 0;
            }
            boolean bl = delayed instanceof ScheduledFutureTask;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
                long l = this.time - scheduledFutureTask.time;
                RuntimeCostAccounter.recordJump();
                if (l < 0L) {
                    return -1;
                }
                RuntimeCostAccounter.recordJump();
                if (l > 0L) {
                    return 1;
                }
                long l2 = this.sequenceNumber - scheduledFutureTask.sequenceNumber;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 < 0) {
                    return -1;
                }
                return 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
            long l = this.getDelay(TimeUnit.NANOSECONDS);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Delayed.getDelay:(Ljava/util/concurrent/TimeUnit;)J");
            long l4 = l - delayed.getDelay(TimeUnit.NANOSECONDS);
            RuntimeCostAccounter.recordJump();
            if (l4 < 0L) {
                n = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (l4 > 0L) {
                    n = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
            }
            return n;
        }

        @Override
        public boolean isPeriodic() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.period != 0L) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        private void setNextRunTime() {
            long l = this.period;
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                this.time += l;
                RuntimeCostAccounter.recordJump();
            } else {
                long l2 = -l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.triggerTime:(J)J");
                this.time = ScheduledThreadPoolExecutor.this.triggerTime(l2);
            }
        }

        @Override
        public boolean cancel(boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.cancel:(Z)Z");
            boolean bl2 = super.cancel(bl);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.access$100:(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)Z");
                boolean bl3 = ScheduledThreadPoolExecutor.this.removeOnCancel;
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordJump();
                    if (this.heapIndex >= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.remove:(Ljava/lang/Runnable;)Z");
                        ScheduledThreadPoolExecutor.this.remove(this);
                    }
                }
            }
            return bl2;
        }

        @Override
        public void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.isPeriodic:()Z");
            boolean bl = this.isPeriodic();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.canRunInCurrentRunState:(Z)Z");
            boolean bl2 = ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(bl);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.cancel:(Z)Z");
                this.cancel(false);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.access$201:(Ljava/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask;)V");
                    ScheduledFutureTask.access$201(this);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.access$301:(Ljava/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask;)Z");
                    boolean bl3 = ScheduledFutureTask.access$301(this);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor$ScheduledFutureTask.setNextRunTime:()V");
                        this.setNextRunTime();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ScheduledThreadPoolExecutor.reExecutePeriodic:(Ljava/util/concurrent/RunnableScheduledFuture;)V");
                        ScheduledThreadPoolExecutor.this.reExecutePeriodic(this.outerTask);
                    }
                }
            }
        }

        static /* synthetic */ void access$201(ScheduledFutureTask scheduledFutureTask) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.run:()V");
            super.run();
        }

        static /* synthetic */ boolean access$301(ScheduledFutureTask scheduledFutureTask) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/FutureTask.runAndReset:()Z");
            return super.runAndReset();
        }
    }
}

