![RAN](https://user-images.githubusercontent.com/694940/29736531-6ab509e8-8a02-11e7-8e61-66e5ea4e29b8.png)
### RAN : React . GraphQL . Next.js Toolkit

[![Greenkeeper badge](https://badges.greenkeeper.io/Sly777/ran.svg)](https://greenkeeper.io/) [![All Contributors](https://img.shields.io/badge/all_contributors-3-orange.svg?style=flat-square)](#contributors) [![Join the chat at https://gitter.im/ran-boilerplate/Lobby](https://badges.gitter.im/ran-boilerplate/Lobby.svg)](https://gitter.im/ran-boilerplate/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![Build Status](https://travis-ci.org/Sly777/ran.svg?branch=master)](https://travis-ci.org/Sly777/ran) [![license](https://img.shields.io/github/license/sly777/ran.svg)]()<br/>
[![Code Climate](https://codeclimate.com/github/Sly777/ran/badges/gpa.svg)](https://codeclimate.com/github/Sly777/ran) [![Known Vulnerabilities](https://snyk.io/test/github/sly777/ran/badge.svg)](https://snyk.io/test/github/sly777/ran) [![npm](https://img.shields.io/npm/v/ran-boilerplate.svg)](https://www.npmjs.com/package/ran-boilerplate) [![styled with prettier](https://img.shields.io/badge/styled_with-prettier-ff69b4.svg)](https://github.com/prettier/prettier)

## Features

- ***Hot-Reload Ready for Dev***

- ***Next Generation JavaScript (ES6)***

- ***Offline Ready (Experimental!)***

- ***Next Generation CSS (CSS-in-JS)***

- ***Create New Page in a Second (with CLI)***

- ***SEO-Ready***

- ***Performance-first***

- ***Production Deployment Ready for Now, Digital Ocean and Heroku***

- ***Prettier and Eslint integrated***

## How to use

- Firstly, Clone the repo with this command.

```bash
git clone --depth=1 https://github.com/Sly777/ran.git RAN
cd RAN
yarn install && yarn run setup
```

- If you are not using Yarn, just run ```npm install && npm run setup``` instead ```yarn install && yarn run setup```
- After everything is finished, run ```yarn run dev``` (or ```npm run dev```)

And that's all!

#### Clean Setup (without example pages & components)

```bash
git clone --depth=1 https://github.com/Sly777/ran.git RAN
cd RAN
yarn install && yarn run setup:clean
```

#### Beta Version (Unstable)

Also, There is a ```beta``` version for new features & fixes that we are testing before release. To access beta;

```bash
git clone --depth=1 -b beta https://github.com/Sly777/ran.git RAN_beta
cd RAN_beta
yarn install && yarn run setup
```

It can be unstable, so that's why please use stable version if you are working on the project that is in production.

## Example

[Click here](https://ran.now.sh/) to see example project to understand how RAN! works on production. I used [graph.cool](https://graph.cool/) service for GraphQL and [now](https://zeit.co/now) for hosting in the example.

## Commands

Best feature of RAN! is **CL commands**. You can just run one command to create page with route! [Click here](docs/Commands.md) to see details how It works on RAN!.

![YAY](https://media.giphy.com/media/l0Iy6nmyS5p7hIAso/giphy.gif)
![YAYY](https://media.giphy.com/media/26vIfscbQhVK7ML5u/giphy.gif)

## Documentation

[Click here](https://www.rantoolkit.com/) to see all details of RAN!

## FAQ

[Click here](docs/FAQ.md) for FAQ of RAN! If it doesn't solve your problem, feel free to open an issue on GitHub!

## License

This project is licensed under the MIT license, Copyright (c) 2017 Ilker Guller. For more information see [LICENSE.md](LICENSE.md).

## Contributing

Please read [Contributing doc](docs/Contributing.md) for details on our code of conduct, and the process for submitting pull requests.

## Versioning

RAN! is using [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/Sly777/ran/tags).

## Author

* **Ilker Guller** - [website](http://ilkerguller.com) / [twitter](https://twitter.com/the_bluescreen)

See also the list of [maintainers](MAINTAINERS.md) who participated in this project.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
| [<img src="https://avatars0.githubusercontent.com/u/694940?v=4" width="100px;"/><br /><sub>Ilker Güller</sub>](http://ilkerguller.com)<br />[💻](https://github.com/sly777/ran/commits?author=Sly777 "Code") [📖](https://github.com/sly777/ran/commits?author=Sly777 "Documentation") [👀](#review-Sly777 "Reviewed Pull Requests") [📢](#talk-Sly777 "Talks") | [<img src="https://avatars2.githubusercontent.com/u/7573215?v=4" width="100px;"/><br /><sub>bjornmelgaard</sub>](https://bitbucket.org/melgaardbjorn)<br />[💻](https://github.com/sly777/ran/commits?author=BjornMelgaard "Code") [💬](#question-BjornMelgaard "Answering Questions") | [<img src="https://avatars0.githubusercontent.com/u/10152022?v=4" width="100px;"/><br /><sub>Asten Mies</sub>](https://github.com/astenmies)<br />[💻](https://github.com/sly777/ran/commits?author=astenmies "Code") |
| :---: | :---: | :---: |
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/kentcdodds/all-contributors) specification. Contributions of any kind welcome!
