package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           96,  379,  215,  215,  314,  261,  264,  312,  214,  315, 
          309,  228,  133,  133,  630,  636,  469,  355,  677,  643, 
          690,  640,  133,  215,  702,  721,  295,  295,  426,  647, 
          295,  228,  772,  299,  299,  325,  308,  299,   83,   83, 
          353,  230,  107,  671,  708,  330,  334,  491,  215,  576, 
          676,  526,  765,  767,  361,  528,  810,  133,  746,  743, 
          721,  230,  630,  636,  720,  332,  336,  720,  565,  699, 
          591,  306,  439,  633,  581,  620,  671,    8,  621,  833, 
          263,  622,  622,  713,   86,  267,  543,    8,  417,  311, 
          571,  633,  446,  840,  874,  432,  633,  954,  465,  434, 
          308,   72,  565,  311,  591,  558,  730,  133,  581,  296, 
          302,  671,  633,  303,   95,   95,  596,  565,  888,  591, 
           95,  431,  850,  581,  571,  564,  285,  308,  430,  262, 
           74,  671,  957,  516,  634,  543,    8,  573,  742,  571, 
           83,   88,   88,  134,  134,  633,  572,   88,  257,  257, 
          257,  431,  321,  283,  257,  257,  385,   95,  257,  564, 
          633,  633,  583,  429,   86,  596,  755,  596,  391, 1018, 
         1033,  573,  377,  304,  564,  378,   73,  377,  267,  803, 
          572,   72,  558,  872,   88,  257,  573,  371,  351,  307, 
          257,   83,  774,  551, 1012,  572,  583,  263,  552,  263, 
          341,  523,  376,   75,  761,  385,  443,  379,  374,  633, 
          781,  583,  558,  311,  418,  633,  596,  391,  558,  272, 
          274,  419,  975,  559,  273,  633,   81,   71,  504,  633, 
          377,  558,  307,  558,  654,  522,  435,  523,  351,  576, 
          372,  809,   95,  375,  783,  373,  262,  491,  262,  341, 
         1033,  814, 1047,  378,   75,  564,  565,   79,  378, 1018, 
          721,  317,  458,  474,  475,  776,  834,  257,  387,   88, 
          452,  525,  311,  762,  633,  628,  366,   81,  633,  530, 
          818,  558,  558,  957,  813,  322,  815, 1072,  298,  298, 
          406,  566,  298,  628,  874,  505,  506,  457,  777,  402, 
          368,  720,  720,  404,  405,  497, 1049,  406,   79,  107, 
          441,  441,  267,  325,  622,  295,  441,  295,  295,   72, 
          331,  372,  299,  470,  299,  415,  440,  971,  913,  444, 
          374,  622,  416,   53,  979,  463,  445,  442,  267,  983, 
           76,   84,  464,  107,  961,  660,   95,   95,  965,  967, 
          413,  969,  422,  970,  536,  537,  538,  576,  133,  576, 
          107,  539,   77,  565,  622,  591,  633,  421,  689,  581, 
          471,  285,  685,   88,   88,  593,  594,  595,  596,  872, 
          622,  543,  423,  385,  386,  571,  442,  644,  675,  648, 
          311,   76,   84,  658,  662,  872,  536,  537,  492,  565, 
          495,  591,  306,  539,  633,  581,  647,  257,  257,   83, 
          950,  596,  638,   77,  325,  497,  656,  543,  591,  310, 
          597,  571,  581, 1069,  915,  633,  441,  427,  295,   95, 
          632,  308,  565,  133,  591,   95,  558,  620,  581,    8, 
          621,  638,  428,  257,  497,  257,  257,  596,  633,  257, 
          543,  257,  688,  691,  571,  848,   88,  295,  837,  632, 
          638,   74,   88,  497,  530,  634,   83,  844,  634,  664, 
          705,   83,   75,  564,  638,  872,  295,  497,  632, 1062, 
          596,  633,  633,  633,  728,  573,  721,  996,  633,  351, 
          295,  633,  632,   82,  572,   81,   95, 1051, 1053, 1054, 
         1055, 1006,  310,  215,  385,  719,  378,   73,   96,  638, 
          583,  228, 1004,  558,  668,  596,  391,  451,  371,  257, 
          257,  257,  257,   88,  257,  257,   79,  632,  720,  638, 
          536,  537,  497,  376,   75,  652,   95,  539,  379,  374, 
          736,  230,   95,  133,   82,  295,   83,  632,  707,  707, 
          272,  274, 1079,  272,  274,  273,  257,   81,  273,   95, 
          257,  377,  257,   88,  351,  103,  257,  257, 1038,   88, 
           95,  372,  467,   95,  375,  940,  373,  298,  107,  298, 
           18,   95,  385,  386,  530,  257,   88,  257,   79,  780, 
          780,  826,  689,  844,  442,  633,  589,   88,  671,  103, 
           88,  590,   80,  454,  257, 1043,  782,  633,   88,   76, 
           84,  437,  456,  633,  459,  438,  103,   78,  257,  787, 
          502,  795,   95,  900,  780,  793,  633,  311,  789,  905, 
          107,   77,  796,  466,  311,  471,  518,  473,  520,  612, 
          107,  789,  473,  468,  633,  786,  432,  257,  870,   88, 
          873,  792,   17,   80,  475,  473,  633,  795,  786,  475, 
          817,  880,  633,  133,  808,  442,  849,  476,   78,  789, 
          480,   76,   84,  257,  351,  633,  486,  311,  215,  215, 
          795,  487,   96,  490,  816,  821,  786,  228,  825,  792, 
          510,  691,  387,   77,  795,  514,  653, 1003,  116,  691, 
          653,   17,  515,  263,  126,  106,  106,  564,  565,  841, 
          263,  106,  106,  106,  106,  479,  521,  230,  106,  106, 
           83,  517,  106,  795,  909,  633,  633,  653,  633,  527, 
          529,  633,  546,  530,  535,  550,  863,  836,  665,  657, 
          585,  807,  845,  588,  703,  133,  633,  116,  106,  106, 
          896,  898,  262,  126,  106,  508,  901,  903,  863,  262, 
          684,  679,   82,  620,  620,  620,  648,   97,  689,  620, 
          620,  694,  620,  704,  536,  537,  541,  633,  723,  511, 
          633,  539,   95,  724,  725,  311,  536,  537,  731,  737, 
          748,  715,   95,  539,  351,  633,   95,  290,  544,  756, 
          757,   95,  722,  758,  780,  465,  536,  290,  257,   88, 
          726,  727,  133,  759,  511,  255,  255,  255,  764,   88, 
          766,  942,  768,   88,   82,  534,  734,  133,   88,  735, 
          770,  106,  771,  106,  103,  432,  775,  784,  115,  785, 
          790,  285,  620,  791,  800,   92,   92,  135,  135,  633, 
         1020,   92,  327,  257,  633,  536,  290,  284,  801,  804, 
         1027,  633,  863,  620, 1031,  126,  633,  567,  633,  811, 
          633,   80,  992,   95,   95, 1001,  351,  819,  633,  633, 
          633,  823,  917,  432,  829,  633,   78,  115,   92,  921, 
          432,   95,  352,   95,  830,   95,  103,  831,  117,  133, 
           88,   88,  832,  847,   17,   17,   17,  835,  860,  894, 
           17,   17,  652,   17,  311,  707,  432,  906,   88,  510, 
           88,  311,   88,  257,  257,  446,  612,  907,  918,  257, 
          257,  939,  920,   80,  436,   95,  923,  106,  106,  257, 
          206,  633,  352,  351, 1076,  691,  943,  117,   78,   95, 
           95,   95,  477,  945,  944,  116,   16,  951,  937,  478, 
          460,  126,   88,   95,  802,  257,  955,  460,  102,  102, 
          958,  106,  106,   92,  102,  959,   88,   88,   88,  512, 
          133,  960,  633,   17,  633,  633,  633,  633,  812,  206, 
           88,  505,  118,  962,  963,  199,  638, 1050,  964,  497, 
          966,  508,  116,  633,   17,   16,  968,  106,  972,  106, 
          106,  102,  295,  106,  632,  106,  511,  973,  110,  976, 
          106,  978,  311,  511,  795,  505,  106,   95,   95,  311, 
          987,  638,  980,  982,  612,  508,  988,  991,  998,  846, 
          505,  118,  512,  691,  199,  257,  536,  537,  541,  513, 
          508,  511,   95,  539,   88,   88,  751,  567,  511,  290, 
          290,  290,  532,  989,  861,  290,  290,  110,  290,  533, 
         1010, 1007,  505,  513,  255,  255, 1008,   92,   92,   88, 
         1011, 1034,  508,  106,  106,  106,  106,  106,  106,  106, 
          290,  290,  290,  290,  290,  115,  102,  858, 1048,  505, 
         1026, 1037,  536,  209,  536,  536,  536,  536,  536,   95, 
         1036, 1023,  999,  536, 1052,   95,  501, 1056,  503, 1000, 
          106,   95, 1058,  919,  106, 1060,  106,  106, 1063, 1068, 
          106,  106, 1071,  106, 1081,  536,   88,  620,  290,  633, 
          257,  113,   88,  536,  536,  536,  536,   96,   88,  106, 
          106,  106,  209,  633,  621,  117,  510,  622,  324,  290, 
           92,  106,  444,  510,  106,   98,   92,  953,  106, 1035, 
          622,  311,  106,  626,  626,  567,  628,  567,  536,  537, 
          543,  536,  106,   99,  622,  539,  255,  255,  255,  255, 
          113,  598,  599,  352,  510,  536,  537,  547,  622,  633, 
          102,  102,  539,  450,  376,  311,  484,  364,   16,   16, 
           16,  106,  512,  106,   16,   16,  512,   16,  852,  853, 
          311,  854,  508,  512,  137,  615,  587,   92,  692, 1070, 
          513,  217,  797,  997,  101,  871,  206,  106,  206,  206, 
          206,  206,  206,  324,  883,  751,  859,  206,  876,  118, 
         1013, 1028,  311,  542,  678,  545, 1029,  548,  511,  615, 
          567,  608,  567,  548,  908,  511,  286,   92,  352,  206, 
          206,  609, 1044,   92,  615,  110,  857,  206,  206,  206, 
          206,  515,    0,  102,    0,   59,   60,   16,  608,  102, 
           92,  199, 1073,  199,  199,  199,  199,  199,    0,  100, 
          311,   92,  199,    0,   92,    0,  615,    0,   16,  505, 
          513,    0,   92,  510,  729,  206,  505,  513,    0,  508, 
          510,  608,    0,    0,  199,  199,  508,  122,    0,    0, 
            0,  609,  199,  199,  199,  199,  505,    0,    0,  505, 
            0,    0,  608,  505,    0,    0,  514,    0,  608,  508, 
          102,    0,  609,   92,  751,    0,  751,    0,  194,  553, 
            0,  554,  555,  556,  557,    0,  120,    0,    0,  608, 
          199,    0,  106,  106,  542,    0,  122,    0,  352,  102, 
            0,    0,  115,  106,  536,  537,  586,  106,    0,    0, 
          102,  539,  106,    0,    0,    0,  102,    0,  113,  209, 
          117,  209,  209,  209,  209,  209,    0,  194,  432,    0, 
          209,  609,    0,  102,    0,  120,    0,  106,  118,    0, 
            0,  512,    0,  176,  102,    0,  516,  102,  512,    0, 
          511,  510,  209,  209,    0,  102,  324,    0,  510,  747, 
          209,  209,  209,  209,    0,    0,    0,  515,    0,  512, 
          119,  751, 1014,  479,  479,  479,  512,    0,    0,  508, 
          479,    0,  567,    0,  106,  106,  508,  513,    0,  120, 
           91,  609,  176,    0,  513,  255,  102,  747,  209,    0, 
            0,    0,  106,    0,  106,    0,  106,  106,  106,  311, 
            0,    0,  609,  106,  106,  615,  311,    0,  352,  119, 
          121,  612,    0,  106,   91,    0,    0,  751,    0,  751, 
            0,    0,  553,   92,  554,  555,  556,  557,  515,  311, 
          255,   91,    0,   92,    0,  515,  106,   92,    0,  106, 
            0,  514,   92,    0,  119,  294,  294,  324,    0,  294, 
          106,  106,  106,  615,  751,   93,    0,   92,    0,  121, 
          615,  505,    0,    0,  106,  611,  461,  461,  461,   95, 
            0,  318,  320,  461,    0,    0,    0,  294,  294,    0, 
          354,  356,    0,  615,  693,    0,  615,    0,    0,    0, 
          352,  516,  701,  514,  122,    0,    0,    0,  856,    0, 
          514,    0,  507,    0,  506,    0,  879,  432,  554,  555, 
          556,  557,  558,    0,   92,   92,  509,  559,  553,  106, 
          554,  555,  556,  557,  121,    0,    0,    0,  106,  106, 
          112,  333,   92,  120,   92,    0,   92,    0,  123,  560, 
            0,    0,  255,    0,    0,    0,  102,  562,  563,  564, 
          565,  749,    0,  106,    0,  432,  102,  352,    0,  750, 
          102,    0,  432,    0,  194,  102,  194,  194,  194,  194, 
          194,    0,  938,  516,    0,  194,   92,    0,    0,  112, 
          516,   61,   62,   63,   64,  566,  513,  123,  432,    0, 
           92,   92,   92,  513,  515,    0,    0,  194,  194,    0, 
            0,  515,    0,    0,   92,  194,  194,  194,  194,  109, 
          106,  507,    0,    0,  106,    0,  106,  119,    0,  611, 
            0,    0,  106,    0,    0,  111,    0,    0,  177,  176, 
            0,  176,  176,  176,  176,  176,    0,  102,  102,    0, 
          176,    0,    0,  194,  135,  467,  467,  467,    0,   91, 
          608,  515,  467,    0,    0,  102,  303,  102,  515,  102, 
            0,    0,  176,  176,    0,  387,    0,  121,   92,   92, 
          176,  176,  176,  176,  111,    0,    0,  177,  514,    0, 
            0,  178,   97,    0,  553,  514,  554,  555,  556,  557, 
          112,    0,  111,   92,    0,    0,  402,    0,  505,  102, 
          404,  405,  406,  407,  114,  505,  506,    0,  176,    0, 
          608,   91,  822,  102,  102,  102,   97,  749,  294,  294, 
          294,  356,    0,  294,    0,  135,    0,  102,  516,    0, 
          178,  608,   94,   97,  294,  516,  294,  294,    0,  507, 
          134,  506,    0,  108,    0,  509,  507,    0,  506,    0, 
           92,    0,    0,  509,    0,    0,   92,    0,    0,    0, 
          509,    0,   92,  511,    0, 1015,   94,  554,  555,  556, 
          557,  481,  482,  483,    0,    0,  485,  380,  381,  382, 
          383,  384,    0,   94,  868,  869,    0,  112,    0,  134, 
          312,  102,  102,    0,  135,  123,    0,    0,    0,    0, 
            0,    0,  892,    0,  893,    0,  895,    0,  611,    0, 
            0,    0,    0,  508,    0,    0,  102,  600,  601,  602, 
          603,  604,  605,  606,  607,  608,  609,  610,  611,  612, 
          613,  614,  615,  616,  617,  618,  619,  620,  621,  622, 
          623,  624,  625,  135,  128,    0,  941,  294,  507,    0, 
          125,  645,  104,  649,    0,  507,  611,  294,  663,    0, 
          947,  948,  949,  611,    0,    0,    0,    0,  611,    0, 
            0,    0,    0,  102,  952,   91,  294,    0,    0,  102, 
            0,  106,  111,    0,  294,  102,  104,    0,    0,  611, 
            0,   96,    0,  303,    0,  294,  645,  700,  663,  125, 
          303,  294,    0,  104,    0,    0,  651,    0,    0,  294, 
          661,    0,  621,  621,  621,  106,  294,  294,  621,  621, 
          294,  621,  505,    0,  177,   96,  177,  177,  177,  177, 
          177,  612,  106,  611,    0,  177,    0,  686,  995,    0, 
            0,    0,   96,  506,  732,  733,  514,  114,    0,    0, 
          506,   97,  294,  514,  651,  294,    0,  177,  177,    0, 
            0,    0,  612, 1002,  294,  177,  177,  177,  177,  716, 
          718,    0,  510,  333,    0,    0,    0,  178,  127,  178, 
          178,  178,  178,  178,    0,    0,    0,  220,  178,    0, 
            0,  621,    0,    0,    0,    0,  114,  220,    0,  516, 
          511,   94,  609,  177,    0,  718,  516,  511,  333,    0, 
          178,  178,  621,   97,  294,    0,    0,  105,  178,  178, 
          178,  178,    0,    0,    0,    0, 1045,  312,  509,    0, 
            0,  220, 1046,  124,  312,    0,  134,  128,  134,  134, 
          134,  134,  134,    0,    0,  220,  220,  134,    0,    0, 
          508,  105,    0,    0,   98,  127,  178,  508,  505,    0, 
            0,    0,  609,   94,    0,  505,  103,  773,  105,  134, 
          134,    0,    0,    0,    0,   99,  294,  134,  134,  134, 
          134,    0,  124,  609,    0,    0,  128,    0,   98,    0, 
          135,  101,  135,  135,  135,  135,  135,    0,  615,    0, 
            0,  135,    0,    0,  127,   98,    0,  125,    0,   99, 
          110,  608,  508,  432,  615,  134,    0,    0,  303,  508, 
          612,  104,  611,  135,  135,  101,   99,  387,    0,  798, 
            0,  135,  135,  135,  135,  512,  312,    0,    0,    0, 
            0,    0,  101,  400,  401,  294,    0,  294,    0,    0, 
          106,  612,    0,    0,  294,  294,  513,    0,  402,  505, 
           96,    0,  404,  405,  406,  407,  505,    0,  612,  135, 
          611,  608,  515,    0,    0,  612,    0,  611,    0,  505, 
          612,    0,  611,  104,    0,    0,  294,    0,    0,  505, 
            0,    0,  608,    0,    0,    0,    0,    0,  842,  612, 
          843,  612,    0,  611,  114,    0,  612,  718,  333,  510, 
          387,  612,  106,    0,  897,  899,  510,    0,    0,    0, 
          902,  904,   96,  505,    0,    0,  400,  401,    0,  910, 
          700,  294,  612,    0,    0,  914,    0,  505,  505,  864, 
          110,  402,  505,  403,    0,  404,  405,  406,  407,  220, 
          220,  220,    0,    0,  220,  220,  220,    0,  220,  897, 
          899,  902,  904,    0,    0,  509,  294,    0,  220,  220, 
          505,    0,  509,    0,    0,    0,    0,  220,  220,    0, 
          220,  220,  220,  220,  912,    0,  105,  615,    0,    0, 
          124,    0,  220,    0,  128,    0,    0,    0,    0,    0, 
            0,  122,  432,  615,    0,    0,    0,    0,  508,    0, 
            0,    0,  127,    0,    0,    0,    0,    0,  508,  946, 
            0,    0,    0,   98,  990,  220,    0,    0,  220,    0, 
            0,  220,    0,  220,    0,  615,  993,    0,    0,    0, 
            0,  294,  615,    0,   99,    0,    0,  611,  105,  220, 
          432,  615,  508,    0,    0,  303,    0,  432,  615,    0, 
          101,  220,  303,  611,    0,    0,  508,  508,  615,  113, 
            0,  508,  512,  312,  993,    0,    0,    0,    0,  512, 
          312,  294,    0,  432,  615,   98,  553,    0,  554,  555, 
          556,  557,    0,  513,  994,    0,    0,    0,    0,  508, 
          513,    0,    0,    0,    0,    0,   99,    0,    0,  515, 
            0,    0,    0,    0,    0,    0,  515,    0,    0,  749, 
            0,    0,  101,    0,    0,    0,    0,  956,    0,    0, 
            0,  294,    0,    0,  333,    0,  608,  608,  608,    0, 
          608,  505,  505,  505,  608,  608,  505,  505,  505,  608, 
          505,  608,  608,  608,  608,  608,  608,  608,    0,  608, 
          505,  505,  608,  608,  608,  608,  608,  608,  608,  505, 
          505,  608,  505,  505,  505,  505,  505,    0,  608,    0, 
            0,  608,  608,  608,  505,  608,  608,  608,  608,  608, 
          608,  608,  608,  608,  608,  608,  505,  505,  505,  505, 
          505,  505,  505,  505,  505,  505,  505,  505,  505,  505, 
            0,    0,  505,  505,  505,  608,  517,  505,  608,  608, 
          505,  608,  608,  505,  608,  505,  608,  505,  608,  505, 
          608,  505,  505,  505,  505,  505,  505,  505,  608,  505, 
          608,  505,  878,  608,  608,  608,  608,  608,  608,    0, 
          891,  890,  608,  505,  608,  608,    0,  608,  608,  608, 
          608,   94,  608,  608,  608,  609,  609,  609,    0,  609, 
          508,  508,  508,  609,  609,  508,  508,  508,  609,  508, 
          609,  609,  609,  609,  609,  609,  609,    0,  609,  508, 
          508,  609,  609,  609,  609,  609,  609,  609,  508,  508, 
          609,  508,  508,  508,  508,  508,    0,  609,  508,    0, 
          609,  609,  609,  508,  609,  609,  609,  609,  609,  609, 
          609,  609,  609,  609,  609,  508,  508,  508,  508,  508, 
          508,  508,  508,  508,  508,  508,  508,  508,  508,    0, 
            0,  508,  508,  508,  609,  520,  508,  609,  609,  508, 
          609,  609,  508,  609,  508,  609,  508,  609,  508,  609, 
          508,  508,  508,  508,  508,  508,  508,  609,  508,  609, 
          508,    0,  609,  609,  609,  609,  609,  609,  387,    0, 
          611,  609,  508,  609,  609,    0,  609,  609,  609,  609, 
          611,  609,  609,  609,  400,  401,    0,    0,  977,    0, 
            0,    0,  981,    0,    0,    0,    0,    0,    0,  402, 
            0,  403,    0,  404,  405,  406,  407,    0,    0,  410, 
            0,  411,    0,  553,  611,  554,  555,  556,  557,  558, 
            0,    0,    0,    0,  559,    0,    0,    0,  611,  611, 
            0,  123,    0,  611,    0,    0,  891,  890,    0,  891, 
          890,  891, 1030,  891,  890,    0,  560,  561,    0,    0, 
            0,    0,    0,    0,  562,  563,  564,  565,    0,    0, 
          553,  611,  554,  555,  556,  557,  558,    0,    0,    0, 
            0,  559,  879,    0,  554,  555,  556,  557,  558,    0, 
            0,    0,    0,  559,    0,    0,  113,  609,    0,    0, 
            0,    0,  566,  560,    0,    0,    0,    0,    0,  612, 
            0,  562,  563,  564,  565,  560,    0,    0,    0,  612, 
            0,    0,    0,  562,  563,  564,  565,    0,    0,  891, 
          890,  891,  890,  891,  890,    0,  891,  890,    0,    0, 
         1057,    0,    0, 1059, 1061,  508,    0, 1064, 1065,  566, 
            0,    0,  508,  612,  891,  890,    0,  609,    0,    0, 
            0,  566,    0,    0,    0,    0,    0,  612,  612,    0, 
          125,    0,  612,    0,    0,    0,    0,    0,  609,  387, 
          388,  389,  390,  391,  392,  393,  394,  395,  396,  397, 
            0, 1080, 1082, 1083, 1084,  400,  401,    0,    0,    0, 
          612, 1086,    0,    0,    0,    0,    0,    0,    0,    0, 
          402,    0,  403,    0,  404,  405,  406,  407,  408,  409, 
          410,    0,  411,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  611,  611,  611, 
            0,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,    0, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,    0,  611, 
            0,    0,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,    0,    0,  611,  611,  611,  611,    0,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,    0,  611,  611,  611,  611,  611,  611, 
            0,    0,    0,  611,  611,  611,  611,    0,  611,  611, 
          611,  611,  104,  611,  611,  611,  612,  612,  612,    0, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,    0,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,    0,  612,  611, 
            0,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
            0,    0,  612,  612,  612,  612,    0,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,    0,  612,  612,  612,  612,  612,  612,    0, 
            0,  615,  612,  612,  612,  612,    0,  612,  612,  612, 
          612,  615,  612,  612,  612,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  627,  628,    0, 
            0,  629,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,  615,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,  615, 
          615,  307,  124,    0,  615,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,    0,    0,    0,    0,    0, 
            0,    0,  615,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,    0,    0,    0, 
            0,  633,  634,    0,    0,  635,    0,  123,  611,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
          304,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
          304,    0,    0,    0,    0,  307,    0,    0,    0,    0, 
            0,    0,  199,  200,    0,  201,  202,  203,  204,  205, 
          206,  207,  208,  209,  210,  211,  611,    0,  212,    0, 
            0,    0,    0,  611,  304,    0,    0,    0,  611,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  304,  304, 
          213,    0,  387,  304,    0,    0,    0,  392,  393,  611, 
            0,  553,    0,  554,  555,  556,  557,  558,  400,  401, 
            0,    0,  559,    0,    0,    0,    0,    0,    0,    0, 
            0,  304,    0,  402,    0,  403,    0,  404,  405,  406, 
          407,  408,  409,  410,  560,  411,    0,    0,    0,    0, 
            0,    0,    0,    0,  564,  565,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  611,  611, 
          611,    0,  611,  615,  615,  615,  611,  611,  615,  615, 
          615,  611,  615,  611,  611,  611,  611,  611,  611,  611, 
          566,  615,  615,  615,  611,  611,  611,  611,  611,  611, 
          611,  615,  615,  611,  615,  615,  615,  615,  615,    0, 
          611,    0,    0,  611,  611,  611,  615,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,    0,    0,  615,  615,  615,  611,    0,  615, 
          611,  611,  615,  611,  611,  615,  611,  615,  611,  615, 
          611,  615,  611,  615,  615,  615,  615,  615,  615,  615, 
          611,  615,  615,  615,    0,  611,  611,  611,  611,  611, 
          611,    0,    0,    0,  611,  615,  611,  611,    0,  611, 
          611,  611,  611,  106,  611,  611,  611,  610,  610,  610, 
            0,  610,  304,  304,  304,  610,  610,  304,  304,  304, 
          610,  304,  610,  610,  610,  610,  610,  610,  610,    0, 
          610,  304,  304,  610,  610,  610,  610,  610,  610,  610, 
          304,  304,  610,  304,  304,  304,  304,  304,    0,  610, 
          612,    0,  610,  610,  610,  304,  610,  610,  610,  610, 
          610,  610,  610,  610,  610,  610,  610,  304,  304,  304, 
          304,  304,  304,  304,  304,  304,  304,  304,  304,  304, 
          304,    0,    0,  304,  304,  304,  610,    0,  304,  610, 
          610,  304,  610,  610,  304,  610,  304,  610,  304,  610, 
          304,  610,  304,  304,  304,  304,  304,  304,  304,  610, 
          304,  610,  304,    0,  610,  610,  610,  610,  610,  610, 
            0,    0,  616,  610,  304,  610,  610,    0,  610,  610, 
          610,  610,  616,  610,  610,  610,    0,    0,    0,    0, 
            0,    0,  641,  628,    0,    0,  642,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,  616,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,  307,    0,    0,    0, 
          616,  616,    0,  199,  200,  616,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  616,    0,    0,    0,    0,    0,    0, 
            0,  213,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  672,  634,    0,    0,  673,    0,  125,  612, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,  617,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,  617,    0,    0,    0,    0,  307,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  612,    0,  212, 
            0,    0,    0,    0,  612,  617,    0,    0,    0,  612, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  617, 
          617,  213,    0,    0,  617,    0,    0,    0,    0,    0, 
          612,  387,  388,  389,  390,  391,  392,  393,  394,    0, 
          396,  397,    0,    0,    0,    0,    0,  400,  401,    0, 
            0,    0,  617,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  402,    0,  403,    0,  404,  405,  406,  407, 
          408,  409,  410,    0,  411,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  613, 
          613,  613,    0,  613,  616,  616,  616,  613,  613,  616, 
          616,  616,  613,  616,  613,  613,  613,  613,  613,  613, 
          613,    0,  616,  616,  616,  613,  613,  613,  613,  613, 
          613,  613,  616,  616,  613,  616,  616,  616,  616,  616, 
            0,  613,    0,    0,  613,  613,  613,  616,  613,  613, 
          613,  613,  613,  613,  613,  613,  613,  613,  613,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,    0,    0,  616,  616,  616,  613,    0, 
          616,  613,  613,  616,  613,  613,  616,  613,  616,  613, 
          616,  613,  616,  613,  616,  616,  616,  616,  616,  616, 
          616,  613,  616,  616,  616,    0,  613,  613,  613,  613, 
          613,  613,    0,    0,    0,  613,  616,  613,  613,    0, 
          613,  613,  613,  613,  105,  613,  613,  613,  614,  614, 
          614,    0,  614,  617,  617,  617,  614,  614,  617,  617, 
          617,  614,  617,  614,  614,  614,  614,  614,  614,  614, 
            0,  617,  617,  617,  614,  614,  614,  614,  614,  614, 
          614,  617,  617,  614,  617,  617,  617,  617,  617,    0, 
          614,  615,    0,  614,  614,  614,  617,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,    0,    0,  617,  617,  617,  614,    0,  617, 
          614,  614,  617,  614,  614,  617,  614,  617,  614,  617, 
          614,  617,  614,  617,  617,  617,  617,  617,  617,  617, 
          614,  617,  617,  617,    0,  614,  614,  614,  614,  614, 
          614,    0,    0,  311,  614,  617,  614,  614,    0,  614, 
          614,  614,  614,  311,  614,  614,  614,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  695, 
          628,    0,    0,  696,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,  311,    0,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,  311,  311,  307,  126,    0,  311,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,  311,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  213,    0, 
            0,    0,    0,  697,  634,    0,    0,  698,    0,  124, 
          615,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,  431,  192,  193,    0,    0,    0,  194,  195, 
          196,  197,  431,    0,    0,    0,    0,  307,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  615,    0, 
          212,    0,    0,    0,    0,  615,  431,    0,    0,    0, 
          611,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  431,  213,    0,    0,  431,    0,    0,    0,    0, 
            0,  615,  387,  388,  389,  390,  391,  392,  393,    0, 
            0,  396,  397,    0,    0,    0,    0,    0,  400,  401, 
            0,    0,    0,  431,    0,    0,    0,    0,    0,    0, 
          311,    0,    0,  402,    0,  403,    0,  404,  405,  406, 
          407,  408,  409,  410,    0,  411,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          612,  612,  612,    0,  612,  311,  311,  311,  612,  612, 
          311,  311,  311,  612,  311,  612,  612,  612,  612,  612, 
          612,  612,    0,  412,  311,  311,  612,  612,  612,  612, 
          612,  612,  612,  311,  311,  612,  311,  311,  311,  311, 
          311,    0,  612,    0,    0,  612,  612,  612,  311,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          311,  311,  311,  311,  311,  311,  311,  311,  311,  311, 
          311,  311,  311,  311,    0,    0,  311,  311,  311,  612, 
            0,  311,  612,  612,  311,  612,  612,  311,  612,  311, 
          612,  311,  612,  311,  612,  311,  311,  311,  311,  311, 
          311,  311,  612,  311,    0,  311,    0,  612,  612,  612, 
          612,  612,  612,    0,    0,    0,  612,  311,  612,  612, 
            0,  612,  612,  612,  612,    0,  612,  612,  612,  280, 
          280,  280,    0,  280,  431,  431,  431,  280,  280,  431, 
          431,  431,  280,  431,  280,  280,  280,  280,  280,  280, 
          280,  473,  431,  431,  431,  280,  280,  280,  280,  280, 
          280,  280,  431,  431,  280,  431,  431,  431,  431,  431, 
            0,  280,    0,    0,  280,  280,  280,    0,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  431, 
          431,  431,  431,  431,  431,  431,  431,  431,  431,  431, 
          431,  431,  431,    0,    0,  431,  431,  431,  280,    0, 
          431,  280,    0,  431,  280,  280,  431,  280,  431,  280, 
          431,  280,  431,  280,  431,  431,  431,  431,  431,  431, 
          431,  280,  431,  431,  431,    0,  280,  280,  280,  280, 
          280,  280,    0,    0,  633,  280,    0,  280,  280,    0, 
          280,  280,  280,  280,  633,  280,  280,  280,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,  397,  633,  398, 
          399,    0,    0,  400,  401,    0,    0,    0,    0,    0, 
            0,    0,    0,  633,    0,    0,    0,  633,  402,    0, 
          403,    0,  404,  405,  406,  407,  408,  409,  410,    0, 
          411,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  633,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,  318,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,  318,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,  318,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,  318,    0,   46,   47,  318,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,  318,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  280,  280,  280,    0,  280,  633,  633,  633,  280, 
          280,  633,  633,  633,  280,  633,  280,  280,  280,  280, 
          280,  280,  280,    0,  633,  633,  633,  280,  280,  280, 
          280,  280,  280,  280,  633,  633,  280,  633,  633,  633, 
          633,  633,    0,  280,    0,    0,  280,  280,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  633,  633,  633,  633,  633,  633,  633,  633,  633, 
          633,  633,  633,  633,  633,    0,    0,  633,  633,  633, 
          280,    0,  633,  280,    0,  633,  280,  280,  633,  280, 
          633,  280,  633,  280,  633,  280,  633,  633,  633,  633, 
          633,  633,  633,  280,  633,  633,  633,    0,  280,  280, 
          280,  280,  280,  280,    0,    0,  350,  280,    0,  280, 
          280,    0,  280,  280,  280,  280,    0,  280,  280,  280, 
          280,  280,  280,    0,  280,  318,  318,  318,  280,  280, 
          318,  318,  318,  280,  318,  280,  280,  280,  280,  280, 
          280,  280,    0,    0,  318,  318,  280,  280,  280,  280, 
          280,  280,  280,  318,  318,  280,  318,  318,  318,  318, 
          318,    0,  280,    0,    0,  280,  280,  280,    0,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  318,    0,    0,  318,  318,  318,  280, 
            0,  318,  280,    0,  318,  280,  280,  318,  280,  318, 
          280,  318,  280,  318,  280,  318,  318,  318,  318,  318, 
          318,  318,  280,  318,  505,  318,    0,  280,  280,  280, 
          280,  280,  280,    0,  505,    0,  280,  100,  280,  280, 
            0,  280,  280,  280,  280,    0,  280,  280,  280,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   91,    0, 
            0,  100,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  505,    0,  110,    0,  505,  100,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  505,    0,    0,  514,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  337,  338, 
          339,  340,    0,  508,  117,    0,    0,    0,    0,    0, 
            0,  118,    0,  508,  341,  342,  343,    0,  344,   35, 
          345,  346,  347,  348,    0,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   94,  349,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,  508,    0,  113,    0,  508,    0,    0,    0, 
            0,    0,  102,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,  508,   65,   66,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  102,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,    0,    0,    0,    0, 
            0,  608,  608,  608,    0,  608,  505,  505,  505,  608, 
          608,    0,  505,  505,  608,  505,  608,  608,  608,  608, 
          608,  608,  608,  516,  608,    0,  100,  608,  608,  608, 
          608,  608,  608,  608,  505,  505,  608,  505,  505,  505, 
          505,  505,    0,  608,    0,    0,  608,  608,  608,    0, 
          608,  608,  608,  608,  608,  608,  608,  608,  608,  608, 
          608,  505,  505,  505,  505,  505,  505,  505,  505,  505, 
          505,  505,  505,  505,  505,  514,    0,  505,  505,  505, 
          608,  517,  514,  608,  608,  505,  608,  608,  100,  608, 
            0,  608,  505,  608,  505,  608,  505,  505,  505,  505, 
          505,  505,  505,  608,  505,  608,  505,    0,  608,  608, 
          608,  608,  608,  608,    0,    0,    0,  608,    0,  608, 
          608,    0,  608,  608,  608,  608,    0,  608,  608, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          608,  609,  609,  609,    0,  609,  508,  508,  508,  609, 
          609,    0,  508,  508,  609,  508,  609,  609,  609,  609, 
          609,  609,  609,    0,  609,    0,    0,  609,  609,  609, 
          609,  609,  609,  609,  508,  508,  609,  508,  508,  508, 
          508,  508,    0,  609,    0,    0,  609,  609,  609,    0, 
          609,  609,  609,  609,  609,  609,  609,  609,  609,  609, 
          609,  508,  508,  508,  508,  508,  508,  508,  508,  508, 
          508,  508,  508,  508,  508,    0,    0,  508,  508,  508, 
          609,  520,  102,  609,  609,  508,  609,  609,    0,  609, 
            0,  609,  508,  609,  508,  609,  508,  508,  508,  508, 
          508,  508,  508,  609,  508,  609,  508,    0,  609,  609, 
          609,  609,  609,  609,    0,    0,  611,  609,    0,  609, 
          609,    0,  609,  609,  609,  609,  611,  609,  609,  609, 
            0,  516,    0,    0,    0,    0,    0,    0,  516,    0, 
            0,    0,  709,  628,  102,    0,  710,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
          104,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,  611,  307,  123,    0,  611, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
            0,    0,    0,    0,    0,    0,    0,  611,    0,    0, 
            0,    0,    0,    0,    0,  711,  634,    0,    0,  712, 
            0,  213,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,    0, 
          194,  195,  196,  197,    0,  612,    0,    0,    0,  307, 
            0,    0,    0,    0,    0,  612,  199,  200,   93,  201, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
          641,  628,  212,    0,  642,    0,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,    0,  106, 
          192,  193,   93,    0,  213,  194,  195,  196,  197,    0, 
            0,    0,    0,    0,  612,    0,  125,    0,  612,   93, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,    0,    0,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,  612,    0,    0,  507, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  213, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  611,  611,  611,    0,  611,  611,  611, 
          611,  611,  611,    0,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,    0,  611,    0,    0,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,    0,  611,    0,    0,  611,  611, 
          611,    0,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,    0,    0,  611, 
          611,  611,  611,    0,    0,  611,  611,  611,  611,  611, 
          412,  611,    0,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  611,  611,  611,  611,  611,    0, 
          611,  611,  611,  611,  611,  611,    0,    0,    0,  611, 
            0,  611,  611,    0,  611,  611,  611,  611,    0,  611, 
          611,  611,  612,  612,  612,    0,  612,  612,  612,  612, 
          612,  612,    0,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,    0,  612,    0,   93,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,    0,  612,    0,    0,  612,  612,  612, 
            0,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  507,    0,  612,  612, 
          612,  612,    0,  507,  612,  612,  612,  612,  612,   93, 
          612,    0,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  612,  612,  612,  612,  612,    0,  612, 
          612,  612,  612,  612,  612,    0,    0,  615,  612,    0, 
          612,  612,    0,  612,  612,  612,  612,  615,  612,  612, 
          612,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  615,    0,  124,    0, 
          615,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  799,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  615,    0, 
            0,    0,    0,    0,  387,  388,  389,  390,  391,  392, 
          393,  394,  395,  396,  397,    0,  398,  399,    0,    0, 
          400,  401,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  402,  311,  403,    0,  404, 
          405,  406,  407,  408,  409,  410,  311,  411,    0,   92, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          107,    0,    0,   92,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  311,    0,  126,    0,  311, 
           92,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  311,    0,    0, 
          506,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  611,  611,  611,    0,  611,  615, 
          615,  615,  611,  611,    0,  615,  615,  611,  615,  611, 
          611,  611,  611,  611,  611,  611,  311,  615,    0,    0, 
          611,  611,  611,  611,  611,  611,  611,  615,  615,  611, 
          615,  615,  615,  615,  615,    0,  611,    0,    0,  611, 
          611,  611,    0,  611,  611,  611,  611,  611,  611,  611, 
          611,  611,  611,  611,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,    0,    0, 
          615,  615,  615,  611,    0,    0,  611,  611,  615,  611, 
          611,    0,  611,    0,  611,  615,  611,  615,  611,  615, 
          615,  615,  615,  615,  615,  615,  611,  615,  615,  615, 
            0,  611,  611,  611,  611,  611,  611,    0,    0,    0, 
          611,    0,  611,  611,    0,  611,  611,  611,  611,    0, 
          611,  611,  611,  612,  612,  612,    0,  612,  311,  311, 
          311,  612,  612,    0,  311,  311,  612,  311,  612,  612, 
          612,  612,  612,  612,  612,    0,    0,    0,   92,  612, 
          612,  612,  612,  612,  612,  612,  311,  311,  612,  311, 
          311,  311,  311,  311,  412,  612,    0,    0,  612,  612, 
          612,    0,  612,  612,  612,  612,  612,  612,  612,  612, 
          612,  612,  612,  311,  311,  311,  311,  311,  311,  311, 
          311,  311,  311,  311,  311,  311,  311,  506,    0,  311, 
          311,  311,  612,    0,  506,  612,  612,  311,  612,  612, 
           92,  612,    0,  612,  311,  612,  311,  612,  311,  311, 
          311,  311,  311,  311,  311,  612,  311,  633,  311,    0, 
          612,  612,  612,  612,  612,  612,    0,  633,    0,  612, 
            0,  612,  612,    0,  612,  612,  612,  612,    0,  612, 
          612,  612,    0,    0,    0,  866,    0,    0,    0,    0, 
            0,    0,  875,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,  882,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,  633,    0,    0,   19, 
           20,   21,  242,  243,  244,  245,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  246,  247, 
          248,    0,  249,   35,  250,  251,  252,  253,  288,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  254,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  289,    0,  290,    0,   50,    0,   95, 
            0,    0,    0,    0,    0,  291,    0,  129,    0,    0, 
           52,  292,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  293,    0,   95,    0,    0,    0,    0,  805,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           95,    0,    0,    0,    0,    0,  129,    0,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,  397,    0, 
          398,  399,    0,    0,  400,  401,    0,    0,    0,    0, 
          509,    0,    0,    0,    0,    0,    0,    0,  505,  402, 
            0,  403,    0,  404,  405,  406,  407,  408,  409,  410, 
         1019,  411, 1021,    0, 1022,    0,    0,    0,    0, 1024, 
            0,    0,    0,    0,    0,    0, 1032,    0,    0,    0, 
            0,    0,    0,    0,  280,  280,  280,    0,  280,  633, 
          633,  633,  280,  280,  633,  633,  633,  280,  633,  280, 
          280,  280,  280,  280,  280,  280,    0,  633,  633,  130, 
          280,  280,  280,  280,  280,  280,  280,  633,  633,  280, 
          633,  633,  633,  633,  633,    0,  280,    0,    0,  280, 
          280,  280,    0,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,    0,    0,    0,    0, 1074,    0, 
            0,    0,    0,    0, 1075,  633, 1077,    0,  130, 1078, 
            0,    0,  633,  280,    0,    0,  280,    0,  633,  280, 
          280,    0,  280,    0,  280,    0,  280, 1085,  280,    0, 
            0,    0,    0,    0,    0,    0,  280,    0,  633,  633, 
          508,  280,  280,  280,  280,  280,  280,    0,    0,    0, 
          280,    0,  280,  280,    0,  280,  280,  280,  280,    0, 
          280,  280,  280,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,    0,    0,  129,  129,   95,  129, 
          129,  129,  129,  129,  129,  129,    0,  608,  129,    0, 
          129,  129,  129,  129,  129,  129,  129,    0,    0,  129, 
            0,    0,    0,    0,    0,  129,  129,    0,  129,  129, 
          129,  129,    0,  129,  129,  129,  129,  129,  129,    0, 
          129,  129,  129,  129,    0,    0,    0,  509,    0,    0, 
            0,    0,    0,    0,  509,  505,    0,  129,    0,    0, 
           95,    0,  505,  129,    0,    0,  129,  608,    0,  129, 
          129,    0,  129,    0,  129,    0,    0,    0,  129,    0, 
            0,    0,    0,  129,    0,    0,  129,    0,  608,  615, 
            0,  129,  129,  129,  129,  129,  129,    0,    0,    0, 
          129,    0,  129,  129,    0,  129,  129,  129,  129,    0, 
          129,  129,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,    0,  130,  130,  130, 
          109,  130,  130,  130,  130,  130,  130,  130,    0,  609, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
            0,  130,    0,    0,    0,    0,    0,  130,  130,    0, 
          130,  130,  130,  130,  109,  130,  130,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,    0,    0,    0, 
            0,  109,    0,    0,    0,    0,    0,  508,    0,    0, 
            0,    0,    0,    0,  508,  130,    0,    0,  130,  609, 
            0,  130,  130,    0,  130,    0,  130,    0,  311,    0, 
          130,  303,    0,    0,    0,  130,    0,    0,  130,    0, 
          609,    0,    0,  130,  130,  130,  130,  130,  130,    0, 
            0,    0,  130,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  129,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,    0,  130,  129,  129,  108, 
          129,  129,  129,  129,  129,  129,  129,    0,  615,    0, 
            0,  129,  129,  129,  129,  129,  129,  129,    0,    0, 
          129,    0,    0,    0,    0,    0,  129,  129,    0,  129, 
          129,  129,  129,  108,  129,  129,  129,  129,  129,  129, 
            0,  129,  129,  129,  129,  130,    0,    0,    0,    0, 
          108,    0,    0,    0,    0,    0,  615,    0,    0,    0, 
            0,    0,    0,  615,  129,    0,    0,  129,  611,    0, 
          129,  129,    0,  129,    0,  129,    0,  312,    0,  129, 
          312,    0,    0,    0,  129,    0,    0,  129,    0,  615, 
            0,    0,  129,  129,  129,  129,  129,  129,    0,    0, 
            0,  129,    0,  129,  129,    0,  129,  129,  129,  129, 
            0,  129,  129,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,  356,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,    0,  109, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,  356,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  311,    0,    0,  303,    0, 
            0,    0,  311,  130,    0,  303,  130,  612,    0,  130, 
          130,  109,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,    0,    0, 
            0,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,  633,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,    0,    0,  108,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,  633,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  312,    0,    0,  312,    0,    0, 
            0,  312,  130,    0,  312,  130,    0,    0,  130,  130, 
          108,  130,    0,  130,    0,    0,    0,  130,    0,    0, 
            0,    0,  130,    0,    0,  130,    0,    0,    0,    0, 
          130,  130,  130,  130,  130,  130,    0,    0,    0,  130, 
            0,  130,  130,    0,  130,  130,  130,  130,    0,  130, 
          130,  356,  356,  356,  356,  356,  356,  356,  356,  356, 
          356,  356,    0,  356,  356,  356,  356,  356,  356,  356, 
          356,  356,  356,  356,  633,    0,    0,    0,  356,  356, 
          356,  356,  356,  356,  356,    0,    0,  356,    0,    0, 
            0,    0,    0,  356,  356,    0,  356,  356,  356,  356, 
            0,  356,  356,  356,  356,  356,  356,    0,  356,  356, 
          356,  356,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  633,    0,    0,    0,    0,    0,    0, 
            0,  356,    0,    0,  356,    0,    0,  356,  356,    0, 
          356,    0,  356,    0,    0,    0,  356,    0,    0,    0, 
            0,    0,    0,    0,  356,    0,    0,    0,    0,  356, 
          356,  356,  356,  356,  356,    0,    0,    0,  356,    0, 
          356,  356,    0,  356,  356,  356,  356,    0,  356,  356, 
          633,  633,  633,  633,  633,  633,    0,    0,  633,  633, 
          633,    0,    0,    0,  633,    0,  633,  633,  633,  633, 
          633,  633,  633,  263,    0,    0,    0,  633,  633,  633, 
          633,  633,  633,  633,    0,    0,  633,    0,    0,    0, 
            0,    0,  633,  633,    0,  633,  633,  633,  633,    0, 
          633,  633,  633,  633,  633,  633,    0,  633,  633,  633, 
          633,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  262,    0,    0,    0,    0,    0,    0,    0, 
          633,    0,    0,  633,    0,    0,  633,  633,    0,  633, 
            0,  633,    0,    0,    0,  633,    0,    0,    0,    0, 
            0,    0,    0,  633,    0,    0,    0,    0,  633,  633, 
          633,  633,  633,  633,    0,    0,    0,  633,    0,  633, 
          633,    0,  633,  633,  633,  633,    0,  633,  633,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          633,  633,  633,  633,  633,  633,    0,    0,    0,  633, 
          633,  311,    0,    0,  633,    0,  633,  633,  633,  633, 
          633,  633,  633,    0,    0,    0,    0,  633,  633,  633, 
          633,  633,  633,  633,    0,    0,  633,    0,    0,    0, 
            0,    0,  633,  633,    0,  633,  633,  633,  633,    0, 
          633,  633,  633,  633,  633,  633,    0,  633,  633,  633, 
          633,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          633,    0,    0,  633,    0,    0,  633,  633,    0,  633, 
            0,  633,    0,    0,    0,  633,    0,    0,    0,    0, 
            0,    0,    0,  633,    0,    0,  633,    0,  633,  633, 
          633,  633,  633,  633,    0,    0,    0,  633,    0,  633, 
          633,    0,  633,  633,  633,  633,    0,  633,  633,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  242, 
          243,  244,  245,    0,  432,   26,    0,    0,    0,    0, 
            0,    0,   28,    0,  432,  246,  247,  248,    0,  249, 
           35,  250,  251,  252,  253,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  432,  254, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,  432,  432,   50,  122,    0,  432,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,  432,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  242,  243,  244, 
          245,    0,  431,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,  431,  246,  247,  248,    0,  249,   35,  250, 
          251,  252,  253,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  431,  254,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
          431,  431,   50,    0,    0,  431,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,  431,   65,   66,    0,    0,    0,    0, 
            0,    0,    0,  877,    0,    0,  877,    0,    0,    0, 
            0,    0,  887,    0,    0,  511,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  511,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  432,  432,  432,    0, 
            0,  432,  432,  432,    0,  432,    0,    0,    0,    0, 
            0,    0,    0,    0,  432,  432,  432,    0,    0,  511, 
            0,    0,    0,    0,  432,  432,    0,  432,  432,  432, 
          432,  432,    0,  511,  511,    0,  116,    0,  511,  432, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  432,  432,  432,  432,  432,  432,  432,  432,  432, 
          432,  432,  432,  432,  432,    0,  511,  432,  432,  432, 
            0,    0,  432,    0,    0,  432,    0,    0,  432,    0, 
          432,    0,  432,    0,  432,    0,  432,  432,  432,  432, 
          432,  432,  432,    0,  432,  432,  432,    0,    0,    0, 
            0,    0,  510,    0,    0,    0,    0,    0,  432,    0, 
            0,    0,  510,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  431,  431,  431,    0,    0,  431, 
          431,  431,    0,  431,    0,    0,    0,    0,    0,    0, 
            0,    0,  431,  431,  431,    0,  510,    0,    0,    0, 
            0,    0,  431,  431,    0,  431,  431,  431,  431,  431, 
          510,  510,    0,  115,    0,  510,    0,  431,  887,    0, 
            0,  887,    0,  877,    0,  887,    0,    0,    0,  431, 
          431,  431,  431,  431,  431,  431,  431,  431,  431,  431, 
          431,  431,  431,  510,    0,  431,  431,  431,    0,    0, 
          431,    0,    0,  431,    0,    0,  431,    0,  431,    0, 
          431,    0,  431,    0,  431,  431,  431,  431,  431,  431, 
          431,    0,  431,  431,  431,  421,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  421,  431,  511,  511,  511, 
            0,    0,  511,  511,  511,    0,  511,    0,    0,    0, 
            0,  887,    0,  887,    0,  887,  511,  511,  887,    0, 
            0,    0,    0,    0,    0,  511,  511,    0,  511,  511, 
          511,  511,  511,    0,    0,    0,  887,    0,    0,    0, 
          511,    0,    0,    0,  421,    0,    0,    0,    0,    0, 
            0,    0,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,    0,    0,  511,  511, 
          511,    0,  523,  511,    0,    0,  511,    0,    0,  511, 
            0,  511,    0,  511,    0,  511,    0,  511,  511,  511, 
          511,  511,  511,  511,    0,  511,    0,  511,    0,    0, 
            0,    0,  512,    0,    0,    0,    0,    0,    0,  511, 
            0,    0,  512,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  510,  510,  510,    0,    0,  510, 
          510,  510,    0,  510,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,  510,    0,  512,    0,    0,    0, 
            0,    0,  510,  510,    0,  510,  510,  510,  510,  510, 
          512,  512,    0,  117,    0,  512,    0,  510,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  512,    0,  510,  510,  510,    0,  522, 
          510,    0,    0,  510,    0,    0,  510,    0,  510,    0, 
          510,  513,  510,    0,  510,  510,  510,  510,  510,  510, 
          510,  513,  510,    0,  510,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  510,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  421,  421,  421, 
            0,    0,  421,  421,  421,  513,  421,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  421,    0,    0,  513, 
          513,    0,  118,    0,  513,  421,  421,    0,  421,  421, 
          421,  421,  421,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  421,    0,    0,    0,    0,    0,  515, 
          421,    0,    0,    0,    0,    0,  421,    0,    0,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  421,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  512,  512,  512,    0,    0,  512, 
          512,  512,    0,  512,    0,    0,    0,  515,  515,    0, 
          120,    0,  515,  512,  512,    0,    0,    0,    0,    0, 
            0,    0,  512,  512,    0,  512,  512,  512,  512,  512, 
            0,    0,    0,    0,    0,    0,    0,  512,    0,    0, 
          515,    0,    0,    0,    0,    0,    0,    0,    0,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,    0,    0,  512,  512,  512,    0,  524, 
          512,    0,    0,  512,    0,    0,  512,    0,  512,    0, 
          512,  514,  512,    0,  512,  512,  512,  512,  512,  512, 
          512,  514,  512,    0,  512,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,  513,  513,  512,    0,  513,  513, 
          513,    0,  513,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,  513,    0,  514,    0,    0,    0,    0, 
            0,  513,  513,    0,  513,  513,  513,  513,  513,  514, 
          514,    0,  119,    0,  514,    0,  513,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  514,    0,  513,  513,  513,    0,  525,  513, 
            0,    0,  513,    0,    0,  513,    0,  513,    0,  513, 
          516,  513,    0,  513,  513,  513,  513,  513,  513,  513, 
          516,  513,    0,  513,    0,    0,    0,    0,    0,    0, 
            0,  515,  515,  515,    0,  513,  515,  515,  515,    0, 
          515,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          515,  515,    0,    0,  516,    0,    0,    0,    0,  515, 
          515,    0,  515,  515,  515,  515,  515,    0,  516,  516, 
            0,  121,    0,  516,  515,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
            0,  516,  515,  515,  515,    0,  527,  515,    0,    0, 
          515,    0,    0,  515,    0,  515,    0,  515,  507,  515, 
            0,  515,  515,  515,  515,  515,  515,  515,  507,  515, 
            0,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  507,  514,  514,  514,    0,    0,  514,  514, 
          514,    0,  514,    0,    0,    0,  507,  507,    0,  112, 
            0,  507,  514,  514,    0,    0,    0,    0,    0,    0, 
            0,  514,  514,    0,  514,  514,  514,  514,  514,    0, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,  507, 
            0,    0,    0,    0,    0,    0,    0,    0,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,    0,    0,  514,  514,  514,    0,  526,  514, 
            0,    0,  514,    0,    0,  514,    0,  514,    0,  514, 
          506,  514,    0,  514,  514,  514,  514,  514,  514,  514, 
          506,  514,    0,  514,    0,    0,    0,    0,    0,    0, 
            0,    0,  516,  516,  516,  514,    0,  516,  516,  516, 
            0,  516,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  516,  516,    0,  506,    0,    0,    0,    0,    0, 
          516,  516,    0,  516,  516,  516,  516,  516,  506,  506, 
            0,  111,    0,  506,    0,  516,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  506,    0,  516,  516,  516,    0,  528,  516,    0, 
            0,  516,    0,    0,  516,    0,  516,    0,  516,  509, 
          516,    0,  516,  516,  516,  516,  516,  516,  516,  509, 
          516,    0,  516,    0,    0,    0,    0,    0,    0,    0, 
          507,  507,  507,    0,  516,  507,  507,  507,    0,  507, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  507, 
          507,    0,    0,  509,    0,    0,    0,    0,  507,  507, 
            0,  507,  507,  507,  507,  507,    0,  509,  509,    0, 
          114,    0,  509,  507,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  507,  507,  507,  507,  507, 
          507,  507,  507,  507,  507,  507,  507,  507,  507,    0, 
          509,  507,  507,  507,    0,  519,  507,    0,    0,  507, 
            0,    0,  507,    0,  507,    0,  507,  633,  507,    0, 
          507,  507,  507,  507,  507,  507,  507,  633,  507,    0, 
          507,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  507,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  633,  506,  506,  506,    0,    0,  506,  506,  506, 
            0,  506,    0,    0,    0,  633,  633,    0,    0,    0, 
          633,  506,  506,    0,    0,    0,    0,    0,    0,    0, 
          506,  506,    0,  506,  506,  506,  506,  506,    0,    0, 
            0,    0,    0,    0,    0,  506,    0,    0,  633,    0, 
            0,    0,    0,    0,    0,    0,    0,  506,  506,  506, 
          506,  506,  506,  506,  506,  506,  506,  506,  506,  506, 
          506,    0,    0,  506,  506,  506,    0,  518,  506,    0, 
            0,  506,    0,    0,  506,    0,  506,    0,  506,  303, 
          506,    0,  506,  506,  506,  506,  506,  506,  506,  303, 
          506,    0,  506,    0,    0,    0,    0,    0,    0,    0, 
            0,  509,  509,  509,  506,    0,  509,  509,  509,    0, 
          509,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          509,  509,    0,  303,    0,    0,    0,    0,    0,  509, 
          509,    0,  509,  509,  509,  509,  509,  303,  303,    0, 
          128,    0,  303,    0,  509,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  509,  509,  509,  509, 
          509,  509,  509,  509,  509,  509,  509,  509,  509,  509, 
          303,    0,  509,  509,  509,    0,  521,  509,    0,    0, 
          509,    0,    0,  509,    0,  509,    0,  509,  312,  509, 
            0,  509,  509,  509,  509,  509,  509,  509,  312,  509, 
            0,  509,    0,    0,    0,    0,    0,    0,    0,  633, 
          633,  633,    0,  509,  633,  633,  633,    0,  633,    0, 
            0,    0,    0,    0,    0,    0,    0,  633,  633,  633, 
            0,    0,  312,    0,    0,    0,    0,  633,  633,    0, 
          633,  633,  633,  633,  633,    0,  312,  312,    0,  127, 
            0,  312,  633,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  633,  633,  633,  633,  633,  633, 
          633,  633,  633,  633,  633,  633,  633,  633,    0,  312, 
          633,  633,  633,    0,    0,  633,    0,    0,  633,    0, 
            0,  633,    0,  633,    0,  633,  452,  633,    0,  633, 
          633,  633,  633,  633,  633,  633,  452,  633,  633,  633, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  633,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          452,  303,  303,  303,    0,    0,  303,  303,  303,    0, 
          303,    0,    0,    0,  452,  452,    0,    0,    0,  452, 
          303,  303,    0,    0,    0,    0,    0,    0,    0,  303, 
          303,    0,  303,  303,  303,  303,  303,    0,    0,    0, 
            0,    0,    0,    0,  303,    0,    0,  452,    0,    0, 
            0,    0,    0,    0,    0,    0,  303,  303,  303,  303, 
          303,  303,  303,  303,  303,  303,  303,  303,  303,  303, 
            0,    0,  303,  303,  303,    0,    0,  303,    0,    0, 
          303,    0,    0,  303,    0,  303,    0,  303,  323,  303, 
            0,  303,  303,  303,  303,  303,  303,  303,  323,  303, 
            0,  303,    0,    0,    0,    0,    0,    0,    0,    0, 
          312,  312,  312,  303,    0,  312,  312,  312,    0,  312, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  312, 
          312,    0,  323,    0,    0,    0,    0,    0,  312,  312, 
            0,  312,  312,  312,  312,  312,  323,  323,    0,    0, 
            0,  323,    0,  312,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  312,  312,  312,  312,  312, 
          312,  312,  312,  312,  312,  312,  312,  312,  312,  323, 
            0,  312,  312,  312,    0,    0,  312,    0,    0,  312, 
            0,    0,  312,    0,  312,    0,  312,  261,  312,    0, 
          312,  312,  312,  312,  312,  312,  312,  261,  312,    0, 
          312,    0,    0,    0,    0,    0,    0,    0,  452,  452, 
          452,    0,  312,  452,  452,  452,    0,  452,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  452,  452,    0, 
            0,  261,    0,    0,    0,    0,  452,  452,    0,  452, 
          452,  452,  452,  452,    0,  261,  261,    0,    0,    0, 
          261,  452,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  452,  452,  452,  452,  452,  452,  452, 
          452,  452,  452,  452,  452,  452,  452,    0,  355,  452, 
          452,  452,    0,    0,  452,    0,    0,  452,    0,    0, 
          452,    0,  452,    0,  452,  318,  452,    0,  452,  452, 
          452,  452,  452,  452,  452,  318,  452,    0,  452,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          452,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  318, 
          323,  323,  323,    0,    0,  323,  323,  323,    0,  323, 
            0,    0,    0,  318,  318,    0,    0,    0,  318,  323, 
          323,    0,    0,    0,    0,    0,    0,    0,  323,  323, 
            0,  323,  323,  323,  323,  323,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,  318,    0,    0,    0, 
            0,    0,    0,    0,    0,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,    0, 
            0,  323,  323,  323,    0,    0,  323,    0,    0,  323, 
            0,    0,  323,    0,  323,    0,  323,  500,  323,    0, 
          323,  323,  323,  323,  323,  323,  323,  500,  323,    0, 
          323,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
          261,  261,  323,    0,  261,  261,  261,    0,  261,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  261,  261, 
            0,  500,    0,    0,    0,    0,    0,  261,  261,    0, 
          261,  261,  261,  261,  261,  500,  500,    0,    0,    0, 
          500,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  261,  261,  261,  261,  261,  261, 
          261,  261,  261,  261,  261,  355,  261,  261,  500,    0, 
          261,  261,  355,    0,    0,  261,    0,    0,  261,    0, 
            0,  261,    0,  261,    0,  261,  239,  261,    0,  261, 
          261,  261,  261,  261,  261,  261,  239,  261,    0,  261, 
            0,    0,    0,    0,    0,    0,    0,  318,  318,  318, 
            0,  261,  318,  318,  318,    0,  318,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  318,  318,    0,    0, 
          239,    0,    0,    0,    0,  318,  318,    0,  318,  318, 
          318,  318,  318,    0,  239,  239,    0,    0,    0,  239, 
          318,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,  318,    0,    0,  318,  318, 
          318,    0,    0,  318,    0,    0,  318,    0,    0,  318, 
            0,  318,    0,  318,  236,  318,    0,  318,  318,  318, 
          318,  318,  318,  318,  236,  318,    0,  318,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  318, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  236,  500, 
          500,  500,    0,    0,  500,  500,  500,    0,  500,    0, 
            0,    0,  236,  236,    0,    0,    0,  236,  500,  500, 
            0,    0,    0,    0,    0,    0,    0,  500,  500,    0, 
          500,  500,  500,  500,  500,    0,    0,    0,    0,    0, 
            0,    0,  500,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  500,  500,  500,  500,  500, 
          500,  500,  500,  500,  500,  500,  500,  500,    0,    0, 
          500,  500,  500,    0,    0,  500,    0,    0,  500,    0, 
            0,  500,    0,  500,    0,  500,  233,  500,    0,  500, 
          500,  500,  500,  500,  500,  500,  233,  500,    0,  500, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,  239, 
          239,  500,    0,  239,  239,  239,    0,  239,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  239,  239,    0, 
          233,    0,    0,    0,    0,    0,  239,  239,    0,  239, 
          239,  239,  239,  239,  233,  233,    0,    0,    0,  233, 
            0,  239,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  239,  239,  239,  239,  239,  239, 
          239,  239,  239,  239,    0,  239,  239,    0,    0,  239, 
          239,    0,    0,    0,  239,    0,    0,  239,    0,    0, 
          239,    0,  239,    0,  239,  235,  239,    0,  239,  239, 
          239,  239,  239,  239,  239,  235,  239,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,  236,  236,  236,    0, 
          239,  236,  236,  236,    0,  236,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  236,  236,    0,    0,  235, 
            0,    0,    0,    0,  236,  236,    0,  236,  236,  236, 
          236,  236,    0,  235,  235,    0,    0,    0,  235,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  236,  236,  236,  236,  236,  236,  236,  236, 
          236,  236,    0,  236,  236,    0,    0,  236,  236,    0, 
            0,    0,  236,    0,    0,  236,    0,    0,  236,    0, 
          236,    0,  236,  234,  236,    0,  236,  236,  236,  236, 
          236,  236,  236,  234,  236,    0,  236,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  236,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  233,  233, 
          233,    0,    0,  233,  233,  233,    0,  233,    0,    0, 
            0,  234,  234,    0,    0,    0,  234,  233,  233,    0, 
            0,    0,    0,    0,    0,    0,  233,  233,    0,  233, 
          233,  233,  233,  233,    0,    0,    0,    0,    0,    0, 
            0,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  233,  233,  233,  233,  233,  233, 
          233,  233,  233,  233,    0,  233,  233,    0,    0,  233, 
          233,  237,    0,    0,  233,    0,    0,  233,    0,    0, 
          233,  237,  233,    0,  233,    0,  233,    0,  233,  233, 
          233,  233,  233,  233,  233,    0,  233,    0,  233,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,  235,  235,  235, 
          233,    0,  235,  235,  235,  237,  235,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,  235,    0,  237, 
          237,    0,    0,    0,  237,  235,  235,    0,  235,  235, 
          235,  235,  235,    0,    0,    0,    0,    0,    0,    0, 
          235,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,  235,  235,  235,  235,  235,  235, 
          235,  235,  235,    0,  235,  235,    0,    0,  235,  235, 
            0,    0,    0,  235,    0,    0,  235,    0,    0,  235, 
            0,  235,    0,  235,  231,  235,    0,  235,  235,  235, 
          235,  235,  235,  235,  231,  235,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,  234,  234,  234,    0,  235, 
          234,  234,  234,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,  234,    0,    0,  231,    0, 
            0,    0,    0,  234,  234,    0,  234,  234,  234,  234, 
          234,    0,  231,  231,    0,    0,    0,  231,  234,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  234,  234,  234,  234,  234,  234,  234,  234,  234, 
          234,    0,  234,  234,    0,    0,  234,  234,    0,    0, 
            0,  234,    0,    0,  234,    0,    0,  234,    0,  234, 
            0,  234,    0,  234,    0,  234,  234,  234,  234,  234, 
          234,  234,  232,  234,    0,  234,    0,    0,    0,    0, 
            0,    0,  232,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,    0,  237,  237,  237,    0,    0,  237,  237, 
          237,    0,  237,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  237,  237,    0,    0,  232,    0,    0,    0, 
            0,  237,  237,    0,  237,  237,  237,  237,  237,    0, 
          232,  232,    0,    0,    0,  232,  237,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,  237,    0, 
          237,  237,    0,    0,  237,  237,    0,    0,    0,  237, 
            0,    0,  237,    0,    0,  237,    0,  237,    0,  237, 
          255,  237,    0,  237,  237,  237,  237,  237,  237,  237, 
          255,  237,    0,  237,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  231,  231,  231,    0, 
            0,  231,  231,  231,  255,  231,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  231,  231,    0,  255,  255, 
            0,    0,    0,  255,  231,  231,    0,  231,  231,  231, 
          231,  231,    0,    0,    0,    0,    0,    0,    0,  231, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  231,  231,  231,  231,  231,  231,  231,  231, 
          231,  231,    0,  231,  231,    0,    0,  231,  231,  256, 
            0,    0,  231,    0,    0,  231,    0,    0,  231,  256, 
          231,    0,    0,    0,  231,    0,    0,    0,  231,  231, 
          231,  231,  231,    0,  231,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  231,    0, 
            0,    0,    0,  256,  232,  232,  232,    0,    0,  232, 
          232,  232,    0,  232,    0,    0,    0,  256,  256,    0, 
            0,    0,  256,  232,  232,    0,    0,    0,    0,    0, 
            0,    0,  232,  232,    0,  232,  232,  232,  232,  232, 
            0,    0,    0,    0,    0,    0,    0,  232,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          232,  232,  232,  232,  232,  232,  232,  232,  232,  232, 
            0,  232,  232,    0,    0,  232,  232,    0,    0,  242, 
          232,    0,    0,  232,    0,    0,  232,    0,  232,  242, 
            0,    0,  232,    0,    0,    0,  232,  232,  232,  232, 
          232,    0,  232,    0,  232,    0,    0,    0,    0,    0, 
            0,    0,  255,  255,  255,    0,  232,  255,  255,  255, 
            0,  255,    0,  242,    0,    0,    0,    0,    0,    0, 
            0,  255,  255,    0,    0,    0,    0,  242,  242,    0, 
          255,  255,  242,  255,  255,  255,  255,  255,    0,    0, 
            0,    0,    0,    0,    0,  255,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  255,  255, 
          255,  255,  255,  255,  255,  255,  255,  255,    0,  255, 
          255,    0,    0,  255,  255,    0,    0,    0,  255,    0, 
            0,  255,    0,    0,  255,    0,  255,    0,    0,  240, 
          255,    0,    0,    0,    0,    0,  255,  255,  255,  240, 
          255,    0,  255,    0,    0,    0,    0,    0,    0,    0, 
            0,  256,  256,  256,  255,    0,  256,  256,  256,    0, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,  256,    0,  240,    0,    0,    0,    0,    0,  256, 
          256,    0,  256,  256,  256,  256,  256,  240,  240,    0, 
            0,    0,  240,    0,  256,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  256,  256,  256, 
          256,  256,  256,  256,  256,  256,  256,    0,  256,  256, 
            0,    0,  256,  256,    0,    0,    0,  256,    0,    0, 
          256,    0,    0,  256,    0,  256,    0,    0,  241,  256, 
            0,    0,    0,    0,    0,  256,  256,  256,  241,  256, 
            0,  256,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  256,    0,    0,    0,    0,    0,    0, 
            0,  242,  242,  242,    0,    0,  242,  242,  242,    0, 
          242,    0,  241,    0,    0,    0,    0,    0,    0,    0, 
          242,  242,    0,    0,    0,    0,  241,  241,    0,  242, 
          242,  241,  242,  242,  242,  242,  242,    0,    0,    0, 
            0,    0,    0,    0,  242,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  242,  242,  242, 
          242,  242,  242,  242,  242,  242,  242,    0,  242,  242, 
            0,    0,    0,    0,    0,    0,  245,  242,    0,    0, 
          242,    0,    0,  242,    0,  242,  245,    0,    0,  242, 
            0,    0,    0,    0,    0,  242,  242,  242,    0,  242, 
            0,  242,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  242,    0,    0,    0,    0,    0,    0, 
          245,  240,  240,  240,    0,    0,  240,  240,  240,    0, 
          240,    0,    0,    0,  245,  245,    0,    0,    0,  245, 
          240,  240,    0,    0,    0,    0,    0,    0,    0,  240, 
          240,    0,  240,  240,  240,  240,  240,    0,    0,    0, 
            0,    0,    0,    0,  240,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  240,  240,  240, 
          240,  240,  240,  240,  240,  240,  240,    0,  240,  240, 
            0,    0,    0,    0,  247,    0,    0,  240,    0,    0, 
          240,    0,    0,  240,  247,  240,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  240,  240,  240,    0,  240, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
          241,  241,  241,  240,    0,  241,  241,  241,  247,  241, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  241, 
          241,    0,  247,  247,    0,    0,    0,  247,  241,  241, 
            0,  241,  241,  241,  241,  241,    0,    0,    0,    0, 
            0,    0,    0,  241,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  241,  241,  241,  241, 
          241,  241,  241,  241,  241,  241,    0,  241,  241,    0, 
            0,    0,    0,    0,    0,    0,  241,    0,    0,  241, 
            0,    0,  241,    0,  241,    0,    0,  246,    0,    0, 
            0,    0,    0,    0,  241,  241,  241,  246,  241,    0, 
          241,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
          245,    0,  241,  245,  245,  245,    0,  245,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  245,  245,    0, 
            0,  246,    0,    0,    0,    0,  245,  245,    0,  245, 
          245,  245,  245,  245,    0,  246,  246,    0,    0,    0, 
          246,  245,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  245,  245,  245,  245,  245,  245, 
          245,  245,  245,  245,    0,  245,  245,    0,    0,    0, 
            0,    0,    0,    0,  245,    0,    0,  245,    0,    0, 
          245,    0,  245,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  245,  245,  244,    0,    0,    0,  245,    0, 
            0,    0,    0,    0,  244,    0,    0,    0,    0,    0, 
          245,    0,    0,    0,    0,    0,  247,  247,  247,    0, 
            0,  247,  247,  247,    0,  247,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,  247,    0,  244,    0, 
            0,    0,    0,    0,  247,  247,    0,  247,  247,  247, 
          247,  247,  244,  244,    0,    0,    0,  244,    0,  247, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,  247,  247,  247,  247,  247,  247,  247, 
          247,  247,    0,  247,  247,    0,    0,    0,    0,    0, 
            0,  243,  247,    0,    0,  247,    0,    0,  247,    0, 
          247,  243,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,  247,    0,    0,    0,    0,  247,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,    0,    0,    0,    0,  243,    0,    0,    0,  246, 
          246,  246,    0,    0,  246,  246,  246,    0,  246,  243, 
          243,    0,    0,    0,  243,    0,    0,    0,  246,  246, 
            0,    0,    0,    0,    0,    0,    0,  246,  246,    0, 
          246,  246,  246,  246,  246,    0,    0,    0,  248,    0, 
            0,    0,  246,    0,    0,    0,    0,    0,  248,    0, 
            0,    0,    0,    0,    0,  246,  246,  246,  246,  246, 
          246,  246,  246,  246,  246,    0,  246,  246,    0,    0, 
            0,    0,    0,    0,    0,  246,    0,    0,  246,    0, 
            0,  246,  248,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  246,  246,    0,  248,  248,    0,  246, 
            0,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,  244,  244,  244,    0, 
            0,  244,  244,  244,    0,  244,    0,  249,    0,    0, 
            0,    0,    0,    0,    0,  244,  244,  249,    0,    0, 
            0,    0,    0,    0,  244,  244,    0,  244,  244,  244, 
          244,  244,    0,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  249,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,  244,    0,  244,  244,  249,  249,    0,    0,    0, 
          249,    0,  244,    0,    0,  244,    0,    0,  244,    0, 
          244,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,    0,  243,  243,  243,  244,    0,  243,  243, 
          243,    0,  243,    0,  250,    0,    0,    0,  244,    0, 
            0,    0,  243,  243,  250,    0,    0,    0,    0,    0, 
            0,  243,  243,    0,  243,  243,  243,  243,  243,    0, 
            0,    0,    0,    0,    0,    0,  243,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,    0,    0,    0,    0,  243,  243,    0,    0,    0, 
          243,  243,  250,  250,    0,    0,    0,  250,    0,  243, 
            0,    0,  243,    0,    0,  243,    0,  243,    0,    0, 
          248,  248,  248,    0,    0,  248,  248,  248,    0,  248, 
            0,  257,    0,  243,    0,    0,    0,    0,    0,  248, 
          248,  257,    0,    0,    0,  243,    0,    0,  248,  248, 
            0,  248,  248,  248,  248,  248,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  257,    0,    0,    0,    0, 
            0,    0,  248,  248,    0,    0,    0,  248,  248,  257, 
          257,    0,    0,    0,  257,    0,  248,    0,    0,  248, 
            0,    0,  248,    0,  248,    0,    0,    0,    0,  249, 
          249,  249,    0,    0,  249,  249,  249,    0,  249,    0, 
          248,  251,    0,    0,    0,    0,    0,    0,  249,  249, 
            0,  251,  248,    0,    0,    0,    0,  249,  249,    0, 
          249,  249,  249,  249,  249,    0,    0,    0,    0,    0, 
            0,    0,  249,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  251,    0,    0,    0,    0, 
            0,  249,  249,    0,    0,    0,  249,  249,    0,  251, 
          251,    0,    0,    0,  251,  249,    0,    0,  249,    0, 
            0,  249,    0,  249,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  250,  250,  250,  249, 
            0,  250,  250,  250,    0,  250,    0,  252,    0,    0, 
            0,  249,    0,    0,    0,  250,  250,  252,    0,    0, 
            0,    0,    0,    0,  250,  250,    0,  250,  250,  250, 
          250,  250,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  252,    0,    0,    0,    0,    0,    0,  250,  250, 
            0,    0,    0,  250,  250,  252,  252,    0,    0,    0, 
          252,    0,  250,    0,    0,  250,    0,    0,  250,    0, 
          250,    0,    0,  257,  257,  257,    0,    0,  257,  257, 
          257,    0,  257,    0,  258,    0,  250,    0,    0,    0, 
            0,    0,  257,  257,  258,    0,    0,    0,  250,    0, 
            0,  257,  257,    0,  257,  257,  257,  257,  257,    0, 
            0,    0,    0,    0,    0,    0,  257,    0,    0,    0, 
            0,    0,   43,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,   43,    0,    0,  257,  257,    0,    0,    0, 
          257,  257,  258,  258,    0,    0,    0,  258,    0,  257, 
            0,    0,  257,    0,    0,  257,    0,  257,    0,    0, 
            0,    0,    0,  251,  251,  251,    0,    0,  251,  251, 
          251,    0,  251,  257,  229,    0,    0,    0,    0,    0, 
            0,   43,  251,  251,  229,  257,    0,    0,    0,    0, 
            0,  251,  251,    0,  251,  251,  251,  251,  251,    0, 
            0,    0,    0,    0,    0,    0,  251,    0,    0,    0, 
            0,    0,    0,    0,  230,    0,    0,    0,  229,    0, 
            0,    0,    0,    0,  230,  251,  251,    0,    0,    0, 
          251,  251,  229,  229,    0,    0,    0,  229,    0,  251, 
            0,    0,  251,    0,    0,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  230,  252, 
          252,  252,    0,  251,  252,  252,  252,    0,  252,    0, 
            0,    0,  230,  230,    0,  251,    0,  230,  252,  252, 
            0,    0,    0,    0,    0,    0,    0,  252,  252,    0, 
          252,  252,  252,  252,  252,    0,    0,    0,    0,    0, 
            0,    0,  252,    0,    0,    0,    0,    0,    0,    0, 
          259,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          259,  252,  252,    0,    0,    0,  252,  252,    0,    0, 
            0,    0,    0,    0,    0,  252,    0,    0,  252,    0, 
            0,  252,    0,  252,    0,    0,  258,  258,  258,    0, 
            0,  258,  258,  258,  259,  258,    0,    0,    0,  252, 
            0,    0,    0,    0,    0,  258,  258,    0,  259,  259, 
            0,  252,    0,    0,  258,  258,    0,  258,  258,  258, 
          258,  258,    0,    0,   43,   43,   43,    0,    0,  258, 
           43,   43,    0,   43,    0,  228,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  228,    0,    0,    0,  258, 
            0,    0,    0,  258,  258,   43,   43,   43,   43,   43, 
            0,    0,  258,    0,    0,  258,    0,    0,  258,    0, 
          258,    0,    0,    0,    0,    0,  229,  229,  229,  228, 
            0,  229,  229,  229,    0,  229,  258,    0,    0,    0, 
            0,    0,    0,  228,  228,  229,  229,    0,  258,    0, 
            0,    0,    0,   43,  229,  229,    0,  229,  229,  229, 
          229,  229,    0,    0,    0,    0,  230,  230,  230,  229, 
          227,  230,  230,  230,   43,  230,    0,    0,    0,    0, 
          227,    0,    0,    0,    0,  230,  230,    0,    0,    0, 
            0,    0,    0,    0,  230,  230,    0,  230,  230,  230, 
          230,  230,  229,    0,    0,  229,    0,    0,  229,  230, 
          229,    0,    0,    0,  227,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  229,    0,  227,  227, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,    0,  230,    0,    0,  230,    0,    0,  230,    0, 
          230,    0,    0,    0,    0,  223,    0,    0,    0,    0, 
            0,    0,  259,  259,  259,  223,  230,  259,  259,  259, 
            0,  259,    0,    0,    0,    0,    0,    0,  230,    0, 
            0,  259,  259,    0,    0,    0,    0,    0,    0,    0, 
          259,  259,    0,  259,  259,  259,  259,  259,    0,  223, 
            0,    0,    0,    0,    0,  259,    0,    0,    0,    0, 
            0,    0,    0,  223,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  259,    0, 
          224,  259,    0,    0,  259,    0,  259,  228,  228,  228, 
          224,    0,  228,  228,  228,    0,  228,    0,    0,    0, 
            0,    0,  259,    0,    0,    0,  228,  228,    0,    0, 
            0,    0,    0,    0,  259,  228,  228,    0,  228,  228, 
          228,  228,  228,    0,  224,    0,    0,    0,    0,    0, 
          228,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,    0,  225,  228,    0,    0,  228, 
            0,  228,  227,  227,  227,  225,    0,  227,  227,  227, 
            0,  227,    0,    0,    0,    0,    0,  228,    0,    0, 
            0,  227,  227,    0,    0,    0,    0,    0,    0,  228, 
          227,  227,    0,  227,  227,  227,  227,  227,    0,  225, 
            0,    0,    0,    0,    0,  227,    0,    0,    0,    0, 
            0,    0,    0,  225,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,    0, 
          226,  227,    0,    0,  227,    0,  227,  223,  223,  223, 
          226,    0,  223,  223,  223,    0,  223,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,  223,  223,    0,    0, 
            0,    0,    0,    0,  227,  223,  223,    0,  223,  223, 
          223,  223,  223,    0,  226,    0,    0,    0,    0,    0, 
          223,    0,    0,    0,    0,    0,    0,    0,  226,  226, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,  219,  223,    0,    0,  223, 
            0,  223,  224,  224,  224,  219,    0,  224,  224,  224, 
            0,  224,    0,    0,    0,    0,    0,  223,    0,    0, 
            0,  224,  224,    0,    0,    0,    0,    0,    0,  223, 
          224,  224,    0,  224,  224,  224,  224,  224,    0,  219, 
            0,    0,    0,    0,    0,  224,    0,    0,    0,    0, 
            0,    0,    0,  219,  219,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
          221,  224,    0,    0,  224,    0,  224,  225,  225,  225, 
          221,    0,  225,  225,  225,    0,  225,    0,    0,    0, 
            0,    0,  224,    0,    0,    0,  225,  225,    0,    0, 
            0,    0,    0,    0,  224,  225,  225,    0,  225,  225, 
          225,  225,  225,    0,  221,    0,    0,    0,    0,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,  221,  221, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,  260,  225,    0,    0,  225, 
            0,  225,  226,  226,  226,  260,    0,  226,  226,  226, 
            0,  226,    0,    0,    0,    0,    0,  225,    0,    0, 
            0,  226,  226,    0,    0,    0,    0,    0,    0,  225, 
          226,  226,    0,  226,  226,  226,  226,  226,    0,  260, 
            0,    0,    0,    0,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,  260,  260,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  226,    0, 
          222,  226,    0,    0,  226,    0,  226,  219,  219,  219, 
          222,    0,  219,  219,  219,    0,  219,    0,    0,    0, 
            0,    0,  226,    0,    0,    0,  219,  219,    0,    0, 
            0,    0,    0,    0,  226,  219,  219,    0,  219,  219, 
          219,  219,  219,    0,  222,    0,    0,    0,    0,    0, 
          219,    0,    0,    0,    0,    0,    0,    0,  222,  222, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  219,    0,  262,  219,    0,    0,  219, 
            0,  219,  221,  221,  221,  262,    0,  221,  221,  221, 
            0,  221,    0,    0,    0,    0,    0,  219,    0,    0, 
            0,  221,  221,    0,    0,    0,    0,    0,    0,  219, 
          221,  221,    0,  221,  221,  221,  221,  221,    0,  262, 
            0,    0,    0,    0,    0,  221,    0,    0,    0,    0, 
            0,    0,    0,  218,  262,    0,    0,    0,    0,    0, 
            0,    0,    0,  218,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  221,    0, 
            0,  221,    0,    0,  221,    0,  221,  260,  260,  260, 
            0,    0,  260,  260,  260,    0,  260,  218,    0,    0, 
            0,    0,  221,    0,    0,    0,  260,  260,    0,    0, 
            0,  218,  218,    0,  221,  260,  260,    0,  260,  260, 
          260,  260,  260,    0,    0,    0,    0,    0,    0,    0, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,  351, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  351, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  260,    0,    0,  260,    0,    0,  260, 
            0,  260,  222,  222,  222,    0,    0,  222,  222,  222, 
            0,  222,    0,  351,    0,    0,    0,  260,    0,    0, 
            0,  222,  222,    0,    0,    0,    0,    0,  351,  260, 
          222,  222,  351,  222,  222,  222,  222,  222,    0,    0, 
            0,    0,    0,    0,    0,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          351,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  222,    0, 
            0,  222,    0,    0,  222,    0,  222,  262,  262,  262, 
          352,    0,  262,  262,  262,    0,  262,    0,    0,    0, 
          352,    0,  222,    0,    0,    0,  262,  262,    0,    0, 
            0,    0,    0,    0,  222,  262,  262,    0,  262,  262, 
          262,  262,  262,    0,    0,    0,    0,    0,    0,    0, 
          262,    0,    0,    0,  352,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  218,  218,  218,    0,  352, 
          218,  218,  218,  352,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,  262,  218,  218,  262,    0,    0,  262, 
            0,  262,    0,  218,  218,    0,  218,  218,  218,  218, 
            0,  352,    0,    0,    0,    0,    0,  262,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  262, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  315, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  315, 
            0,  218,    0,    0,  218,    0,    0,  218,    0,  218, 
            0,  351,  351,  351,    0,    0,  351,  351,  351,    0, 
          351,    0,    0,    0,    0,  218,    0,    0,    0,    0, 
          351,  351,    0,  315,    0,    0,    0,  218,    0,  351, 
          351,    0,  351,  351,  351,  351,  351,    0,  315,    0, 
            0,    0,  315,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  351,  351,  351,  351, 
          351,  351,  351,  351,  351,  351,  351,  351,  351,  351, 
          315,    0,  351,  351,  351,    0,    0,  351,    0,    0, 
          351,    0,    0,  351,    0,  351,    0,  351,    0,  351, 
            0,  351,  351,  351,  351,  351,  351,  351,    0,  351, 
          432,  351,    0,    0,    0,    0,    0,    0,    0,    0, 
          432,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  352,  352,  352,    0,    0,  352,  352,  352, 
            0,  352,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  352,  352,    0,  103,    0,    0,    0,    0,    0, 
          352,  352,    0,  352,  352,  352,  352,  352,    0,  432, 
            0,  122,    0,  432,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  352,  352,  352, 
          352,  352,  352,  352,  352,  352,  352,  352,  352,  352, 
          352,  432,    0,  352,  352,  352,    0,    0,  352,    0, 
            0,  352,    0,    0,  352,    0,  352,    0,  352,    0, 
          352,    0,  352,  352,  352,  352,  352,  352,  352,  511, 
          352,    0,  352,    0,    0,    0,    0,    0,    0,  511, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  315,  315,  315,    0,    0,  315,  315,  315,    0, 
          315,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          315,  315,    0,   97,    0,    0,    0,    0,    0,  315, 
          315,    0,  315,  315,  315,  315,  315,    0,  511,    0, 
          116,    0,  511,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          511,    0,  315,  315,  315,    0,    0,  315,    0,    0, 
          315,    0,    0,  315,    0,  315,    0,  315,    0,  315, 
            0,  315,  315,  315,  315,  315,  315,  315,    0,  315, 
          510,  315,    0,    0,    0,    0,    0,    0,    0,    0, 
          510,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  432,  432,  432,    0,    0,    0,  432,  432, 
            0,  432,    0,    0,    0,    0,    0,    0,    0,    0, 
          432,    0,    0,    0,   96,    0,    0,    0,    0,    0, 
          432,  432,    0,  432,  432,  432,  432,  432,    0,  510, 
            0,  115,    0,  510,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  432,  432,  432, 
          432,  432,  432,  432,  432,  432,  432,  432,  432,  432, 
          432,  510,    0,  432,  432,  432,    0,    0,    0,    0, 
            0,  432,    0,    0,    0,    0,    0,    0,  432,    0, 
          432,    0,  432,  432,  432,  432,  432,  432,  432,  512, 
          432,  432,  432,    0,    0,    0,    0,    0,    0,  512, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,  511,  511,    0,    0,    0,  511,  511,    0, 
          511,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   98,    0,    0,    0,    0,    0,  511, 
          511,    0,  511,  511,  511,  511,  511,    0,  512,    0, 
          117,    0,  512,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          512,    0,  511,  511,  511,    0,  523,    0,    0,    0, 
          511,    0,    0,    0,    0,    0,    0,  511,    0,  511, 
            0,  511,  511,  511,  511,  511,  511,  511,    0,  511, 
          513,  511,    0,    0,    0,    0,    0,    0,    0,    0, 
          513,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  510,  510,  510,    0,    0,    0,  510,  510, 
            0,  510,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   99,    0,    0,    0,    0,    0, 
          510,  510,    0,  510,  510,  510,  510,  510,    0,  513, 
            0,  118,    0,  513,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
          510,  513,    0,  510,  510,  510,    0,  522,    0,    0, 
            0,  510,    0,    0,    0,    0,    0,    0,  510,    0, 
          510,    0,  510,  510,  510,  510,  510,  510,  510,  515, 
          510,    0,  510,    0,    0,    0,    0,    0,    0,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  512,  512,  512,    0,    0,    0,  512,  512,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,    0,    0,    0,  512, 
          512,    0,  512,  512,  512,  512,  512,    0,  515,    0, 
          120,    0,  515,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          515,    0,  512,  512,  512,    0,  524,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,    0,  512,    0,  512, 
            0,  512,  512,  512,  512,  512,  512,  512,    0,  512, 
          514,  512,    0,    0,    0,    0,    0,    0,    0,    0, 
          514,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,  513,  513,    0,    0,    0,  513,  513, 
            0,  513,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  100,    0,    0,    0,    0,    0, 
          513,  513,    0,  513,  513,  513,  513,  513,    0,  514, 
            0,  119,    0,  514,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  514,    0,  513,  513,  513,    0,  525,    0,    0, 
            0,  513,    0,    0,    0,    0,    0,    0,  513,    0, 
          513,    0,  513,  513,  513,  513,  513,  513,  513,  516, 
          513,    0,  513,    0,    0,    0,    0,    0,    0,  516, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,  515,  515,    0,    0,    0,  515,  515,    0, 
          515,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  102,    0,    0,    0,    0,    0,  515, 
          515,    0,  515,  515,  515,  515,  515,    0,  516,    0, 
          121,    0,  516,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          516,    0,  515,  515,  515,    0,  527,    0,    0,    0, 
          515,    0,    0,    0,    0,    0,    0,  515,    0,  515, 
            0,  515,  515,  515,  515,  515,  515,  515,    0,  515, 
          507,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
          507,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  514,  514,  514,    0,    0,    0,  514,  514, 
            0,  514,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   93,    0,    0,    0,    0,    0, 
          514,  514,    0,  514,  514,  514,  514,  514,    0,  507, 
            0,  112,    0,  507,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  507,    0,  514,  514,  514,    0,  526,    0,    0, 
            0,  514,    0,    0,    0,    0,    0,    0,  514,    0, 
          514,    0,  514,  514,  514,  514,  514,  514,  514,  506, 
          514,    0,  514,    0,    0,    0,    0,    0,    0,  506, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  516,  516,  516,    0,    0,    0,  516,  516,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   92,    0,    0,    0,    0,    0,  516, 
          516,    0,  516,  516,  516,  516,  516,    0,  506,    0, 
          111,    0,  506,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          506,    0,  516,  516,  516,    0,  528,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,    0,  516,    0,  516, 
            0,  516,  516,  516,  516,  516,  516,  516,    0,  516, 
          509,  516,    0,    0,    0,    0,    0,    0,    0,    0, 
          509,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  507,  507,  507,    0,    0,    0,  507,  507, 
            0,  507,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   95,    0,    0,    0,    0,    0, 
          507,  507,    0,  507,  507,  507,  507,  507,    0,  509, 
            0,  114,    0,  509,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  507,  507,  507, 
          507,  507,  507,  507,  507,  507,  507,  507,  507,  507, 
          507,  509,    0,  507,  507,  507,    0,  519,    0,    0, 
            0,  507,    0,    0,    0,    0,    0,    0,  507,    0, 
          507,    0,  507,  507,  507,  507,  507,  507,  507,  303, 
          507,    0,  507,    0,    0,    0,    0,    0,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  506,  506,  506,    0,    0,    0,  506,  506,    0, 
          506,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  109,    0,    0,    0,    0,    0,  506, 
          506,    0,  506,  506,  506,  506,  506,    0,  303,    0, 
          128,    0,  303,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  506,  506,  506,  506, 
          506,  506,  506,  506,  506,  506,  506,  506,  506,  506, 
          303,    0,  506,  506,  506,    0,  518,    0,    0,    0, 
          506,    0,    0,    0,    0,    0,    0,  506,    0,  506, 
            0,  506,  506,  506,  506,  506,  506,  506,    0,  506, 
          312,  506,    0,    0,    0,    0,    0,    0,    0,    0, 
          312,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  509,  509,  509,    0,    0,    0,  509,  509, 
            0,  509,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  108,    0,    0,    0,    0,    0, 
          509,  509,    0,  509,  509,  509,  509,  509,    0,  312, 
            0,  127,    0,  312,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  509,  509,  509, 
          509,  509,  509,  509,  509,  509,  509,  509,  509,  509, 
          509,  312,    0,  509,  509,  509,    0,  521,    0,    0, 
            0,  509,    0,    0,    0,    0,    0,    0,  509,  285, 
          509,    0,  509,  509,  509,  509,  509,  509,  509,  285, 
          509,    0,  509,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  303,  303,  303,    0,    0,    0,  303,  303,    0, 
          303,  287,    0,  285,    0,    0,    0,    0,    0,    0, 
            0,  287,    0,    0,    0,    0,    0,    0,  285,  303, 
          303,    0,  303,  303,  303,  303,  303,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  287,  303,  303,  303,  303, 
          303,  303,  303,  303,  303,  303,  303,  303,  303,  303, 
          287,    0,  303,  303,  303,    0,    0,    0,    0,    0, 
          303,    0,    0,    0,    0,    0,    0,  303,    0,  303, 
            0,  303,  303,  303,  303,  303,  303,  303,    0,  303, 
          634,  303,    0,    0,    0,    0,    0,    0,    0,    0, 
          634,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  312,  312,  312,    0,    0,    0,  312,  312, 
            0,  312,    0,    0,    0,    0,    0,   60,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   60,    0,    0, 
          312,  312,    0,  312,  312,  312,  312,  312,    0,  634, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  312,  312,  312, 
          312,  312,  312,  312,  312,  312,  312,  312,  312,  312, 
          312,    0,    0,  312,  312,  312,   60,    0,    0,    0, 
            0,  312,    0,    0,    0,    0,    0,    0,  312,    0, 
          312,    0,  312,  312,  312,  312,  312,  312,  312,    0, 
          312,    0,  312,    0,   62,    0,    0,    0,    0,    0, 
            0,  285,  285,  285,   62,    0,  285,  285,  285,    0, 
          285,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          285,  285,    0,    0,    0,    0,    0,    0,    0,  285, 
          285,   64,  285,  285,  285,  285,  285,    0,    0,    0, 
            0,   64,    0,  287,  287,  287,    0,    0,  287,  287, 
          287,    0,  287,   62,    0,    0,    0,    0,    0,    0, 
            0,    0,  287,  287,    0,    0,    0,    0,    0,    0, 
            0,  287,  287,    0,  287,  287,  287,  287,  287,    0, 
          285,    0,    0,  285,    0,  285,   51,    0,    0,    0, 
           64,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,  285,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  287,    0,    0,  287,    0,  287,    0,    0, 
            0,    0,  634,  634,  634,    0,    0,  634,  634,  634, 
           53,  634,    0,  287,    0,   51,    0,    0,    0,    0, 
           53,  634,  634,    0,    0,    0,    0,    0,    0,    0, 
          634,  634,    0,  634,  634,  634,  634,  634,    0,   60, 
           60,   60,    0,    0,   60,   60,   60,    0,   60,    0, 
            0,    0,   55,    0,    0,    0,    0,    0,   60,   60, 
            0,    0,   55,    0,    0,    0,    0,   60,   60,   53, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           60,   60,   60,   60,   60,    0,    0,    0,    0,    0, 
            0,  634,    0,    0,  634,    0,  634,    0,    0,    0, 
           56,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           56,    0,  634,    0,    0,    0,    0,    0,    0,    0, 
            0,   55,    0,    0,    0,    0,    0,    0,   60,    0, 
            0,   60,    0,    0,    0,    0,   62,   62,   62,    0, 
            0,   62,   62,   62,    0,   62,    0,    0,    0,   60, 
          293,    0,    0,    0,    0,   62,   62,    0,    0,   56, 
          293,    0,    0,    0,   62,   62,    0,   62,   62,   62, 
           62,   62,    0,   64,   64,   64,    0,    0,   64,   64, 
           64,    0,   64,    0,    0,    0,    0,  291,    0,    0, 
            0,    0,   64,   64,  286,    0,    0,  291,    0,    0, 
            0,   64,   64,    0,   64,   64,   64,   64,   64,  293, 
            0,    0,    0,    0,    0,   62,    0,    0,   62,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   51,   51, 
           51,  287,    0,   51,   51,   51,   62,   51,    0,    0, 
            0,    0,    0,    0,    0,    0,  291,   51,    0,    0, 
            0,    0,   64,    0,    0,   64,   51,   51,    0,   51, 
           51,   51,   51,   51,    0,    0,    0,    0,  292,    0, 
            0,    0,    0,   64,    0,    0,    0,    0,  292,    0, 
            0,    0,   53,   53,   53,    0,    0,   53,   53,   53, 
            0,   53,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   53,    0,    0,    0,    0,    0,   51,    0,    0, 
           53,   53,  288,   53,   53,   53,   53,   53,    0,    0, 
            0,    0,    0,    0,   55,   55,   55,  292,   51,   55, 
           55,   55,    0,   55,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   55,    0,    0,    0,    0,    0,    0, 
           52,    0,   55,   55,    0,   55,   55,   55,   55,   55, 
           52,   53,   56,   56,   56,    0,    0,   56,   56,   56, 
           25,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
           25,   56,   53,    0,    0,    0,    0,    0,    0,  218, 
           56,   56,    0,   56,   56,   56,   56,   56,    0,  218, 
            0,    0,    0,   55,    0,    0,    0,    0,    0,   52, 
            0,    0,  293,  293,  293,    0,    0,  293,  293,  293, 
            0,  293,    0,    0,   55,    0,    0,    0,    0,   25, 
            0,    0,    0,  262,    0,    0,    0,    0,    0,    0, 
            0,   56,    0,  293,  293,  293,  293,  293,  218,  291, 
          291,  291,    0,    0,  291,  291,  291,    0,  291,    0, 
            0,    0,   56,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          291,  291,  291,  291,  291,    0,    0,    0,  293,    0, 
            0,  293,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  655,    0,    0,    0,    0, 
            0,    0,  293,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  291,    0,    0,  291,    0, 
          292,  292,  292,    0,    0,  292,  292,  292,    0,  292, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  291, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  292,  292,  292,  292,  292,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  292,    0,    0,  292, 
            0,    0,   52,   52,   52,    0,    0,   52,   52,   52, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
          292,   52,   25,   25,   25,    0,    0,    0,   25,   25, 
            0,   25,    0,   52,   52,   52,   52,   52,  473,    0, 
            0,  218,  218,  218,    0,    0,    0,  218,  218,    0, 
          218,    0,    0,   25,   25,   25,   25,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  218, 
          218,    0,  218,  218,  218,  218,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   25,   52,    0,    0,    0,    0,    0,    4,    5, 
            6,  412,    8,    0,    0,    0,    9,   10,    0,    0, 
          218,   11,   25,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  337,  338,  339, 
          340,  218,    0,  117,    0,    0,    0,    0,    0,    0, 
          118,    0,    0,  341,  342,  343,    0,  344,   35,  345, 
          346,  347,  348,    0,   40,    0,    0,  127,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  349,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    7, 
          235,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    0,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,  396,  397,    0,  398,  399,    0, 
            0,  400,  401,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  402,    0,  403,    0, 
          404,  405,  406,  407,  408,  409,  410,    0,  411,  138, 
          139,  140,  141,  142,  143,  144,  145,    0,    0,  146, 
          147,  148,  149,  150,    0,    0,  151,  152,  153,  154, 
          155,  156,  157,    0,    0,  158,  159,  160,  161,  162, 
          163,  164,  165,  166,  167,  168,  169,  170,  171,  172, 
          173,  174,  175,  176,  177,  178,  179,    0,  180,  181, 
          123,  124,  182,  126,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  198,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,    0,    0,  212,    0,    0,    0,    0, 
            0,  138,  139,  140,  141,  142,  143,  144,  145,    0, 
            0,  146,  147,  148,  149,  150,    0,  213,  151,  152, 
          153,  154,  155,  156,  157,    0,    0,  158,  159,  160, 
          219,  220,  221,  222,  165,  166,  167,  168,  169,  170, 
          171,  172,  173,  174,  175,  176,  223,  224,  225,    0, 
          226,  181,  357,  358,  227,  359,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,    0,    0, 
          192,  193,    0,    0,    0,  194,  195,  196,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,    0,    0,  212,    0,    0, 
            0,    0,    0,  138,  139,  140,  141,  142,  143,  144, 
          145,    0,    0,  146,  147,  148,  149,  150,    0,  213, 
          151,  152,  153,  154,  155,  156,  157,    0,    0,  158, 
          159,  160,  219,  220,  221,  222,  165,  166,  167,  168, 
          169,  170,  171,  172,  173,  174,  175,  176,  223,  224, 
          225,    0,  226,  181,  313,    0,  227,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
           52,    0,    0,    0,    0,  138,  139,  140,  141,  142, 
          143,  144,  145,    0,    0,  146,  147,  148,  149,  150, 
            0,  213,  151,  152,  153,  154,  155,  156,  157,    0, 
            0,  158,  159,  160,  219,  220,  221,  222,  165,  166, 
          167,  168,  169,  170,  171,  172,  173,  174,  175,  176, 
          223,  224,  225,    0,  226,  181,    0,    0,  227,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,    0,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,    0, 
            0,  212,   52,    0,    0,    0,    0,  138,  139,  140, 
          141,  142,  143,  144,  145,    0,    0,  146,  147,  148, 
          149,  150,    0,  213,  151,  152,  153,  154,  155,  156, 
          157,    0,    0,  158,  159,  160,  219,  220,  221,  222, 
          165,  166,  167,  168,  169,  170,  171,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,    0,    0, 
          227,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  213,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  234, 
            4,    5,    6,    7,  235,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  234,    4, 
            5,    6,    7,  235,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  323,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  242,  243,  244,  245, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  246,  247,  248,    0,  249,   35,  250,  251, 
          252,  253,  288,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  289,    0,  290, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  291, 
            0,    0,    0,    0,   52,  292,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,  293,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  242,  243,  244,  245,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  246,  247,  248,    0,  249,   35,  250,  251,  252, 
          253,  288,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  717,    0,  290,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  291,    0, 
            0,    0,    0,   52,  292,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,  293,  280,  280,  280,    0,  280, 
            0,    0,    0,  280,  280,    0,    0,    0,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,    0,    0,    0, 
            0,  280,  280,  280,  280,  280,  280,  280,    0,    0, 
          280,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
          280,  280,  280,    0,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  280,    0,    0,  280,    0,    0, 
          280,  280,    0,  280,    0,  280,    0,  280,    0,  280, 
            0,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
            0,    0,  280,  280,  280,  280,  280,  280,    0,    0, 
            0,  280,    0,  280,  280,    0,  280,  280,  280,  280, 
            0,  280,  280,  280,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  242,  243,  244,  245,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  246, 
          247,  248,    0,  249,   35,  250,  251,  252,  253,  288, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,  289,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  291,    0,    0,    0, 
            0,   52,  292,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  293,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  242,  243,  244,  245,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  246,  247, 
          248,    0,  249,   35,  250,  251,  252,  253,  288,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  254,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,  290,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  291,    0,    0,    0,    0, 
           52,  292,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  293,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  242,  243,  244,  245,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  246,  247,  248, 
            0,  249,   35,  250,  251,  252,  253,  288,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  254,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  717,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  291,    0,    0,    0,    0,   52, 
          292,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          293,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          242,  243,  244,  245,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  246,  247,  248,    0, 
          249,   35,  250,  251,  252,  253,  288,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  291,    0,    0,    0,    0,   52,  292, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  293, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  242,  243,  244,  245,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  246,  247,  248,    0,  249,   35,  250,  251,  252, 
          253,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,  130,  508, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  291,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  242,  243,  244,  245,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  246, 
          247,  248,    0,  249,   35,  250,  251,  252,  253,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,  646,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  291,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  242,  243,  244,  245,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  246,  247,  248, 
            0,  249,   35,  250,  251,  252,  253,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  254,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  646,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  291,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  242, 
          243,  244,  245,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  246,  247,  248,    0,  249, 
           35,  250,  251,  252,  253,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  254, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
          289,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  291,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  242,  243,  244, 
          245,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  246,  247,  248,    0,  249,   35,  250, 
          251,  252,  253,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  911,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          291,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  242,  243,  244,  245,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  246,  247,  248,    0,  249,   35,  250,  251,  252, 
          253,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  717,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  291,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,  622,  622,  622,    0,  622,    0, 
            0,    0,  622,  622,    0,    0,    0,  622,    0,  622, 
          622,  622,  622,  622,  622,  622,    0,    0,    0,    0, 
          622,  622,  622,  622,  622,  622,  622,    0,    0,  622, 
            0,    0,    0,    0,    0,    0,  622,    0,    0,  622, 
          622,  622,    0,  622,  622,  622,  622,  622,  622,    0, 
          622,  622,  622,  622,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  622,    0,    0,  622,  622,    0,  622, 
          622,    0,  622,    0,    0,    0,    0,    0,  622,    0, 
            0,    0,    0,    0,    0,    0,  622,    0,    0,    0, 
            0,  622,  622,  622,  622,  622,  622,    0,    0,    0, 
          622,    0,  622,  622,    0,  622,  622,  622,  622,    0, 
          622,  622,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,  242,  243,  244,  245,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  246,  247,  248, 
            0,  249,   35,  250,  251,  252,  253,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  254,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  242, 
          243,  244,  245,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  246,  247,  248,    0,  249, 
           35,  250,  251,  252,  253,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  254, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  291,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  242,  243,  244, 
          245,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  246,  247,  248,    0,  249,   35,  250, 
          251,  252,  253,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          291,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  622,  622,  622,    0, 
          622,    0,    0,    0,  622,  622,    0,    0,    0,  622, 
            0,  622,  622,  622,  622,  622,  622,  622,    0,    0, 
            0,    0,  622,  622,  622,  622,  622,  622,  622,    0, 
            0,  622,    0,    0,    0,    0,    0,    0,  622,    0, 
            0,  622,  622,  622,    0,  622,  622,  622,  622,  622, 
          622,    0,  622,  622,  622,  622,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  622,    0,    0,  622,    0, 
            0,  622,  622,    0,  622,    0,    0,    0,    0,    0, 
          622,    0,    0,    0,    0,    0,    0,    0,  622,    0, 
            0,    0,    0,  622,  622,  622,  622,  622,  622,    0, 
            0,    0,  622,    0,  622,  622,    0,  622,  622,  622, 
          622,    0,  622,  622,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  113,  114,  115,  116,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,  118,    0,    0,  119, 
          120,  121,    0,  122,   35,  123,  124,  125,  126,    0, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          128,    0,    0,  129,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  270,  271,  272,  273,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  274,  275,  276, 
            0,  277,   35,  278,  279,  280,  281,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  282,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  337, 
          338,  339,  340,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,  118,    0,    0,  341,  342,  343,    0,  344, 
           35,  345,  346,  347,  348,    0,   40,    0,    0,  127, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  349, 
            0,    0,  424,    0,    0,   46,   47,    0,   48,    0, 
          425,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  113,  114,  115, 
          116,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
          118,    0,    0,  119,  120,  121,    0,  122,   35,  123, 
          124,  125,  126,    0,   40,    0,    0,  127,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  129,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  337,  338,  339,  340,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  341,  342,  343,    0,  344,   35,  345,  346,  347, 
          348,    0,   40,    0,    0,  127,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  349,    0,    0,  424,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  924,  925,  926,  927,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,  118,    0,    0,  928, 
          929,  930,    0,  931,   35,  932,  933,  934,  935,    0, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  936,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  113,  114,  115,  116,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  119,  120,  121, 
            0,  984,   35,  123,  124,  985,  126,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  986,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          738,  628,    0,    0,  739,    0,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,    0,    0, 
          192,  193,    0,    0,    0,  194,  195,  196,  197,    0, 
            0,    0,    0,    0,  307,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  740,  634,  212,    0,  741, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,  213, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,  307, 
            0,    0,    0,    0,    0,    0,  199,  200,    0,  201, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
         1039,  628,  212,    0, 1040,    0,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,    0,    0, 
          192,  193,    0,    0,  213,  194,  195,  196,  197,    0, 
            0,    0,    0,    0,  307,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211, 1041,  634,  212,    0, 1042, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,  213, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,  307, 
            0,    0,    0,    0,    0,    0,  199,  200,    0,  201, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
         1066,  634,  212,    0, 1067,    0,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,    0,    0, 
          192,  193,    0,    0,  213,  194,  195,  196,  197,    0, 
            0,    0,    0,    0,  307,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,    0,    0,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  213, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,   74,    6,    7,   27,   10,   11,   26,    6,   28, 
           21,    7,    4,    5,  415,  416,  261,   51,  447,  420, 
          455,  417,   14,   27,  470,  490,   15,   16,   99,  423, 
           19,   27,  583,   15,   16,   45,   21,   19,    2,    3, 
           49,    7,    3,  444,  475,   47,   48,  299,   52,  371, 
          446,  332,  574,  575,   52,  336,  676,   49,   32,  535, 
          525,   27,  463,  464,  487,   47,   48,  490,   10,  465, 
           10,   10,  129,   10,   10,    0,  477,    0,    0,  699, 
           10,   59,   59,  479,   44,   11,   10,   10,   91,   10, 
           10,   10,   91,  713,  766,  106,   10,  858,   91,  118, 
           10,   61,   44,   10,   44,   10,  510,   99,   44,   15, 
           16,  512,   10,   19,    2,    3,   10,   59,  777,   59, 
            8,  106,  742,   59,   44,   10,   14,  112,  104,   59, 
           10,  532,  860,  323,   10,   59,   59,   10,  534,   59, 
           10,    2,    3,    4,    5,   59,   10,    8,    9,   10, 
           11,  136,   43,   14,   15,   16,   10,   45,   19,   44, 
           10,   59,   10,  104,   44,   59,  561,   10,   10,  959, 
          980,   44,  280,  340,   59,   10,   10,  280,  104,  655, 
           44,   61,   10,  764,   45,   46,   59,   10,   49,  340, 
           51,   61,   32,  372,  955,   59,   44,   10,  377,   10, 
           10,   10,   10,   10,  305,   59,  132,   10,   10,   59, 
          592,   59,  305,   10,  328,    0,   59,   59,  312,   10, 
           10,  335,  881,  317,   10,   10,   10,   61,  308,   10, 
           10,   59,  340,   10,  424,   44,  127,   10,   99,  561, 
           10,  670,  130,   10,  626,   10,   59,  499,   59,   59, 
         1060,  680, 1013,  361,   61,  349,  350,   10,  361, 1049, 
          725,  361,  238,  268,  269,  325,  701,  128,  317,  130, 
          234,   44,   10,  374,   59,  344,   32,   61,   59,  350, 
          684,  374,   59, 1011,  679,  310,  681, 1048,   15,   16, 
          341,  385,   19,  362,  966,  375,  376,  238,  358,  348, 
           32,  724,  725,  352,  353,  307,   44,  358,   61,   10, 
          263,  264,  238,  323,  341,  304,  269,  306,  307,  279, 
           47,   32,  304,  264,  306,  328,  256,  878,  804,  328, 
           32,  358,  335,  365,  885,  328,  335,   10,  264,  890, 
           10,   10,  335,   44,  866,  427,  234,  235,  870,  871, 
          282,  873,   44,  875,  370,  371,  372,  679,  350,  681, 
           61,  377,   10,  305,  341,  305,  264,  337,  269,  305, 
          271,   44,  454,  234,  235,  380,  381,  382,  383,  960, 
          358,  305,   61,  290,  291,  305,   59,  421,  445,  423, 
           91,   61,   61,  427,  428,  976,  370,  371,  304,  341, 
          306,  341,  341,  377,  341,  341,  800,  268,  269,  279, 
          841,  305,  416,   61,  424,  417,  425,  341,  358,  340, 
          384,  341,  358, 1043,  806,  344,  356,   61,  417,  317, 
          415,  341,  374,  425,  374,  323,  341,  362,  374,  362, 
          362,  445,  337,  304,  446,  306,  307,  341,  362,  310, 
          374,  312,  454,  455,  374,  736,  317,  446,  703,  444, 
          464,  341,  323,  465,  535,  341,  430,  719,  344,  430, 
          281,  341,  279,  358,  478, 1056,  465,  479,  463, 1030, 
          374,  262,  263,  264,  507,  358,  951,  916,  269,  350, 
          479,  341,  477,   10,  358,  279,  384, 1019, 1020, 1021, 
         1022,  947,  340,  507,  358,  487,  341,  341,  510,  513, 
          358,  507,  947,  341,  440,  358,  358,   44,  341,  380, 
          381,  382,  383,  384,  385,  386,  279,  512,  951,  533, 
          370,  371,  534,  341,  341,  423,  424,  377,  341,  341, 
          522,  507,  430,  535,   61,  534,  510,  532,  474,  475, 
          341,  341, 1074,  344,  344,  341,  417,  341,  344,  447, 
          421,  341,  423,  424,  425,   10,  427,  428,  997,  430, 
          458,  341,   61,  461,  341,  820,  341,  304,  279,  306, 
          361,  469,  290,  291,  655,  446,  447,  448,  341,  591, 
          592,  268,  269,  845,  267,   10,  372,  458,  999,   44, 
          461,  377,   10,  262,  465, 1001,  625,   10,  469,  279, 
          279,  306,  264,   10,  310,  310,   61,   10,  479,  630, 
          310,  640,  510,  787,  626,  636,   10,  328,  630,  793, 
           44,  279,  643,  337,  335,  271,  326,  372,  328,  340, 
          341,  643,  377,  337,   59,  630,   91,  508,  764,  510, 
          766,  636,   10,   61,  372,   59,   59,  676,  643,  377, 
          683,  777,   59,  655,  669,  338,  737,  310,   61,  671, 
          279,  341,  341,  534,  535,   59,  338,   91,  682,  683, 
          699,   44,  684,   44,  682,  687,  671,  683,  690,  674, 
          361,  693,  317,  341,  713,  317,  423,  942,   10,  701, 
          427,   59,  337,   10,   10,    2,    3,  349,  350,  714, 
           10,    8,    9,   10,   11,   91,  344,  683,   15,   16, 
          684,  341,   19,  742,  797,  263,  264,  454,   10,  362, 
          310,   10,  372,  804,   44,  372,  755,   44,  346,   44, 
          372,  667,  724,  372,  471,  737,   10,   59,   45,   46, 
          784,  785,   59,   59,   51,  340,  790,  791,  777,   59, 
          361,  340,  279,  262,  263,  264,  800,   44,  269,  268, 
          269,  267,  271,  264,  370,  371,  372,   59,  341,   91, 
           59,  377,  670,   44,   44,   91,  370,  371,  362,   44, 
           32,  387,  680,  377,  655,   59,  684,    0,  382,   61, 
          306,  689,  492,  306,  806,   91,   10,   10,  669,  670, 
          500,  501,  804,   44,   91,    9,   10,   11,   44,  680, 
           44,  826,   44,  684,  341,   91,  516,  819,  689,  519, 
          306,  128,   44,  130,  279,  280,   32,  337,   10,  337, 
          337,   44,  341,  337,   61,    2,    3,    4,    5,  264, 
          966,    8,   46,  714,  269,   59,   59,   14,   44,   44, 
          976,  264,  881,  362,  980,  279,  269,  371,  271,  264, 
          267,  279,  906,  761,  762,   91,  737,  338,  262,  263, 
          264,  263,  808,  328,  337,  269,  279,   59,   45,  815, 
          335,  779,   49,  781,  337,  783,  341,  337,   10,  891, 
          761,  762,  337,  362,  262,  263,  264,  264,   44,   58, 
          268,  269,  800,  271,  328,  841,  361,  337,  779,   91, 
          781,  335,  783,  784,  785,   91,  340,  344,  264,  790, 
          791,  819,  264,  341,  128,  823,  362,  234,  235,  800, 
           10,  338,   99,  804, 1060,  947,  264,   59,  341,  837, 
          838,  839,  328,  264,  337,  267,   10,   44,  819,  335, 
          267,  267,  823,  851,  654,  826,   44,  267,    2,    3, 
          341,  268,  269,  130,    8,   59,  837,  838,  839,   91, 
          972,   44,  264,  341,  263,  264,  268,  269,  678,   59, 
          851,   10,   10,  264,  362,   10, 1000, 1016,   44, 1001, 
           44,   10,  279,  267,  362,   59,   44,  304,   61,  306, 
          307,   45, 1001,  310,  999,  312,  328,   44,   10,   44, 
          317,   44,  328,  335, 1043,   44,  323,  915,  916,  335, 
          891, 1035,   44,  358,  340,   44,  264,  264,  310,  729, 
           59,   59,  328, 1045,   59,  906,  370,  371,  372,  335, 
           59,  328,  940,  377,  915,  916,  560,  561,  335,  262, 
          263,  264,  328,  362,  754,  268,  269,   59,  271,  335, 
          362,  264,   91,   91,  268,  269,  264,  234,  235,  940, 
           44,  310,   91,  380,  381,  382,  383,  384,  385,  386, 
          293,  294,  295,  296,  297,  267,  130,   44,   44,   91, 
          358,  264,  306,   10,  308,  309,  310,  311,  312,  997, 
          362,  972,  328,  317,   44, 1003,  310,   44,  312,  335, 
          417, 1009,   44,  813,  421,   44,  423,  424,   44,  264, 
          427,  428,  264,  430,   44,  339,  997,  271,  341,  344, 
         1001,   10, 1003,  347,  348,  349,  350,   44, 1009,  446, 
          447,  448,   59,  362,  271,  267,  328,  340,   45,  362, 
          317,  458,  328,  335,  461,   44,  323,  857,  465,  335, 
          341,   10,  469,  362,  344,  679,  344,  681,  370,  371, 
          372,  385,  479,   44,   58,  377,  380,  381,  382,  383, 
           59,  385,  386,  350,   91,  370,  371,  372,  344,  264, 
          234,  235,  377,  216,   70,   44,  292,   54,  262,  263, 
          264,  508,   91,  510,  268,  269,  328,  271,  308,  309, 
           59,  311,   91,  335,    5,   10,  373,  384,  458, 1045, 
           91,    6,  643,  922,   44,  764,  306,  534,  308,  309, 
          310,  311,  312,  130,  777,  749,  750,  317,  768,  267, 
           44,  976,   91,  363,  448,  365,  978,  367,  328,   44, 
          764,  280,  766,  373,  796,  335,   14,  424,  425,  339, 
          340,  280, 1002,  430,   59,  267,  749,  347,  348,  349, 
          350,   91,   -1,  317,   -1,  375,  376,  341,  280,  323, 
          447,  306, 1049,  308,  309,  310,  311,  312,   -1,   44, 
           10,  458,  317,   -1,  461,   -1,   91,   -1,  362,  328, 
          328,   -1,  469,  328,  508,  385,  335,  335,   -1,  328, 
          335,  340,   -1,   -1,  339,  340,  335,   10,   -1,   -1, 
           -1,  340,  347,  348,  349,  350,  328,   -1,   -1,  358, 
           -1,   -1,  361,  335,   -1,   -1,   91,   -1,  340,  358, 
          384,   -1,  361,  510,  858,   -1,  860,   -1,   10,  306, 
           -1,  308,  309,  310,  311,   -1,   10,   -1,   -1,  361, 
          385,   -1,  669,  670,  484,   -1,   59,   -1,  535,   44, 
           -1,   -1,  279,  680,  370,  371,  372,  684,   -1,   -1, 
          424,  377,  689,   -1,   -1,   -1,  430,   -1,  267,  306, 
          279,  308,  309,  310,  311,  312,   -1,   59,   91,   -1, 
          317,  280,   -1,  447,   -1,   59,   -1,  714,  279,   -1, 
           -1,  328,   -1,   10,  458,   -1,   91,  461,  335,   -1, 
          317,  328,  339,  340,   -1,  469,  323,   -1,  335,  549, 
          347,  348,  349,  350,   -1,   -1,   -1,   91,   -1,  328, 
           10,  955,  956,  370,  371,  372,  335,   -1,   -1,  328, 
          377,   -1,  966,   -1,  761,  762,  335,  328,   -1,  279, 
           10,  340,   59,   -1,  335,  669,  510,  587,  385,   -1, 
           -1,   -1,  779,   -1,  781,   -1,  783,  784,  785,  328, 
           -1,   -1,  361,  790,  791,  280,  335,   -1,  655,   59, 
           10,  340,   -1,  800,   44,   -1,   -1, 1011,   -1, 1013, 
           -1,   -1,  306,  670,  308,  309,  310,  311,  328,  358, 
          714,   61,   -1,  680,   -1,  335,  823,  684,   -1,  826, 
           -1,   91,  689,   -1,  279,   15,   16,  424,   -1,   19, 
          837,  838,  839,  328, 1048,   44,   -1,   44,   -1,   59, 
          335,   91,   -1,   -1,  851,  340,  370,  371,  372,   44, 
           -1,   41,   42,  377,   -1,   -1,   -1,   47,   48,   -1, 
           50,   51,   -1,  358,  461,   -1,  361,   -1,   -1,   -1, 
          737,   91,  469,  328,  267,   -1,   -1,   -1,  745,   -1, 
          335,   -1,   91,   -1,   91,   -1,  306,  280,  308,  309, 
          310,  311,  312,   -1,  761,  762,   91,  317,  306,  906, 
          308,  309,  310,  311,  279,   -1,   -1,   -1,  915,  916, 
           10,   48,  779,  267,  781,   -1,  783,   -1,   10,  339, 
           -1,   -1,  826,   -1,   -1,   -1,  670,  347,  348,  349, 
          350,  339,   -1,  940,   -1,  328,  680,  804,   -1,  347, 
          684,   -1,  335,   -1,  306,  689,  308,  309,  310,  311, 
          312,   -1,  819,  328,   -1,  317,  823,   -1,   -1,   59, 
          335,  378,  379,  380,  381,  385,  328,   59,  361,   -1, 
          837,  838,  839,  335,  328,   -1,   -1,  339,  340,   -1, 
           -1,  335,   -1,   -1,  851,  347,  348,  349,  350,   44, 
          997,   91,   -1,   -1, 1001,   -1, 1003,  267,   -1,   91, 
           -1,   -1, 1009,   -1,   -1,   10,   -1,   -1,   10,  306, 
           -1,  308,  309,  310,  311,  312,   -1,  761,  762,   -1, 
          317,   -1,   -1,  385,  891,  370,  371,  372,   -1,  279, 
          280,  328,  377,   -1,   -1,  779,   91,  781,  335,  783, 
           -1,   -1,  339,  340,   -1,  317,   -1,  267,  915,  916, 
          347,  348,  349,  350,   59,   -1,   -1,   59,  328,   -1, 
           -1,   10,   10,   -1,  306,  335,  308,  309,  310,  311, 
          279,   -1,  279,  940,   -1,   -1,  348,   -1,  328,  823, 
          352,  353,  354,  355,  279,  335,   91,   -1,  385,   -1, 
          340,  341,  689,  837,  838,  839,   44,  339,  288,  289, 
          290,  291,   -1,  293,   -1,  972,   -1,  851,  328,   -1, 
           59,  361,   10,   61,  304,  335,  306,  307,   -1,  328, 
           10,  328,   -1,   44,   -1,  315,  335,   -1,  335,   -1, 
          997,   -1,   -1,  328,   -1,   -1, 1003,   -1,   -1,   -1, 
          335,   -1, 1009,   91,   -1,  306,   44,  308,  309,  310, 
          311,  288,  289,  290,   -1,   -1,  293,  293,  294,  295, 
          296,  297,   -1,   61,  761,  762,   -1,  267,   -1,   59, 
           91,  915,  916,   -1,   10,  267,   -1,   -1,   -1,   -1, 
           -1,   -1,  779,   -1,  781,   -1,  783,   -1,  280,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,  940,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,  397,  398,  399, 
          400,  401,  402,  403,  404,  405,  406,  407,  408,  409, 
          410,  411,  412,   59,  279,   -1,  823,  417,  328,   -1, 
           10,  421,   10,  423,   -1,  335,  328,  427,  428,   -1, 
          837,  838,  839,  335,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,  997,  851,   44,  446,   -1,   -1, 1003, 
           -1,   10,  267,   -1,  454, 1009,   44,   -1,   -1,  361, 
           -1,   10,   -1,  328,   -1,  465,  466,  467,  468,   59, 
          335,  471,   -1,   61,   -1,   -1,  423,   -1,   -1,  479, 
          427,   -1,  262,  263,  264,   44,  486,  487,  268,  269, 
          490,  271,   91,   -1,  306,   44,  308,  309,  310,  311, 
          312,   91,   61,   91,   -1,  317,   -1,  454,  915,   -1, 
           -1,   -1,   61,  328,  514,  515,  328,   10,   -1,   -1, 
          335,  279,  522,  335,  471,  525,   -1,  339,  340,   -1, 
           -1,   -1,   91,  940,  534,  347,  348,  349,  350,  486, 
          487,   -1,   91,  490,   -1,   -1,   -1,  306,  279,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,    0,  317,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   59,   10,   -1,  328, 
          328,  279,  280,  385,   -1,  522,  335,  335,  525,   -1, 
          339,  340,  362,  341,  584,   -1,   -1,   10,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1, 1003,  328,   91,   -1, 
           -1,   44, 1009,   10,  335,   -1,  306,   10,  308,  309, 
          310,  311,  312,   -1,   -1,   58,   59,  317,   -1,   -1, 
          328,   44,   -1,   -1,   10,   10,  385,  335,  328,   -1, 
           -1,   -1,  340,  341,   -1,  335,   44,  584,   61,  339, 
          340,   -1,   -1,   -1,   -1,   10,  646,  347,  348,  349, 
          350,   -1,   59,  361,   -1,   -1,   59,   -1,   44,   -1, 
          306,   10,  308,  309,  310,  311,  312,   -1,   91,   -1, 
           -1,  317,   -1,   -1,   59,   61,   -1,  267,   -1,   44, 
          279,  280,  328,   91,   91,  385,   -1,   -1,   91,  335, 
          280,  279,  280,  339,  340,   44,   61,  317,   -1,  646, 
           -1,  347,  348,  349,  350,   91,   91,   -1,   -1,   -1, 
           -1,   -1,   61,  333,  334,  715,   -1,  717,   -1,   -1, 
          279,  280,   -1,   -1,  724,  725,   91,   -1,  348,  328, 
          279,   -1,  352,  353,  354,  355,  335,   -1,  328,  385, 
          328,  340,   91,   -1,   -1,  335,   -1,  335,   -1,    0, 
          340,   -1,  340,  341,   -1,   -1,  756,   -1,   -1,   10, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,   -1,  715,  328, 
          717,  361,   -1,  361,  267,   -1,  335,  724,  725,  328, 
          317,  340,  341,   -1,  784,  785,  335,   -1,   -1,   -1, 
          790,  791,  341,   44,   -1,   -1,  333,  334,   -1,  799, 
          800,  801,  361,   -1,   -1,  805,   -1,   58,   59,  756, 
           61,  348,   63,  350,   -1,  352,  353,  354,  355,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  829, 
          830,  831,  832,   -1,   -1,  328,  836,   -1,  281,  282, 
           91,   -1,  335,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  801,   -1,  279,  280,   -1,   -1, 
          267,   -1,  305,   -1,  267,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,  280,  280,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  267,   -1,   -1,   -1,   -1,   -1,   10,  836, 
           -1,   -1,   -1,  279,  894,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  328,  906,   -1,   -1,   -1, 
           -1,  911,  335,   -1,  279,   -1,   -1,  340,  341,  362, 
          328,  328,   44,   -1,   -1,  328,   -1,  335,  335,   -1, 
          279,  374,  335,  340,   -1,   -1,   58,   59,  361,   61, 
           -1,   63,  328,  328,  944,   -1,   -1,   -1,   -1,  335, 
          335,  951,   -1,  361,  361,  341,  306,   -1,  308,  309, 
          310,  311,   -1,  328,  911,   -1,   -1,   -1,   -1,   91, 
          335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,  339, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
           -1, 1001,   -1,   -1,  951,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  768,  364,  365,  366,  367,  368,  369,   -1, 
          777,  777,  373,  374,  375,  376,   -1,  378,  379,  380, 
          381,   44,  383,  384,  385,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   91,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,  317,   -1, 
            0,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           10,  383,  384,  385,  333,  334,   -1,   -1,  882,   -1, 
           -1,   -1,  886,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,   -1,   -1,  358, 
           -1,  360,   -1,  306,   44,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,  973,  973,   -1,  976, 
          976,  978,  978,  980,  980,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
          306,   91,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  317,   -1,   -1,  279,  280,   -1,   -1, 
           -1,   -1,  385,  339,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,  347,  348,  349,  350,  339,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 1056, 
         1056, 1058, 1058, 1060, 1060,   -1, 1063, 1063,   -1,   -1, 
         1024,   -1,   -1, 1027, 1028,  328,   -1, 1031, 1032,  385, 
           -1,   -1,  335,   44, 1081, 1081,   -1,  340,   -1,   -1, 
           -1,  385,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  361,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1, 1075, 1076, 1077, 1078,  333,  334,   -1,   -1,   -1, 
           91, 1085,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
          380,  381,   44,  383,  384,  385,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   91, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,    0,  373,  374,  375,  376,   -1,  378,  379,  380, 
          381,   10,  383,  384,  385,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   44,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   58, 
           59,  340,   61,   -1,   63,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,  279,  280,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
            0,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           10,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  328,   -1,  363,   -1, 
           -1,   -1,   -1,  335,   44,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          385,   -1,  317,   63,   -1,   -1,   -1,  322,  323,  361, 
           -1,  306,   -1,  308,  309,  310,  311,  312,  333,  334, 
           -1,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,  339,  360,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          385,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,  374,  375,  376,   -1,  378, 
          379,  380,  381,   44,  383,  384,  385,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           91,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,    0,  373,  374,  375,  376,   -1,  378,  379, 
          380,  381,   10,  383,  384,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   44,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           58,   59,   -1,  347,  348,   63,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,  279,  280, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,    0,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   10,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  328,   -1,  363, 
           -1,   -1,   -1,   -1,  335,   44,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  385,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          361,  317,  318,  319,  320,  321,  322,  323,  324,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,  380,  381,   44,  383,  384,  385,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   91,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,    0,  373,  374,  375,  376,   -1,  378, 
          379,  380,  381,   10,  383,  384,  385,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   44,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   58,   59,  340,   61,   -1,   63,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1, 
           -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1,  279, 
          280,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,    0,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   10,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  328,   -1, 
          363,   -1,   -1,   -1,   -1,  335,   44,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  385,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  361,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   63,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,  374,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   59,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,    0,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   10,  383,  384,  385,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   44,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   63,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,    0,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   10,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   59,   -1,  342,  343,   63,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   91,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   44,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  385, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,    0,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   10,   -1,  373,   10,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   61,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   91,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,    0,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   10,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   91,  383,  384,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   61,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   91,  280,   -1,  279,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  328,   -1,  333,  334,  335, 
          336,  337,  335,  339,  340,  341,  342,  343,  341,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          385,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,  279,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,    0,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   10,  383,  384,  385, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1, 
           -1,   -1,  306,  307,  341,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           44,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   59,  340,   61,   -1,   63, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310, 
           -1,  385,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,    0,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   10,  347,  348,   10,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          306,  307,  363,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   44, 
          326,  327,   44,   -1,  385,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   61, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           63,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   -1,  333,  334, 
          335,  336,   -1,  335,  339,  340,  341,  342,  343,  341, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   10,  383,  384, 
          385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           61,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   10,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,  279,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   63,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  328,   -1,  333, 
          334,  335,  336,   -1,  335,  339,  340,  341,  342,  343, 
          341,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,   -1,   -1,   -1,  759,   -1,   -1,   -1,   -1, 
           -1,   -1,  766,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,  777,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   59,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   10,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,   -1,   44,   -1,   -1,   -1,   -1,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           61,   -1,   -1,   -1,   -1,   -1,   59,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
          964,  360,  966,   -1,  968,   -1,   -1,   -1,   -1,  973, 
           -1,   -1,   -1,   -1,   -1,   -1,  980,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,   10, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1, 1052,   -1, 
           -1,   -1,   -1,   -1, 1058,  328, 1060,   -1,   59, 1063, 
           -1,   -1,  335,  336,   -1,   -1,  339,   -1,  341,  342, 
          343,   -1,  345,   -1,  347,   -1,  349, 1081,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,  361,  362, 
           91,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,  279,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  328,   -1,   59,   -1,   -1, 
          341,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361,   91, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           10,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   44,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   61,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   91,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   10,  269,  270,   10, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   44,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           61,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   91,   -1,  351, 
           91,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,  279, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,  328,   -1, 
           -1,   -1,  335,  336,   -1,  335,  339,  340,   -1,  342, 
          343,  341,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   10,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,  279,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,  328,   -1,   -1, 
           -1,  335,  336,   -1,  335,  339,   -1,   -1,  342,  343, 
          341,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          256,  257,  258,  259,  260,  261,   -1,   -1,  264,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   10,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,    0,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   10,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   58,   59,  351,   61,   -1,   63,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   91,  383,  384,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,    0,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   10,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           58,   59,  351,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   91,  383,  384,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  768,   -1,   -1,  771,   -1,   -1,   -1, 
           -1,   -1,  777,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   61,   -1,   63,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   91,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,  361,  362,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   61,   -1,   63,   -1,  305,  973,   -1, 
           -1,  976,   -1,  978,   -1,  980,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  361,  362,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  374,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1, 1056,   -1, 1058,   -1, 1060,  281,  282, 1063,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1, 1081,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,  337,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,  337, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   44,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,    0, 
          335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,  337, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  374,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  374,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   58,   59, 
           -1,   61,   -1,   63,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   91,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  374,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,  374,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   58,   59,   -1, 
           61,   -1,   63,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           91,  333,  334,  335,   -1,  337,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,  337,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  374,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           61,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,  374,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   58,   59,   -1,   61, 
           -1,   63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   91, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  374,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  374,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   91,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  374,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   -1,   -1,   63, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          374,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   -1,   -1,   63,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   44,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58, 
           59,   -1,   -1,   -1,   63,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,    0,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           58,   59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   44,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59, 
           -1,   -1,   -1,   63,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,    0, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   10, 
          346,   -1,   -1,   -1,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,  350,   -1,   -1,   -1,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  374,  267,  268,  269, 
           -1,  271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          290,  291,   63,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,    0, 
          350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  374,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,    0,  350, 
           -1,   -1,   -1,   -1,   -1,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   10,   -1,   -1,  350, 
           -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   10,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  374,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  374,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,    0,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   -1,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   44,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,   58,   59,   -1,  362, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   -1,  262,  263,  264,  362,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,    0,   -1,  362,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   10,   -1,   -1,   -1,  374,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   58, 
           59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          362,    0,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   10,  374,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   58, 
           59,   -1,   -1,   -1,   63,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,  374,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   10,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  362,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  281,  282,   10,  374,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   10,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,  362,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,  374,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   44,  271,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59, 
           -1,  374,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  262,  263,  264,   -1,   -1,  305, 
          268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  325, 
           -1,   -1,   -1,  329,  330,  293,  294,  295,  296,  297, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,  267,  268,  269,   -1,  271,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  281,  282,   -1,  374,   -1, 
           -1,   -1,   -1,  341,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,  262,  263,  264,  305, 
            0,  267,  268,  269,  362,  271,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  338,   -1,   -1,  341,   -1,   -1,  344,  305, 
          346,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   10,  362,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
            0,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,    0,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   10,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
            0,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,    0,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   10,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
            0,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,    0,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   10,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
            0,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,    0,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   10,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   44,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   58,   59,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   44,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   59,  374, 
          290,  291,   63,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
            0,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           10,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   59, 
          267,  268,  269,   63,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,  281,  282,  341,   -1,   -1,  344, 
           -1,  346,   -1,  290,  291,   -1,  293,  294,  295,  296, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  362,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,  374,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,    0,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   59,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           59,   -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   59,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   10,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,    0,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   10,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          341,   -1,   -1,  344,   -1,  346,    0,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,  362,   -1,   59,   -1,   -1,   -1,   -1, 
           10,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  290,  291,   59, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,  344,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  362, 
            0,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   59, 
           10,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,  281,  282,   44,   -1,   -1,   10,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   59, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   44,   -1,  267,  268,  269,  362,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,  281,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,  344,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   59,  362,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           10,  341,  262,  263,  264,   -1,   -1,  267,  268,  269, 
            0,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  281,  362,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   10, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,  362,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,  293,  294,  295,  296,  297,   59,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,  281,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,  293,  294,  295,  296,  297,   59,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  362,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   63,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
          341,  270,  362,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  362,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,  260,  261,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  270,  271,   -1,  385,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,  385, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          364,   -1,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,  385,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,  364,   -1,   -1,   -1,   -1,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,  385,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,  385,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  385, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  306,  307,  363,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,  385, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          306,  307,  363,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,  385,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  306,  307,  363,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,  385, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          306,  307,  363,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,  385,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385, 
      };
   }

}
