# RMT CLI

We would like to have a single entry-point script named `rmt-cli` to provide CLI to RMT functions.

```
o rmt-cli
|
+--+ scc
|  |
|  +--+ sync (Synchronize database with SCC)
|     |
|     +--> -o, [--out-file] FILENAME (Write SCC data into a file rather than into the DB)
|     +--> -i, [--in-file] FILENAME (Load SCC data from a file rather than from SCC)
|
+--+ products
|  |
|  +--+ list (List released products)
|  |  |
|  |  +--> -r RELEASE_STAGES (Show products with only specified stages: alpha, beta, released)
|  |  +--> -c, [--custom-only], [--no-custom-only] (Show only custom products)
|  |
|  +--> enable PRODUCT (Enable a product)
|  |
|  +--> disable PRODUCT (Disable a product)
|  |
|  +--> create PRODUCT (Create a custom product)
|  |
|  +--> edit PRODUCT (Edit an existing custom product)
|  |
|  +--> delete PRODUCT (Delete a custom product)
|  |
|  +--> addrepo PRODUCT REPO_ID (Add a custom repository to the product)
|  |
|  +--> removerepo PRODUCT REPO_ID (Remove a custom repository from the product)
|
+--+ repos
|  |
|  +--+ list [PRODUCT_STRING] (List repositories which are enabled for mirroring, optionally for a specified product)
|  |  |
|  |  +--> -a, [--all], [--no-all] (Show all repositories, default off)
|  |  +--> -c, [--custom-only], [--no-custom-only] (Show only custom repositories)
|  |
|  +--+ enable TARGET (Enable repositories, TARGET is either product string (identifier/version/arch) or repo ID)
|  |
|  +--> disable TARGET (Disable repositories, TARGET is either product string (identifier/version/arch) or repo ID)
|  |
|  +--> create NAME URL (Create a custom repository)
|  |
|  +--> edit NAME URL (Edit an existing custom repository)
|  |
|  +--> delete TARGET (Delete a custom repository by name, ID or URL)
|
+--> mirror (Mirror all repositories that are enabled)
|
+--> help COMMAND (Show help for specified command)
|
+--> version (Show RMT version)
|
+--+ Global options:
   |
   +--> -h, [--help] (Another way to invoke `help` command)
   +--> -v, [--version] (Another way to invoke `version` command)
   +--> -d, [--debug] (Display debug output)

```

## Syncing with SCC

```
# rmt-cli scc help
Commands:
  rmt-cli scc sync     # Synchronize database with SCC

  -o, [--out-file] FILENAME (Write SCC data into a file rather than into the DB)
  -i, [--in-file] FILENAME (Load results from a file rather than from SCC)

Run 'rmt-cli scc help COMMAND' for more information on a command.
```

##### Respective SMT commands

```
smt-scc-sync
```

```
smt-scc-sync : Get data from SCC and update the local database.

Usage:
smt-scc-sync [options]

Options:
--fromdir                 read SCC informations from directory instead of downloading it from SCC
                          and update the database.
--todir                   write SCC informations to directory without updating the database.
--createdbreplacementfile create a database replacement file for using smt-mirror without database.
--logfile -L file         Path to logfile
--debug                   Enable debug mode
--verboselevel -v level   set the verbose level
--mail -m                 Send output as e-mail to the administrators defined in reportEmail in smt.conf.
                          The output on stdout and stderr will be suppressed.
```

## Listing SCC-related data

### rmt-cli products list

Columns:

* ID
* Name
* Version
* Architecture
* Product string
* Release stage
* Mirror? (Mirroring enabled: true/false)
* Last mirrored (Timestamp of last successful mirroring)

```
+------+------------------------------------------------+---------+--------------+--------------------+---------------+---------+---------------+
| ID   | Name                                           | Version | Architecture | Product string     | Release stage | Mirror? | Last mirrored |
+------+------------------------------------------------+---------+--------------+--------------------+---------------+---------+---------------+
| 1172 | SUSE Linux Enterprise Software Development Kit | 12      | x86_64       | sles-sdk/12/x86_64 | released      | true    | 2017-01-01    |
+------+------------------------------------------------+---------+--------------+--------------------+---------------+---------+---------------+
```

### rmt-cli repos list

Columns:

* ID
* Name
* Description
* Mirror? (Mirroring enabled: true/false)
* Mandatory? (Repository is enabled by zypper by default: true/false)
* Last mirrored (Timestamp of last successful mirroring)

```
+------+------------------+------------------------------------------------+---------+------------+---------------+
| ID   | Name             | Description                                    | Mirror? | Mandatory? | Last mirrored |
+------+------------------+------------------------------------------------+---------+------------+---------------+
| 1712 | SLE-HA12-Updates | SLE-HA12-Updates for sle-12-x86_64             | true    | true       | 2017-01-01    |
+------+------------------+------------------------------------------------+---------+------------+---------------+
```

##### Respective SMT commands

```
smt-list-products
smt-repos
smt-setup-custom-repos
```

```
smt-list-products : list known products
   --used       (-u) : show only used products
   --catstat    (-c) : show repository (catalog) status: Are all repositories localy mirrored, which are required for this product?
   --help       (-h) : show this help
   --format     (-f) : format the output ('asciitable', 'csv')
```

```
smt-repos [name] [target]: Enable or disable mirroring of a repository
   --enable-mirror    (-e)     : enable repository mirorring for $repository
   --disable-mirror   (-d)     : disable repository mirroring for $repository
   --enable-by-prod   (-p) arg : enable repository mirroring by giving product data
                                 Product[,Version[,Architecture[,Release]]]
                                 (call smt list-products to get a list of known products)
   --disable-by-prod  (-P) arg : disable repository mirroring by giving product data
                                 Product[,Version[,Architecture[,Release]]]
                                 (call smt list-products to get a list of known products)
   --exclude-optional (-x)     : exclude optional repositories when running with
                                 --enable-by-prod or --disable-by-prod flags
   --enable-staging   (-s)     : Enable staging for a repository
   --disable-staging  (-S)     : Disable staging for a repository
   --only-mirrorable  (-m)     : only show mirrorable repositories
   --only-enabled     (-o)     : only show repositories set to be mirrored
   --delete                    : delete the repository from disk
   --namespace             arg : specify the namespace of the repository which should be deleted
   --verbose          (-v)     : show detailed repository information
   --help             (-h)     : show this help
```

```
smt-setup-custom-repos : setup a custom repository
    --productid arg     Product id this repository belongs to.
                        You can use this option multiple times
                        to assign a repository to multiple products
    --name  arg         The name of this repository.
    --description arg   A description
    --exturl arg        The URL where this repository can be mirrored from
    --target arg        The target architecture of the repository
                        (only usefull when the product itself has no target architecture)
    --delete arg        Remove custom repository with the given ID. You can use this option multiple times.
                        Call 'smt repos --verbose' to find out the Repository ID
                        of the repository you want to delete.
    --addproductsto repoid Add new products to a custom repository defined by 'repoid'


Examples:

  smt-setup-custom-repos --productid 434 --name 'My_Repository' --exturl 'http://my.domain.top/My_Repository'
  smt-setup-custom-repos --delete 1cf336d819e8e5904f4d4b05ee081971a0cc8afc
  smt-setup-custom-repos --addproductsto 1cf336d819e8e5904f4d4b05ee081971a0cc8afc --productid 101010 --productid 101012
```


# Mirroring

##### Respective SMT commands

```
smt-mirror
```

```
smt-mirror [--directory path] [--deepverify] [--testrun] [--dbreplfile file] [-L file] [--debug] [--verboselevel level] [--nohardlink] [--mail] [--repository repositoryid]
smt-mirror --clean [--directory path] [--dbreplfile file] [-L file] [--debug]
smt-mirror --hardlink size [--directory path] [-L file] [--debug]

Options:
--debug -d              enable debug mode
--verboselevel -v level set the verbose level
--clean -c              cleanup all mirrored repositories.
                        Remove all files no longer mentioned in the metadata.
                        It does not mirror new files.
--hardlink size         Search for duplicate files with size > 'size' (in Kilobytes) and create hardlinks
                        for them
--directory arg         The directory to work on. Using this option ignores the configured
                        default value in smt.conf
--fromdir arg           Mirror from the directory give here, instead of mirroring from the remote sources.
                        The directory can e.g. be created by calling smt-mirror --directory
--fromlocalsmt          Mirror from the local running SMT server. This options requires the --directory
                        option being set. The resulting directory can  e.g later be imported to another server
                        using smt-mirror --fromdir
--deepverify            Verify all checksums
--testrun               Run mirror algorithm without downloading the rpms
                        (but it needs to download the metadata into a temporary directory).
                        It shows only the names which would be downloaded
--nohardlink            If a file already exists on the local harddisk do not link it into the
                        mirrored repository, but copy it.
--dbreplfile arg        Path to XML file to use as database replacement. Such a file can
                        be created with the sync-scc command. This option is only
                        useful if the smt database does not exist on the host from
                        which the smt-mirror script is being executed.
--mail -m               Send output as e-mail to the administrators defined in reportEmail in smt.conf.
                        The output on stdout and stderr will be suppressed.
--logfile -L file       Path to logfile
--repository ID         Repository ID to mirror. By default, all repositories are selected. Not allowed with --dbreplfile.
```

## Reporting

```
smt-report
smt-list-registrations
```

```
smt-repos [name] [target]: Enable or disable mirroring of a repository
   --enable-mirror    (-e)     : enable repository mirorring for $repository
   --disable-mirror   (-d)     : disable repository mirroring for $repository
   --enable-by-prod   (-p) arg : enable repository mirroring by giving product data
                                 Product[,Version[,Architecture[,Release]]]
                                 (call smt list-products to get a list of known products)
   --disable-by-prod  (-P) arg : disable repository mirroring by giving product data
                                 Product[,Version[,Architecture[,Release]]]
                                 (call smt list-products to get a list of known products)
   --exclude-optional (-x)     : exclude optional repositories when running with
                                 --enable-by-prod or --disable-by-prod flags
   --enable-staging   (-s)     : Enable staging for a repository
   --disable-staging  (-S)     : Disable staging for a repository
   --only-mirrorable  (-m)     : only show mirrorable repositories
   --only-enabled     (-o)     : only show repositories set to be mirrored
   --delete                    : delete the repository from disk
   --namespace             arg : specify the namespace of the repository which should be deleted
   --verbose          (-v)     : show detailed repository information
   --help             (-h)     : show this help
```

```
smt-list-registrations : list active registrations
    --help       (-h) : show this help
    --verbose    (-v) : show detailed informations about the registered devices
    --format     (-f) : format the output ('asciitable', 'csv')
```

# Various/other

```
smt-register
smt-delete-registration
```

```
smt-register [--reseterror] [--debug] [--logfile file] [--mail]

Register all clients at SCC which are currently not registered
or which data changed since the last registration.

Options:
--reseterror            reset the SCC registration error flag and try to submit failed registrations again.
--mail -m               Send output as e-mail to the administrators defined in reportEmail in smt.conf.
                        The output on stdout and stderr will be suppressed.
--debug -d              enable debug mode
--verboselevel -v level set the verbose level
--logfile -L file       Path to logfile
```

```
smt-delete-registration [OPTIONS]
Delete one or more registration from SCC and SMT

Options:
  --guid (-g)            : Unique ID of the client which should be deleted.
                           This option can be used multiple times.
  --debug (-d)           : enable debug mode
  --logfile (-L) <file>  : Path to logfile
  --older-than           : Limit time or delta from now to delete registrations older than this limit.
```
