## Description

Please describe your change and provide as much context as possible.

Fixes # (issue)

## Change Type

*Please select the correct option.*

- [ ] **Bug Fix** (a non-breaking change which fixes an issue)
- [ ] **New Feature** (a non-breaking change which adds new functionality)
- [ ] **Documentation Update** (a change which only updates documentation)

## Checklist

*Please check off each item if the requirement is met.*

- [ ] I have verified that my code follows RMT's coding standards with `rubocop`.
- [ ] I have reviewed my own code and believe that it's ready for an external review.
- [ ] I have provided comments for any hard-to-understand code.
- [ ] I have documented the `MANUAL.md` file with any changes to the user experience.
- [ ] RMT's test coverage remains at 100%.
- [ ] If my changes are non-trivial, I have added a changelog entry to notify users at `package/obs/rmt-server.changes`.

## Other Notes

Please use this space to provide notes or thoughts to the team, such as tips on how to review/demo your changes.
