---
order: 3
title: Visualization
---

The visual language is based on a set of design guidelines with data visualization features derived from the intermediate design language Ant Design, which makes the data expression more in line with the user's psychology, helping the “designer” to incubate visual solutions with more business characteristics to meet the individualization. Design requirements, shielding unnecessary design differences and implementation costs, thus liberating the "designer" and front-end R&D resources, and achieving comprehensive improvement of data chart development efficiency.

At the same time, this is a dynamically updated design document, your reading and feedback is the driving force for us to continue to advance, here is our [GitHub feedback url](https://github.com/antvis/site/issues).

## Design Resources

We provide comprehensive design principles & guidelines and design resource files (Sketch), as well as a complete graphical usage note to help users quickly understand charts and design high quality visualization charts.

- [Design Principles](https://antv.vision/zh/docs/specification/principles/basic)
- [Design Resources](https://antv.vision/zh/docs/specification/resources)
- [Charts Usage](https://antv-2018.alipay.com/zh-cn/vis/chart/index.html)

## Front end implementation

We encapsulate a set of AntV component libraries based on native JavaScript, which includes a high-interaction base chart library G2Plot, a chart library G6 focusing on process and relationship analysis, a chart library F2 for mobile applications, and other frameworks in the community.

- [G2: Grammar of Graphics](https://g2.antv.vision/en)
- [G2Plot: a charting library](https://g2plot.antv.vision/en) 🔥
- [G6: Graph Visualization Framework](https://g6.antv.vision/en)
- [F2: Mobile Charts](https://f2.antv.vision/en)
- [L7: Geospatial Visualization Analysis](https://l7.antv.vision/en)
