
set_property(GLOBAL PROPERTY CTEST_TARGETS_ADDED 1) # Do not add CTest default targets
include(CTest)
include(ExternalData)

set(target_qualifier "")
if(TARGET Experimental OR TARGET Nightly)
  set(target_qualifier "Extension")
endif()

if(WIN32)
  set(RUN_CTEST_CONFIGURE FALSE)
endif()

find_package(Git)
mark_as_superbuild(GIT_EXECUTABLE)
find_package(Subversion)
mark_as_superbuild(Subversion_SVN_EXECUTABLE)

set(Slicer_EXTENSIONS_TRACK_QUALIFIER "master" CACHE STRING "CDash extensions track qualifier (master, 4.4, ...)")

set(CTEST_MODEL "Experimental")
include(SlicerBlockUploadExtension)
add_custom_target(Experimental${target_qualifier}
  COMMAND ${EXTENSION_TEST_COMMAND}
  COMMENT "Build and test extension"
  )
add_custom_target(Experimental${target_qualifier}Upload
  COMMAND ${EXTENSION_UPLOAD_COMMAND}
  COMMENT "Build, test, package and upload extension"
  )

set(CTEST_MODEL "Nightly")
include(SlicerBlockUploadExtension)
add_custom_target(Nightly${target_qualifier}
  COMMAND ${EXTENSION_TEST_COMMAND}
  COMMENT "Build and test extension"
  )
add_custom_target(Nightly${target_qualifier}Upload
  COMMAND ${EXTENSION_UPLOAD_COMMAND}
  COMMENT "Build, test, package and upload extension"
  )
