/*==============================================================================

  Program: 3D Slicer

  Copyright (c) Kitware Inc.

  See COPYRIGHT.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  This file was originally developed by Julien Finet, Kitware Inc.
  and was partially funded by NIH grant 3P41RR013218-12S1

==============================================================================*/

#ifndef __qMRMLEventBrokerWidget_h
#define __qMRMLEventBrokerWidget_h

// Qt includes
#include <QWidget>

// CTK includes
#include <ctkPimpl.h>

#include "qMRMLWidgetsExport.h"

class QModelIndex;
class QTreeWidgetItem;
class qMRMLEventBrokerWidgetPrivate;
class vtkMRMLNode;
class vtkMRMLScene;
class vtkObject;

class QMRML_WIDGETS_EXPORT qMRMLEventBrokerWidget: public QWidget
{
  Q_OBJECT
public:
  typedef QWidget Superclass;
  explicit qMRMLEventBrokerWidget(QWidget *parent = nullptr);
  ~qMRMLEventBrokerWidget() override;

public slots:
  void refresh();
  void resetElapsedTimes();
  void expandElapsedTimeItems();

signals:
  void currentObjectChanged(vtkObject*);

protected slots:
  void onItemChanged(QTreeWidgetItem* item, int column);
  void onCurrentItemChanged(QTreeWidgetItem* currentItem);

protected:
  QScopedPointer<qMRMLEventBrokerWidgetPrivate> d_ptr;

private:
  Q_DECLARE_PRIVATE(qMRMLEventBrokerWidget);
  Q_DISABLE_COPY(qMRMLEventBrokerWidget);
};

#endif
