import os
import sys
from logging.config import fileConfig
from os import path

from alembic import context
from sqlalchemy import engine_from_config, pool

config = context.config

fileConfig(config.config_file_name)

# needed to import local modules
sys.path.insert(0, path.realpath(path.join(path.dirname(__file__), "..")))
from db import db  # noqa

try:
    # These imports are only needed for offline generation of automigrations.
    # Importing them in a prod-like environment breaks things.
    from journalist_app import create_app
    from sdconfig import SecureDropConfig

    # App context is needed for autogenerated migrations
    sdconfig = SecureDropConfig.get_current()
    create_app(sdconfig).app_context().push()
except Exception:
    # Only reraise the exception in 'dev' where a developer actually cares
    if os.environ.get("SECUREDROP_ENV") == "dev":
        raise


target_metadata = db.Model.metadata


def run_migrations_offline() -> None:
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option("sqlalchemy.url")
    context.configure(
        url=url, target_metadata=target_metadata, compare_type=True, literal_binds=True
    )

    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online() -> None:
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """
    connectable = engine_from_config(
        config.get_section(config.config_ini_section), prefix="sqlalchemy.", poolclass=pool.NullPool
    )

    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
            compare_type=True,
            render_as_batch=True,
        )

        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
