// This file is part of the ACTS project.
//
// Copyright (C) 2016 CERN for the benefit of the ACTS project
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

// The entries within this file have been automatically created using the
// particle data files from the 2019 edition of the Review of Particle Physics
// by the Berkeley Particle Data Group.

#pragma once

#include <array>
#include <cstdint>
#include <limits>

// Rows within the particle data table are sorted by their signed PDG particle
// number and are then stored column-wise. Since the PDG particle number column
// is sorted it can be used to quickly search for the index of a particle
// within all column arrays.

static constexpr std::uint32_t kParticlesCount = 6502u;
static const std::array<std::int32_t, kParticlesCount> kParticlesPdgNumber = {
    // Og294~
    -1001182940,
    // Ts294~
    -1001172940,
    // Lv293~
    -1001162930,
    // Mc289~
    -1001152890,
    // Fl289~
    -1001142890,
    // Nh286~
    -1001132860,
    // Cn285~
    -1001122850,
    // Rg272~
    -1001112720,
    // Ds281~
    -1001102810,
    // Ds273~
    -1001102730,
    // Ds272~
    -1001102720,
    // Ds271~
    -1001102710,
    // Ds270~
    -1001102700,
    // Ds269~
    -1001102690,
    // Ds268~
    -1001102680,
    // Ds267~
    -1001102670,
    // Mt271~
    -1001092710,
    // Mt270~
    -1001092700,
    // Mt269~
    -1001092690,
    // Mt268~
    -1001092680,
    // Mt267~
    -1001092670,
    // Mt266~
    -1001092660,
    // Mt265~
    -1001092650,
    // Hs277~
    -1001082770,
    // Hs269~
    -1001082690,
    // Hs268~
    -1001082680,
    // Hs267~
    -1001082670,
    // Hs266~
    -1001082660,
    // Hs265~
    -1001082650,
    // Hs264~
    -1001082640,
    // Hs263~
    -1001082630,
    // Bh267~
    -1001072670,
    // Bh266~
    -1001072660,
    // Bh265~
    -1001072650,
    // Bh264~
    -1001072640,
    // Bh263~
    -1001072630,
    // Bh262~
    -1001072620,
    // Bh261~
    -1001072610,
    // Bh260~
    -1001072600,
    // Sg266~
    -1001062660,
    // Sg265~
    -1001062650,
    // Sg264~
    -1001062640,
    // Sg263~
    -1001062630,
    // Sg262~
    -1001062620,
    // Sg261~
    -1001062610,
    // Sg260~
    -1001062600,
    // Sg259~
    -1001062590,
    // Sg258~
    -1001062580,
    // Db265~
    -1001052650,
    // Db264~
    -1001052640,
    // Db263~
    -1001052630,
    // Db262~
    -1001052620,
    // Db261~
    -1001052610,
    // Db260~
    -1001052600,
    // Db259~
    -1001052590,
    // Db258~
    -1001052580,
    // Db257~
    -1001052570,
    // Db256~
    -1001052560,
    // Db255~
    -1001052550,
    // Rf264~
    -1001042640,
    // Rf263~
    -1001042630,
    // Rf262~
    -1001042620,
    // Rf261~
    -1001042610,
    // Rf260~
    -1001042600,
    // Rf259~
    -1001042590,
    // Rf258~
    -1001042580,
    // Rf257~
    -1001042570,
    // Rf256~
    -1001042560,
    // Rf255~
    -1001042550,
    // Rf254~
    -1001042540,
    // Rf253~
    -1001042530,
    // Lr263~
    -1001032630,
    // Lr262~
    -1001032620,
    // Lr261~
    -1001032610,
    // Lr260~
    -1001032600,
    // Lr259~
    -1001032590,
    // Lr258~
    -1001032580,
    // Lr257~
    -1001032570,
    // Lr256~
    -1001032560,
    // Lr255~
    -1001032550,
    // Lr254~
    -1001032540,
    // Lr253~
    -1001032530,
    // Lr252~
    -1001032520,
    // Lr251~
    -1001032510,
    // No262~
    -1001022620,
    // No261~
    -1001022610,
    // No260~
    -1001022600,
    // No259~
    -1001022590,
    // No258~
    -1001022580,
    // No257~
    -1001022570,
    // No256~
    -1001022560,
    // No255~
    -1001022550,
    // No254~
    -1001022540,
    // No253~
    -1001022530,
    // No252~
    -1001022520,
    // No251~
    -1001022510,
    // No250~
    -1001022500,
    // No249~
    -1001022490,
    // Md260~
    -1001012600,
    // Md259~
    -1001012590,
    // Md258~
    -1001012580,
    // Md257~
    -1001012570,
    // Md256~
    -1001012560,
    // Md255~
    -1001012550,
    // Md254~
    -1001012540,
    // Md253~
    -1001012530,
    // Md252~
    -1001012520,
    // Md251~
    -1001012510,
    // Md250~
    -1001012500,
    // Md249~
    -1001012490,
    // Md248~
    -1001012480,
    // Md247~
    -1001012470,
    // Md246~
    -1001012460,
    // Md245~
    -1001012450,
    // Fm259~
    -1001002590,
    // Fm258~
    -1001002580,
    // Fm257~
    -1001002570,
    // Fm256~
    -1001002560,
    // Fm255~
    -1001002550,
    // Fm254~
    -1001002540,
    // Fm253~
    -1001002530,
    // Fm252~
    -1001002520,
    // Fm251~
    -1001002510,
    // Fm250~
    -1001002500,
    // Fm249~
    -1001002490,
    // Fm248~
    -1001002480,
    // Fm247~
    -1001002470,
    // Fm246~
    -1001002460,
    // Fm245~
    -1001002450,
    // Fm244~
    -1001002440,
    // Fm243~
    -1001002430,
    // Fm242~
    -1001002420,
    // Es257~
    -1000992570,
    // Es256~
    -1000992560,
    // Es255~
    -1000992550,
    // Es254~
    -1000992540,
    // Es253~
    -1000992530,
    // Es252~
    -1000992520,
    // Es251~
    -1000992510,
    // Es250~
    -1000992500,
    // Es249~
    -1000992490,
    // Es248~
    -1000992480,
    // Es247~
    -1000992470,
    // Es246~
    -1000992460,
    // Es245~
    -1000992450,
    // Es244~
    -1000992440,
    // Es243~
    -1000992430,
    // Es242~
    -1000992420,
    // Es241~
    -1000992410,
    // Es240~
    -1000992400,
    // Cf256~
    -1000982560,
    // Cf255~
    -1000982550,
    // Cf254~
    -1000982540,
    // Cf253~
    -1000982530,
    // Cf252~
    -1000982520,
    // Cf251~
    -1000982510,
    // Cf250~
    -1000982500,
    // Cf249~
    -1000982490,
    // Cf248~
    -1000982480,
    // Cf247~
    -1000982470,
    // Cf246~
    -1000982460,
    // Cf245~
    -1000982450,
    // Cf244~
    -1000982440,
    // Cf243~
    -1000982430,
    // Cf242~
    -1000982420,
    // Cf241~
    -1000982410,
    // Cf240~
    -1000982400,
    // Cf239~
    -1000982390,
    // Cf238~
    -1000982380,
    // Cf237~
    -1000982370,
    // Bk254~
    -1000972540,
    // Bk253~
    -1000972530,
    // Bk252~
    -1000972520,
    // Bk251~
    -1000972510,
    // Bk250~
    -1000972500,
    // Bk249~
    -1000972490,
    // Bk248~
    -1000972480,
    // Bk247~
    -1000972470,
    // Bk246~
    -1000972460,
    // Bk245~
    -1000972450,
    // Bk244~
    -1000972440,
    // Bk243~
    -1000972430,
    // Bk242~
    -1000972420,
    // Bk241~
    -1000972410,
    // Bk240~
    -1000972400,
    // Bk239~
    -1000972390,
    // Bk238~
    -1000972380,
    // Bk237~
    -1000972370,
    // Bk236~
    -1000972360,
    // Bk235~
    -1000972350,
    // Cm252~
    -1000962520,
    // Cm251~
    -1000962510,
    // Cm250~
    -1000962500,
    // Cm249~
    -1000962490,
    // Cm248~
    -1000962480,
    // Cm247~
    -1000962470,
    // Cm246~
    -1000962460,
    // Cm245~
    -1000962450,
    // Cm244~
    -1000962440,
    // Cm243~
    -1000962430,
    // Cm242~
    -1000962420,
    // Cm241~
    -1000962410,
    // Cm240~
    -1000962400,
    // Cm239~
    -1000962390,
    // Cm238~
    -1000962380,
    // Cm237~
    -1000962370,
    // Cm236~
    -1000962360,
    // Cm235~
    -1000962350,
    // Cm234~
    -1000962340,
    // Cm233~
    -1000962330,
    // Am249~
    -1000952490,
    // Am248~
    -1000952480,
    // Am247~
    -1000952470,
    // Am246~
    -1000952460,
    // Am245~
    -1000952450,
    // Am244~
    -1000952440,
    // Am243~
    -1000952430,
    // Am242~
    -1000952420,
    // Am241~
    -1000952410,
    // Am240~
    -1000952400,
    // Am239~
    -1000952390,
    // Am238~
    -1000952380,
    // Am237~
    -1000952370,
    // Am236~
    -1000952360,
    // Am235~
    -1000952350,
    // Am234~
    -1000952340,
    // Am233~
    -1000952330,
    // Am232~
    -1000952320,
    // Am231~
    -1000952310,
    // Pu247~
    -1000942470,
    // Pu246~
    -1000942460,
    // Pu245~
    -1000942450,
    // Pu244~
    -1000942440,
    // Pu243~
    -1000942430,
    // Pu242~
    -1000942420,
    // Pu241~
    -1000942410,
    // Pu240~
    -1000942400,
    // Pu239~
    -1000942390,
    // Pu238~
    -1000942380,
    // Pu237~
    -1000942370,
    // Pu236~
    -1000942360,
    // Pu235~
    -1000942350,
    // Pu234~
    -1000942340,
    // Pu233~
    -1000942330,
    // Pu232~
    -1000942320,
    // Pu231~
    -1000942310,
    // Pu230~
    -1000942300,
    // Pu229~
    -1000942290,
    // Pu228~
    -1000942280,
    // Np244~
    -1000932440,
    // Np243~
    -1000932430,
    // Np242~
    -1000932420,
    // Np241~
    -1000932410,
    // Np240~
    -1000932400,
    // Np239~
    -1000932390,
    // Np238~
    -1000932380,
    // Np237~
    -1000932370,
    // Np236~
    -1000932360,
    // Np235~
    -1000932350,
    // Np234~
    -1000932340,
    // Np233~
    -1000932330,
    // Np232~
    -1000932320,
    // Np231~
    -1000932310,
    // Np230~
    -1000932300,
    // Np229~
    -1000932290,
    // Np228~
    -1000932280,
    // Np227~
    -1000932270,
    // Np226~
    -1000932260,
    // Np225~
    -1000932250,
    // U242~
    -1000922420,
    // U241~
    -1000922410,
    // U240~
    -1000922400,
    // U239~
    -1000922390,
    // U238~
    -1000922380,
    // U237~
    -1000922370,
    // U236~
    -1000922360,
    // U235~
    -1000922350,
    // U234~
    -1000922340,
    // U233~
    -1000922330,
    // U232~
    -1000922320,
    // U231~
    -1000922310,
    // U230~
    -1000922300,
    // U229~
    -1000922290,
    // U228~
    -1000922280,
    // U227~
    -1000922270,
    // U226~
    -1000922260,
    // U225~
    -1000922250,
    // U224~
    -1000922240,
    // U223~
    -1000922230,
    // U222~
    -1000922220,
    // U221~
    -1000922210,
    // U220~
    -1000922200,
    // U219~
    -1000922190,
    // U218~
    -1000922180,
    // Pa240~
    -1000912400,
    // Pa239~
    -1000912390,
    // Pa238~
    -1000912380,
    // Pa237~
    -1000912370,
    // Pa236~
    -1000912360,
    // Pa235~
    -1000912350,
    // Pa234~
    -1000912340,
    // Pa233~
    -1000912330,
    // Pa232~
    -1000912320,
    // Pa231~
    -1000912310,
    // Pa230~
    -1000912300,
    // Pa229~
    -1000912290,
    // Pa228~
    -1000912280,
    // Pa227~
    -1000912270,
    // Pa226~
    -1000912260,
    // Pa225~
    -1000912250,
    // Pa224~
    -1000912240,
    // Pa223~
    -1000912230,
    // Pa222~
    -1000912220,
    // Pa221~
    -1000912210,
    // Pa220~
    -1000912200,
    // Pa219~
    -1000912190,
    // Pa218~
    -1000912180,
    // Pa217~
    -1000912170,
    // Pa216~
    -1000912160,
    // Pa215~
    -1000912150,
    // Pa214~
    -1000912140,
    // Pa213~
    -1000912130,
    // Th238~
    -1000902380,
    // Th237~
    -1000902370,
    // Th236~
    -1000902360,
    // Th235~
    -1000902350,
    // Th234~
    -1000902340,
    // Th233~
    -1000902330,
    // Th232~
    -1000902320,
    // Th231~
    -1000902310,
    // Th230~
    -1000902300,
    // Th229~
    -1000902290,
    // Th228~
    -1000902280,
    // Th227~
    -1000902270,
    // Th226~
    -1000902260,
    // Th225~
    -1000902250,
    // Th224~
    -1000902240,
    // Th223~
    -1000902230,
    // Th222~
    -1000902220,
    // Th221~
    -1000902210,
    // Th220~
    -1000902200,
    // Th219~
    -1000902190,
    // Th218~
    -1000902180,
    // Th217~
    -1000902170,
    // Th216~
    -1000902160,
    // Th215~
    -1000902150,
    // Th214~
    -1000902140,
    // Th213~
    -1000902130,
    // Th212~
    -1000902120,
    // Th211~
    -1000902110,
    // Th210~
    -1000902100,
    // Ac236~
    -1000892360,
    // Ac235~
    -1000892350,
    // Ac234~
    -1000892340,
    // Ac233~
    -1000892330,
    // Ac232~
    -1000892320,
    // Ac231~
    -1000892310,
    // Ac230~
    -1000892300,
    // Ac229~
    -1000892290,
    // Ac228~
    -1000892280,
    // Ac227~
    -1000892270,
    // Ac226~
    -1000892260,
    // Ac225~
    -1000892250,
    // Ac224~
    -1000892240,
    // Ac223~
    -1000892230,
    // Ac222~
    -1000892220,
    // Ac221~
    -1000892210,
    // Ac220~
    -1000892200,
    // Ac219~
    -1000892190,
    // Ac218~
    -1000892180,
    // Ac217~
    -1000892170,
    // Ac216~
    -1000892160,
    // Ac215~
    -1000892150,
    // Ac214~
    -1000892140,
    // Ac213~
    -1000892130,
    // Ac212~
    -1000892120,
    // Ac211~
    -1000892110,
    // Ac210~
    -1000892100,
    // Ac209~
    -1000892090,
    // Ac208~
    -1000892080,
    // Ac207~
    -1000892070,
    // Ra234~
    -1000882340,
    // Ra233~
    -1000882330,
    // Ra232~
    -1000882320,
    // Ra231~
    -1000882310,
    // Ra230~
    -1000882300,
    // Ra229~
    -1000882290,
    // Ra228~
    -1000882280,
    // Ra227~
    -1000882270,
    // Ra226~
    -1000882260,
    // Ra225~
    -1000882250,
    // Ra224~
    -1000882240,
    // Ra223~
    -1000882230,
    // Ra222~
    -1000882220,
    // Ra221~
    -1000882210,
    // Ra220~
    -1000882200,
    // Ra219~
    -1000882190,
    // Ra218~
    -1000882180,
    // Ra217~
    -1000882170,
    // Ra216~
    -1000882160,
    // Ra215~
    -1000882150,
    // Ra214~
    -1000882140,
    // Ra213~
    -1000882130,
    // Ra212~
    -1000882120,
    // Ra211~
    -1000882110,
    // Ra210~
    -1000882100,
    // Ra209~
    -1000882090,
    // Ra208~
    -1000882080,
    // Ra207~
    -1000882070,
    // Ra206~
    -1000882060,
    // Ra205~
    -1000882050,
    // Ra204~
    -1000882040,
    // Ra203~
    -1000882030,
    // Fr232~
    -1000872320,
    // Fr231~
    -1000872310,
    // Fr230~
    -1000872300,
    // Fr229~
    -1000872290,
    // Fr228~
    -1000872280,
    // Fr227~
    -1000872270,
    // Fr226~
    -1000872260,
    // Fr225~
    -1000872250,
    // Fr224~
    -1000872240,
    // Fr223~
    -1000872230,
    // Fr222~
    -1000872220,
    // Fr221~
    -1000872210,
    // Fr220~
    -1000872200,
    // Fr219~
    -1000872190,
    // Fr218~
    -1000872180,
    // Fr217~
    -1000872170,
    // Fr216~
    -1000872160,
    // Fr215~
    -1000872150,
    // Fr214~
    -1000872140,
    // Fr213~
    -1000872130,
    // Fr212~
    -1000872120,
    // Fr211~
    -1000872110,
    // Fr210~
    -1000872100,
    // Fr209~
    -1000872090,
    // Fr208~
    -1000872080,
    // Fr207~
    -1000872070,
    // Fr206~
    -1000872060,
    // Fr205~
    -1000872050,
    // Fr204~
    -1000872040,
    // Fr203~
    -1000872030,
    // Fr202~
    -1000872020,
    // Fr201~
    -1000872010,
    // Fr200~
    -1000872000,
    // Rn228~
    -1000862280,
    // Rn227~
    -1000862270,
    // Rn226~
    -1000862260,
    // Rn225~
    -1000862250,
    // Rn224~
    -1000862240,
    // Rn223~
    -1000862230,
    // Rn222~
    -1000862220,
    // Rn221~
    -1000862210,
    // Rn220~
    -1000862200,
    // Rn219~
    -1000862190,
    // Rn218~
    -1000862180,
    // Rn217~
    -1000862170,
    // Rn216~
    -1000862160,
    // Rn215~
    -1000862150,
    // Rn214~
    -1000862140,
    // Rn213~
    -1000862130,
    // Rn212~
    -1000862120,
    // Rn211~
    -1000862110,
    // Rn210~
    -1000862100,
    // Rn209~
    -1000862090,
    // Rn208~
    -1000862080,
    // Rn207~
    -1000862070,
    // Rn206~
    -1000862060,
    // Rn205~
    -1000862050,
    // Rn204~
    -1000862040,
    // Rn203~
    -1000862030,
    // Rn202~
    -1000862020,
    // Rn201~
    -1000862010,
    // Rn200~
    -1000862000,
    // Rn199~
    -1000861990,
    // Rn198~
    -1000861980,
    // Rn197~
    -1000861970,
    // Rn196~
    -1000861960,
    // At223~
    -1000852230,
    // At222~
    -1000852220,
    // At221~
    -1000852210,
    // At220~
    -1000852200,
    // At219~
    -1000852190,
    // At218~
    -1000852180,
    // At217~
    -1000852170,
    // At216~
    -1000852160,
    // At215~
    -1000852150,
    // At214~
    -1000852140,
    // At213~
    -1000852130,
    // At212~
    -1000852120,
    // At211~
    -1000852110,
    // At210~
    -1000852100,
    // At209~
    -1000852090,
    // At208~
    -1000852080,
    // At207~
    -1000852070,
    // At206~
    -1000852060,
    // At205~
    -1000852050,
    // At204~
    -1000852040,
    // At203~
    -1000852030,
    // At202~
    -1000852020,
    // At201~
    -1000852010,
    // At200~
    -1000852000,
    // At199~
    -1000851990,
    // At198~
    -1000851980,
    // At197~
    -1000851970,
    // At196~
    -1000851960,
    // At195~
    -1000851950,
    // At194~
    -1000851940,
    // At193~
    -1000851930,
    // Po218~
    -1000842180,
    // Po217~
    -1000842170,
    // Po216~
    -1000842160,
    // Po215~
    -1000842150,
    // Po214~
    -1000842140,
    // Po213~
    -1000842130,
    // Po212~
    -1000842120,
    // Po211~
    -1000842110,
    // Po210~
    -1000842100,
    // Po209~
    -1000842090,
    // Po208~
    -1000842080,
    // Po207~
    -1000842070,
    // Po206~
    -1000842060,
    // Po205~
    -1000842050,
    // Po204~
    -1000842040,
    // Po203~
    -1000842030,
    // Po202~
    -1000842020,
    // Po201~
    -1000842010,
    // Po200~
    -1000842000,
    // Po199~
    -1000841990,
    // Po198~
    -1000841980,
    // Po197~
    -1000841970,
    // Po196~
    -1000841960,
    // Po195~
    -1000841950,
    // Po194~
    -1000841940,
    // Po193~
    -1000841930,
    // Po192~
    -1000841920,
    // Po191~
    -1000841910,
    // Po190~
    -1000841900,
    // Bi216~
    -1000832160,
    // Bi215~
    -1000832150,
    // Bi214~
    -1000832140,
    // Bi213~
    -1000832130,
    // Bi212~
    -1000832120,
    // Bi211~
    -1000832110,
    // Bi210~
    -1000832100,
    // Bi209~
    -1000832090,
    // Bi208~
    -1000832080,
    // Bi207~
    -1000832070,
    // Bi206~
    -1000832060,
    // Bi205~
    -1000832050,
    // Bi204~
    -1000832040,
    // Bi203~
    -1000832030,
    // Bi202~
    -1000832020,
    // Bi201~
    -1000832010,
    // Bi200~
    -1000832000,
    // Bi199~
    -1000831990,
    // Bi198~
    -1000831980,
    // Bi197~
    -1000831970,
    // Bi196~
    -1000831960,
    // Bi195~
    -1000831950,
    // Bi194~
    -1000831940,
    // Bi193~
    -1000831930,
    // Bi192~
    -1000831920,
    // Bi191~
    -1000831910,
    // Bi190~
    -1000831900,
    // Bi189~
    -1000831890,
    // Bi188~
    -1000831880,
    // Bi187~
    -1000831870,
    // Bi186~
    -1000831860,
    // Bi185~
    -1000831850,
    // Pb214~
    -1000822140,
    // Pb213~
    -1000822130,
    // Pb212~
    -1000822120,
    // Pb211~
    -1000822110,
    // Pb210~
    -1000822100,
    // Pb209~
    -1000822090,
    // Pb208~
    -1000822080,
    // Pb207~
    -1000822070,
    // Pb206~
    -1000822060,
    // Pb205~
    -1000822050,
    // Pb204~
    -1000822040,
    // Pb203~
    -1000822030,
    // Pb202~
    -1000822020,
    // Pb201~
    -1000822010,
    // Pb200~
    -1000822000,
    // Pb199~
    -1000821990,
    // Pb198~
    -1000821980,
    // Pb197~
    -1000821970,
    // Pb196~
    -1000821960,
    // Pb195~
    -1000821950,
    // Pb194~
    -1000821940,
    // Pb193~
    -1000821930,
    // Pb192~
    -1000821920,
    // Pb191~
    -1000821910,
    // Pb190~
    -1000821900,
    // Pb189~
    -1000821890,
    // Pb188~
    -1000821880,
    // Pb187~
    -1000821870,
    // Pb186~
    -1000821860,
    // Pb185~
    -1000821850,
    // Pb184~
    -1000821840,
    // Pb183~
    -1000821830,
    // Pb182~
    -1000821820,
    // Pb181~
    -1000821810,
    // Tl210~
    -1000812100,
    // Tl209~
    -1000812090,
    // Tl208~
    -1000812080,
    // Tl207~
    -1000812070,
    // Tl206~
    -1000812060,
    // Tl205~
    -1000812050,
    // Tl204~
    -1000812040,
    // Tl203~
    -1000812030,
    // Tl202~
    -1000812020,
    // Tl201~
    -1000812010,
    // Tl200~
    -1000812000,
    // Tl199~
    -1000811990,
    // Tl198~
    -1000811980,
    // Tl197~
    -1000811970,
    // Tl196~
    -1000811960,
    // Tl195~
    -1000811950,
    // Tl194~
    -1000811940,
    // Tl193~
    -1000811930,
    // Tl192~
    -1000811920,
    // Tl191~
    -1000811910,
    // Tl190~
    -1000811900,
    // Tl189~
    -1000811890,
    // Tl188~
    -1000811880,
    // Tl187~
    -1000811870,
    // Tl186~
    -1000811860,
    // Tl185~
    -1000811850,
    // Tl184~
    -1000811840,
    // Tl183~
    -1000811830,
    // Tl182~
    -1000811820,
    // Tl181~
    -1000811810,
    // Tl180~
    -1000811800,
    // Tl179~
    -1000811790,
    // Tl178~
    -1000811780,
    // Tl177~
    -1000811770,
    // Hg208~
    -1000802080,
    // Hg207~
    -1000802070,
    // Hg206~
    -1000802060,
    // Hg205~
    -1000802050,
    // Hg204~
    -1000802040,
    // Hg203~
    -1000802030,
    // Hg202~
    -1000802020,
    // Hg201~
    -1000802010,
    // Hg200~
    -1000802000,
    // Hg199~
    -1000801990,
    // Hg198~
    -1000801980,
    // Hg197~
    -1000801970,
    // Hg196~
    -1000801960,
    // Hg195~
    -1000801950,
    // Hg194~
    -1000801940,
    // Hg193~
    -1000801930,
    // Hg192~
    -1000801920,
    // Hg191~
    -1000801910,
    // Hg190~
    -1000801900,
    // Hg189~
    -1000801890,
    // Hg188~
    -1000801880,
    // Hg187~
    -1000801870,
    // Hg186~
    -1000801860,
    // Hg185~
    -1000801850,
    // Hg184~
    -1000801840,
    // Hg183~
    -1000801830,
    // Hg182~
    -1000801820,
    // Hg181~
    -1000801810,
    // Hg180~
    -1000801800,
    // Hg179~
    -1000801790,
    // Hg178~
    -1000801780,
    // Hg177~
    -1000801770,
    // Hg176~
    -1000801760,
    // Hg175~
    -1000801750,
    // Au205~
    -1000792050,
    // Au204~
    -1000792040,
    // Au203~
    -1000792030,
    // Au202~
    -1000792020,
    // Au201~
    -1000792010,
    // Au200~
    -1000792000,
    // Au199~
    -1000791990,
    // Au198~
    -1000791980,
    // Au197~
    -1000791970,
    // Au196~
    -1000791960,
    // Au195~
    -1000791950,
    // Au194~
    -1000791940,
    // Au193~
    -1000791930,
    // Au192~
    -1000791920,
    // Au191~
    -1000791910,
    // Au190~
    -1000791900,
    // Au189~
    -1000791890,
    // Au188~
    -1000791880,
    // Au187~
    -1000791870,
    // Au186~
    -1000791860,
    // Au185~
    -1000791850,
    // Au184~
    -1000791840,
    // Au183~
    -1000791830,
    // Au182~
    -1000791820,
    // Au181~
    -1000791810,
    // Au180~
    -1000791800,
    // Au179~
    -1000791790,
    // Au178~
    -1000791780,
    // Au177~
    -1000791770,
    // Au176~
    -1000791760,
    // Au175~
    -1000791750,
    // Au174~
    -1000791740,
    // Au173~
    -1000791730,
    // Au172~
    -1000791720,
    // Au171~
    -1000791710,
    // Pt202~
    -1000782020,
    // Pt201~
    -1000782010,
    // Pt200~
    -1000782000,
    // Pt199~
    -1000781990,
    // Pt198~
    -1000781980,
    // Pt197~
    -1000781970,
    // Pt196~
    -1000781960,
    // Pt195~
    -1000781950,
    // Pt194~
    -1000781940,
    // Pt193~
    -1000781930,
    // Pt192~
    -1000781920,
    // Pt191~
    -1000781910,
    // Pt190~
    -1000781900,
    // Pt189~
    -1000781890,
    // Pt188~
    -1000781880,
    // Pt187~
    -1000781870,
    // Pt186~
    -1000781860,
    // Pt185~
    -1000781850,
    // Pt184~
    -1000781840,
    // Pt183~
    -1000781830,
    // Pt182~
    -1000781820,
    // Pt181~
    -1000781810,
    // Pt180~
    -1000781800,
    // Pt179~
    -1000781790,
    // Pt178~
    -1000781780,
    // Pt177~
    -1000781770,
    // Pt176~
    -1000781760,
    // Pt175~
    -1000781750,
    // Pt174~
    -1000781740,
    // Pt173~
    -1000781730,
    // Pt172~
    -1000781720,
    // Pt171~
    -1000781710,
    // Pt170~
    -1000781700,
    // Pt169~
    -1000781690,
    // Pt168~
    -1000781680,
    // Ir199~
    -1000771990,
    // Ir198~
    -1000771980,
    // Ir197~
    -1000771970,
    // Ir196~
    -1000771960,
    // Ir195~
    -1000771950,
    // Ir194~
    -1000771940,
    // Ir193~
    -1000771930,
    // Ir192~
    -1000771920,
    // Ir191~
    -1000771910,
    // Ir190~
    -1000771900,
    // Ir189~
    -1000771890,
    // Ir188~
    -1000771880,
    // Ir187~
    -1000771870,
    // Ir186~
    -1000771860,
    // Ir185~
    -1000771850,
    // Ir184~
    -1000771840,
    // Ir183~
    -1000771830,
    // Ir182~
    -1000771820,
    // Ir181~
    -1000771810,
    // Ir180~
    -1000771800,
    // Ir179~
    -1000771790,
    // Ir178~
    -1000771780,
    // Ir177~
    -1000771770,
    // Ir176~
    -1000771760,
    // Ir175~
    -1000771750,
    // Ir174~
    -1000771740,
    // Ir173~
    -1000771730,
    // Ir172~
    -1000771720,
    // Ir171~
    -1000771710,
    // Ir170~
    -1000771700,
    // Ir169~
    -1000771690,
    // Ir168~
    -1000771680,
    // Ir167~
    -1000771670,
    // Ir166~
    -1000771660,
    // Ir165~
    -1000771650,
    // Os196~
    -1000761960,
    // Os195~
    -1000761950,
    // Os194~
    -1000761940,
    // Os193~
    -1000761930,
    // Os192~
    -1000761920,
    // Os191~
    -1000761910,
    // Os190~
    -1000761900,
    // Os189~
    -1000761890,
    // Os188~
    -1000761880,
    // Os187~
    -1000761870,
    // Os186~
    -1000761860,
    // Os185~
    -1000761850,
    // Os184~
    -1000761840,
    // Os183~
    -1000761830,
    // Os182~
    -1000761820,
    // Os181~
    -1000761810,
    // Os180~
    -1000761800,
    // Os179~
    -1000761790,
    // Os178~
    -1000761780,
    // Os177~
    -1000761770,
    // Os176~
    -1000761760,
    // Os175~
    -1000761750,
    // Os174~
    -1000761740,
    // Os173~
    -1000761730,
    // Os172~
    -1000761720,
    // Os171~
    -1000761710,
    // Os170~
    -1000761700,
    // Os169~
    -1000761690,
    // Os168~
    -1000761680,
    // Os167~
    -1000761670,
    // Os166~
    -1000761660,
    // Os165~
    -1000761650,
    // Os164~
    -1000761640,
    // Os163~
    -1000761630,
    // Os162~
    -1000761620,
    // Re192~
    -1000751920,
    // Re191~
    -1000751910,
    // Re190~
    -1000751900,
    // Re189~
    -1000751890,
    // Re188~
    -1000751880,
    // Re187~
    -1000751870,
    // Re186~
    -1000751860,
    // Re185~
    -1000751850,
    // Re184~
    -1000751840,
    // Re183~
    -1000751830,
    // Re182~
    -1000751820,
    // Re181~
    -1000751810,
    // Re180~
    -1000751800,
    // Re179~
    -1000751790,
    // Re178~
    -1000751780,
    // Re177~
    -1000751770,
    // Re176~
    -1000751760,
    // Re175~
    -1000751750,
    // Re174~
    -1000751740,
    // Re173~
    -1000751730,
    // Re172~
    -1000751720,
    // Re171~
    -1000751710,
    // Re170~
    -1000751700,
    // Re169~
    -1000751690,
    // Re168~
    -1000751680,
    // Re167~
    -1000751670,
    // Re166~
    -1000751660,
    // Re165~
    -1000751650,
    // Re164~
    -1000751640,
    // Re163~
    -1000751630,
    // Re162~
    -1000751620,
    // Re161~
    -1000751610,
    // Re160~
    -1000751600,
    // W190~
    -1000741900,
    // W189~
    -1000741890,
    // W188~
    -1000741880,
    // W187~
    -1000741870,
    // W186~
    -1000741860,
    // W185~
    -1000741850,
    // W184~
    -1000741840,
    // W183~
    -1000741830,
    // W182~
    -1000741820,
    // W181~
    -1000741810,
    // W180~
    -1000741800,
    // W179~
    -1000741790,
    // W178~
    -1000741780,
    // W177~
    -1000741770,
    // W176~
    -1000741760,
    // W175~
    -1000741750,
    // W174~
    -1000741740,
    // W173~
    -1000741730,
    // W172~
    -1000741720,
    // W171~
    -1000741710,
    // W170~
    -1000741700,
    // W169~
    -1000741690,
    // W168~
    -1000741680,
    // W167~
    -1000741670,
    // W166~
    -1000741660,
    // W165~
    -1000741650,
    // W164~
    -1000741640,
    // W163~
    -1000741630,
    // W162~
    -1000741620,
    // W161~
    -1000741610,
    // W160~
    -1000741600,
    // W159~
    -1000741590,
    // W158~
    -1000741580,
    // Ta188~
    -1000731880,
    // Ta187~
    -1000731870,
    // Ta186~
    -1000731860,
    // Ta185~
    -1000731850,
    // Ta184~
    -1000731840,
    // Ta183~
    -1000731830,
    // Ta182~
    -1000731820,
    // Ta181~
    -1000731810,
    // Ta180~
    -1000731800,
    // Ta179~
    -1000731790,
    // Ta178~
    -1000731780,
    // Ta177~
    -1000731770,
    // Ta176~
    -1000731760,
    // Ta175~
    -1000731750,
    // Ta174~
    -1000731740,
    // Ta173~
    -1000731730,
    // Ta172~
    -1000731720,
    // Ta171~
    -1000731710,
    // Ta170~
    -1000731700,
    // Ta169~
    -1000731690,
    // Ta168~
    -1000731680,
    // Ta167~
    -1000731670,
    // Ta166~
    -1000731660,
    // Ta165~
    -1000731650,
    // Ta164~
    -1000731640,
    // Ta163~
    -1000731630,
    // Ta162~
    -1000731620,
    // Ta161~
    -1000731610,
    // Ta160~
    -1000731600,
    // Ta159~
    -1000731590,
    // Ta158~
    -1000731580,
    // Ta157~
    -1000731570,
    // Ta156~
    -1000731560,
    // Hf186~
    -1000721860,
    // Hf185~
    -1000721850,
    // Hf184~
    -1000721840,
    // Hf183~
    -1000721830,
    // Hf182~
    -1000721820,
    // Hf181~
    -1000721810,
    // Hf180~
    -1000721800,
    // Hf179~
    -1000721790,
    // Hf178~
    -1000721780,
    // Hf177~
    -1000721770,
    // Hf176~
    -1000721760,
    // Hf175~
    -1000721750,
    // Hf174~
    -1000721740,
    // Hf173~
    -1000721730,
    // Hf172~
    -1000721720,
    // Hf171~
    -1000721710,
    // Hf170~
    -1000721700,
    // Hf169~
    -1000721690,
    // Hf168~
    -1000721680,
    // Hf167~
    -1000721670,
    // Hf166~
    -1000721660,
    // Hf165~
    -1000721650,
    // Hf164~
    -1000721640,
    // Hf163~
    -1000721630,
    // Hf162~
    -1000721620,
    // Hf161~
    -1000721610,
    // Hf160~
    -1000721600,
    // Hf159~
    -1000721590,
    // Hf158~
    -1000721580,
    // Hf157~
    -1000721570,
    // Hf156~
    -1000721560,
    // Hf155~
    -1000721550,
    // Hf154~
    -1000721540,
    // Lu184~
    -1000711840,
    // Lu183~
    -1000711830,
    // Lu182~
    -1000711820,
    // Lu181~
    -1000711810,
    // Lu180~
    -1000711800,
    // Lu179~
    -1000711790,
    // Lu178~
    -1000711780,
    // Lu177~
    -1000711770,
    // Lu176~
    -1000711760,
    // Lu175~
    -1000711750,
    // Lu174~
    -1000711740,
    // Lu173~
    -1000711730,
    // Lu172~
    -1000711720,
    // Lu171~
    -1000711710,
    // Lu170~
    -1000711700,
    // Lu169~
    -1000711690,
    // Lu168~
    -1000711680,
    // Lu167~
    -1000711670,
    // Lu166~
    -1000711660,
    // Lu165~
    -1000711650,
    // Lu164~
    -1000711640,
    // Lu163~
    -1000711630,
    // Lu162~
    -1000711620,
    // Lu161~
    -1000711610,
    // Lu160~
    -1000711600,
    // Lu159~
    -1000711590,
    // Lu158~
    -1000711580,
    // Lu157~
    -1000711570,
    // Lu156~
    -1000711560,
    // Lu155~
    -1000711550,
    // Lu154~
    -1000711540,
    // Lu153~
    -1000711530,
    // Lu152~
    -1000711520,
    // Lu151~
    -1000711510,
    // Lu150~
    -1000711500,
    // Yb181~
    -1000701810,
    // Yb180~
    -1000701800,
    // Yb179~
    -1000701790,
    // Yb178~
    -1000701780,
    // Yb177~
    -1000701770,
    // Yb176~
    -1000701760,
    // Yb175~
    -1000701750,
    // Yb174~
    -1000701740,
    // Yb173~
    -1000701730,
    // Yb172~
    -1000701720,
    // Yb171~
    -1000701710,
    // Yb170~
    -1000701700,
    // Yb169~
    -1000701690,
    // Yb168~
    -1000701680,
    // Yb167~
    -1000701670,
    // Yb166~
    -1000701660,
    // Yb165~
    -1000701650,
    // Yb164~
    -1000701640,
    // Yb163~
    -1000701630,
    // Yb162~
    -1000701620,
    // Yb161~
    -1000701610,
    // Yb160~
    -1000701600,
    // Yb159~
    -1000701590,
    // Yb158~
    -1000701580,
    // Yb157~
    -1000701570,
    // Yb156~
    -1000701560,
    // Yb155~
    -1000701550,
    // Yb154~
    -1000701540,
    // Yb153~
    -1000701530,
    // Yb152~
    -1000701520,
    // Yb151~
    -1000701510,
    // Yb150~
    -1000701500,
    // Yb149~
    -1000701490,
    // Yb148~
    -1000701480,
    // Tm179~
    -1000691790,
    // Tm178~
    -1000691780,
    // Tm177~
    -1000691770,
    // Tm176~
    -1000691760,
    // Tm175~
    -1000691750,
    // Tm174~
    -1000691740,
    // Tm173~
    -1000691730,
    // Tm172~
    -1000691720,
    // Tm171~
    -1000691710,
    // Tm170~
    -1000691700,
    // Tm169~
    -1000691690,
    // Tm168~
    -1000691680,
    // Tm167~
    -1000691670,
    // Tm166~
    -1000691660,
    // Tm165~
    -1000691650,
    // Tm164~
    -1000691640,
    // Tm163~
    -1000691630,
    // Tm162~
    -1000691620,
    // Tm161~
    -1000691610,
    // Tm160~
    -1000691600,
    // Tm159~
    -1000691590,
    // Tm158~
    -1000691580,
    // Tm157~
    -1000691570,
    // Tm156~
    -1000691560,
    // Tm155~
    -1000691550,
    // Tm154~
    -1000691540,
    // Tm153~
    -1000691530,
    // Tm152~
    -1000691520,
    // Tm151~
    -1000691510,
    // Tm150~
    -1000691500,
    // Tm149~
    -1000691490,
    // Tm148~
    -1000691480,
    // Tm147~
    -1000691470,
    // Tm146~
    -1000691460,
    // Er177~
    -1000681770,
    // Er176~
    -1000681760,
    // Er175~
    -1000681750,
    // Er174~
    -1000681740,
    // Er173~
    -1000681730,
    // Er172~
    -1000681720,
    // Er171~
    -1000681710,
    // Er170~
    -1000681700,
    // Er169~
    -1000681690,
    // Er168~
    -1000681680,
    // Er167~
    -1000681670,
    // Er166~
    -1000681660,
    // Er165~
    -1000681650,
    // Er164~
    -1000681640,
    // Er163~
    -1000681630,
    // Er162~
    -1000681620,
    // Er161~
    -1000681610,
    // Er160~
    -1000681600,
    // Er159~
    -1000681590,
    // Er158~
    -1000681580,
    // Er157~
    -1000681570,
    // Er156~
    -1000681560,
    // Er155~
    -1000681550,
    // Er154~
    -1000681540,
    // Er153~
    -1000681530,
    // Er152~
    -1000681520,
    // Er151~
    -1000681510,
    // Er150~
    -1000681500,
    // Er149~
    -1000681490,
    // Er148~
    -1000681480,
    // Er147~
    -1000681470,
    // Er146~
    -1000681460,
    // Er145~
    -1000681450,
    // Er144~
    -1000681440,
    // Ho175~
    -1000671750,
    // Ho174~
    -1000671740,
    // Ho173~
    -1000671730,
    // Ho172~
    -1000671720,
    // Ho171~
    -1000671710,
    // Ho170~
    -1000671700,
    // Ho169~
    -1000671690,
    // Ho168~
    -1000671680,
    // Ho167~
    -1000671670,
    // Ho166~
    -1000671660,
    // Ho165~
    -1000671650,
    // Ho164~
    -1000671640,
    // Ho163~
    -1000671630,
    // Ho162~
    -1000671620,
    // Ho161~
    -1000671610,
    // Ho160~
    -1000671600,
    // Ho159~
    -1000671590,
    // Ho158~
    -1000671580,
    // Ho157~
    -1000671570,
    // Ho156~
    -1000671560,
    // Ho155~
    -1000671550,
    // Ho154~
    -1000671540,
    // Ho153~
    -1000671530,
    // Ho152~
    -1000671520,
    // Ho151~
    -1000671510,
    // Ho150~
    -1000671500,
    // Ho149~
    -1000671490,
    // Ho148~
    -1000671480,
    // Ho147~
    -1000671470,
    // Ho146~
    -1000671460,
    // Ho145~
    -1000671450,
    // Ho144~
    -1000671440,
    // Ho143~
    -1000671430,
    // Ho142~
    -1000671420,
    // Dy173~
    -1000661730,
    // Dy172~
    -1000661720,
    // Dy171~
    -1000661710,
    // Dy170~
    -1000661700,
    // Dy169~
    -1000661690,
    // Dy168~
    -1000661680,
    // Dy167~
    -1000661670,
    // Dy166~
    -1000661660,
    // Dy165~
    -1000661650,
    // Dy164~
    -1000661640,
    // Dy163~
    -1000661630,
    // Dy162~
    -1000661620,
    // Dy161~
    -1000661610,
    // Dy160~
    -1000661600,
    // Dy159~
    -1000661590,
    // Dy158~
    -1000661580,
    // Dy157~
    -1000661570,
    // Dy156~
    -1000661560,
    // Dy155~
    -1000661550,
    // Dy154~
    -1000661540,
    // Dy153~
    -1000661530,
    // Dy152~
    -1000661520,
    // Dy151~
    -1000661510,
    // Dy150~
    -1000661500,
    // Dy149~
    -1000661490,
    // Dy148~
    -1000661480,
    // Dy147~
    -1000661470,
    // Dy146~
    -1000661460,
    // Dy145~
    -1000661450,
    // Dy144~
    -1000661440,
    // Dy143~
    -1000661430,
    // Dy142~
    -1000661420,
    // Dy141~
    -1000661410,
    // Dy140~
    -1000661400,
    // Tb171~
    -1000651710,
    // Tb170~
    -1000651700,
    // Tb169~
    -1000651690,
    // Tb168~
    -1000651680,
    // Tb167~
    -1000651670,
    // Tb166~
    -1000651660,
    // Tb165~
    -1000651650,
    // Tb164~
    -1000651640,
    // Tb163~
    -1000651630,
    // Tb162~
    -1000651620,
    // Tb161~
    -1000651610,
    // Tb160~
    -1000651600,
    // Tb159~
    -1000651590,
    // Tb158~
    -1000651580,
    // Tb157~
    -1000651570,
    // Tb156~
    -1000651560,
    // Tb155~
    -1000651550,
    // Tb154~
    -1000651540,
    // Tb153~
    -1000651530,
    // Tb152~
    -1000651520,
    // Tb151~
    -1000651510,
    // Tb150~
    -1000651500,
    // Tb149~
    -1000651490,
    // Tb148~
    -1000651480,
    // Tb147~
    -1000651470,
    // Tb146~
    -1000651460,
    // Tb145~
    -1000651450,
    // Tb144~
    -1000651440,
    // Tb143~
    -1000651430,
    // Tb142~
    -1000651420,
    // Tb141~
    -1000651410,
    // Tb140~
    -1000651400,
    // Tb139~
    -1000651390,
    // Tb138~
    -1000651380,
    // Gd169~
    -1000641690,
    // Gd168~
    -1000641680,
    // Gd167~
    -1000641670,
    // Gd166~
    -1000641660,
    // Gd165~
    -1000641650,
    // Gd164~
    -1000641640,
    // Gd163~
    -1000641630,
    // Gd162~
    -1000641620,
    // Gd161~
    -1000641610,
    // Gd160~
    -1000641600,
    // Gd159~
    -1000641590,
    // Gd158~
    -1000641580,
    // Gd157~
    -1000641570,
    // Gd156~
    -1000641560,
    // Gd155~
    -1000641550,
    // Gd154~
    -1000641540,
    // Gd153~
    -1000641530,
    // Gd152~
    -1000641520,
    // Gd151~
    -1000641510,
    // Gd150~
    -1000641500,
    // Gd149~
    -1000641490,
    // Gd148~
    -1000641480,
    // Gd147~
    -1000641470,
    // Gd146~
    -1000641460,
    // Gd145~
    -1000641450,
    // Gd144~
    -1000641440,
    // Gd143~
    -1000641430,
    // Gd142~
    -1000641420,
    // Gd141~
    -1000641410,
    // Gd140~
    -1000641400,
    // Gd139~
    -1000641390,
    // Gd138~
    -1000641380,
    // Gd137~
    -1000641370,
    // Gd136~
    -1000641360,
    // Eu167~
    -1000631670,
    // Eu166~
    -1000631660,
    // Eu165~
    -1000631650,
    // Eu164~
    -1000631640,
    // Eu163~
    -1000631630,
    // Eu162~
    -1000631620,
    // Eu161~
    -1000631610,
    // Eu160~
    -1000631600,
    // Eu159~
    -1000631590,
    // Eu158~
    -1000631580,
    // Eu157~
    -1000631570,
    // Eu156~
    -1000631560,
    // Eu155~
    -1000631550,
    // Eu154~
    -1000631540,
    // Eu153~
    -1000631530,
    // Eu152~
    -1000631520,
    // Eu151~
    -1000631510,
    // Eu150~
    -1000631500,
    // Eu149~
    -1000631490,
    // Eu148~
    -1000631480,
    // Eu147~
    -1000631470,
    // Eu146~
    -1000631460,
    // Eu145~
    -1000631450,
    // Eu144~
    -1000631440,
    // Eu143~
    -1000631430,
    // Eu142~
    -1000631420,
    // Eu141~
    -1000631410,
    // Eu140~
    -1000631400,
    // Eu139~
    -1000631390,
    // Eu138~
    -1000631380,
    // Eu137~
    -1000631370,
    // Eu136~
    -1000631360,
    // Eu135~
    -1000631350,
    // Eu134~
    -1000631340,
    // Eu133~
    -1000631330,
    // Eu132~
    -1000631320,
    // Sm165~
    -1000621650,
    // Sm164~
    -1000621640,
    // Sm163~
    -1000621630,
    // Sm162~
    -1000621620,
    // Sm161~
    -1000621610,
    // Sm160~
    -1000621600,
    // Sm159~
    -1000621590,
    // Sm158~
    -1000621580,
    // Sm157~
    -1000621570,
    // Sm156~
    -1000621560,
    // Sm155~
    -1000621550,
    // Sm154~
    -1000621540,
    // Sm153~
    -1000621530,
    // Sm152~
    -1000621520,
    // Sm151~
    -1000621510,
    // Sm150~
    -1000621500,
    // Sm149~
    -1000621490,
    // Sm148~
    -1000621480,
    // Sm147~
    -1000621470,
    // Sm146~
    -1000621460,
    // Sm145~
    -1000621450,
    // Sm144~
    -1000621440,
    // Sm143~
    -1000621430,
    // Sm142~
    -1000621420,
    // Sm141~
    -1000621410,
    // Sm140~
    -1000621400,
    // Sm139~
    -1000621390,
    // Sm138~
    -1000621380,
    // Sm137~
    -1000621370,
    // Sm136~
    -1000621360,
    // Sm135~
    -1000621350,
    // Sm134~
    -1000621340,
    // Sm133~
    -1000621330,
    // Sm132~
    -1000621320,
    // Sm131~
    -1000621310,
    // Sm130~
    -1000621300,
    // Pm163~
    -1000611630,
    // Pm162~
    -1000611620,
    // Pm161~
    -1000611610,
    // Pm160~
    -1000611600,
    // Pm159~
    -1000611590,
    // Pm158~
    -1000611580,
    // Pm157~
    -1000611570,
    // Pm156~
    -1000611560,
    // Pm155~
    -1000611550,
    // Pm154~
    -1000611540,
    // Pm153~
    -1000611530,
    // Pm152~
    -1000611520,
    // Pm151~
    -1000611510,
    // Pm150~
    -1000611500,
    // Pm149~
    -1000611490,
    // Pm148~
    -1000611480,
    // Pm147~
    -1000611470,
    // Pm146~
    -1000611460,
    // Pm145~
    -1000611450,
    // Pm144~
    -1000611440,
    // Pm143~
    -1000611430,
    // Pm142~
    -1000611420,
    // Pm141~
    -1000611410,
    // Pm140~
    -1000611400,
    // Pm139~
    -1000611390,
    // Pm138~
    -1000611380,
    // Pm137~
    -1000611370,
    // Pm136~
    -1000611360,
    // Pm135~
    -1000611350,
    // Pm134~
    -1000611340,
    // Pm133~
    -1000611330,
    // Pm132~
    -1000611320,
    // Pm131~
    -1000611310,
    // Pm130~
    -1000611300,
    // Pm129~
    -1000611290,
    // Pm128~
    -1000611280,
    // Nd161~
    -1000601610,
    // Nd160~
    -1000601600,
    // Nd159~
    -1000601590,
    // Nd158~
    -1000601580,
    // Nd157~
    -1000601570,
    // Nd156~
    -1000601560,
    // Nd155~
    -1000601550,
    // Nd154~
    -1000601540,
    // Nd153~
    -1000601530,
    // Nd152~
    -1000601520,
    // Nd151~
    -1000601510,
    // Nd150~
    -1000601500,
    // Nd149~
    -1000601490,
    // Nd148~
    -1000601480,
    // Nd147~
    -1000601470,
    // Nd146~
    -1000601460,
    // Nd145~
    -1000601450,
    // Nd144~
    -1000601440,
    // Nd143~
    -1000601430,
    // Nd142~
    -1000601420,
    // Nd141~
    -1000601410,
    // Nd140~
    -1000601400,
    // Nd139~
    -1000601390,
    // Nd138~
    -1000601380,
    // Nd137~
    -1000601370,
    // Nd136~
    -1000601360,
    // Nd135~
    -1000601350,
    // Nd134~
    -1000601340,
    // Nd133~
    -1000601330,
    // Nd132~
    -1000601320,
    // Nd131~
    -1000601310,
    // Nd130~
    -1000601300,
    // Nd129~
    -1000601290,
    // Nd128~
    -1000601280,
    // Nd127~
    -1000601270,
    // Nd126~
    -1000601260,
    // Pr159~
    -1000591590,
    // Pr158~
    -1000591580,
    // Pr157~
    -1000591570,
    // Pr156~
    -1000591560,
    // Pr155~
    -1000591550,
    // Pr154~
    -1000591540,
    // Pr153~
    -1000591530,
    // Pr152~
    -1000591520,
    // Pr151~
    -1000591510,
    // Pr150~
    -1000591500,
    // Pr149~
    -1000591490,
    // Pr148~
    -1000591480,
    // Pr147~
    -1000591470,
    // Pr146~
    -1000591460,
    // Pr145~
    -1000591450,
    // Pr144~
    -1000591440,
    // Pr143~
    -1000591430,
    // Pr142~
    -1000591420,
    // Pr141~
    -1000591410,
    // Pr140~
    -1000591400,
    // Pr139~
    -1000591390,
    // Pr138~
    -1000591380,
    // Pr137~
    -1000591370,
    // Pr136~
    -1000591360,
    // Pr135~
    -1000591350,
    // Pr134~
    -1000591340,
    // Pr133~
    -1000591330,
    // Pr132~
    -1000591320,
    // Pr131~
    -1000591310,
    // Pr130~
    -1000591300,
    // Pr129~
    -1000591290,
    // Pr128~
    -1000591280,
    // Pr127~
    -1000591270,
    // Pr126~
    -1000591260,
    // Pr125~
    -1000591250,
    // Pr124~
    -1000591240,
    // Pr123~
    -1000591230,
    // Pr122~
    -1000591220,
    // Pr121~
    -1000591210,
    // Ce157~
    -1000581570,
    // Ce156~
    -1000581560,
    // Ce155~
    -1000581550,
    // Ce154~
    -1000581540,
    // Ce153~
    -1000581530,
    // Ce152~
    -1000581520,
    // Ce151~
    -1000581510,
    // Ce150~
    -1000581500,
    // Ce149~
    -1000581490,
    // Ce148~
    -1000581480,
    // Ce147~
    -1000581470,
    // Ce146~
    -1000581460,
    // Ce145~
    -1000581450,
    // Ce144~
    -1000581440,
    // Ce143~
    -1000581430,
    // Ce142~
    -1000581420,
    // Ce141~
    -1000581410,
    // Ce140~
    -1000581400,
    // Ce139~
    -1000581390,
    // Ce138~
    -1000581380,
    // Ce137~
    -1000581370,
    // Ce136~
    -1000581360,
    // Ce135~
    -1000581350,
    // Ce134~
    -1000581340,
    // Ce133~
    -1000581330,
    // Ce132~
    -1000581320,
    // Ce131~
    -1000581310,
    // Ce130~
    -1000581300,
    // Ce129~
    -1000581290,
    // Ce128~
    -1000581280,
    // Ce127~
    -1000581270,
    // Ce126~
    -1000581260,
    // Ce125~
    -1000581250,
    // Ce124~
    -1000581240,
    // Ce123~
    -1000581230,
    // Ce122~
    -1000581220,
    // Ce121~
    -1000581210,
    // Ce120~
    -1000581200,
    // Ce119~
    -1000581190,
    // La155~
    -1000571550,
    // La154~
    -1000571540,
    // La153~
    -1000571530,
    // La152~
    -1000571520,
    // La151~
    -1000571510,
    // La150~
    -1000571500,
    // La149~
    -1000571490,
    // La148~
    -1000571480,
    // La147~
    -1000571470,
    // La146~
    -1000571460,
    // La145~
    -1000571450,
    // La144~
    -1000571440,
    // La143~
    -1000571430,
    // La142~
    -1000571420,
    // La141~
    -1000571410,
    // La140~
    -1000571400,
    // La139~
    -1000571390,
    // La138~
    -1000571380,
    // La137~
    -1000571370,
    // La136~
    -1000571360,
    // La135~
    -1000571350,
    // La134~
    -1000571340,
    // La133~
    -1000571330,
    // La132~
    -1000571320,
    // La131~
    -1000571310,
    // La130~
    -1000571300,
    // La129~
    -1000571290,
    // La128~
    -1000571280,
    // La127~
    -1000571270,
    // La126~
    -1000571260,
    // La125~
    -1000571250,
    // La124~
    -1000571240,
    // La123~
    -1000571230,
    // La122~
    -1000571220,
    // La121~
    -1000571210,
    // La120~
    -1000571200,
    // La119~
    -1000571190,
    // La118~
    -1000571180,
    // La117~
    -1000571170,
    // Ba153~
    -1000561530,
    // Ba152~
    -1000561520,
    // Ba151~
    -1000561510,
    // Ba150~
    -1000561500,
    // Ba149~
    -1000561490,
    // Ba148~
    -1000561480,
    // Ba147~
    -1000561470,
    // Ba146~
    -1000561460,
    // Ba145~
    -1000561450,
    // Ba144~
    -1000561440,
    // Ba143~
    -1000561430,
    // Ba142~
    -1000561420,
    // Ba141~
    -1000561410,
    // Ba140~
    -1000561400,
    // Ba139~
    -1000561390,
    // Ba138~
    -1000561380,
    // Ba137~
    -1000561370,
    // Ba136~
    -1000561360,
    // Ba135~
    -1000561350,
    // Ba134~
    -1000561340,
    // Ba133~
    -1000561330,
    // Ba132~
    -1000561320,
    // Ba131~
    -1000561310,
    // Ba130~
    -1000561300,
    // Ba129~
    -1000561290,
    // Ba128~
    -1000561280,
    // Ba127~
    -1000561270,
    // Ba126~
    -1000561260,
    // Ba125~
    -1000561250,
    // Ba124~
    -1000561240,
    // Ba123~
    -1000561230,
    // Ba122~
    -1000561220,
    // Ba121~
    -1000561210,
    // Ba120~
    -1000561200,
    // Ba119~
    -1000561190,
    // Ba118~
    -1000561180,
    // Ba117~
    -1000561170,
    // Ba116~
    -1000561160,
    // Ba115~
    -1000561150,
    // Ba114~
    -1000561140,
    // Cs151~
    -1000551510,
    // Cs150~
    -1000551500,
    // Cs149~
    -1000551490,
    // Cs148~
    -1000551480,
    // Cs147~
    -1000551470,
    // Cs146~
    -1000551460,
    // Cs145~
    -1000551450,
    // Cs144~
    -1000551440,
    // Cs143~
    -1000551430,
    // Cs142~
    -1000551420,
    // Cs141~
    -1000551410,
    // Cs140~
    -1000551400,
    // Cs139~
    -1000551390,
    // Cs138~
    -1000551380,
    // Cs137~
    -1000551370,
    // Cs136~
    -1000551360,
    // Cs135~
    -1000551350,
    // Cs134~
    -1000551340,
    // Cs133~
    -1000551330,
    // Cs132~
    -1000551320,
    // Cs131~
    -1000551310,
    // Cs130~
    -1000551300,
    // Cs129~
    -1000551290,
    // Cs128~
    -1000551280,
    // Cs127~
    -1000551270,
    // Cs126~
    -1000551260,
    // Cs125~
    -1000551250,
    // Cs124~
    -1000551240,
    // Cs123~
    -1000551230,
    // Cs122~
    -1000551220,
    // Cs121~
    -1000551210,
    // Cs120~
    -1000551200,
    // Cs119~
    -1000551190,
    // Cs118~
    -1000551180,
    // Cs117~
    -1000551170,
    // Cs116~
    -1000551160,
    // Cs115~
    -1000551150,
    // Cs114~
    -1000551140,
    // Cs113~
    -1000551130,
    // Cs112~
    -1000551120,
    // Xe147~
    -1000541470,
    // Xe146~
    -1000541460,
    // Xe145~
    -1000541450,
    // Xe144~
    -1000541440,
    // Xe143~
    -1000541430,
    // Xe142~
    -1000541420,
    // Xe141~
    -1000541410,
    // Xe140~
    -1000541400,
    // Xe139~
    -1000541390,
    // Xe138~
    -1000541380,
    // Xe137~
    -1000541370,
    // Xe136~
    -1000541360,
    // Xe135~
    -1000541350,
    // Xe134~
    -1000541340,
    // Xe133~
    -1000541330,
    // Xe132~
    -1000541320,
    // Xe131~
    -1000541310,
    // Xe130~
    -1000541300,
    // Xe129~
    -1000541290,
    // Xe128~
    -1000541280,
    // Xe127~
    -1000541270,
    // Xe126~
    -1000541260,
    // Xe125~
    -1000541250,
    // Xe124~
    -1000541240,
    // Xe123~
    -1000541230,
    // Xe122~
    -1000541220,
    // Xe121~
    -1000541210,
    // Xe120~
    -1000541200,
    // Xe119~
    -1000541190,
    // Xe118~
    -1000541180,
    // Xe117~
    -1000541170,
    // Xe116~
    -1000541160,
    // Xe115~
    -1000541150,
    // Xe114~
    -1000541140,
    // Xe113~
    -1000541130,
    // Xe112~
    -1000541120,
    // Xe111~
    -1000541110,
    // Xe110~
    -1000541100,
    // I144~
    -1000531440,
    // I143~
    -1000531430,
    // I142~
    -1000531420,
    // I141~
    -1000531410,
    // I140~
    -1000531400,
    // I139~
    -1000531390,
    // I138~
    -1000531380,
    // I137~
    -1000531370,
    // I136~
    -1000531360,
    // I135~
    -1000531350,
    // I134~
    -1000531340,
    // I133~
    -1000531330,
    // I132~
    -1000531320,
    // I131~
    -1000531310,
    // I130~
    -1000531300,
    // I129~
    -1000531290,
    // I128~
    -1000531280,
    // I127~
    -1000531270,
    // I126~
    -1000531260,
    // I125~
    -1000531250,
    // I124~
    -1000531240,
    // I123~
    -1000531230,
    // I122~
    -1000531220,
    // I121~
    -1000531210,
    // I120~
    -1000531200,
    // I119~
    -1000531190,
    // I118~
    -1000531180,
    // I117~
    -1000531170,
    // I116~
    -1000531160,
    // I115~
    -1000531150,
    // I114~
    -1000531140,
    // I113~
    -1000531130,
    // I112~
    -1000531120,
    // I111~
    -1000531110,
    // I110~
    -1000531100,
    // I109~
    -1000531090,
    // I108~
    -1000531080,
    // Te142~
    -1000521420,
    // Te141~
    -1000521410,
    // Te140~
    -1000521400,
    // Te139~
    -1000521390,
    // Te138~
    -1000521380,
    // Te137~
    -1000521370,
    // Te136~
    -1000521360,
    // Te135~
    -1000521350,
    // Te134~
    -1000521340,
    // Te133~
    -1000521330,
    // Te132~
    -1000521320,
    // Te131~
    -1000521310,
    // Te130~
    -1000521300,
    // Te129~
    -1000521290,
    // Te128~
    -1000521280,
    // Te127~
    -1000521270,
    // Te126~
    -1000521260,
    // Te125~
    -1000521250,
    // Te124~
    -1000521240,
    // Te123~
    -1000521230,
    // Te122~
    -1000521220,
    // Te121~
    -1000521210,
    // Te120~
    -1000521200,
    // Te119~
    -1000521190,
    // Te118~
    -1000521180,
    // Te117~
    -1000521170,
    // Te116~
    -1000521160,
    // Te115~
    -1000521150,
    // Te114~
    -1000521140,
    // Te113~
    -1000521130,
    // Te112~
    -1000521120,
    // Te111~
    -1000521110,
    // Te110~
    -1000521100,
    // Te109~
    -1000521090,
    // Te108~
    -1000521080,
    // Te107~
    -1000521070,
    // Te106~
    -1000521060,
    // Sb139~
    -1000511390,
    // Sb138~
    -1000511380,
    // Sb137~
    -1000511370,
    // Sb136~
    -1000511360,
    // Sb135~
    -1000511350,
    // Sb134~
    -1000511340,
    // Sb133~
    -1000511330,
    // Sb132~
    -1000511320,
    // Sb131~
    -1000511310,
    // Sb130~
    -1000511300,
    // Sb129~
    -1000511290,
    // Sb128~
    -1000511280,
    // Sb127~
    -1000511270,
    // Sb126~
    -1000511260,
    // Sb125~
    -1000511250,
    // Sb124~
    -1000511240,
    // Sb123~
    -1000511230,
    // Sb122~
    -1000511220,
    // Sb121~
    -1000511210,
    // Sb120~
    -1000511200,
    // Sb119~
    -1000511190,
    // Sb118~
    -1000511180,
    // Sb117~
    -1000511170,
    // Sb116~
    -1000511160,
    // Sb115~
    -1000511150,
    // Sb114~
    -1000511140,
    // Sb113~
    -1000511130,
    // Sb112~
    -1000511120,
    // Sb111~
    -1000511110,
    // Sb110~
    -1000511100,
    // Sb109~
    -1000511090,
    // Sb108~
    -1000511080,
    // Sb107~
    -1000511070,
    // Sb106~
    -1000511060,
    // Sb105~
    -1000511050,
    // Sb104~
    -1000511040,
    // Sb103~
    -1000511030,
    // Sn137~
    -1000501370,
    // Sn136~
    -1000501360,
    // Sn135~
    -1000501350,
    // Sn134~
    -1000501340,
    // Sn133~
    -1000501330,
    // Sn132~
    -1000501320,
    // Sn131~
    -1000501310,
    // Sn130~
    -1000501300,
    // Sn129~
    -1000501290,
    // Sn128~
    -1000501280,
    // Sn127~
    -1000501270,
    // Sn126~
    -1000501260,
    // Sn125~
    -1000501250,
    // Sn124~
    -1000501240,
    // Sn123~
    -1000501230,
    // Sn122~
    -1000501220,
    // Sn121~
    -1000501210,
    // Sn120~
    -1000501200,
    // Sn119~
    -1000501190,
    // Sn118~
    -1000501180,
    // Sn117~
    -1000501170,
    // Sn116~
    -1000501160,
    // Sn115~
    -1000501150,
    // Sn114~
    -1000501140,
    // Sn113~
    -1000501130,
    // Sn112~
    -1000501120,
    // Sn111~
    -1000501110,
    // Sn110~
    -1000501100,
    // Sn109~
    -1000501090,
    // Sn108~
    -1000501080,
    // Sn107~
    -1000501070,
    // Sn106~
    -1000501060,
    // Sn105~
    -1000501050,
    // Sn104~
    -1000501040,
    // Sn103~
    -1000501030,
    // Sn102~
    -1000501020,
    // Sn101~
    -1000501010,
    // Sn100~
    -1000501000,
    // In134~
    -1000491340,
    // In133~
    -1000491330,
    // In132~
    -1000491320,
    // In131~
    -1000491310,
    // In130~
    -1000491300,
    // In129~
    -1000491290,
    // In128~
    -1000491280,
    // In127~
    -1000491270,
    // In126~
    -1000491260,
    // In125~
    -1000491250,
    // In124~
    -1000491240,
    // In123~
    -1000491230,
    // In122~
    -1000491220,
    // In121~
    -1000491210,
    // In120~
    -1000491200,
    // In119~
    -1000491190,
    // In118~
    -1000491180,
    // In117~
    -1000491170,
    // In116~
    -1000491160,
    // In115~
    -1000491150,
    // In114~
    -1000491140,
    // In113~
    -1000491130,
    // In112~
    -1000491120,
    // In111~
    -1000491110,
    // In110~
    -1000491100,
    // In109~
    -1000491090,
    // In108~
    -1000491080,
    // In107~
    -1000491070,
    // In106~
    -1000491060,
    // In105~
    -1000491050,
    // In104~
    -1000491040,
    // In103~
    -1000491030,
    // In102~
    -1000491020,
    // In101~
    -1000491010,
    // In100~
    -1000491000,
    // In99~
    -1000490990,
    // In98~
    -1000490980,
    // Cd130~
    -1000481300,
    // Cd129~
    -1000481290,
    // Cd128~
    -1000481280,
    // Cd127~
    -1000481270,
    // Cd126~
    -1000481260,
    // Cd125~
    -1000481250,
    // Cd124~
    -1000481240,
    // Cd123~
    -1000481230,
    // Cd122~
    -1000481220,
    // Cd121~
    -1000481210,
    // Cd120~
    -1000481200,
    // Cd119~
    -1000481190,
    // Cd118~
    -1000481180,
    // Cd117~
    -1000481170,
    // Cd116~
    -1000481160,
    // Cd115~
    -1000481150,
    // Cd114~
    -1000481140,
    // Cd113~
    -1000481130,
    // Cd112~
    -1000481120,
    // Cd111~
    -1000481110,
    // Cd110~
    -1000481100,
    // Cd109~
    -1000481090,
    // Cd108~
    -1000481080,
    // Cd107~
    -1000481070,
    // Cd106~
    -1000481060,
    // Cd105~
    -1000481050,
    // Cd104~
    -1000481040,
    // Cd103~
    -1000481030,
    // Cd102~
    -1000481020,
    // Cd101~
    -1000481010,
    // Cd100~
    -1000481000,
    // Cd99~
    -1000480990,
    // Cd98~
    -1000480980,
    // Cd97~
    -1000480970,
    // Cd96~
    -1000480960,
    // Ag127~
    -1000471270,
    // Ag126~
    -1000471260,
    // Ag125~
    -1000471250,
    // Ag124~
    -1000471240,
    // Ag123~
    -1000471230,
    // Ag122~
    -1000471220,
    // Ag121~
    -1000471210,
    // Ag120~
    -1000471200,
    // Ag119~
    -1000471190,
    // Ag118~
    -1000471180,
    // Ag117~
    -1000471170,
    // Ag116~
    -1000471160,
    // Ag115~
    -1000471150,
    // Ag114~
    -1000471140,
    // Ag113~
    -1000471130,
    // Ag112~
    -1000471120,
    // Ag111~
    -1000471110,
    // Ag110~
    -1000471100,
    // Ag109~
    -1000471090,
    // Ag108~
    -1000471080,
    // Ag107~
    -1000471070,
    // Ag106~
    -1000471060,
    // Ag105~
    -1000471050,
    // Ag104~
    -1000471040,
    // Ag103~
    -1000471030,
    // Ag102~
    -1000471020,
    // Ag101~
    -1000471010,
    // Ag100~
    -1000471000,
    // Ag99~
    -1000470990,
    // Ag98~
    -1000470980,
    // Ag97~
    -1000470970,
    // Ag96~
    -1000470960,
    // Ag95~
    -1000470950,
    // Ag94~
    -1000470940,
    // Pd123~
    -1000461230,
    // Pd122~
    -1000461220,
    // Pd121~
    -1000461210,
    // Pd120~
    -1000461200,
    // Pd119~
    -1000461190,
    // Pd118~
    -1000461180,
    // Pd117~
    -1000461170,
    // Pd116~
    -1000461160,
    // Pd115~
    -1000461150,
    // Pd114~
    -1000461140,
    // Pd113~
    -1000461130,
    // Pd112~
    -1000461120,
    // Pd111~
    -1000461110,
    // Pd110~
    -1000461100,
    // Pd109~
    -1000461090,
    // Pd108~
    -1000461080,
    // Pd107~
    -1000461070,
    // Pd106~
    -1000461060,
    // Pd105~
    -1000461050,
    // Pd104~
    -1000461040,
    // Pd103~
    -1000461030,
    // Pd102~
    -1000461020,
    // Pd101~
    -1000461010,
    // Pd100~
    -1000461000,
    // Pd99~
    -1000460990,
    // Pd98~
    -1000460980,
    // Pd97~
    -1000460970,
    // Pd96~
    -1000460960,
    // Pd95~
    -1000460950,
    // Pd94~
    -1000460940,
    // Pd93~
    -1000460930,
    // Pd92~
    -1000460920,
    // Pd91~
    -1000460910,
    // Rh121~
    -1000451210,
    // Rh120~
    -1000451200,
    // Rh119~
    -1000451190,
    // Rh118~
    -1000451180,
    // Rh117~
    -1000451170,
    // Rh116~
    -1000451160,
    // Rh115~
    -1000451150,
    // Rh114~
    -1000451140,
    // Rh113~
    -1000451130,
    // Rh112~
    -1000451120,
    // Rh111~
    -1000451110,
    // Rh110~
    -1000451100,
    // Rh109~
    -1000451090,
    // Rh108~
    -1000451080,
    // Rh107~
    -1000451070,
    // Rh106~
    -1000451060,
    // Rh105~
    -1000451050,
    // Rh104~
    -1000451040,
    // Rh103~
    -1000451030,
    // Rh102~
    -1000451020,
    // Rh101~
    -1000451010,
    // Rh100~
    -1000451000,
    // Rh99~
    -1000450990,
    // Rh98~
    -1000450980,
    // Rh97~
    -1000450970,
    // Rh96~
    -1000450960,
    // Rh95~
    -1000450950,
    // Rh94~
    -1000450940,
    // Rh93~
    -1000450930,
    // Rh92~
    -1000450920,
    // Rh91~
    -1000450910,
    // Rh90~
    -1000450900,
    // Rh89~
    -1000450890,
    // Ru118~
    -1000441180,
    // Ru117~
    -1000441170,
    // Ru116~
    -1000441160,
    // Ru115~
    -1000441150,
    // Ru114~
    -1000441140,
    // Ru113~
    -1000441130,
    // Ru112~
    -1000441120,
    // Ru111~
    -1000441110,
    // Ru110~
    -1000441100,
    // Ru109~
    -1000441090,
    // Ru108~
    -1000441080,
    // Ru107~
    -1000441070,
    // Ru106~
    -1000441060,
    // Ru105~
    -1000441050,
    // Ru104~
    -1000441040,
    // Ru103~
    -1000441030,
    // Ru102~
    -1000441020,
    // Ru101~
    -1000441010,
    // Ru100~
    -1000441000,
    // Ru99~
    -1000440990,
    // Ru98~
    -1000440980,
    // Ru97~
    -1000440970,
    // Ru96~
    -1000440960,
    // Ru95~
    -1000440950,
    // Ru94~
    -1000440940,
    // Ru93~
    -1000440930,
    // Ru92~
    -1000440920,
    // Ru91~
    -1000440910,
    // Ru90~
    -1000440900,
    // Ru89~
    -1000440890,
    // Ru88~
    -1000440880,
    // Ru87~
    -1000440870,
    // Tc115~
    -1000431150,
    // Tc114~
    -1000431140,
    // Tc113~
    -1000431130,
    // Tc112~
    -1000431120,
    // Tc111~
    -1000431110,
    // Tc110~
    -1000431100,
    // Tc109~
    -1000431090,
    // Tc108~
    -1000431080,
    // Tc107~
    -1000431070,
    // Tc106~
    -1000431060,
    // Tc105~
    -1000431050,
    // Tc104~
    -1000431040,
    // Tc103~
    -1000431030,
    // Tc102~
    -1000431020,
    // Tc101~
    -1000431010,
    // Tc100~
    -1000431000,
    // Tc99~
    -1000430990,
    // Tc98~
    -1000430980,
    // Tc97~
    -1000430970,
    // Tc96~
    -1000430960,
    // Tc95~
    -1000430950,
    // Tc94~
    -1000430940,
    // Tc93~
    -1000430930,
    // Tc92~
    -1000430920,
    // Tc91~
    -1000430910,
    // Tc90~
    -1000430900,
    // Tc89~
    -1000430890,
    // Tc88~
    -1000430880,
    // Tc87~
    -1000430870,
    // Tc86~
    -1000430860,
    // Tc85~
    -1000430850,
    // Mo113~
    -1000421130,
    // Mo112~
    -1000421120,
    // Mo111~
    -1000421110,
    // Mo110~
    -1000421100,
    // Mo109~
    -1000421090,
    // Mo108~
    -1000421080,
    // Mo107~
    -1000421070,
    // Mo106~
    -1000421060,
    // Mo105~
    -1000421050,
    // Mo104~
    -1000421040,
    // Mo103~
    -1000421030,
    // Mo102~
    -1000421020,
    // Mo101~
    -1000421010,
    // Mo100~
    -1000421000,
    // Mo99~
    -1000420990,
    // Mo98~
    -1000420980,
    // Mo97~
    -1000420970,
    // Mo96~
    -1000420960,
    // Mo95~
    -1000420950,
    // Mo94~
    -1000420940,
    // Mo93~
    -1000420930,
    // Mo92~
    -1000420920,
    // Mo91~
    -1000420910,
    // Mo90~
    -1000420900,
    // Mo89~
    -1000420890,
    // Mo88~
    -1000420880,
    // Mo87~
    -1000420870,
    // Mo86~
    -1000420860,
    // Mo85~
    -1000420850,
    // Mo84~
    -1000420840,
    // Mo83~
    -1000420830,
    // Nb110~
    -1000411100,
    // Nb109~
    -1000411090,
    // Nb108~
    -1000411080,
    // Nb107~
    -1000411070,
    // Nb106~
    -1000411060,
    // Nb105~
    -1000411050,
    // Nb104~
    -1000411040,
    // Nb103~
    -1000411030,
    // Nb102~
    -1000411020,
    // Nb101~
    -1000411010,
    // Nb100~
    -1000411000,
    // Nb99~
    -1000410990,
    // Nb98~
    -1000410980,
    // Nb97~
    -1000410970,
    // Nb96~
    -1000410960,
    // Nb95~
    -1000410950,
    // Nb94~
    -1000410940,
    // Nb93~
    -1000410930,
    // Nb92~
    -1000410920,
    // Nb91~
    -1000410910,
    // Nb90~
    -1000410900,
    // Nb89~
    -1000410890,
    // Nb88~
    -1000410880,
    // Nb87~
    -1000410870,
    // Nb86~
    -1000410860,
    // Nb85~
    -1000410850,
    // Nb84~
    -1000410840,
    // Nb83~
    -1000410830,
    // Nb82~
    -1000410820,
    // Nb81~
    -1000410810,
    // Zr108~
    -1000401080,
    // Zr107~
    -1000401070,
    // Zr106~
    -1000401060,
    // Zr105~
    -1000401050,
    // Zr104~
    -1000401040,
    // Zr103~
    -1000401030,
    // Zr102~
    -1000401020,
    // Zr101~
    -1000401010,
    // Zr100~
    -1000401000,
    // Zr99~
    -1000400990,
    // Zr98~
    -1000400980,
    // Zr97~
    -1000400970,
    // Zr96~
    -1000400960,
    // Zr95~
    -1000400950,
    // Zr94~
    -1000400940,
    // Zr93~
    -1000400930,
    // Zr92~
    -1000400920,
    // Zr91~
    -1000400910,
    // Zr90~
    -1000400900,
    // Zr89~
    -1000400890,
    // Zr88~
    -1000400880,
    // Zr87~
    -1000400870,
    // Zr86~
    -1000400860,
    // Zr85~
    -1000400850,
    // Zr84~
    -1000400840,
    // Zr83~
    -1000400830,
    // Zr82~
    -1000400820,
    // Zr81~
    -1000400810,
    // Zr80~
    -1000400800,
    // Zr79~
    -1000400790,
    // Y106~
    -1000391060,
    // Y105~
    -1000391050,
    // Y104~
    -1000391040,
    // Y103~
    -1000391030,
    // Y102~
    -1000391020,
    // Y101~
    -1000391010,
    // Y100~
    -1000391000,
    // Y99~
    -1000390990,
    // Y98~
    -1000390980,
    // Y97~
    -1000390970,
    // Y96~
    -1000390960,
    // Y95~
    -1000390950,
    // Y94~
    -1000390940,
    // Y93~
    -1000390930,
    // Y92~
    -1000390920,
    // Y91~
    -1000390910,
    // Y90~
    -1000390900,
    // Y89~
    -1000390890,
    // Y88~
    -1000390880,
    // Y87~
    -1000390870,
    // Y86~
    -1000390860,
    // Y85~
    -1000390850,
    // Y84~
    -1000390840,
    // Y83~
    -1000390830,
    // Y82~
    -1000390820,
    // Y81~
    -1000390810,
    // Y80~
    -1000390800,
    // Y79~
    -1000390790,
    // Y78~
    -1000390780,
    // Y77~
    -1000390770,
    // Sr104~
    -1000381040,
    // Sr103~
    -1000381030,
    // Sr102~
    -1000381020,
    // Sr101~
    -1000381010,
    // Sr100~
    -1000381000,
    // Sr99~
    -1000380990,
    // Sr98~
    -1000380980,
    // Sr97~
    -1000380970,
    // Sr96~
    -1000380960,
    // Sr95~
    -1000380950,
    // Sr94~
    -1000380940,
    // Sr93~
    -1000380930,
    // Sr92~
    -1000380920,
    // Sr91~
    -1000380910,
    // Sr90~
    -1000380900,
    // Sr89~
    -1000380890,
    // Sr88~
    -1000380880,
    // Sr87~
    -1000380870,
    // Sr86~
    -1000380860,
    // Sr85~
    -1000380850,
    // Sr84~
    -1000380840,
    // Sr83~
    -1000380830,
    // Sr82~
    -1000380820,
    // Sr81~
    -1000380810,
    // Sr80~
    -1000380800,
    // Sr79~
    -1000380790,
    // Sr78~
    -1000380780,
    // Sr77~
    -1000380770,
    // Sr76~
    -1000380760,
    // Sr75~
    -1000380750,
    // Sr74~
    -1000380740,
    // Sr73~
    -1000380730,
    // Rb102~
    -1000371020,
    // Rb101~
    -1000371010,
    // Rb100~
    -1000371000,
    // Rb99~
    -1000370990,
    // Rb98~
    -1000370980,
    // Rb97~
    -1000370970,
    // Rb96~
    -1000370960,
    // Rb95~
    -1000370950,
    // Rb94~
    -1000370940,
    // Rb93~
    -1000370930,
    // Rb92~
    -1000370920,
    // Rb91~
    -1000370910,
    // Rb90~
    -1000370900,
    // Rb89~
    -1000370890,
    // Rb88~
    -1000370880,
    // Rb87~
    -1000370870,
    // Rb86~
    -1000370860,
    // Rb85~
    -1000370850,
    // Rb84~
    -1000370840,
    // Rb83~
    -1000370830,
    // Rb82~
    -1000370820,
    // Rb81~
    -1000370810,
    // Rb80~
    -1000370800,
    // Rb79~
    -1000370790,
    // Rb78~
    -1000370780,
    // Rb77~
    -1000370770,
    // Rb76~
    -1000370760,
    // Rb75~
    -1000370750,
    // Rb74~
    -1000370740,
    // Rb73~
    -1000370730,
    // Rb72~
    -1000370720,
    // Rb71~
    -1000370710,
    // Kr97~
    -1000360970,
    // Kr96~
    -1000360960,
    // Kr95~
    -1000360950,
    // Kr94~
    -1000360940,
    // Kr93~
    -1000360930,
    // Kr92~
    -1000360920,
    // Kr91~
    -1000360910,
    // Kr90~
    -1000360900,
    // Kr89~
    -1000360890,
    // Kr88~
    -1000360880,
    // Kr87~
    -1000360870,
    // Kr86~
    -1000360860,
    // Kr85~
    -1000360850,
    // Kr84~
    -1000360840,
    // Kr83~
    -1000360830,
    // Kr82~
    -1000360820,
    // Kr81~
    -1000360810,
    // Kr80~
    -1000360800,
    // Kr79~
    -1000360790,
    // Kr78~
    -1000360780,
    // Kr77~
    -1000360770,
    // Kr76~
    -1000360760,
    // Kr75~
    -1000360750,
    // Kr74~
    -1000360740,
    // Kr73~
    -1000360730,
    // Kr72~
    -1000360720,
    // Kr71~
    -1000360710,
    // Kr70~
    -1000360700,
    // Kr69~
    -1000360690,
    // Br94~
    -1000350940,
    // Br93~
    -1000350930,
    // Br92~
    -1000350920,
    // Br91~
    -1000350910,
    // Br90~
    -1000350900,
    // Br89~
    -1000350890,
    // Br88~
    -1000350880,
    // Br87~
    -1000350870,
    // Br86~
    -1000350860,
    // Br85~
    -1000350850,
    // Br84~
    -1000350840,
    // Br83~
    -1000350830,
    // Br82~
    -1000350820,
    // Br81~
    -1000350810,
    // Br80~
    -1000350800,
    // Br79~
    -1000350790,
    // Br78~
    -1000350780,
    // Br77~
    -1000350770,
    // Br76~
    -1000350760,
    // Br75~
    -1000350750,
    // Br74~
    -1000350740,
    // Br73~
    -1000350730,
    // Br72~
    -1000350720,
    // Br71~
    -1000350710,
    // Br70~
    -1000350700,
    // Br69~
    -1000350690,
    // Br68~
    -1000350680,
    // Br67~
    -1000350670,
    // Se92~
    -1000340920,
    // Se91~
    -1000340910,
    // Se90~
    -1000340900,
    // Se89~
    -1000340890,
    // Se88~
    -1000340880,
    // Se87~
    -1000340870,
    // Se86~
    -1000340860,
    // Se85~
    -1000340850,
    // Se84~
    -1000340840,
    // Se83~
    -1000340830,
    // Se82~
    -1000340820,
    // Se81~
    -1000340810,
    // Se80~
    -1000340800,
    // Se79~
    -1000340790,
    // Se78~
    -1000340780,
    // Se77~
    -1000340770,
    // Se76~
    -1000340760,
    // Se75~
    -1000340750,
    // Se74~
    -1000340740,
    // Se73~
    -1000340730,
    // Se72~
    -1000340720,
    // Se71~
    -1000340710,
    // Se70~
    -1000340700,
    // Se69~
    -1000340690,
    // Se68~
    -1000340680,
    // Se67~
    -1000340670,
    // Se66~
    -1000340660,
    // Se65~
    -1000340650,
    // As89~
    -1000330890,
    // As88~
    -1000330880,
    // As87~
    -1000330870,
    // As86~
    -1000330860,
    // As85~
    -1000330850,
    // As84~
    -1000330840,
    // As83~
    -1000330830,
    // As82~
    -1000330820,
    // As81~
    -1000330810,
    // As80~
    -1000330800,
    // As79~
    -1000330790,
    // As78~
    -1000330780,
    // As77~
    -1000330770,
    // As76~
    -1000330760,
    // As75~
    -1000330750,
    // As74~
    -1000330740,
    // As73~
    -1000330730,
    // As72~
    -1000330720,
    // As71~
    -1000330710,
    // As70~
    -1000330700,
    // As69~
    -1000330690,
    // As68~
    -1000330680,
    // As67~
    -1000330670,
    // As66~
    -1000330660,
    // As65~
    -1000330650,
    // As64~
    -1000330640,
    // As63~
    -1000330630,
    // As62~
    -1000330620,
    // As61~
    -1000330610,
    // As60~
    -1000330600,
    // Ge86~
    -1000320860,
    // Ge85~
    -1000320850,
    // Ge84~
    -1000320840,
    // Ge83~
    -1000320830,
    // Ge82~
    -1000320820,
    // Ge81~
    -1000320810,
    // Ge80~
    -1000320800,
    // Ge79~
    -1000320790,
    // Ge78~
    -1000320780,
    // Ge77~
    -1000320770,
    // Ge76~
    -1000320760,
    // Ge75~
    -1000320750,
    // Ge74~
    -1000320740,
    // Ge73~
    -1000320730,
    // Ge72~
    -1000320720,
    // Ge71~
    -1000320710,
    // Ge70~
    -1000320700,
    // Ge69~
    -1000320690,
    // Ge68~
    -1000320680,
    // Ge67~
    -1000320670,
    // Ge66~
    -1000320660,
    // Ge65~
    -1000320650,
    // Ge64~
    -1000320640,
    // Ge63~
    -1000320630,
    // Ge62~
    -1000320620,
    // Ge61~
    -1000320610,
    // Ge60~
    -1000320600,
    // Ge59~
    -1000320590,
    // Ge58~
    -1000320580,
    // Ga84~
    -1000310840,
    // Ga83~
    -1000310830,
    // Ga82~
    -1000310820,
    // Ga81~
    -1000310810,
    // Ga80~
    -1000310800,
    // Ga79~
    -1000310790,
    // Ga78~
    -1000310780,
    // Ga77~
    -1000310770,
    // Ga76~
    -1000310760,
    // Ga75~
    -1000310750,
    // Ga74~
    -1000310740,
    // Ga73~
    -1000310730,
    // Ga72~
    -1000310720,
    // Ga71~
    -1000310710,
    // Ga70~
    -1000310700,
    // Ga69~
    -1000310690,
    // Ga68~
    -1000310680,
    // Ga67~
    -1000310670,
    // Ga66~
    -1000310660,
    // Ga65~
    -1000310650,
    // Ga64~
    -1000310640,
    // Ga63~
    -1000310630,
    // Ga62~
    -1000310620,
    // Ga61~
    -1000310610,
    // Ga60~
    -1000310600,
    // Ga59~
    -1000310590,
    // Ga58~
    -1000310580,
    // Ga57~
    -1000310570,
    // Ga56~
    -1000310560,
    // Zn82~
    -1000300820,
    // Zn81~
    -1000300810,
    // Zn80~
    -1000300800,
    // Zn79~
    -1000300790,
    // Zn78~
    -1000300780,
    // Zn77~
    -1000300770,
    // Zn76~
    -1000300760,
    // Zn75~
    -1000300750,
    // Zn74~
    -1000300740,
    // Zn73~
    -1000300730,
    // Zn72~
    -1000300720,
    // Zn71~
    -1000300710,
    // Zn70~
    -1000300700,
    // Zn69~
    -1000300690,
    // Zn68~
    -1000300680,
    // Zn67~
    -1000300670,
    // Zn66~
    -1000300660,
    // Zn65~
    -1000300650,
    // Zn64~
    -1000300640,
    // Zn63~
    -1000300630,
    // Zn62~
    -1000300620,
    // Zn61~
    -1000300610,
    // Zn60~
    -1000300600,
    // Zn59~
    -1000300590,
    // Zn58~
    -1000300580,
    // Zn57~
    -1000300570,
    // Zn56~
    -1000300560,
    // Zn55~
    -1000300550,
    // Zn54~
    -1000300540,
    // Cu80~
    -1000290800,
    // Cu79~
    -1000290790,
    // Cu78~
    -1000290780,
    // Cu77~
    -1000290770,
    // Cu76~
    -1000290760,
    // Cu75~
    -1000290750,
    // Cu74~
    -1000290740,
    // Cu73~
    -1000290730,
    // Cu72~
    -1000290720,
    // Cu71~
    -1000290710,
    // Cu70~
    -1000290700,
    // Cu69~
    -1000290690,
    // Cu68~
    -1000290680,
    // Cu67~
    -1000290670,
    // Cu66~
    -1000290660,
    // Cu65~
    -1000290650,
    // Cu64~
    -1000290640,
    // Cu63~
    -1000290630,
    // Cu62~
    -1000290620,
    // Cu61~
    -1000290610,
    // Cu60~
    -1000290600,
    // Cu59~
    -1000290590,
    // Cu58~
    -1000290580,
    // Cu57~
    -1000290570,
    // Cu56~
    -1000290560,
    // Cu55~
    -1000290550,
    // Cu54~
    -1000290540,
    // Cu53~
    -1000290530,
    // Cu52~
    -1000290520,
    // Ni78~
    -1000280780,
    // Ni77~
    -1000280770,
    // Ni76~
    -1000280760,
    // Ni75~
    -1000280750,
    // Ni74~
    -1000280740,
    // Ni73~
    -1000280730,
    // Ni72~
    -1000280720,
    // Ni71~
    -1000280710,
    // Ni70~
    -1000280700,
    // Ni69~
    -1000280690,
    // Ni68~
    -1000280680,
    // Ni67~
    -1000280670,
    // Ni66~
    -1000280660,
    // Ni65~
    -1000280650,
    // Ni64~
    -1000280640,
    // Ni63~
    -1000280630,
    // Ni62~
    -1000280620,
    // Ni61~
    -1000280610,
    // Ni60~
    -1000280600,
    // Ni59~
    -1000280590,
    // Ni58~
    -1000280580,
    // Ni57~
    -1000280570,
    // Ni56~
    -1000280560,
    // Ni55~
    -1000280550,
    // Ni54~
    -1000280540,
    // Ni53~
    -1000280530,
    // Ni52~
    -1000280520,
    // Ni51~
    -1000280510,
    // Ni50~
    -1000280500,
    // Co72~
    -1000270720,
    // Co71~
    -1000270710,
    // Co70~
    -1000270700,
    // Co69~
    -1000270690,
    // Co68~
    -1000270680,
    // Co67~
    -1000270670,
    // Co66~
    -1000270660,
    // Co65~
    -1000270650,
    // Co64~
    -1000270640,
    // Co63~
    -1000270630,
    // Co62~
    -1000270620,
    // Co61~
    -1000270610,
    // Co60~
    -1000270600,
    // Co59~
    -1000270590,
    // Co58~
    -1000270580,
    // Co57~
    -1000270570,
    // Co56~
    -1000270560,
    // Co55~
    -1000270550,
    // Co54~
    -1000270540,
    // Co53~
    -1000270530,
    // Co52~
    -1000270520,
    // Co51~
    -1000270510,
    // Co50~
    -1000270500,
    // Co49~
    -1000270490,
    // Co48~
    -1000270480,
    // Fe69~
    -1000260690,
    // Fe68~
    -1000260680,
    // Fe67~
    -1000260670,
    // Fe66~
    -1000260660,
    // Fe65~
    -1000260650,
    // Fe64~
    -1000260640,
    // Fe63~
    -1000260630,
    // Fe62~
    -1000260620,
    // Fe61~
    -1000260610,
    // Fe60~
    -1000260600,
    // Fe59~
    -1000260590,
    // Fe58~
    -1000260580,
    // Fe57~
    -1000260570,
    // Fe56~
    -1000260560,
    // Fe55~
    -1000260550,
    // Fe54~
    -1000260540,
    // Fe53~
    -1000260530,
    // Fe52~
    -1000260520,
    // Fe51~
    -1000260510,
    // Fe50~
    -1000260500,
    // Fe49~
    -1000260490,
    // Fe48~
    -1000260480,
    // Fe47~
    -1000260470,
    // Fe46~
    -1000260460,
    // Fe45~
    -1000260450,
    // Mn67~
    -1000250670,
    // Mn66~
    -1000250660,
    // Mn65~
    -1000250650,
    // Mn64~
    -1000250640,
    // Mn63~
    -1000250630,
    // Mn62~
    -1000250620,
    // Mn61~
    -1000250610,
    // Mn60~
    -1000250600,
    // Mn59~
    -1000250590,
    // Mn58~
    -1000250580,
    // Mn57~
    -1000250570,
    // Mn56~
    -1000250560,
    // Mn55~
    -1000250550,
    // Mn54~
    -1000250540,
    // Mn53~
    -1000250530,
    // Mn52~
    -1000250520,
    // Mn51~
    -1000250510,
    // Mn50~
    -1000250500,
    // Mn49~
    -1000250490,
    // Mn48~
    -1000250480,
    // Mn47~
    -1000250470,
    // Mn46~
    -1000250460,
    // Mn45~
    -1000250450,
    // Mn44~
    -1000250440,
    // Cr65~
    -1000240650,
    // Cr64~
    -1000240640,
    // Cr63~
    -1000240630,
    // Cr62~
    -1000240620,
    // Cr61~
    -1000240610,
    // Cr60~
    -1000240600,
    // Cr59~
    -1000240590,
    // Cr58~
    -1000240580,
    // Cr57~
    -1000240570,
    // Cr56~
    -1000240560,
    // Cr55~
    -1000240550,
    // Cr54~
    -1000240540,
    // Cr53~
    -1000240530,
    // Cr52~
    -1000240520,
    // Cr51~
    -1000240510,
    // Cr50~
    -1000240500,
    // Cr49~
    -1000240490,
    // Cr48~
    -1000240480,
    // Cr47~
    -1000240470,
    // Cr46~
    -1000240460,
    // Cr45~
    -1000240450,
    // Cr44~
    -1000240440,
    // Cr43~
    -1000240430,
    // Cr42~
    -1000240420,
    // V63~
    -1000230630,
    // V62~
    -1000230620,
    // V61~
    -1000230610,
    // V60~
    -1000230600,
    // V59~
    -1000230590,
    // V58~
    -1000230580,
    // V57~
    -1000230570,
    // V56~
    -1000230560,
    // V55~
    -1000230550,
    // V54~
    -1000230540,
    // V53~
    -1000230530,
    // V52~
    -1000230520,
    // V51~
    -1000230510,
    // V50~
    -1000230500,
    // V49~
    -1000230490,
    // V48~
    -1000230480,
    // V47~
    -1000230470,
    // V46~
    -1000230460,
    // V45~
    -1000230450,
    // V44~
    -1000230440,
    // V43~
    -1000230430,
    // V42~
    -1000230420,
    // V41~
    -1000230410,
    // V40~
    -1000230400,
    // Ti61~
    -1000220610,
    // Ti60~
    -1000220600,
    // Ti59~
    -1000220590,
    // Ti58~
    -1000220580,
    // Ti57~
    -1000220570,
    // Ti56~
    -1000220560,
    // Ti55~
    -1000220550,
    // Ti54~
    -1000220540,
    // Ti53~
    -1000220530,
    // Ti52~
    -1000220520,
    // Ti51~
    -1000220510,
    // Ti50~
    -1000220500,
    // Ti49~
    -1000220490,
    // Ti48~
    -1000220480,
    // Ti47~
    -1000220470,
    // Ti46~
    -1000220460,
    // Ti45~
    -1000220450,
    // Ti44~
    -1000220440,
    // Ti43~
    -1000220430,
    // Ti42~
    -1000220420,
    // Ti41~
    -1000220410,
    // Ti40~
    -1000220400,
    // Ti39~
    -1000220390,
    // Ti38~
    -1000220380,
    // Sc59~
    -1000210590,
    // Sc58~
    -1000210580,
    // Sc57~
    -1000210570,
    // Sc56~
    -1000210560,
    // Sc55~
    -1000210550,
    // Sc54~
    -1000210540,
    // Sc53~
    -1000210530,
    // Sc52~
    -1000210520,
    // Sc51~
    -1000210510,
    // Sc50~
    -1000210500,
    // Sc49~
    -1000210490,
    // Sc48~
    -1000210480,
    // Sc47~
    -1000210470,
    // Sc46~
    -1000210460,
    // Sc45~
    -1000210450,
    // Sc44~
    -1000210440,
    // Sc43~
    -1000210430,
    // Sc42~
    -1000210420,
    // Sc41~
    -1000210410,
    // Sc40~
    -1000210400,
    // Sc39~
    -1000210390,
    // Sc38~
    -1000210380,
    // Sc37~
    -1000210370,
    // Sc36~
    -1000210360,
    // Ca57~
    -1000200570,
    // Ca56~
    -1000200560,
    // Ca55~
    -1000200550,
    // Ca54~
    -1000200540,
    // Ca53~
    -1000200530,
    // Ca52~
    -1000200520,
    // Ca51~
    -1000200510,
    // Ca50~
    -1000200500,
    // Ca49~
    -1000200490,
    // Ca48~
    -1000200480,
    // Ca47~
    -1000200470,
    // Ca46~
    -1000200460,
    // Ca45~
    -1000200450,
    // Ca44~
    -1000200440,
    // Ca43~
    -1000200430,
    // Ca42~
    -1000200420,
    // Ca41~
    -1000200410,
    // Ca40~
    -1000200400,
    // Ca39~
    -1000200390,
    // Ca38~
    -1000200380,
    // Ca37~
    -1000200370,
    // Ca36~
    -1000200360,
    // Ca35~
    -1000200350,
    // Ca34~
    -1000200340,
    // K55~
    -1000190550,
    // K54~
    -1000190540,
    // K53~
    -1000190530,
    // K52~
    -1000190520,
    // K51~
    -1000190510,
    // K50~
    -1000190500,
    // K49~
    -1000190490,
    // K48~
    -1000190480,
    // K47~
    -1000190470,
    // K46~
    -1000190460,
    // K45~
    -1000190450,
    // K44~
    -1000190440,
    // K43~
    -1000190430,
    // K42~
    -1000190420,
    // K41~
    -1000190410,
    // K40~
    -1000190400,
    // K39~
    -1000190390,
    // K38~
    -1000190380,
    // K37~
    -1000190370,
    // K36~
    -1000190360,
    // K35~
    -1000190350,
    // K34~
    -1000190340,
    // K33~
    -1000190330,
    // K32~
    -1000190320,
    // Ar53~
    -1000180530,
    // Ar52~
    -1000180520,
    // Ar51~
    -1000180510,
    // Ar50~
    -1000180500,
    // Ar49~
    -1000180490,
    // Ar48~
    -1000180480,
    // Ar47~
    -1000180470,
    // Ar46~
    -1000180460,
    // Ar45~
    -1000180450,
    // Ar44~
    -1000180440,
    // Ar43~
    -1000180430,
    // Ar42~
    -1000180420,
    // Ar41~
    -1000180410,
    // Ar40~
    -1000180400,
    // Ar39~
    -1000180390,
    // Ar38~
    -1000180380,
    // Ar37~
    -1000180370,
    // Ar36~
    -1000180360,
    // Ar35~
    -1000180350,
    // Ar34~
    -1000180340,
    // Ar33~
    -1000180330,
    // Ar32~
    -1000180320,
    // Ar31~
    -1000180310,
    // Ar30~
    -1000180300,
    // Cl51~
    -1000170510,
    // Cl50~
    -1000170500,
    // Cl49~
    -1000170490,
    // Cl48~
    -1000170480,
    // Cl47~
    -1000170470,
    // Cl46~
    -1000170460,
    // Cl45~
    -1000170450,
    // Cl44~
    -1000170440,
    // Cl43~
    -1000170430,
    // Cl42~
    -1000170420,
    // Cl41~
    -1000170410,
    // Cl40~
    -1000170400,
    // Cl39~
    -1000170390,
    // Cl38~
    -1000170380,
    // Cl37~
    -1000170370,
    // Cl36~
    -1000170360,
    // Cl35~
    -1000170350,
    // Cl34~
    -1000170340,
    // Cl33~
    -1000170330,
    // Cl32~
    -1000170320,
    // Cl31~
    -1000170310,
    // Cl30~
    -1000170300,
    // Cl29~
    -1000170290,
    // Cl28~
    -1000170280,
    // S49~
    -1000160490,
    // S48~
    -1000160480,
    // S47~
    -1000160470,
    // S46~
    -1000160460,
    // S45~
    -1000160450,
    // S44~
    -1000160440,
    // S43~
    -1000160430,
    // S42~
    -1000160420,
    // S41~
    -1000160410,
    // S40~
    -1000160400,
    // S39~
    -1000160390,
    // S38~
    -1000160380,
    // S37~
    -1000160370,
    // S36~
    -1000160360,
    // S35~
    -1000160350,
    // S34~
    -1000160340,
    // S33~
    -1000160330,
    // S32~
    -1000160320,
    // S31~
    -1000160310,
    // S30~
    -1000160300,
    // S29~
    -1000160290,
    // S28~
    -1000160280,
    // S27~
    -1000160270,
    // S26~
    -1000160260,
    // P46~
    -1000150460,
    // P45~
    -1000150450,
    // P44~
    -1000150440,
    // P43~
    -1000150430,
    // P42~
    -1000150420,
    // P41~
    -1000150410,
    // P40~
    -1000150400,
    // P39~
    -1000150390,
    // P38~
    -1000150380,
    // P37~
    -1000150370,
    // P36~
    -1000150360,
    // P35~
    -1000150350,
    // P34~
    -1000150340,
    // P33~
    -1000150330,
    // P32~
    -1000150320,
    // P31~
    -1000150310,
    // P30~
    -1000150300,
    // P29~
    -1000150290,
    // P28~
    -1000150280,
    // P27~
    -1000150270,
    // P26~
    -1000150260,
    // P25~
    -1000150250,
    // P24~
    -1000150240,
    // Si42~
    -1000140420,
    // Si41~
    -1000140410,
    // Si40~
    -1000140400,
    // Si39~
    -1000140390,
    // Si38~
    -1000140380,
    // Si37~
    -1000140370,
    // Si36~
    -1000140360,
    // Si35~
    -1000140350,
    // Si34~
    -1000140340,
    // Si33~
    -1000140330,
    // Si32~
    -1000140320,
    // Si31~
    -1000140310,
    // Si30~
    -1000140300,
    // Si29~
    -1000140290,
    // Si28~
    -1000140280,
    // Si27~
    -1000140270,
    // Si26~
    -1000140260,
    // Si25~
    -1000140250,
    // Si24~
    -1000140240,
    // Si23~
    -1000140230,
    // Si22~
    -1000140220,
    // Al39~
    -1000130390,
    // Al38~
    -1000130380,
    // Al37~
    -1000130370,
    // Al36~
    -1000130360,
    // Al35~
    -1000130350,
    // Al34~
    -1000130340,
    // Al33~
    -1000130330,
    // Al32~
    -1000130320,
    // Al31~
    -1000130310,
    // Al30~
    -1000130300,
    // Al29~
    -1000130290,
    // Al28~
    -1000130280,
    // Al27~
    -1000130270,
    // Al26~
    -1000130260,
    // Al25~
    -1000130250,
    // Al24~
    -1000130240,
    // Al23~
    -1000130230,
    // Al22~
    -1000130220,
    // Al21~
    -1000130210,
    // Mg37~
    -1000120370,
    // Mg36~
    -1000120360,
    // Mg35~
    -1000120350,
    // Mg34~
    -1000120340,
    // Mg33~
    -1000120330,
    // Mg32~
    -1000120320,
    // Mg31~
    -1000120310,
    // Mg30~
    -1000120300,
    // Mg29~
    -1000120290,
    // Mg28~
    -1000120280,
    // Mg27~
    -1000120270,
    // Mg26~
    -1000120260,
    // Mg25~
    -1000120250,
    // Mg24~
    -1000120240,
    // Mg23~
    -1000120230,
    // Mg22~
    -1000120220,
    // Mg21~
    -1000120210,
    // Mg20~
    -1000120200,
    // Na35~
    -1000110350,
    // Na34~
    -1000110340,
    // Na33~
    -1000110330,
    // Na32~
    -1000110320,
    // Na31~
    -1000110310,
    // Na30~
    -1000110300,
    // Na29~
    -1000110290,
    // Na28~
    -1000110280,
    // Na27~
    -1000110270,
    // Na26~
    -1000110260,
    // Na25~
    -1000110250,
    // Na24~
    -1000110240,
    // Na23~
    -1000110230,
    // Na22~
    -1000110220,
    // Na21~
    -1000110210,
    // Na20~
    -1000110200,
    // Na19~
    -1000110190,
    // Na18~
    -1000110180,
    // Ne32~
    -1000100320,
    // Ne31~
    -1000100310,
    // Ne30~
    -1000100300,
    // Ne29~
    -1000100290,
    // Ne28~
    -1000100280,
    // Ne27~
    -1000100270,
    // Ne26~
    -1000100260,
    // Ne25~
    -1000100250,
    // Ne24~
    -1000100240,
    // Ne23~
    -1000100230,
    // Ne22~
    -1000100220,
    // Ne21~
    -1000100210,
    // Ne20~
    -1000100200,
    // Ne19~
    -1000100190,
    // Ne18~
    -1000100180,
    // Ne17~
    -1000100170,
    // Ne16~
    -1000100160,
    // F29~
    -1000090290,
    // F28~
    -1000090280,
    // F27~
    -1000090270,
    // F26~
    -1000090260,
    // F25~
    -1000090250,
    // F24~
    -1000090240,
    // F23~
    -1000090230,
    // F22~
    -1000090220,
    // F21~
    -1000090210,
    // F20~
    -1000090200,
    // F19~
    -1000090190,
    // F18~
    -1000090180,
    // F17~
    -1000090170,
    // F16~
    -1000090160,
    // F15~
    -1000090150,
    // F14~
    -1000090140,
    // O26~
    -1000080260,
    // O25~
    -1000080250,
    // O24~
    -1000080240,
    // O23~
    -1000080230,
    // O22~
    -1000080220,
    // O21~
    -1000080210,
    // O20~
    -1000080200,
    // O19~
    -1000080190,
    // O18~
    -1000080180,
    // O17~
    -1000080170,
    // O16~
    -1000080160,
    // O15~
    -1000080150,
    // O14~
    -1000080140,
    // O13~
    -1000080130,
    // O12~
    -1000080120,
    // N24~
    -1000070240,
    // N23~
    -1000070230,
    // N22~
    -1000070220,
    // N21~
    -1000070210,
    // N20~
    -1000070200,
    // N19~
    -1000070190,
    // N18~
    -1000070180,
    // N17~
    -1000070170,
    // N16~
    -1000070160,
    // N15~
    -1000070150,
    // N14~
    -1000070140,
    // N13~
    -1000070130,
    // N12~
    -1000070120,
    // N11~
    -1000070110,
    // N10~
    -1000070100,
    // C22~
    -1000060220,
    // C21~
    -1000060210,
    // C20~
    -1000060200,
    // C19~
    -1000060190,
    // C18~
    -1000060180,
    // C17~
    -1000060170,
    // C16~
    -1000060160,
    // C15~
    -1000060150,
    // C14~
    -1000060140,
    // C13~
    -1000060130,
    // C12~
    -1000060120,
    // C11~
    -1000060110,
    // C10~
    -1000060100,
    // C9~
    -1000060090,
    // C8~
    -1000060080,
    // B19~
    -1000050190,
    // B18~
    -1000050180,
    // B17~
    -1000050170,
    // B16~
    -1000050160,
    // B15~
    -1000050150,
    // B14~
    -1000050140,
    // B13~
    -1000050130,
    // B12~
    -1000050120,
    // B11~
    -1000050110,
    // B10~
    -1000050100,
    // B9~
    -1000050090,
    // B8~
    -1000050080,
    // B7~
    -1000050070,
    // Be14~
    -1000040140,
    // Be13~
    -1000040130,
    // Be12~
    -1000040120,
    // Be11~
    -1000040110,
    // Be10~
    -1000040100,
    // Be9~
    -1000040090,
    // Be8~
    -1000040080,
    // Be7~
    -1000040070,
    // Be6~
    -1000040060,
    // Be5~
    -1000040050,
    // Li12~
    -1000030120,
    // Li11~
    -1000030110,
    // Li10~
    -1000030100,
    // Li9~
    -1000030090,
    // Li8~
    -1000030080,
    // Li7~
    -1000030070,
    // Li6~
    -1000030060,
    // Li5~
    -1000030050,
    // Li4~
    -1000030040,
    // He10~
    -1000020100,
    // He9~
    -1000020090,
    // He8~
    -1000020080,
    // He7~
    -1000020070,
    // He6~
    -1000020060,
    // He5~
    -1000020050,
    // He4~
    -1000020040,
    // He3~
    -1000020030,
    // H6~
    -1000010060,
    // H5~
    -1000010050,
    // H4~
    -1000010040,
    // T3~
    -1000010030,
    // D2~
    -1000010020,
    // p~
    -1000010010,
    // n~
    -1000000010,
    // K(2)(2250)-
    -9020325,
    // K(0)*(1950)-
    -9020321,
    // a(1)(1640)-
    -9020213,
    // K(3)(2320)-
    -9010327,
    // K(2)*(1980)-
    -9010325,
    // K(1830)-
    -9010321,
    // K(2)*(1980)~0
    -9010315,
    // pi(1)(1600)-
    -9010213,
    // pi(1800)-
    -9010211,
    // K(4)(2500)-
    -9000329,
    // K(2)(1580)-
    -9000325,
    // K(1)(1650)-
    -9000323,
    // K(0)*(700)-
    -9000321,
    // K(1)(1650)~0
    -9000313,
    // K(0)*(700)~0
    -9000311,
    // a(2)(1700)-
    -9000215,
    // pi(1)(1400)-
    -9000213,
    // a(0)(980)-
    -9000211,
    // Lambda(c)(2880)~-
    -204126,
    // Omega(2250)~+
    -203338,
    // Xi(2030)~0
    -203326,
    // Xi(1690)~0
    -203322,
    // Xi(2030)~+
    -203316,
    // Xi(1690)~+
    -203312,
    // Xi(c)(2790)~-
    -104324,
    // Xi(c)(2815)~-
    -104322,
    // Xi(c)(2790)~0
    -104314,
    // Xi(c)(2815)~0
    -104312,
    // Lambda(c)(2625)~-
    -104122,
    // Xi(1950)~0
    -103326,
    // Xi(1950)~+
    -103316,
    // K*(1410)-
    -100323,
    // K(1460)-
    -100321,
    // K*(1410)~0
    -100313,
    // rho(1450)-
    -100213,
    // pi(1300)-
    -100211,
    // Lambda(1810)~
    -53122,
    // Lambda(1800)~
    -43122,
    // N(1710)~-
    -42212,
    // N(1710)~0
    -42112,
    // Lambda(1670)~
    -33122,
    // Delta(1600)~--
    -32224,
    // Delta(1600)~-
    -32214,
    // N(1650)~-
    -32212,
    // N(1720)~-
    -32124,
    // Delta(1600)~0
    -32114,
    // N(1650)~0
    -32112,
    // N(1720)~0
    -31214,
    // Delta(1600)~+
    -31114,
    // K*(1680)-
    -30323,
    // K*(1680)~0
    -30313,
    // rho(1700)-
    -30213,
    // Sigma(1910)~-
    -23224,
    // Sigma(1750)~-
    -23222,
    // Sigma(1910)~0
    -23214,
    // Sigma(1750)~0
    -23212,
    // Lambda(2110)~
    -23126,
    // Lambda(1890)~
    -23124,
    // Lambda(1600)~
    -23122,
    // Sigma(1910)~+
    -23114,
    // Sigma(1750)~+
    -23112,
    // Delta(1920)~--
    -22224,
    // Delta(1910)~--
    -22222,
    // Delta(1920)~-
    -22214,
    // N(1535)~-
    -22212,
    // N(1700)~-
    -22124,
    // Delta(1910)~-
    -22122,
    // Delta(1920)~0
    -22114,
    // N(1535)~0
    -22112,
    // N(1700)~0
    -21214,
    // Delta(1910)~0
    -21212,
    // Delta(1920)~+
    -21114,
    // Delta(1910)~+
    -21112,
    // D(s1)(2460)-
    -20433,
    // D(1)(2430)~0
    -20423,
    // K(2)(1820)-
    -20325,
    // K(1)(1400)-
    -20323,
    // K(2)(1820)~0
    -20315,
    // K(1)(1400)~0
    -20313,
    // a(1)(1260)-
    -20213,
    // Lambda(c)(2595)~-
    -14122,
    // Xi(1820)~0
    -13324,
    // Xi(1820)~+
    -13314,
    // Sigma(1915)~-
    -13226,
    // Sigma(1670)~-
    -13224,
    // Sigma(1660)~-
    -13222,
    // Sigma(1915)~0
    -13216,
    // Sigma(1670)~0
    -13214,
    // Sigma(1660)~0
    -13212,
    // Lambda(1830)~
    -13126,
    // Lambda(1690)~
    -13124,
    // Lambda(1405)~
    -13122,
    // Sigma(1915)~+
    -13116,
    // Sigma(1670)~+
    -13114,
    // Sigma(1660)~+
    -13112,
    // Delta(1930)~--
    -12226,
    // Delta(1700)~--
    -12224,
    // Delta(1900)~--
    -12222,
    // N(1680)~-
    -12216,
    // Delta(1700)~-
    -12214,
    // N(1440)~-
    -12212,
    // Delta(1930)~-
    -12126,
    // Delta(1900)~-
    -12122,
    // N(1680)~0
    -12116,
    // Delta(1700)~0
    -12114,
    // N(1440)~0
    -12112,
    // Delta(1930)~0
    -11216,
    // Delta(1900)~0
    -11212,
    // Delta(1930)~+
    -11116,
    // Delta(1700)~+
    -11114,
    // Delta(1900)~+
    -11112,
    // D(s1)(2536)-
    -10433,
    // D(s0)*(2317)-
    -10431,
    // D(1)(2420)~0
    -10423,
    // D(0)*(2300)~0
    -10421,
    // D(1)(2420)-
    -10413,
    // D(0)*(2300)-
    -10411,
    // K(2)(1770)-
    -10325,
    // K(1)(1270)-
    -10323,
    // K(0)*(1430)-
    -10321,
    // K(2)(1770)~0
    -10315,
    // K(1)(1270)~0
    -10313,
    // K(0)*(1430)~0
    -10311,
    // pi(2)(1670)-
    -10215,
    // b(1)(1235)-
    -10213,
    // a(0)(1450)-
    -10211,
    // (bb)(1)~
    -5503,
    // (bc)(1)~
    -5403,
    // (bc)(0)~
    -5401,
    // Omega(b)~+
    -5332,
    // (bs)(1)~
    -5303,
    // (bs)(0)~
    -5301,
    // Xi(b)~0
    -5232,
    // Sigma(b)*~-
    -5224,
    // Sigma(b)~-
    -5222,
    // (bu)(1)~
    -5203,
    // (bu)(0)~
    -5201,
    // Xi(b)~+
    -5132,
    // Lambda(b)~0
    -5122,
    // Sigma(b)*~+
    -5114,
    // Sigma(b)~+
    -5112,
    // (bd)(1)~
    -5103,
    // (bd)(0)~
    -5101,
    // (cc)(1)~
    -4403,
    // Omega(c)(2770)~0
    -4334,
    // Omega(c)~0
    -4332,
    // Xi(c)(2645)~-
    -4324,
    // Xi(c)'~-
    -4322,
    // Xi(c)(2645)~0
    -4314,
    // Xi(c)'~0
    -4312,
    // (cs)(1)~
    -4303,
    // (cs)(0)~
    -4301,
    // Xi(c)~-
    -4232,
    // Sigma(c)(2520)~--
    -4224,
    // Sigma(c)(2455)~--
    -4222,
    // Sigma(c)(2520)~-
    -4214,
    // Sigma(c)(2455)~-
    -4212,
    // (cu)(1)~
    -4203,
    // (cu)(0)~
    -4201,
    // Xi(c)~0
    -4132,
    // Lambda(c)~-
    -4122,
    // Sigma(c)(2520)~0
    -4114,
    // Sigma(c)(2455)~0
    -4112,
    // (cd)(1)~
    -4103,
    // (cd)(0)~
    -4101,
    // Omega~+
    -3334,
    // Xi(1530)~0
    -3324,
    // Xi~0
    -3322,
    // Xi(1530)~+
    -3314,
    // Xi~+
    -3312,
    // (ss)(1)~
    -3303,
    // Sigma(2030)~-
    -3228,
    // Sigma(1775)~-
    -3226,
    // Sigma(1385)~-
    -3224,
    // Sigma~-
    -3222,
    // Sigma(2030)~0
    -3218,
    // Sigma(1775)~0
    -3216,
    // Sigma(1385)~0
    -3214,
    // Sigma~0
    -3212,
    // (su)(1)~
    -3203,
    // (su)(0)~
    -3201,
    // Lambda(2100)~
    -3128,
    // Lambda(1820)~
    -3126,
    // Lambda(1520)~
    -3124,
    // Lambda~
    -3122,
    // Sigma(2030)~+
    -3118,
    // Sigma(1775)~+
    -3116,
    // Sigma(1385)~+
    -3114,
    // Sigma~+
    -3112,
    // (sd)(1)~
    -3103,
    // (sd)(0)~
    -3101,
    // Delta(1950)~--
    -2228,
    // Delta(1905)~--
    -2226,
    // Delta(1232)~--
    -2224,
    // Delta(1620)~--
    -2222,
    // Delta(1950)~-
    -2218,
    // N(1675)~-
    -2216,
    // Delta(1232)~-
    -2214,
    // p~
    -2212,
    // (uu)(1)~
    -2203,
    // N(2190)~-
    -2128,
    // Delta(1905)~-
    -2126,
    // N(1520)~-
    -2124,
    // Delta(1620)~-
    -2122,
    // Delta(1950)~0
    -2118,
    // N(1675)~0
    -2116,
    // Delta(1232)~0
    -2114,
    // n~
    -2112,
    // (ud)(1)~
    -2103,
    // (ud)(0)~
    -2101,
    // N(2190)~0
    -1218,
    // Delta(1905)~0
    -1216,
    // N(1520)~0
    -1214,
    // Delta(1620)~0
    -1212,
    // Delta(1950)~+
    -1118,
    // Delta(1905)~+
    -1116,
    // Delta(1232)~+
    -1114,
    // Delta(1620)~+
    -1112,
    // (dd)(1)~
    -1103,
    // B(c)-
    -541,
    // B(s2)*(5840)~0
    -535,
    // B(s)*~0
    -533,
    // B(s)~0
    -531,
    // B(2)*(5747)-
    -525,
    // B*-
    -523,
    // B-
    -521,
    // B(2)*(5747)~0
    -515,
    // B*~0
    -513,
    // B~0
    -511,
    // D(s2)*(2573)-
    -435,
    // D(s)*-
    -433,
    // D(s)-
    -431,
    // D(2)*(2460)~0
    -425,
    // D*(2007)~0
    -423,
    // D~0
    -421,
    // D(2)*(2460)-
    -415,
    // D*(2010)-
    -413,
    // D-
    -411,
    // K(4)*(2045)-
    -329,
    // K(3)*(1780)-
    -327,
    // K(2)*(1430)-
    -325,
    // K*(892)-
    -323,
    // K-
    -321,
    // K(4)*(2045)~0
    -319,
    // K(3)*(1780)~0
    -317,
    // K(2)*(1430)~0
    -315,
    // K*(892)~0
    -313,
    // K~0
    -311,
    // a(4)(1970)-
    -219,
    // rho(3)(1690)-
    -217,
    // a(2)(1320)-
    -215,
    // rho(770)-
    -213,
    // pi-
    -211,
    // W-
    -24,
    // nu(tau')~
    -18,
    // tau'+
    -17,
    // nu(tau)~
    -16,
    // tau+
    -15,
    // nu(mu)~
    -14,
    // mu+
    -13,
    // nu(e)~
    -12,
    // e+
    -11,
    // t~
    -6,
    // b~
    -5,
    // c~
    -4,
    // s~
    -3,
    // u~
    -2,
    // d~
    -1,
    // d
    1,
    // u
    2,
    // s
    3,
    // c
    4,
    // b
    5,
    // t
    6,
    // e-
    11,
    // nu(e)
    12,
    // mu-
    13,
    // nu(mu)
    14,
    // tau-
    15,
    // nu(tau)
    16,
    // tau'-
    17,
    // nu(tau')
    18,
    // g
    21,
    // gamma
    22,
    // Z0
    23,
    // W+
    24,
    // H0
    25,
    // pi0
    111,
    // rho(770)0
    113,
    // a(2)(1320)0
    115,
    // rho(3)(1690)0
    117,
    // a(4)(1970)0
    119,
    // K(L)0
    130,
    // pi+
    211,
    // rho(770)+
    213,
    // a(2)(1320)+
    215,
    // rho(3)(1690)+
    217,
    // a(4)(1970)+
    219,
    // eta
    221,
    // omega(782)
    223,
    // f(2)(1270)
    225,
    // omega(3)(1670)
    227,
    // f(4)(2050)
    229,
    // K(S)0
    310,
    // K0
    311,
    // K*(892)0
    313,
    // K(2)*(1430)0
    315,
    // K(3)*(1780)0
    317,
    // K(4)*(2045)0
    319,
    // K+
    321,
    // K*(892)+
    323,
    // K(2)*(1430)+
    325,
    // K(3)*(1780)+
    327,
    // K(4)*(2045)+
    329,
    // eta'(958)
    331,
    // phi(1020)
    333,
    // f(2)'(1525)
    335,
    // phi(3)(1850)
    337,
    // D+
    411,
    // D*(2010)+
    413,
    // D(2)*(2460)+
    415,
    // D0
    421,
    // D*(2007)0
    423,
    // D(2)*(2460)0
    425,
    // D(s)+
    431,
    // D(s)*+
    433,
    // D(s2)*(2573)+
    435,
    // eta(c)(1S)
    441,
    // J/psi(1S)
    443,
    // chi(c2)(1P)
    445,
    // B0
    511,
    // B*0
    513,
    // B(2)*(5747)0
    515,
    // B+
    521,
    // B*+
    523,
    // B(2)*(5747)+
    525,
    // B(s)0
    531,
    // B(s)*0
    533,
    // B(s2)*(5840)0
    535,
    // B(c)+
    541,
    // eta(b)(1S)
    551,
    // Upsilon(1S)
    553,
    // chi(b2)(1P)
    555,
    // (dd)(1)
    1103,
    // Delta(1620)-
    1112,
    // Delta(1232)-
    1114,
    // Delta(1905)-
    1116,
    // Delta(1950)-
    1118,
    // Delta(1620)0
    1212,
    // N(1520)0
    1214,
    // Delta(1905)0
    1216,
    // N(2190)0
    1218,
    // (ud)(0)
    2101,
    // (ud)(1)
    2103,
    // n
    2112,
    // Delta(1232)0
    2114,
    // N(1675)0
    2116,
    // Delta(1950)0
    2118,
    // Delta(1620)+
    2122,
    // N(1520)+
    2124,
    // Delta(1905)+
    2126,
    // N(2190)+
    2128,
    // (uu)(1)
    2203,
    // p
    2212,
    // Delta(1232)+
    2214,
    // N(1675)+
    2216,
    // Delta(1950)+
    2218,
    // Delta(1620)++
    2222,
    // Delta(1232)++
    2224,
    // Delta(1905)++
    2226,
    // Delta(1950)++
    2228,
    // (sd)(0)
    3101,
    // (sd)(1)
    3103,
    // Sigma-
    3112,
    // Sigma(1385)-
    3114,
    // Sigma(1775)-
    3116,
    // Sigma(2030)-
    3118,
    // Lambda
    3122,
    // Lambda(1520)
    3124,
    // Lambda(1820)
    3126,
    // Lambda(2100)
    3128,
    // (su)(0)
    3201,
    // (su)(1)
    3203,
    // Sigma0
    3212,
    // Sigma(1385)0
    3214,
    // Sigma(1775)0
    3216,
    // Sigma(2030)0
    3218,
    // Sigma+
    3222,
    // Sigma(1385)+
    3224,
    // Sigma(1775)+
    3226,
    // Sigma(2030)+
    3228,
    // (ss)(1)
    3303,
    // Xi-
    3312,
    // Xi(1530)-
    3314,
    // Xi0
    3322,
    // Xi(1530)0
    3324,
    // Omega-
    3334,
    // (cd)(0)
    4101,
    // (cd)(1)
    4103,
    // Sigma(c)(2455)0
    4112,
    // Sigma(c)(2520)0
    4114,
    // Lambda(c)+
    4122,
    // Xi(c)0
    4132,
    // (cu)(0)
    4201,
    // (cu)(1)
    4203,
    // Sigma(c)(2455)+
    4212,
    // Sigma(c)(2520)+
    4214,
    // Sigma(c)(2455)++
    4222,
    // Sigma(c)(2520)++
    4224,
    // Xi(c)+
    4232,
    // (cs)(0)
    4301,
    // (cs)(1)
    4303,
    // Xi(c)'0
    4312,
    // Xi(c)(2645)0
    4314,
    // Xi(c)'+
    4322,
    // Xi(c)(2645)+
    4324,
    // Omega(c)0
    4332,
    // Omega(c)(2770)0
    4334,
    // (cc)(1)
    4403,
    // (bd)(0)
    5101,
    // (bd)(1)
    5103,
    // Sigma(b)-
    5112,
    // Sigma(b)*-
    5114,
    // Lambda(b)0
    5122,
    // Xi(b)-
    5132,
    // (bu)(0)
    5201,
    // (bu)(1)
    5203,
    // Sigma(b)+
    5222,
    // Sigma(b)*+
    5224,
    // Xi(b)0
    5232,
    // (bs)(0)
    5301,
    // (bs)(1)
    5303,
    // Omega(b)-
    5332,
    // (bc)(0)
    5401,
    // (bc)(1)
    5403,
    // (bb)(1)
    5503,
    // a(0)(1450)0
    10111,
    // b(1)(1235)0
    10113,
    // pi(2)(1670)0
    10115,
    // a(0)(1450)+
    10211,
    // b(1)(1235)+
    10213,
    // pi(2)(1670)+
    10215,
    // f(0)(1370)
    10221,
    // h(1)(1170)
    10223,
    // eta(2)(1645)
    10225,
    // K(0)*(1430)0
    10311,
    // K(1)(1270)0
    10313,
    // K(2)(1770)0
    10315,
    // K(0)*(1430)+
    10321,
    // K(1)(1270)+
    10323,
    // K(2)(1770)+
    10325,
    // f(0)(1710)
    10331,
    // h(1)(1415)
    10333,
    // eta(2)(1870)
    10335,
    // D(0)*(2300)+
    10411,
    // D(1)(2420)+
    10413,
    // D(0)*(2300)0
    10421,
    // D(1)(2420)0
    10423,
    // D(s0)*(2317)+
    10431,
    // D(s1)(2536)+
    10433,
    // chi(c0)(1P)
    10441,
    // h(c)(1P)
    10443,
    // chi(b0)(1P)
    10551,
    // h(b)(1P)
    10553,
    // Delta(1900)-
    11112,
    // Delta(1700)-
    11114,
    // Delta(1930)-
    11116,
    // Delta(1900)0
    11212,
    // Delta(1930)0
    11216,
    // N(1440)0
    12112,
    // Delta(1700)0
    12114,
    // N(1680)0
    12116,
    // Delta(1900)+
    12122,
    // Delta(1930)+
    12126,
    // N(1440)+
    12212,
    // Delta(1700)+
    12214,
    // N(1680)+
    12216,
    // Delta(1900)++
    12222,
    // Delta(1700)++
    12224,
    // Delta(1930)++
    12226,
    // Sigma(1660)-
    13112,
    // Sigma(1670)-
    13114,
    // Sigma(1915)-
    13116,
    // Lambda(1405)
    13122,
    // Lambda(1690)
    13124,
    // Lambda(1830)
    13126,
    // Sigma(1660)0
    13212,
    // Sigma(1670)0
    13214,
    // Sigma(1915)0
    13216,
    // Sigma(1660)+
    13222,
    // Sigma(1670)+
    13224,
    // Sigma(1915)+
    13226,
    // Xi(1820)-
    13314,
    // Xi(1820)0
    13324,
    // Lambda(c)(2595)+
    14122,
    // a(1)(1260)0
    20113,
    // a(1)(1260)+
    20213,
    // f(1)(1285)
    20223,
    // K(1)(1400)0
    20313,
    // K(2)(1820)0
    20315,
    // K(1)(1400)+
    20323,
    // K(2)(1820)+
    20325,
    // f(1)(1420)
    20333,
    // D(1)(2430)0
    20423,
    // D(s1)(2460)+
    20433,
    // chi(c1)(1P)
    20443,
    // chi(b1)(1P)
    20553,
    // Upsilon(2)(1D)
    20555,
    // Delta(1910)-
    21112,
    // Delta(1920)-
    21114,
    // Delta(1910)0
    21212,
    // N(1700)0
    21214,
    // N(1535)0
    22112,
    // Delta(1920)0
    22114,
    // Delta(1910)+
    22122,
    // N(1700)+
    22124,
    // N(1535)+
    22212,
    // Delta(1920)+
    22214,
    // Delta(1910)++
    22222,
    // Delta(1920)++
    22224,
    // Sigma(1750)-
    23112,
    // Sigma(1910)-
    23114,
    // Lambda(1600)
    23122,
    // Lambda(1890)
    23124,
    // Lambda(2110)
    23126,
    // Sigma(1750)0
    23212,
    // Sigma(1910)0
    23214,
    // Sigma(1750)+
    23222,
    // Sigma(1910)+
    23224,
    // rho(1700)0
    30113,
    // rho(1700)+
    30213,
    // omega(1650)
    30223,
    // K*(1680)0
    30313,
    // K*(1680)+
    30323,
    // psi(3770)
    30443,
    // Delta(1600)-
    31114,
    // N(1720)0
    31214,
    // N(1650)0
    32112,
    // Delta(1600)0
    32114,
    // N(1720)+
    32124,
    // N(1650)+
    32212,
    // Delta(1600)+
    32214,
    // Delta(1600)++
    32224,
    // Lambda(1670)
    33122,
    // N(1710)0
    42112,
    // N(1710)+
    42212,
    // Lambda(1800)
    43122,
    // Lambda(1810)
    53122,
    // pi(1300)0
    100111,
    // rho(1450)0
    100113,
    // pi(1300)+
    100211,
    // rho(1450)+
    100213,
    // eta(1295)
    100221,
    // omega(1420)
    100223,
    // K*(1410)0
    100313,
    // K(1460)+
    100321,
    // K*(1410)+
    100323,
    // eta(1475)
    100331,
    // phi(1680)
    100333,
    // eta(c)(2S)
    100441,
    // psi(2S)
    100443,
    // chi(c2)(3930)
    100445,
    // Upsilon(2S)
    100553,
    // chi(b2)(2P)
    100555,
    // Xi(1950)-
    103316,
    // Xi(1950)0
    103326,
    // Lambda(c)(2625)+
    104122,
    // Xi(c)(2815)0
    104312,
    // Xi(c)(2790)0
    104314,
    // Xi(c)(2815)+
    104322,
    // Xi(c)(2790)+
    104324,
    // chi(b0)(2P)
    110551,
    // h(b)(2P)
    110553,
    // chi(b1)(2P)
    120553,
    // Upsilon(3S)
    200553,
    // chi(b2)(3P)
    200555,
    // Xi(1690)-
    203312,
    // Xi(2030)-
    203316,
    // Xi(1690)0
    203322,
    // Xi(2030)0
    203326,
    // Omega(2250)-
    203338,
    // Lambda(c)(2880)+
    204126,
    // chi(b1)(3P)
    220553,
    // Upsilon(4S)
    300553,
    // a(0)(980)0
    9000111,
    // pi(1)(1400)0
    9000113,
    // a(2)(1700)0
    9000115,
    // a(0)(980)+
    9000211,
    // pi(1)(1400)+
    9000213,
    // a(2)(1700)+
    9000215,
    // f(0)(500)
    9000221,
    // K(0)*(700)0
    9000311,
    // K(1)(1650)0
    9000313,
    // K(0)*(700)+
    9000321,
    // K(1)(1650)+
    9000323,
    // K(2)(1580)+
    9000325,
    // K(4)(2500)+
    9000329,
    // psi(4040)
    9000443,
    // Upsilon(10860)
    9000553,
    // pi(1800)0
    9010111,
    // pi(1)(1600)0
    9010113,
    // pi(1800)+
    9010211,
    // pi(1)(1600)+
    9010213,
    // f(0)(980)
    9010221,
    // K(2)*(1980)0
    9010315,
    // K(1830)+
    9010321,
    // K(2)*(1980)+
    9010325,
    // K(3)(2320)+
    9010327,
    // psi(4160)
    9010443,
    // Upsilon(11020)
    9010553,
    // a(1)(1640)0
    9020113,
    // a(1)(1640)+
    9020213,
    // eta(1405)
    9020221,
    // K(0)*(1950)+
    9020321,
    // K(2)(2250)+
    9020325,
    // psi(4415)
    9020443,
    // f(0)(1500)
    9030221,
    // f(0)(2020)
    9050221,
    // f(2)(1950)
    9050225,
    // f(2)(2010)
    9060225,
    // f(2)(2300)
    9080225,
    // f(2)(2340)
    9090225,
    // n
    1000000010,
    // p
    1000010010,
    // D2
    1000010020,
    // T3
    1000010030,
    // H4
    1000010040,
    // H5
    1000010050,
    // H6
    1000010060,
    // He3
    1000020030,
    // He4
    1000020040,
    // He5
    1000020050,
    // He6
    1000020060,
    // He7
    1000020070,
    // He8
    1000020080,
    // He9
    1000020090,
    // He10
    1000020100,
    // Li4
    1000030040,
    // Li5
    1000030050,
    // Li6
    1000030060,
    // Li7
    1000030070,
    // Li8
    1000030080,
    // Li9
    1000030090,
    // Li10
    1000030100,
    // Li11
    1000030110,
    // Li12
    1000030120,
    // Be5
    1000040050,
    // Be6
    1000040060,
    // Be7
    1000040070,
    // Be8
    1000040080,
    // Be9
    1000040090,
    // Be10
    1000040100,
    // Be11
    1000040110,
    // Be12
    1000040120,
    // Be13
    1000040130,
    // Be14
    1000040140,
    // B7
    1000050070,
    // B8
    1000050080,
    // B9
    1000050090,
    // B10
    1000050100,
    // B11
    1000050110,
    // B12
    1000050120,
    // B13
    1000050130,
    // B14
    1000050140,
    // B15
    1000050150,
    // B16
    1000050160,
    // B17
    1000050170,
    // B18
    1000050180,
    // B19
    1000050190,
    // C8
    1000060080,
    // C9
    1000060090,
    // C10
    1000060100,
    // C11
    1000060110,
    // C12
    1000060120,
    // C13
    1000060130,
    // C14
    1000060140,
    // C15
    1000060150,
    // C16
    1000060160,
    // C17
    1000060170,
    // C18
    1000060180,
    // C19
    1000060190,
    // C20
    1000060200,
    // C21
    1000060210,
    // C22
    1000060220,
    // N10
    1000070100,
    // N11
    1000070110,
    // N12
    1000070120,
    // N13
    1000070130,
    // N14
    1000070140,
    // N15
    1000070150,
    // N16
    1000070160,
    // N17
    1000070170,
    // N18
    1000070180,
    // N19
    1000070190,
    // N20
    1000070200,
    // N21
    1000070210,
    // N22
    1000070220,
    // N23
    1000070230,
    // N24
    1000070240,
    // O12
    1000080120,
    // O13
    1000080130,
    // O14
    1000080140,
    // O15
    1000080150,
    // O16
    1000080160,
    // O17
    1000080170,
    // O18
    1000080180,
    // O19
    1000080190,
    // O20
    1000080200,
    // O21
    1000080210,
    // O22
    1000080220,
    // O23
    1000080230,
    // O24
    1000080240,
    // O25
    1000080250,
    // O26
    1000080260,
    // F14
    1000090140,
    // F15
    1000090150,
    // F16
    1000090160,
    // F17
    1000090170,
    // F18
    1000090180,
    // F19
    1000090190,
    // F20
    1000090200,
    // F21
    1000090210,
    // F22
    1000090220,
    // F23
    1000090230,
    // F24
    1000090240,
    // F25
    1000090250,
    // F26
    1000090260,
    // F27
    1000090270,
    // F28
    1000090280,
    // F29
    1000090290,
    // Ne16
    1000100160,
    // Ne17
    1000100170,
    // Ne18
    1000100180,
    // Ne19
    1000100190,
    // Ne20
    1000100200,
    // Ne21
    1000100210,
    // Ne22
    1000100220,
    // Ne23
    1000100230,
    // Ne24
    1000100240,
    // Ne25
    1000100250,
    // Ne26
    1000100260,
    // Ne27
    1000100270,
    // Ne28
    1000100280,
    // Ne29
    1000100290,
    // Ne30
    1000100300,
    // Ne31
    1000100310,
    // Ne32
    1000100320,
    // Na18
    1000110180,
    // Na19
    1000110190,
    // Na20
    1000110200,
    // Na21
    1000110210,
    // Na22
    1000110220,
    // Na23
    1000110230,
    // Na24
    1000110240,
    // Na25
    1000110250,
    // Na26
    1000110260,
    // Na27
    1000110270,
    // Na28
    1000110280,
    // Na29
    1000110290,
    // Na30
    1000110300,
    // Na31
    1000110310,
    // Na32
    1000110320,
    // Na33
    1000110330,
    // Na34
    1000110340,
    // Na35
    1000110350,
    // Mg20
    1000120200,
    // Mg21
    1000120210,
    // Mg22
    1000120220,
    // Mg23
    1000120230,
    // Mg24
    1000120240,
    // Mg25
    1000120250,
    // Mg26
    1000120260,
    // Mg27
    1000120270,
    // Mg28
    1000120280,
    // Mg29
    1000120290,
    // Mg30
    1000120300,
    // Mg31
    1000120310,
    // Mg32
    1000120320,
    // Mg33
    1000120330,
    // Mg34
    1000120340,
    // Mg35
    1000120350,
    // Mg36
    1000120360,
    // Mg37
    1000120370,
    // Al21
    1000130210,
    // Al22
    1000130220,
    // Al23
    1000130230,
    // Al24
    1000130240,
    // Al25
    1000130250,
    // Al26
    1000130260,
    // Al27
    1000130270,
    // Al28
    1000130280,
    // Al29
    1000130290,
    // Al30
    1000130300,
    // Al31
    1000130310,
    // Al32
    1000130320,
    // Al33
    1000130330,
    // Al34
    1000130340,
    // Al35
    1000130350,
    // Al36
    1000130360,
    // Al37
    1000130370,
    // Al38
    1000130380,
    // Al39
    1000130390,
    // Si22
    1000140220,
    // Si23
    1000140230,
    // Si24
    1000140240,
    // Si25
    1000140250,
    // Si26
    1000140260,
    // Si27
    1000140270,
    // Si28
    1000140280,
    // Si29
    1000140290,
    // Si30
    1000140300,
    // Si31
    1000140310,
    // Si32
    1000140320,
    // Si33
    1000140330,
    // Si34
    1000140340,
    // Si35
    1000140350,
    // Si36
    1000140360,
    // Si37
    1000140370,
    // Si38
    1000140380,
    // Si39
    1000140390,
    // Si40
    1000140400,
    // Si41
    1000140410,
    // Si42
    1000140420,
    // P24
    1000150240,
    // P25
    1000150250,
    // P26
    1000150260,
    // P27
    1000150270,
    // P28
    1000150280,
    // P29
    1000150290,
    // P30
    1000150300,
    // P31
    1000150310,
    // P32
    1000150320,
    // P33
    1000150330,
    // P34
    1000150340,
    // P35
    1000150350,
    // P36
    1000150360,
    // P37
    1000150370,
    // P38
    1000150380,
    // P39
    1000150390,
    // P40
    1000150400,
    // P41
    1000150410,
    // P42
    1000150420,
    // P43
    1000150430,
    // P44
    1000150440,
    // P45
    1000150450,
    // P46
    1000150460,
    // S26
    1000160260,
    // S27
    1000160270,
    // S28
    1000160280,
    // S29
    1000160290,
    // S30
    1000160300,
    // S31
    1000160310,
    // S32
    1000160320,
    // S33
    1000160330,
    // S34
    1000160340,
    // S35
    1000160350,
    // S36
    1000160360,
    // S37
    1000160370,
    // S38
    1000160380,
    // S39
    1000160390,
    // S40
    1000160400,
    // S41
    1000160410,
    // S42
    1000160420,
    // S43
    1000160430,
    // S44
    1000160440,
    // S45
    1000160450,
    // S46
    1000160460,
    // S47
    1000160470,
    // S48
    1000160480,
    // S49
    1000160490,
    // Cl28
    1000170280,
    // Cl29
    1000170290,
    // Cl30
    1000170300,
    // Cl31
    1000170310,
    // Cl32
    1000170320,
    // Cl33
    1000170330,
    // Cl34
    1000170340,
    // Cl35
    1000170350,
    // Cl36
    1000170360,
    // Cl37
    1000170370,
    // Cl38
    1000170380,
    // Cl39
    1000170390,
    // Cl40
    1000170400,
    // Cl41
    1000170410,
    // Cl42
    1000170420,
    // Cl43
    1000170430,
    // Cl44
    1000170440,
    // Cl45
    1000170450,
    // Cl46
    1000170460,
    // Cl47
    1000170470,
    // Cl48
    1000170480,
    // Cl49
    1000170490,
    // Cl50
    1000170500,
    // Cl51
    1000170510,
    // Ar30
    1000180300,
    // Ar31
    1000180310,
    // Ar32
    1000180320,
    // Ar33
    1000180330,
    // Ar34
    1000180340,
    // Ar35
    1000180350,
    // Ar36
    1000180360,
    // Ar37
    1000180370,
    // Ar38
    1000180380,
    // Ar39
    1000180390,
    // Ar40
    1000180400,
    // Ar41
    1000180410,
    // Ar42
    1000180420,
    // Ar43
    1000180430,
    // Ar44
    1000180440,
    // Ar45
    1000180450,
    // Ar46
    1000180460,
    // Ar47
    1000180470,
    // Ar48
    1000180480,
    // Ar49
    1000180490,
    // Ar50
    1000180500,
    // Ar51
    1000180510,
    // Ar52
    1000180520,
    // Ar53
    1000180530,
    // K32
    1000190320,
    // K33
    1000190330,
    // K34
    1000190340,
    // K35
    1000190350,
    // K36
    1000190360,
    // K37
    1000190370,
    // K38
    1000190380,
    // K39
    1000190390,
    // K40
    1000190400,
    // K41
    1000190410,
    // K42
    1000190420,
    // K43
    1000190430,
    // K44
    1000190440,
    // K45
    1000190450,
    // K46
    1000190460,
    // K47
    1000190470,
    // K48
    1000190480,
    // K49
    1000190490,
    // K50
    1000190500,
    // K51
    1000190510,
    // K52
    1000190520,
    // K53
    1000190530,
    // K54
    1000190540,
    // K55
    1000190550,
    // Ca34
    1000200340,
    // Ca35
    1000200350,
    // Ca36
    1000200360,
    // Ca37
    1000200370,
    // Ca38
    1000200380,
    // Ca39
    1000200390,
    // Ca40
    1000200400,
    // Ca41
    1000200410,
    // Ca42
    1000200420,
    // Ca43
    1000200430,
    // Ca44
    1000200440,
    // Ca45
    1000200450,
    // Ca46
    1000200460,
    // Ca47
    1000200470,
    // Ca48
    1000200480,
    // Ca49
    1000200490,
    // Ca50
    1000200500,
    // Ca51
    1000200510,
    // Ca52
    1000200520,
    // Ca53
    1000200530,
    // Ca54
    1000200540,
    // Ca55
    1000200550,
    // Ca56
    1000200560,
    // Ca57
    1000200570,
    // Sc36
    1000210360,
    // Sc37
    1000210370,
    // Sc38
    1000210380,
    // Sc39
    1000210390,
    // Sc40
    1000210400,
    // Sc41
    1000210410,
    // Sc42
    1000210420,
    // Sc43
    1000210430,
    // Sc44
    1000210440,
    // Sc45
    1000210450,
    // Sc46
    1000210460,
    // Sc47
    1000210470,
    // Sc48
    1000210480,
    // Sc49
    1000210490,
    // Sc50
    1000210500,
    // Sc51
    1000210510,
    // Sc52
    1000210520,
    // Sc53
    1000210530,
    // Sc54
    1000210540,
    // Sc55
    1000210550,
    // Sc56
    1000210560,
    // Sc57
    1000210570,
    // Sc58
    1000210580,
    // Sc59
    1000210590,
    // Ti38
    1000220380,
    // Ti39
    1000220390,
    // Ti40
    1000220400,
    // Ti41
    1000220410,
    // Ti42
    1000220420,
    // Ti43
    1000220430,
    // Ti44
    1000220440,
    // Ti45
    1000220450,
    // Ti46
    1000220460,
    // Ti47
    1000220470,
    // Ti48
    1000220480,
    // Ti49
    1000220490,
    // Ti50
    1000220500,
    // Ti51
    1000220510,
    // Ti52
    1000220520,
    // Ti53
    1000220530,
    // Ti54
    1000220540,
    // Ti55
    1000220550,
    // Ti56
    1000220560,
    // Ti57
    1000220570,
    // Ti58
    1000220580,
    // Ti59
    1000220590,
    // Ti60
    1000220600,
    // Ti61
    1000220610,
    // V40
    1000230400,
    // V41
    1000230410,
    // V42
    1000230420,
    // V43
    1000230430,
    // V44
    1000230440,
    // V45
    1000230450,
    // V46
    1000230460,
    // V47
    1000230470,
    // V48
    1000230480,
    // V49
    1000230490,
    // V50
    1000230500,
    // V51
    1000230510,
    // V52
    1000230520,
    // V53
    1000230530,
    // V54
    1000230540,
    // V55
    1000230550,
    // V56
    1000230560,
    // V57
    1000230570,
    // V58
    1000230580,
    // V59
    1000230590,
    // V60
    1000230600,
    // V61
    1000230610,
    // V62
    1000230620,
    // V63
    1000230630,
    // Cr42
    1000240420,
    // Cr43
    1000240430,
    // Cr44
    1000240440,
    // Cr45
    1000240450,
    // Cr46
    1000240460,
    // Cr47
    1000240470,
    // Cr48
    1000240480,
    // Cr49
    1000240490,
    // Cr50
    1000240500,
    // Cr51
    1000240510,
    // Cr52
    1000240520,
    // Cr53
    1000240530,
    // Cr54
    1000240540,
    // Cr55
    1000240550,
    // Cr56
    1000240560,
    // Cr57
    1000240570,
    // Cr58
    1000240580,
    // Cr59
    1000240590,
    // Cr60
    1000240600,
    // Cr61
    1000240610,
    // Cr62
    1000240620,
    // Cr63
    1000240630,
    // Cr64
    1000240640,
    // Cr65
    1000240650,
    // Mn44
    1000250440,
    // Mn45
    1000250450,
    // Mn46
    1000250460,
    // Mn47
    1000250470,
    // Mn48
    1000250480,
    // Mn49
    1000250490,
    // Mn50
    1000250500,
    // Mn51
    1000250510,
    // Mn52
    1000250520,
    // Mn53
    1000250530,
    // Mn54
    1000250540,
    // Mn55
    1000250550,
    // Mn56
    1000250560,
    // Mn57
    1000250570,
    // Mn58
    1000250580,
    // Mn59
    1000250590,
    // Mn60
    1000250600,
    // Mn61
    1000250610,
    // Mn62
    1000250620,
    // Mn63
    1000250630,
    // Mn64
    1000250640,
    // Mn65
    1000250650,
    // Mn66
    1000250660,
    // Mn67
    1000250670,
    // Fe45
    1000260450,
    // Fe46
    1000260460,
    // Fe47
    1000260470,
    // Fe48
    1000260480,
    // Fe49
    1000260490,
    // Fe50
    1000260500,
    // Fe51
    1000260510,
    // Fe52
    1000260520,
    // Fe53
    1000260530,
    // Fe54
    1000260540,
    // Fe55
    1000260550,
    // Fe56
    1000260560,
    // Fe57
    1000260570,
    // Fe58
    1000260580,
    // Fe59
    1000260590,
    // Fe60
    1000260600,
    // Fe61
    1000260610,
    // Fe62
    1000260620,
    // Fe63
    1000260630,
    // Fe64
    1000260640,
    // Fe65
    1000260650,
    // Fe66
    1000260660,
    // Fe67
    1000260670,
    // Fe68
    1000260680,
    // Fe69
    1000260690,
    // Co48
    1000270480,
    // Co49
    1000270490,
    // Co50
    1000270500,
    // Co51
    1000270510,
    // Co52
    1000270520,
    // Co53
    1000270530,
    // Co54
    1000270540,
    // Co55
    1000270550,
    // Co56
    1000270560,
    // Co57
    1000270570,
    // Co58
    1000270580,
    // Co59
    1000270590,
    // Co60
    1000270600,
    // Co61
    1000270610,
    // Co62
    1000270620,
    // Co63
    1000270630,
    // Co64
    1000270640,
    // Co65
    1000270650,
    // Co66
    1000270660,
    // Co67
    1000270670,
    // Co68
    1000270680,
    // Co69
    1000270690,
    // Co70
    1000270700,
    // Co71
    1000270710,
    // Co72
    1000270720,
    // Ni50
    1000280500,
    // Ni51
    1000280510,
    // Ni52
    1000280520,
    // Ni53
    1000280530,
    // Ni54
    1000280540,
    // Ni55
    1000280550,
    // Ni56
    1000280560,
    // Ni57
    1000280570,
    // Ni58
    1000280580,
    // Ni59
    1000280590,
    // Ni60
    1000280600,
    // Ni61
    1000280610,
    // Ni62
    1000280620,
    // Ni63
    1000280630,
    // Ni64
    1000280640,
    // Ni65
    1000280650,
    // Ni66
    1000280660,
    // Ni67
    1000280670,
    // Ni68
    1000280680,
    // Ni69
    1000280690,
    // Ni70
    1000280700,
    // Ni71
    1000280710,
    // Ni72
    1000280720,
    // Ni73
    1000280730,
    // Ni74
    1000280740,
    // Ni75
    1000280750,
    // Ni76
    1000280760,
    // Ni77
    1000280770,
    // Ni78
    1000280780,
    // Cu52
    1000290520,
    // Cu53
    1000290530,
    // Cu54
    1000290540,
    // Cu55
    1000290550,
    // Cu56
    1000290560,
    // Cu57
    1000290570,
    // Cu58
    1000290580,
    // Cu59
    1000290590,
    // Cu60
    1000290600,
    // Cu61
    1000290610,
    // Cu62
    1000290620,
    // Cu63
    1000290630,
    // Cu64
    1000290640,
    // Cu65
    1000290650,
    // Cu66
    1000290660,
    // Cu67
    1000290670,
    // Cu68
    1000290680,
    // Cu69
    1000290690,
    // Cu70
    1000290700,
    // Cu71
    1000290710,
    // Cu72
    1000290720,
    // Cu73
    1000290730,
    // Cu74
    1000290740,
    // Cu75
    1000290750,
    // Cu76
    1000290760,
    // Cu77
    1000290770,
    // Cu78
    1000290780,
    // Cu79
    1000290790,
    // Cu80
    1000290800,
    // Zn54
    1000300540,
    // Zn55
    1000300550,
    // Zn56
    1000300560,
    // Zn57
    1000300570,
    // Zn58
    1000300580,
    // Zn59
    1000300590,
    // Zn60
    1000300600,
    // Zn61
    1000300610,
    // Zn62
    1000300620,
    // Zn63
    1000300630,
    // Zn64
    1000300640,
    // Zn65
    1000300650,
    // Zn66
    1000300660,
    // Zn67
    1000300670,
    // Zn68
    1000300680,
    // Zn69
    1000300690,
    // Zn70
    1000300700,
    // Zn71
    1000300710,
    // Zn72
    1000300720,
    // Zn73
    1000300730,
    // Zn74
    1000300740,
    // Zn75
    1000300750,
    // Zn76
    1000300760,
    // Zn77
    1000300770,
    // Zn78
    1000300780,
    // Zn79
    1000300790,
    // Zn80
    1000300800,
    // Zn81
    1000300810,
    // Zn82
    1000300820,
    // Ga56
    1000310560,
    // Ga57
    1000310570,
    // Ga58
    1000310580,
    // Ga59
    1000310590,
    // Ga60
    1000310600,
    // Ga61
    1000310610,
    // Ga62
    1000310620,
    // Ga63
    1000310630,
    // Ga64
    1000310640,
    // Ga65
    1000310650,
    // Ga66
    1000310660,
    // Ga67
    1000310670,
    // Ga68
    1000310680,
    // Ga69
    1000310690,
    // Ga70
    1000310700,
    // Ga71
    1000310710,
    // Ga72
    1000310720,
    // Ga73
    1000310730,
    // Ga74
    1000310740,
    // Ga75
    1000310750,
    // Ga76
    1000310760,
    // Ga77
    1000310770,
    // Ga78
    1000310780,
    // Ga79
    1000310790,
    // Ga80
    1000310800,
    // Ga81
    1000310810,
    // Ga82
    1000310820,
    // Ga83
    1000310830,
    // Ga84
    1000310840,
    // Ge58
    1000320580,
    // Ge59
    1000320590,
    // Ge60
    1000320600,
    // Ge61
    1000320610,
    // Ge62
    1000320620,
    // Ge63
    1000320630,
    // Ge64
    1000320640,
    // Ge65
    1000320650,
    // Ge66
    1000320660,
    // Ge67
    1000320670,
    // Ge68
    1000320680,
    // Ge69
    1000320690,
    // Ge70
    1000320700,
    // Ge71
    1000320710,
    // Ge72
    1000320720,
    // Ge73
    1000320730,
    // Ge74
    1000320740,
    // Ge75
    1000320750,
    // Ge76
    1000320760,
    // Ge77
    1000320770,
    // Ge78
    1000320780,
    // Ge79
    1000320790,
    // Ge80
    1000320800,
    // Ge81
    1000320810,
    // Ge82
    1000320820,
    // Ge83
    1000320830,
    // Ge84
    1000320840,
    // Ge85
    1000320850,
    // Ge86
    1000320860,
    // As60
    1000330600,
    // As61
    1000330610,
    // As62
    1000330620,
    // As63
    1000330630,
    // As64
    1000330640,
    // As65
    1000330650,
    // As66
    1000330660,
    // As67
    1000330670,
    // As68
    1000330680,
    // As69
    1000330690,
    // As70
    1000330700,
    // As71
    1000330710,
    // As72
    1000330720,
    // As73
    1000330730,
    // As74
    1000330740,
    // As75
    1000330750,
    // As76
    1000330760,
    // As77
    1000330770,
    // As78
    1000330780,
    // As79
    1000330790,
    // As80
    1000330800,
    // As81
    1000330810,
    // As82
    1000330820,
    // As83
    1000330830,
    // As84
    1000330840,
    // As85
    1000330850,
    // As86
    1000330860,
    // As87
    1000330870,
    // As88
    1000330880,
    // As89
    1000330890,
    // Se65
    1000340650,
    // Se66
    1000340660,
    // Se67
    1000340670,
    // Se68
    1000340680,
    // Se69
    1000340690,
    // Se70
    1000340700,
    // Se71
    1000340710,
    // Se72
    1000340720,
    // Se73
    1000340730,
    // Se74
    1000340740,
    // Se75
    1000340750,
    // Se76
    1000340760,
    // Se77
    1000340770,
    // Se78
    1000340780,
    // Se79
    1000340790,
    // Se80
    1000340800,
    // Se81
    1000340810,
    // Se82
    1000340820,
    // Se83
    1000340830,
    // Se84
    1000340840,
    // Se85
    1000340850,
    // Se86
    1000340860,
    // Se87
    1000340870,
    // Se88
    1000340880,
    // Se89
    1000340890,
    // Se90
    1000340900,
    // Se91
    1000340910,
    // Se92
    1000340920,
    // Br67
    1000350670,
    // Br68
    1000350680,
    // Br69
    1000350690,
    // Br70
    1000350700,
    // Br71
    1000350710,
    // Br72
    1000350720,
    // Br73
    1000350730,
    // Br74
    1000350740,
    // Br75
    1000350750,
    // Br76
    1000350760,
    // Br77
    1000350770,
    // Br78
    1000350780,
    // Br79
    1000350790,
    // Br80
    1000350800,
    // Br81
    1000350810,
    // Br82
    1000350820,
    // Br83
    1000350830,
    // Br84
    1000350840,
    // Br85
    1000350850,
    // Br86
    1000350860,
    // Br87
    1000350870,
    // Br88
    1000350880,
    // Br89
    1000350890,
    // Br90
    1000350900,
    // Br91
    1000350910,
    // Br92
    1000350920,
    // Br93
    1000350930,
    // Br94
    1000350940,
    // Kr69
    1000360690,
    // Kr70
    1000360700,
    // Kr71
    1000360710,
    // Kr72
    1000360720,
    // Kr73
    1000360730,
    // Kr74
    1000360740,
    // Kr75
    1000360750,
    // Kr76
    1000360760,
    // Kr77
    1000360770,
    // Kr78
    1000360780,
    // Kr79
    1000360790,
    // Kr80
    1000360800,
    // Kr81
    1000360810,
    // Kr82
    1000360820,
    // Kr83
    1000360830,
    // Kr84
    1000360840,
    // Kr85
    1000360850,
    // Kr86
    1000360860,
    // Kr87
    1000360870,
    // Kr88
    1000360880,
    // Kr89
    1000360890,
    // Kr90
    1000360900,
    // Kr91
    1000360910,
    // Kr92
    1000360920,
    // Kr93
    1000360930,
    // Kr94
    1000360940,
    // Kr95
    1000360950,
    // Kr96
    1000360960,
    // Kr97
    1000360970,
    // Rb71
    1000370710,
    // Rb72
    1000370720,
    // Rb73
    1000370730,
    // Rb74
    1000370740,
    // Rb75
    1000370750,
    // Rb76
    1000370760,
    // Rb77
    1000370770,
    // Rb78
    1000370780,
    // Rb79
    1000370790,
    // Rb80
    1000370800,
    // Rb81
    1000370810,
    // Rb82
    1000370820,
    // Rb83
    1000370830,
    // Rb84
    1000370840,
    // Rb85
    1000370850,
    // Rb86
    1000370860,
    // Rb87
    1000370870,
    // Rb88
    1000370880,
    // Rb89
    1000370890,
    // Rb90
    1000370900,
    // Rb91
    1000370910,
    // Rb92
    1000370920,
    // Rb93
    1000370930,
    // Rb94
    1000370940,
    // Rb95
    1000370950,
    // Rb96
    1000370960,
    // Rb97
    1000370970,
    // Rb98
    1000370980,
    // Rb99
    1000370990,
    // Rb100
    1000371000,
    // Rb101
    1000371010,
    // Rb102
    1000371020,
    // Sr73
    1000380730,
    // Sr74
    1000380740,
    // Sr75
    1000380750,
    // Sr76
    1000380760,
    // Sr77
    1000380770,
    // Sr78
    1000380780,
    // Sr79
    1000380790,
    // Sr80
    1000380800,
    // Sr81
    1000380810,
    // Sr82
    1000380820,
    // Sr83
    1000380830,
    // Sr84
    1000380840,
    // Sr85
    1000380850,
    // Sr86
    1000380860,
    // Sr87
    1000380870,
    // Sr88
    1000380880,
    // Sr89
    1000380890,
    // Sr90
    1000380900,
    // Sr91
    1000380910,
    // Sr92
    1000380920,
    // Sr93
    1000380930,
    // Sr94
    1000380940,
    // Sr95
    1000380950,
    // Sr96
    1000380960,
    // Sr97
    1000380970,
    // Sr98
    1000380980,
    // Sr99
    1000380990,
    // Sr100
    1000381000,
    // Sr101
    1000381010,
    // Sr102
    1000381020,
    // Sr103
    1000381030,
    // Sr104
    1000381040,
    // Y77
    1000390770,
    // Y78
    1000390780,
    // Y79
    1000390790,
    // Y80
    1000390800,
    // Y81
    1000390810,
    // Y82
    1000390820,
    // Y83
    1000390830,
    // Y84
    1000390840,
    // Y85
    1000390850,
    // Y86
    1000390860,
    // Y87
    1000390870,
    // Y88
    1000390880,
    // Y89
    1000390890,
    // Y90
    1000390900,
    // Y91
    1000390910,
    // Y92
    1000390920,
    // Y93
    1000390930,
    // Y94
    1000390940,
    // Y95
    1000390950,
    // Y96
    1000390960,
    // Y97
    1000390970,
    // Y98
    1000390980,
    // Y99
    1000390990,
    // Y100
    1000391000,
    // Y101
    1000391010,
    // Y102
    1000391020,
    // Y103
    1000391030,
    // Y104
    1000391040,
    // Y105
    1000391050,
    // Y106
    1000391060,
    // Zr79
    1000400790,
    // Zr80
    1000400800,
    // Zr81
    1000400810,
    // Zr82
    1000400820,
    // Zr83
    1000400830,
    // Zr84
    1000400840,
    // Zr85
    1000400850,
    // Zr86
    1000400860,
    // Zr87
    1000400870,
    // Zr88
    1000400880,
    // Zr89
    1000400890,
    // Zr90
    1000400900,
    // Zr91
    1000400910,
    // Zr92
    1000400920,
    // Zr93
    1000400930,
    // Zr94
    1000400940,
    // Zr95
    1000400950,
    // Zr96
    1000400960,
    // Zr97
    1000400970,
    // Zr98
    1000400980,
    // Zr99
    1000400990,
    // Zr100
    1000401000,
    // Zr101
    1000401010,
    // Zr102
    1000401020,
    // Zr103
    1000401030,
    // Zr104
    1000401040,
    // Zr105
    1000401050,
    // Zr106
    1000401060,
    // Zr107
    1000401070,
    // Zr108
    1000401080,
    // Nb81
    1000410810,
    // Nb82
    1000410820,
    // Nb83
    1000410830,
    // Nb84
    1000410840,
    // Nb85
    1000410850,
    // Nb86
    1000410860,
    // Nb87
    1000410870,
    // Nb88
    1000410880,
    // Nb89
    1000410890,
    // Nb90
    1000410900,
    // Nb91
    1000410910,
    // Nb92
    1000410920,
    // Nb93
    1000410930,
    // Nb94
    1000410940,
    // Nb95
    1000410950,
    // Nb96
    1000410960,
    // Nb97
    1000410970,
    // Nb98
    1000410980,
    // Nb99
    1000410990,
    // Nb100
    1000411000,
    // Nb101
    1000411010,
    // Nb102
    1000411020,
    // Nb103
    1000411030,
    // Nb104
    1000411040,
    // Nb105
    1000411050,
    // Nb106
    1000411060,
    // Nb107
    1000411070,
    // Nb108
    1000411080,
    // Nb109
    1000411090,
    // Nb110
    1000411100,
    // Mo83
    1000420830,
    // Mo84
    1000420840,
    // Mo85
    1000420850,
    // Mo86
    1000420860,
    // Mo87
    1000420870,
    // Mo88
    1000420880,
    // Mo89
    1000420890,
    // Mo90
    1000420900,
    // Mo91
    1000420910,
    // Mo92
    1000420920,
    // Mo93
    1000420930,
    // Mo94
    1000420940,
    // Mo95
    1000420950,
    // Mo96
    1000420960,
    // Mo97
    1000420970,
    // Mo98
    1000420980,
    // Mo99
    1000420990,
    // Mo100
    1000421000,
    // Mo101
    1000421010,
    // Mo102
    1000421020,
    // Mo103
    1000421030,
    // Mo104
    1000421040,
    // Mo105
    1000421050,
    // Mo106
    1000421060,
    // Mo107
    1000421070,
    // Mo108
    1000421080,
    // Mo109
    1000421090,
    // Mo110
    1000421100,
    // Mo111
    1000421110,
    // Mo112
    1000421120,
    // Mo113
    1000421130,
    // Tc85
    1000430850,
    // Tc86
    1000430860,
    // Tc87
    1000430870,
    // Tc88
    1000430880,
    // Tc89
    1000430890,
    // Tc90
    1000430900,
    // Tc91
    1000430910,
    // Tc92
    1000430920,
    // Tc93
    1000430930,
    // Tc94
    1000430940,
    // Tc95
    1000430950,
    // Tc96
    1000430960,
    // Tc97
    1000430970,
    // Tc98
    1000430980,
    // Tc99
    1000430990,
    // Tc100
    1000431000,
    // Tc101
    1000431010,
    // Tc102
    1000431020,
    // Tc103
    1000431030,
    // Tc104
    1000431040,
    // Tc105
    1000431050,
    // Tc106
    1000431060,
    // Tc107
    1000431070,
    // Tc108
    1000431080,
    // Tc109
    1000431090,
    // Tc110
    1000431100,
    // Tc111
    1000431110,
    // Tc112
    1000431120,
    // Tc113
    1000431130,
    // Tc114
    1000431140,
    // Tc115
    1000431150,
    // Ru87
    1000440870,
    // Ru88
    1000440880,
    // Ru89
    1000440890,
    // Ru90
    1000440900,
    // Ru91
    1000440910,
    // Ru92
    1000440920,
    // Ru93
    1000440930,
    // Ru94
    1000440940,
    // Ru95
    1000440950,
    // Ru96
    1000440960,
    // Ru97
    1000440970,
    // Ru98
    1000440980,
    // Ru99
    1000440990,
    // Ru100
    1000441000,
    // Ru101
    1000441010,
    // Ru102
    1000441020,
    // Ru103
    1000441030,
    // Ru104
    1000441040,
    // Ru105
    1000441050,
    // Ru106
    1000441060,
    // Ru107
    1000441070,
    // Ru108
    1000441080,
    // Ru109
    1000441090,
    // Ru110
    1000441100,
    // Ru111
    1000441110,
    // Ru112
    1000441120,
    // Ru113
    1000441130,
    // Ru114
    1000441140,
    // Ru115
    1000441150,
    // Ru116
    1000441160,
    // Ru117
    1000441170,
    // Ru118
    1000441180,
    // Rh89
    1000450890,
    // Rh90
    1000450900,
    // Rh91
    1000450910,
    // Rh92
    1000450920,
    // Rh93
    1000450930,
    // Rh94
    1000450940,
    // Rh95
    1000450950,
    // Rh96
    1000450960,
    // Rh97
    1000450970,
    // Rh98
    1000450980,
    // Rh99
    1000450990,
    // Rh100
    1000451000,
    // Rh101
    1000451010,
    // Rh102
    1000451020,
    // Rh103
    1000451030,
    // Rh104
    1000451040,
    // Rh105
    1000451050,
    // Rh106
    1000451060,
    // Rh107
    1000451070,
    // Rh108
    1000451080,
    // Rh109
    1000451090,
    // Rh110
    1000451100,
    // Rh111
    1000451110,
    // Rh112
    1000451120,
    // Rh113
    1000451130,
    // Rh114
    1000451140,
    // Rh115
    1000451150,
    // Rh116
    1000451160,
    // Rh117
    1000451170,
    // Rh118
    1000451180,
    // Rh119
    1000451190,
    // Rh120
    1000451200,
    // Rh121
    1000451210,
    // Pd91
    1000460910,
    // Pd92
    1000460920,
    // Pd93
    1000460930,
    // Pd94
    1000460940,
    // Pd95
    1000460950,
    // Pd96
    1000460960,
    // Pd97
    1000460970,
    // Pd98
    1000460980,
    // Pd99
    1000460990,
    // Pd100
    1000461000,
    // Pd101
    1000461010,
    // Pd102
    1000461020,
    // Pd103
    1000461030,
    // Pd104
    1000461040,
    // Pd105
    1000461050,
    // Pd106
    1000461060,
    // Pd107
    1000461070,
    // Pd108
    1000461080,
    // Pd109
    1000461090,
    // Pd110
    1000461100,
    // Pd111
    1000461110,
    // Pd112
    1000461120,
    // Pd113
    1000461130,
    // Pd114
    1000461140,
    // Pd115
    1000461150,
    // Pd116
    1000461160,
    // Pd117
    1000461170,
    // Pd118
    1000461180,
    // Pd119
    1000461190,
    // Pd120
    1000461200,
    // Pd121
    1000461210,
    // Pd122
    1000461220,
    // Pd123
    1000461230,
    // Ag94
    1000470940,
    // Ag95
    1000470950,
    // Ag96
    1000470960,
    // Ag97
    1000470970,
    // Ag98
    1000470980,
    // Ag99
    1000470990,
    // Ag100
    1000471000,
    // Ag101
    1000471010,
    // Ag102
    1000471020,
    // Ag103
    1000471030,
    // Ag104
    1000471040,
    // Ag105
    1000471050,
    // Ag106
    1000471060,
    // Ag107
    1000471070,
    // Ag108
    1000471080,
    // Ag109
    1000471090,
    // Ag110
    1000471100,
    // Ag111
    1000471110,
    // Ag112
    1000471120,
    // Ag113
    1000471130,
    // Ag114
    1000471140,
    // Ag115
    1000471150,
    // Ag116
    1000471160,
    // Ag117
    1000471170,
    // Ag118
    1000471180,
    // Ag119
    1000471190,
    // Ag120
    1000471200,
    // Ag121
    1000471210,
    // Ag122
    1000471220,
    // Ag123
    1000471230,
    // Ag124
    1000471240,
    // Ag125
    1000471250,
    // Ag126
    1000471260,
    // Ag127
    1000471270,
    // Cd96
    1000480960,
    // Cd97
    1000480970,
    // Cd98
    1000480980,
    // Cd99
    1000480990,
    // Cd100
    1000481000,
    // Cd101
    1000481010,
    // Cd102
    1000481020,
    // Cd103
    1000481030,
    // Cd104
    1000481040,
    // Cd105
    1000481050,
    // Cd106
    1000481060,
    // Cd107
    1000481070,
    // Cd108
    1000481080,
    // Cd109
    1000481090,
    // Cd110
    1000481100,
    // Cd111
    1000481110,
    // Cd112
    1000481120,
    // Cd113
    1000481130,
    // Cd114
    1000481140,
    // Cd115
    1000481150,
    // Cd116
    1000481160,
    // Cd117
    1000481170,
    // Cd118
    1000481180,
    // Cd119
    1000481190,
    // Cd120
    1000481200,
    // Cd121
    1000481210,
    // Cd122
    1000481220,
    // Cd123
    1000481230,
    // Cd124
    1000481240,
    // Cd125
    1000481250,
    // Cd126
    1000481260,
    // Cd127
    1000481270,
    // Cd128
    1000481280,
    // Cd129
    1000481290,
    // Cd130
    1000481300,
    // In98
    1000490980,
    // In99
    1000490990,
    // In100
    1000491000,
    // In101
    1000491010,
    // In102
    1000491020,
    // In103
    1000491030,
    // In104
    1000491040,
    // In105
    1000491050,
    // In106
    1000491060,
    // In107
    1000491070,
    // In108
    1000491080,
    // In109
    1000491090,
    // In110
    1000491100,
    // In111
    1000491110,
    // In112
    1000491120,
    // In113
    1000491130,
    // In114
    1000491140,
    // In115
    1000491150,
    // In116
    1000491160,
    // In117
    1000491170,
    // In118
    1000491180,
    // In119
    1000491190,
    // In120
    1000491200,
    // In121
    1000491210,
    // In122
    1000491220,
    // In123
    1000491230,
    // In124
    1000491240,
    // In125
    1000491250,
    // In126
    1000491260,
    // In127
    1000491270,
    // In128
    1000491280,
    // In129
    1000491290,
    // In130
    1000491300,
    // In131
    1000491310,
    // In132
    1000491320,
    // In133
    1000491330,
    // In134
    1000491340,
    // Sn100
    1000501000,
    // Sn101
    1000501010,
    // Sn102
    1000501020,
    // Sn103
    1000501030,
    // Sn104
    1000501040,
    // Sn105
    1000501050,
    // Sn106
    1000501060,
    // Sn107
    1000501070,
    // Sn108
    1000501080,
    // Sn109
    1000501090,
    // Sn110
    1000501100,
    // Sn111
    1000501110,
    // Sn112
    1000501120,
    // Sn113
    1000501130,
    // Sn114
    1000501140,
    // Sn115
    1000501150,
    // Sn116
    1000501160,
    // Sn117
    1000501170,
    // Sn118
    1000501180,
    // Sn119
    1000501190,
    // Sn120
    1000501200,
    // Sn121
    1000501210,
    // Sn122
    1000501220,
    // Sn123
    1000501230,
    // Sn124
    1000501240,
    // Sn125
    1000501250,
    // Sn126
    1000501260,
    // Sn127
    1000501270,
    // Sn128
    1000501280,
    // Sn129
    1000501290,
    // Sn130
    1000501300,
    // Sn131
    1000501310,
    // Sn132
    1000501320,
    // Sn133
    1000501330,
    // Sn134
    1000501340,
    // Sn135
    1000501350,
    // Sn136
    1000501360,
    // Sn137
    1000501370,
    // Sb103
    1000511030,
    // Sb104
    1000511040,
    // Sb105
    1000511050,
    // Sb106
    1000511060,
    // Sb107
    1000511070,
    // Sb108
    1000511080,
    // Sb109
    1000511090,
    // Sb110
    1000511100,
    // Sb111
    1000511110,
    // Sb112
    1000511120,
    // Sb113
    1000511130,
    // Sb114
    1000511140,
    // Sb115
    1000511150,
    // Sb116
    1000511160,
    // Sb117
    1000511170,
    // Sb118
    1000511180,
    // Sb119
    1000511190,
    // Sb120
    1000511200,
    // Sb121
    1000511210,
    // Sb122
    1000511220,
    // Sb123
    1000511230,
    // Sb124
    1000511240,
    // Sb125
    1000511250,
    // Sb126
    1000511260,
    // Sb127
    1000511270,
    // Sb128
    1000511280,
    // Sb129
    1000511290,
    // Sb130
    1000511300,
    // Sb131
    1000511310,
    // Sb132
    1000511320,
    // Sb133
    1000511330,
    // Sb134
    1000511340,
    // Sb135
    1000511350,
    // Sb136
    1000511360,
    // Sb137
    1000511370,
    // Sb138
    1000511380,
    // Sb139
    1000511390,
    // Te106
    1000521060,
    // Te107
    1000521070,
    // Te108
    1000521080,
    // Te109
    1000521090,
    // Te110
    1000521100,
    // Te111
    1000521110,
    // Te112
    1000521120,
    // Te113
    1000521130,
    // Te114
    1000521140,
    // Te115
    1000521150,
    // Te116
    1000521160,
    // Te117
    1000521170,
    // Te118
    1000521180,
    // Te119
    1000521190,
    // Te120
    1000521200,
    // Te121
    1000521210,
    // Te122
    1000521220,
    // Te123
    1000521230,
    // Te124
    1000521240,
    // Te125
    1000521250,
    // Te126
    1000521260,
    // Te127
    1000521270,
    // Te128
    1000521280,
    // Te129
    1000521290,
    // Te130
    1000521300,
    // Te131
    1000521310,
    // Te132
    1000521320,
    // Te133
    1000521330,
    // Te134
    1000521340,
    // Te135
    1000521350,
    // Te136
    1000521360,
    // Te137
    1000521370,
    // Te138
    1000521380,
    // Te139
    1000521390,
    // Te140
    1000521400,
    // Te141
    1000521410,
    // Te142
    1000521420,
    // I108
    1000531080,
    // I109
    1000531090,
    // I110
    1000531100,
    // I111
    1000531110,
    // I112
    1000531120,
    // I113
    1000531130,
    // I114
    1000531140,
    // I115
    1000531150,
    // I116
    1000531160,
    // I117
    1000531170,
    // I118
    1000531180,
    // I119
    1000531190,
    // I120
    1000531200,
    // I121
    1000531210,
    // I122
    1000531220,
    // I123
    1000531230,
    // I124
    1000531240,
    // I125
    1000531250,
    // I126
    1000531260,
    // I127
    1000531270,
    // I128
    1000531280,
    // I129
    1000531290,
    // I130
    1000531300,
    // I131
    1000531310,
    // I132
    1000531320,
    // I133
    1000531330,
    // I134
    1000531340,
    // I135
    1000531350,
    // I136
    1000531360,
    // I137
    1000531370,
    // I138
    1000531380,
    // I139
    1000531390,
    // I140
    1000531400,
    // I141
    1000531410,
    // I142
    1000531420,
    // I143
    1000531430,
    // I144
    1000531440,
    // Xe110
    1000541100,
    // Xe111
    1000541110,
    // Xe112
    1000541120,
    // Xe113
    1000541130,
    // Xe114
    1000541140,
    // Xe115
    1000541150,
    // Xe116
    1000541160,
    // Xe117
    1000541170,
    // Xe118
    1000541180,
    // Xe119
    1000541190,
    // Xe120
    1000541200,
    // Xe121
    1000541210,
    // Xe122
    1000541220,
    // Xe123
    1000541230,
    // Xe124
    1000541240,
    // Xe125
    1000541250,
    // Xe126
    1000541260,
    // Xe127
    1000541270,
    // Xe128
    1000541280,
    // Xe129
    1000541290,
    // Xe130
    1000541300,
    // Xe131
    1000541310,
    // Xe132
    1000541320,
    // Xe133
    1000541330,
    // Xe134
    1000541340,
    // Xe135
    1000541350,
    // Xe136
    1000541360,
    // Xe137
    1000541370,
    // Xe138
    1000541380,
    // Xe139
    1000541390,
    // Xe140
    1000541400,
    // Xe141
    1000541410,
    // Xe142
    1000541420,
    // Xe143
    1000541430,
    // Xe144
    1000541440,
    // Xe145
    1000541450,
    // Xe146
    1000541460,
    // Xe147
    1000541470,
    // Cs112
    1000551120,
    // Cs113
    1000551130,
    // Cs114
    1000551140,
    // Cs115
    1000551150,
    // Cs116
    1000551160,
    // Cs117
    1000551170,
    // Cs118
    1000551180,
    // Cs119
    1000551190,
    // Cs120
    1000551200,
    // Cs121
    1000551210,
    // Cs122
    1000551220,
    // Cs123
    1000551230,
    // Cs124
    1000551240,
    // Cs125
    1000551250,
    // Cs126
    1000551260,
    // Cs127
    1000551270,
    // Cs128
    1000551280,
    // Cs129
    1000551290,
    // Cs130
    1000551300,
    // Cs131
    1000551310,
    // Cs132
    1000551320,
    // Cs133
    1000551330,
    // Cs134
    1000551340,
    // Cs135
    1000551350,
    // Cs136
    1000551360,
    // Cs137
    1000551370,
    // Cs138
    1000551380,
    // Cs139
    1000551390,
    // Cs140
    1000551400,
    // Cs141
    1000551410,
    // Cs142
    1000551420,
    // Cs143
    1000551430,
    // Cs144
    1000551440,
    // Cs145
    1000551450,
    // Cs146
    1000551460,
    // Cs147
    1000551470,
    // Cs148
    1000551480,
    // Cs149
    1000551490,
    // Cs150
    1000551500,
    // Cs151
    1000551510,
    // Ba114
    1000561140,
    // Ba115
    1000561150,
    // Ba116
    1000561160,
    // Ba117
    1000561170,
    // Ba118
    1000561180,
    // Ba119
    1000561190,
    // Ba120
    1000561200,
    // Ba121
    1000561210,
    // Ba122
    1000561220,
    // Ba123
    1000561230,
    // Ba124
    1000561240,
    // Ba125
    1000561250,
    // Ba126
    1000561260,
    // Ba127
    1000561270,
    // Ba128
    1000561280,
    // Ba129
    1000561290,
    // Ba130
    1000561300,
    // Ba131
    1000561310,
    // Ba132
    1000561320,
    // Ba133
    1000561330,
    // Ba134
    1000561340,
    // Ba135
    1000561350,
    // Ba136
    1000561360,
    // Ba137
    1000561370,
    // Ba138
    1000561380,
    // Ba139
    1000561390,
    // Ba140
    1000561400,
    // Ba141
    1000561410,
    // Ba142
    1000561420,
    // Ba143
    1000561430,
    // Ba144
    1000561440,
    // Ba145
    1000561450,
    // Ba146
    1000561460,
    // Ba147
    1000561470,
    // Ba148
    1000561480,
    // Ba149
    1000561490,
    // Ba150
    1000561500,
    // Ba151
    1000561510,
    // Ba152
    1000561520,
    // Ba153
    1000561530,
    // La117
    1000571170,
    // La118
    1000571180,
    // La119
    1000571190,
    // La120
    1000571200,
    // La121
    1000571210,
    // La122
    1000571220,
    // La123
    1000571230,
    // La124
    1000571240,
    // La125
    1000571250,
    // La126
    1000571260,
    // La127
    1000571270,
    // La128
    1000571280,
    // La129
    1000571290,
    // La130
    1000571300,
    // La131
    1000571310,
    // La132
    1000571320,
    // La133
    1000571330,
    // La134
    1000571340,
    // La135
    1000571350,
    // La136
    1000571360,
    // La137
    1000571370,
    // La138
    1000571380,
    // La139
    1000571390,
    // La140
    1000571400,
    // La141
    1000571410,
    // La142
    1000571420,
    // La143
    1000571430,
    // La144
    1000571440,
    // La145
    1000571450,
    // La146
    1000571460,
    // La147
    1000571470,
    // La148
    1000571480,
    // La149
    1000571490,
    // La150
    1000571500,
    // La151
    1000571510,
    // La152
    1000571520,
    // La153
    1000571530,
    // La154
    1000571540,
    // La155
    1000571550,
    // Ce119
    1000581190,
    // Ce120
    1000581200,
    // Ce121
    1000581210,
    // Ce122
    1000581220,
    // Ce123
    1000581230,
    // Ce124
    1000581240,
    // Ce125
    1000581250,
    // Ce126
    1000581260,
    // Ce127
    1000581270,
    // Ce128
    1000581280,
    // Ce129
    1000581290,
    // Ce130
    1000581300,
    // Ce131
    1000581310,
    // Ce132
    1000581320,
    // Ce133
    1000581330,
    // Ce134
    1000581340,
    // Ce135
    1000581350,
    // Ce136
    1000581360,
    // Ce137
    1000581370,
    // Ce138
    1000581380,
    // Ce139
    1000581390,
    // Ce140
    1000581400,
    // Ce141
    1000581410,
    // Ce142
    1000581420,
    // Ce143
    1000581430,
    // Ce144
    1000581440,
    // Ce145
    1000581450,
    // Ce146
    1000581460,
    // Ce147
    1000581470,
    // Ce148
    1000581480,
    // Ce149
    1000581490,
    // Ce150
    1000581500,
    // Ce151
    1000581510,
    // Ce152
    1000581520,
    // Ce153
    1000581530,
    // Ce154
    1000581540,
    // Ce155
    1000581550,
    // Ce156
    1000581560,
    // Ce157
    1000581570,
    // Pr121
    1000591210,
    // Pr122
    1000591220,
    // Pr123
    1000591230,
    // Pr124
    1000591240,
    // Pr125
    1000591250,
    // Pr126
    1000591260,
    // Pr127
    1000591270,
    // Pr128
    1000591280,
    // Pr129
    1000591290,
    // Pr130
    1000591300,
    // Pr131
    1000591310,
    // Pr132
    1000591320,
    // Pr133
    1000591330,
    // Pr134
    1000591340,
    // Pr135
    1000591350,
    // Pr136
    1000591360,
    // Pr137
    1000591370,
    // Pr138
    1000591380,
    // Pr139
    1000591390,
    // Pr140
    1000591400,
    // Pr141
    1000591410,
    // Pr142
    1000591420,
    // Pr143
    1000591430,
    // Pr144
    1000591440,
    // Pr145
    1000591450,
    // Pr146
    1000591460,
    // Pr147
    1000591470,
    // Pr148
    1000591480,
    // Pr149
    1000591490,
    // Pr150
    1000591500,
    // Pr151
    1000591510,
    // Pr152
    1000591520,
    // Pr153
    1000591530,
    // Pr154
    1000591540,
    // Pr155
    1000591550,
    // Pr156
    1000591560,
    // Pr157
    1000591570,
    // Pr158
    1000591580,
    // Pr159
    1000591590,
    // Nd126
    1000601260,
    // Nd127
    1000601270,
    // Nd128
    1000601280,
    // Nd129
    1000601290,
    // Nd130
    1000601300,
    // Nd131
    1000601310,
    // Nd132
    1000601320,
    // Nd133
    1000601330,
    // Nd134
    1000601340,
    // Nd135
    1000601350,
    // Nd136
    1000601360,
    // Nd137
    1000601370,
    // Nd138
    1000601380,
    // Nd139
    1000601390,
    // Nd140
    1000601400,
    // Nd141
    1000601410,
    // Nd142
    1000601420,
    // Nd143
    1000601430,
    // Nd144
    1000601440,
    // Nd145
    1000601450,
    // Nd146
    1000601460,
    // Nd147
    1000601470,
    // Nd148
    1000601480,
    // Nd149
    1000601490,
    // Nd150
    1000601500,
    // Nd151
    1000601510,
    // Nd152
    1000601520,
    // Nd153
    1000601530,
    // Nd154
    1000601540,
    // Nd155
    1000601550,
    // Nd156
    1000601560,
    // Nd157
    1000601570,
    // Nd158
    1000601580,
    // Nd159
    1000601590,
    // Nd160
    1000601600,
    // Nd161
    1000601610,
    // Pm128
    1000611280,
    // Pm129
    1000611290,
    // Pm130
    1000611300,
    // Pm131
    1000611310,
    // Pm132
    1000611320,
    // Pm133
    1000611330,
    // Pm134
    1000611340,
    // Pm135
    1000611350,
    // Pm136
    1000611360,
    // Pm137
    1000611370,
    // Pm138
    1000611380,
    // Pm139
    1000611390,
    // Pm140
    1000611400,
    // Pm141
    1000611410,
    // Pm142
    1000611420,
    // Pm143
    1000611430,
    // Pm144
    1000611440,
    // Pm145
    1000611450,
    // Pm146
    1000611460,
    // Pm147
    1000611470,
    // Pm148
    1000611480,
    // Pm149
    1000611490,
    // Pm150
    1000611500,
    // Pm151
    1000611510,
    // Pm152
    1000611520,
    // Pm153
    1000611530,
    // Pm154
    1000611540,
    // Pm155
    1000611550,
    // Pm156
    1000611560,
    // Pm157
    1000611570,
    // Pm158
    1000611580,
    // Pm159
    1000611590,
    // Pm160
    1000611600,
    // Pm161
    1000611610,
    // Pm162
    1000611620,
    // Pm163
    1000611630,
    // Sm130
    1000621300,
    // Sm131
    1000621310,
    // Sm132
    1000621320,
    // Sm133
    1000621330,
    // Sm134
    1000621340,
    // Sm135
    1000621350,
    // Sm136
    1000621360,
    // Sm137
    1000621370,
    // Sm138
    1000621380,
    // Sm139
    1000621390,
    // Sm140
    1000621400,
    // Sm141
    1000621410,
    // Sm142
    1000621420,
    // Sm143
    1000621430,
    // Sm144
    1000621440,
    // Sm145
    1000621450,
    // Sm146
    1000621460,
    // Sm147
    1000621470,
    // Sm148
    1000621480,
    // Sm149
    1000621490,
    // Sm150
    1000621500,
    // Sm151
    1000621510,
    // Sm152
    1000621520,
    // Sm153
    1000621530,
    // Sm154
    1000621540,
    // Sm155
    1000621550,
    // Sm156
    1000621560,
    // Sm157
    1000621570,
    // Sm158
    1000621580,
    // Sm159
    1000621590,
    // Sm160
    1000621600,
    // Sm161
    1000621610,
    // Sm162
    1000621620,
    // Sm163
    1000621630,
    // Sm164
    1000621640,
    // Sm165
    1000621650,
    // Eu132
    1000631320,
    // Eu133
    1000631330,
    // Eu134
    1000631340,
    // Eu135
    1000631350,
    // Eu136
    1000631360,
    // Eu137
    1000631370,
    // Eu138
    1000631380,
    // Eu139
    1000631390,
    // Eu140
    1000631400,
    // Eu141
    1000631410,
    // Eu142
    1000631420,
    // Eu143
    1000631430,
    // Eu144
    1000631440,
    // Eu145
    1000631450,
    // Eu146
    1000631460,
    // Eu147
    1000631470,
    // Eu148
    1000631480,
    // Eu149
    1000631490,
    // Eu150
    1000631500,
    // Eu151
    1000631510,
    // Eu152
    1000631520,
    // Eu153
    1000631530,
    // Eu154
    1000631540,
    // Eu155
    1000631550,
    // Eu156
    1000631560,
    // Eu157
    1000631570,
    // Eu158
    1000631580,
    // Eu159
    1000631590,
    // Eu160
    1000631600,
    // Eu161
    1000631610,
    // Eu162
    1000631620,
    // Eu163
    1000631630,
    // Eu164
    1000631640,
    // Eu165
    1000631650,
    // Eu166
    1000631660,
    // Eu167
    1000631670,
    // Gd136
    1000641360,
    // Gd137
    1000641370,
    // Gd138
    1000641380,
    // Gd139
    1000641390,
    // Gd140
    1000641400,
    // Gd141
    1000641410,
    // Gd142
    1000641420,
    // Gd143
    1000641430,
    // Gd144
    1000641440,
    // Gd145
    1000641450,
    // Gd146
    1000641460,
    // Gd147
    1000641470,
    // Gd148
    1000641480,
    // Gd149
    1000641490,
    // Gd150
    1000641500,
    // Gd151
    1000641510,
    // Gd152
    1000641520,
    // Gd153
    1000641530,
    // Gd154
    1000641540,
    // Gd155
    1000641550,
    // Gd156
    1000641560,
    // Gd157
    1000641570,
    // Gd158
    1000641580,
    // Gd159
    1000641590,
    // Gd160
    1000641600,
    // Gd161
    1000641610,
    // Gd162
    1000641620,
    // Gd163
    1000641630,
    // Gd164
    1000641640,
    // Gd165
    1000641650,
    // Gd166
    1000641660,
    // Gd167
    1000641670,
    // Gd168
    1000641680,
    // Gd169
    1000641690,
    // Tb138
    1000651380,
    // Tb139
    1000651390,
    // Tb140
    1000651400,
    // Tb141
    1000651410,
    // Tb142
    1000651420,
    // Tb143
    1000651430,
    // Tb144
    1000651440,
    // Tb145
    1000651450,
    // Tb146
    1000651460,
    // Tb147
    1000651470,
    // Tb148
    1000651480,
    // Tb149
    1000651490,
    // Tb150
    1000651500,
    // Tb151
    1000651510,
    // Tb152
    1000651520,
    // Tb153
    1000651530,
    // Tb154
    1000651540,
    // Tb155
    1000651550,
    // Tb156
    1000651560,
    // Tb157
    1000651570,
    // Tb158
    1000651580,
    // Tb159
    1000651590,
    // Tb160
    1000651600,
    // Tb161
    1000651610,
    // Tb162
    1000651620,
    // Tb163
    1000651630,
    // Tb164
    1000651640,
    // Tb165
    1000651650,
    // Tb166
    1000651660,
    // Tb167
    1000651670,
    // Tb168
    1000651680,
    // Tb169
    1000651690,
    // Tb170
    1000651700,
    // Tb171
    1000651710,
    // Dy140
    1000661400,
    // Dy141
    1000661410,
    // Dy142
    1000661420,
    // Dy143
    1000661430,
    // Dy144
    1000661440,
    // Dy145
    1000661450,
    // Dy146
    1000661460,
    // Dy147
    1000661470,
    // Dy148
    1000661480,
    // Dy149
    1000661490,
    // Dy150
    1000661500,
    // Dy151
    1000661510,
    // Dy152
    1000661520,
    // Dy153
    1000661530,
    // Dy154
    1000661540,
    // Dy155
    1000661550,
    // Dy156
    1000661560,
    // Dy157
    1000661570,
    // Dy158
    1000661580,
    // Dy159
    1000661590,
    // Dy160
    1000661600,
    // Dy161
    1000661610,
    // Dy162
    1000661620,
    // Dy163
    1000661630,
    // Dy164
    1000661640,
    // Dy165
    1000661650,
    // Dy166
    1000661660,
    // Dy167
    1000661670,
    // Dy168
    1000661680,
    // Dy169
    1000661690,
    // Dy170
    1000661700,
    // Dy171
    1000661710,
    // Dy172
    1000661720,
    // Dy173
    1000661730,
    // Ho142
    1000671420,
    // Ho143
    1000671430,
    // Ho144
    1000671440,
    // Ho145
    1000671450,
    // Ho146
    1000671460,
    // Ho147
    1000671470,
    // Ho148
    1000671480,
    // Ho149
    1000671490,
    // Ho150
    1000671500,
    // Ho151
    1000671510,
    // Ho152
    1000671520,
    // Ho153
    1000671530,
    // Ho154
    1000671540,
    // Ho155
    1000671550,
    // Ho156
    1000671560,
    // Ho157
    1000671570,
    // Ho158
    1000671580,
    // Ho159
    1000671590,
    // Ho160
    1000671600,
    // Ho161
    1000671610,
    // Ho162
    1000671620,
    // Ho163
    1000671630,
    // Ho164
    1000671640,
    // Ho165
    1000671650,
    // Ho166
    1000671660,
    // Ho167
    1000671670,
    // Ho168
    1000671680,
    // Ho169
    1000671690,
    // Ho170
    1000671700,
    // Ho171
    1000671710,
    // Ho172
    1000671720,
    // Ho173
    1000671730,
    // Ho174
    1000671740,
    // Ho175
    1000671750,
    // Er144
    1000681440,
    // Er145
    1000681450,
    // Er146
    1000681460,
    // Er147
    1000681470,
    // Er148
    1000681480,
    // Er149
    1000681490,
    // Er150
    1000681500,
    // Er151
    1000681510,
    // Er152
    1000681520,
    // Er153
    1000681530,
    // Er154
    1000681540,
    // Er155
    1000681550,
    // Er156
    1000681560,
    // Er157
    1000681570,
    // Er158
    1000681580,
    // Er159
    1000681590,
    // Er160
    1000681600,
    // Er161
    1000681610,
    // Er162
    1000681620,
    // Er163
    1000681630,
    // Er164
    1000681640,
    // Er165
    1000681650,
    // Er166
    1000681660,
    // Er167
    1000681670,
    // Er168
    1000681680,
    // Er169
    1000681690,
    // Er170
    1000681700,
    // Er171
    1000681710,
    // Er172
    1000681720,
    // Er173
    1000681730,
    // Er174
    1000681740,
    // Er175
    1000681750,
    // Er176
    1000681760,
    // Er177
    1000681770,
    // Tm146
    1000691460,
    // Tm147
    1000691470,
    // Tm148
    1000691480,
    // Tm149
    1000691490,
    // Tm150
    1000691500,
    // Tm151
    1000691510,
    // Tm152
    1000691520,
    // Tm153
    1000691530,
    // Tm154
    1000691540,
    // Tm155
    1000691550,
    // Tm156
    1000691560,
    // Tm157
    1000691570,
    // Tm158
    1000691580,
    // Tm159
    1000691590,
    // Tm160
    1000691600,
    // Tm161
    1000691610,
    // Tm162
    1000691620,
    // Tm163
    1000691630,
    // Tm164
    1000691640,
    // Tm165
    1000691650,
    // Tm166
    1000691660,
    // Tm167
    1000691670,
    // Tm168
    1000691680,
    // Tm169
    1000691690,
    // Tm170
    1000691700,
    // Tm171
    1000691710,
    // Tm172
    1000691720,
    // Tm173
    1000691730,
    // Tm174
    1000691740,
    // Tm175
    1000691750,
    // Tm176
    1000691760,
    // Tm177
    1000691770,
    // Tm178
    1000691780,
    // Tm179
    1000691790,
    // Yb148
    1000701480,
    // Yb149
    1000701490,
    // Yb150
    1000701500,
    // Yb151
    1000701510,
    // Yb152
    1000701520,
    // Yb153
    1000701530,
    // Yb154
    1000701540,
    // Yb155
    1000701550,
    // Yb156
    1000701560,
    // Yb157
    1000701570,
    // Yb158
    1000701580,
    // Yb159
    1000701590,
    // Yb160
    1000701600,
    // Yb161
    1000701610,
    // Yb162
    1000701620,
    // Yb163
    1000701630,
    // Yb164
    1000701640,
    // Yb165
    1000701650,
    // Yb166
    1000701660,
    // Yb167
    1000701670,
    // Yb168
    1000701680,
    // Yb169
    1000701690,
    // Yb170
    1000701700,
    // Yb171
    1000701710,
    // Yb172
    1000701720,
    // Yb173
    1000701730,
    // Yb174
    1000701740,
    // Yb175
    1000701750,
    // Yb176
    1000701760,
    // Yb177
    1000701770,
    // Yb178
    1000701780,
    // Yb179
    1000701790,
    // Yb180
    1000701800,
    // Yb181
    1000701810,
    // Lu150
    1000711500,
    // Lu151
    1000711510,
    // Lu152
    1000711520,
    // Lu153
    1000711530,
    // Lu154
    1000711540,
    // Lu155
    1000711550,
    // Lu156
    1000711560,
    // Lu157
    1000711570,
    // Lu158
    1000711580,
    // Lu159
    1000711590,
    // Lu160
    1000711600,
    // Lu161
    1000711610,
    // Lu162
    1000711620,
    // Lu163
    1000711630,
    // Lu164
    1000711640,
    // Lu165
    1000711650,
    // Lu166
    1000711660,
    // Lu167
    1000711670,
    // Lu168
    1000711680,
    // Lu169
    1000711690,
    // Lu170
    1000711700,
    // Lu171
    1000711710,
    // Lu172
    1000711720,
    // Lu173
    1000711730,
    // Lu174
    1000711740,
    // Lu175
    1000711750,
    // Lu176
    1000711760,
    // Lu177
    1000711770,
    // Lu178
    1000711780,
    // Lu179
    1000711790,
    // Lu180
    1000711800,
    // Lu181
    1000711810,
    // Lu182
    1000711820,
    // Lu183
    1000711830,
    // Lu184
    1000711840,
    // Hf154
    1000721540,
    // Hf155
    1000721550,
    // Hf156
    1000721560,
    // Hf157
    1000721570,
    // Hf158
    1000721580,
    // Hf159
    1000721590,
    // Hf160
    1000721600,
    // Hf161
    1000721610,
    // Hf162
    1000721620,
    // Hf163
    1000721630,
    // Hf164
    1000721640,
    // Hf165
    1000721650,
    // Hf166
    1000721660,
    // Hf167
    1000721670,
    // Hf168
    1000721680,
    // Hf169
    1000721690,
    // Hf170
    1000721700,
    // Hf171
    1000721710,
    // Hf172
    1000721720,
    // Hf173
    1000721730,
    // Hf174
    1000721740,
    // Hf175
    1000721750,
    // Hf176
    1000721760,
    // Hf177
    1000721770,
    // Hf178
    1000721780,
    // Hf179
    1000721790,
    // Hf180
    1000721800,
    // Hf181
    1000721810,
    // Hf182
    1000721820,
    // Hf183
    1000721830,
    // Hf184
    1000721840,
    // Hf185
    1000721850,
    // Hf186
    1000721860,
    // Ta156
    1000731560,
    // Ta157
    1000731570,
    // Ta158
    1000731580,
    // Ta159
    1000731590,
    // Ta160
    1000731600,
    // Ta161
    1000731610,
    // Ta162
    1000731620,
    // Ta163
    1000731630,
    // Ta164
    1000731640,
    // Ta165
    1000731650,
    // Ta166
    1000731660,
    // Ta167
    1000731670,
    // Ta168
    1000731680,
    // Ta169
    1000731690,
    // Ta170
    1000731700,
    // Ta171
    1000731710,
    // Ta172
    1000731720,
    // Ta173
    1000731730,
    // Ta174
    1000731740,
    // Ta175
    1000731750,
    // Ta176
    1000731760,
    // Ta177
    1000731770,
    // Ta178
    1000731780,
    // Ta179
    1000731790,
    // Ta180
    1000731800,
    // Ta181
    1000731810,
    // Ta182
    1000731820,
    // Ta183
    1000731830,
    // Ta184
    1000731840,
    // Ta185
    1000731850,
    // Ta186
    1000731860,
    // Ta187
    1000731870,
    // Ta188
    1000731880,
    // W158
    1000741580,
    // W159
    1000741590,
    // W160
    1000741600,
    // W161
    1000741610,
    // W162
    1000741620,
    // W163
    1000741630,
    // W164
    1000741640,
    // W165
    1000741650,
    // W166
    1000741660,
    // W167
    1000741670,
    // W168
    1000741680,
    // W169
    1000741690,
    // W170
    1000741700,
    // W171
    1000741710,
    // W172
    1000741720,
    // W173
    1000741730,
    // W174
    1000741740,
    // W175
    1000741750,
    // W176
    1000741760,
    // W177
    1000741770,
    // W178
    1000741780,
    // W179
    1000741790,
    // W180
    1000741800,
    // W181
    1000741810,
    // W182
    1000741820,
    // W183
    1000741830,
    // W184
    1000741840,
    // W185
    1000741850,
    // W186
    1000741860,
    // W187
    1000741870,
    // W188
    1000741880,
    // W189
    1000741890,
    // W190
    1000741900,
    // Re160
    1000751600,
    // Re161
    1000751610,
    // Re162
    1000751620,
    // Re163
    1000751630,
    // Re164
    1000751640,
    // Re165
    1000751650,
    // Re166
    1000751660,
    // Re167
    1000751670,
    // Re168
    1000751680,
    // Re169
    1000751690,
    // Re170
    1000751700,
    // Re171
    1000751710,
    // Re172
    1000751720,
    // Re173
    1000751730,
    // Re174
    1000751740,
    // Re175
    1000751750,
    // Re176
    1000751760,
    // Re177
    1000751770,
    // Re178
    1000751780,
    // Re179
    1000751790,
    // Re180
    1000751800,
    // Re181
    1000751810,
    // Re182
    1000751820,
    // Re183
    1000751830,
    // Re184
    1000751840,
    // Re185
    1000751850,
    // Re186
    1000751860,
    // Re187
    1000751870,
    // Re188
    1000751880,
    // Re189
    1000751890,
    // Re190
    1000751900,
    // Re191
    1000751910,
    // Re192
    1000751920,
    // Os162
    1000761620,
    // Os163
    1000761630,
    // Os164
    1000761640,
    // Os165
    1000761650,
    // Os166
    1000761660,
    // Os167
    1000761670,
    // Os168
    1000761680,
    // Os169
    1000761690,
    // Os170
    1000761700,
    // Os171
    1000761710,
    // Os172
    1000761720,
    // Os173
    1000761730,
    // Os174
    1000761740,
    // Os175
    1000761750,
    // Os176
    1000761760,
    // Os177
    1000761770,
    // Os178
    1000761780,
    // Os179
    1000761790,
    // Os180
    1000761800,
    // Os181
    1000761810,
    // Os182
    1000761820,
    // Os183
    1000761830,
    // Os184
    1000761840,
    // Os185
    1000761850,
    // Os186
    1000761860,
    // Os187
    1000761870,
    // Os188
    1000761880,
    // Os189
    1000761890,
    // Os190
    1000761900,
    // Os191
    1000761910,
    // Os192
    1000761920,
    // Os193
    1000761930,
    // Os194
    1000761940,
    // Os195
    1000761950,
    // Os196
    1000761960,
    // Ir165
    1000771650,
    // Ir166
    1000771660,
    // Ir167
    1000771670,
    // Ir168
    1000771680,
    // Ir169
    1000771690,
    // Ir170
    1000771700,
    // Ir171
    1000771710,
    // Ir172
    1000771720,
    // Ir173
    1000771730,
    // Ir174
    1000771740,
    // Ir175
    1000771750,
    // Ir176
    1000771760,
    // Ir177
    1000771770,
    // Ir178
    1000771780,
    // Ir179
    1000771790,
    // Ir180
    1000771800,
    // Ir181
    1000771810,
    // Ir182
    1000771820,
    // Ir183
    1000771830,
    // Ir184
    1000771840,
    // Ir185
    1000771850,
    // Ir186
    1000771860,
    // Ir187
    1000771870,
    // Ir188
    1000771880,
    // Ir189
    1000771890,
    // Ir190
    1000771900,
    // Ir191
    1000771910,
    // Ir192
    1000771920,
    // Ir193
    1000771930,
    // Ir194
    1000771940,
    // Ir195
    1000771950,
    // Ir196
    1000771960,
    // Ir197
    1000771970,
    // Ir198
    1000771980,
    // Ir199
    1000771990,
    // Pt168
    1000781680,
    // Pt169
    1000781690,
    // Pt170
    1000781700,
    // Pt171
    1000781710,
    // Pt172
    1000781720,
    // Pt173
    1000781730,
    // Pt174
    1000781740,
    // Pt175
    1000781750,
    // Pt176
    1000781760,
    // Pt177
    1000781770,
    // Pt178
    1000781780,
    // Pt179
    1000781790,
    // Pt180
    1000781800,
    // Pt181
    1000781810,
    // Pt182
    1000781820,
    // Pt183
    1000781830,
    // Pt184
    1000781840,
    // Pt185
    1000781850,
    // Pt186
    1000781860,
    // Pt187
    1000781870,
    // Pt188
    1000781880,
    // Pt189
    1000781890,
    // Pt190
    1000781900,
    // Pt191
    1000781910,
    // Pt192
    1000781920,
    // Pt193
    1000781930,
    // Pt194
    1000781940,
    // Pt195
    1000781950,
    // Pt196
    1000781960,
    // Pt197
    1000781970,
    // Pt198
    1000781980,
    // Pt199
    1000781990,
    // Pt200
    1000782000,
    // Pt201
    1000782010,
    // Pt202
    1000782020,
    // Au171
    1000791710,
    // Au172
    1000791720,
    // Au173
    1000791730,
    // Au174
    1000791740,
    // Au175
    1000791750,
    // Au176
    1000791760,
    // Au177
    1000791770,
    // Au178
    1000791780,
    // Au179
    1000791790,
    // Au180
    1000791800,
    // Au181
    1000791810,
    // Au182
    1000791820,
    // Au183
    1000791830,
    // Au184
    1000791840,
    // Au185
    1000791850,
    // Au186
    1000791860,
    // Au187
    1000791870,
    // Au188
    1000791880,
    // Au189
    1000791890,
    // Au190
    1000791900,
    // Au191
    1000791910,
    // Au192
    1000791920,
    // Au193
    1000791930,
    // Au194
    1000791940,
    // Au195
    1000791950,
    // Au196
    1000791960,
    // Au197
    1000791970,
    // Au198
    1000791980,
    // Au199
    1000791990,
    // Au200
    1000792000,
    // Au201
    1000792010,
    // Au202
    1000792020,
    // Au203
    1000792030,
    // Au204
    1000792040,
    // Au205
    1000792050,
    // Hg175
    1000801750,
    // Hg176
    1000801760,
    // Hg177
    1000801770,
    // Hg178
    1000801780,
    // Hg179
    1000801790,
    // Hg180
    1000801800,
    // Hg181
    1000801810,
    // Hg182
    1000801820,
    // Hg183
    1000801830,
    // Hg184
    1000801840,
    // Hg185
    1000801850,
    // Hg186
    1000801860,
    // Hg187
    1000801870,
    // Hg188
    1000801880,
    // Hg189
    1000801890,
    // Hg190
    1000801900,
    // Hg191
    1000801910,
    // Hg192
    1000801920,
    // Hg193
    1000801930,
    // Hg194
    1000801940,
    // Hg195
    1000801950,
    // Hg196
    1000801960,
    // Hg197
    1000801970,
    // Hg198
    1000801980,
    // Hg199
    1000801990,
    // Hg200
    1000802000,
    // Hg201
    1000802010,
    // Hg202
    1000802020,
    // Hg203
    1000802030,
    // Hg204
    1000802040,
    // Hg205
    1000802050,
    // Hg206
    1000802060,
    // Hg207
    1000802070,
    // Hg208
    1000802080,
    // Tl177
    1000811770,
    // Tl178
    1000811780,
    // Tl179
    1000811790,
    // Tl180
    1000811800,
    // Tl181
    1000811810,
    // Tl182
    1000811820,
    // Tl183
    1000811830,
    // Tl184
    1000811840,
    // Tl185
    1000811850,
    // Tl186
    1000811860,
    // Tl187
    1000811870,
    // Tl188
    1000811880,
    // Tl189
    1000811890,
    // Tl190
    1000811900,
    // Tl191
    1000811910,
    // Tl192
    1000811920,
    // Tl193
    1000811930,
    // Tl194
    1000811940,
    // Tl195
    1000811950,
    // Tl196
    1000811960,
    // Tl197
    1000811970,
    // Tl198
    1000811980,
    // Tl199
    1000811990,
    // Tl200
    1000812000,
    // Tl201
    1000812010,
    // Tl202
    1000812020,
    // Tl203
    1000812030,
    // Tl204
    1000812040,
    // Tl205
    1000812050,
    // Tl206
    1000812060,
    // Tl207
    1000812070,
    // Tl208
    1000812080,
    // Tl209
    1000812090,
    // Tl210
    1000812100,
    // Pb181
    1000821810,
    // Pb182
    1000821820,
    // Pb183
    1000821830,
    // Pb184
    1000821840,
    // Pb185
    1000821850,
    // Pb186
    1000821860,
    // Pb187
    1000821870,
    // Pb188
    1000821880,
    // Pb189
    1000821890,
    // Pb190
    1000821900,
    // Pb191
    1000821910,
    // Pb192
    1000821920,
    // Pb193
    1000821930,
    // Pb194
    1000821940,
    // Pb195
    1000821950,
    // Pb196
    1000821960,
    // Pb197
    1000821970,
    // Pb198
    1000821980,
    // Pb199
    1000821990,
    // Pb200
    1000822000,
    // Pb201
    1000822010,
    // Pb202
    1000822020,
    // Pb203
    1000822030,
    // Pb204
    1000822040,
    // Pb205
    1000822050,
    // Pb206
    1000822060,
    // Pb207
    1000822070,
    // Pb208
    1000822080,
    // Pb209
    1000822090,
    // Pb210
    1000822100,
    // Pb211
    1000822110,
    // Pb212
    1000822120,
    // Pb213
    1000822130,
    // Pb214
    1000822140,
    // Bi185
    1000831850,
    // Bi186
    1000831860,
    // Bi187
    1000831870,
    // Bi188
    1000831880,
    // Bi189
    1000831890,
    // Bi190
    1000831900,
    // Bi191
    1000831910,
    // Bi192
    1000831920,
    // Bi193
    1000831930,
    // Bi194
    1000831940,
    // Bi195
    1000831950,
    // Bi196
    1000831960,
    // Bi197
    1000831970,
    // Bi198
    1000831980,
    // Bi199
    1000831990,
    // Bi200
    1000832000,
    // Bi201
    1000832010,
    // Bi202
    1000832020,
    // Bi203
    1000832030,
    // Bi204
    1000832040,
    // Bi205
    1000832050,
    // Bi206
    1000832060,
    // Bi207
    1000832070,
    // Bi208
    1000832080,
    // Bi209
    1000832090,
    // Bi210
    1000832100,
    // Bi211
    1000832110,
    // Bi212
    1000832120,
    // Bi213
    1000832130,
    // Bi214
    1000832140,
    // Bi215
    1000832150,
    // Bi216
    1000832160,
    // Po190
    1000841900,
    // Po191
    1000841910,
    // Po192
    1000841920,
    // Po193
    1000841930,
    // Po194
    1000841940,
    // Po195
    1000841950,
    // Po196
    1000841960,
    // Po197
    1000841970,
    // Po198
    1000841980,
    // Po199
    1000841990,
    // Po200
    1000842000,
    // Po201
    1000842010,
    // Po202
    1000842020,
    // Po203
    1000842030,
    // Po204
    1000842040,
    // Po205
    1000842050,
    // Po206
    1000842060,
    // Po207
    1000842070,
    // Po208
    1000842080,
    // Po209
    1000842090,
    // Po210
    1000842100,
    // Po211
    1000842110,
    // Po212
    1000842120,
    // Po213
    1000842130,
    // Po214
    1000842140,
    // Po215
    1000842150,
    // Po216
    1000842160,
    // Po217
    1000842170,
    // Po218
    1000842180,
    // At193
    1000851930,
    // At194
    1000851940,
    // At195
    1000851950,
    // At196
    1000851960,
    // At197
    1000851970,
    // At198
    1000851980,
    // At199
    1000851990,
    // At200
    1000852000,
    // At201
    1000852010,
    // At202
    1000852020,
    // At203
    1000852030,
    // At204
    1000852040,
    // At205
    1000852050,
    // At206
    1000852060,
    // At207
    1000852070,
    // At208
    1000852080,
    // At209
    1000852090,
    // At210
    1000852100,
    // At211
    1000852110,
    // At212
    1000852120,
    // At213
    1000852130,
    // At214
    1000852140,
    // At215
    1000852150,
    // At216
    1000852160,
    // At217
    1000852170,
    // At218
    1000852180,
    // At219
    1000852190,
    // At220
    1000852200,
    // At221
    1000852210,
    // At222
    1000852220,
    // At223
    1000852230,
    // Rn196
    1000861960,
    // Rn197
    1000861970,
    // Rn198
    1000861980,
    // Rn199
    1000861990,
    // Rn200
    1000862000,
    // Rn201
    1000862010,
    // Rn202
    1000862020,
    // Rn203
    1000862030,
    // Rn204
    1000862040,
    // Rn205
    1000862050,
    // Rn206
    1000862060,
    // Rn207
    1000862070,
    // Rn208
    1000862080,
    // Rn209
    1000862090,
    // Rn210
    1000862100,
    // Rn211
    1000862110,
    // Rn212
    1000862120,
    // Rn213
    1000862130,
    // Rn214
    1000862140,
    // Rn215
    1000862150,
    // Rn216
    1000862160,
    // Rn217
    1000862170,
    // Rn218
    1000862180,
    // Rn219
    1000862190,
    // Rn220
    1000862200,
    // Rn221
    1000862210,
    // Rn222
    1000862220,
    // Rn223
    1000862230,
    // Rn224
    1000862240,
    // Rn225
    1000862250,
    // Rn226
    1000862260,
    // Rn227
    1000862270,
    // Rn228
    1000862280,
    // Fr200
    1000872000,
    // Fr201
    1000872010,
    // Fr202
    1000872020,
    // Fr203
    1000872030,
    // Fr204
    1000872040,
    // Fr205
    1000872050,
    // Fr206
    1000872060,
    // Fr207
    1000872070,
    // Fr208
    1000872080,
    // Fr209
    1000872090,
    // Fr210
    1000872100,
    // Fr211
    1000872110,
    // Fr212
    1000872120,
    // Fr213
    1000872130,
    // Fr214
    1000872140,
    // Fr215
    1000872150,
    // Fr216
    1000872160,
    // Fr217
    1000872170,
    // Fr218
    1000872180,
    // Fr219
    1000872190,
    // Fr220
    1000872200,
    // Fr221
    1000872210,
    // Fr222
    1000872220,
    // Fr223
    1000872230,
    // Fr224
    1000872240,
    // Fr225
    1000872250,
    // Fr226
    1000872260,
    // Fr227
    1000872270,
    // Fr228
    1000872280,
    // Fr229
    1000872290,
    // Fr230
    1000872300,
    // Fr231
    1000872310,
    // Fr232
    1000872320,
    // Ra203
    1000882030,
    // Ra204
    1000882040,
    // Ra205
    1000882050,
    // Ra206
    1000882060,
    // Ra207
    1000882070,
    // Ra208
    1000882080,
    // Ra209
    1000882090,
    // Ra210
    1000882100,
    // Ra211
    1000882110,
    // Ra212
    1000882120,
    // Ra213
    1000882130,
    // Ra214
    1000882140,
    // Ra215
    1000882150,
    // Ra216
    1000882160,
    // Ra217
    1000882170,
    // Ra218
    1000882180,
    // Ra219
    1000882190,
    // Ra220
    1000882200,
    // Ra221
    1000882210,
    // Ra222
    1000882220,
    // Ra223
    1000882230,
    // Ra224
    1000882240,
    // Ra225
    1000882250,
    // Ra226
    1000882260,
    // Ra227
    1000882270,
    // Ra228
    1000882280,
    // Ra229
    1000882290,
    // Ra230
    1000882300,
    // Ra231
    1000882310,
    // Ra232
    1000882320,
    // Ra233
    1000882330,
    // Ra234
    1000882340,
    // Ac207
    1000892070,
    // Ac208
    1000892080,
    // Ac209
    1000892090,
    // Ac210
    1000892100,
    // Ac211
    1000892110,
    // Ac212
    1000892120,
    // Ac213
    1000892130,
    // Ac214
    1000892140,
    // Ac215
    1000892150,
    // Ac216
    1000892160,
    // Ac217
    1000892170,
    // Ac218
    1000892180,
    // Ac219
    1000892190,
    // Ac220
    1000892200,
    // Ac221
    1000892210,
    // Ac222
    1000892220,
    // Ac223
    1000892230,
    // Ac224
    1000892240,
    // Ac225
    1000892250,
    // Ac226
    1000892260,
    // Ac227
    1000892270,
    // Ac228
    1000892280,
    // Ac229
    1000892290,
    // Ac230
    1000892300,
    // Ac231
    1000892310,
    // Ac232
    1000892320,
    // Ac233
    1000892330,
    // Ac234
    1000892340,
    // Ac235
    1000892350,
    // Ac236
    1000892360,
    // Th210
    1000902100,
    // Th211
    1000902110,
    // Th212
    1000902120,
    // Th213
    1000902130,
    // Th214
    1000902140,
    // Th215
    1000902150,
    // Th216
    1000902160,
    // Th217
    1000902170,
    // Th218
    1000902180,
    // Th219
    1000902190,
    // Th220
    1000902200,
    // Th221
    1000902210,
    // Th222
    1000902220,
    // Th223
    1000902230,
    // Th224
    1000902240,
    // Th225
    1000902250,
    // Th226
    1000902260,
    // Th227
    1000902270,
    // Th228
    1000902280,
    // Th229
    1000902290,
    // Th230
    1000902300,
    // Th231
    1000902310,
    // Th232
    1000902320,
    // Th233
    1000902330,
    // Th234
    1000902340,
    // Th235
    1000902350,
    // Th236
    1000902360,
    // Th237
    1000902370,
    // Th238
    1000902380,
    // Pa213
    1000912130,
    // Pa214
    1000912140,
    // Pa215
    1000912150,
    // Pa216
    1000912160,
    // Pa217
    1000912170,
    // Pa218
    1000912180,
    // Pa219
    1000912190,
    // Pa220
    1000912200,
    // Pa221
    1000912210,
    // Pa222
    1000912220,
    // Pa223
    1000912230,
    // Pa224
    1000912240,
    // Pa225
    1000912250,
    // Pa226
    1000912260,
    // Pa227
    1000912270,
    // Pa228
    1000912280,
    // Pa229
    1000912290,
    // Pa230
    1000912300,
    // Pa231
    1000912310,
    // Pa232
    1000912320,
    // Pa233
    1000912330,
    // Pa234
    1000912340,
    // Pa235
    1000912350,
    // Pa236
    1000912360,
    // Pa237
    1000912370,
    // Pa238
    1000912380,
    // Pa239
    1000912390,
    // Pa240
    1000912400,
    // U218
    1000922180,
    // U219
    1000922190,
    // U220
    1000922200,
    // U221
    1000922210,
    // U222
    1000922220,
    // U223
    1000922230,
    // U224
    1000922240,
    // U225
    1000922250,
    // U226
    1000922260,
    // U227
    1000922270,
    // U228
    1000922280,
    // U229
    1000922290,
    // U230
    1000922300,
    // U231
    1000922310,
    // U232
    1000922320,
    // U233
    1000922330,
    // U234
    1000922340,
    // U235
    1000922350,
    // U236
    1000922360,
    // U237
    1000922370,
    // U238
    1000922380,
    // U239
    1000922390,
    // U240
    1000922400,
    // U241
    1000922410,
    // U242
    1000922420,
    // Np225
    1000932250,
    // Np226
    1000932260,
    // Np227
    1000932270,
    // Np228
    1000932280,
    // Np229
    1000932290,
    // Np230
    1000932300,
    // Np231
    1000932310,
    // Np232
    1000932320,
    // Np233
    1000932330,
    // Np234
    1000932340,
    // Np235
    1000932350,
    // Np236
    1000932360,
    // Np237
    1000932370,
    // Np238
    1000932380,
    // Np239
    1000932390,
    // Np240
    1000932400,
    // Np241
    1000932410,
    // Np242
    1000932420,
    // Np243
    1000932430,
    // Np244
    1000932440,
    // Pu228
    1000942280,
    // Pu229
    1000942290,
    // Pu230
    1000942300,
    // Pu231
    1000942310,
    // Pu232
    1000942320,
    // Pu233
    1000942330,
    // Pu234
    1000942340,
    // Pu235
    1000942350,
    // Pu236
    1000942360,
    // Pu237
    1000942370,
    // Pu238
    1000942380,
    // Pu239
    1000942390,
    // Pu240
    1000942400,
    // Pu241
    1000942410,
    // Pu242
    1000942420,
    // Pu243
    1000942430,
    // Pu244
    1000942440,
    // Pu245
    1000942450,
    // Pu246
    1000942460,
    // Pu247
    1000942470,
    // Am231
    1000952310,
    // Am232
    1000952320,
    // Am233
    1000952330,
    // Am234
    1000952340,
    // Am235
    1000952350,
    // Am236
    1000952360,
    // Am237
    1000952370,
    // Am238
    1000952380,
    // Am239
    1000952390,
    // Am240
    1000952400,
    // Am241
    1000952410,
    // Am242
    1000952420,
    // Am243
    1000952430,
    // Am244
    1000952440,
    // Am245
    1000952450,
    // Am246
    1000952460,
    // Am247
    1000952470,
    // Am248
    1000952480,
    // Am249
    1000952490,
    // Cm233
    1000962330,
    // Cm234
    1000962340,
    // Cm235
    1000962350,
    // Cm236
    1000962360,
    // Cm237
    1000962370,
    // Cm238
    1000962380,
    // Cm239
    1000962390,
    // Cm240
    1000962400,
    // Cm241
    1000962410,
    // Cm242
    1000962420,
    // Cm243
    1000962430,
    // Cm244
    1000962440,
    // Cm245
    1000962450,
    // Cm246
    1000962460,
    // Cm247
    1000962470,
    // Cm248
    1000962480,
    // Cm249
    1000962490,
    // Cm250
    1000962500,
    // Cm251
    1000962510,
    // Cm252
    1000962520,
    // Bk235
    1000972350,
    // Bk236
    1000972360,
    // Bk237
    1000972370,
    // Bk238
    1000972380,
    // Bk239
    1000972390,
    // Bk240
    1000972400,
    // Bk241
    1000972410,
    // Bk242
    1000972420,
    // Bk243
    1000972430,
    // Bk244
    1000972440,
    // Bk245
    1000972450,
    // Bk246
    1000972460,
    // Bk247
    1000972470,
    // Bk248
    1000972480,
    // Bk249
    1000972490,
    // Bk250
    1000972500,
    // Bk251
    1000972510,
    // Bk252
    1000972520,
    // Bk253
    1000972530,
    // Bk254
    1000972540,
    // Cf237
    1000982370,
    // Cf238
    1000982380,
    // Cf239
    1000982390,
    // Cf240
    1000982400,
    // Cf241
    1000982410,
    // Cf242
    1000982420,
    // Cf243
    1000982430,
    // Cf244
    1000982440,
    // Cf245
    1000982450,
    // Cf246
    1000982460,
    // Cf247
    1000982470,
    // Cf248
    1000982480,
    // Cf249
    1000982490,
    // Cf250
    1000982500,
    // Cf251
    1000982510,
    // Cf252
    1000982520,
    // Cf253
    1000982530,
    // Cf254
    1000982540,
    // Cf255
    1000982550,
    // Cf256
    1000982560,
    // Es240
    1000992400,
    // Es241
    1000992410,
    // Es242
    1000992420,
    // Es243
    1000992430,
    // Es244
    1000992440,
    // Es245
    1000992450,
    // Es246
    1000992460,
    // Es247
    1000992470,
    // Es248
    1000992480,
    // Es249
    1000992490,
    // Es250
    1000992500,
    // Es251
    1000992510,
    // Es252
    1000992520,
    // Es253
    1000992530,
    // Es254
    1000992540,
    // Es255
    1000992550,
    // Es256
    1000992560,
    // Es257
    1000992570,
    // Fm242
    1001002420,
    // Fm243
    1001002430,
    // Fm244
    1001002440,
    // Fm245
    1001002450,
    // Fm246
    1001002460,
    // Fm247
    1001002470,
    // Fm248
    1001002480,
    // Fm249
    1001002490,
    // Fm250
    1001002500,
    // Fm251
    1001002510,
    // Fm252
    1001002520,
    // Fm253
    1001002530,
    // Fm254
    1001002540,
    // Fm255
    1001002550,
    // Fm256
    1001002560,
    // Fm257
    1001002570,
    // Fm258
    1001002580,
    // Fm259
    1001002590,
    // Md245
    1001012450,
    // Md246
    1001012460,
    // Md247
    1001012470,
    // Md248
    1001012480,
    // Md249
    1001012490,
    // Md250
    1001012500,
    // Md251
    1001012510,
    // Md252
    1001012520,
    // Md253
    1001012530,
    // Md254
    1001012540,
    // Md255
    1001012550,
    // Md256
    1001012560,
    // Md257
    1001012570,
    // Md258
    1001012580,
    // Md259
    1001012590,
    // Md260
    1001012600,
    // No249
    1001022490,
    // No250
    1001022500,
    // No251
    1001022510,
    // No252
    1001022520,
    // No253
    1001022530,
    // No254
    1001022540,
    // No255
    1001022550,
    // No256
    1001022560,
    // No257
    1001022570,
    // No258
    1001022580,
    // No259
    1001022590,
    // No260
    1001022600,
    // No261
    1001022610,
    // No262
    1001022620,
    // Lr251
    1001032510,
    // Lr252
    1001032520,
    // Lr253
    1001032530,
    // Lr254
    1001032540,
    // Lr255
    1001032550,
    // Lr256
    1001032560,
    // Lr257
    1001032570,
    // Lr258
    1001032580,
    // Lr259
    1001032590,
    // Lr260
    1001032600,
    // Lr261
    1001032610,
    // Lr262
    1001032620,
    // Lr263
    1001032630,
    // Rf253
    1001042530,
    // Rf254
    1001042540,
    // Rf255
    1001042550,
    // Rf256
    1001042560,
    // Rf257
    1001042570,
    // Rf258
    1001042580,
    // Rf259
    1001042590,
    // Rf260
    1001042600,
    // Rf261
    1001042610,
    // Rf262
    1001042620,
    // Rf263
    1001042630,
    // Rf264
    1001042640,
    // Db255
    1001052550,
    // Db256
    1001052560,
    // Db257
    1001052570,
    // Db258
    1001052580,
    // Db259
    1001052590,
    // Db260
    1001052600,
    // Db261
    1001052610,
    // Db262
    1001052620,
    // Db263
    1001052630,
    // Db264
    1001052640,
    // Db265
    1001052650,
    // Sg258
    1001062580,
    // Sg259
    1001062590,
    // Sg260
    1001062600,
    // Sg261
    1001062610,
    // Sg262
    1001062620,
    // Sg263
    1001062630,
    // Sg264
    1001062640,
    // Sg265
    1001062650,
    // Sg266
    1001062660,
    // Bh260
    1001072600,
    // Bh261
    1001072610,
    // Bh262
    1001072620,
    // Bh263
    1001072630,
    // Bh264
    1001072640,
    // Bh265
    1001072650,
    // Bh266
    1001072660,
    // Bh267
    1001072670,
    // Hs263
    1001082630,
    // Hs264
    1001082640,
    // Hs265
    1001082650,
    // Hs266
    1001082660,
    // Hs267
    1001082670,
    // Hs268
    1001082680,
    // Hs269
    1001082690,
    // Hs277
    1001082770,
    // Mt265
    1001092650,
    // Mt266
    1001092660,
    // Mt267
    1001092670,
    // Mt268
    1001092680,
    // Mt269
    1001092690,
    // Mt270
    1001092700,
    // Mt271
    1001092710,
    // Ds267
    1001102670,
    // Ds268
    1001102680,
    // Ds269
    1001102690,
    // Ds270
    1001102700,
    // Ds271
    1001102710,
    // Ds272
    1001102720,
    // Ds273
    1001102730,
    // Ds281
    1001102810,
    // Rg272
    1001112720,
    // Cn285
    1001122850,
    // Nh286
    1001132860,
    // Fl289
    1001142890,
    // Mc289
    1001152890,
    // Lv293
    1001162930,
    // Ts294
    1001172940,
    // Og294
    1001182940,
};
static const std::array<std::int16_t, kParticlesCount> kParticlesThreeCharge = {
    // Og294~
    -354,
    // Ts294~
    -351,
    // Lv293~
    -348,
    // Mc289~
    -345,
    // Fl289~
    -342,
    // Nh286~
    -339,
    // Cn285~
    -336,
    // Rg272~
    -333,
    // Ds281~
    -330,
    // Ds273~
    -330,
    // Ds272~
    -330,
    // Ds271~
    -330,
    // Ds270~
    -330,
    // Ds269~
    -330,
    // Ds268~
    -330,
    // Ds267~
    -330,
    // Mt271~
    -327,
    // Mt270~
    -327,
    // Mt269~
    -327,
    // Mt268~
    -327,
    // Mt267~
    -327,
    // Mt266~
    -327,
    // Mt265~
    -327,
    // Hs277~
    -324,
    // Hs269~
    -324,
    // Hs268~
    -324,
    // Hs267~
    -324,
    // Hs266~
    -324,
    // Hs265~
    -324,
    // Hs264~
    -324,
    // Hs263~
    -324,
    // Bh267~
    -321,
    // Bh266~
    -321,
    // Bh265~
    -321,
    // Bh264~
    -321,
    // Bh263~
    -321,
    // Bh262~
    -321,
    // Bh261~
    -321,
    // Bh260~
    -321,
    // Sg266~
    -318,
    // Sg265~
    -318,
    // Sg264~
    -318,
    // Sg263~
    -318,
    // Sg262~
    -318,
    // Sg261~
    -318,
    // Sg260~
    -318,
    // Sg259~
    -318,
    // Sg258~
    -318,
    // Db265~
    -315,
    // Db264~
    -315,
    // Db263~
    -315,
    // Db262~
    -315,
    // Db261~
    -315,
    // Db260~
    -315,
    // Db259~
    -315,
    // Db258~
    -315,
    // Db257~
    -315,
    // Db256~
    -315,
    // Db255~
    -315,
    // Rf264~
    -312,
    // Rf263~
    -312,
    // Rf262~
    -312,
    // Rf261~
    -312,
    // Rf260~
    -312,
    // Rf259~
    -312,
    // Rf258~
    -312,
    // Rf257~
    -312,
    // Rf256~
    -312,
    // Rf255~
    -312,
    // Rf254~
    -312,
    // Rf253~
    -312,
    // Lr263~
    -309,
    // Lr262~
    -309,
    // Lr261~
    -309,
    // Lr260~
    -309,
    // Lr259~
    -309,
    // Lr258~
    -309,
    // Lr257~
    -309,
    // Lr256~
    -309,
    // Lr255~
    -309,
    // Lr254~
    -309,
    // Lr253~
    -309,
    // Lr252~
    -309,
    // Lr251~
    -309,
    // No262~
    -306,
    // No261~
    -306,
    // No260~
    -306,
    // No259~
    -306,
    // No258~
    -306,
    // No257~
    -306,
    // No256~
    -306,
    // No255~
    -306,
    // No254~
    -306,
    // No253~
    -306,
    // No252~
    -306,
    // No251~
    -306,
    // No250~
    -306,
    // No249~
    -306,
    // Md260~
    -303,
    // Md259~
    -303,
    // Md258~
    -303,
    // Md257~
    -303,
    // Md256~
    -303,
    // Md255~
    -303,
    // Md254~
    -303,
    // Md253~
    -303,
    // Md252~
    -303,
    // Md251~
    -303,
    // Md250~
    -303,
    // Md249~
    -303,
    // Md248~
    -303,
    // Md247~
    -303,
    // Md246~
    -303,
    // Md245~
    -303,
    // Fm259~
    -300,
    // Fm258~
    -300,
    // Fm257~
    -300,
    // Fm256~
    -300,
    // Fm255~
    -300,
    // Fm254~
    -300,
    // Fm253~
    -300,
    // Fm252~
    -300,
    // Fm251~
    -300,
    // Fm250~
    -300,
    // Fm249~
    -300,
    // Fm248~
    -300,
    // Fm247~
    -300,
    // Fm246~
    -300,
    // Fm245~
    -300,
    // Fm244~
    -300,
    // Fm243~
    -300,
    // Fm242~
    -300,
    // Es257~
    -297,
    // Es256~
    -297,
    // Es255~
    -297,
    // Es254~
    -297,
    // Es253~
    -297,
    // Es252~
    -297,
    // Es251~
    -297,
    // Es250~
    -297,
    // Es249~
    -297,
    // Es248~
    -297,
    // Es247~
    -297,
    // Es246~
    -297,
    // Es245~
    -297,
    // Es244~
    -297,
    // Es243~
    -297,
    // Es242~
    -297,
    // Es241~
    -297,
    // Es240~
    -297,
    // Cf256~
    -294,
    // Cf255~
    -294,
    // Cf254~
    -294,
    // Cf253~
    -294,
    // Cf252~
    -294,
    // Cf251~
    -294,
    // Cf250~
    -294,
    // Cf249~
    -294,
    // Cf248~
    -294,
    // Cf247~
    -294,
    // Cf246~
    -294,
    // Cf245~
    -294,
    // Cf244~
    -294,
    // Cf243~
    -294,
    // Cf242~
    -294,
    // Cf241~
    -294,
    // Cf240~
    -294,
    // Cf239~
    -294,
    // Cf238~
    -294,
    // Cf237~
    -294,
    // Bk254~
    -291,
    // Bk253~
    -291,
    // Bk252~
    -291,
    // Bk251~
    -291,
    // Bk250~
    -291,
    // Bk249~
    -291,
    // Bk248~
    -291,
    // Bk247~
    -291,
    // Bk246~
    -291,
    // Bk245~
    -291,
    // Bk244~
    -291,
    // Bk243~
    -291,
    // Bk242~
    -291,
    // Bk241~
    -291,
    // Bk240~
    -291,
    // Bk239~
    -291,
    // Bk238~
    -291,
    // Bk237~
    -291,
    // Bk236~
    -291,
    // Bk235~
    -291,
    // Cm252~
    -288,
    // Cm251~
    -288,
    // Cm250~
    -288,
    // Cm249~
    -288,
    // Cm248~
    -288,
    // Cm247~
    -288,
    // Cm246~
    -288,
    // Cm245~
    -288,
    // Cm244~
    -288,
    // Cm243~
    -288,
    // Cm242~
    -288,
    // Cm241~
    -288,
    // Cm240~
    -288,
    // Cm239~
    -288,
    // Cm238~
    -288,
    // Cm237~
    -288,
    // Cm236~
    -288,
    // Cm235~
    -288,
    // Cm234~
    -288,
    // Cm233~
    -288,
    // Am249~
    -285,
    // Am248~
    -285,
    // Am247~
    -285,
    // Am246~
    -285,
    // Am245~
    -285,
    // Am244~
    -285,
    // Am243~
    -285,
    // Am242~
    -285,
    // Am241~
    -285,
    // Am240~
    -285,
    // Am239~
    -285,
    // Am238~
    -285,
    // Am237~
    -285,
    // Am236~
    -285,
    // Am235~
    -285,
    // Am234~
    -285,
    // Am233~
    -285,
    // Am232~
    -285,
    // Am231~
    -285,
    // Pu247~
    -282,
    // Pu246~
    -282,
    // Pu245~
    -282,
    // Pu244~
    -282,
    // Pu243~
    -282,
    // Pu242~
    -282,
    // Pu241~
    -282,
    // Pu240~
    -282,
    // Pu239~
    -282,
    // Pu238~
    -282,
    // Pu237~
    -282,
    // Pu236~
    -282,
    // Pu235~
    -282,
    // Pu234~
    -282,
    // Pu233~
    -282,
    // Pu232~
    -282,
    // Pu231~
    -282,
    // Pu230~
    -282,
    // Pu229~
    -282,
    // Pu228~
    -282,
    // Np244~
    -279,
    // Np243~
    -279,
    // Np242~
    -279,
    // Np241~
    -279,
    // Np240~
    -279,
    // Np239~
    -279,
    // Np238~
    -279,
    // Np237~
    -279,
    // Np236~
    -279,
    // Np235~
    -279,
    // Np234~
    -279,
    // Np233~
    -279,
    // Np232~
    -279,
    // Np231~
    -279,
    // Np230~
    -279,
    // Np229~
    -279,
    // Np228~
    -279,
    // Np227~
    -279,
    // Np226~
    -279,
    // Np225~
    -279,
    // U242~
    -276,
    // U241~
    -276,
    // U240~
    -276,
    // U239~
    -276,
    // U238~
    -276,
    // U237~
    -276,
    // U236~
    -276,
    // U235~
    -276,
    // U234~
    -276,
    // U233~
    -276,
    // U232~
    -276,
    // U231~
    -276,
    // U230~
    -276,
    // U229~
    -276,
    // U228~
    -276,
    // U227~
    -276,
    // U226~
    -276,
    // U225~
    -276,
    // U224~
    -276,
    // U223~
    -276,
    // U222~
    -276,
    // U221~
    -276,
    // U220~
    -276,
    // U219~
    -276,
    // U218~
    -276,
    // Pa240~
    -273,
    // Pa239~
    -273,
    // Pa238~
    -273,
    // Pa237~
    -273,
    // Pa236~
    -273,
    // Pa235~
    -273,
    // Pa234~
    -273,
    // Pa233~
    -273,
    // Pa232~
    -273,
    // Pa231~
    -273,
    // Pa230~
    -273,
    // Pa229~
    -273,
    // Pa228~
    -273,
    // Pa227~
    -273,
    // Pa226~
    -273,
    // Pa225~
    -273,
    // Pa224~
    -273,
    // Pa223~
    -273,
    // Pa222~
    -273,
    // Pa221~
    -273,
    // Pa220~
    -273,
    // Pa219~
    -273,
    // Pa218~
    -273,
    // Pa217~
    -273,
    // Pa216~
    -273,
    // Pa215~
    -273,
    // Pa214~
    -273,
    // Pa213~
    -273,
    // Th238~
    -270,
    // Th237~
    -270,
    // Th236~
    -270,
    // Th235~
    -270,
    // Th234~
    -270,
    // Th233~
    -270,
    // Th232~
    -270,
    // Th231~
    -270,
    // Th230~
    -270,
    // Th229~
    -270,
    // Th228~
    -270,
    // Th227~
    -270,
    // Th226~
    -270,
    // Th225~
    -270,
    // Th224~
    -270,
    // Th223~
    -270,
    // Th222~
    -270,
    // Th221~
    -270,
    // Th220~
    -270,
    // Th219~
    -270,
    // Th218~
    -270,
    // Th217~
    -270,
    // Th216~
    -270,
    // Th215~
    -270,
    // Th214~
    -270,
    // Th213~
    -270,
    // Th212~
    -270,
    // Th211~
    -270,
    // Th210~
    -270,
    // Ac236~
    -267,
    // Ac235~
    -267,
    // Ac234~
    -267,
    // Ac233~
    -267,
    // Ac232~
    -267,
    // Ac231~
    -267,
    // Ac230~
    -267,
    // Ac229~
    -267,
    // Ac228~
    -267,
    // Ac227~
    -267,
    // Ac226~
    -267,
    // Ac225~
    -267,
    // Ac224~
    -267,
    // Ac223~
    -267,
    // Ac222~
    -267,
    // Ac221~
    -267,
    // Ac220~
    -267,
    // Ac219~
    -267,
    // Ac218~
    -267,
    // Ac217~
    -267,
    // Ac216~
    -267,
    // Ac215~
    -267,
    // Ac214~
    -267,
    // Ac213~
    -267,
    // Ac212~
    -267,
    // Ac211~
    -267,
    // Ac210~
    -267,
    // Ac209~
    -267,
    // Ac208~
    -267,
    // Ac207~
    -267,
    // Ra234~
    -264,
    // Ra233~
    -264,
    // Ra232~
    -264,
    // Ra231~
    -264,
    // Ra230~
    -264,
    // Ra229~
    -264,
    // Ra228~
    -264,
    // Ra227~
    -264,
    // Ra226~
    -264,
    // Ra225~
    -264,
    // Ra224~
    -264,
    // Ra223~
    -264,
    // Ra222~
    -264,
    // Ra221~
    -264,
    // Ra220~
    -264,
    // Ra219~
    -264,
    // Ra218~
    -264,
    // Ra217~
    -264,
    // Ra216~
    -264,
    // Ra215~
    -264,
    // Ra214~
    -264,
    // Ra213~
    -264,
    // Ra212~
    -264,
    // Ra211~
    -264,
    // Ra210~
    -264,
    // Ra209~
    -264,
    // Ra208~
    -264,
    // Ra207~
    -264,
    // Ra206~
    -264,
    // Ra205~
    -264,
    // Ra204~
    -264,
    // Ra203~
    -264,
    // Fr232~
    -261,
    // Fr231~
    -261,
    // Fr230~
    -261,
    // Fr229~
    -261,
    // Fr228~
    -261,
    // Fr227~
    -261,
    // Fr226~
    -261,
    // Fr225~
    -261,
    // Fr224~
    -261,
    // Fr223~
    -261,
    // Fr222~
    -261,
    // Fr221~
    -261,
    // Fr220~
    -261,
    // Fr219~
    -261,
    // Fr218~
    -261,
    // Fr217~
    -261,
    // Fr216~
    -261,
    // Fr215~
    -261,
    // Fr214~
    -261,
    // Fr213~
    -261,
    // Fr212~
    -261,
    // Fr211~
    -261,
    // Fr210~
    -261,
    // Fr209~
    -261,
    // Fr208~
    -261,
    // Fr207~
    -261,
    // Fr206~
    -261,
    // Fr205~
    -261,
    // Fr204~
    -261,
    // Fr203~
    -261,
    // Fr202~
    -261,
    // Fr201~
    -261,
    // Fr200~
    -261,
    // Rn228~
    -258,
    // Rn227~
    -258,
    // Rn226~
    -258,
    // Rn225~
    -258,
    // Rn224~
    -258,
    // Rn223~
    -258,
    // Rn222~
    -258,
    // Rn221~
    -258,
    // Rn220~
    -258,
    // Rn219~
    -258,
    // Rn218~
    -258,
    // Rn217~
    -258,
    // Rn216~
    -258,
    // Rn215~
    -258,
    // Rn214~
    -258,
    // Rn213~
    -258,
    // Rn212~
    -258,
    // Rn211~
    -258,
    // Rn210~
    -258,
    // Rn209~
    -258,
    // Rn208~
    -258,
    // Rn207~
    -258,
    // Rn206~
    -258,
    // Rn205~
    -258,
    // Rn204~
    -258,
    // Rn203~
    -258,
    // Rn202~
    -258,
    // Rn201~
    -258,
    // Rn200~
    -258,
    // Rn199~
    -258,
    // Rn198~
    -258,
    // Rn197~
    -258,
    // Rn196~
    -258,
    // At223~
    -255,
    // At222~
    -255,
    // At221~
    -255,
    // At220~
    -255,
    // At219~
    -255,
    // At218~
    -255,
    // At217~
    -255,
    // At216~
    -255,
    // At215~
    -255,
    // At214~
    -255,
    // At213~
    -255,
    // At212~
    -255,
    // At211~
    -255,
    // At210~
    -255,
    // At209~
    -255,
    // At208~
    -255,
    // At207~
    -255,
    // At206~
    -255,
    // At205~
    -255,
    // At204~
    -255,
    // At203~
    -255,
    // At202~
    -255,
    // At201~
    -255,
    // At200~
    -255,
    // At199~
    -255,
    // At198~
    -255,
    // At197~
    -255,
    // At196~
    -255,
    // At195~
    -255,
    // At194~
    -255,
    // At193~
    -255,
    // Po218~
    -252,
    // Po217~
    -252,
    // Po216~
    -252,
    // Po215~
    -252,
    // Po214~
    -252,
    // Po213~
    -252,
    // Po212~
    -252,
    // Po211~
    -252,
    // Po210~
    -252,
    // Po209~
    -252,
    // Po208~
    -252,
    // Po207~
    -252,
    // Po206~
    -252,
    // Po205~
    -252,
    // Po204~
    -252,
    // Po203~
    -252,
    // Po202~
    -252,
    // Po201~
    -252,
    // Po200~
    -252,
    // Po199~
    -252,
    // Po198~
    -252,
    // Po197~
    -252,
    // Po196~
    -252,
    // Po195~
    -252,
    // Po194~
    -252,
    // Po193~
    -252,
    // Po192~
    -252,
    // Po191~
    -252,
    // Po190~
    -252,
    // Bi216~
    -249,
    // Bi215~
    -249,
    // Bi214~
    -249,
    // Bi213~
    -249,
    // Bi212~
    -249,
    // Bi211~
    -249,
    // Bi210~
    -249,
    // Bi209~
    -249,
    // Bi208~
    -249,
    // Bi207~
    -249,
    // Bi206~
    -249,
    // Bi205~
    -249,
    // Bi204~
    -249,
    // Bi203~
    -249,
    // Bi202~
    -249,
    // Bi201~
    -249,
    // Bi200~
    -249,
    // Bi199~
    -249,
    // Bi198~
    -249,
    // Bi197~
    -249,
    // Bi196~
    -249,
    // Bi195~
    -249,
    // Bi194~
    -249,
    // Bi193~
    -249,
    // Bi192~
    -249,
    // Bi191~
    -249,
    // Bi190~
    -249,
    // Bi189~
    -249,
    // Bi188~
    -249,
    // Bi187~
    -249,
    // Bi186~
    -249,
    // Bi185~
    -249,
    // Pb214~
    -246,
    // Pb213~
    -246,
    // Pb212~
    -246,
    // Pb211~
    -246,
    // Pb210~
    -246,
    // Pb209~
    -246,
    // Pb208~
    -246,
    // Pb207~
    -246,
    // Pb206~
    -246,
    // Pb205~
    -246,
    // Pb204~
    -246,
    // Pb203~
    -246,
    // Pb202~
    -246,
    // Pb201~
    -246,
    // Pb200~
    -246,
    // Pb199~
    -246,
    // Pb198~
    -246,
    // Pb197~
    -246,
    // Pb196~
    -246,
    // Pb195~
    -246,
    // Pb194~
    -246,
    // Pb193~
    -246,
    // Pb192~
    -246,
    // Pb191~
    -246,
    // Pb190~
    -246,
    // Pb189~
    -246,
    // Pb188~
    -246,
    // Pb187~
    -246,
    // Pb186~
    -246,
    // Pb185~
    -246,
    // Pb184~
    -246,
    // Pb183~
    -246,
    // Pb182~
    -246,
    // Pb181~
    -246,
    // Tl210~
    -243,
    // Tl209~
    -243,
    // Tl208~
    -243,
    // Tl207~
    -243,
    // Tl206~
    -243,
    // Tl205~
    -243,
    // Tl204~
    -243,
    // Tl203~
    -243,
    // Tl202~
    -243,
    // Tl201~
    -243,
    // Tl200~
    -243,
    // Tl199~
    -243,
    // Tl198~
    -243,
    // Tl197~
    -243,
    // Tl196~
    -243,
    // Tl195~
    -243,
    // Tl194~
    -243,
    // Tl193~
    -243,
    // Tl192~
    -243,
    // Tl191~
    -243,
    // Tl190~
    -243,
    // Tl189~
    -243,
    // Tl188~
    -243,
    // Tl187~
    -243,
    // Tl186~
    -243,
    // Tl185~
    -243,
    // Tl184~
    -243,
    // Tl183~
    -243,
    // Tl182~
    -243,
    // Tl181~
    -243,
    // Tl180~
    -243,
    // Tl179~
    -243,
    // Tl178~
    -243,
    // Tl177~
    -243,
    // Hg208~
    -240,
    // Hg207~
    -240,
    // Hg206~
    -240,
    // Hg205~
    -240,
    // Hg204~
    -240,
    // Hg203~
    -240,
    // Hg202~
    -240,
    // Hg201~
    -240,
    // Hg200~
    -240,
    // Hg199~
    -240,
    // Hg198~
    -240,
    // Hg197~
    -240,
    // Hg196~
    -240,
    // Hg195~
    -240,
    // Hg194~
    -240,
    // Hg193~
    -240,
    // Hg192~
    -240,
    // Hg191~
    -240,
    // Hg190~
    -240,
    // Hg189~
    -240,
    // Hg188~
    -240,
    // Hg187~
    -240,
    // Hg186~
    -240,
    // Hg185~
    -240,
    // Hg184~
    -240,
    // Hg183~
    -240,
    // Hg182~
    -240,
    // Hg181~
    -240,
    // Hg180~
    -240,
    // Hg179~
    -240,
    // Hg178~
    -240,
    // Hg177~
    -240,
    // Hg176~
    -240,
    // Hg175~
    -240,
    // Au205~
    -237,
    // Au204~
    -237,
    // Au203~
    -237,
    // Au202~
    -237,
    // Au201~
    -237,
    // Au200~
    -237,
    // Au199~
    -237,
    // Au198~
    -237,
    // Au197~
    -237,
    // Au196~
    -237,
    // Au195~
    -237,
    // Au194~
    -237,
    // Au193~
    -237,
    // Au192~
    -237,
    // Au191~
    -237,
    // Au190~
    -237,
    // Au189~
    -237,
    // Au188~
    -237,
    // Au187~
    -237,
    // Au186~
    -237,
    // Au185~
    -237,
    // Au184~
    -237,
    // Au183~
    -237,
    // Au182~
    -237,
    // Au181~
    -237,
    // Au180~
    -237,
    // Au179~
    -237,
    // Au178~
    -237,
    // Au177~
    -237,
    // Au176~
    -237,
    // Au175~
    -237,
    // Au174~
    -237,
    // Au173~
    -237,
    // Au172~
    -237,
    // Au171~
    -237,
    // Pt202~
    -234,
    // Pt201~
    -234,
    // Pt200~
    -234,
    // Pt199~
    -234,
    // Pt198~
    -234,
    // Pt197~
    -234,
    // Pt196~
    -234,
    // Pt195~
    -234,
    // Pt194~
    -234,
    // Pt193~
    -234,
    // Pt192~
    -234,
    // Pt191~
    -234,
    // Pt190~
    -234,
    // Pt189~
    -234,
    // Pt188~
    -234,
    // Pt187~
    -234,
    // Pt186~
    -234,
    // Pt185~
    -234,
    // Pt184~
    -234,
    // Pt183~
    -234,
    // Pt182~
    -234,
    // Pt181~
    -234,
    // Pt180~
    -234,
    // Pt179~
    -234,
    // Pt178~
    -234,
    // Pt177~
    -234,
    // Pt176~
    -234,
    // Pt175~
    -234,
    // Pt174~
    -234,
    // Pt173~
    -234,
    // Pt172~
    -234,
    // Pt171~
    -234,
    // Pt170~
    -234,
    // Pt169~
    -234,
    // Pt168~
    -234,
    // Ir199~
    -231,
    // Ir198~
    -231,
    // Ir197~
    -231,
    // Ir196~
    -231,
    // Ir195~
    -231,
    // Ir194~
    -231,
    // Ir193~
    -231,
    // Ir192~
    -231,
    // Ir191~
    -231,
    // Ir190~
    -231,
    // Ir189~
    -231,
    // Ir188~
    -231,
    // Ir187~
    -231,
    // Ir186~
    -231,
    // Ir185~
    -231,
    // Ir184~
    -231,
    // Ir183~
    -231,
    // Ir182~
    -231,
    // Ir181~
    -231,
    // Ir180~
    -231,
    // Ir179~
    -231,
    // Ir178~
    -231,
    // Ir177~
    -231,
    // Ir176~
    -231,
    // Ir175~
    -231,
    // Ir174~
    -231,
    // Ir173~
    -231,
    // Ir172~
    -231,
    // Ir171~
    -231,
    // Ir170~
    -231,
    // Ir169~
    -231,
    // Ir168~
    -231,
    // Ir167~
    -231,
    // Ir166~
    -231,
    // Ir165~
    -231,
    // Os196~
    -228,
    // Os195~
    -228,
    // Os194~
    -228,
    // Os193~
    -228,
    // Os192~
    -228,
    // Os191~
    -228,
    // Os190~
    -228,
    // Os189~
    -228,
    // Os188~
    -228,
    // Os187~
    -228,
    // Os186~
    -228,
    // Os185~
    -228,
    // Os184~
    -228,
    // Os183~
    -228,
    // Os182~
    -228,
    // Os181~
    -228,
    // Os180~
    -228,
    // Os179~
    -228,
    // Os178~
    -228,
    // Os177~
    -228,
    // Os176~
    -228,
    // Os175~
    -228,
    // Os174~
    -228,
    // Os173~
    -228,
    // Os172~
    -228,
    // Os171~
    -228,
    // Os170~
    -228,
    // Os169~
    -228,
    // Os168~
    -228,
    // Os167~
    -228,
    // Os166~
    -228,
    // Os165~
    -228,
    // Os164~
    -228,
    // Os163~
    -228,
    // Os162~
    -228,
    // Re192~
    -225,
    // Re191~
    -225,
    // Re190~
    -225,
    // Re189~
    -225,
    // Re188~
    -225,
    // Re187~
    -225,
    // Re186~
    -225,
    // Re185~
    -225,
    // Re184~
    -225,
    // Re183~
    -225,
    // Re182~
    -225,
    // Re181~
    -225,
    // Re180~
    -225,
    // Re179~
    -225,
    // Re178~
    -225,
    // Re177~
    -225,
    // Re176~
    -225,
    // Re175~
    -225,
    // Re174~
    -225,
    // Re173~
    -225,
    // Re172~
    -225,
    // Re171~
    -225,
    // Re170~
    -225,
    // Re169~
    -225,
    // Re168~
    -225,
    // Re167~
    -225,
    // Re166~
    -225,
    // Re165~
    -225,
    // Re164~
    -225,
    // Re163~
    -225,
    // Re162~
    -225,
    // Re161~
    -225,
    // Re160~
    -225,
    // W190~
    -222,
    // W189~
    -222,
    // W188~
    -222,
    // W187~
    -222,
    // W186~
    -222,
    // W185~
    -222,
    // W184~
    -222,
    // W183~
    -222,
    // W182~
    -222,
    // W181~
    -222,
    // W180~
    -222,
    // W179~
    -222,
    // W178~
    -222,
    // W177~
    -222,
    // W176~
    -222,
    // W175~
    -222,
    // W174~
    -222,
    // W173~
    -222,
    // W172~
    -222,
    // W171~
    -222,
    // W170~
    -222,
    // W169~
    -222,
    // W168~
    -222,
    // W167~
    -222,
    // W166~
    -222,
    // W165~
    -222,
    // W164~
    -222,
    // W163~
    -222,
    // W162~
    -222,
    // W161~
    -222,
    // W160~
    -222,
    // W159~
    -222,
    // W158~
    -222,
    // Ta188~
    -219,
    // Ta187~
    -219,
    // Ta186~
    -219,
    // Ta185~
    -219,
    // Ta184~
    -219,
    // Ta183~
    -219,
    // Ta182~
    -219,
    // Ta181~
    -219,
    // Ta180~
    -219,
    // Ta179~
    -219,
    // Ta178~
    -219,
    // Ta177~
    -219,
    // Ta176~
    -219,
    // Ta175~
    -219,
    // Ta174~
    -219,
    // Ta173~
    -219,
    // Ta172~
    -219,
    // Ta171~
    -219,
    // Ta170~
    -219,
    // Ta169~
    -219,
    // Ta168~
    -219,
    // Ta167~
    -219,
    // Ta166~
    -219,
    // Ta165~
    -219,
    // Ta164~
    -219,
    // Ta163~
    -219,
    // Ta162~
    -219,
    // Ta161~
    -219,
    // Ta160~
    -219,
    // Ta159~
    -219,
    // Ta158~
    -219,
    // Ta157~
    -219,
    // Ta156~
    -219,
    // Hf186~
    -216,
    // Hf185~
    -216,
    // Hf184~
    -216,
    // Hf183~
    -216,
    // Hf182~
    -216,
    // Hf181~
    -216,
    // Hf180~
    -216,
    // Hf179~
    -216,
    // Hf178~
    -216,
    // Hf177~
    -216,
    // Hf176~
    -216,
    // Hf175~
    -216,
    // Hf174~
    -216,
    // Hf173~
    -216,
    // Hf172~
    -216,
    // Hf171~
    -216,
    // Hf170~
    -216,
    // Hf169~
    -216,
    // Hf168~
    -216,
    // Hf167~
    -216,
    // Hf166~
    -216,
    // Hf165~
    -216,
    // Hf164~
    -216,
    // Hf163~
    -216,
    // Hf162~
    -216,
    // Hf161~
    -216,
    // Hf160~
    -216,
    // Hf159~
    -216,
    // Hf158~
    -216,
    // Hf157~
    -216,
    // Hf156~
    -216,
    // Hf155~
    -216,
    // Hf154~
    -216,
    // Lu184~
    -213,
    // Lu183~
    -213,
    // Lu182~
    -213,
    // Lu181~
    -213,
    // Lu180~
    -213,
    // Lu179~
    -213,
    // Lu178~
    -213,
    // Lu177~
    -213,
    // Lu176~
    -213,
    // Lu175~
    -213,
    // Lu174~
    -213,
    // Lu173~
    -213,
    // Lu172~
    -213,
    // Lu171~
    -213,
    // Lu170~
    -213,
    // Lu169~
    -213,
    // Lu168~
    -213,
    // Lu167~
    -213,
    // Lu166~
    -213,
    // Lu165~
    -213,
    // Lu164~
    -213,
    // Lu163~
    -213,
    // Lu162~
    -213,
    // Lu161~
    -213,
    // Lu160~
    -213,
    // Lu159~
    -213,
    // Lu158~
    -213,
    // Lu157~
    -213,
    // Lu156~
    -213,
    // Lu155~
    -213,
    // Lu154~
    -213,
    // Lu153~
    -213,
    // Lu152~
    -213,
    // Lu151~
    -213,
    // Lu150~
    -213,
    // Yb181~
    -210,
    // Yb180~
    -210,
    // Yb179~
    -210,
    // Yb178~
    -210,
    // Yb177~
    -210,
    // Yb176~
    -210,
    // Yb175~
    -210,
    // Yb174~
    -210,
    // Yb173~
    -210,
    // Yb172~
    -210,
    // Yb171~
    -210,
    // Yb170~
    -210,
    // Yb169~
    -210,
    // Yb168~
    -210,
    // Yb167~
    -210,
    // Yb166~
    -210,
    // Yb165~
    -210,
    // Yb164~
    -210,
    // Yb163~
    -210,
    // Yb162~
    -210,
    // Yb161~
    -210,
    // Yb160~
    -210,
    // Yb159~
    -210,
    // Yb158~
    -210,
    // Yb157~
    -210,
    // Yb156~
    -210,
    // Yb155~
    -210,
    // Yb154~
    -210,
    // Yb153~
    -210,
    // Yb152~
    -210,
    // Yb151~
    -210,
    // Yb150~
    -210,
    // Yb149~
    -210,
    // Yb148~
    -210,
    // Tm179~
    -207,
    // Tm178~
    -207,
    // Tm177~
    -207,
    // Tm176~
    -207,
    // Tm175~
    -207,
    // Tm174~
    -207,
    // Tm173~
    -207,
    // Tm172~
    -207,
    // Tm171~
    -207,
    // Tm170~
    -207,
    // Tm169~
    -207,
    // Tm168~
    -207,
    // Tm167~
    -207,
    // Tm166~
    -207,
    // Tm165~
    -207,
    // Tm164~
    -207,
    // Tm163~
    -207,
    // Tm162~
    -207,
    // Tm161~
    -207,
    // Tm160~
    -207,
    // Tm159~
    -207,
    // Tm158~
    -207,
    // Tm157~
    -207,
    // Tm156~
    -207,
    // Tm155~
    -207,
    // Tm154~
    -207,
    // Tm153~
    -207,
    // Tm152~
    -207,
    // Tm151~
    -207,
    // Tm150~
    -207,
    // Tm149~
    -207,
    // Tm148~
    -207,
    // Tm147~
    -207,
    // Tm146~
    -207,
    // Er177~
    -204,
    // Er176~
    -204,
    // Er175~
    -204,
    // Er174~
    -204,
    // Er173~
    -204,
    // Er172~
    -204,
    // Er171~
    -204,
    // Er170~
    -204,
    // Er169~
    -204,
    // Er168~
    -204,
    // Er167~
    -204,
    // Er166~
    -204,
    // Er165~
    -204,
    // Er164~
    -204,
    // Er163~
    -204,
    // Er162~
    -204,
    // Er161~
    -204,
    // Er160~
    -204,
    // Er159~
    -204,
    // Er158~
    -204,
    // Er157~
    -204,
    // Er156~
    -204,
    // Er155~
    -204,
    // Er154~
    -204,
    // Er153~
    -204,
    // Er152~
    -204,
    // Er151~
    -204,
    // Er150~
    -204,
    // Er149~
    -204,
    // Er148~
    -204,
    // Er147~
    -204,
    // Er146~
    -204,
    // Er145~
    -204,
    // Er144~
    -204,
    // Ho175~
    -201,
    // Ho174~
    -201,
    // Ho173~
    -201,
    // Ho172~
    -201,
    // Ho171~
    -201,
    // Ho170~
    -201,
    // Ho169~
    -201,
    // Ho168~
    -201,
    // Ho167~
    -201,
    // Ho166~
    -201,
    // Ho165~
    -201,
    // Ho164~
    -201,
    // Ho163~
    -201,
    // Ho162~
    -201,
    // Ho161~
    -201,
    // Ho160~
    -201,
    // Ho159~
    -201,
    // Ho158~
    -201,
    // Ho157~
    -201,
    // Ho156~
    -201,
    // Ho155~
    -201,
    // Ho154~
    -201,
    // Ho153~
    -201,
    // Ho152~
    -201,
    // Ho151~
    -201,
    // Ho150~
    -201,
    // Ho149~
    -201,
    // Ho148~
    -201,
    // Ho147~
    -201,
    // Ho146~
    -201,
    // Ho145~
    -201,
    // Ho144~
    -201,
    // Ho143~
    -201,
    // Ho142~
    -201,
    // Dy173~
    -198,
    // Dy172~
    -198,
    // Dy171~
    -198,
    // Dy170~
    -198,
    // Dy169~
    -198,
    // Dy168~
    -198,
    // Dy167~
    -198,
    // Dy166~
    -198,
    // Dy165~
    -198,
    // Dy164~
    -198,
    // Dy163~
    -198,
    // Dy162~
    -198,
    // Dy161~
    -198,
    // Dy160~
    -198,
    // Dy159~
    -198,
    // Dy158~
    -198,
    // Dy157~
    -198,
    // Dy156~
    -198,
    // Dy155~
    -198,
    // Dy154~
    -198,
    // Dy153~
    -198,
    // Dy152~
    -198,
    // Dy151~
    -198,
    // Dy150~
    -198,
    // Dy149~
    -198,
    // Dy148~
    -198,
    // Dy147~
    -198,
    // Dy146~
    -198,
    // Dy145~
    -198,
    // Dy144~
    -198,
    // Dy143~
    -198,
    // Dy142~
    -198,
    // Dy141~
    -198,
    // Dy140~
    -198,
    // Tb171~
    -195,
    // Tb170~
    -195,
    // Tb169~
    -195,
    // Tb168~
    -195,
    // Tb167~
    -195,
    // Tb166~
    -195,
    // Tb165~
    -195,
    // Tb164~
    -195,
    // Tb163~
    -195,
    // Tb162~
    -195,
    // Tb161~
    -195,
    // Tb160~
    -195,
    // Tb159~
    -195,
    // Tb158~
    -195,
    // Tb157~
    -195,
    // Tb156~
    -195,
    // Tb155~
    -195,
    // Tb154~
    -195,
    // Tb153~
    -195,
    // Tb152~
    -195,
    // Tb151~
    -195,
    // Tb150~
    -195,
    // Tb149~
    -195,
    // Tb148~
    -195,
    // Tb147~
    -195,
    // Tb146~
    -195,
    // Tb145~
    -195,
    // Tb144~
    -195,
    // Tb143~
    -195,
    // Tb142~
    -195,
    // Tb141~
    -195,
    // Tb140~
    -195,
    // Tb139~
    -195,
    // Tb138~
    -195,
    // Gd169~
    -192,
    // Gd168~
    -192,
    // Gd167~
    -192,
    // Gd166~
    -192,
    // Gd165~
    -192,
    // Gd164~
    -192,
    // Gd163~
    -192,
    // Gd162~
    -192,
    // Gd161~
    -192,
    // Gd160~
    -192,
    // Gd159~
    -192,
    // Gd158~
    -192,
    // Gd157~
    -192,
    // Gd156~
    -192,
    // Gd155~
    -192,
    // Gd154~
    -192,
    // Gd153~
    -192,
    // Gd152~
    -192,
    // Gd151~
    -192,
    // Gd150~
    -192,
    // Gd149~
    -192,
    // Gd148~
    -192,
    // Gd147~
    -192,
    // Gd146~
    -192,
    // Gd145~
    -192,
    // Gd144~
    -192,
    // Gd143~
    -192,
    // Gd142~
    -192,
    // Gd141~
    -192,
    // Gd140~
    -192,
    // Gd139~
    -192,
    // Gd138~
    -192,
    // Gd137~
    -192,
    // Gd136~
    -192,
    // Eu167~
    -189,
    // Eu166~
    -189,
    // Eu165~
    -189,
    // Eu164~
    -189,
    // Eu163~
    -189,
    // Eu162~
    -189,
    // Eu161~
    -189,
    // Eu160~
    -189,
    // Eu159~
    -189,
    // Eu158~
    -189,
    // Eu157~
    -189,
    // Eu156~
    -189,
    // Eu155~
    -189,
    // Eu154~
    -189,
    // Eu153~
    -189,
    // Eu152~
    -189,
    // Eu151~
    -189,
    // Eu150~
    -189,
    // Eu149~
    -189,
    // Eu148~
    -189,
    // Eu147~
    -189,
    // Eu146~
    -189,
    // Eu145~
    -189,
    // Eu144~
    -189,
    // Eu143~
    -189,
    // Eu142~
    -189,
    // Eu141~
    -189,
    // Eu140~
    -189,
    // Eu139~
    -189,
    // Eu138~
    -189,
    // Eu137~
    -189,
    // Eu136~
    -189,
    // Eu135~
    -189,
    // Eu134~
    -189,
    // Eu133~
    -189,
    // Eu132~
    -189,
    // Sm165~
    -186,
    // Sm164~
    -186,
    // Sm163~
    -186,
    // Sm162~
    -186,
    // Sm161~
    -186,
    // Sm160~
    -186,
    // Sm159~
    -186,
    // Sm158~
    -186,
    // Sm157~
    -186,
    // Sm156~
    -186,
    // Sm155~
    -186,
    // Sm154~
    -186,
    // Sm153~
    -186,
    // Sm152~
    -186,
    // Sm151~
    -186,
    // Sm150~
    -186,
    // Sm149~
    -186,
    // Sm148~
    -186,
    // Sm147~
    -186,
    // Sm146~
    -186,
    // Sm145~
    -186,
    // Sm144~
    -186,
    // Sm143~
    -186,
    // Sm142~
    -186,
    // Sm141~
    -186,
    // Sm140~
    -186,
    // Sm139~
    -186,
    // Sm138~
    -186,
    // Sm137~
    -186,
    // Sm136~
    -186,
    // Sm135~
    -186,
    // Sm134~
    -186,
    // Sm133~
    -186,
    // Sm132~
    -186,
    // Sm131~
    -186,
    // Sm130~
    -186,
    // Pm163~
    -183,
    // Pm162~
    -183,
    // Pm161~
    -183,
    // Pm160~
    -183,
    // Pm159~
    -183,
    // Pm158~
    -183,
    // Pm157~
    -183,
    // Pm156~
    -183,
    // Pm155~
    -183,
    // Pm154~
    -183,
    // Pm153~
    -183,
    // Pm152~
    -183,
    // Pm151~
    -183,
    // Pm150~
    -183,
    // Pm149~
    -183,
    // Pm148~
    -183,
    // Pm147~
    -183,
    // Pm146~
    -183,
    // Pm145~
    -183,
    // Pm144~
    -183,
    // Pm143~
    -183,
    // Pm142~
    -183,
    // Pm141~
    -183,
    // Pm140~
    -183,
    // Pm139~
    -183,
    // Pm138~
    -183,
    // Pm137~
    -183,
    // Pm136~
    -183,
    // Pm135~
    -183,
    // Pm134~
    -183,
    // Pm133~
    -183,
    // Pm132~
    -183,
    // Pm131~
    -183,
    // Pm130~
    -183,
    // Pm129~
    -183,
    // Pm128~
    -183,
    // Nd161~
    -180,
    // Nd160~
    -180,
    // Nd159~
    -180,
    // Nd158~
    -180,
    // Nd157~
    -180,
    // Nd156~
    -180,
    // Nd155~
    -180,
    // Nd154~
    -180,
    // Nd153~
    -180,
    // Nd152~
    -180,
    // Nd151~
    -180,
    // Nd150~
    -180,
    // Nd149~
    -180,
    // Nd148~
    -180,
    // Nd147~
    -180,
    // Nd146~
    -180,
    // Nd145~
    -180,
    // Nd144~
    -180,
    // Nd143~
    -180,
    // Nd142~
    -180,
    // Nd141~
    -180,
    // Nd140~
    -180,
    // Nd139~
    -180,
    // Nd138~
    -180,
    // Nd137~
    -180,
    // Nd136~
    -180,
    // Nd135~
    -180,
    // Nd134~
    -180,
    // Nd133~
    -180,
    // Nd132~
    -180,
    // Nd131~
    -180,
    // Nd130~
    -180,
    // Nd129~
    -180,
    // Nd128~
    -180,
    // Nd127~
    -180,
    // Nd126~
    -180,
    // Pr159~
    -177,
    // Pr158~
    -177,
    // Pr157~
    -177,
    // Pr156~
    -177,
    // Pr155~
    -177,
    // Pr154~
    -177,
    // Pr153~
    -177,
    // Pr152~
    -177,
    // Pr151~
    -177,
    // Pr150~
    -177,
    // Pr149~
    -177,
    // Pr148~
    -177,
    // Pr147~
    -177,
    // Pr146~
    -177,
    // Pr145~
    -177,
    // Pr144~
    -177,
    // Pr143~
    -177,
    // Pr142~
    -177,
    // Pr141~
    -177,
    // Pr140~
    -177,
    // Pr139~
    -177,
    // Pr138~
    -177,
    // Pr137~
    -177,
    // Pr136~
    -177,
    // Pr135~
    -177,
    // Pr134~
    -177,
    // Pr133~
    -177,
    // Pr132~
    -177,
    // Pr131~
    -177,
    // Pr130~
    -177,
    // Pr129~
    -177,
    // Pr128~
    -177,
    // Pr127~
    -177,
    // Pr126~
    -177,
    // Pr125~
    -177,
    // Pr124~
    -177,
    // Pr123~
    -177,
    // Pr122~
    -177,
    // Pr121~
    -177,
    // Ce157~
    -174,
    // Ce156~
    -174,
    // Ce155~
    -174,
    // Ce154~
    -174,
    // Ce153~
    -174,
    // Ce152~
    -174,
    // Ce151~
    -174,
    // Ce150~
    -174,
    // Ce149~
    -174,
    // Ce148~
    -174,
    // Ce147~
    -174,
    // Ce146~
    -174,
    // Ce145~
    -174,
    // Ce144~
    -174,
    // Ce143~
    -174,
    // Ce142~
    -174,
    // Ce141~
    -174,
    // Ce140~
    -174,
    // Ce139~
    -174,
    // Ce138~
    -174,
    // Ce137~
    -174,
    // Ce136~
    -174,
    // Ce135~
    -174,
    // Ce134~
    -174,
    // Ce133~
    -174,
    // Ce132~
    -174,
    // Ce131~
    -174,
    // Ce130~
    -174,
    // Ce129~
    -174,
    // Ce128~
    -174,
    // Ce127~
    -174,
    // Ce126~
    -174,
    // Ce125~
    -174,
    // Ce124~
    -174,
    // Ce123~
    -174,
    // Ce122~
    -174,
    // Ce121~
    -174,
    // Ce120~
    -174,
    // Ce119~
    -174,
    // La155~
    -171,
    // La154~
    -171,
    // La153~
    -171,
    // La152~
    -171,
    // La151~
    -171,
    // La150~
    -171,
    // La149~
    -171,
    // La148~
    -171,
    // La147~
    -171,
    // La146~
    -171,
    // La145~
    -171,
    // La144~
    -171,
    // La143~
    -171,
    // La142~
    -171,
    // La141~
    -171,
    // La140~
    -171,
    // La139~
    -171,
    // La138~
    -171,
    // La137~
    -171,
    // La136~
    -171,
    // La135~
    -171,
    // La134~
    -171,
    // La133~
    -171,
    // La132~
    -171,
    // La131~
    -171,
    // La130~
    -171,
    // La129~
    -171,
    // La128~
    -171,
    // La127~
    -171,
    // La126~
    -171,
    // La125~
    -171,
    // La124~
    -171,
    // La123~
    -171,
    // La122~
    -171,
    // La121~
    -171,
    // La120~
    -171,
    // La119~
    -171,
    // La118~
    -171,
    // La117~
    -171,
    // Ba153~
    -168,
    // Ba152~
    -168,
    // Ba151~
    -168,
    // Ba150~
    -168,
    // Ba149~
    -168,
    // Ba148~
    -168,
    // Ba147~
    -168,
    // Ba146~
    -168,
    // Ba145~
    -168,
    // Ba144~
    -168,
    // Ba143~
    -168,
    // Ba142~
    -168,
    // Ba141~
    -168,
    // Ba140~
    -168,
    // Ba139~
    -168,
    // Ba138~
    -168,
    // Ba137~
    -168,
    // Ba136~
    -168,
    // Ba135~
    -168,
    // Ba134~
    -168,
    // Ba133~
    -168,
    // Ba132~
    -168,
    // Ba131~
    -168,
    // Ba130~
    -168,
    // Ba129~
    -168,
    // Ba128~
    -168,
    // Ba127~
    -168,
    // Ba126~
    -168,
    // Ba125~
    -168,
    // Ba124~
    -168,
    // Ba123~
    -168,
    // Ba122~
    -168,
    // Ba121~
    -168,
    // Ba120~
    -168,
    // Ba119~
    -168,
    // Ba118~
    -168,
    // Ba117~
    -168,
    // Ba116~
    -168,
    // Ba115~
    -168,
    // Ba114~
    -168,
    // Cs151~
    -165,
    // Cs150~
    -165,
    // Cs149~
    -165,
    // Cs148~
    -165,
    // Cs147~
    -165,
    // Cs146~
    -165,
    // Cs145~
    -165,
    // Cs144~
    -165,
    // Cs143~
    -165,
    // Cs142~
    -165,
    // Cs141~
    -165,
    // Cs140~
    -165,
    // Cs139~
    -165,
    // Cs138~
    -165,
    // Cs137~
    -165,
    // Cs136~
    -165,
    // Cs135~
    -165,
    // Cs134~
    -165,
    // Cs133~
    -165,
    // Cs132~
    -165,
    // Cs131~
    -165,
    // Cs130~
    -165,
    // Cs129~
    -165,
    // Cs128~
    -165,
    // Cs127~
    -165,
    // Cs126~
    -165,
    // Cs125~
    -165,
    // Cs124~
    -165,
    // Cs123~
    -165,
    // Cs122~
    -165,
    // Cs121~
    -165,
    // Cs120~
    -165,
    // Cs119~
    -165,
    // Cs118~
    -165,
    // Cs117~
    -165,
    // Cs116~
    -165,
    // Cs115~
    -165,
    // Cs114~
    -165,
    // Cs113~
    -165,
    // Cs112~
    -165,
    // Xe147~
    -162,
    // Xe146~
    -162,
    // Xe145~
    -162,
    // Xe144~
    -162,
    // Xe143~
    -162,
    // Xe142~
    -162,
    // Xe141~
    -162,
    // Xe140~
    -162,
    // Xe139~
    -162,
    // Xe138~
    -162,
    // Xe137~
    -162,
    // Xe136~
    -162,
    // Xe135~
    -162,
    // Xe134~
    -162,
    // Xe133~
    -162,
    // Xe132~
    -162,
    // Xe131~
    -162,
    // Xe130~
    -162,
    // Xe129~
    -162,
    // Xe128~
    -162,
    // Xe127~
    -162,
    // Xe126~
    -162,
    // Xe125~
    -162,
    // Xe124~
    -162,
    // Xe123~
    -162,
    // Xe122~
    -162,
    // Xe121~
    -162,
    // Xe120~
    -162,
    // Xe119~
    -162,
    // Xe118~
    -162,
    // Xe117~
    -162,
    // Xe116~
    -162,
    // Xe115~
    -162,
    // Xe114~
    -162,
    // Xe113~
    -162,
    // Xe112~
    -162,
    // Xe111~
    -162,
    // Xe110~
    -162,
    // I144~
    -159,
    // I143~
    -159,
    // I142~
    -159,
    // I141~
    -159,
    // I140~
    -159,
    // I139~
    -159,
    // I138~
    -159,
    // I137~
    -159,
    // I136~
    -159,
    // I135~
    -159,
    // I134~
    -159,
    // I133~
    -159,
    // I132~
    -159,
    // I131~
    -159,
    // I130~
    -159,
    // I129~
    -159,
    // I128~
    -159,
    // I127~
    -159,
    // I126~
    -159,
    // I125~
    -159,
    // I124~
    -159,
    // I123~
    -159,
    // I122~
    -159,
    // I121~
    -159,
    // I120~
    -159,
    // I119~
    -159,
    // I118~
    -159,
    // I117~
    -159,
    // I116~
    -159,
    // I115~
    -159,
    // I114~
    -159,
    // I113~
    -159,
    // I112~
    -159,
    // I111~
    -159,
    // I110~
    -159,
    // I109~
    -159,
    // I108~
    -159,
    // Te142~
    -156,
    // Te141~
    -156,
    // Te140~
    -156,
    // Te139~
    -156,
    // Te138~
    -156,
    // Te137~
    -156,
    // Te136~
    -156,
    // Te135~
    -156,
    // Te134~
    -156,
    // Te133~
    -156,
    // Te132~
    -156,
    // Te131~
    -156,
    // Te130~
    -156,
    // Te129~
    -156,
    // Te128~
    -156,
    // Te127~
    -156,
    // Te126~
    -156,
    // Te125~
    -156,
    // Te124~
    -156,
    // Te123~
    -156,
    // Te122~
    -156,
    // Te121~
    -156,
    // Te120~
    -156,
    // Te119~
    -156,
    // Te118~
    -156,
    // Te117~
    -156,
    // Te116~
    -156,
    // Te115~
    -156,
    // Te114~
    -156,
    // Te113~
    -156,
    // Te112~
    -156,
    // Te111~
    -156,
    // Te110~
    -156,
    // Te109~
    -156,
    // Te108~
    -156,
    // Te107~
    -156,
    // Te106~
    -156,
    // Sb139~
    -153,
    // Sb138~
    -153,
    // Sb137~
    -153,
    // Sb136~
    -153,
    // Sb135~
    -153,
    // Sb134~
    -153,
    // Sb133~
    -153,
    // Sb132~
    -153,
    // Sb131~
    -153,
    // Sb130~
    -153,
    // Sb129~
    -153,
    // Sb128~
    -153,
    // Sb127~
    -153,
    // Sb126~
    -153,
    // Sb125~
    -153,
    // Sb124~
    -153,
    // Sb123~
    -153,
    // Sb122~
    -153,
    // Sb121~
    -153,
    // Sb120~
    -153,
    // Sb119~
    -153,
    // Sb118~
    -153,
    // Sb117~
    -153,
    // Sb116~
    -153,
    // Sb115~
    -153,
    // Sb114~
    -153,
    // Sb113~
    -153,
    // Sb112~
    -153,
    // Sb111~
    -153,
    // Sb110~
    -153,
    // Sb109~
    -153,
    // Sb108~
    -153,
    // Sb107~
    -153,
    // Sb106~
    -153,
    // Sb105~
    -153,
    // Sb104~
    -153,
    // Sb103~
    -153,
    // Sn137~
    -150,
    // Sn136~
    -150,
    // Sn135~
    -150,
    // Sn134~
    -150,
    // Sn133~
    -150,
    // Sn132~
    -150,
    // Sn131~
    -150,
    // Sn130~
    -150,
    // Sn129~
    -150,
    // Sn128~
    -150,
    // Sn127~
    -150,
    // Sn126~
    -150,
    // Sn125~
    -150,
    // Sn124~
    -150,
    // Sn123~
    -150,
    // Sn122~
    -150,
    // Sn121~
    -150,
    // Sn120~
    -150,
    // Sn119~
    -150,
    // Sn118~
    -150,
    // Sn117~
    -150,
    // Sn116~
    -150,
    // Sn115~
    -150,
    // Sn114~
    -150,
    // Sn113~
    -150,
    // Sn112~
    -150,
    // Sn111~
    -150,
    // Sn110~
    -150,
    // Sn109~
    -150,
    // Sn108~
    -150,
    // Sn107~
    -150,
    // Sn106~
    -150,
    // Sn105~
    -150,
    // Sn104~
    -150,
    // Sn103~
    -150,
    // Sn102~
    -150,
    // Sn101~
    -150,
    // Sn100~
    -150,
    // In134~
    -147,
    // In133~
    -147,
    // In132~
    -147,
    // In131~
    -147,
    // In130~
    -147,
    // In129~
    -147,
    // In128~
    -147,
    // In127~
    -147,
    // In126~
    -147,
    // In125~
    -147,
    // In124~
    -147,
    // In123~
    -147,
    // In122~
    -147,
    // In121~
    -147,
    // In120~
    -147,
    // In119~
    -147,
    // In118~
    -147,
    // In117~
    -147,
    // In116~
    -147,
    // In115~
    -147,
    // In114~
    -147,
    // In113~
    -147,
    // In112~
    -147,
    // In111~
    -147,
    // In110~
    -147,
    // In109~
    -147,
    // In108~
    -147,
    // In107~
    -147,
    // In106~
    -147,
    // In105~
    -147,
    // In104~
    -147,
    // In103~
    -147,
    // In102~
    -147,
    // In101~
    -147,
    // In100~
    -147,
    // In99~
    -147,
    // In98~
    -147,
    // Cd130~
    -144,
    // Cd129~
    -144,
    // Cd128~
    -144,
    // Cd127~
    -144,
    // Cd126~
    -144,
    // Cd125~
    -144,
    // Cd124~
    -144,
    // Cd123~
    -144,
    // Cd122~
    -144,
    // Cd121~
    -144,
    // Cd120~
    -144,
    // Cd119~
    -144,
    // Cd118~
    -144,
    // Cd117~
    -144,
    // Cd116~
    -144,
    // Cd115~
    -144,
    // Cd114~
    -144,
    // Cd113~
    -144,
    // Cd112~
    -144,
    // Cd111~
    -144,
    // Cd110~
    -144,
    // Cd109~
    -144,
    // Cd108~
    -144,
    // Cd107~
    -144,
    // Cd106~
    -144,
    // Cd105~
    -144,
    // Cd104~
    -144,
    // Cd103~
    -144,
    // Cd102~
    -144,
    // Cd101~
    -144,
    // Cd100~
    -144,
    // Cd99~
    -144,
    // Cd98~
    -144,
    // Cd97~
    -144,
    // Cd96~
    -144,
    // Ag127~
    -141,
    // Ag126~
    -141,
    // Ag125~
    -141,
    // Ag124~
    -141,
    // Ag123~
    -141,
    // Ag122~
    -141,
    // Ag121~
    -141,
    // Ag120~
    -141,
    // Ag119~
    -141,
    // Ag118~
    -141,
    // Ag117~
    -141,
    // Ag116~
    -141,
    // Ag115~
    -141,
    // Ag114~
    -141,
    // Ag113~
    -141,
    // Ag112~
    -141,
    // Ag111~
    -141,
    // Ag110~
    -141,
    // Ag109~
    -141,
    // Ag108~
    -141,
    // Ag107~
    -141,
    // Ag106~
    -141,
    // Ag105~
    -141,
    // Ag104~
    -141,
    // Ag103~
    -141,
    // Ag102~
    -141,
    // Ag101~
    -141,
    // Ag100~
    -141,
    // Ag99~
    -141,
    // Ag98~
    -141,
    // Ag97~
    -141,
    // Ag96~
    -141,
    // Ag95~
    -141,
    // Ag94~
    -141,
    // Pd123~
    -138,
    // Pd122~
    -138,
    // Pd121~
    -138,
    // Pd120~
    -138,
    // Pd119~
    -138,
    // Pd118~
    -138,
    // Pd117~
    -138,
    // Pd116~
    -138,
    // Pd115~
    -138,
    // Pd114~
    -138,
    // Pd113~
    -138,
    // Pd112~
    -138,
    // Pd111~
    -138,
    // Pd110~
    -138,
    // Pd109~
    -138,
    // Pd108~
    -138,
    // Pd107~
    -138,
    // Pd106~
    -138,
    // Pd105~
    -138,
    // Pd104~
    -138,
    // Pd103~
    -138,
    // Pd102~
    -138,
    // Pd101~
    -138,
    // Pd100~
    -138,
    // Pd99~
    -138,
    // Pd98~
    -138,
    // Pd97~
    -138,
    // Pd96~
    -138,
    // Pd95~
    -138,
    // Pd94~
    -138,
    // Pd93~
    -138,
    // Pd92~
    -138,
    // Pd91~
    -138,
    // Rh121~
    -135,
    // Rh120~
    -135,
    // Rh119~
    -135,
    // Rh118~
    -135,
    // Rh117~
    -135,
    // Rh116~
    -135,
    // Rh115~
    -135,
    // Rh114~
    -135,
    // Rh113~
    -135,
    // Rh112~
    -135,
    // Rh111~
    -135,
    // Rh110~
    -135,
    // Rh109~
    -135,
    // Rh108~
    -135,
    // Rh107~
    -135,
    // Rh106~
    -135,
    // Rh105~
    -135,
    // Rh104~
    -135,
    // Rh103~
    -135,
    // Rh102~
    -135,
    // Rh101~
    -135,
    // Rh100~
    -135,
    // Rh99~
    -135,
    // Rh98~
    -135,
    // Rh97~
    -135,
    // Rh96~
    -135,
    // Rh95~
    -135,
    // Rh94~
    -135,
    // Rh93~
    -135,
    // Rh92~
    -135,
    // Rh91~
    -135,
    // Rh90~
    -135,
    // Rh89~
    -135,
    // Ru118~
    -132,
    // Ru117~
    -132,
    // Ru116~
    -132,
    // Ru115~
    -132,
    // Ru114~
    -132,
    // Ru113~
    -132,
    // Ru112~
    -132,
    // Ru111~
    -132,
    // Ru110~
    -132,
    // Ru109~
    -132,
    // Ru108~
    -132,
    // Ru107~
    -132,
    // Ru106~
    -132,
    // Ru105~
    -132,
    // Ru104~
    -132,
    // Ru103~
    -132,
    // Ru102~
    -132,
    // Ru101~
    -132,
    // Ru100~
    -132,
    // Ru99~
    -132,
    // Ru98~
    -132,
    // Ru97~
    -132,
    // Ru96~
    -132,
    // Ru95~
    -132,
    // Ru94~
    -132,
    // Ru93~
    -132,
    // Ru92~
    -132,
    // Ru91~
    -132,
    // Ru90~
    -132,
    // Ru89~
    -132,
    // Ru88~
    -132,
    // Ru87~
    -132,
    // Tc115~
    -129,
    // Tc114~
    -129,
    // Tc113~
    -129,
    // Tc112~
    -129,
    // Tc111~
    -129,
    // Tc110~
    -129,
    // Tc109~
    -129,
    // Tc108~
    -129,
    // Tc107~
    -129,
    // Tc106~
    -129,
    // Tc105~
    -129,
    // Tc104~
    -129,
    // Tc103~
    -129,
    // Tc102~
    -129,
    // Tc101~
    -129,
    // Tc100~
    -129,
    // Tc99~
    -129,
    // Tc98~
    -129,
    // Tc97~
    -129,
    // Tc96~
    -129,
    // Tc95~
    -129,
    // Tc94~
    -129,
    // Tc93~
    -129,
    // Tc92~
    -129,
    // Tc91~
    -129,
    // Tc90~
    -129,
    // Tc89~
    -129,
    // Tc88~
    -129,
    // Tc87~
    -129,
    // Tc86~
    -129,
    // Tc85~
    -129,
    // Mo113~
    -126,
    // Mo112~
    -126,
    // Mo111~
    -126,
    // Mo110~
    -126,
    // Mo109~
    -126,
    // Mo108~
    -126,
    // Mo107~
    -126,
    // Mo106~
    -126,
    // Mo105~
    -126,
    // Mo104~
    -126,
    // Mo103~
    -126,
    // Mo102~
    -126,
    // Mo101~
    -126,
    // Mo100~
    -126,
    // Mo99~
    -126,
    // Mo98~
    -126,
    // Mo97~
    -126,
    // Mo96~
    -126,
    // Mo95~
    -126,
    // Mo94~
    -126,
    // Mo93~
    -126,
    // Mo92~
    -126,
    // Mo91~
    -126,
    // Mo90~
    -126,
    // Mo89~
    -126,
    // Mo88~
    -126,
    // Mo87~
    -126,
    // Mo86~
    -126,
    // Mo85~
    -126,
    // Mo84~
    -126,
    // Mo83~
    -126,
    // Nb110~
    -123,
    // Nb109~
    -123,
    // Nb108~
    -123,
    // Nb107~
    -123,
    // Nb106~
    -123,
    // Nb105~
    -123,
    // Nb104~
    -123,
    // Nb103~
    -123,
    // Nb102~
    -123,
    // Nb101~
    -123,
    // Nb100~
    -123,
    // Nb99~
    -123,
    // Nb98~
    -123,
    // Nb97~
    -123,
    // Nb96~
    -123,
    // Nb95~
    -123,
    // Nb94~
    -123,
    // Nb93~
    -123,
    // Nb92~
    -123,
    // Nb91~
    -123,
    // Nb90~
    -123,
    // Nb89~
    -123,
    // Nb88~
    -123,
    // Nb87~
    -123,
    // Nb86~
    -123,
    // Nb85~
    -123,
    // Nb84~
    -123,
    // Nb83~
    -123,
    // Nb82~
    -123,
    // Nb81~
    -123,
    // Zr108~
    -120,
    // Zr107~
    -120,
    // Zr106~
    -120,
    // Zr105~
    -120,
    // Zr104~
    -120,
    // Zr103~
    -120,
    // Zr102~
    -120,
    // Zr101~
    -120,
    // Zr100~
    -120,
    // Zr99~
    -120,
    // Zr98~
    -120,
    // Zr97~
    -120,
    // Zr96~
    -120,
    // Zr95~
    -120,
    // Zr94~
    -120,
    // Zr93~
    -120,
    // Zr92~
    -120,
    // Zr91~
    -120,
    // Zr90~
    -120,
    // Zr89~
    -120,
    // Zr88~
    -120,
    // Zr87~
    -120,
    // Zr86~
    -120,
    // Zr85~
    -120,
    // Zr84~
    -120,
    // Zr83~
    -120,
    // Zr82~
    -120,
    // Zr81~
    -120,
    // Zr80~
    -120,
    // Zr79~
    -120,
    // Y106~
    -117,
    // Y105~
    -117,
    // Y104~
    -117,
    // Y103~
    -117,
    // Y102~
    -117,
    // Y101~
    -117,
    // Y100~
    -117,
    // Y99~
    -117,
    // Y98~
    -117,
    // Y97~
    -117,
    // Y96~
    -117,
    // Y95~
    -117,
    // Y94~
    -117,
    // Y93~
    -117,
    // Y92~
    -117,
    // Y91~
    -117,
    // Y90~
    -117,
    // Y89~
    -117,
    // Y88~
    -117,
    // Y87~
    -117,
    // Y86~
    -117,
    // Y85~
    -117,
    // Y84~
    -117,
    // Y83~
    -117,
    // Y82~
    -117,
    // Y81~
    -117,
    // Y80~
    -117,
    // Y79~
    -117,
    // Y78~
    -117,
    // Y77~
    -117,
    // Sr104~
    -114,
    // Sr103~
    -114,
    // Sr102~
    -114,
    // Sr101~
    -114,
    // Sr100~
    -114,
    // Sr99~
    -114,
    // Sr98~
    -114,
    // Sr97~
    -114,
    // Sr96~
    -114,
    // Sr95~
    -114,
    // Sr94~
    -114,
    // Sr93~
    -114,
    // Sr92~
    -114,
    // Sr91~
    -114,
    // Sr90~
    -114,
    // Sr89~
    -114,
    // Sr88~
    -114,
    // Sr87~
    -114,
    // Sr86~
    -114,
    // Sr85~
    -114,
    // Sr84~
    -114,
    // Sr83~
    -114,
    // Sr82~
    -114,
    // Sr81~
    -114,
    // Sr80~
    -114,
    // Sr79~
    -114,
    // Sr78~
    -114,
    // Sr77~
    -114,
    // Sr76~
    -114,
    // Sr75~
    -114,
    // Sr74~
    -114,
    // Sr73~
    -114,
    // Rb102~
    -111,
    // Rb101~
    -111,
    // Rb100~
    -111,
    // Rb99~
    -111,
    // Rb98~
    -111,
    // Rb97~
    -111,
    // Rb96~
    -111,
    // Rb95~
    -111,
    // Rb94~
    -111,
    // Rb93~
    -111,
    // Rb92~
    -111,
    // Rb91~
    -111,
    // Rb90~
    -111,
    // Rb89~
    -111,
    // Rb88~
    -111,
    // Rb87~
    -111,
    // Rb86~
    -111,
    // Rb85~
    -111,
    // Rb84~
    -111,
    // Rb83~
    -111,
    // Rb82~
    -111,
    // Rb81~
    -111,
    // Rb80~
    -111,
    // Rb79~
    -111,
    // Rb78~
    -111,
    // Rb77~
    -111,
    // Rb76~
    -111,
    // Rb75~
    -111,
    // Rb74~
    -111,
    // Rb73~
    -111,
    // Rb72~
    -111,
    // Rb71~
    -111,
    // Kr97~
    -108,
    // Kr96~
    -108,
    // Kr95~
    -108,
    // Kr94~
    -108,
    // Kr93~
    -108,
    // Kr92~
    -108,
    // Kr91~
    -108,
    // Kr90~
    -108,
    // Kr89~
    -108,
    // Kr88~
    -108,
    // Kr87~
    -108,
    // Kr86~
    -108,
    // Kr85~
    -108,
    // Kr84~
    -108,
    // Kr83~
    -108,
    // Kr82~
    -108,
    // Kr81~
    -108,
    // Kr80~
    -108,
    // Kr79~
    -108,
    // Kr78~
    -108,
    // Kr77~
    -108,
    // Kr76~
    -108,
    // Kr75~
    -108,
    // Kr74~
    -108,
    // Kr73~
    -108,
    // Kr72~
    -108,
    // Kr71~
    -108,
    // Kr70~
    -108,
    // Kr69~
    -108,
    // Br94~
    -105,
    // Br93~
    -105,
    // Br92~
    -105,
    // Br91~
    -105,
    // Br90~
    -105,
    // Br89~
    -105,
    // Br88~
    -105,
    // Br87~
    -105,
    // Br86~
    -105,
    // Br85~
    -105,
    // Br84~
    -105,
    // Br83~
    -105,
    // Br82~
    -105,
    // Br81~
    -105,
    // Br80~
    -105,
    // Br79~
    -105,
    // Br78~
    -105,
    // Br77~
    -105,
    // Br76~
    -105,
    // Br75~
    -105,
    // Br74~
    -105,
    // Br73~
    -105,
    // Br72~
    -105,
    // Br71~
    -105,
    // Br70~
    -105,
    // Br69~
    -105,
    // Br68~
    -105,
    // Br67~
    -105,
    // Se92~
    -102,
    // Se91~
    -102,
    // Se90~
    -102,
    // Se89~
    -102,
    // Se88~
    -102,
    // Se87~
    -102,
    // Se86~
    -102,
    // Se85~
    -102,
    // Se84~
    -102,
    // Se83~
    -102,
    // Se82~
    -102,
    // Se81~
    -102,
    // Se80~
    -102,
    // Se79~
    -102,
    // Se78~
    -102,
    // Se77~
    -102,
    // Se76~
    -102,
    // Se75~
    -102,
    // Se74~
    -102,
    // Se73~
    -102,
    // Se72~
    -102,
    // Se71~
    -102,
    // Se70~
    -102,
    // Se69~
    -102,
    // Se68~
    -102,
    // Se67~
    -102,
    // Se66~
    -102,
    // Se65~
    -102,
    // As89~
    -99,
    // As88~
    -99,
    // As87~
    -99,
    // As86~
    -99,
    // As85~
    -99,
    // As84~
    -99,
    // As83~
    -99,
    // As82~
    -99,
    // As81~
    -99,
    // As80~
    -99,
    // As79~
    -99,
    // As78~
    -99,
    // As77~
    -99,
    // As76~
    -99,
    // As75~
    -99,
    // As74~
    -99,
    // As73~
    -99,
    // As72~
    -99,
    // As71~
    -99,
    // As70~
    -99,
    // As69~
    -99,
    // As68~
    -99,
    // As67~
    -99,
    // As66~
    -99,
    // As65~
    -99,
    // As64~
    -99,
    // As63~
    -99,
    // As62~
    -99,
    // As61~
    -99,
    // As60~
    -99,
    // Ge86~
    -96,
    // Ge85~
    -96,
    // Ge84~
    -96,
    // Ge83~
    -96,
    // Ge82~
    -96,
    // Ge81~
    -96,
    // Ge80~
    -96,
    // Ge79~
    -96,
    // Ge78~
    -96,
    // Ge77~
    -96,
    // Ge76~
    -96,
    // Ge75~
    -96,
    // Ge74~
    -96,
    // Ge73~
    -96,
    // Ge72~
    -96,
    // Ge71~
    -96,
    // Ge70~
    -96,
    // Ge69~
    -96,
    // Ge68~
    -96,
    // Ge67~
    -96,
    // Ge66~
    -96,
    // Ge65~
    -96,
    // Ge64~
    -96,
    // Ge63~
    -96,
    // Ge62~
    -96,
    // Ge61~
    -96,
    // Ge60~
    -96,
    // Ge59~
    -96,
    // Ge58~
    -96,
    // Ga84~
    -93,
    // Ga83~
    -93,
    // Ga82~
    -93,
    // Ga81~
    -93,
    // Ga80~
    -93,
    // Ga79~
    -93,
    // Ga78~
    -93,
    // Ga77~
    -93,
    // Ga76~
    -93,
    // Ga75~
    -93,
    // Ga74~
    -93,
    // Ga73~
    -93,
    // Ga72~
    -93,
    // Ga71~
    -93,
    // Ga70~
    -93,
    // Ga69~
    -93,
    // Ga68~
    -93,
    // Ga67~
    -93,
    // Ga66~
    -93,
    // Ga65~
    -93,
    // Ga64~
    -93,
    // Ga63~
    -93,
    // Ga62~
    -93,
    // Ga61~
    -93,
    // Ga60~
    -93,
    // Ga59~
    -93,
    // Ga58~
    -93,
    // Ga57~
    -93,
    // Ga56~
    -93,
    // Zn82~
    -90,
    // Zn81~
    -90,
    // Zn80~
    -90,
    // Zn79~
    -90,
    // Zn78~
    -90,
    // Zn77~
    -90,
    // Zn76~
    -90,
    // Zn75~
    -90,
    // Zn74~
    -90,
    // Zn73~
    -90,
    // Zn72~
    -90,
    // Zn71~
    -90,
    // Zn70~
    -90,
    // Zn69~
    -90,
    // Zn68~
    -90,
    // Zn67~
    -90,
    // Zn66~
    -90,
    // Zn65~
    -90,
    // Zn64~
    -90,
    // Zn63~
    -90,
    // Zn62~
    -90,
    // Zn61~
    -90,
    // Zn60~
    -90,
    // Zn59~
    -90,
    // Zn58~
    -90,
    // Zn57~
    -90,
    // Zn56~
    -90,
    // Zn55~
    -90,
    // Zn54~
    -90,
    // Cu80~
    -87,
    // Cu79~
    -87,
    // Cu78~
    -87,
    // Cu77~
    -87,
    // Cu76~
    -87,
    // Cu75~
    -87,
    // Cu74~
    -87,
    // Cu73~
    -87,
    // Cu72~
    -87,
    // Cu71~
    -87,
    // Cu70~
    -87,
    // Cu69~
    -87,
    // Cu68~
    -87,
    // Cu67~
    -87,
    // Cu66~
    -87,
    // Cu65~
    -87,
    // Cu64~
    -87,
    // Cu63~
    -87,
    // Cu62~
    -87,
    // Cu61~
    -87,
    // Cu60~
    -87,
    // Cu59~
    -87,
    // Cu58~
    -87,
    // Cu57~
    -87,
    // Cu56~
    -87,
    // Cu55~
    -87,
    // Cu54~
    -87,
    // Cu53~
    -87,
    // Cu52~
    -87,
    // Ni78~
    -84,
    // Ni77~
    -84,
    // Ni76~
    -84,
    // Ni75~
    -84,
    // Ni74~
    -84,
    // Ni73~
    -84,
    // Ni72~
    -84,
    // Ni71~
    -84,
    // Ni70~
    -84,
    // Ni69~
    -84,
    // Ni68~
    -84,
    // Ni67~
    -84,
    // Ni66~
    -84,
    // Ni65~
    -84,
    // Ni64~
    -84,
    // Ni63~
    -84,
    // Ni62~
    -84,
    // Ni61~
    -84,
    // Ni60~
    -84,
    // Ni59~
    -84,
    // Ni58~
    -84,
    // Ni57~
    -84,
    // Ni56~
    -84,
    // Ni55~
    -84,
    // Ni54~
    -84,
    // Ni53~
    -84,
    // Ni52~
    -84,
    // Ni51~
    -84,
    // Ni50~
    -84,
    // Co72~
    -81,
    // Co71~
    -81,
    // Co70~
    -81,
    // Co69~
    -81,
    // Co68~
    -81,
    // Co67~
    -81,
    // Co66~
    -81,
    // Co65~
    -81,
    // Co64~
    -81,
    // Co63~
    -81,
    // Co62~
    -81,
    // Co61~
    -81,
    // Co60~
    -81,
    // Co59~
    -81,
    // Co58~
    -81,
    // Co57~
    -81,
    // Co56~
    -81,
    // Co55~
    -81,
    // Co54~
    -81,
    // Co53~
    -81,
    // Co52~
    -81,
    // Co51~
    -81,
    // Co50~
    -81,
    // Co49~
    -81,
    // Co48~
    -81,
    // Fe69~
    -78,
    // Fe68~
    -78,
    // Fe67~
    -78,
    // Fe66~
    -78,
    // Fe65~
    -78,
    // Fe64~
    -78,
    // Fe63~
    -78,
    // Fe62~
    -78,
    // Fe61~
    -78,
    // Fe60~
    -78,
    // Fe59~
    -78,
    // Fe58~
    -78,
    // Fe57~
    -78,
    // Fe56~
    -78,
    // Fe55~
    -78,
    // Fe54~
    -78,
    // Fe53~
    -78,
    // Fe52~
    -78,
    // Fe51~
    -78,
    // Fe50~
    -78,
    // Fe49~
    -78,
    // Fe48~
    -78,
    // Fe47~
    -78,
    // Fe46~
    -78,
    // Fe45~
    -78,
    // Mn67~
    -75,
    // Mn66~
    -75,
    // Mn65~
    -75,
    // Mn64~
    -75,
    // Mn63~
    -75,
    // Mn62~
    -75,
    // Mn61~
    -75,
    // Mn60~
    -75,
    // Mn59~
    -75,
    // Mn58~
    -75,
    // Mn57~
    -75,
    // Mn56~
    -75,
    // Mn55~
    -75,
    // Mn54~
    -75,
    // Mn53~
    -75,
    // Mn52~
    -75,
    // Mn51~
    -75,
    // Mn50~
    -75,
    // Mn49~
    -75,
    // Mn48~
    -75,
    // Mn47~
    -75,
    // Mn46~
    -75,
    // Mn45~
    -75,
    // Mn44~
    -75,
    // Cr65~
    -72,
    // Cr64~
    -72,
    // Cr63~
    -72,
    // Cr62~
    -72,
    // Cr61~
    -72,
    // Cr60~
    -72,
    // Cr59~
    -72,
    // Cr58~
    -72,
    // Cr57~
    -72,
    // Cr56~
    -72,
    // Cr55~
    -72,
    // Cr54~
    -72,
    // Cr53~
    -72,
    // Cr52~
    -72,
    // Cr51~
    -72,
    // Cr50~
    -72,
    // Cr49~
    -72,
    // Cr48~
    -72,
    // Cr47~
    -72,
    // Cr46~
    -72,
    // Cr45~
    -72,
    // Cr44~
    -72,
    // Cr43~
    -72,
    // Cr42~
    -72,
    // V63~
    -69,
    // V62~
    -69,
    // V61~
    -69,
    // V60~
    -69,
    // V59~
    -69,
    // V58~
    -69,
    // V57~
    -69,
    // V56~
    -69,
    // V55~
    -69,
    // V54~
    -69,
    // V53~
    -69,
    // V52~
    -69,
    // V51~
    -69,
    // V50~
    -69,
    // V49~
    -69,
    // V48~
    -69,
    // V47~
    -69,
    // V46~
    -69,
    // V45~
    -69,
    // V44~
    -69,
    // V43~
    -69,
    // V42~
    -69,
    // V41~
    -69,
    // V40~
    -69,
    // Ti61~
    -66,
    // Ti60~
    -66,
    // Ti59~
    -66,
    // Ti58~
    -66,
    // Ti57~
    -66,
    // Ti56~
    -66,
    // Ti55~
    -66,
    // Ti54~
    -66,
    // Ti53~
    -66,
    // Ti52~
    -66,
    // Ti51~
    -66,
    // Ti50~
    -66,
    // Ti49~
    -66,
    // Ti48~
    -66,
    // Ti47~
    -66,
    // Ti46~
    -66,
    // Ti45~
    -66,
    // Ti44~
    -66,
    // Ti43~
    -66,
    // Ti42~
    -66,
    // Ti41~
    -66,
    // Ti40~
    -66,
    // Ti39~
    -66,
    // Ti38~
    -66,
    // Sc59~
    -63,
    // Sc58~
    -63,
    // Sc57~
    -63,
    // Sc56~
    -63,
    // Sc55~
    -63,
    // Sc54~
    -63,
    // Sc53~
    -63,
    // Sc52~
    -63,
    // Sc51~
    -63,
    // Sc50~
    -63,
    // Sc49~
    -63,
    // Sc48~
    -63,
    // Sc47~
    -63,
    // Sc46~
    -63,
    // Sc45~
    -63,
    // Sc44~
    -63,
    // Sc43~
    -63,
    // Sc42~
    -63,
    // Sc41~
    -63,
    // Sc40~
    -63,
    // Sc39~
    -63,
    // Sc38~
    -63,
    // Sc37~
    -63,
    // Sc36~
    -63,
    // Ca57~
    -60,
    // Ca56~
    -60,
    // Ca55~
    -60,
    // Ca54~
    -60,
    // Ca53~
    -60,
    // Ca52~
    -60,
    // Ca51~
    -60,
    // Ca50~
    -60,
    // Ca49~
    -60,
    // Ca48~
    -60,
    // Ca47~
    -60,
    // Ca46~
    -60,
    // Ca45~
    -60,
    // Ca44~
    -60,
    // Ca43~
    -60,
    // Ca42~
    -60,
    // Ca41~
    -60,
    // Ca40~
    -60,
    // Ca39~
    -60,
    // Ca38~
    -60,
    // Ca37~
    -60,
    // Ca36~
    -60,
    // Ca35~
    -60,
    // Ca34~
    -60,
    // K55~
    -57,
    // K54~
    -57,
    // K53~
    -57,
    // K52~
    -57,
    // K51~
    -57,
    // K50~
    -57,
    // K49~
    -57,
    // K48~
    -57,
    // K47~
    -57,
    // K46~
    -57,
    // K45~
    -57,
    // K44~
    -57,
    // K43~
    -57,
    // K42~
    -57,
    // K41~
    -57,
    // K40~
    -57,
    // K39~
    -57,
    // K38~
    -57,
    // K37~
    -57,
    // K36~
    -57,
    // K35~
    -57,
    // K34~
    -57,
    // K33~
    -57,
    // K32~
    -57,
    // Ar53~
    -54,
    // Ar52~
    -54,
    // Ar51~
    -54,
    // Ar50~
    -54,
    // Ar49~
    -54,
    // Ar48~
    -54,
    // Ar47~
    -54,
    // Ar46~
    -54,
    // Ar45~
    -54,
    // Ar44~
    -54,
    // Ar43~
    -54,
    // Ar42~
    -54,
    // Ar41~
    -54,
    // Ar40~
    -54,
    // Ar39~
    -54,
    // Ar38~
    -54,
    // Ar37~
    -54,
    // Ar36~
    -54,
    // Ar35~
    -54,
    // Ar34~
    -54,
    // Ar33~
    -54,
    // Ar32~
    -54,
    // Ar31~
    -54,
    // Ar30~
    -54,
    // Cl51~
    -51,
    // Cl50~
    -51,
    // Cl49~
    -51,
    // Cl48~
    -51,
    // Cl47~
    -51,
    // Cl46~
    -51,
    // Cl45~
    -51,
    // Cl44~
    -51,
    // Cl43~
    -51,
    // Cl42~
    -51,
    // Cl41~
    -51,
    // Cl40~
    -51,
    // Cl39~
    -51,
    // Cl38~
    -51,
    // Cl37~
    -51,
    // Cl36~
    -51,
    // Cl35~
    -51,
    // Cl34~
    -51,
    // Cl33~
    -51,
    // Cl32~
    -51,
    // Cl31~
    -51,
    // Cl30~
    -51,
    // Cl29~
    -51,
    // Cl28~
    -51,
    // S49~
    -48,
    // S48~
    -48,
    // S47~
    -48,
    // S46~
    -48,
    // S45~
    -48,
    // S44~
    -48,
    // S43~
    -48,
    // S42~
    -48,
    // S41~
    -48,
    // S40~
    -48,
    // S39~
    -48,
    // S38~
    -48,
    // S37~
    -48,
    // S36~
    -48,
    // S35~
    -48,
    // S34~
    -48,
    // S33~
    -48,
    // S32~
    -48,
    // S31~
    -48,
    // S30~
    -48,
    // S29~
    -48,
    // S28~
    -48,
    // S27~
    -48,
    // S26~
    -48,
    // P46~
    -45,
    // P45~
    -45,
    // P44~
    -45,
    // P43~
    -45,
    // P42~
    -45,
    // P41~
    -45,
    // P40~
    -45,
    // P39~
    -45,
    // P38~
    -45,
    // P37~
    -45,
    // P36~
    -45,
    // P35~
    -45,
    // P34~
    -45,
    // P33~
    -45,
    // P32~
    -45,
    // P31~
    -45,
    // P30~
    -45,
    // P29~
    -45,
    // P28~
    -45,
    // P27~
    -45,
    // P26~
    -45,
    // P25~
    -45,
    // P24~
    -45,
    // Si42~
    -42,
    // Si41~
    -42,
    // Si40~
    -42,
    // Si39~
    -42,
    // Si38~
    -42,
    // Si37~
    -42,
    // Si36~
    -42,
    // Si35~
    -42,
    // Si34~
    -42,
    // Si33~
    -42,
    // Si32~
    -42,
    // Si31~
    -42,
    // Si30~
    -42,
    // Si29~
    -42,
    // Si28~
    -42,
    // Si27~
    -42,
    // Si26~
    -42,
    // Si25~
    -42,
    // Si24~
    -42,
    // Si23~
    -42,
    // Si22~
    -42,
    // Al39~
    -39,
    // Al38~
    -39,
    // Al37~
    -39,
    // Al36~
    -39,
    // Al35~
    -39,
    // Al34~
    -39,
    // Al33~
    -39,
    // Al32~
    -39,
    // Al31~
    -39,
    // Al30~
    -39,
    // Al29~
    -39,
    // Al28~
    -39,
    // Al27~
    -39,
    // Al26~
    -39,
    // Al25~
    -39,
    // Al24~
    -39,
    // Al23~
    -39,
    // Al22~
    -39,
    // Al21~
    -39,
    // Mg37~
    -36,
    // Mg36~
    -36,
    // Mg35~
    -36,
    // Mg34~
    -36,
    // Mg33~
    -36,
    // Mg32~
    -36,
    // Mg31~
    -36,
    // Mg30~
    -36,
    // Mg29~
    -36,
    // Mg28~
    -36,
    // Mg27~
    -36,
    // Mg26~
    -36,
    // Mg25~
    -36,
    // Mg24~
    -36,
    // Mg23~
    -36,
    // Mg22~
    -36,
    // Mg21~
    -36,
    // Mg20~
    -36,
    // Na35~
    -33,
    // Na34~
    -33,
    // Na33~
    -33,
    // Na32~
    -33,
    // Na31~
    -33,
    // Na30~
    -33,
    // Na29~
    -33,
    // Na28~
    -33,
    // Na27~
    -33,
    // Na26~
    -33,
    // Na25~
    -33,
    // Na24~
    -33,
    // Na23~
    -33,
    // Na22~
    -33,
    // Na21~
    -33,
    // Na20~
    -33,
    // Na19~
    -33,
    // Na18~
    -33,
    // Ne32~
    -30,
    // Ne31~
    -30,
    // Ne30~
    -30,
    // Ne29~
    -30,
    // Ne28~
    -30,
    // Ne27~
    -30,
    // Ne26~
    -30,
    // Ne25~
    -30,
    // Ne24~
    -30,
    // Ne23~
    -30,
    // Ne22~
    -30,
    // Ne21~
    -30,
    // Ne20~
    -30,
    // Ne19~
    -30,
    // Ne18~
    -30,
    // Ne17~
    -30,
    // Ne16~
    -30,
    // F29~
    -27,
    // F28~
    -27,
    // F27~
    -27,
    // F26~
    -27,
    // F25~
    -27,
    // F24~
    -27,
    // F23~
    -27,
    // F22~
    -27,
    // F21~
    -27,
    // F20~
    -27,
    // F19~
    -27,
    // F18~
    -27,
    // F17~
    -27,
    // F16~
    -27,
    // F15~
    -27,
    // F14~
    -27,
    // O26~
    -24,
    // O25~
    -24,
    // O24~
    -24,
    // O23~
    -24,
    // O22~
    -24,
    // O21~
    -24,
    // O20~
    -24,
    // O19~
    -24,
    // O18~
    -24,
    // O17~
    -24,
    // O16~
    -24,
    // O15~
    -24,
    // O14~
    -24,
    // O13~
    -24,
    // O12~
    -24,
    // N24~
    -21,
    // N23~
    -21,
    // N22~
    -21,
    // N21~
    -21,
    // N20~
    -21,
    // N19~
    -21,
    // N18~
    -21,
    // N17~
    -21,
    // N16~
    -21,
    // N15~
    -21,
    // N14~
    -21,
    // N13~
    -21,
    // N12~
    -21,
    // N11~
    -21,
    // N10~
    -21,
    // C22~
    -18,
    // C21~
    -18,
    // C20~
    -18,
    // C19~
    -18,
    // C18~
    -18,
    // C17~
    -18,
    // C16~
    -18,
    // C15~
    -18,
    // C14~
    -18,
    // C13~
    -18,
    // C12~
    -18,
    // C11~
    -18,
    // C10~
    -18,
    // C9~
    -18,
    // C8~
    -18,
    // B19~
    -15,
    // B18~
    -15,
    // B17~
    -15,
    // B16~
    -15,
    // B15~
    -15,
    // B14~
    -15,
    // B13~
    -15,
    // B12~
    -15,
    // B11~
    -15,
    // B10~
    -15,
    // B9~
    -15,
    // B8~
    -15,
    // B7~
    -15,
    // Be14~
    -12,
    // Be13~
    -12,
    // Be12~
    -12,
    // Be11~
    -12,
    // Be10~
    -12,
    // Be9~
    -12,
    // Be8~
    -12,
    // Be7~
    -12,
    // Be6~
    -12,
    // Be5~
    -12,
    // Li12~
    -9,
    // Li11~
    -9,
    // Li10~
    -9,
    // Li9~
    -9,
    // Li8~
    -9,
    // Li7~
    -9,
    // Li6~
    -9,
    // Li5~
    -9,
    // Li4~
    -9,
    // He10~
    -6,
    // He9~
    -6,
    // He8~
    -6,
    // He7~
    -6,
    // He6~
    -6,
    // He5~
    -6,
    // He4~
    -6,
    // He3~
    -6,
    // H6~
    -3,
    // H5~
    -3,
    // H4~
    -3,
    // T3~
    -3,
    // D2~
    -3,
    // p~
    -3,
    // n~
    0,
    // K(2)(2250)-
    -3,
    // K(0)*(1950)-
    -3,
    // a(1)(1640)-
    -3,
    // K(3)(2320)-
    -3,
    // K(2)*(1980)-
    -3,
    // K(1830)-
    -3,
    // K(2)*(1980)~0
    0,
    // pi(1)(1600)-
    -3,
    // pi(1800)-
    -3,
    // K(4)(2500)-
    -3,
    // K(2)(1580)-
    -3,
    // K(1)(1650)-
    -3,
    // K(0)*(700)-
    -3,
    // K(1)(1650)~0
    0,
    // K(0)*(700)~0
    0,
    // a(2)(1700)-
    -3,
    // pi(1)(1400)-
    -3,
    // a(0)(980)-
    -3,
    // Lambda(c)(2880)~-
    -3,
    // Omega(2250)~+
    3,
    // Xi(2030)~0
    0,
    // Xi(1690)~0
    0,
    // Xi(2030)~+
    3,
    // Xi(1690)~+
    3,
    // Xi(c)(2790)~-
    -3,
    // Xi(c)(2815)~-
    -3,
    // Xi(c)(2790)~0
    0,
    // Xi(c)(2815)~0
    0,
    // Lambda(c)(2625)~-
    -3,
    // Xi(1950)~0
    0,
    // Xi(1950)~+
    3,
    // K*(1410)-
    -3,
    // K(1460)-
    -3,
    // K*(1410)~0
    0,
    // rho(1450)-
    -3,
    // pi(1300)-
    -3,
    // Lambda(1810)~
    0,
    // Lambda(1800)~
    0,
    // N(1710)~-
    -3,
    // N(1710)~0
    0,
    // Lambda(1670)~
    0,
    // Delta(1600)~--
    -6,
    // Delta(1600)~-
    -3,
    // N(1650)~-
    -3,
    // N(1720)~-
    -3,
    // Delta(1600)~0
    0,
    // N(1650)~0
    0,
    // N(1720)~0
    0,
    // Delta(1600)~+
    3,
    // K*(1680)-
    -3,
    // K*(1680)~0
    0,
    // rho(1700)-
    -3,
    // Sigma(1910)~-
    -3,
    // Sigma(1750)~-
    -3,
    // Sigma(1910)~0
    0,
    // Sigma(1750)~0
    0,
    // Lambda(2110)~
    0,
    // Lambda(1890)~
    0,
    // Lambda(1600)~
    0,
    // Sigma(1910)~+
    3,
    // Sigma(1750)~+
    3,
    // Delta(1920)~--
    -6,
    // Delta(1910)~--
    -6,
    // Delta(1920)~-
    -3,
    // N(1535)~-
    -3,
    // N(1700)~-
    -3,
    // Delta(1910)~-
    -3,
    // Delta(1920)~0
    0,
    // N(1535)~0
    0,
    // N(1700)~0
    0,
    // Delta(1910)~0
    0,
    // Delta(1920)~+
    3,
    // Delta(1910)~+
    3,
    // D(s1)(2460)-
    -3,
    // D(1)(2430)~0
    0,
    // K(2)(1820)-
    -3,
    // K(1)(1400)-
    -3,
    // K(2)(1820)~0
    0,
    // K(1)(1400)~0
    0,
    // a(1)(1260)-
    -3,
    // Lambda(c)(2595)~-
    -3,
    // Xi(1820)~0
    0,
    // Xi(1820)~+
    3,
    // Sigma(1915)~-
    -3,
    // Sigma(1670)~-
    -3,
    // Sigma(1660)~-
    -3,
    // Sigma(1915)~0
    0,
    // Sigma(1670)~0
    0,
    // Sigma(1660)~0
    0,
    // Lambda(1830)~
    0,
    // Lambda(1690)~
    0,
    // Lambda(1405)~
    0,
    // Sigma(1915)~+
    3,
    // Sigma(1670)~+
    3,
    // Sigma(1660)~+
    3,
    // Delta(1930)~--
    -6,
    // Delta(1700)~--
    -6,
    // Delta(1900)~--
    -6,
    // N(1680)~-
    -3,
    // Delta(1700)~-
    -3,
    // N(1440)~-
    -3,
    // Delta(1930)~-
    -3,
    // Delta(1900)~-
    -3,
    // N(1680)~0
    0,
    // Delta(1700)~0
    0,
    // N(1440)~0
    0,
    // Delta(1930)~0
    0,
    // Delta(1900)~0
    0,
    // Delta(1930)~+
    3,
    // Delta(1700)~+
    3,
    // Delta(1900)~+
    3,
    // D(s1)(2536)-
    -3,
    // D(s0)*(2317)-
    -3,
    // D(1)(2420)~0
    0,
    // D(0)*(2300)~0
    0,
    // D(1)(2420)-
    -3,
    // D(0)*(2300)-
    -3,
    // K(2)(1770)-
    -3,
    // K(1)(1270)-
    -3,
    // K(0)*(1430)-
    -3,
    // K(2)(1770)~0
    0,
    // K(1)(1270)~0
    0,
    // K(0)*(1430)~0
    0,
    // pi(2)(1670)-
    -3,
    // b(1)(1235)-
    -3,
    // a(0)(1450)-
    -3,
    // (bb)(1)~
    2,
    // (bc)(1)~
    -1,
    // (bc)(0)~
    -1,
    // Omega(b)~+
    3,
    // (bs)(1)~
    2,
    // (bs)(0)~
    2,
    // Xi(b)~0
    0,
    // Sigma(b)*~-
    -3,
    // Sigma(b)~-
    -3,
    // (bu)(1)~
    -1,
    // (bu)(0)~
    -1,
    // Xi(b)~+
    3,
    // Lambda(b)~0
    0,
    // Sigma(b)*~+
    3,
    // Sigma(b)~+
    3,
    // (bd)(1)~
    2,
    // (bd)(0)~
    2,
    // (cc)(1)~
    -4,
    // Omega(c)(2770)~0
    0,
    // Omega(c)~0
    0,
    // Xi(c)(2645)~-
    -3,
    // Xi(c)'~-
    -3,
    // Xi(c)(2645)~0
    0,
    // Xi(c)'~0
    0,
    // (cs)(1)~
    -1,
    // (cs)(0)~
    -1,
    // Xi(c)~-
    -3,
    // Sigma(c)(2520)~--
    -6,
    // Sigma(c)(2455)~--
    -6,
    // Sigma(c)(2520)~-
    -3,
    // Sigma(c)(2455)~-
    -3,
    // (cu)(1)~
    -4,
    // (cu)(0)~
    -4,
    // Xi(c)~0
    0,
    // Lambda(c)~-
    -3,
    // Sigma(c)(2520)~0
    0,
    // Sigma(c)(2455)~0
    0,
    // (cd)(1)~
    -1,
    // (cd)(0)~
    -1,
    // Omega~+
    3,
    // Xi(1530)~0
    0,
    // Xi~0
    0,
    // Xi(1530)~+
    3,
    // Xi~+
    3,
    // (ss)(1)~
    2,
    // Sigma(2030)~-
    -3,
    // Sigma(1775)~-
    -3,
    // Sigma(1385)~-
    -3,
    // Sigma~-
    -3,
    // Sigma(2030)~0
    0,
    // Sigma(1775)~0
    0,
    // Sigma(1385)~0
    0,
    // Sigma~0
    0,
    // (su)(1)~
    -1,
    // (su)(0)~
    -1,
    // Lambda(2100)~
    0,
    // Lambda(1820)~
    0,
    // Lambda(1520)~
    0,
    // Lambda~
    0,
    // Sigma(2030)~+
    3,
    // Sigma(1775)~+
    3,
    // Sigma(1385)~+
    3,
    // Sigma~+
    3,
    // (sd)(1)~
    2,
    // (sd)(0)~
    2,
    // Delta(1950)~--
    -6,
    // Delta(1905)~--
    -6,
    // Delta(1232)~--
    -6,
    // Delta(1620)~--
    -6,
    // Delta(1950)~-
    -3,
    // N(1675)~-
    -3,
    // Delta(1232)~-
    -3,
    // p~
    -3,
    // (uu)(1)~
    -4,
    // N(2190)~-
    -3,
    // Delta(1905)~-
    -3,
    // N(1520)~-
    -3,
    // Delta(1620)~-
    -3,
    // Delta(1950)~0
    0,
    // N(1675)~0
    0,
    // Delta(1232)~0
    0,
    // n~
    0,
    // (ud)(1)~
    -1,
    // (ud)(0)~
    -1,
    // N(2190)~0
    0,
    // Delta(1905)~0
    0,
    // N(1520)~0
    0,
    // Delta(1620)~0
    0,
    // Delta(1950)~+
    3,
    // Delta(1905)~+
    3,
    // Delta(1232)~+
    3,
    // Delta(1620)~+
    3,
    // (dd)(1)~
    2,
    // B(c)-
    -3,
    // B(s2)*(5840)~0
    0,
    // B(s)*~0
    0,
    // B(s)~0
    0,
    // B(2)*(5747)-
    -3,
    // B*-
    -3,
    // B-
    -3,
    // B(2)*(5747)~0
    0,
    // B*~0
    0,
    // B~0
    0,
    // D(s2)*(2573)-
    -3,
    // D(s)*-
    -3,
    // D(s)-
    -3,
    // D(2)*(2460)~0
    0,
    // D*(2007)~0
    0,
    // D~0
    0,
    // D(2)*(2460)-
    -3,
    // D*(2010)-
    -3,
    // D-
    -3,
    // K(4)*(2045)-
    -3,
    // K(3)*(1780)-
    -3,
    // K(2)*(1430)-
    -3,
    // K*(892)-
    -3,
    // K-
    -3,
    // K(4)*(2045)~0
    0,
    // K(3)*(1780)~0
    0,
    // K(2)*(1430)~0
    0,
    // K*(892)~0
    0,
    // K~0
    0,
    // a(4)(1970)-
    -3,
    // rho(3)(1690)-
    -3,
    // a(2)(1320)-
    -3,
    // rho(770)-
    -3,
    // pi-
    -3,
    // W-
    -3,
    // nu(tau')~
    0,
    // tau'+
    3,
    // nu(tau)~
    0,
    // tau+
    3,
    // nu(mu)~
    0,
    // mu+
    3,
    // nu(e)~
    0,
    // e+
    3,
    // t~
    -2,
    // b~
    1,
    // c~
    -2,
    // s~
    1,
    // u~
    -2,
    // d~
    1,
    // d
    -1,
    // u
    2,
    // s
    -1,
    // c
    2,
    // b
    -1,
    // t
    2,
    // e-
    -3,
    // nu(e)
    0,
    // mu-
    -3,
    // nu(mu)
    0,
    // tau-
    -3,
    // nu(tau)
    0,
    // tau'-
    -3,
    // nu(tau')
    0,
    // g
    0,
    // gamma
    0,
    // Z0
    0,
    // W+
    3,
    // H0
    0,
    // pi0
    0,
    // rho(770)0
    0,
    // a(2)(1320)0
    0,
    // rho(3)(1690)0
    0,
    // a(4)(1970)0
    0,
    // K(L)0
    0,
    // pi+
    3,
    // rho(770)+
    3,
    // a(2)(1320)+
    3,
    // rho(3)(1690)+
    3,
    // a(4)(1970)+
    3,
    // eta
    0,
    // omega(782)
    0,
    // f(2)(1270)
    0,
    // omega(3)(1670)
    0,
    // f(4)(2050)
    0,
    // K(S)0
    0,
    // K0
    0,
    // K*(892)0
    0,
    // K(2)*(1430)0
    0,
    // K(3)*(1780)0
    0,
    // K(4)*(2045)0
    0,
    // K+
    3,
    // K*(892)+
    3,
    // K(2)*(1430)+
    3,
    // K(3)*(1780)+
    3,
    // K(4)*(2045)+
    3,
    // eta'(958)
    0,
    // phi(1020)
    0,
    // f(2)'(1525)
    0,
    // phi(3)(1850)
    0,
    // D+
    3,
    // D*(2010)+
    3,
    // D(2)*(2460)+
    3,
    // D0
    0,
    // D*(2007)0
    0,
    // D(2)*(2460)0
    0,
    // D(s)+
    3,
    // D(s)*+
    3,
    // D(s2)*(2573)+
    3,
    // eta(c)(1S)
    0,
    // J/psi(1S)
    0,
    // chi(c2)(1P)
    0,
    // B0
    0,
    // B*0
    0,
    // B(2)*(5747)0
    0,
    // B+
    3,
    // B*+
    3,
    // B(2)*(5747)+
    3,
    // B(s)0
    0,
    // B(s)*0
    0,
    // B(s2)*(5840)0
    0,
    // B(c)+
    3,
    // eta(b)(1S)
    0,
    // Upsilon(1S)
    0,
    // chi(b2)(1P)
    0,
    // (dd)(1)
    -2,
    // Delta(1620)-
    -3,
    // Delta(1232)-
    -3,
    // Delta(1905)-
    -3,
    // Delta(1950)-
    -3,
    // Delta(1620)0
    0,
    // N(1520)0
    0,
    // Delta(1905)0
    0,
    // N(2190)0
    0,
    // (ud)(0)
    1,
    // (ud)(1)
    1,
    // n
    0,
    // Delta(1232)0
    0,
    // N(1675)0
    0,
    // Delta(1950)0
    0,
    // Delta(1620)+
    3,
    // N(1520)+
    3,
    // Delta(1905)+
    3,
    // N(2190)+
    3,
    // (uu)(1)
    4,
    // p
    3,
    // Delta(1232)+
    3,
    // N(1675)+
    3,
    // Delta(1950)+
    3,
    // Delta(1620)++
    6,
    // Delta(1232)++
    6,
    // Delta(1905)++
    6,
    // Delta(1950)++
    6,
    // (sd)(0)
    -2,
    // (sd)(1)
    -2,
    // Sigma-
    -3,
    // Sigma(1385)-
    -3,
    // Sigma(1775)-
    -3,
    // Sigma(2030)-
    -3,
    // Lambda
    0,
    // Lambda(1520)
    0,
    // Lambda(1820)
    0,
    // Lambda(2100)
    0,
    // (su)(0)
    1,
    // (su)(1)
    1,
    // Sigma0
    0,
    // Sigma(1385)0
    0,
    // Sigma(1775)0
    0,
    // Sigma(2030)0
    0,
    // Sigma+
    3,
    // Sigma(1385)+
    3,
    // Sigma(1775)+
    3,
    // Sigma(2030)+
    3,
    // (ss)(1)
    -2,
    // Xi-
    -3,
    // Xi(1530)-
    -3,
    // Xi0
    0,
    // Xi(1530)0
    0,
    // Omega-
    -3,
    // (cd)(0)
    1,
    // (cd)(1)
    1,
    // Sigma(c)(2455)0
    0,
    // Sigma(c)(2520)0
    0,
    // Lambda(c)+
    3,
    // Xi(c)0
    0,
    // (cu)(0)
    4,
    // (cu)(1)
    4,
    // Sigma(c)(2455)+
    3,
    // Sigma(c)(2520)+
    3,
    // Sigma(c)(2455)++
    6,
    // Sigma(c)(2520)++
    6,
    // Xi(c)+
    3,
    // (cs)(0)
    1,
    // (cs)(1)
    1,
    // Xi(c)'0
    0,
    // Xi(c)(2645)0
    0,
    // Xi(c)'+
    3,
    // Xi(c)(2645)+
    3,
    // Omega(c)0
    0,
    // Omega(c)(2770)0
    0,
    // (cc)(1)
    4,
    // (bd)(0)
    -2,
    // (bd)(1)
    -2,
    // Sigma(b)-
    -3,
    // Sigma(b)*-
    -3,
    // Lambda(b)0
    0,
    // Xi(b)-
    -3,
    // (bu)(0)
    1,
    // (bu)(1)
    1,
    // Sigma(b)+
    3,
    // Sigma(b)*+
    3,
    // Xi(b)0
    0,
    // (bs)(0)
    -2,
    // (bs)(1)
    -2,
    // Omega(b)-
    -3,
    // (bc)(0)
    1,
    // (bc)(1)
    1,
    // (bb)(1)
    -2,
    // a(0)(1450)0
    0,
    // b(1)(1235)0
    0,
    // pi(2)(1670)0
    0,
    // a(0)(1450)+
    3,
    // b(1)(1235)+
    3,
    // pi(2)(1670)+
    3,
    // f(0)(1370)
    0,
    // h(1)(1170)
    0,
    // eta(2)(1645)
    0,
    // K(0)*(1430)0
    0,
    // K(1)(1270)0
    0,
    // K(2)(1770)0
    0,
    // K(0)*(1430)+
    3,
    // K(1)(1270)+
    3,
    // K(2)(1770)+
    3,
    // f(0)(1710)
    0,
    // h(1)(1415)
    0,
    // eta(2)(1870)
    0,
    // D(0)*(2300)+
    3,
    // D(1)(2420)+
    3,
    // D(0)*(2300)0
    0,
    // D(1)(2420)0
    0,
    // D(s0)*(2317)+
    3,
    // D(s1)(2536)+
    3,
    // chi(c0)(1P)
    0,
    // h(c)(1P)
    0,
    // chi(b0)(1P)
    0,
    // h(b)(1P)
    0,
    // Delta(1900)-
    -3,
    // Delta(1700)-
    -3,
    // Delta(1930)-
    -3,
    // Delta(1900)0
    0,
    // Delta(1930)0
    0,
    // N(1440)0
    0,
    // Delta(1700)0
    0,
    // N(1680)0
    0,
    // Delta(1900)+
    3,
    // Delta(1930)+
    3,
    // N(1440)+
    3,
    // Delta(1700)+
    3,
    // N(1680)+
    3,
    // Delta(1900)++
    6,
    // Delta(1700)++
    6,
    // Delta(1930)++
    6,
    // Sigma(1660)-
    -3,
    // Sigma(1670)-
    -3,
    // Sigma(1915)-
    -3,
    // Lambda(1405)
    0,
    // Lambda(1690)
    0,
    // Lambda(1830)
    0,
    // Sigma(1660)0
    0,
    // Sigma(1670)0
    0,
    // Sigma(1915)0
    0,
    // Sigma(1660)+
    3,
    // Sigma(1670)+
    3,
    // Sigma(1915)+
    3,
    // Xi(1820)-
    -3,
    // Xi(1820)0
    0,
    // Lambda(c)(2595)+
    3,
    // a(1)(1260)0
    0,
    // a(1)(1260)+
    3,
    // f(1)(1285)
    0,
    // K(1)(1400)0
    0,
    // K(2)(1820)0
    0,
    // K(1)(1400)+
    3,
    // K(2)(1820)+
    3,
    // f(1)(1420)
    0,
    // D(1)(2430)0
    0,
    // D(s1)(2460)+
    3,
    // chi(c1)(1P)
    0,
    // chi(b1)(1P)
    0,
    // Upsilon(2)(1D)
    0,
    // Delta(1910)-
    -3,
    // Delta(1920)-
    -3,
    // Delta(1910)0
    0,
    // N(1700)0
    0,
    // N(1535)0
    0,
    // Delta(1920)0
    0,
    // Delta(1910)+
    3,
    // N(1700)+
    3,
    // N(1535)+
    3,
    // Delta(1920)+
    3,
    // Delta(1910)++
    6,
    // Delta(1920)++
    6,
    // Sigma(1750)-
    -3,
    // Sigma(1910)-
    -3,
    // Lambda(1600)
    0,
    // Lambda(1890)
    0,
    // Lambda(2110)
    0,
    // Sigma(1750)0
    0,
    // Sigma(1910)0
    0,
    // Sigma(1750)+
    3,
    // Sigma(1910)+
    3,
    // rho(1700)0
    0,
    // rho(1700)+
    3,
    // omega(1650)
    0,
    // K*(1680)0
    0,
    // K*(1680)+
    3,
    // psi(3770)
    0,
    // Delta(1600)-
    -3,
    // N(1720)0
    0,
    // N(1650)0
    0,
    // Delta(1600)0
    0,
    // N(1720)+
    3,
    // N(1650)+
    3,
    // Delta(1600)+
    3,
    // Delta(1600)++
    6,
    // Lambda(1670)
    0,
    // N(1710)0
    0,
    // N(1710)+
    3,
    // Lambda(1800)
    0,
    // Lambda(1810)
    0,
    // pi(1300)0
    0,
    // rho(1450)0
    0,
    // pi(1300)+
    3,
    // rho(1450)+
    3,
    // eta(1295)
    0,
    // omega(1420)
    0,
    // K*(1410)0
    0,
    // K(1460)+
    3,
    // K*(1410)+
    3,
    // eta(1475)
    0,
    // phi(1680)
    0,
    // eta(c)(2S)
    0,
    // psi(2S)
    0,
    // chi(c2)(3930)
    0,
    // Upsilon(2S)
    0,
    // chi(b2)(2P)
    0,
    // Xi(1950)-
    -3,
    // Xi(1950)0
    0,
    // Lambda(c)(2625)+
    3,
    // Xi(c)(2815)0
    0,
    // Xi(c)(2790)0
    0,
    // Xi(c)(2815)+
    3,
    // Xi(c)(2790)+
    3,
    // chi(b0)(2P)
    0,
    // h(b)(2P)
    0,
    // chi(b1)(2P)
    0,
    // Upsilon(3S)
    0,
    // chi(b2)(3P)
    0,
    // Xi(1690)-
    -3,
    // Xi(2030)-
    -3,
    // Xi(1690)0
    0,
    // Xi(2030)0
    0,
    // Omega(2250)-
    -3,
    // Lambda(c)(2880)+
    3,
    // chi(b1)(3P)
    0,
    // Upsilon(4S)
    0,
    // a(0)(980)0
    0,
    // pi(1)(1400)0
    0,
    // a(2)(1700)0
    0,
    // a(0)(980)+
    3,
    // pi(1)(1400)+
    3,
    // a(2)(1700)+
    3,
    // f(0)(500)
    0,
    // K(0)*(700)0
    0,
    // K(1)(1650)0
    0,
    // K(0)*(700)+
    3,
    // K(1)(1650)+
    3,
    // K(2)(1580)+
    3,
    // K(4)(2500)+
    3,
    // psi(4040)
    0,
    // Upsilon(10860)
    0,
    // pi(1800)0
    0,
    // pi(1)(1600)0
    0,
    // pi(1800)+
    3,
    // pi(1)(1600)+
    3,
    // f(0)(980)
    0,
    // K(2)*(1980)0
    0,
    // K(1830)+
    3,
    // K(2)*(1980)+
    3,
    // K(3)(2320)+
    3,
    // psi(4160)
    0,
    // Upsilon(11020)
    0,
    // a(1)(1640)0
    0,
    // a(1)(1640)+
    3,
    // eta(1405)
    0,
    // K(0)*(1950)+
    3,
    // K(2)(2250)+
    3,
    // psi(4415)
    0,
    // f(0)(1500)
    0,
    // f(0)(2020)
    0,
    // f(2)(1950)
    0,
    // f(2)(2010)
    0,
    // f(2)(2300)
    0,
    // f(2)(2340)
    0,
    // n
    0,
    // p
    3,
    // D2
    3,
    // T3
    3,
    // H4
    3,
    // H5
    3,
    // H6
    3,
    // He3
    6,
    // He4
    6,
    // He5
    6,
    // He6
    6,
    // He7
    6,
    // He8
    6,
    // He9
    6,
    // He10
    6,
    // Li4
    9,
    // Li5
    9,
    // Li6
    9,
    // Li7
    9,
    // Li8
    9,
    // Li9
    9,
    // Li10
    9,
    // Li11
    9,
    // Li12
    9,
    // Be5
    12,
    // Be6
    12,
    // Be7
    12,
    // Be8
    12,
    // Be9
    12,
    // Be10
    12,
    // Be11
    12,
    // Be12
    12,
    // Be13
    12,
    // Be14
    12,
    // B7
    15,
    // B8
    15,
    // B9
    15,
    // B10
    15,
    // B11
    15,
    // B12
    15,
    // B13
    15,
    // B14
    15,
    // B15
    15,
    // B16
    15,
    // B17
    15,
    // B18
    15,
    // B19
    15,
    // C8
    18,
    // C9
    18,
    // C10
    18,
    // C11
    18,
    // C12
    18,
    // C13
    18,
    // C14
    18,
    // C15
    18,
    // C16
    18,
    // C17
    18,
    // C18
    18,
    // C19
    18,
    // C20
    18,
    // C21
    18,
    // C22
    18,
    // N10
    21,
    // N11
    21,
    // N12
    21,
    // N13
    21,
    // N14
    21,
    // N15
    21,
    // N16
    21,
    // N17
    21,
    // N18
    21,
    // N19
    21,
    // N20
    21,
    // N21
    21,
    // N22
    21,
    // N23
    21,
    // N24
    21,
    // O12
    24,
    // O13
    24,
    // O14
    24,
    // O15
    24,
    // O16
    24,
    // O17
    24,
    // O18
    24,
    // O19
    24,
    // O20
    24,
    // O21
    24,
    // O22
    24,
    // O23
    24,
    // O24
    24,
    // O25
    24,
    // O26
    24,
    // F14
    27,
    // F15
    27,
    // F16
    27,
    // F17
    27,
    // F18
    27,
    // F19
    27,
    // F20
    27,
    // F21
    27,
    // F22
    27,
    // F23
    27,
    // F24
    27,
    // F25
    27,
    // F26
    27,
    // F27
    27,
    // F28
    27,
    // F29
    27,
    // Ne16
    30,
    // Ne17
    30,
    // Ne18
    30,
    // Ne19
    30,
    // Ne20
    30,
    // Ne21
    30,
    // Ne22
    30,
    // Ne23
    30,
    // Ne24
    30,
    // Ne25
    30,
    // Ne26
    30,
    // Ne27
    30,
    // Ne28
    30,
    // Ne29
    30,
    // Ne30
    30,
    // Ne31
    30,
    // Ne32
    30,
    // Na18
    33,
    // Na19
    33,
    // Na20
    33,
    // Na21
    33,
    // Na22
    33,
    // Na23
    33,
    // Na24
    33,
    // Na25
    33,
    // Na26
    33,
    // Na27
    33,
    // Na28
    33,
    // Na29
    33,
    // Na30
    33,
    // Na31
    33,
    // Na32
    33,
    // Na33
    33,
    // Na34
    33,
    // Na35
    33,
    // Mg20
    36,
    // Mg21
    36,
    // Mg22
    36,
    // Mg23
    36,
    // Mg24
    36,
    // Mg25
    36,
    // Mg26
    36,
    // Mg27
    36,
    // Mg28
    36,
    // Mg29
    36,
    // Mg30
    36,
    // Mg31
    36,
    // Mg32
    36,
    // Mg33
    36,
    // Mg34
    36,
    // Mg35
    36,
    // Mg36
    36,
    // Mg37
    36,
    // Al21
    39,
    // Al22
    39,
    // Al23
    39,
    // Al24
    39,
    // Al25
    39,
    // Al26
    39,
    // Al27
    39,
    // Al28
    39,
    // Al29
    39,
    // Al30
    39,
    // Al31
    39,
    // Al32
    39,
    // Al33
    39,
    // Al34
    39,
    // Al35
    39,
    // Al36
    39,
    // Al37
    39,
    // Al38
    39,
    // Al39
    39,
    // Si22
    42,
    // Si23
    42,
    // Si24
    42,
    // Si25
    42,
    // Si26
    42,
    // Si27
    42,
    // Si28
    42,
    // Si29
    42,
    // Si30
    42,
    // Si31
    42,
    // Si32
    42,
    // Si33
    42,
    // Si34
    42,
    // Si35
    42,
    // Si36
    42,
    // Si37
    42,
    // Si38
    42,
    // Si39
    42,
    // Si40
    42,
    // Si41
    42,
    // Si42
    42,
    // P24
    45,
    // P25
    45,
    // P26
    45,
    // P27
    45,
    // P28
    45,
    // P29
    45,
    // P30
    45,
    // P31
    45,
    // P32
    45,
    // P33
    45,
    // P34
    45,
    // P35
    45,
    // P36
    45,
    // P37
    45,
    // P38
    45,
    // P39
    45,
    // P40
    45,
    // P41
    45,
    // P42
    45,
    // P43
    45,
    // P44
    45,
    // P45
    45,
    // P46
    45,
    // S26
    48,
    // S27
    48,
    // S28
    48,
    // S29
    48,
    // S30
    48,
    // S31
    48,
    // S32
    48,
    // S33
    48,
    // S34
    48,
    // S35
    48,
    // S36
    48,
    // S37
    48,
    // S38
    48,
    // S39
    48,
    // S40
    48,
    // S41
    48,
    // S42
    48,
    // S43
    48,
    // S44
    48,
    // S45
    48,
    // S46
    48,
    // S47
    48,
    // S48
    48,
    // S49
    48,
    // Cl28
    51,
    // Cl29
    51,
    // Cl30
    51,
    // Cl31
    51,
    // Cl32
    51,
    // Cl33
    51,
    // Cl34
    51,
    // Cl35
    51,
    // Cl36
    51,
    // Cl37
    51,
    // Cl38
    51,
    // Cl39
    51,
    // Cl40
    51,
    // Cl41
    51,
    // Cl42
    51,
    // Cl43
    51,
    // Cl44
    51,
    // Cl45
    51,
    // Cl46
    51,
    // Cl47
    51,
    // Cl48
    51,
    // Cl49
    51,
    // Cl50
    51,
    // Cl51
    51,
    // Ar30
    54,
    // Ar31
    54,
    // Ar32
    54,
    // Ar33
    54,
    // Ar34
    54,
    // Ar35
    54,
    // Ar36
    54,
    // Ar37
    54,
    // Ar38
    54,
    // Ar39
    54,
    // Ar40
    54,
    // Ar41
    54,
    // Ar42
    54,
    // Ar43
    54,
    // Ar44
    54,
    // Ar45
    54,
    // Ar46
    54,
    // Ar47
    54,
    // Ar48
    54,
    // Ar49
    54,
    // Ar50
    54,
    // Ar51
    54,
    // Ar52
    54,
    // Ar53
    54,
    // K32
    57,
    // K33
    57,
    // K34
    57,
    // K35
    57,
    // K36
    57,
    // K37
    57,
    // K38
    57,
    // K39
    57,
    // K40
    57,
    // K41
    57,
    // K42
    57,
    // K43
    57,
    // K44
    57,
    // K45
    57,
    // K46
    57,
    // K47
    57,
    // K48
    57,
    // K49
    57,
    // K50
    57,
    // K51
    57,
    // K52
    57,
    // K53
    57,
    // K54
    57,
    // K55
    57,
    // Ca34
    60,
    // Ca35
    60,
    // Ca36
    60,
    // Ca37
    60,
    // Ca38
    60,
    // Ca39
    60,
    // Ca40
    60,
    // Ca41
    60,
    // Ca42
    60,
    // Ca43
    60,
    // Ca44
    60,
    // Ca45
    60,
    // Ca46
    60,
    // Ca47
    60,
    // Ca48
    60,
    // Ca49
    60,
    // Ca50
    60,
    // Ca51
    60,
    // Ca52
    60,
    // Ca53
    60,
    // Ca54
    60,
    // Ca55
    60,
    // Ca56
    60,
    // Ca57
    60,
    // Sc36
    63,
    // Sc37
    63,
    // Sc38
    63,
    // Sc39
    63,
    // Sc40
    63,
    // Sc41
    63,
    // Sc42
    63,
    // Sc43
    63,
    // Sc44
    63,
    // Sc45
    63,
    // Sc46
    63,
    // Sc47
    63,
    // Sc48
    63,
    // Sc49
    63,
    // Sc50
    63,
    // Sc51
    63,
    // Sc52
    63,
    // Sc53
    63,
    // Sc54
    63,
    // Sc55
    63,
    // Sc56
    63,
    // Sc57
    63,
    // Sc58
    63,
    // Sc59
    63,
    // Ti38
    66,
    // Ti39
    66,
    // Ti40
    66,
    // Ti41
    66,
    // Ti42
    66,
    // Ti43
    66,
    // Ti44
    66,
    // Ti45
    66,
    // Ti46
    66,
    // Ti47
    66,
    // Ti48
    66,
    // Ti49
    66,
    // Ti50
    66,
    // Ti51
    66,
    // Ti52
    66,
    // Ti53
    66,
    // Ti54
    66,
    // Ti55
    66,
    // Ti56
    66,
    // Ti57
    66,
    // Ti58
    66,
    // Ti59
    66,
    // Ti60
    66,
    // Ti61
    66,
    // V40
    69,
    // V41
    69,
    // V42
    69,
    // V43
    69,
    // V44
    69,
    // V45
    69,
    // V46
    69,
    // V47
    69,
    // V48
    69,
    // V49
    69,
    // V50
    69,
    // V51
    69,
    // V52
    69,
    // V53
    69,
    // V54
    69,
    // V55
    69,
    // V56
    69,
    // V57
    69,
    // V58
    69,
    // V59
    69,
    // V60
    69,
    // V61
    69,
    // V62
    69,
    // V63
    69,
    // Cr42
    72,
    // Cr43
    72,
    // Cr44
    72,
    // Cr45
    72,
    // Cr46
    72,
    // Cr47
    72,
    // Cr48
    72,
    // Cr49
    72,
    // Cr50
    72,
    // Cr51
    72,
    // Cr52
    72,
    // Cr53
    72,
    // Cr54
    72,
    // Cr55
    72,
    // Cr56
    72,
    // Cr57
    72,
    // Cr58
    72,
    // Cr59
    72,
    // Cr60
    72,
    // Cr61
    72,
    // Cr62
    72,
    // Cr63
    72,
    // Cr64
    72,
    // Cr65
    72,
    // Mn44
    75,
    // Mn45
    75,
    // Mn46
    75,
    // Mn47
    75,
    // Mn48
    75,
    // Mn49
    75,
    // Mn50
    75,
    // Mn51
    75,
    // Mn52
    75,
    // Mn53
    75,
    // Mn54
    75,
    // Mn55
    75,
    // Mn56
    75,
    // Mn57
    75,
    // Mn58
    75,
    // Mn59
    75,
    // Mn60
    75,
    // Mn61
    75,
    // Mn62
    75,
    // Mn63
    75,
    // Mn64
    75,
    // Mn65
    75,
    // Mn66
    75,
    // Mn67
    75,
    // Fe45
    78,
    // Fe46
    78,
    // Fe47
    78,
    // Fe48
    78,
    // Fe49
    78,
    // Fe50
    78,
    // Fe51
    78,
    // Fe52
    78,
    // Fe53
    78,
    // Fe54
    78,
    // Fe55
    78,
    // Fe56
    78,
    // Fe57
    78,
    // Fe58
    78,
    // Fe59
    78,
    // Fe60
    78,
    // Fe61
    78,
    // Fe62
    78,
    // Fe63
    78,
    // Fe64
    78,
    // Fe65
    78,
    // Fe66
    78,
    // Fe67
    78,
    // Fe68
    78,
    // Fe69
    78,
    // Co48
    81,
    // Co49
    81,
    // Co50
    81,
    // Co51
    81,
    // Co52
    81,
    // Co53
    81,
    // Co54
    81,
    // Co55
    81,
    // Co56
    81,
    // Co57
    81,
    // Co58
    81,
    // Co59
    81,
    // Co60
    81,
    // Co61
    81,
    // Co62
    81,
    // Co63
    81,
    // Co64
    81,
    // Co65
    81,
    // Co66
    81,
    // Co67
    81,
    // Co68
    81,
    // Co69
    81,
    // Co70
    81,
    // Co71
    81,
    // Co72
    81,
    // Ni50
    84,
    // Ni51
    84,
    // Ni52
    84,
    // Ni53
    84,
    // Ni54
    84,
    // Ni55
    84,
    // Ni56
    84,
    // Ni57
    84,
    // Ni58
    84,
    // Ni59
    84,
    // Ni60
    84,
    // Ni61
    84,
    // Ni62
    84,
    // Ni63
    84,
    // Ni64
    84,
    // Ni65
    84,
    // Ni66
    84,
    // Ni67
    84,
    // Ni68
    84,
    // Ni69
    84,
    // Ni70
    84,
    // Ni71
    84,
    // Ni72
    84,
    // Ni73
    84,
    // Ni74
    84,
    // Ni75
    84,
    // Ni76
    84,
    // Ni77
    84,
    // Ni78
    84,
    // Cu52
    87,
    // Cu53
    87,
    // Cu54
    87,
    // Cu55
    87,
    // Cu56
    87,
    // Cu57
    87,
    // Cu58
    87,
    // Cu59
    87,
    // Cu60
    87,
    // Cu61
    87,
    // Cu62
    87,
    // Cu63
    87,
    // Cu64
    87,
    // Cu65
    87,
    // Cu66
    87,
    // Cu67
    87,
    // Cu68
    87,
    // Cu69
    87,
    // Cu70
    87,
    // Cu71
    87,
    // Cu72
    87,
    // Cu73
    87,
    // Cu74
    87,
    // Cu75
    87,
    // Cu76
    87,
    // Cu77
    87,
    // Cu78
    87,
    // Cu79
    87,
    // Cu80
    87,
    // Zn54
    90,
    // Zn55
    90,
    // Zn56
    90,
    // Zn57
    90,
    // Zn58
    90,
    // Zn59
    90,
    // Zn60
    90,
    // Zn61
    90,
    // Zn62
    90,
    // Zn63
    90,
    // Zn64
    90,
    // Zn65
    90,
    // Zn66
    90,
    // Zn67
    90,
    // Zn68
    90,
    // Zn69
    90,
    // Zn70
    90,
    // Zn71
    90,
    // Zn72
    90,
    // Zn73
    90,
    // Zn74
    90,
    // Zn75
    90,
    // Zn76
    90,
    // Zn77
    90,
    // Zn78
    90,
    // Zn79
    90,
    // Zn80
    90,
    // Zn81
    90,
    // Zn82
    90,
    // Ga56
    93,
    // Ga57
    93,
    // Ga58
    93,
    // Ga59
    93,
    // Ga60
    93,
    // Ga61
    93,
    // Ga62
    93,
    // Ga63
    93,
    // Ga64
    93,
    // Ga65
    93,
    // Ga66
    93,
    // Ga67
    93,
    // Ga68
    93,
    // Ga69
    93,
    // Ga70
    93,
    // Ga71
    93,
    // Ga72
    93,
    // Ga73
    93,
    // Ga74
    93,
    // Ga75
    93,
    // Ga76
    93,
    // Ga77
    93,
    // Ga78
    93,
    // Ga79
    93,
    // Ga80
    93,
    // Ga81
    93,
    // Ga82
    93,
    // Ga83
    93,
    // Ga84
    93,
    // Ge58
    96,
    // Ge59
    96,
    // Ge60
    96,
    // Ge61
    96,
    // Ge62
    96,
    // Ge63
    96,
    // Ge64
    96,
    // Ge65
    96,
    // Ge66
    96,
    // Ge67
    96,
    // Ge68
    96,
    // Ge69
    96,
    // Ge70
    96,
    // Ge71
    96,
    // Ge72
    96,
    // Ge73
    96,
    // Ge74
    96,
    // Ge75
    96,
    // Ge76
    96,
    // Ge77
    96,
    // Ge78
    96,
    // Ge79
    96,
    // Ge80
    96,
    // Ge81
    96,
    // Ge82
    96,
    // Ge83
    96,
    // Ge84
    96,
    // Ge85
    96,
    // Ge86
    96,
    // As60
    99,
    // As61
    99,
    // As62
    99,
    // As63
    99,
    // As64
    99,
    // As65
    99,
    // As66
    99,
    // As67
    99,
    // As68
    99,
    // As69
    99,
    // As70
    99,
    // As71
    99,
    // As72
    99,
    // As73
    99,
    // As74
    99,
    // As75
    99,
    // As76
    99,
    // As77
    99,
    // As78
    99,
    // As79
    99,
    // As80
    99,
    // As81
    99,
    // As82
    99,
    // As83
    99,
    // As84
    99,
    // As85
    99,
    // As86
    99,
    // As87
    99,
    // As88
    99,
    // As89
    99,
    // Se65
    102,
    // Se66
    102,
    // Se67
    102,
    // Se68
    102,
    // Se69
    102,
    // Se70
    102,
    // Se71
    102,
    // Se72
    102,
    // Se73
    102,
    // Se74
    102,
    // Se75
    102,
    // Se76
    102,
    // Se77
    102,
    // Se78
    102,
    // Se79
    102,
    // Se80
    102,
    // Se81
    102,
    // Se82
    102,
    // Se83
    102,
    // Se84
    102,
    // Se85
    102,
    // Se86
    102,
    // Se87
    102,
    // Se88
    102,
    // Se89
    102,
    // Se90
    102,
    // Se91
    102,
    // Se92
    102,
    // Br67
    105,
    // Br68
    105,
    // Br69
    105,
    // Br70
    105,
    // Br71
    105,
    // Br72
    105,
    // Br73
    105,
    // Br74
    105,
    // Br75
    105,
    // Br76
    105,
    // Br77
    105,
    // Br78
    105,
    // Br79
    105,
    // Br80
    105,
    // Br81
    105,
    // Br82
    105,
    // Br83
    105,
    // Br84
    105,
    // Br85
    105,
    // Br86
    105,
    // Br87
    105,
    // Br88
    105,
    // Br89
    105,
    // Br90
    105,
    // Br91
    105,
    // Br92
    105,
    // Br93
    105,
    // Br94
    105,
    // Kr69
    108,
    // Kr70
    108,
    // Kr71
    108,
    // Kr72
    108,
    // Kr73
    108,
    // Kr74
    108,
    // Kr75
    108,
    // Kr76
    108,
    // Kr77
    108,
    // Kr78
    108,
    // Kr79
    108,
    // Kr80
    108,
    // Kr81
    108,
    // Kr82
    108,
    // Kr83
    108,
    // Kr84
    108,
    // Kr85
    108,
    // Kr86
    108,
    // Kr87
    108,
    // Kr88
    108,
    // Kr89
    108,
    // Kr90
    108,
    // Kr91
    108,
    // Kr92
    108,
    // Kr93
    108,
    // Kr94
    108,
    // Kr95
    108,
    // Kr96
    108,
    // Kr97
    108,
    // Rb71
    111,
    // Rb72
    111,
    // Rb73
    111,
    // Rb74
    111,
    // Rb75
    111,
    // Rb76
    111,
    // Rb77
    111,
    // Rb78
    111,
    // Rb79
    111,
    // Rb80
    111,
    // Rb81
    111,
    // Rb82
    111,
    // Rb83
    111,
    // Rb84
    111,
    // Rb85
    111,
    // Rb86
    111,
    // Rb87
    111,
    // Rb88
    111,
    // Rb89
    111,
    // Rb90
    111,
    // Rb91
    111,
    // Rb92
    111,
    // Rb93
    111,
    // Rb94
    111,
    // Rb95
    111,
    // Rb96
    111,
    // Rb97
    111,
    // Rb98
    111,
    // Rb99
    111,
    // Rb100
    111,
    // Rb101
    111,
    // Rb102
    111,
    // Sr73
    114,
    // Sr74
    114,
    // Sr75
    114,
    // Sr76
    114,
    // Sr77
    114,
    // Sr78
    114,
    // Sr79
    114,
    // Sr80
    114,
    // Sr81
    114,
    // Sr82
    114,
    // Sr83
    114,
    // Sr84
    114,
    // Sr85
    114,
    // Sr86
    114,
    // Sr87
    114,
    // Sr88
    114,
    // Sr89
    114,
    // Sr90
    114,
    // Sr91
    114,
    // Sr92
    114,
    // Sr93
    114,
    // Sr94
    114,
    // Sr95
    114,
    // Sr96
    114,
    // Sr97
    114,
    // Sr98
    114,
    // Sr99
    114,
    // Sr100
    114,
    // Sr101
    114,
    // Sr102
    114,
    // Sr103
    114,
    // Sr104
    114,
    // Y77
    117,
    // Y78
    117,
    // Y79
    117,
    // Y80
    117,
    // Y81
    117,
    // Y82
    117,
    // Y83
    117,
    // Y84
    117,
    // Y85
    117,
    // Y86
    117,
    // Y87
    117,
    // Y88
    117,
    // Y89
    117,
    // Y90
    117,
    // Y91
    117,
    // Y92
    117,
    // Y93
    117,
    // Y94
    117,
    // Y95
    117,
    // Y96
    117,
    // Y97
    117,
    // Y98
    117,
    // Y99
    117,
    // Y100
    117,
    // Y101
    117,
    // Y102
    117,
    // Y103
    117,
    // Y104
    117,
    // Y105
    117,
    // Y106
    117,
    // Zr79
    120,
    // Zr80
    120,
    // Zr81
    120,
    // Zr82
    120,
    // Zr83
    120,
    // Zr84
    120,
    // Zr85
    120,
    // Zr86
    120,
    // Zr87
    120,
    // Zr88
    120,
    // Zr89
    120,
    // Zr90
    120,
    // Zr91
    120,
    // Zr92
    120,
    // Zr93
    120,
    // Zr94
    120,
    // Zr95
    120,
    // Zr96
    120,
    // Zr97
    120,
    // Zr98
    120,
    // Zr99
    120,
    // Zr100
    120,
    // Zr101
    120,
    // Zr102
    120,
    // Zr103
    120,
    // Zr104
    120,
    // Zr105
    120,
    // Zr106
    120,
    // Zr107
    120,
    // Zr108
    120,
    // Nb81
    123,
    // Nb82
    123,
    // Nb83
    123,
    // Nb84
    123,
    // Nb85
    123,
    // Nb86
    123,
    // Nb87
    123,
    // Nb88
    123,
    // Nb89
    123,
    // Nb90
    123,
    // Nb91
    123,
    // Nb92
    123,
    // Nb93
    123,
    // Nb94
    123,
    // Nb95
    123,
    // Nb96
    123,
    // Nb97
    123,
    // Nb98
    123,
    // Nb99
    123,
    // Nb100
    123,
    // Nb101
    123,
    // Nb102
    123,
    // Nb103
    123,
    // Nb104
    123,
    // Nb105
    123,
    // Nb106
    123,
    // Nb107
    123,
    // Nb108
    123,
    // Nb109
    123,
    // Nb110
    123,
    // Mo83
    126,
    // Mo84
    126,
    // Mo85
    126,
    // Mo86
    126,
    // Mo87
    126,
    // Mo88
    126,
    // Mo89
    126,
    // Mo90
    126,
    // Mo91
    126,
    // Mo92
    126,
    // Mo93
    126,
    // Mo94
    126,
    // Mo95
    126,
    // Mo96
    126,
    // Mo97
    126,
    // Mo98
    126,
    // Mo99
    126,
    // Mo100
    126,
    // Mo101
    126,
    // Mo102
    126,
    // Mo103
    126,
    // Mo104
    126,
    // Mo105
    126,
    // Mo106
    126,
    // Mo107
    126,
    // Mo108
    126,
    // Mo109
    126,
    // Mo110
    126,
    // Mo111
    126,
    // Mo112
    126,
    // Mo113
    126,
    // Tc85
    129,
    // Tc86
    129,
    // Tc87
    129,
    // Tc88
    129,
    // Tc89
    129,
    // Tc90
    129,
    // Tc91
    129,
    // Tc92
    129,
    // Tc93
    129,
    // Tc94
    129,
    // Tc95
    129,
    // Tc96
    129,
    // Tc97
    129,
    // Tc98
    129,
    // Tc99
    129,
    // Tc100
    129,
    // Tc101
    129,
    // Tc102
    129,
    // Tc103
    129,
    // Tc104
    129,
    // Tc105
    129,
    // Tc106
    129,
    // Tc107
    129,
    // Tc108
    129,
    // Tc109
    129,
    // Tc110
    129,
    // Tc111
    129,
    // Tc112
    129,
    // Tc113
    129,
    // Tc114
    129,
    // Tc115
    129,
    // Ru87
    132,
    // Ru88
    132,
    // Ru89
    132,
    // Ru90
    132,
    // Ru91
    132,
    // Ru92
    132,
    // Ru93
    132,
    // Ru94
    132,
    // Ru95
    132,
    // Ru96
    132,
    // Ru97
    132,
    // Ru98
    132,
    // Ru99
    132,
    // Ru100
    132,
    // Ru101
    132,
    // Ru102
    132,
    // Ru103
    132,
    // Ru104
    132,
    // Ru105
    132,
    // Ru106
    132,
    // Ru107
    132,
    // Ru108
    132,
    // Ru109
    132,
    // Ru110
    132,
    // Ru111
    132,
    // Ru112
    132,
    // Ru113
    132,
    // Ru114
    132,
    // Ru115
    132,
    // Ru116
    132,
    // Ru117
    132,
    // Ru118
    132,
    // Rh89
    135,
    // Rh90
    135,
    // Rh91
    135,
    // Rh92
    135,
    // Rh93
    135,
    // Rh94
    135,
    // Rh95
    135,
    // Rh96
    135,
    // Rh97
    135,
    // Rh98
    135,
    // Rh99
    135,
    // Rh100
    135,
    // Rh101
    135,
    // Rh102
    135,
    // Rh103
    135,
    // Rh104
    135,
    // Rh105
    135,
    // Rh106
    135,
    // Rh107
    135,
    // Rh108
    135,
    // Rh109
    135,
    // Rh110
    135,
    // Rh111
    135,
    // Rh112
    135,
    // Rh113
    135,
    // Rh114
    135,
    // Rh115
    135,
    // Rh116
    135,
    // Rh117
    135,
    // Rh118
    135,
    // Rh119
    135,
    // Rh120
    135,
    // Rh121
    135,
    // Pd91
    138,
    // Pd92
    138,
    // Pd93
    138,
    // Pd94
    138,
    // Pd95
    138,
    // Pd96
    138,
    // Pd97
    138,
    // Pd98
    138,
    // Pd99
    138,
    // Pd100
    138,
    // Pd101
    138,
    // Pd102
    138,
    // Pd103
    138,
    // Pd104
    138,
    // Pd105
    138,
    // Pd106
    138,
    // Pd107
    138,
    // Pd108
    138,
    // Pd109
    138,
    // Pd110
    138,
    // Pd111
    138,
    // Pd112
    138,
    // Pd113
    138,
    // Pd114
    138,
    // Pd115
    138,
    // Pd116
    138,
    // Pd117
    138,
    // Pd118
    138,
    // Pd119
    138,
    // Pd120
    138,
    // Pd121
    138,
    // Pd122
    138,
    // Pd123
    138,
    // Ag94
    141,
    // Ag95
    141,
    // Ag96
    141,
    // Ag97
    141,
    // Ag98
    141,
    // Ag99
    141,
    // Ag100
    141,
    // Ag101
    141,
    // Ag102
    141,
    // Ag103
    141,
    // Ag104
    141,
    // Ag105
    141,
    // Ag106
    141,
    // Ag107
    141,
    // Ag108
    141,
    // Ag109
    141,
    // Ag110
    141,
    // Ag111
    141,
    // Ag112
    141,
    // Ag113
    141,
    // Ag114
    141,
    // Ag115
    141,
    // Ag116
    141,
    // Ag117
    141,
    // Ag118
    141,
    // Ag119
    141,
    // Ag120
    141,
    // Ag121
    141,
    // Ag122
    141,
    // Ag123
    141,
    // Ag124
    141,
    // Ag125
    141,
    // Ag126
    141,
    // Ag127
    141,
    // Cd96
    144,
    // Cd97
    144,
    // Cd98
    144,
    // Cd99
    144,
    // Cd100
    144,
    // Cd101
    144,
    // Cd102
    144,
    // Cd103
    144,
    // Cd104
    144,
    // Cd105
    144,
    // Cd106
    144,
    // Cd107
    144,
    // Cd108
    144,
    // Cd109
    144,
    // Cd110
    144,
    // Cd111
    144,
    // Cd112
    144,
    // Cd113
    144,
    // Cd114
    144,
    // Cd115
    144,
    // Cd116
    144,
    // Cd117
    144,
    // Cd118
    144,
    // Cd119
    144,
    // Cd120
    144,
    // Cd121
    144,
    // Cd122
    144,
    // Cd123
    144,
    // Cd124
    144,
    // Cd125
    144,
    // Cd126
    144,
    // Cd127
    144,
    // Cd128
    144,
    // Cd129
    144,
    // Cd130
    144,
    // In98
    147,
    // In99
    147,
    // In100
    147,
    // In101
    147,
    // In102
    147,
    // In103
    147,
    // In104
    147,
    // In105
    147,
    // In106
    147,
    // In107
    147,
    // In108
    147,
    // In109
    147,
    // In110
    147,
    // In111
    147,
    // In112
    147,
    // In113
    147,
    // In114
    147,
    // In115
    147,
    // In116
    147,
    // In117
    147,
    // In118
    147,
    // In119
    147,
    // In120
    147,
    // In121
    147,
    // In122
    147,
    // In123
    147,
    // In124
    147,
    // In125
    147,
    // In126
    147,
    // In127
    147,
    // In128
    147,
    // In129
    147,
    // In130
    147,
    // In131
    147,
    // In132
    147,
    // In133
    147,
    // In134
    147,
    // Sn100
    150,
    // Sn101
    150,
    // Sn102
    150,
    // Sn103
    150,
    // Sn104
    150,
    // Sn105
    150,
    // Sn106
    150,
    // Sn107
    150,
    // Sn108
    150,
    // Sn109
    150,
    // Sn110
    150,
    // Sn111
    150,
    // Sn112
    150,
    // Sn113
    150,
    // Sn114
    150,
    // Sn115
    150,
    // Sn116
    150,
    // Sn117
    150,
    // Sn118
    150,
    // Sn119
    150,
    // Sn120
    150,
    // Sn121
    150,
    // Sn122
    150,
    // Sn123
    150,
    // Sn124
    150,
    // Sn125
    150,
    // Sn126
    150,
    // Sn127
    150,
    // Sn128
    150,
    // Sn129
    150,
    // Sn130
    150,
    // Sn131
    150,
    // Sn132
    150,
    // Sn133
    150,
    // Sn134
    150,
    // Sn135
    150,
    // Sn136
    150,
    // Sn137
    150,
    // Sb103
    153,
    // Sb104
    153,
    // Sb105
    153,
    // Sb106
    153,
    // Sb107
    153,
    // Sb108
    153,
    // Sb109
    153,
    // Sb110
    153,
    // Sb111
    153,
    // Sb112
    153,
    // Sb113
    153,
    // Sb114
    153,
    // Sb115
    153,
    // Sb116
    153,
    // Sb117
    153,
    // Sb118
    153,
    // Sb119
    153,
    // Sb120
    153,
    // Sb121
    153,
    // Sb122
    153,
    // Sb123
    153,
    // Sb124
    153,
    // Sb125
    153,
    // Sb126
    153,
    // Sb127
    153,
    // Sb128
    153,
    // Sb129
    153,
    // Sb130
    153,
    // Sb131
    153,
    // Sb132
    153,
    // Sb133
    153,
    // Sb134
    153,
    // Sb135
    153,
    // Sb136
    153,
    // Sb137
    153,
    // Sb138
    153,
    // Sb139
    153,
    // Te106
    156,
    // Te107
    156,
    // Te108
    156,
    // Te109
    156,
    // Te110
    156,
    // Te111
    156,
    // Te112
    156,
    // Te113
    156,
    // Te114
    156,
    // Te115
    156,
    // Te116
    156,
    // Te117
    156,
    // Te118
    156,
    // Te119
    156,
    // Te120
    156,
    // Te121
    156,
    // Te122
    156,
    // Te123
    156,
    // Te124
    156,
    // Te125
    156,
    // Te126
    156,
    // Te127
    156,
    // Te128
    156,
    // Te129
    156,
    // Te130
    156,
    // Te131
    156,
    // Te132
    156,
    // Te133
    156,
    // Te134
    156,
    // Te135
    156,
    // Te136
    156,
    // Te137
    156,
    // Te138
    156,
    // Te139
    156,
    // Te140
    156,
    // Te141
    156,
    // Te142
    156,
    // I108
    159,
    // I109
    159,
    // I110
    159,
    // I111
    159,
    // I112
    159,
    // I113
    159,
    // I114
    159,
    // I115
    159,
    // I116
    159,
    // I117
    159,
    // I118
    159,
    // I119
    159,
    // I120
    159,
    // I121
    159,
    // I122
    159,
    // I123
    159,
    // I124
    159,
    // I125
    159,
    // I126
    159,
    // I127
    159,
    // I128
    159,
    // I129
    159,
    // I130
    159,
    // I131
    159,
    // I132
    159,
    // I133
    159,
    // I134
    159,
    // I135
    159,
    // I136
    159,
    // I137
    159,
    // I138
    159,
    // I139
    159,
    // I140
    159,
    // I141
    159,
    // I142
    159,
    // I143
    159,
    // I144
    159,
    // Xe110
    162,
    // Xe111
    162,
    // Xe112
    162,
    // Xe113
    162,
    // Xe114
    162,
    // Xe115
    162,
    // Xe116
    162,
    // Xe117
    162,
    // Xe118
    162,
    // Xe119
    162,
    // Xe120
    162,
    // Xe121
    162,
    // Xe122
    162,
    // Xe123
    162,
    // Xe124
    162,
    // Xe125
    162,
    // Xe126
    162,
    // Xe127
    162,
    // Xe128
    162,
    // Xe129
    162,
    // Xe130
    162,
    // Xe131
    162,
    // Xe132
    162,
    // Xe133
    162,
    // Xe134
    162,
    // Xe135
    162,
    // Xe136
    162,
    // Xe137
    162,
    // Xe138
    162,
    // Xe139
    162,
    // Xe140
    162,
    // Xe141
    162,
    // Xe142
    162,
    // Xe143
    162,
    // Xe144
    162,
    // Xe145
    162,
    // Xe146
    162,
    // Xe147
    162,
    // Cs112
    165,
    // Cs113
    165,
    // Cs114
    165,
    // Cs115
    165,
    // Cs116
    165,
    // Cs117
    165,
    // Cs118
    165,
    // Cs119
    165,
    // Cs120
    165,
    // Cs121
    165,
    // Cs122
    165,
    // Cs123
    165,
    // Cs124
    165,
    // Cs125
    165,
    // Cs126
    165,
    // Cs127
    165,
    // Cs128
    165,
    // Cs129
    165,
    // Cs130
    165,
    // Cs131
    165,
    // Cs132
    165,
    // Cs133
    165,
    // Cs134
    165,
    // Cs135
    165,
    // Cs136
    165,
    // Cs137
    165,
    // Cs138
    165,
    // Cs139
    165,
    // Cs140
    165,
    // Cs141
    165,
    // Cs142
    165,
    // Cs143
    165,
    // Cs144
    165,
    // Cs145
    165,
    // Cs146
    165,
    // Cs147
    165,
    // Cs148
    165,
    // Cs149
    165,
    // Cs150
    165,
    // Cs151
    165,
    // Ba114
    168,
    // Ba115
    168,
    // Ba116
    168,
    // Ba117
    168,
    // Ba118
    168,
    // Ba119
    168,
    // Ba120
    168,
    // Ba121
    168,
    // Ba122
    168,
    // Ba123
    168,
    // Ba124
    168,
    // Ba125
    168,
    // Ba126
    168,
    // Ba127
    168,
    // Ba128
    168,
    // Ba129
    168,
    // Ba130
    168,
    // Ba131
    168,
    // Ba132
    168,
    // Ba133
    168,
    // Ba134
    168,
    // Ba135
    168,
    // Ba136
    168,
    // Ba137
    168,
    // Ba138
    168,
    // Ba139
    168,
    // Ba140
    168,
    // Ba141
    168,
    // Ba142
    168,
    // Ba143
    168,
    // Ba144
    168,
    // Ba145
    168,
    // Ba146
    168,
    // Ba147
    168,
    // Ba148
    168,
    // Ba149
    168,
    // Ba150
    168,
    // Ba151
    168,
    // Ba152
    168,
    // Ba153
    168,
    // La117
    171,
    // La118
    171,
    // La119
    171,
    // La120
    171,
    // La121
    171,
    // La122
    171,
    // La123
    171,
    // La124
    171,
    // La125
    171,
    // La126
    171,
    // La127
    171,
    // La128
    171,
    // La129
    171,
    // La130
    171,
    // La131
    171,
    // La132
    171,
    // La133
    171,
    // La134
    171,
    // La135
    171,
    // La136
    171,
    // La137
    171,
    // La138
    171,
    // La139
    171,
    // La140
    171,
    // La141
    171,
    // La142
    171,
    // La143
    171,
    // La144
    171,
    // La145
    171,
    // La146
    171,
    // La147
    171,
    // La148
    171,
    // La149
    171,
    // La150
    171,
    // La151
    171,
    // La152
    171,
    // La153
    171,
    // La154
    171,
    // La155
    171,
    // Ce119
    174,
    // Ce120
    174,
    // Ce121
    174,
    // Ce122
    174,
    // Ce123
    174,
    // Ce124
    174,
    // Ce125
    174,
    // Ce126
    174,
    // Ce127
    174,
    // Ce128
    174,
    // Ce129
    174,
    // Ce130
    174,
    // Ce131
    174,
    // Ce132
    174,
    // Ce133
    174,
    // Ce134
    174,
    // Ce135
    174,
    // Ce136
    174,
    // Ce137
    174,
    // Ce138
    174,
    // Ce139
    174,
    // Ce140
    174,
    // Ce141
    174,
    // Ce142
    174,
    // Ce143
    174,
    // Ce144
    174,
    // Ce145
    174,
    // Ce146
    174,
    // Ce147
    174,
    // Ce148
    174,
    // Ce149
    174,
    // Ce150
    174,
    // Ce151
    174,
    // Ce152
    174,
    // Ce153
    174,
    // Ce154
    174,
    // Ce155
    174,
    // Ce156
    174,
    // Ce157
    174,
    // Pr121
    177,
    // Pr122
    177,
    // Pr123
    177,
    // Pr124
    177,
    // Pr125
    177,
    // Pr126
    177,
    // Pr127
    177,
    // Pr128
    177,
    // Pr129
    177,
    // Pr130
    177,
    // Pr131
    177,
    // Pr132
    177,
    // Pr133
    177,
    // Pr134
    177,
    // Pr135
    177,
    // Pr136
    177,
    // Pr137
    177,
    // Pr138
    177,
    // Pr139
    177,
    // Pr140
    177,
    // Pr141
    177,
    // Pr142
    177,
    // Pr143
    177,
    // Pr144
    177,
    // Pr145
    177,
    // Pr146
    177,
    // Pr147
    177,
    // Pr148
    177,
    // Pr149
    177,
    // Pr150
    177,
    // Pr151
    177,
    // Pr152
    177,
    // Pr153
    177,
    // Pr154
    177,
    // Pr155
    177,
    // Pr156
    177,
    // Pr157
    177,
    // Pr158
    177,
    // Pr159
    177,
    // Nd126
    180,
    // Nd127
    180,
    // Nd128
    180,
    // Nd129
    180,
    // Nd130
    180,
    // Nd131
    180,
    // Nd132
    180,
    // Nd133
    180,
    // Nd134
    180,
    // Nd135
    180,
    // Nd136
    180,
    // Nd137
    180,
    // Nd138
    180,
    // Nd139
    180,
    // Nd140
    180,
    // Nd141
    180,
    // Nd142
    180,
    // Nd143
    180,
    // Nd144
    180,
    // Nd145
    180,
    // Nd146
    180,
    // Nd147
    180,
    // Nd148
    180,
    // Nd149
    180,
    // Nd150
    180,
    // Nd151
    180,
    // Nd152
    180,
    // Nd153
    180,
    // Nd154
    180,
    // Nd155
    180,
    // Nd156
    180,
    // Nd157
    180,
    // Nd158
    180,
    // Nd159
    180,
    // Nd160
    180,
    // Nd161
    180,
    // Pm128
    183,
    // Pm129
    183,
    // Pm130
    183,
    // Pm131
    183,
    // Pm132
    183,
    // Pm133
    183,
    // Pm134
    183,
    // Pm135
    183,
    // Pm136
    183,
    // Pm137
    183,
    // Pm138
    183,
    // Pm139
    183,
    // Pm140
    183,
    // Pm141
    183,
    // Pm142
    183,
    // Pm143
    183,
    // Pm144
    183,
    // Pm145
    183,
    // Pm146
    183,
    // Pm147
    183,
    // Pm148
    183,
    // Pm149
    183,
    // Pm150
    183,
    // Pm151
    183,
    // Pm152
    183,
    // Pm153
    183,
    // Pm154
    183,
    // Pm155
    183,
    // Pm156
    183,
    // Pm157
    183,
    // Pm158
    183,
    // Pm159
    183,
    // Pm160
    183,
    // Pm161
    183,
    // Pm162
    183,
    // Pm163
    183,
    // Sm130
    186,
    // Sm131
    186,
    // Sm132
    186,
    // Sm133
    186,
    // Sm134
    186,
    // Sm135
    186,
    // Sm136
    186,
    // Sm137
    186,
    // Sm138
    186,
    // Sm139
    186,
    // Sm140
    186,
    // Sm141
    186,
    // Sm142
    186,
    // Sm143
    186,
    // Sm144
    186,
    // Sm145
    186,
    // Sm146
    186,
    // Sm147
    186,
    // Sm148
    186,
    // Sm149
    186,
    // Sm150
    186,
    // Sm151
    186,
    // Sm152
    186,
    // Sm153
    186,
    // Sm154
    186,
    // Sm155
    186,
    // Sm156
    186,
    // Sm157
    186,
    // Sm158
    186,
    // Sm159
    186,
    // Sm160
    186,
    // Sm161
    186,
    // Sm162
    186,
    // Sm163
    186,
    // Sm164
    186,
    // Sm165
    186,
    // Eu132
    189,
    // Eu133
    189,
    // Eu134
    189,
    // Eu135
    189,
    // Eu136
    189,
    // Eu137
    189,
    // Eu138
    189,
    // Eu139
    189,
    // Eu140
    189,
    // Eu141
    189,
    // Eu142
    189,
    // Eu143
    189,
    // Eu144
    189,
    // Eu145
    189,
    // Eu146
    189,
    // Eu147
    189,
    // Eu148
    189,
    // Eu149
    189,
    // Eu150
    189,
    // Eu151
    189,
    // Eu152
    189,
    // Eu153
    189,
    // Eu154
    189,
    // Eu155
    189,
    // Eu156
    189,
    // Eu157
    189,
    // Eu158
    189,
    // Eu159
    189,
    // Eu160
    189,
    // Eu161
    189,
    // Eu162
    189,
    // Eu163
    189,
    // Eu164
    189,
    // Eu165
    189,
    // Eu166
    189,
    // Eu167
    189,
    // Gd136
    192,
    // Gd137
    192,
    // Gd138
    192,
    // Gd139
    192,
    // Gd140
    192,
    // Gd141
    192,
    // Gd142
    192,
    // Gd143
    192,
    // Gd144
    192,
    // Gd145
    192,
    // Gd146
    192,
    // Gd147
    192,
    // Gd148
    192,
    // Gd149
    192,
    // Gd150
    192,
    // Gd151
    192,
    // Gd152
    192,
    // Gd153
    192,
    // Gd154
    192,
    // Gd155
    192,
    // Gd156
    192,
    // Gd157
    192,
    // Gd158
    192,
    // Gd159
    192,
    // Gd160
    192,
    // Gd161
    192,
    // Gd162
    192,
    // Gd163
    192,
    // Gd164
    192,
    // Gd165
    192,
    // Gd166
    192,
    // Gd167
    192,
    // Gd168
    192,
    // Gd169
    192,
    // Tb138
    195,
    // Tb139
    195,
    // Tb140
    195,
    // Tb141
    195,
    // Tb142
    195,
    // Tb143
    195,
    // Tb144
    195,
    // Tb145
    195,
    // Tb146
    195,
    // Tb147
    195,
    // Tb148
    195,
    // Tb149
    195,
    // Tb150
    195,
    // Tb151
    195,
    // Tb152
    195,
    // Tb153
    195,
    // Tb154
    195,
    // Tb155
    195,
    // Tb156
    195,
    // Tb157
    195,
    // Tb158
    195,
    // Tb159
    195,
    // Tb160
    195,
    // Tb161
    195,
    // Tb162
    195,
    // Tb163
    195,
    // Tb164
    195,
    // Tb165
    195,
    // Tb166
    195,
    // Tb167
    195,
    // Tb168
    195,
    // Tb169
    195,
    // Tb170
    195,
    // Tb171
    195,
    // Dy140
    198,
    // Dy141
    198,
    // Dy142
    198,
    // Dy143
    198,
    // Dy144
    198,
    // Dy145
    198,
    // Dy146
    198,
    // Dy147
    198,
    // Dy148
    198,
    // Dy149
    198,
    // Dy150
    198,
    // Dy151
    198,
    // Dy152
    198,
    // Dy153
    198,
    // Dy154
    198,
    // Dy155
    198,
    // Dy156
    198,
    // Dy157
    198,
    // Dy158
    198,
    // Dy159
    198,
    // Dy160
    198,
    // Dy161
    198,
    // Dy162
    198,
    // Dy163
    198,
    // Dy164
    198,
    // Dy165
    198,
    // Dy166
    198,
    // Dy167
    198,
    // Dy168
    198,
    // Dy169
    198,
    // Dy170
    198,
    // Dy171
    198,
    // Dy172
    198,
    // Dy173
    198,
    // Ho142
    201,
    // Ho143
    201,
    // Ho144
    201,
    // Ho145
    201,
    // Ho146
    201,
    // Ho147
    201,
    // Ho148
    201,
    // Ho149
    201,
    // Ho150
    201,
    // Ho151
    201,
    // Ho152
    201,
    // Ho153
    201,
    // Ho154
    201,
    // Ho155
    201,
    // Ho156
    201,
    // Ho157
    201,
    // Ho158
    201,
    // Ho159
    201,
    // Ho160
    201,
    // Ho161
    201,
    // Ho162
    201,
    // Ho163
    201,
    // Ho164
    201,
    // Ho165
    201,
    // Ho166
    201,
    // Ho167
    201,
    // Ho168
    201,
    // Ho169
    201,
    // Ho170
    201,
    // Ho171
    201,
    // Ho172
    201,
    // Ho173
    201,
    // Ho174
    201,
    // Ho175
    201,
    // Er144
    204,
    // Er145
    204,
    // Er146
    204,
    // Er147
    204,
    // Er148
    204,
    // Er149
    204,
    // Er150
    204,
    // Er151
    204,
    // Er152
    204,
    // Er153
    204,
    // Er154
    204,
    // Er155
    204,
    // Er156
    204,
    // Er157
    204,
    // Er158
    204,
    // Er159
    204,
    // Er160
    204,
    // Er161
    204,
    // Er162
    204,
    // Er163
    204,
    // Er164
    204,
    // Er165
    204,
    // Er166
    204,
    // Er167
    204,
    // Er168
    204,
    // Er169
    204,
    // Er170
    204,
    // Er171
    204,
    // Er172
    204,
    // Er173
    204,
    // Er174
    204,
    // Er175
    204,
    // Er176
    204,
    // Er177
    204,
    // Tm146
    207,
    // Tm147
    207,
    // Tm148
    207,
    // Tm149
    207,
    // Tm150
    207,
    // Tm151
    207,
    // Tm152
    207,
    // Tm153
    207,
    // Tm154
    207,
    // Tm155
    207,
    // Tm156
    207,
    // Tm157
    207,
    // Tm158
    207,
    // Tm159
    207,
    // Tm160
    207,
    // Tm161
    207,
    // Tm162
    207,
    // Tm163
    207,
    // Tm164
    207,
    // Tm165
    207,
    // Tm166
    207,
    // Tm167
    207,
    // Tm168
    207,
    // Tm169
    207,
    // Tm170
    207,
    // Tm171
    207,
    // Tm172
    207,
    // Tm173
    207,
    // Tm174
    207,
    // Tm175
    207,
    // Tm176
    207,
    // Tm177
    207,
    // Tm178
    207,
    // Tm179
    207,
    // Yb148
    210,
    // Yb149
    210,
    // Yb150
    210,
    // Yb151
    210,
    // Yb152
    210,
    // Yb153
    210,
    // Yb154
    210,
    // Yb155
    210,
    // Yb156
    210,
    // Yb157
    210,
    // Yb158
    210,
    // Yb159
    210,
    // Yb160
    210,
    // Yb161
    210,
    // Yb162
    210,
    // Yb163
    210,
    // Yb164
    210,
    // Yb165
    210,
    // Yb166
    210,
    // Yb167
    210,
    // Yb168
    210,
    // Yb169
    210,
    // Yb170
    210,
    // Yb171
    210,
    // Yb172
    210,
    // Yb173
    210,
    // Yb174
    210,
    // Yb175
    210,
    // Yb176
    210,
    // Yb177
    210,
    // Yb178
    210,
    // Yb179
    210,
    // Yb180
    210,
    // Yb181
    210,
    // Lu150
    213,
    // Lu151
    213,
    // Lu152
    213,
    // Lu153
    213,
    // Lu154
    213,
    // Lu155
    213,
    // Lu156
    213,
    // Lu157
    213,
    // Lu158
    213,
    // Lu159
    213,
    // Lu160
    213,
    // Lu161
    213,
    // Lu162
    213,
    // Lu163
    213,
    // Lu164
    213,
    // Lu165
    213,
    // Lu166
    213,
    // Lu167
    213,
    // Lu168
    213,
    // Lu169
    213,
    // Lu170
    213,
    // Lu171
    213,
    // Lu172
    213,
    // Lu173
    213,
    // Lu174
    213,
    // Lu175
    213,
    // Lu176
    213,
    // Lu177
    213,
    // Lu178
    213,
    // Lu179
    213,
    // Lu180
    213,
    // Lu181
    213,
    // Lu182
    213,
    // Lu183
    213,
    // Lu184
    213,
    // Hf154
    216,
    // Hf155
    216,
    // Hf156
    216,
    // Hf157
    216,
    // Hf158
    216,
    // Hf159
    216,
    // Hf160
    216,
    // Hf161
    216,
    // Hf162
    216,
    // Hf163
    216,
    // Hf164
    216,
    // Hf165
    216,
    // Hf166
    216,
    // Hf167
    216,
    // Hf168
    216,
    // Hf169
    216,
    // Hf170
    216,
    // Hf171
    216,
    // Hf172
    216,
    // Hf173
    216,
    // Hf174
    216,
    // Hf175
    216,
    // Hf176
    216,
    // Hf177
    216,
    // Hf178
    216,
    // Hf179
    216,
    // Hf180
    216,
    // Hf181
    216,
    // Hf182
    216,
    // Hf183
    216,
    // Hf184
    216,
    // Hf185
    216,
    // Hf186
    216,
    // Ta156
    219,
    // Ta157
    219,
    // Ta158
    219,
    // Ta159
    219,
    // Ta160
    219,
    // Ta161
    219,
    // Ta162
    219,
    // Ta163
    219,
    // Ta164
    219,
    // Ta165
    219,
    // Ta166
    219,
    // Ta167
    219,
    // Ta168
    219,
    // Ta169
    219,
    // Ta170
    219,
    // Ta171
    219,
    // Ta172
    219,
    // Ta173
    219,
    // Ta174
    219,
    // Ta175
    219,
    // Ta176
    219,
    // Ta177
    219,
    // Ta178
    219,
    // Ta179
    219,
    // Ta180
    219,
    // Ta181
    219,
    // Ta182
    219,
    // Ta183
    219,
    // Ta184
    219,
    // Ta185
    219,
    // Ta186
    219,
    // Ta187
    219,
    // Ta188
    219,
    // W158
    222,
    // W159
    222,
    // W160
    222,
    // W161
    222,
    // W162
    222,
    // W163
    222,
    // W164
    222,
    // W165
    222,
    // W166
    222,
    // W167
    222,
    // W168
    222,
    // W169
    222,
    // W170
    222,
    // W171
    222,
    // W172
    222,
    // W173
    222,
    // W174
    222,
    // W175
    222,
    // W176
    222,
    // W177
    222,
    // W178
    222,
    // W179
    222,
    // W180
    222,
    // W181
    222,
    // W182
    222,
    // W183
    222,
    // W184
    222,
    // W185
    222,
    // W186
    222,
    // W187
    222,
    // W188
    222,
    // W189
    222,
    // W190
    222,
    // Re160
    225,
    // Re161
    225,
    // Re162
    225,
    // Re163
    225,
    // Re164
    225,
    // Re165
    225,
    // Re166
    225,
    // Re167
    225,
    // Re168
    225,
    // Re169
    225,
    // Re170
    225,
    // Re171
    225,
    // Re172
    225,
    // Re173
    225,
    // Re174
    225,
    // Re175
    225,
    // Re176
    225,
    // Re177
    225,
    // Re178
    225,
    // Re179
    225,
    // Re180
    225,
    // Re181
    225,
    // Re182
    225,
    // Re183
    225,
    // Re184
    225,
    // Re185
    225,
    // Re186
    225,
    // Re187
    225,
    // Re188
    225,
    // Re189
    225,
    // Re190
    225,
    // Re191
    225,
    // Re192
    225,
    // Os162
    228,
    // Os163
    228,
    // Os164
    228,
    // Os165
    228,
    // Os166
    228,
    // Os167
    228,
    // Os168
    228,
    // Os169
    228,
    // Os170
    228,
    // Os171
    228,
    // Os172
    228,
    // Os173
    228,
    // Os174
    228,
    // Os175
    228,
    // Os176
    228,
    // Os177
    228,
    // Os178
    228,
    // Os179
    228,
    // Os180
    228,
    // Os181
    228,
    // Os182
    228,
    // Os183
    228,
    // Os184
    228,
    // Os185
    228,
    // Os186
    228,
    // Os187
    228,
    // Os188
    228,
    // Os189
    228,
    // Os190
    228,
    // Os191
    228,
    // Os192
    228,
    // Os193
    228,
    // Os194
    228,
    // Os195
    228,
    // Os196
    228,
    // Ir165
    231,
    // Ir166
    231,
    // Ir167
    231,
    // Ir168
    231,
    // Ir169
    231,
    // Ir170
    231,
    // Ir171
    231,
    // Ir172
    231,
    // Ir173
    231,
    // Ir174
    231,
    // Ir175
    231,
    // Ir176
    231,
    // Ir177
    231,
    // Ir178
    231,
    // Ir179
    231,
    // Ir180
    231,
    // Ir181
    231,
    // Ir182
    231,
    // Ir183
    231,
    // Ir184
    231,
    // Ir185
    231,
    // Ir186
    231,
    // Ir187
    231,
    // Ir188
    231,
    // Ir189
    231,
    // Ir190
    231,
    // Ir191
    231,
    // Ir192
    231,
    // Ir193
    231,
    // Ir194
    231,
    // Ir195
    231,
    // Ir196
    231,
    // Ir197
    231,
    // Ir198
    231,
    // Ir199
    231,
    // Pt168
    234,
    // Pt169
    234,
    // Pt170
    234,
    // Pt171
    234,
    // Pt172
    234,
    // Pt173
    234,
    // Pt174
    234,
    // Pt175
    234,
    // Pt176
    234,
    // Pt177
    234,
    // Pt178
    234,
    // Pt179
    234,
    // Pt180
    234,
    // Pt181
    234,
    // Pt182
    234,
    // Pt183
    234,
    // Pt184
    234,
    // Pt185
    234,
    // Pt186
    234,
    // Pt187
    234,
    // Pt188
    234,
    // Pt189
    234,
    // Pt190
    234,
    // Pt191
    234,
    // Pt192
    234,
    // Pt193
    234,
    // Pt194
    234,
    // Pt195
    234,
    // Pt196
    234,
    // Pt197
    234,
    // Pt198
    234,
    // Pt199
    234,
    // Pt200
    234,
    // Pt201
    234,
    // Pt202
    234,
    // Au171
    237,
    // Au172
    237,
    // Au173
    237,
    // Au174
    237,
    // Au175
    237,
    // Au176
    237,
    // Au177
    237,
    // Au178
    237,
    // Au179
    237,
    // Au180
    237,
    // Au181
    237,
    // Au182
    237,
    // Au183
    237,
    // Au184
    237,
    // Au185
    237,
    // Au186
    237,
    // Au187
    237,
    // Au188
    237,
    // Au189
    237,
    // Au190
    237,
    // Au191
    237,
    // Au192
    237,
    // Au193
    237,
    // Au194
    237,
    // Au195
    237,
    // Au196
    237,
    // Au197
    237,
    // Au198
    237,
    // Au199
    237,
    // Au200
    237,
    // Au201
    237,
    // Au202
    237,
    // Au203
    237,
    // Au204
    237,
    // Au205
    237,
    // Hg175
    240,
    // Hg176
    240,
    // Hg177
    240,
    // Hg178
    240,
    // Hg179
    240,
    // Hg180
    240,
    // Hg181
    240,
    // Hg182
    240,
    // Hg183
    240,
    // Hg184
    240,
    // Hg185
    240,
    // Hg186
    240,
    // Hg187
    240,
    // Hg188
    240,
    // Hg189
    240,
    // Hg190
    240,
    // Hg191
    240,
    // Hg192
    240,
    // Hg193
    240,
    // Hg194
    240,
    // Hg195
    240,
    // Hg196
    240,
    // Hg197
    240,
    // Hg198
    240,
    // Hg199
    240,
    // Hg200
    240,
    // Hg201
    240,
    // Hg202
    240,
    // Hg203
    240,
    // Hg204
    240,
    // Hg205
    240,
    // Hg206
    240,
    // Hg207
    240,
    // Hg208
    240,
    // Tl177
    243,
    // Tl178
    243,
    // Tl179
    243,
    // Tl180
    243,
    // Tl181
    243,
    // Tl182
    243,
    // Tl183
    243,
    // Tl184
    243,
    // Tl185
    243,
    // Tl186
    243,
    // Tl187
    243,
    // Tl188
    243,
    // Tl189
    243,
    // Tl190
    243,
    // Tl191
    243,
    // Tl192
    243,
    // Tl193
    243,
    // Tl194
    243,
    // Tl195
    243,
    // Tl196
    243,
    // Tl197
    243,
    // Tl198
    243,
    // Tl199
    243,
    // Tl200
    243,
    // Tl201
    243,
    // Tl202
    243,
    // Tl203
    243,
    // Tl204
    243,
    // Tl205
    243,
    // Tl206
    243,
    // Tl207
    243,
    // Tl208
    243,
    // Tl209
    243,
    // Tl210
    243,
    // Pb181
    246,
    // Pb182
    246,
    // Pb183
    246,
    // Pb184
    246,
    // Pb185
    246,
    // Pb186
    246,
    // Pb187
    246,
    // Pb188
    246,
    // Pb189
    246,
    // Pb190
    246,
    // Pb191
    246,
    // Pb192
    246,
    // Pb193
    246,
    // Pb194
    246,
    // Pb195
    246,
    // Pb196
    246,
    // Pb197
    246,
    // Pb198
    246,
    // Pb199
    246,
    // Pb200
    246,
    // Pb201
    246,
    // Pb202
    246,
    // Pb203
    246,
    // Pb204
    246,
    // Pb205
    246,
    // Pb206
    246,
    // Pb207
    246,
    // Pb208
    246,
    // Pb209
    246,
    // Pb210
    246,
    // Pb211
    246,
    // Pb212
    246,
    // Pb213
    246,
    // Pb214
    246,
    // Bi185
    249,
    // Bi186
    249,
    // Bi187
    249,
    // Bi188
    249,
    // Bi189
    249,
    // Bi190
    249,
    // Bi191
    249,
    // Bi192
    249,
    // Bi193
    249,
    // Bi194
    249,
    // Bi195
    249,
    // Bi196
    249,
    // Bi197
    249,
    // Bi198
    249,
    // Bi199
    249,
    // Bi200
    249,
    // Bi201
    249,
    // Bi202
    249,
    // Bi203
    249,
    // Bi204
    249,
    // Bi205
    249,
    // Bi206
    249,
    // Bi207
    249,
    // Bi208
    249,
    // Bi209
    249,
    // Bi210
    249,
    // Bi211
    249,
    // Bi212
    249,
    // Bi213
    249,
    // Bi214
    249,
    // Bi215
    249,
    // Bi216
    249,
    // Po190
    252,
    // Po191
    252,
    // Po192
    252,
    // Po193
    252,
    // Po194
    252,
    // Po195
    252,
    // Po196
    252,
    // Po197
    252,
    // Po198
    252,
    // Po199
    252,
    // Po200
    252,
    // Po201
    252,
    // Po202
    252,
    // Po203
    252,
    // Po204
    252,
    // Po205
    252,
    // Po206
    252,
    // Po207
    252,
    // Po208
    252,
    // Po209
    252,
    // Po210
    252,
    // Po211
    252,
    // Po212
    252,
    // Po213
    252,
    // Po214
    252,
    // Po215
    252,
    // Po216
    252,
    // Po217
    252,
    // Po218
    252,
    // At193
    255,
    // At194
    255,
    // At195
    255,
    // At196
    255,
    // At197
    255,
    // At198
    255,
    // At199
    255,
    // At200
    255,
    // At201
    255,
    // At202
    255,
    // At203
    255,
    // At204
    255,
    // At205
    255,
    // At206
    255,
    // At207
    255,
    // At208
    255,
    // At209
    255,
    // At210
    255,
    // At211
    255,
    // At212
    255,
    // At213
    255,
    // At214
    255,
    // At215
    255,
    // At216
    255,
    // At217
    255,
    // At218
    255,
    // At219
    255,
    // At220
    255,
    // At221
    255,
    // At222
    255,
    // At223
    255,
    // Rn196
    258,
    // Rn197
    258,
    // Rn198
    258,
    // Rn199
    258,
    // Rn200
    258,
    // Rn201
    258,
    // Rn202
    258,
    // Rn203
    258,
    // Rn204
    258,
    // Rn205
    258,
    // Rn206
    258,
    // Rn207
    258,
    // Rn208
    258,
    // Rn209
    258,
    // Rn210
    258,
    // Rn211
    258,
    // Rn212
    258,
    // Rn213
    258,
    // Rn214
    258,
    // Rn215
    258,
    // Rn216
    258,
    // Rn217
    258,
    // Rn218
    258,
    // Rn219
    258,
    // Rn220
    258,
    // Rn221
    258,
    // Rn222
    258,
    // Rn223
    258,
    // Rn224
    258,
    // Rn225
    258,
    // Rn226
    258,
    // Rn227
    258,
    // Rn228
    258,
    // Fr200
    261,
    // Fr201
    261,
    // Fr202
    261,
    // Fr203
    261,
    // Fr204
    261,
    // Fr205
    261,
    // Fr206
    261,
    // Fr207
    261,
    // Fr208
    261,
    // Fr209
    261,
    // Fr210
    261,
    // Fr211
    261,
    // Fr212
    261,
    // Fr213
    261,
    // Fr214
    261,
    // Fr215
    261,
    // Fr216
    261,
    // Fr217
    261,
    // Fr218
    261,
    // Fr219
    261,
    // Fr220
    261,
    // Fr221
    261,
    // Fr222
    261,
    // Fr223
    261,
    // Fr224
    261,
    // Fr225
    261,
    // Fr226
    261,
    // Fr227
    261,
    // Fr228
    261,
    // Fr229
    261,
    // Fr230
    261,
    // Fr231
    261,
    // Fr232
    261,
    // Ra203
    264,
    // Ra204
    264,
    // Ra205
    264,
    // Ra206
    264,
    // Ra207
    264,
    // Ra208
    264,
    // Ra209
    264,
    // Ra210
    264,
    // Ra211
    264,
    // Ra212
    264,
    // Ra213
    264,
    // Ra214
    264,
    // Ra215
    264,
    // Ra216
    264,
    // Ra217
    264,
    // Ra218
    264,
    // Ra219
    264,
    // Ra220
    264,
    // Ra221
    264,
    // Ra222
    264,
    // Ra223
    264,
    // Ra224
    264,
    // Ra225
    264,
    // Ra226
    264,
    // Ra227
    264,
    // Ra228
    264,
    // Ra229
    264,
    // Ra230
    264,
    // Ra231
    264,
    // Ra232
    264,
    // Ra233
    264,
    // Ra234
    264,
    // Ac207
    267,
    // Ac208
    267,
    // Ac209
    267,
    // Ac210
    267,
    // Ac211
    267,
    // Ac212
    267,
    // Ac213
    267,
    // Ac214
    267,
    // Ac215
    267,
    // Ac216
    267,
    // Ac217
    267,
    // Ac218
    267,
    // Ac219
    267,
    // Ac220
    267,
    // Ac221
    267,
    // Ac222
    267,
    // Ac223
    267,
    // Ac224
    267,
    // Ac225
    267,
    // Ac226
    267,
    // Ac227
    267,
    // Ac228
    267,
    // Ac229
    267,
    // Ac230
    267,
    // Ac231
    267,
    // Ac232
    267,
    // Ac233
    267,
    // Ac234
    267,
    // Ac235
    267,
    // Ac236
    267,
    // Th210
    270,
    // Th211
    270,
    // Th212
    270,
    // Th213
    270,
    // Th214
    270,
    // Th215
    270,
    // Th216
    270,
    // Th217
    270,
    // Th218
    270,
    // Th219
    270,
    // Th220
    270,
    // Th221
    270,
    // Th222
    270,
    // Th223
    270,
    // Th224
    270,
    // Th225
    270,
    // Th226
    270,
    // Th227
    270,
    // Th228
    270,
    // Th229
    270,
    // Th230
    270,
    // Th231
    270,
    // Th232
    270,
    // Th233
    270,
    // Th234
    270,
    // Th235
    270,
    // Th236
    270,
    // Th237
    270,
    // Th238
    270,
    // Pa213
    273,
    // Pa214
    273,
    // Pa215
    273,
    // Pa216
    273,
    // Pa217
    273,
    // Pa218
    273,
    // Pa219
    273,
    // Pa220
    273,
    // Pa221
    273,
    // Pa222
    273,
    // Pa223
    273,
    // Pa224
    273,
    // Pa225
    273,
    // Pa226
    273,
    // Pa227
    273,
    // Pa228
    273,
    // Pa229
    273,
    // Pa230
    273,
    // Pa231
    273,
    // Pa232
    273,
    // Pa233
    273,
    // Pa234
    273,
    // Pa235
    273,
    // Pa236
    273,
    // Pa237
    273,
    // Pa238
    273,
    // Pa239
    273,
    // Pa240
    273,
    // U218
    276,
    // U219
    276,
    // U220
    276,
    // U221
    276,
    // U222
    276,
    // U223
    276,
    // U224
    276,
    // U225
    276,
    // U226
    276,
    // U227
    276,
    // U228
    276,
    // U229
    276,
    // U230
    276,
    // U231
    276,
    // U232
    276,
    // U233
    276,
    // U234
    276,
    // U235
    276,
    // U236
    276,
    // U237
    276,
    // U238
    276,
    // U239
    276,
    // U240
    276,
    // U241
    276,
    // U242
    276,
    // Np225
    279,
    // Np226
    279,
    // Np227
    279,
    // Np228
    279,
    // Np229
    279,
    // Np230
    279,
    // Np231
    279,
    // Np232
    279,
    // Np233
    279,
    // Np234
    279,
    // Np235
    279,
    // Np236
    279,
    // Np237
    279,
    // Np238
    279,
    // Np239
    279,
    // Np240
    279,
    // Np241
    279,
    // Np242
    279,
    // Np243
    279,
    // Np244
    279,
    // Pu228
    282,
    // Pu229
    282,
    // Pu230
    282,
    // Pu231
    282,
    // Pu232
    282,
    // Pu233
    282,
    // Pu234
    282,
    // Pu235
    282,
    // Pu236
    282,
    // Pu237
    282,
    // Pu238
    282,
    // Pu239
    282,
    // Pu240
    282,
    // Pu241
    282,
    // Pu242
    282,
    // Pu243
    282,
    // Pu244
    282,
    // Pu245
    282,
    // Pu246
    282,
    // Pu247
    282,
    // Am231
    285,
    // Am232
    285,
    // Am233
    285,
    // Am234
    285,
    // Am235
    285,
    // Am236
    285,
    // Am237
    285,
    // Am238
    285,
    // Am239
    285,
    // Am240
    285,
    // Am241
    285,
    // Am242
    285,
    // Am243
    285,
    // Am244
    285,
    // Am245
    285,
    // Am246
    285,
    // Am247
    285,
    // Am248
    285,
    // Am249
    285,
    // Cm233
    288,
    // Cm234
    288,
    // Cm235
    288,
    // Cm236
    288,
    // Cm237
    288,
    // Cm238
    288,
    // Cm239
    288,
    // Cm240
    288,
    // Cm241
    288,
    // Cm242
    288,
    // Cm243
    288,
    // Cm244
    288,
    // Cm245
    288,
    // Cm246
    288,
    // Cm247
    288,
    // Cm248
    288,
    // Cm249
    288,
    // Cm250
    288,
    // Cm251
    288,
    // Cm252
    288,
    // Bk235
    291,
    // Bk236
    291,
    // Bk237
    291,
    // Bk238
    291,
    // Bk239
    291,
    // Bk240
    291,
    // Bk241
    291,
    // Bk242
    291,
    // Bk243
    291,
    // Bk244
    291,
    // Bk245
    291,
    // Bk246
    291,
    // Bk247
    291,
    // Bk248
    291,
    // Bk249
    291,
    // Bk250
    291,
    // Bk251
    291,
    // Bk252
    291,
    // Bk253
    291,
    // Bk254
    291,
    // Cf237
    294,
    // Cf238
    294,
    // Cf239
    294,
    // Cf240
    294,
    // Cf241
    294,
    // Cf242
    294,
    // Cf243
    294,
    // Cf244
    294,
    // Cf245
    294,
    // Cf246
    294,
    // Cf247
    294,
    // Cf248
    294,
    // Cf249
    294,
    // Cf250
    294,
    // Cf251
    294,
    // Cf252
    294,
    // Cf253
    294,
    // Cf254
    294,
    // Cf255
    294,
    // Cf256
    294,
    // Es240
    297,
    // Es241
    297,
    // Es242
    297,
    // Es243
    297,
    // Es244
    297,
    // Es245
    297,
    // Es246
    297,
    // Es247
    297,
    // Es248
    297,
    // Es249
    297,
    // Es250
    297,
    // Es251
    297,
    // Es252
    297,
    // Es253
    297,
    // Es254
    297,
    // Es255
    297,
    // Es256
    297,
    // Es257
    297,
    // Fm242
    300,
    // Fm243
    300,
    // Fm244
    300,
    // Fm245
    300,
    // Fm246
    300,
    // Fm247
    300,
    // Fm248
    300,
    // Fm249
    300,
    // Fm250
    300,
    // Fm251
    300,
    // Fm252
    300,
    // Fm253
    300,
    // Fm254
    300,
    // Fm255
    300,
    // Fm256
    300,
    // Fm257
    300,
    // Fm258
    300,
    // Fm259
    300,
    // Md245
    303,
    // Md246
    303,
    // Md247
    303,
    // Md248
    303,
    // Md249
    303,
    // Md250
    303,
    // Md251
    303,
    // Md252
    303,
    // Md253
    303,
    // Md254
    303,
    // Md255
    303,
    // Md256
    303,
    // Md257
    303,
    // Md258
    303,
    // Md259
    303,
    // Md260
    303,
    // No249
    306,
    // No250
    306,
    // No251
    306,
    // No252
    306,
    // No253
    306,
    // No254
    306,
    // No255
    306,
    // No256
    306,
    // No257
    306,
    // No258
    306,
    // No259
    306,
    // No260
    306,
    // No261
    306,
    // No262
    306,
    // Lr251
    309,
    // Lr252
    309,
    // Lr253
    309,
    // Lr254
    309,
    // Lr255
    309,
    // Lr256
    309,
    // Lr257
    309,
    // Lr258
    309,
    // Lr259
    309,
    // Lr260
    309,
    // Lr261
    309,
    // Lr262
    309,
    // Lr263
    309,
    // Rf253
    312,
    // Rf254
    312,
    // Rf255
    312,
    // Rf256
    312,
    // Rf257
    312,
    // Rf258
    312,
    // Rf259
    312,
    // Rf260
    312,
    // Rf261
    312,
    // Rf262
    312,
    // Rf263
    312,
    // Rf264
    312,
    // Db255
    315,
    // Db256
    315,
    // Db257
    315,
    // Db258
    315,
    // Db259
    315,
    // Db260
    315,
    // Db261
    315,
    // Db262
    315,
    // Db263
    315,
    // Db264
    315,
    // Db265
    315,
    // Sg258
    318,
    // Sg259
    318,
    // Sg260
    318,
    // Sg261
    318,
    // Sg262
    318,
    // Sg263
    318,
    // Sg264
    318,
    // Sg265
    318,
    // Sg266
    318,
    // Bh260
    321,
    // Bh261
    321,
    // Bh262
    321,
    // Bh263
    321,
    // Bh264
    321,
    // Bh265
    321,
    // Bh266
    321,
    // Bh267
    321,
    // Hs263
    324,
    // Hs264
    324,
    // Hs265
    324,
    // Hs266
    324,
    // Hs267
    324,
    // Hs268
    324,
    // Hs269
    324,
    // Hs277
    324,
    // Mt265
    327,
    // Mt266
    327,
    // Mt267
    327,
    // Mt268
    327,
    // Mt269
    327,
    // Mt270
    327,
    // Mt271
    327,
    // Ds267
    330,
    // Ds268
    330,
    // Ds269
    330,
    // Ds270
    330,
    // Ds271
    330,
    // Ds272
    330,
    // Ds273
    330,
    // Ds281
    330,
    // Rg272
    333,
    // Cn285
    336,
    // Nh286
    339,
    // Fl289
    342,
    // Mc289
    345,
    // Lv293
    348,
    // Ts294
    351,
    // Og294
    354,
};
static const std::array<float, kParticlesCount> kParticlesMassMeV = {
    // Og294~
    0.0f,
    // Ts294~
    0.0f,
    // Lv293~
    0.0f,
    // Mc289~
    0.0f,
    // Fl289~
    0.0f,
    // Nh286~
    0.0f,
    // Cn285~
    0.0f,
    // Rg272~
    253509.3615636f,
    // Ds281~
    0.0f,
    // Ds273~
    254436.9154459f,
    // Ds272~
    253502.6827509f,
    // Ds271~
    252570.9744049f,
    // Ds270~
    251638.129636f,
    // Ds269~
    250707.1105956f,
    // Ds268~
    249774.1167877f,
    // Ds267~
    248843.0232278f,
    // Mt271~
    252566.4566585f,
    // Mt270~
    251634.4874941f,
    // Mt269~
    250701.4936862f,
    // Mt268~
    249769.7294505f,
    // Mt267~
    248837.0337207f,
    // Mt266~
    247905.9215309f,
    // Mt265~
    246973.1512816f,
    // Hs277~
    0.0f,
    // Hs269~
    250696.8362157f,
    // Hs268~
    249763.5256998f,
    // Hs267~
    248831.6683147f,
    // Hs266~
    247898.5627275f,
    // Hs265~
    246967.0313654f,
    // Hs264~
    246034.0561874f,
    // Hs263~
    245102.8415332f,
    // Bh267~
    248827.9143935f,
    // Bh266~
    247895.7403004f,
    // Bh265~
    246962.5601937f,
    // Bh264~
    246030.6282891f,
    // Bh263~
    245097.662426f,
    // Bh262~
    244166.0379145f,
    // Bh261~
    243233.4167042f,
    // Bh260~
    242301.9226018f,
    // Sg266~
    247891.0083104f,
    // Sg265~
    246958.713123f,
    // Sg264~
    246025.2163083f,
    // Sg263~
    245093.1539946f,
    // Sg262~
    244159.955258f,
    // Sg261~
    243228.2003372f,
    // Sg260~
    242295.0668052f,
    // Sg259~
    241363.7683166f,
    // Sg258~
    240430.8769731f,
    // Db265~
    246956.4682223f,
    // Db264~
    246023.8656419f,
    // Db263~
    245090.1452686f,
    // Db262~
    244157.7848767f,
    // Db261~
    243224.3905264f,
    // Db260~
    242292.263008f,
    // Db259~
    241359.1760507f,
    // Db258~
    240427.4211299f,
    // Db257~
    239494.4552669f,
    // Db256~
    238563.194038f,
    // Db255~
    237631.0385748f,
    // Rf264~
    246020.6147275f,
    // Rf263~
    245087.7792736f,
    // Rf262~
    244153.8446567f,
    // Rf261~
    243221.2607062f,
    // Rf260~
    242287.6055375f,
    // Rf259~
    241355.3662398f,
    // Rf258~
    240421.9532596f,
    // Rf257~
    239489.9934101f,
    // Rf256~
    238556.7387839f,
    // Rf255~
    237625.5334447f,
    // Rf254~
    236692.8097701f,
    // Rf253~
    235761.7907297f,
    // Lr263~
    245086.7080554f,
    // Lr262~
    244153.630413f,
    // Lr261~
    243219.5747018f,
    // Lr260~
    242286.8044525f,
    // Lr259~
    241352.9070954f,
    // Lr258~
    240420.3790345f,
    // Lr257~
    239486.7704405f,
    // Lr256~
    238554.4845682f,
    // Lr255~
    237621.1367925f,
    // Lr254~
    236689.4750212f,
    // Lr253~
    235756.7420316f,
    // Lr252~
    234825.3131338f,
    // Lr251~
    233892.9154822f,
    // No262~
    244151.6090708f,
    // No261~
    243218.4569089f,
    // No260~
    242284.0751748f,
    // No259~
    241351.072052f,
    // No258~
    240416.9511362f,
    // No257~
    239484.1995168f,
    // No256~
    238550.3077486f,
    // No255~
    237617.8411664f,
    // No254~
    236684.220463f,
    // No253~
    235752.4478438f,
    // No252~
    234819.3851054f,
    // No251~
    233887.885414f,
    // No250~
    232955.0220153f,
    // No249~
    232023.835306f,
    // Md260~
    242285.0159839f,
    // Md259~
    241350.5876751f,
    // Md258~
    240417.1607224f,
    // Md257~
    239482.9746021f,
    // Md256~
    238550.0972309f,
    // Md255~
    237615.8319336f,
    // Md254~
    236683.0849716f,
    // Md253~
    235749.3087087f,
    // Md252~
    234817.2091352f,
    // Md251~
    233884.1221779f,
    // Md250~
    232952.227533f,
    // Md249~
    232019.3455044f,
    // Md248~
    231087.7675676f,
    // Md247~
    230155.2395067f,
    // Md246~
    229223.8664986f,
    // Md245~
    228291.5247365f,
    // Fm259~
    241350.6715095f,
    // Fm258~
    240415.8985479f,
    // Fm257~
    239482.5684706f,
    // Fm256~
    238547.9706299f,
    // Fm255~
    237614.7886602f,
    // Fm254~
    236680.4004056f,
    // Fm253~
    235747.3488451f,
    // Fm252~
    234813.3248047f,
    // Fm251~
    233880.9979466f,
    // Fm250~
    232947.5933498f,
    // Fm249~
    232015.6381579f,
    // Fm248~
    231082.4338323f,
    // Fm247~
    230150.6006661f,
    // Fm246~
    229217.6720628f,
    // Fm245~
    228286.2711098f,
    // Fm244~
    227353.5660651f,
    // Fm243~
    226422.4725052f,
    // Fm242~
    225489.9723892f,
    // Es257~
    239483.3891169f,
    // Es256~
    238549.6687436f,
    // Es255~
    237615.0783549f,
    // Es254~
    236681.4883908f,
    // Es253~
    235747.0153702f,
    // Es252~
    234813.7998667f,
    // Es251~
    233879.524323f,
    // Es250~
    232946.7876074f,
    // Es249~
    232013.2069583f,
    // Es248~
    231080.8279365f,
    // Es247~
    230147.6478298f,
    // Es246~
    229215.5203114f,
    // Es245~
    228282.4892438f,
    // Es244~
    227350.6691184f,
    // Es243~
    226417.9268139f,
    // Es242~
    225486.4979162f,
    // Es241~
    224554.0350599f,
    // Es240~
    223622.783146f,
    // Cf256~
    238549.5290195f,
    // Cf255~
    237615.7993313f,
    // Cf254~
    236680.8363449f,
    // Cf253~
    235747.3032019f,
    // Cf252~
    234812.5423497f,
    // Cf251~
    233879.1479993f,
    // Cf250~
    232944.6917457f,
    // Cf249~
    232011.751033f,
    // Cf248~
    231077.7707728f,
    // Cf247~
    230145.1719185f,
    // Cf246~
    229211.6348632f,
    // Cf245~
    228279.4339431f,
    // Cf244~
    227346.0302778f,
    // Cf243~
    226414.0052238f,
    // Cf242~
    225480.8996366f,
    // Cf241~
    224549.433479f,
    // Cf240~
    223616.616655f,
    // Cf239~
    222685.383371f,
    // Cf238~
    221752.7994205f,
    // Cf237~
    220821.9201042f,
    // Bk254~
    236683.8953715f,
    // Bk253~
    235748.9361111f,
    // Bk252~
    234815.0387539f,
    // Bk251~
    233880.2406419f,
    // Bk250~
    232946.4718309f,
    // Bk249~
    232011.8749217f,
    // Bk248~
    231078.6109805f,
    // Bk247~
    230144.526393f,
    // Bk246~
    229211.5148868f,
    // Bk245~
    228277.8647481f,
    // Bk244~
    227345.2645896f,
    // Bk243~
    226411.752871f,
    // Bk242~
    225479.3719863f,
    // Bk241~
    224546.1732497f,
    // Bk240~
    223614.2413451f,
    // Bk239~
    222681.4524659f,
    // Bk238~
    221749.874529f,
    // Bk237~
    220817.3185234f,
    // Bk236~
    219886.0107198f,
    // Bk235~
    218953.8179968f,
    // Cm252~
    234815.5697055f,
    // Cm251~
    233881.6611704f,
    // Cm250~
    232946.5090907f,
    // Cm249~
    232012.7756765f,
    // Cm248~
    231077.9235379f,
    // Cm247~
    230144.5711048f,
    // Cm246~
    229210.1619847f,
    // Cm245~
    228277.0545346f,
    // Cm244~
    227343.0087904f,
    // Cm243~
    226410.2440369f,
    // Cm242~
    225476.3719232f,
    // Cm241~
    224543.7762359f,
    // Cm240~
    223610.3001935f,
    // Cm239~
    222678.276071f,
    // Cm238~
    221744.984185f,
    // Cm237~
    220813.3689884f,
    // Cm236~
    219880.4962747f,
    // Cm235~
    218949.1698413f,
    // Cm234~
    218016.4182218f,
    // Cm233~
    217085.4457561f,
    // Am249~
    232015.1351511f,
    // Am248~
    231081.0980698f,
    // Am247~
    230146.194699f,
    // Am246~
    229212.5376673f,
    // Am245~
    228277.94821f,
    // Am244~
    227344.436864f,
    // Am243~
    226410.2351877f,
    // Am242~
    225477.0367306f,
    // Am241~
    224543.0088711f,
    // Am240~
    223610.0850184f,
    // Am239~
    222676.4764244f,
    // Am238~
    221744.0154311f,
    // Am237~
    220810.6490256f,
    // Am236~
    219878.7823256f,
    // Am235~
    218945.8537223f,
    // Am234~
    218014.1360613f,
    // Am233~
    217081.4123867f,
    // Am232~
    216150.0300636f,
    // Am231~
    215217.5765223f,
    // Pu247~
    230148.0390573f,
    // Pu246~
    229212.9382098f,
    // Pu245~
    228279.1535634f,
    // Pu244~
    227344.3610404f,
    // Pu243~
    226410.8167195f,
    // Pu242~
    225476.28576f,
    // Pu241~
    224543.0297365f,
    // Pu240~
    223608.7059414f,
    // Pu239~
    222675.6739422f,
    // Pu238~
    221741.7550675f,
    // Pu237~
    220809.1901195f,
    // Pu236~
    219875.5016965f,
    // Pu235~
    218943.2939765f,
    // Pu234~
    218009.9583102f,
    // Pu233~
    217078.1707872f,
    // Pu232~
    216144.989749f,
    // Pu231~
    215213.5710976f,
    // Pu230~
    214280.5735638f,
    // Pu229~
    213349.5396195f,
    // Pu228~
    212416.7321104f,
    // Np244~
    227347.7628568f,
    // Np243~
    226412.9340056f,
    // Np242~
    225478.9900737f,
    // Np241~
    224544.3382063f,
    // Np240~
    223610.9056647f,
    // Np239~
    222676.395757f,
    // Np238~
    221743.047143f,
    // Np237~
    220808.9698212f,
    // Np236~
    219875.9785283f,
    // Np235~
    218942.1518715f,
    // Np234~
    218009.5708087f,
    // Np233~
    217076.0656105f,
    // Np232~
    216143.9846669f,
    // Np231~
    215210.7486705f,
    // Np230~
    214278.8633406f,
    // Np229~
    213345.9161074f,
    // Np228~
    212414.3568004f,
    // Np227~
    211481.7262753f,
    // Np226~
    210550.3905269f,
    // Np225~
    209617.7506867f,
    // U242~
    225480.1917011f,
    // U241~
    224546.275714f,
    // U240~
    223611.2940977f,
    // U239~
    222677.6592356f,
    // U238~
    221742.9000601f,
    // U237~
    220809.4883839f,
    // U236~
    219875.048804f,
    // U235~
    218942.0281691f,
    // U234~
    218007.7605431f,
    // U233~
    217075.039104f,
    // U232~
    216141.2333127f,
    // U231~
    215208.9406405f,
    // U230~
    214275.246349f,
    // U229~
    213343.3507727f,
    // U228~
    212409.8725878f,
    // U227~
    211478.1679678f,
    // U226~
    210544.997176f,
    // U225~
    209613.5403334f,
    // U224~
    208680.3788566f,
    // U223~
    207749.0058484f,
    // U222~
    206815.9747808f,
    // U221~
    205884.7414967f,
    // U220~
    204951.719744f,
    // U219~
    204020.4212554f,
    // U218~
    203087.5951164f,
    // Pa240~
    223615.3870828f,
    // Pa239~
    222680.3067281f,
    // Pa238~
    221746.3627963f,
    // Pa237~
    220811.7388737f,
    // Pa236~
    219877.9532958f,
    // Pa235~
    218943.4411525f,
    // Pa234~
    218009.9555158f,
    // Pa233~
    217075.6093647f,
    // Pa232~
    216142.5706588f,
    // Pa231~
    215208.5586347f,
    // Pa230~
    214275.8108344f,
    // Pa229~
    213342.0401605f,
    // Pa228~
    212409.5661263f,
    // Pa227~
    211475.9817511f,
    // Pa226~
    210543.6865638f,
    // Pa225~
    209610.5036626f,
    // Pa224~
    208678.5344982f,
    // Pa223~
    207745.5034306f,
    // Pa222~
    206813.7950846f,
    // Pa221~
    205880.5590882f,
    // Pa220~
    204949.0836157f,
    // Pa219~
    204015.7265251f,
    // Pa218~
    203084.353517f,
    // Pa217~
    202151.2572447f,
    // Pa216~
    201220.5269675f,
    // Pa215~
    200289.0235502f,
    // Pa214~
    199359.0570981f,
    // Pa213~
    198427.9728531f,
    // Th238~
    221747.983596f,
    // Th237~
    220814.3004825f,
    // Th236~
    219878.9127347f,
    // Th235~
    218945.3600304f,
    // Th234~
    218010.2284435f,
    // Th233~
    217076.8544929f,
    // Th232~
    216142.0754766f,
    // Th231~
    215208.9481856f,
    // Th230~
    214274.5007811f,
    // Th229~
    213341.7290414f,
    // Th228~
    212407.4183803f,
    // Th227~
    211474.9626966f,
    // Th226~
    210540.8529588f,
    // Th225~
    209608.473937f,
    // Th224~
    208674.6678662f,
    // Th223~
    207742.5552518f,
    // Th222~
    206808.8805217f,
    // Th221~
    205877.1228065f,
    // Th220~
    204943.3577215f,
    // Th219~
    204011.6652108f,
    // Th218~
    203078.0733837f,
    // Th217~
    202146.3948455f,
    // Th216~
    201213.0200565f,
    // Th215~
    200282.1584386f,
    // Th214~
    199350.4035179f,
    // Th213~
    198420.3159716f,
    // Th212~
    197488.7846095f,
    // Th211~
    196559.0976056f,
    // Th210~
    195627.7618572f,
    // Ac236~
    219884.0080075f,
    // Ac235~
    218948.7134092f,
    // Ac234~
    218014.7229026f,
    // Ac233~
    217079.623918f,
    // Ac232~
    216145.7731355f,
    // Ac231~
    215211.0467486f,
    // Ac230~
    214277.2052811f,
    // Ac229~
    213342.823547f,
    // Ac228~
    212409.5454471f,
    // Ac227~
    211475.0074083f,
    // Ac226~
    210541.9698202f,
    // Ac225~
    209607.8032612f,
    // Ac224~
    208674.8998083f,
    // Ac223~
    207741.0005881f,
    // Ac222~
    206808.2983379f,
    // Ac221~
    205874.7093052f,
    // Ac220~
    204942.4420628f,
    // Ac219~
    204008.7589492f,
    // Ac218~
    203076.5475964f,
    // Ac217~
    202142.913852f,
    // Ac216~
    201210.8496753f,
    // Ac215~
    200277.2401498f,
    // Ac214~
    199346.1559048f,
    // Ac213~
    198414.3637243f,
    // Ac212~
    197484.0246746f,
    // Ac211~
    196552.3815332f,
    // Ac210~
    195622.3871363f,
    // Ac209~
    194691.1817971f,
    // Ac208~
    193761.4761634f,
    // Ac207~
    192830.5409574f,
    // Ra234~
    218016.706985f,
    // Ra233~
    217082.8375727f,
    // Ra232~
    216147.3287307f,
    // Ra231~
    215213.5338379f,
    // Ra230~
    214278.1833499f,
    // Ra229~
    213344.5840709f,
    // Ra228~
    212409.5913698f,
    // Ra227~
    211476.3335764f,
    // Ra226~
    210541.3295111f,
    // Ra225~
    209608.1600235f,
    // Ra224~
    208673.4969781f,
    // Ra223~
    207740.4146783f,
    // Ra222~
    206806.0003419f,
    // Ra221~
    205873.1518471f,
    // Ra220~
    204938.9629323f,
    // Ra219~
    204006.5876365f,
    // Ra218~
    203072.350284f,
    // Ra217~
    202140.0942194f,
    // Ra216~
    201206.0031115f,
    // Ra215~
    200273.7507729f,
    // Ra214~
    199339.8226764f,
    // Ra213~
    198408.569831f,
    // Ra212~
    197476.5475714f,
    // Ra211~
    196546.084633f,
    // Ra210~
    195614.1806732f,
    // Ra209~
    194684.0744971f,
    // Ra208~
    193752.4313556f,
    // Ra207~
    192822.7536667f,
    // Ra206~
    191891.3061391f,
    // Ra205~
    190962.0569375f,
    // Ra204~
    190030.8329684f,
    // Ra203~
    189101.8818449f,
    // Fr232~
    216152.8804355f,
    // Fr231~
    215217.4367982f,
    // Fr230~
    214283.2413629f,
    // Fr229~
    213347.9467646f,
    // Fr228~
    212413.9283132f,
    // Fr227~
    211478.8106987f,
    // Fr226~
    210544.997176f,
    // Fr225~
    209610.0258061f,
    // Fr224~
    208676.3268572f,
    // Fr223~
    207741.5638626f,
    // Fr222~
    206808.032862f,
    // Fr221~
    205873.4666921f,
    // Fr220~
    204940.1720116f,
    // Fr219~
    204005.8163594f,
    // Fr218~
    203072.7592099f,
    // Fr217~
    202138.5199944f,
    // Fr216~
    201205.6957184f,
    // Fr215~
    200271.5356799f,
    // Fr214~
    199338.7644991f,
    // Fr213~
    198404.6808431f,
    // Fr212~
    197473.2053706f,
    // Fr211~
    196541.0908931f,
    // Fr210~
    195610.4062591f,
    // Fr209~
    194678.4669026f,
    // Fr208~
    193748.099908f,
    // Fr207~
    192816.3543023f,
    // Fr206~
    191886.3785353f,
    // Fr205~
    190955.0427869f,
    // Fr204~
    190025.3464681f,
    // Fr203~
    189094.280853f,
    // Fr202~
    188164.8732974f,
    // Fr201~
    187234.0312409f,
    // Fr200~
    186304.8751887f,
    // Rn228~
    212416.1266392f,
    // Rn227~
    211482.1454476f,
    // Rn226~
    210546.4409919f,
    // Rn225~
    209612.6647289f,
    // Rn224~
    208677.1186272f,
    // Rn223~
    207743.4820884f,
    // Rn222~
    206808.0575466f,
    // Rn221~
    205874.5975259f,
    // Rn220~
    204939.3067468f,
    // Rn219~
    204006.034329f,
    // Rn218~
    203070.917646f,
    // Rn217~
    202137.867017f,
    // Rn216~
    201202.9664407f,
    // Rn215~
    200270.0480838f,
    // Rn214~
    199335.4027369f,
    // Rn213~
    198402.5318862f,
    // Rn212~
    197468.0765641f,
    // Rn211~
    196536.4855863f,
    // Rn210~
    195604.1484818f,
    // Rn209~
    194673.3064252f,
    // Rn208~
    193741.1146338f,
    // Rn207~
    192810.6442434f,
    // Rn206~
    191878.6191894f,
    // Rn205~
    190948.5316431f,
    // Rn204~
    190016.7580925f,
    // Rn203~
    189087.0804036f,
    // Rn202~
    188155.4931518f,
    // Rn201~
    187226.1601157f,
    // Rn200~
    186294.7964225f,
    // Rn199~
    185365.7521496f,
    // Rn198~
    184434.6958495f,
    // Rn197~
    183505.8844501f,
    // Rn196~
    182574.9958189f,
    // At223~
    207746.7888925f,
    // At222~
    206812.4909928f,
    // At221~
    205877.0939301f,
    // At220~
    204942.9543845f,
    // At219~
    204007.7343057f,
    // At218~
    203073.8006203f,
    // At217~
    202138.6075548f,
    // At216~
    201204.9700845f,
    // At215~
    200269.9661123f,
    // At214~
    199336.3435459f,
    // At213~
    198401.6497613f,
    // At212~
    197468.1194128f,
    // At211~
    196533.5942286f,
    // At210~
    195601.7741033f,
    // At209~
    194669.3745886f,
    // At208~
    193738.2754397f,
    // At207~
    192806.0296216f,
    // At206~
    191875.3030704f,
    // At205~
    190943.2873313f,
    // At204~
    190012.9296517f,
    // At203~
    189081.0536367f,
    // At202~
    188151.0499249f,
    // At201~
    187219.5930823f,
    // At200~
    186289.7756693f,
    // At199~
    185358.5982749f,
    // At198~
    184429.07894f,
    // At197~
    183498.0878445f,
    // At196~
    182568.8386429f,
    // At195~
    181638.1363105f,
    // At194~
    180708.8964238f,
    // At193~
    179778.5387442f,
    // Po218~
    203074.0659098f,
    // Po217~
    202140.0420557f,
    // Po216~
    201204.5007978f,
    // Po215~
    200270.6870888f,
    // Po214~
    199335.2536978f,
    // Po213~
    198401.5771048f,
    // Po212~
    197466.3654094f,
    // Po211~
    196532.8080476f,
    // Po210~
    195597.7928975f,
    // Po209~
    194665.8880062f,
    // Po208~
    193733.2900833f,
    // Po207~
    192802.1192094f,
    // Po206~
    191869.5883541f,
    // Po205~
    190938.750955f,
    // Po204~
    190006.4529732f,
    // Po203~
    189075.9863088f,
    // Po202~
    188143.8308456f,
    // Po201~
    187213.7432993f,
    // Po200~
    186281.8113947f,
    // Po199~
    185352.0498714f,
    // Po198~
    184420.3135805f,
    // Po197~
    183490.89671f,
    // Po196~
    182559.346718f,
    // Po195~
    181630.2186106f,
    // Po194~
    180698.9387518f,
    // Po193~
    179770.0714628f,
    // Po192~
    178838.968588f,
    // Po191~
    177910.3900621f,
    // Po190~
    176979.324447f,
    // Bi216~
    201208.5013786f,
    // Bi215~
    200272.936647f,
    // Bi214~
    199338.5260366f,
    // Bi213~
    198403.0041537f,
    // Bi212~
    197468.6196251f,
    // Bi211~
    196533.3865054f,
    // Bi210~
    195598.9554021f,
    // Bi209~
    194663.9942787f,
    // Bi208~
    193731.8891162f,
    // Bi207~
    192799.2101533f,
    // Bi206~
    191867.7421327f,
    // Bi205~
    190935.2159349f,
    // Bi204~
    190004.122375f,
    // Bi203~
    189071.7554626f,
    // Bi202~
    188141.0084185f,
    // Bi201~
    187208.8622702f,
    // Bi200~
    186278.458016f,
    // Bi199~
    185346.4422769f,
    // Bi198~
    184416.289526f,
    // Bi197~
    183484.7115891f,
    // Bi196~
    182554.7823969f,
    // Bi195~
    181623.4187036f,
    // Bi194~
    180693.7875895f,
    // Bi193~
    179762.5822502f,
    // Bi192~
    178833.2398992f,
    // Bi191~
    177902.3792128f,
    // Bi190~
    176973.1859009f,
    // Bi189~
    176042.6139777f,
    // Bi188~
    175113.5976496f,
    // Bi187~
    174183.3051746f,
    // Bi186~
    173254.6241844f,
    // Bi185~
    172324.2758198f,
    // Pb214~
    199339.5498418f,
    // Pb213~
    198404.9835787f,
    // Pb212~
    197469.1929598f,
    // Pb211~
    196534.7585962f,
    // Pb210~
    195599.0187437f,
    // Pb209~
    194664.6388726f,
    // Pb208~
    193729.0098679f,
    // Pb207~
    192796.8124875f,
    // Pb206~
    191863.9844855f,
    // Pb205~
    190932.50715f,
    // Pb204~
    189999.6735591f,
    // Pb203~
    189068.5017537f,
    // Pb202~
    188135.8609821f,
    // Pb201~
    187205.0245145f,
    // Pb200~
    186272.5672473f,
    // Pb199~
    185342.0921994f,
    // Pb198~
    184409.7318075f,
    // Pb197~
    183479.5417969f,
    // Pb196~
    182547.4235934f,
    // Pb195~
    181617.5689207f,
    // Pb194~
    180685.6090712f,
    // Pb193~
    179756.0804214f,
    // Pb192~
    178824.2882409f,
    // Pb191~
    177895.0669841f,
    // Pb190~
    176963.5542519f,
    // Pb189~
    176034.5751836f,
    // Pb188~
    175103.2487501f,
    // Pb187~
    174174.5211852f,
    // Pb186~
    173243.2785862f,
    // Pb185~
    172314.8397845f,
    // Pb184~
    171383.9232085f,
    // Pb183~
    170455.9035791f,
    // Pb182~
    169525.1043713f,
    // Pb181~
    168597.3679161f,
    // Tl210~
    195604.5080385f,
    // Tl209~
    194668.6200784f,
    // Tl208~
    193734.0110597f,
    // Tl207~
    192798.234879f,
    // Tl206~
    191865.5177248f,
    // Tl205~
    190932.4559179f,
    // Tl204~
    190000.4373843f,
    // Tl203~
    189067.5274109f,
    // Tl202~
    188135.8116129f,
    // Tl201~
    187203.1186776f,
    // Tl200~
    186271.7559159f,
    // Tl199~
    185339.2045677f,
    // Tl198~
    184408.3252514f,
    // Tl197~
    183475.9648595f,
    // Tl196~
    182545.3836214f,
    // Tl195~
    181613.0791191f,
    // Tl194~
    180682.8891085f,
    // Tl193~
    179750.929259f,
    // Tl192~
    178820.9162323f,
    // Tl191~
    177889.1892564f,
    // Tl190~
    176959.4649928f,
    // Tl189~
    176027.877741f,
    // Tl188~
    175098.4608704f,
    // Tl187~
    174167.1996416f,
    // Tl186~
    173237.9224951f,
    // Tl185~
    172306.9407145f,
    // Tl184~
    171377.9243864f,
    // Tl183~
    170447.3058885f,
    // Tl182~
    169518.522434f,
    // Tl181~
    168588.229959f,
    // Tl180~
    167659.8004722f,
    // Tl179~
    166729.4986823f,
    // Tl178~
    165801.5069977f,
    // Tl177~
    164871.5498606f,
    // Hg208~
    193737.676489f,
    // Hg207~
    192803.0525665f,
    // Hg206~
    191866.8255426f,
    // Hg205~
    190933.9872942f,
    // Hg204~
    190000.089937f,
    // Hg203~
    189068.0192398f,
    // Hg202~
    188134.446974f,
    // Hg201~
    187202.6352322f,
    // Hg200~
    186269.3004974f,
    // Hg199~
    185337.7626148f,
    // Hg198~
    184404.8619564f,
    // Hg197~
    183473.7805059f,
    // Hg196~
    182541.0009416f,
    // Hg195~
    181610.2753219f,
    // Hg194~
    180677.6093999f,
    // Hg193~
    179747.2908431f,
    // Hg192~
    178814.796316f,
    // Hg191~
    177884.6901398f,
    // Hg190~
    176952.4694721f,
    // Hg189~
    176022.6986338f,
    // Hg188~
    175090.6735797f,
    // Hg187~
    174161.2567092f,
    // Hg186~
    173229.4552138f,
    // Hg185~
    172300.3084765f,
    // Hg184~
    171368.7398546f,
    // Hg183~
    170439.7235265f,
    // Hg182~
    169508.406408f,
    // Hg181~
    168579.7626776f,
    // Hg180~
    167648.7436372f,
    // Hg179~
    166720.4725044f,
    // Hg178~
    165789.6267219f,
    // Hg177~
    164861.7319127f,
    // Hg176~
    163931.234509f,
    // Hg175~
    163003.4663831f,
    // Au205~
    190937.2978242f,
    // Au204~
    190004.033883f,
    // Au203~
    189070.1430463f,
    // Au202~
    188137.3942214f,
    // Au201~
    187203.8983382f,
    // Au200~
    186271.5463297f,
    // Au199~
    185338.215321f,
    // Au198~
    184406.2340472f,
    // Au197~
    183473.1815551f,
    // Au196~
    182541.6865213f,
    // Au195~
    181608.7644384f,
    // Au194~
    180677.5693456f,
    // Au193~
    179744.9509299f,
    // Au192~
    178814.0883805f,
    // Au191~
    177881.5137449f,
    // Au190~
    176950.9967799f,
    // Au189~
    176018.7490988f,
    // Au188~
    175088.3727893f,
    // Au187~
    174156.384995f,
    // Au186~
    173226.2322442f,
    // Au185~
    172294.5611579f,
    // Au184~
    171364.6133357f,
    // Au183~
    170433.2589575f,
    // Au182~
    169503.6278433f,
    // Au181~
    168572.4411339f,
    // Au180~
    167643.2291921f,
    // Au179~
    166712.6758988f,
    // Au178~
    165783.5757362f,
    // Au177~
    164853.2366865f,
    // Au176~
    163924.5836412f,
    // Au175~
    162994.2818512f,
    // Au174~
    162065.926884f,
    // Au173~
    161135.8113928f,
    // Au172~
    160207.7731336f,
    // Au171~
    159277.8253114f,
    // Pt202~
    188139.2106349f,
    // Pt201~
    187206.5614798f,
    // Pt200~
    186272.2021016f,
    // Pt199~
    185339.9180922f,
    // Pt198~
    184405.9089557f,
    // Pt197~
    183473.8997371f,
    // Pt196~
    182540.1812268f,
    // Pt195~
    181608.5371539f,
    // Pt194~
    180675.0775989f,
    // Pt193~
    179743.8825061f,
    // Pt192~
    178810.5719903f,
    // Pt191~
    177879.683359f,
    // Pt190~
    176946.5544845f,
    // Pt189~
    176015.9005898f,
    // Pt188~
    175083.0688619f,
    // Pt187~
    174152.6590186f,
    // Pt186~
    173220.1123279f,
    // Pt185~
    172289.8477977f,
    // Pt184~
    171357.5619254f,
    // Pt183~
    170427.7724572f,
    // Pt182~
    169495.8498675f,
    // Pt181~
    168566.1349189f,
    // Pt180~
    167634.6780762f,
    // Pt179~
    166705.2891505f,
    // Pt178~
    165774.0092918f,
    // Pt177~
    164845.0674832f,
    // Pt176~
    163914.0857026f,
    // Pt175~
    162985.6469009f,
    // Pt174~
    162054.6474219f,
    // Pt173~
    161126.5896012f,
    // Pt172~
    160195.9152137f,
    // Pt171~
    159268.0259934f,
    // Pt170~
    158337.5379047f,
    // Pt169~
    157409.8536132f,
    // Pt168~
    156479.8685312f,
    // Ir199~
    185342.9119142f,
    // Ir198~
    184410.0112557f,
    // Ir197~
    183476.054283f,
    // Ir196~
    182543.390224f,
    // Ir195~
    181609.6577413f,
    // Ir194~
    180677.3243627f,
    // Ir193~
    179743.825685f,
    // Ir192~
    178812.0316415f,
    // Ir191~
    177878.6643045f,
    // Ir190~
    176947.1692706f,
    // Ir189~
    176013.9295483f,
    // Ir188~
    175082.5621291f,
    // Ir187~
    174149.679169f,
    // Ir186~
    173218.7346481f,
    // Ir185~
    172285.9727823f,
    // Ir184~
    171355.2238752f,
    // Ir183~
    170423.1895062f,
    // Ir182~
    169492.924976f,
    // Ir181~
    168560.9744415f,
    // Ir180~
    167630.9800447f,
    // Ir179~
    166699.3927929f,
    // Ir178~
    165769.6964741f,
    // Ir177~
    164838.2862062f,
    // Ir176~
    163908.9718f,
    // Ir175~
    162978.1949481f,
    // Ir174~
    162049.0482108f,
    // Ir173~
    161118.4017681f,
    // Ir172~
    160189.6369434f,
    // Ir171~
    159259.2047443f,
    // Ir170~
    158330.7379977f,
    // Ir169~
    157400.5107273f,
    // Ir168~
    156472.3513738f,
    // Ir167~
    155542.3197172f,
    // Ir166~
    154614.5236464f,
    // Ir165~
    153684.9577368f,
    // Os196~
    182544.5452767f,
    // Os195~
    181611.6539331f,
    // Os194~
    180677.4203066f,
    // Os193~
    179744.9658338f,
    // Os192~
    178810.9855736f,
    // Os191~
    177878.978218f,
    // Os190~
    176945.1712158f,
    // Os189~
    176013.397572f,
    // Os188~
    175079.7527429f,
    // Os187~
    174148.1765759f,
    // Os186~
    173214.9034129f,
    // Os185~
    172283.6002668f,
    // Os184~
    171350.6604856f,
    // Os183~
    170419.742978f,
    // Os182~
    169487.3881751f,
    // Os181~
    168556.9038123f,
    // Os180~
    167624.5527354f,
    // Os179~
    166694.5490235f,
    // Os178~
    165762.4960247f,
    // Os177~
    164832.5854623f,
    // Os176~
    163900.9982105f,
    // Os175~
    162971.4881905f,
    // Os174~
    162040.0313479f,
    // Os173~
    161111.0243348f,
    // Os172~
    160179.8003657f,
    // Os171~
    159251.0634858f,
    // Os170~
    158320.0630753f,
    // Os169~
    157391.8385172f,
    // Os168~
    156461.0430354f,
    // Os167~
    155533.0140911f,
    // Os166~
    154602.4328529f,
    // Os165~
    153674.6181523f,
    // Os164~
    152744.4747163f,
    // Os163~
    151816.8183696f,
    // Os162~
    150886.9730118f,
    // Re192~
    178815.1595987f,
    // Re191~
    177881.0237791f,
    // Re190~
    176948.3150084f,
    // Re189~
    176014.4064733f,
    // Re188~
    175081.8731029f,
    // Re187~
    174148.1792772f,
    // Re186~
    173215.9736996f,
    // Re185~
    172282.5874533f,
    // Re184~
    171350.6912249f,
    // Re183~
    170417.610788f,
    // Re182~
    169486.4790368f,
    // Re181~
    168553.9183737f,
    // Re180~
    167623.0996046f,
    // Re179~
    166690.8509919f,
    // Re178~
    165760.1672894f,
    // Re177~
    164828.1329205f,
    // Re176~
    163897.8497604f,
    // Re175~
    162966.1879891f,
    // Re174~
    162036.2960566f,
    // Re173~
    161104.7553795f,
    // Re172~
    160175.3385089f,
    // Re171~
    159244.086595f,
    // Re170~
    158315.0236922f,
    // Re169~
    157384.1536909f,
    // Re168~
    156455.2491421f,
    // Re167~
    155524.6399591f,
    // Re166~
    154596.1638976f,
    // Re165~
    153665.8341629f,
    // Re164~
    152737.3860462f,
    // Re163~
    151807.4289091f,
    // Re162~
    150879.4185947f,
    // Re161~
    149949.7409058f,
    // Re160~
    149021.8144258f,
    // W190~
    176949.5818403f,
    // W189~
    176016.9047404f,
    // W188~
    175082.2221337f,
    // W187~
    174149.4900757f,
    // W186~
    173215.3915158f,
    // W185~
    172283.0205049f,
    // W184~
    171349.2088452f,
    // W183~
    170417.0551518f,
    // W182~
    169483.6808286f,
    // W181~
    168552.1792742f,
    // W180~
    167619.2953826f,
    // W179~
    166688.1422071f,
    // W178~
    165755.5098189f,
    // W177~
    164824.732967f,
    // W176~
    163892.2794257f,
    // W175~
    162961.8844863f,
    // W174~
    162029.8221725f,
    // W173~
    161099.8836653f,
    // W172~
    160168.0076503f,
    // W171~
    159238.4137959f,
    // W170~
    158306.7613395f,
    // W169~
    157377.5680276f,
    // W168~
    156446.1670746f,
    // W167~
    155517.2904707f,
    // W166~
    154586.1223912f,
    // W165~
    153657.7208493f,
    // W164~
    152726.8229031f,
    // W163~
    151798.6356048f,
    // W162~
    150867.8960126f,
    // W161~
    149939.8950131f,
    // W160~
    149009.5932232f,
    // W159~
    148081.7412627f,
    // W158~
    147151.7934406f,
    // Ta188~
    175087.0873274f,
    // Ta187~
    174152.5192945f,
    // Ta186~
    173219.2926131f,
    // Ta185~
    172285.0124119f,
    // Ta184~
    171352.0744936f,
    // Ta183~
    170418.1249728f,
    // Ta182~
    169485.4935161f,
    // Ta181~
    168551.9911124f,
    // Ta180~
    167620.0033182f,
    // Ta179~
    166687.0821668f,
    // Ta178~
    165755.4166695f,
    // Ta177~
    164822.7321177f,
    // Ta176~
    163891.4876557f,
    // Ta175~
    162958.9782247f,
    // Ta174~
    162027.9684993f,
    // Ta173~
    161095.8875556f,
    // Ta172~
    160165.5112462f,
    // Ta171~
    159233.7563254f,
    // Ta170~
    158303.7805584f,
    // Ta169~
    157372.128102f,
    // Ta168~
    156442.3758936f,
    // Ta167~
    155511.0494602f,
    // Ta166~
    154581.884093f,
    // Ta165~
    153650.7160136f,
    // Ta164~
    152721.78352f,
    // Ta163~
    151790.9880382f,
    // Ta162~
    150862.1300641f,
    // Ta161~
    149931.7723845f,
    // Ta160~
    149003.0634495f,
    // Ta159~
    148073.013163f,
    // Ta158~
    147144.7420302f,
    // Ta157~
    146214.9059873f,
    // Ta156~
    145286.7093741f,
    // Hf186~
    173221.5002541f,
    // Hf185~
    172288.0127544f,
    // Hf184~
    171353.4167766f,
    // Hf183~
    170420.1342056f,
    // Hf182~
    169485.8670452f,
    // Hf181~
    168553.0186436f,
    // Hf180~
    167619.1489518f,
    // Hf179~
    166686.9714122f,
    // Hf178~
    165753.5049642f,
    // Hf177~
    164821.565887f,
    // Hf176~
    163888.3781421f,
    // Hf175~
    162956.9783069f,
    // Hf174~
    162024.1214286f,
    // Hf173~
    161093.1955377f,
    // Hf172~
    160160.5929573f,
    // Hf171~
    159230.0582938f,
    // Hf170~
    158297.7817364f,
    // Hf169~
    157367.6941901f,
    // Hf168~
    156435.7063959f,
    // Hf167~
    155506.0473368f,
    // Hf166~
    154574.2272115f,
    // Hf165~
    153644.8662306f,
    // Hf164~
    152713.260349f,
    // Hf163~
    151784.225391f,
    // Hf162~
    150852.8644923f,
    // Hf161~
    149924.2831719f,
    // Hf160~
    148993.1430373f,
    // Hf159~
    148064.7135505f,
    // Hf158~
    147133.8249193f,
    // Hf157~
    146205.5724164f,
    // Hf156~
    145275.1215874f,
    // Hf155~
    144346.8970293f,
    // Hf154~
    143416.7908532f,
    // Lu184~
    171358.7449229f,
    // Lu183~
    170423.8974417f,
    // Lu182~
    169490.2050133f,
    // Lu181~
    168555.69287f,
    // Lu180~
    167622.2519449f,
    // Lu179~
    166688.3769436f,
    // Lu178~
    165755.6038998f,
    // Lu177~
    164822.0642364f,
    // Lu176~
    163889.5710134f,
    // Lu175~
    162956.2935656f,
    // Lu174~
    162024.3948222f,
    // Lu173~
    161091.5905733f,
    // Lu172~
    160160.2408525f,
    // Lu171~
    159227.655039f,
    // Lu170~
    158296.6844363f,
    // Lu169~
    157364.4237143f,
    // Lu168~
    156433.9086122f,
    // Lu167~
    155502.0512271f,
    // Lu166~
    154571.9077912f,
    // Lu165~
    153640.2739647f,
    // Lu164~
    152710.2795678f,
    // Lu163~
    151778.7668356f,
    // Lu162~
    150849.1543513f,
    // Lu161~
    149917.958327f,
    // Lu160~
    148988.77433f,
    // Lu159~
    148057.8391241f,
    // Lu158~
    147128.7203316f,
    // Lu157~
    146198.0943818f,
    // Lu156~
    145269.2159148f,
    // Lu155~
    144338.9513846f,
    // Lu154~
    143410.1306703f,
    // Lu153~
    142480.1176436f,
    // Lu152~
    141553.2064922f,
    // Lu151~
    140625.0098789f,
    // Lu150~
    139698.657624f,
    // Yb181~
    168559.5865153f,
    // Yb180~
    167624.5341055f,
    // Yb179~
    166691.0279758f,
    // Yb178~
    165756.2484937f,
    // Yb177~
    164823.4633405f,
    // Yb176~
    163889.4644505f,
    // Yb175~
    162956.7635975f,
    // Yb174~
    162023.0204958f,
    // Yb173~
    161090.9197113f,
    // Yb172~
    160157.721813f,
    // Yb171~
    159226.1758264f,
    // Yb170~
    158293.2257987f,
    // Yb169~
    157362.1303758f,
    // Yb168~
    156429.4318516f,
    // Yb167~
    155498.9186125f,
    // Yb166~
    154566.4306059f,
    // Yb165~
    153636.3505116f,
    // Yb164~
    152704.0385573f,
    // Yb163~
    151774.1745696f,
    // Yb162~
    150842.1960903f,
    // Yb161~
    149912.6581256f,
    // Yb160~
    148980.8938899f,
    // Yb159~
    148051.8123572f,
    // Yb158~
    147120.0462586f,
    // Yb157~
    146191.1622026f,
    // Yb156~
    145259.8450841f,
    // Yb155~
    144331.0895744f,
    // Yb154~
    143400.0146444f,
    // Yb153~
    142471.2870795f,
    // Yb152~
    141540.6872114f,
    // Yb151~
    140613.9250991f,
    // Yb150~
    139684.9832905f,
    // Yb149~
    138758.6030908f,
    // Yb148~
    137830.164289f,
    // Tm179~
    166695.8438003f,
    // Tm178~
    165761.8346639f,
    // Tm177~
    164826.9871827f,
    // Tm176~
    163893.5835174f,
    // Tm175~
    162959.1458937f,
    // Tm174~
    162026.0961961f,
    // Tm173~
    161092.2174689f,
    // Tm172~
    160159.6018476f,
    // Tm171~
    159226.2727018f,
    // Tm170~
    158294.1936211f,
    // Tm169~
    157361.2212376f,
    // Tm168~
    156429.688944f,
    // Tm167~
    155496.9643379f,
    // Tm166~
    154566.1260073f,
    // Tm165~
    153633.5877f,
    // Tm164~
    152703.0427902f,
    // Tm163~
    151770.800698f,
    // Tm162~
    150840.5380308f,
    // Tm161~
    149908.5129768f,
    // Tm160~
    148978.5930994f,
    // Tm159~
    148046.8381787f,
    // Tm158~
    147117.3840484f,
    // Tm157~
    146185.6663874f,
    // Tm156~
    145256.2681468f,
    // Tm155~
    144324.9435763f,
    // Tm154~
    143395.5248428f,
    // Tm153~
    142464.5970888f,
    // Tm152~
    141535.219341f,
    // Tm151~
    140604.777827f,
    // Tm150~
    139677.2332596f,
    // Tm149~
    138748.5150096f,
    // Tm148~
    137821.5852284f,
    // Tm147~
    136893.3793002f,
    // Tm146~
    135966.9338958f,
    // Er177~
    164831.9520463f,
    // Er176~
    163896.657448f,
    // Er175~
    162962.9650195f,
    // Er174~
    162028.1268533f,
    // Er173~
    161094.8256523f,
    // Er172~
    160160.4923559f,
    // Er171~
    159227.7630924f,
    // Er170~
    158293.8787761f,
    // Er169~
    157361.5724109f,
    // Er168~
    156428.0103916f,
    // Er167~
    155496.2154166f,
    // Er166~
    154563.0865421f,
    // Er165~
    153631.9957766f,
    // Er164~
    152699.0802142f,
    // Er163~
    151768.3611149f,
    // Er162~
    150835.698919f,
    // Er161~
    149905.3468283f,
    // Er160~
    148972.9948199f,
    // Er159~
    148042.9920396f,
    // Er158~
    147110.7797552f,
    // Er157~
    146181.1859008f,
    // Er156~
    145248.8255089f,
    // Er155~
    144319.3620637f,
    // Er154~
    143387.4739393f,
    // Er153~
    142458.1371772f,
    // Er152~
    141526.6309654f,
    // Er151~
    140597.353819f,
    // Er150~
    139666.1391648f,
    // Er149~
    138738.7529515f,
    // Er148~
    137809.3733407f,
    // Er147~
    136882.4156146f,
    // Er146~
    135953.5390106f,
    // Er145~
    135027.0190867f,
    // Er144~
    134098.4405609f,
    // Ho175~
    162968.6657634f,
    // Ho174~
    162034.4703281f,
    // Ho173~
    161099.3806585f,
    // Ho172~
    160165.5857657f,
    // Ho171~
    159230.9618431f,
    // Ho170~
    158297.7444766f,
    // Ho169~
    157363.6962174f,
    // Ho168~
    156430.9278311f,
    // Ho167~
    155497.2223617f,
    // Ho166~
    154564.9411468f,
    // Ho165~
    153631.619453f,
    // Ho164~
    152700.0433791f,
    // Ho163~
    151767.1511041f,
    // Ho162~
    150835.9942026f,
    // Ho161~
    149903.3450475f,
    // Ho160~
    148972.665071f,
    // Ho159~
    148040.2236391f,
    // Ho158~
    147109.8855209f,
    // Ho157~
    146177.683483f,
    // Ho156~
    145247.6052516f,
    // Ho155~
    144315.5233765f,
    // Ho154~
    143385.4423506f,
    // Ho153~
    142453.5747191f,
    // Ho152~
    141523.5197751f,
    // Ho151~
    140591.9707146f,
    // Ho150~
    139662.0312759f,
    // Ho149~
    138730.9470309f,
    // Ho148~
    137802.694528f,
    // Ho147~
    136873.5943654f,
    // Ho146~
    135946.0684279f,
    // Ho145~
    135017.1638791f,
    // Ho144~
    134090.1036887f,
    // Ho143~
    133161.4506433f,
    // Ho142~
    132234.7723654f,
    // Dy173~
    161105.1093472f,
    // Dy172~
    160169.5818754f,
    // Dy171~
    159235.6379435f,
    // Dy170~
    158300.5948486f,
    // Dy169~
    157366.8931052f,
    // Dy168~
    156432.5393159f,
    // Dy167~
    155499.5734528f,
    // Dy166~
    154565.4273867f,
    // Dy165~
    153632.9058464f,
    // Dy164~
    152699.0559954f,
    // Dy163~
    151767.1492411f,
    // Dy162~
    150833.8545606f,
    // Dy161~
    149902.48621f,
    // Dy160~
    148969.3750338f,
    // Dy159~
    148038.3858012f,
    // Dy158~
    147105.6518802f,
    // Dy157~
    146175.1414356f,
    // Dy156~
    145242.5453757f,
    // Dy155~
    144312.4215011f,
    // Dy154~
    143379.691306f,
    // Dy153~
    142449.4444743f,
    // Dy152~
    141516.9750976f,
    // Dy151~
    140586.8465655f,
    // Dy150~
    139654.7935667f,
    // Dy149~
    138724.9333049f,
    // Dy148~
    137793.2957525f,
    // Dy147~
    136865.2481783f,
    // Dy146~
    135935.468025f,
    // Dy145~
    135007.9141427f,
    // Dy144~
    134078.3948078f,
    // Dy143~
    133151.3346174f,
    // Dy142~
    132222.1133606f,
    // Dy141~
    131295.2022092f,
    // Dy140~
    130366.1299915f,
    // Tb171~
    159241.9907333f,
    // Tb170~
    158307.6555739f,
    // Tb169~
    157372.4075503f,
    // Tb168~
    156438.5101931f,
    // Tb167~
    155503.6720269f,
    // Tb166~
    154570.3149363f,
    // Tb165~
    153635.8679976f,
    // Tb164~
    152702.9487092f,
    // Tb163~
    151768.9339838f,
    // Tb162~
    150836.3556223f,
    // Tb161~
    149903.0786402f,
    // Tb160~
    148971.2100772f,
    // Tb159~
    148038.019724f,
    // Tb158~
    147106.5880318f,
    // Tb157~
    146173.8000841f,
    // Tb156~
    145242.9794519f,
    // Tb155~
    144310.3265709f,
    // Tb154~
    143379.9409465f,
    // Tb153~
    142447.274093f,
    // Tb152~
    141516.3752154f,
    // Tb151~
    140583.9757007f,
    // Tb150~
    139652.999509f,
    // Tb149~
    138721.1216311f,
    // Tb148~
    137790.6130495f,
    // Tb147~
    136858.8739641f,
    // Tb146~
    135930.3075477f,
    // Tb145~
    135000.3969853f,
    // Tb144~
    134072.3028364f,
    // Tb143~
    133142.8766509f,
    // Tb142~
    132215.2109893f,
    // Tb141~
    131285.8593233f,
    // Tb140~
    130358.4451651f,
    // Tb139~
    129429.270483f,
    // Tb138~
    128502.2848121f,
    // Gd169~
    157378.6019861f,
    // Gd168~
    156442.9068453f,
    // Gd167~
    155508.8138743f,
    // Gd166~
    154573.6217404f,
    // Gd165~
    153640.0597211f,
    // Gd164~
    152705.2867594f,
    // Gd163~
    151772.0507631f,
    // Gd162~
    150837.7537949f,
    // Gd161~
    149905.0347778f,
    // Gd160~
    148971.1048184f,
    // Gd159~
    148038.9903409f,
    // Gd158~
    147105.368706f,
    // Gd157~
    146173.7404684f,
    // Gd156~
    145240.5352114f,
    // Gd155~
    144309.5059246f,
    // Gd154~
    143376.375187f,
    // Gd153~
    142445.7045254f,
    // Gd152~
    141512.3865576f,
    // Gd151~
    140581.4103659f,
    // Gd150~
    139648.34297f,
    // Gd149~
    138717.4832151f,
    // Gd148~
    137784.847101f,
    // Gd147~
    136854.2649313f,
    // Gd146~
    135922.0405375f,
    // Gd145~
    134993.6995427f,
    // Gd144~
    134063.2300838f,
    // Gd143~
    133135.4153831f,
    // Gd142~
    132205.309207f,
    // Gd141~
    131277.5224511f,
    // Gd140~
    130347.6491485f,
    // Gd139~
    129420.0021167f,
    // Gd138~
    128490.2685382f,
    // Gd137~
    127563.1338282f,
    // Gd136~
    126633.8939415f,
    // Eu167~
    155515.7814502f,
    // Eu166~
    154581.418346f,
    // Eu165~
    153645.9653937f,
    // Eu164~
    152711.9283124f,
    // Eu163~
    151776.9131623f,
    // Eu162~
    150843.3977177f,
    // Eu161~
    149908.7737951f,
    // Eu160~
    148975.6868378f,
    // Eu159~
    148041.5044435f,
    // Eu158~
    147108.8515624f,
    // Eu157~
    146175.1023128f,
    // Eu156~
    145242.9859724f,
    // Eu155~
    144309.757428f,
    // Eu154~
    143378.3434341f,
    // Eu153~
    142445.2201485f,
    // Eu152~
    141514.2048341f,
    // Eu151~
    140580.9464819f,
    // Eu150~
    139649.3145184f,
    // Eu149~
    138716.1698084f,
    // Eu148~
    137784.8880867f,
    // Eu147~
    136852.0777832f,
    // Eu146~
    135921.0112366f,
    // Eu145~
    134988.6424612f,
    // Eu144~
    134059.4892035f,
    // Eu143~
    133129.4044517f,
    // Eu142~
    132200.8100905f,
    // Eu141~
    131270.7039143f,
    // Eu140~
    130342.1812781f,
    // Eu139~
    129412.3266053f,
    // Eu138~
    128484.1951966f,
    // Eu137~
    127554.3405239f,
    // Eu136~
    126626.8425312f,
    // Eu135~
    125697.4163457f,
    // Eu134~
    124770.2071162f,
    // Eu133~
    123841.1162686f,
    // Eu132~
    122914.5218252f,
    // Sm165~
    153652.7280409f,
    // Sm164~
    152716.8559162f,
    // Sm163~
    151782.641851f,
    // Sm162~
    150847.2913631f,
    // Sm161~
    149913.5709898f,
    // Sm160~
    148978.6396741f,
    // Sm159~
    148045.3384732f,
    // Sm158~
    147110.8542748f,
    // Sm157~
    146177.832522f,
    // Sm156~
    145243.7078803f,
    // Sm155~
    144311.3847482f,
    // Sm154~
    143377.6261836f,
    // Sm153~
    142446.0286854f,
    // Sm152~
    141512.330668f,
    // Sm151~
    140581.0228644f,
    // Sm150~
    139647.0537822f,
    // Sm149~
    138715.4749138f,
    // Sm148~
    137781.7806224f,
    // Sm147~
    136850.3563821f,
    // Sm146~
    135917.1334266f,
    // Sm145~
    134985.9830455f,
    // Sm144~
    134053.174605f,
    // Sm143~
    133124.1294006f,
    // Sm142~
    132193.1653184f,
    // Sm141~
    131264.7227906f,
    // Sm140~
    130333.7149282f,
    // Sm139~
    129405.3050028f,
    // Sm138~
    128474.9640901f,
    // Sm137~
    127546.739532f,
    // Sm136~
    126616.4097972f,
    // Sm135~
    125688.688246f,
    // Sm134~
    124758.7497387f,
    // Sm133~
    123831.6429736f,
    // Sm132~
    122902.0956939f,
    // Sm131~
    121975.3242666f,
    // Sm130~
    121046.382458f,
    // Pm163~
    151790.2428429f,
    // Pm162~
    150855.7400146f,
    // Pm161~
    149920.1193933f,
    // Pm160~
    148985.9519029f,
    // Pm159~
    148050.8622332f,
    // Pm158~
    147117.0952852f,
    // Pm157~
    146182.3502684f,
    // Pm156~
    145248.8627687f,
    // Pm155~
    144314.6114437f,
    // Pm154~
    143381.6735255f,
    // Pm153~
    142447.909372f,
    // Pm152~
    141515.8349488f,
    // Pm151~
    140582.2105194f,
    // Pm150~
    139650.5077623f,
    // Pm149~
    138716.5452006f,
    // Pm148~
    137784.2490817f,
    // Pm147~
    136850.5808721f,
    // Pm146~
    135918.6750494f,
    // Pm145~
    134985.3663965f,
    // Pm144~
    134053.725118f,
    // Pm143~
    133120.6865984f,
    // Pm142~
    132191.0759771f,
    // Pm141~
    131260.1938663f,
    // Pm140~
    130330.7425305f,
    // Pm139~
    129400.1426625f,
    // Pm138~
    128471.1542792f,
    // Pm137~
    127540.8338594f,
    // Pm136~
    126611.8920508f,
    // Pm135~
    125681.4877966f,
    // Pm134~
    124753.5985764f,
    // Pm133~
    123823.2502117f,
    // Pm132~
    122895.5100306f,
    // Pm131~
    121965.9254911f,
    // Pm130~
    121038.7628363f,
    // Pm129~
    120109.7930829f,
    // Pm128~
    119183.0496004f,
    // Nd161~
    149928.0091484f,
    // Nd160~
    148991.9134651f,
    // Nd159~
    148057.6248804f,
    // Nd158~
    147121.9204247f,
    // Nd157~
    146188.0044376f,
    // Nd156~
    145252.7191543f,
    // Nd155~
    144318.831112f,
    // Nd154~
    143384.4028032f,
    // Nd153~
    142451.2459839f,
    // Nd152~
    141516.9434268f,
    // Nd151~
    140584.6528969f,
    // Nd150~
    139650.4220649f,
    // Nd149~
    138718.2358624f,
    // Nd148~
    137783.7097467f,
    // Nd147~
    136851.4769695f,
    // Nd146~
    135917.2032887f,
    // Nd145~
    134985.203385f,
    // Nd144~
    134051.3935883f,
    // Nd143~
    133119.645188f,
    // Nd142~
    132186.2033314f,
    // Nd141~
    131256.4660269f,
    // Nd140~
    130324.6971338f,
    // Nd139~
    129395.634231f,
    // Nd138~
    128464.1494436f,
    // Nd137~
    127535.1796902f,
    // Nd136~
    126604.0395556f,
    // Nd135~
    125675.5448642f,
    // Nd134~
    124744.4326744f,
    // Nd133~
    123816.254691f,
    // Nd132~
    122885.6082483f,
    // Nd131~
    121957.8214924f,
    // Nd130~
    121027.8923001f,
    // Nd129~
    120100.5619764f,
    // Nd128~
    119171.0612713f,
    // Nd127~
    118244.3271038f,
    // Nd126~
    117315.2269413f,
    // Pr159~
    148065.8592883f,
    // Pr158~
    147131.1515312f,
    // Pr157~
    146195.363241f,
    // Pr156~
    145261.0280816f,
    // Pr155~
    144325.6869086f,
    // Pr154~
    143391.7709216f,
    // Pr153~
    142456.7930312f,
    // Pr152~
    141523.3893659f,
    // Pr151~
    140588.7561284f,
    // Pr150~
    139656.1162883f,
    // Pr149~
    138721.6330213f,
    // Pr148~
    137788.638282f,
    // Pr147~
    136854.1633984f,
    // Pr146~
    135921.3745193f,
    // Pr145~
    134987.0086206f,
    // Pr144~
    134054.3911363f,
    // Pr143~
    133120.5785451f,
    // Pr142~
    132188.3653292f,
    // Pr141~
    131254.643093f,
    // Pr140~
    130324.4745067f,
    // Pr139~
    129392.8509266f,
    // Pr138~
    128463.049349f,
    // Pr137~
    127531.4909735f,
    // Pr136~
    126601.8319145f,
    // Pr135~
    125670.7942443f,
    // Pr134~
    124741.656822f,
    // Pr133~
    123810.6564114f,
    // Pr132~
    122881.8822718f,
    // Pr131~
    121951.2637739f,
    // Pr130~
    121022.8622319f,
    // Pr129~
    120092.7467408f,
    // Pr128~
    119164.9227252f,
    // Pr127~
    118235.3195559f,
    // Pr126~
    117307.9985471f,
    // Pr125~
    116378.8518098f,
    // Pr124~
    115452.1362722f,
    // Pr123~
    114523.4366521f,
    // Pr122~
    113597.2427511f,
    // Pr121~
    112669.2044919f,
    // Ce157~
    146203.905042f,
    // Ce156~
    145267.6789495f,
    // Ce155~
    144333.1854361f,
    // Ce154~
    143397.2946816f,
    // Ce153~
    142463.2482854f,
    // Ce152~
    141527.8419078f,
    // Ce151~
    140594.1681092f,
    // Ce150~
    139659.1250143f,
    // Ce149~
    138725.8238133f,
    // Ce148~
    137790.6968839f,
    // Ce147~
    136857.4515726f,
    // Ce146~
    135922.3991628f,
    // Ce145~
    134989.545079f,
    // Ce144~
    134054.7097073f,
    // Ce143~
    133122.0400593f,
    // Ce142~
    132187.620134f,
    // Ce141~
    131255.2234138f,
    // Ce140~
    130321.0866626f,
    // Ce139~
    129390.7224626f,
    // Ce138~
    128458.6126426f,
    // Ce137~
    127528.7896406f,
    // Ce136~
    126596.699382f,
    // Ce135~
    125667.0738568f,
    // Ce134~
    124735.4717011f,
    // Ce133~
    123806.3249639f,
    // Ce132~
    122874.7749718f,
    // Ce131~
    121946.0101472f,
    // Ce130~
    121014.7675482f,
    // Ce129~
    120086.4405258f,
    // Ce128~
    119155.6729888f,
    // Ce127~
    118227.7930835f,
    // Ce126~
    117297.5564982f,
    // Ce125~
    116370.1982296f,
    // Ce124~
    115440.5484855f,
    // Ce123~
    114513.7025387f,
    // Ce122~
    113584.5371716f,
    // Ce121~
    112658.3153258f,
    // Ce120~
    111729.5877609f,
    // Ce119~
    110803.7944024f,
    // La155~
    144342.5842116f,
    // La154~
    143407.6156362f,
    // La153~
    142471.5106381f,
    // La152~
    141536.9053454f,
    // La151~
    140601.1729448f,
    // La150~
    139666.8936751f,
    // La149~
    138731.4872975f,
    // La148~
    137797.9625379f,
    // La147~
    136862.3978063f,
    // La146~
    135928.9289364f,
    // La145~
    134993.652968f,
    // La144~
    134060.2493027f,
    // La143~
    133125.4660946f,
    // La142~
    132192.1229765f,
    // La141~
    131257.725407f,
    // La140~
    130324.8489673f,
    // La139~
    129390.4439459f,
    // La138~
    128459.6568475f,
    // La137~
    127527.5693834f,
    // La136~
    126597.174444f,
    // La135~
    125665.0478571f,
    // La134~
    124734.9686943f,
    // La133~
    123803.3907575f,
    // La132~
    122873.48951f,
    // La131~
    121941.9954076f,
    // La130~
    121012.5599072f,
    // La129~
    120081.3918277f,
    // La128~
    119152.4872789f,
    // La127~
    118221.6545374f,
    // La126~
    117293.1505311f,
    // La125~
    116362.867371f,
    // La124~
    115434.9688359f,
    // La123~
    114505.0675884f,
    // La122~
    113577.7372646f,
    // La121~
    112648.3855987f,
    // La120~
    111721.6048565f,
    // La119~
    110792.8307169f,
    // La118~
    109866.5343516f,
    // La117~
    108938.2445889f,
    // Ba153~
    142480.9746181f,
    // Ba152~
    141544.4038729f,
    // Ba151~
    140609.6868009f,
    // Ba150~
    139673.4607085f,
    // Ba149~
    138739.0230847f,
    // Ba148~
    137803.0764405f,
    // Ba147~
    136868.1451249f,
    // Ba146~
    135933.0368254f,
    // Ba145~
    134998.5712568f,
    // Ba144~
    134063.3698079f,
    // Ba143~
    133129.7118448f,
    // Ba142~
    132194.3343435f,
    // Ba141~
    131260.9381301f,
    // Ba140~
    130325.8978297f,
    // Ba139~
    129392.7605717f,
    // Ba138~
    128457.9186795f,
    // Ba137~
    127526.9648437f,
    // Ba136~
    126594.3054422f,
    // Ba135~
    125663.8480927f,
    // Ba134~
    124731.2548273f,
    // Ba133~
    123801.1570346f,
    // Ba132~
    122868.7817388f,
    // Ba131~
    121939.0341878f,
    // Ba130~
    121006.9616276f,
    // Ba129~
    120077.6695773f,
    // Ba128~
    119145.8354796f,
    // Ba127~
    118216.9598071f,
    // Ba126~
    117285.58121f,
    // Ba125~
    116357.2318317f,
    // Ba124~
    115426.1736685f,
    // Ba123~
    114498.183847f,
    // Ba122~
    113568.0031513f,
    // Ba121~
    112640.4492689f,
    // Ba120~
    111710.4082974f,
    // Ba119~
    110783.5716655f,
    // Ba118~
    109854.303834f,
    // Ba117~
    108927.8584296f,
    // Ba116~
    107998.9911406f,
    // Ba115~
    107073.1139477f,
    // Ba114~
    106144.6285712f,
    // Cs151~
    140620.2126843f,
    // Cs150~
    139684.9646607f,
    // Cs149~
    138748.5802142f,
    // Cs148~
    137813.5278044f,
    // Cs147~
    136877.3389717f,
    // Cs146~
    135942.3983412f,
    // Cs145~
    135006.4610119f,
    // Cs144~
    134071.8370893f,
    // Cs143~
    133135.9649647f,
    // Cs142~
    132201.6409832f,
    // Cs141~
    131266.1898939f,
    // Cs140~
    130332.1183473f,
    // Cs139~
    129396.9737195f,
    // Cs138~
    128463.2934005f,
    // Cs137~
    127528.1413208f,
    // Cs136~
    126596.8540101f,
    // Cs135~
    125664.1172945f,
    // Cs134~
    124733.3134293f,
    // Cs133~
    123800.6400554f,
    // Cs132~
    122870.0616117f,
    // Cs131~
    121937.66396f,
    // Cs130~
    121007.3304993f,
    // Cs129~
    120075.2374462f,
    // Cs128~
    119145.3129114f,
    // Cs127~
    118213.5114159f,
    // Cs126~
    117283.9082466f,
    // Cs125~
    116352.6721681f,
    // Cs124~
    115423.5263623f,
    // Cs123~
    114492.7252915f,
    // Cs122~
    113564.1486287f,
    // Cs121~
    112633.643773f,
    // Cs120~
    111705.404311f,
    // Cs119~
    110775.4872282f,
    // Cs118~
    109847.8904971f,
    // Cs117~
    108918.3385599f,
    // Cs116~
    107990.8219374f,
    // Cs115~
    107062.1502621f,
    // Cs114~
    106135.7607474f,
    // Cs113~
    105207.1729066f,
    // Cs112~
    104281.0721551f,
    // Xe147~
    136885.8621428f,
    // Xe146~
    135949.049209f,
    // Xe145~
    135014.1737831f,
    // Xe144~
    134077.6123528f,
    // Xe143~
    133143.0070601f,
    // Xe142~
    132206.6785033f,
    // Xe141~
    131272.3433439f,
    // Xe140~
    130336.1824561f,
    // Xe139~
    129402.030801f,
    // Xe138~
    128466.0683214f,
    // Xe137~
    127532.3134828f,
    // Xe136~
    126596.7739016f,
    // Xe135~
    125665.2676898f,
    // Xe134~
    124732.0852543f,
    // Xe133~
    123801.0676112f,
    // Xe132~
    122867.9419969f,
    // Xe131~
    121937.3117621f,
    // Xe130~
    121004.351488f,
    // Xe129~
    120074.0418735f,
    // Xe128~
    119141.3842418f,
    // Xe127~
    118211.4267321f,
    // Xe126~
    117279.0840386f,
    // Xe125~
    116349.5732735f,
    // Xe124~
    115417.6111885f,
    // Xe123~
    114488.5158697f,
    // Xe122~
    113557.0953553f,
    // Xe121~
    112628.2429702f,
    // Xe120~
    111697.4605293f,
    // Xe119~
    110769.1335069f,
    // Xe118~
    109838.5895285f,
    // Xe117~
    108910.8120876f,
    // Xe116~
    107980.4171482f,
    // Xe115~
    107053.3942175f,
    // Xe114~
    106123.3998207f,
    // Xe113~
    105196.7774324f,
    // Xe112~
    104267.4164515f,
    // Xe111~
    103341.474054f,
    // Xe110~
    102412.6347098f,
    // I144~
    134088.2127556f,
    // I143~
    133151.5581759f,
    // I142~
    132216.4405615f,
    // I141~
    131279.9629657f,
    // I140~
    130345.0968546f,
    // I139~
    129408.8335024f,
    // I138~
    128473.8835569f,
    // I137~
    127538.1912106f,
    // I136~
    126603.7042177f,
    // I135~
    125667.9159275f,
    // I134~
    124736.2606766f,
    // I133~
    123802.83745f,
    // I132~
    122871.5194f,
    // I131~
    121938.2826584f,
    // I130~
    121007.3006915f,
    // I129~
    120074.2351585f,
    // I128~
    119143.5030183f,
    // I127~
    118210.7635083f,
    // I126~
    117280.3415557f,
    // I125~
    116347.9207098f,
    // I124~
    115417.905168f,
    // I123~
    114485.8396871f,
    // I122~
    113556.202984f,
    // I121~
    112624.4983639f,
    // I120~
    111695.5025287f,
    // I119~
    110764.1313836f,
    // I118~
    109835.6180623f,
    // I117~
    108904.3754633f,
    // I116~
    107975.7596777f,
    // I115~
    107045.3647384f,
    // I114~
    106117.5314078f,
    // I113~
    105187.7046799f,
    // I112~
    104260.2439469f,
    // I111~
    103330.9015959f,
    // I110~
    102403.9997595f,
    // I109~
    101475.2815095f,
    // I108~
    100548.5380271f,
    // Te142~
    132224.1905924f,
    // Te141~
    131288.8680493f,
    // Te140~
    130352.0737454f,
    // Te139~
    129416.8816115f,
    // Te138~
    128480.2549766f,
    // Te137~
    127545.1280472f,
    // Te136~
    126608.7715456f,
    // Te135~
    125673.8774897f,
    // Te134~
    124737.8097513f,
    // Te133~
    123805.7567525f,
    // Te132~
    122872.0121603f,
    // Te131~
    121940.5161018f,
    // Te130~
    121006.8804013f,
    // Te129~
    120075.7339325f,
    // Te128~
    119142.2514629f,
    // Te127~
    118211.4611974f,
    // Te126~
    117278.1865441f,
    // Te125~
    116347.7349699f,
    // Te124~
    115414.7456331f,
    // Te123~
    114484.6054574f,
    // Te122~
    113551.9694364f,
    // Te121~
    112622.2292443f,
    // Te120~
    111689.8874823f,
    // Te119~
    110760.6177878f,
    // Te118~
    109828.5806244f,
    // Te117~
    108899.7030889f,
    // Te116~
    107968.0096468f,
    // Te115~
    107039.4590658f,
    // Te114~
    106108.4120805f,
    // Te113~
    105180.5228603f,
    // Te112~
    104250.0813463f,
    // Te111~
    103322.36911f,
    // Te110~
    102392.076635f,
    // Te109~
    101465.2865778f,
    // Te108~
    100535.6834084f,
    // Te107~
    99609.3590983f,
    // Te106~
    98680.3427703f,
    // Sb139~
    129427.1094167f,
    // Sb138~
    128491.1907174f,
    // Sb137~
    127554.4336733f,
    // Sb136~
    126618.6081233f,
    // Sb135~
    125682.0001183f,
    // Sb134~
    124746.2025132f,
    // Sb133~
    123809.7621771f,
    // Sb132~
    122877.4977291f,
    // Sb131~
    121943.7093567f,
    // Sb130~
    121011.8389307f,
    // Sb129~
    120078.1129685f,
    // Sb128~
    119146.6347015f,
    // Sb127~
    118213.0428744f,
    // Sb126~
    117281.8608225f,
    // Sb125~
    116348.501869f,
    // Sb124~
    115417.6500318f,
    // Sb123~
    114484.5520828f,
    // Sb122~
    113553.9519353f,
    // Sb121~
    112621.1934229f,
    // Sb120~
    111690.8692771f,
    // Sb119~
    110758.3244493f,
    // Sb118~
    109828.3076966f,
    // Sb117~
    108896.1690003f,
    // Sb116~
    107966.4978319f,
    // Sb115~
    107034.8192936f,
    // Sb114~
    106105.654858f,
    // Sb113~
    105174.419711f,
    // Sb112~
    104245.7359263f,
    // Sb111~
    103315.0009916f,
    // Sb110~
    102386.8136933f,
    // Sb109~
    101456.6013268f,
    // Sb108~
    100528.8555567f,
    // Sb107~
    99599.2151275f,
    // Sb106~
    98672.015213f,
    // Sb105~
    97743.1013493f,
    // Sb104~
    96816.0411588f,
    // Sb103~
    95888.1146788f,
    // Sn137~
    127564.1957315f,
    // Sn136~
    126626.6934921f,
    // Sn135~
    125690.9052019f,
    // Sn134~
    124753.5706315f,
    // Sn133~
    123817.7450816f,
    // Sn132~
    122880.600536f,
    // Sn131~
    121948.3388824f,
    // Sn130~
    121013.9850932f,
    // Sn129~
    120082.1090782f,
    // Sn128~
    119147.9089854f,
    // Sn127~
    118216.2434881f,
    // Sn126~
    117282.2371462f,
    // Sn125~
    116350.8649763f,
    // Sn124~
    115417.0325443f,
    // Sn123~
    114485.9550992f,
    // Sn122~
    113552.3355136f,
    // Sn121~
    112621.5836257f,
    // Sn120~
    111688.1889959f,
    // Sn119~
    110757.7310876f,
    // Sn118~
    109824.6506507f,
    // Sn117~
    108894.4122024f,
    // Sn116~
    107961.7909922f,
    // Sn115~
    107031.7891433f,
    // Sn114~
    106099.7696783f,
    // Sn113~
    105170.5027783f,
    // Sn112~
    104238.68079f,
    // Sn111~
    103309.9010614f,
    // Sn110~
    102378.5168753f,
    // Sn109~
    101450.2215237f,
    // Sn108~
    100519.3636318f,
    // Sn107~
    99591.3160576f,
    // Sn106~
    98660.949063f,
    // Sn105~
    97733.6559991f,
    // Sn104~
    96803.8385861f,
    // Sn103~
    95876.9460645f,
    // Sn102~
    94947.6502882f,
    // Sn101~
    94021.344608f,
    // Sn100~
    93092.5425236f,
    // In134~
    124768.660836f,
    // In133~
    123831.2796909f,
    // In132~
    122894.7368905f,
    // In131~
    121957.5140993f,
    // In130~
    121024.2315283f,
    // In129~
    120089.7659597f,
    // In128~
    119156.8839311f,
    // In127~
    118222.7537004f,
    // In126~
    117290.4398832f,
    // In125~
    116356.2817077f,
    // In124~
    115424.3963778f,
    // In123~
    114490.3490501f,
    // In122~
    113558.7068401f,
    // In121~
    112624.9482756f,
    // In120~
    111693.557569f,
    // In119~
    110760.0942881f,
    // In118~
    109829.0743162f,
    // In117~
    108895.8671962f,
    // In116~
    107965.0661254f,
    // In115~
    107032.2846982f,
    // In114~
    106101.7584182f,
    // In113~
    105169.4669568f,
    // In112~
    104239.3440138f,
    // In111~
    103307.4568209f,
    // In110~
    102377.8797334f,
    // In109~
    101446.3716586f,
    // In108~
    100517.26777f,
    // In107~
    99586.3064823f,
    // In106~
    98657.7642847f,
    // In105~
    97727.3991532f,
    // In104~
    96799.3208397f,
    // In103~
    95869.292909f,
    // In102~
    94942.2662523f,
    // In101~
    94012.495414f,
    // In100~
    93085.2768696f,
    // In99~
    92157.0057368f,
    // In98~
    91232.6189344f,
    // Cd130~
    121032.7360694f,
    // Cd129~
    120099.6397972f,
    // Cd128~
    119163.9539713f,
    // Cd127~
    118231.2209818f,
    // Cd126~
    117295.9263835f,
    // Cd125~
    116363.4076376f,
    // Cd124~
    115428.5601564f,
    // Cd123~
    114496.4605829f,
    // Cd122~
    113561.7062511f,
    // Cd121~
    112629.7277718f,
    // Cd120~
    111695.3190244f,
    // Cd119~
    110763.8891951f,
    // Cd118~
    109829.5950214f,
    // Cd117~
    108898.3840933f,
    // Cd116~
    107964.5957209f,
    // Cd115~
    107033.7313085f,
    // Cd114~
    106100.306312f,
    // Cd113~
    105169.7835717f,
    // Cd112~
    104236.7583724f,
    // Cd111~
    103306.5914629f,
    // Cd110~
    102374.0019234f,
    // Cd109~
    101444.3521793f,
    // Cd108~
    100512.1100872f,
    // Cd107~
    99582.880447f,
    // Cd106~
    98651.2410315f,
    // Cd105~
    97722.5507264f,
    // Cd104~
    96791.4105917f,
    // Cd103~
    95863.2428548f,
    // Cd102~
    94933.0165159f,
    // Cd101~
    94005.1552405f,
    // Cd100~
    93075.104954f,
    // Cd99~
    92148.0633934f,
    // Cd98~
    91218.9632309f,
    // Cd97~
    90294.3249251f,
    // Cd96~
    89367.3299392f,
    // Ag127~
    118240.9550952f,
    // Ag126~
    117307.2440368f,
    // Ag125~
    116372.0612178f,
    // Ag124~
    115438.6948123f,
    // Ag123~
    114503.8193863f,
    // Ag122~
    113570.8535232f,
    // Ag121~
    112636.1271363f,
    // Ag120~
    111703.6456502f,
    // Ag119~
    110769.2452862f,
    // Ag118~
    109836.7358552f,
    // Ag117~
    108902.5404199f,
    // Ag116~
    107970.7482394f,
    // Ag115~
    107036.8322524f,
    // Ag114~
    106105.3828617f,
    // Ag113~
    105171.8003496f,
    // Ag112~
    104240.7142416f,
    // Ag111~
    103307.6282158f,
    // Ag110~
    102376.8932811f,
    // Ag109~
    101444.1379357f,
    // Ag108~
    100513.7597632f,
    // Ag107~
    99581.4636444f,
    // Ag106~
    98651.4347823f,
    // Ag105~
    97719.8121337f,
    // Ag104~
    96790.2741689f,
    // Ag103~
    95859.1005005f,
    // Ag102~
    94930.4269623f,
    // Ag101~
    93999.6780552f,
    // Ag100~
    93071.2299385f,
    // Ag99~
    92141.1610221f,
    // Ag98~
    91213.5419352f,
    // Ag97~
    90284.1343796f,
    // Ag96~
    89358.8626578f,
    // Ag95~
    88431.8397271f,
    // Ag94~
    87507.1455317f,
    // Pd123~
    114512.5381711f,
    // Pd122~
    113576.889605f,
    // Pd121~
    112643.8864822f,
    // Pd120~
    111708.5266793f,
    // Pd119~
    110775.7750598f,
    // Pd118~
    109840.8344293f,
    // Pd117~
    108908.2784236f,
    // Pd116~
    107973.3564229f,
    // Pd115~
    107041.4152034f,
    // Pd114~
    106106.833198f,
    // Pd113~
    105175.1388244f,
    // Pd112~
    104241.0020733f,
    // Pd111~
    103309.8125695f,
    // Pd110~
    102376.0009097f,
    // Pd109~
    101445.2538656f,
    // Pd108~
    100511.8408854f,
    // Pd107~
    99581.4962467f,
    // Pd106~
    98648.4698365f,
    // Pd105~
    97718.4670562f,
    // Pd104~
    96785.9958165f,
    // Pd103~
    95856.41314f,
    // Pd102~
    94924.472852f,
    // Pd101~
    93995.4760853f,
    // Pd100~
    93064.1831856f,
    // Pd99~
    92135.7285485f,
    // Pd98~
    91205.12216f,
    // Pd97~
    90277.1295439f,
    // Pd96~
    89347.2562413f,
    // Pd95~
    88421.7889057f,
    // Pd94~
    87494.0952993f,
    // Pd93~
    86569.2520648f,
    // Pd92~
    85641.9590008f,
    // Pd91~
    84718.904235f,
    // Rh121~
    112653.1082738f,
    // Rh120~
    111719.471735f,
    // Rh119~
    110783.8604286f,
    // Rh118~
    109850.5685426f,
    // Rh117~
    108915.2739443f,
    // Rh116~
    107982.2521916f,
    // Rh115~
    107047.4140254f,
    // Rh114~
    106114.7369255f,
    // Rh113~
    105180.0477983f,
    // Rh112~
    104247.7991857f,
    // Rh111~
    103313.5571758f,
    // Rh110~
    102381.4017126f,
    // Rh109~
    101447.8452822f,
    // Rh108~
    100516.3455909f,
    // Rh107~
    99583.0080617f,
    // Rh106~
    98652.0113771f,
    // Rh105~
    97719.0334046f,
    // Rh104~
    96788.4363311f,
    // Rh103~
    95855.870079f,
    // Rh102~
    94925.6232472f,
    // Rh101~
    93993.4966603f,
    // Rh100~
    93063.8217659f,
    // Rh99~
    92132.3416359f,
    // Rh98~
    91203.2545143f,
    // Rh97~
    90272.3416642f,
    // Rh96~
    89343.8078501f,
    // Rh95~
    88413.6010726f,
    // Rh94~
    87487.509636f,
    // Rh93~
    86559.7787698f,
    // Rh92~
    85634.0971906f,
    // Rh91~
    84706.8600163f,
    // Rh90~
    83781.2529566f,
    // Rh89~
    82855.8228808f,
    // Ru118~
    109857.6478978f,
    // Ru117~
    108924.0672487f,
    // Ru116~
    107988.2603286f,
    // Ru115~
    107055.0429621f,
    // Ru114~
    106119.5341201f,
    // Ru113~
    105186.6800364f,
    // Ru112~
    104251.4692725f,
    // Ru111~
    103319.052991f,
    // Ru110~
    102384.2148247f,
    // Ru109~
    101452.0034719f,
    // Ru108~
    100517.7055723f,
    // Ru107~
    99585.9506515f,
    // Ru106~
    98652.0504999f,
    // Ru105~
    97720.9504195f,
    // Ru104~
    96787.2952508f,
    // Ru103~
    95856.6336247f,
    // Ru102~
    94923.3005666f,
    // Ru101~
    93992.954717f,
    // Ru100~
    93060.1914539f,
    // Ru99~
    92130.2991488f,
    // Ru98~
    91198.1974328f,
    // Ru97~
    90268.8159591f,
    // Ru96~
    89337.3619109f,
    // Ru95~
    88408.4899644f,
    // Ru94~
    87477.877987f,
    // Ru93~
    86551.684086f,
    // Ru92~
    85623.0496705f,
    // Ru91~
    84697.3867212f,
    // Ru90~
    83769.0596988f,
    // Ru89~
    82843.4619541f,
    // Ru88~
    81915.9825913f,
    // Ru87~
    80992.6483772f,
    // Tc115~
    107064.3299583f,
    // Tc114~
    106130.6002701f,
    // Tc113~
    105194.8678695f,
    // Tc112~
    104261.4269445f,
    // Tc111~
    103326.0298818f,
    // Tc110~
    102392.9894992f,
    // Tc109~
    101457.992979f,
    // Tc108~
    100525.4276584f,
    // Tc107~
    99590.766476f,
    // Tc106~
    98658.5970404f,
    // Tc105~
    97724.5925614f,
    // Tc104~
    96792.8935304f,
    // Tc103~
    95859.2933198f,
    // Tc102~
    94927.8308882f,
    // Tc101~
    93994.5678785f,
    // Tc100~
    93063.3938375f,
    // Tc99~
    92130.5928489f,
    // Tc98~
    91199.994285f,
    // Tc97~
    90267.7074811f,
    // Tc96~
    89337.6162088f,
    // Tc95~
    88405.9218352f,
    // Tc94~
    87476.290721f,
    // Tc93~
    86545.3480631f,
    // Tc92~
    85618.5226092f,
    // Tc91~
    84689.9813431f,
    // Tc90~
    83763.2658055f,
    // Tc89~
    82835.4790496f,
    // Tc88~
    81908.912551f,
    // Tc87~
    80980.8649768f,
    // Tc86~
    80055.285862f,
    // Tc85~
    79129.4366139f,
    // Mo113~
    105204.8348564f,
    // Mo112~
    104268.5062996f,
    // Mo111~
    103334.841816f,
    // Mo110~
    102398.8951718f,
    // Mo109~
    101465.6126007f,
    // Mo108~
    100530.1782783f,
    // Mo107~
    99596.9236521f,
    // Mo106~
    98662.1171566f,
    // Mo105~
    97729.5387951f,
    // Mo104~
    96795.0545967f,
    // Mo103~
    95863.0388576f,
    // Mo102~
    94928.8406278f,
    // Mo101~
    93997.3931001f,
    // Mo100~
    93063.2256097f,
    // Mo99~
    92131.9500358f,
    // Mo98~
    91198.3099573f,
    // Mo97~
    90267.3870471f,
    // Mo96~
    89334.6427865f,
    // Mo95~
    88404.2316392f,
    // Mo94~
    87472.0352834f,
    // Mo93~
    86542.1474494f,
    // Mo92~
    85610.651484f,
    // Mo91~
    84683.759894f,
    // Mo90~
    83754.3011062f,
    // Mo89~
    82827.9721387f,
    // Mo88~
    81898.7806897f,
    // Mo87~
    80972.2952311f,
    // Mo86~
    80043.9402638f,
    // Mo85~
    79117.9326617f,
    // Mo84~
    78189.6987887f,
    // Mo83~
    77266.2621103f,
    // Nb110~
    102410.9580204f,
    // Nb109~
    101474.7598728f,
    // Nb108~
    100540.8252559f,
    // Nb107~
    99604.9531312f,
    // Nb106~
    98671.4842613f,
    // Nb105~
    97736.0219941f,
    // Nb104~
    96803.1585954f,
    // Nb103~
    95868.5719326f,
    // Nb102~
    94936.0531867f,
    // Nb101~
    94001.9620787f,
    // Nb100~
    93069.4703461f,
    // Nb99~
    92135.5888244f,
    // Nb98~
    91202.8958891f,
    // Nb97~
    90269.320922f,
    // Nb96~
    89337.829521f,
    // Nb95~
    88405.1572648f,
    // Nb94~
    87474.0807513f,
    // Nb93~
    86541.7427152f,
    // Nb92~
    85611.0084326f,
    // Nb91~
    84679.3259821f,
    // Nb90~
    83751.812154f,
    // Nb89~
    82822.4008724f,
    // Nb88~
    81895.0612337f,
    // Nb87~
    80965.8027172f,
    // Nb86~
    80038.6680072f,
    // Nb85~
    79109.8472929f,
    // Nb84~
    78183.6254471f,
    // Nb83~
    77255.0469213f,
    // Nb82~
    76329.542326f,
    // Nb81~
    75403.5626687f,
    // Zr108~
    100549.4602062f,
    // Zr107~
    99614.780394f,
    // Zr106~
    98678.6753958f,
    // Zr105~
    97744.5172203f,
    // Zr104~
    96809.0456381f,
    // Zr103~
    95875.5208786f,
    // Zr102~
    94940.6547675f,
    // Zr101~
    94007.446716f,
    // Zr100~
    93072.8041635f,
    // Zr99~
    92140.146625f,
    // Zr98~
    91205.1454473f,
    // Zr97~
    90271.979313f,
    // Zr96~
    89337.9934639f,
    // Zr95~
    88406.282044f,
    // Zr94~
    87473.1793444f,
    // Zr93~
    86541.8340948f,
    // Zr92~
    85609.0028326f,
    // Zr91~
    84678.072191f,
    // Zr90~
    83745.7012732f,
    // Zr89~
    82818.1057531f,
    // Zr88~
    81887.8570583f,
    // Zr87~
    80960.6394454f,
    // Zr86~
    80030.6851028f,
    // Zr85~
    79103.8484709f,
    // Zr84~
    78174.012428f,
    // Zr83~
    77247.5483938f,
    // Zr82~
    76318.327137f,
    // Zr81~
    75392.1704958f,
    // Zr80~
    74464.1508664f,
    // Zr79~
    73540.6769283f,
    // Y106~
    98692.0050764f,
    // Y105~
    97755.7324093f,
    // Y104~
    96820.8476684f,
    // Y103~
    95885.1525276f,
    // Y102~
    94950.5099751f,
    // Y101~
    94015.9885169f,
    // Y100~
    93082.1191046f,
    // Y99~
    92147.7140831f,
    // Y98~
    91213.9704225f,
    // Y97~
    90278.6674407f,
    // Y96~
    89345.093312f,
    // Y95~
    88410.7357967f,
    // Y94~
    87478.0959566f,
    // Y93~
    86544.7276881f,
    // Y92~
    85612.6420869f,
    // Y91~
    84679.6166082f,
    // Y90~
    83747.9812914f,
    // Y89~
    82815.2729864f,
    // Y88~
    81887.1839607f,
    // Y87~
    80956.9701038f,
    // Y86~
    80029.2114791f,
    // Y85~
    79099.1509461f,
    // Y84~
    78171.3483549f,
    // Y83~
    77241.6799809f,
    // Y82~
    76314.3217123f,
    // Y81~
    75385.0073062f,
    // Y80~
    74458.3662881f,
    // Y79~
    73529.6759829f,
    // Y78~
    72603.9105693f,
    // Y77~
    71678.1172108f,
    // Sr104~
    96830.9823242f,
    // Sr103~
    95896.3397717f,
    // Sr102~
    94959.3219093f,
    // Sr101~
    94025.4990717f,
    // Sr100~
    93089.1891448f,
    // Sr99~
    92155.8041094f,
    // Sr98~
    91219.7931921f,
    // Sr97~
    90286.1361604f,
    // Sr96~
    89350.4792109f,
    // Sr95~
    88416.8221792f,
    // Sr94~
    87481.6039634f,
    // Sr93~
    86548.8635219f,
    // Sr92~
    85614.5823891f,
    // Sr91~
    84682.3244616f,
    // Sr90~
    83748.5273332f,
    // Sr89~
    82816.7680344f,
    // Sr88~
    81883.561287f,
    // Sr87~
    80955.1085129f,
    // Sr86~
    80023.9712659f,
    // Sr85~
    79095.8963057f,
    // Sr84~
    78164.8604984f,
    // Sr83~
    77237.2134667f,
    // Sr82~
    76306.5074083f,
    // Sr81~
    75379.4956556f,
    // Sr80~
    74449.2236734f,
    // Sr79~
    73522.5565735f,
    // Sr78~
    72593.3651245f,
    // Sr77~
    71667.0696907f,
    // Sr76~
    70739.1618406f,
    // Sr75~
    69815.4084542f,
    // Sr74~
    68889.8665992f,
    // Sr73~
    67967.3707298f,
    // Rb102~
    94974.4027989f,
    // Rb101~
    94037.3104169f,
    // Rb100~
    93102.7144392f,
    // Rb99~
    92167.075188f,
    // Rb98~
    91232.1159276f,
    // Rb97~
    90296.5605109f,
    // Rb96~
    89362.2197625f,
    // Rb95~
    88426.1007919f,
    // Rb94~
    87491.8941787f,
    // Rb93~
    86556.3257211f,
    // Rb92~
    85622.6817304f,
    // Rb91~
    84688.2152303f,
    // Rb90~
    83755.1143006f,
    // Rb89~
    82821.2644496f,
    // Rb88~
    81888.8751814f,
    // Rb87~
    80955.3918734f,
    // Rb86~
    80025.7454827f,
    // Rb85~
    79094.8309559f,
    // Rb84~
    78165.7547328f,
    // Rb83~
    77234.9378266f,
    // Rb82~
    76306.32763f,
    // Rb81~
    75375.5656819f,
    // Rb80~
    74447.3550963f,
    // Rb79~
    73517.2377422f,
    // Rb78~
    72589.6037513f,
    // Rb77~
    71660.2204146f,
    // Rb76~
    70733.0708007f,
    // Rb75~
    69804.8350647f,
    // Rb74~
    68878.837709f,
    // Rb73~
    67952.8394218f,
    // Rb72~
    67029.4586331f,
    // Rb71~
    66103.7770539f,
    // Kr97~
    90307.0118747f,
    // Kr96~
    89370.4038697f,
    // Kr95~
    88435.9010414f,
    // Kr94~
    87499.3023513f,
    // Kr93~
    86564.9299322f,
    // Kr92~
    85628.6693745f,
    // Kr91~
    84694.6481286f,
    // Kr90~
    83759.5062953f,
    // Kr89~
    82826.2479431f,
    // Kr88~
    81891.788895f,
    // Kr87~
    80959.276949f,
    // Kr86~
    80025.2268268f,
    // Kr85~
    79095.5181191f,
    // Kr84~
    78163.0738928f,
    // Kr83~
    77234.0286884f,
    // Kr82~
    76301.9278107f,
    // Kr81~
    75373.3282331f,
    // Kr80~
    74441.634791f,
    // Kr79~
    73513.5918742f,
    // Kr78~
    72582.3800146f,
    // Kr77~
    71654.8745699f,
    // Kr76~
    70724.57278f,
    // Kr75~
    69797.8162566f,
    // Kr74~
    68868.3956601f,
    // Kr73~
    67942.1831293f,
    // Kr72~
    67013.4648793f,
    // Kr71~
    66089.9816262f,
    // Kr70~
    65163.6107414f,
    // Kr69~
    64240.7888491f,
    // Br94~
    87512.6413469f,
    // Br93~
    86575.9495074f,
    // Br92~
    85640.8784677f,
    // Br91~
    84704.4567615f,
    // Br90~
    83769.8514688f,
    // Br89~
    82834.4078314f,
    // Br88~
    81900.7526627f,
    // Br87~
    80966.1296716f,
    // Br86~
    80032.8526895f,
    // Br85~
    79098.3880525f,
    // Br84~
    78167.7285688f,
    // Br83~
    77235.0011682f,
    // Br82~
    76305.0207437f,
    // Br81~
    75373.0478534f,
    // Br80~
    74443.6393663f,
    // Br79~
    73511.9660444f,
    // Br78~
    72583.0879501f,
    // Br77~
    71651.8118173f,
    // Br76~
    70723.2630993f,
    // Br75~
    69792.9184606f,
    // Br74~
    68865.2574565f,
    // Br73~
    67935.5322614f,
    // Br72~
    67008.4254962f,
    // Br71~
    66079.4930026f,
    // Br70~
    65153.0010236f,
    // Br69~
    64226.6860284f,
    // Br68~
    63302.7090834f,
    // Br67~
    62377.3069525f,
    // Se92~
    85650.2586133f,
    // Se91~
    84715.0757942f,
    // Se90~
    83778.0393019f,
    // Se89~
    82843.3781196f,
    // Se88~
    81907.5991444f,
    // Se87~
    80973.4037091f,
    // Se86~
    80037.9516882f,
    // Se85~
    79104.5657213f,
    // Se84~
    78169.5552287f,
    // Se83~
    77238.6703235f,
    // Se82~
    76304.9229369f,
    // Se81~
    75374.6331632f,
    // Se80~
    74441.7687398f,
    // Se79~
    73512.1171328f,
    // Se78~
    72579.514273f,
    // Se77~
    71650.4468059f,
    // Se76~
    70718.3001919f,
    // Se75~
    69789.8888692f,
    // Se74~
    68858.3509866f,
    // Se73~
    67930.8533665f,
    // Se72~
    66999.6806296f,
    // Se71~
    66072.9911738f,
    // Se70~
    65142.6428092f,
    // Se69~
    64216.793561f,
    // Se68~
    63287.45121f,
    // Se67~
    62363.6139892f,
    // Se66~
    61436.8891366f,
    // Se65~
    60514.1976535f,
    // As89~
    82855.6831567f,
    // As88~
    81919.8389769f,
    // As87~
    80983.7060338f,
    // As86~
    80049.0914262f,
    // As85~
    79113.4801199f,
    // As84~
    78179.4244087f,
    // As83~
    77244.1298104f,
    // As82~
    76312.1885909f,
    // As81~
    75378.4896419f,
    // As80~
    74447.4100544f,
    // As79~
    73514.3976166f,
    // As78~
    72583.7241606f,
    // As77~
    71651.1296842f,
    // As76~
    70721.2621568f,
    // As75~
    69789.0251879f,
    // As74~
    68859.7039818f,
    // As73~
    67928.1129109f,
    // As72~
    66999.3462232f,
    // As71~
    66068.1893217f,
    // As70~
    65140.2488693f,
    // As69~
    64210.012284f,
    // As68~
    63282.71922f,
    // As67~
    62353.4607034f,
    // As66~
    61426.7917405f,
    // As65~
    60500.057573f,
    // As64~
    59576.0992579f,
    // As63~
    58650.3058994f,
    // As62~
    57727.6703059f,
    // As61~
    56803.0878898f,
    // As60~
    55883.2467786f,
    // Ge86~
    80058.443627f,
    // Ge85~
    79123.6147757f,
    // Ge84~
    78187.1092351f,
    // Ge83~
    77253.0069492f,
    // Ge82~
    76316.8926361f,
    // Ge81~
    75384.718543f,
    // Ge80~
    74450.080648f,
    // Ge79~
    73518.5446284f,
    // Ge78~
    72584.6780105f,
    // Ge77~
    71653.8317623f,
    // Ge76~
    70720.3388599f,
    // Ge75~
    69790.2017581f,
    // Ge74~
    68857.1415347f,
    // Ge73~
    67927.7723566f,
    // Ge72~
    66994.9898116f,
    // Ge71~
    66066.1763629f,
    // Ge70~
    65134.0268613f,
    // Ge69~
    64205.9994074f,
    // Ge68~
    63274.6217417f,
    // Ge67~
    62347.4507035f,
    // Ge66~
    61416.9924225f,
    // Ge65~
    60490.7053722f,
    // Ge64~
    59561.1953522f,
    // Ge63~
    58637.2184073f,
    // Ge62~
    57710.3910903f,
    // Ge61~
    56787.410844f,
    // Ge60~
    55861.8783039f,
    // Ge59~
    54941.1522734f,
    // Ge58~
    54018.2838064f,
    // Ga84~
    78201.1095914f,
    // Ga83~
    77264.5202163f,
    // Ga82~
    76329.5702708f,
    // Ga81~
    75393.0367853f,
    // Ga80~
    74460.4621498f,
    // Ga79~
    73525.549464f,
    // Ga78~
    72592.8816791f,
    // Ga77~
    71659.1706207f,
    // Ga76~
    70727.3504954f,
    // Ga75~
    69793.5937939f,
    // Ga74~
    68862.5086174f,
    // Ga73~
    67929.3657704f,
    // Ga72~
    66998.9889021f,
    // Ga71~
    66065.9444209f,
    // Ga70~
    65135.6826852f,
    // Ga69~
    64203.772205f,
    // Ga68~
    63274.5160172f,
    // Ga67~
    62343.2281476f,
    // Ga66~
    61414.8891089f,
    // Ga65~
    60484.4637097f,
    // Ga64~
    59556.7875222f,
    // Ga63~
    58627.4377192f,
    // Ga62~
    57700.6383471f,
    // Ga61~
    56773.7924003f,
    // Ga60~
    55849.6477864f,
    // Ga59~
    54924.0314118f,
    // Ga58~
    54002.6719652f,
    // Ga57~
    53079.2632316f,
    // Ga56~
    52158.9284286f,
    // Zn82~
    76340.4501219f,
    // Zn81~
    75404.8947052f,
    // Zn80~
    74467.7464337f,
    // Zn79~
    73534.6408465f,
    // Zn78~
    72599.3183033f,
    // Zn77~
    71666.4455897f,
    // Zn76~
    70731.5049591f,
    // Zn75~
    69799.5916844f,
    // Zn74~
    68864.8559825f,
    // Zn73~
    67933.6599582f,
    // Zn72~
    66999.4468246f,
    // Zn71~
    66068.7593961f,
    // Zn70~
    65135.0278449f,
    // Zn69~
    64204.678083f,
    // Zn68~
    63271.5949448f,
    // Zn67~
    62342.2277229f,
    // Zn66~
    61409.7144728f,
    // Zn65~
    60481.208883f,
    // Zn64~
    59549.6230284f,
    // Zn63~
    58621.9191755f,
    // Zn62~
    57691.4668562f,
    // Zn61~
    56764.7978932f,
    // Zn60~
    55835.4629942f,
    // Zn59~
    54910.8973449f,
    // Zn58~
    53984.3681061f,
    // Zn57~
    53062.4777079f,
    // Zn56~
    52137.9418665f,
    // Zn55~
    51217.2530957f,
    // Zn54~
    50294.1144954f,
    // Cu80~
    74484.0289506f,
    // Cu79~
    73546.3776722f,
    // Cu78~
    72612.5827794f,
    // Cu77~
    71676.5616156f,
    // Cu76~
    70743.2417848f,
    // Cu75~
    69807.7515727f,
    // Cu74~
    68874.8602292f,
    // Cu73~
    67939.9102837f,
    // Cu72~
    67007.512632f,
    // Cu71~
    66073.3171967f,
    // Cu70~
    65141.6265491f,
    // Cu69~
    64207.3528683f,
    // Cu68~
    63276.0590371f,
    // Cu67~
    62342.8044109f,
    // Cu66~
    61412.3563764f,
    // Cu65~
    60479.8569124f,
    // Cu64~
    59550.2017657f,
    // Cu63~
    58618.5522901f,
    // Cu62~
    57689.839536f,
    // Cu61~
    56759.1606772f,
    // Cu60~
    55831.3048976f,
    // Cu59~
    54901.8004667f,
    // Cu58~
    53974.9979275f,
    // Cu57~
    53047.8588395f,
    // Cu56~
    52125.068618f,
    // Cu55~
    51200.5514064f,
    // Cu54~
    50278.9870312f,
    // Cu53~
    49355.7273366f,
    // Cu52~
    48435.0665107f,
    // Ni78~
    72622.8198995f,
    // Ni77~
    71688.5592597f,
    // Ni76~
    70751.9419397f,
    // Ni75~
    69818.2495113f,
    // Ni74~
    68882.0420487f,
    // Ni73~
    67948.8433121f,
    // Ni72~
    67012.8966679f,
    // Ni71~
    66080.1916232f,
    // Ni70~
    65145.1019536f,
    // Ni69~
    64212.7136169f,
    // Ni68~
    63278.1129816f,
    // Ni67~
    62346.3627184f,
    // Ni66~
    61412.581798f,
    // Ni65~
    60481.9940394f,
    // Ni64~
    59548.5266599f,
    // Ni63~
    58618.6191714f,
    // Ni62~
    57685.8916777f,
    // Ni61~
    56756.9234147f,
    // Ni60~
    55825.1779952f,
    // Ni59~
    54897.0009433f,
    // Ni58~
    53966.4348885f,
    // Ni57~
    53039.087891f,
    // Ni56~
    52109.7697588f,
    // Ni55~
    51186.8454022f,
    // Ni54~
    50261.474942f,
    // Ni53~
    49339.8081024f,
    // Ni52~
    48415.0393875f,
    // Ni51~
    47494.7604741f,
    // Ni50~
    46570.9139383f,
    // Co72~
    67026.9715438f,
    // Co71~
    66091.118049f,
    // Co70~
    65157.835478f,
    // Co69~
    64222.0471878f,
    // Co68~
    63289.7706303f,
    // Co67~
    62354.7834251f,
    // Co66~
    61422.5627573f,
    // Co65~
    60487.9528071f,
    // Co64~
    59555.8336722f,
    // Co63~
    58622.2912143f,
    // Co62~
    57691.2060378f,
    // Co61~
    56758.2452048f,
    // Co60~
    55828.0019127f,
    // Co59~
    54895.928421f,
    // Co58~
    53966.8165216f,
    // Co57~
    53035.824122f,
    // Co56~
    52107.6346812f,
    // Co55~
    51178.1518609f,
    // Co54~
    50252.6761419f,
    // Co53~
    49326.5482839f,
    // Co52~
    48403.7776238f,
    // Co51~
    47478.9250743f,
    // Co50~
    46557.5097381f,
    // Co49~
    45633.6352575f,
    // Co48~
    44713.3563441f,
    // Fe69~
    64233.690864f,
    // Fe68~
    63297.3623073f,
    // Fe67~
    62363.5301547f,
    // Fe66~
    61428.291446f,
    // Fe65~
    60495.8285898f,
    // Fe64~
    59560.5433064f,
    // Fe63~
    58628.3505834f,
    // Fe62~
    57693.7359758f,
    // Fe61~
    56762.222312f,
    // Fe60~
    55828.2392574f,
    // Fe59~
    54897.4936105f,
    // Fe58~
    53964.5091176f,
    // Fe57~
    53034.988106f,
    // Fe56~
    52103.0686834f,
    // Fe55~
    51174.7005821f,
    // Fe54~
    50244.4330711f,
    // Fe53~
    49318.2461564f,
    // Fe52~
    48389.3646155f,
    // Fe51~
    47465.9819638f,
    // Fe50~
    46540.2305225f,
    // Fe49~
    45618.6288875f,
    // Fe48~
    44693.6086691f,
    // Fe47~
    43773.599889f,
    // Fe46~
    42849.4832199f,
    // Fe45~
    41930.7971615f,
    // Mn67~
    62376.4034032f,
    // Mn66~
    61442.1148185f,
    // Mn65~
    60506.2240639f,
    // Mn64~
    59572.5223205f,
    // Mn63~
    58637.3767613f,
    // Mn62~
    57704.1687097f,
    // Mn61~
    56769.405063f,
    // Mn60~
    55836.7279632f,
    // Mn59~
    54902.6815669f,
    // Mn58~
    53970.7589773f,
    // Mn57~
    53037.6785404f,
    // Mn56~
    52106.7642f,
    // Mn55~
    51174.4691989f,
    // Mn54~
    50245.1302013f,
    // Mn53~
    49314.5037857f,
    // Mn52~
    48386.9921932f,
    // Mn51~
    47457.9622653f,
    // Mn50~
    46532.0836751f,
    // Mn49~
    45605.6000795f,
    // Mn48~
    44682.7195031f,
    // Mn47~
    43757.9601031f,
    // Mn46~
    42836.358468f,
    // Mn45~
    41912.1207047f,
    // Mn44~
    40992.1398694f,
    // Cr65~
    60519.5164848f,
    // Cr64~
    59582.2750638f,
    // Cr63~
    58648.6012652f,
    // Cr62~
    57711.4623086f,
    // Cr61~
    56778.3753513f,
    // Cr60~
    55842.8199346f,
    // Cr59~
    54910.3011887f,
    // Cr58~
    53974.7271421f,
    // Cr57~
    53042.7672927f,
    // Cr56~
    52108.3809011f,
    // Cr55~
    51177.0723524f,
    // Cr54~
    50243.7531736f,
    // Cr53~
    49313.9067911f,
    // Cr52~
    48382.2805097f,
    // Cr51~
    47454.7544791f,
    // Cr50~
    46524.4506398f,
    // Cr49~
    45597.8855385f,
    // Cr48~
    44668.9017196f,
    // Cr47~
    43745.6709014f,
    // Cr46~
    42819.2580993f,
    // Cr45~
    41897.8222702f,
    // Cr44~
    40972.2058956f,
    // Cr43~
    40052.1132811f,
    // Cr42~
    39128.7418073f,
    // V63~
    58662.4712124f,
    // V62~
    57727.6144163f,
    // V61~
    56790.7828527f,
    // V60~
    55856.5781025f,
    // V59~
    54920.2402308f,
    // V58~
    53986.277669f,
    // V57~
    53050.7874569f,
    // V56~
    52117.4303663f,
    // V55~
    51183.0300023f,
    // V54~
    50250.7944307f,
    // V53~
    49317.3432592f,
    // V52~
    48386.2559402f,
    // V51~
    47454.0017387f,
    // V50~
    46525.4875791f,
    // V49~
    45595.2548129f,
    // V48~
    44667.2422628f,
    // V47~
    43738.2188554f,
    // V46~
    42811.6547787f,
    // V45~
    41885.3607421f,
    // V44~
    40961.8942559f,
    // V43~
    40036.2219917f,
    // V42~
    39114.5830969f,
    // V41~
    38191.0160093f,
    // V40~
    37270.094365f,
    // Ti61~
    56804.3919815f,
    // Ti60~
    55866.9549468f,
    // Ti59~
    54932.0329461f,
    // Ti58~
    53995.0896032f,
    // Ti57~
    53060.6054048f,
    // Ti56~
    52124.5376663f,
    // Ti55~
    51190.3701759f,
    // Ti54~
    50254.9172235f,
    // Ti53~
    49322.3612179f,
    // Ti52~
    48388.2291242f,
    // Ti51~
    47456.4723405f,
    // Ti50~
    46523.279286f,
    // Ti49~
    45594.6529745f,
    // Ti48~
    44663.2299451f,
    // Ti47~
    43735.2910763f,
    // Ti46~
    42804.6033683f,
    // Ti45~
    41878.2276398f,
    // Ti44~
    40948.192164f,
    // Ti43~
    40024.9257627f,
    // Ti42~
    39097.6317672f,
    // Ti41~
    38175.5438923f,
    // Ti40~
    37250.9149014f,
    // Ti39~
    36329.4995652f,
    // Ti38~
    35405.876588f,
    // Sc59~
    54947.0113713f,
    // Sc58~
    54010.8877432f,
    // Sc57~
    53073.7767314f,
    // Sc56~
    52138.2026848f,
    // Sc55~
    51201.8368683f,
    // Sc54~
    50266.216247f,
    // Sc53~
    49331.2197268f,
    // Sc52~
    48397.3130547f,
    // Sc51~
    47462.9806898f,
    // Sc50~
    46530.1675917f,
    // Sc49~
    45596.6586676f,
    // Sc48~
    44667.2240987f,
    // Sc47~
    43735.8911448f,
    // Sc46~
    42806.9701086f,
    // Sc45~
    41876.1652187f,
    // Sc44~
    40947.9246389f,
    // Sc43~
    40018.0587882f,
    // Sc42~
    39090.6314027f,
    // Sc41~
    38162.6159651f,
    // Sc40~
    37239.2376914f,
    // Sc39~
    36314.1019677f,
    // Sc38~
    35391.8389719f,
    // Sc37~
    34468.1228453f,
    // Sc36~
    33547.6855779f,
    // Ca57~
    53088.047221f,
    // Ca56~
    52150.4332024f,
    // Ca55~
    51214.0580709f,
    // Ca54~
    50277.0960981f,
    // Ca53~
    49341.289178f,
    // Ca52~
    48405.1841799f,
    // Ca51~
    47470.3087539f,
    // Ca50~
    46535.1333868f,
    // Ca49~
    45601.9206778f,
    // Ca48~
    44667.5026154f,
    // Ca47~
    43737.8831449f,
    // Ca46~
    42805.593826f,
    // Ca45~
    41876.4220316f,
    // Ca44~
    40944.2714122f,
    // Ca43~
    40015.8379199f,
    // Ca42~
    39084.2054907f,
    // Ca41~
    38156.1206567f,
    // Ca40~
    37224.9180188f,
    // Ca39~
    36300.9937033f,
    // Ca38~
    35374.7171788f,
    // Ca37~
    34452.1216396f,
    // Ca36~
    33527.3510616f,
    // Ca35~
    32606.7368103f,
    // Ca34~
    31683.9521778f,
    // K55~
    51231.6074198f,
    // K54~
    50295.0832492f,
    // K53~
    49357.1897824f,
    // K52~
    48421.4946416f,
    // K51~
    47484.1973309f,
    // K50~
    46549.3498498f,
    // K49~
    45612.8908838f,
    // K48~
    44679.5924774f,
    // K47~
    43744.5260951f,
    // K46~
    42813.309578f,
    // K45~
    41880.6268891f,
    // K44~
    40949.9338717f,
    // K43~
    40017.6535882f,
    // K42~
    39087.7310096f,
    // K41~
    38155.699314f,
    // K40~
    37226.2290688f,
    // K39~
    36294.4631844f,
    // K38~
    35367.9741861f,
    // K37~
    34440.4825369f,
    // K36~
    33516.3622257f,
    // K35~
    32591.1268322f,
    // K34~
    31669.3184055f,
    // K33~
    30746.0680259f,
    // K32~
    29828.2296271f,
    // Ar53~
    49374.9906347f,
    // Ar52~
    48435.9886898f,
    // Ar51~
    47499.9023215f,
    // Ar50~
    46561.6083122f,
    // Ar49~
    45626.611792f,
    // Ar48~
    44688.4947665f,
    // Ar47~
    43754.3179611f,
    // Ar46~
    42819.0047329f,
    // Ar45~
    41887.5106305f,
    // Ar44~
    40953.4782067f,
    // Ar43~
    40022.26821f,
    // Ar42~
    39088.3335931f,
    // Ar41~
    38158.1909024f,
    // Ar40~
    37224.7241963f,
    // Ar39~
    36295.027763f,
    // Ar38~
    35362.0611547f,
    // Ar37~
    34434.333735f,
    // Ar36~
    33503.5572371f,
    // Ar35~
    32579.2453455f,
    // Ar34~
    31652.4211025f,
    // Ar33~
    30729.9252331f,
    // Ar32~
    29805.6315801f,
    // Ar31~
    28887.6161974f,
    // Ar30~
    27964.9060844f,
    // Cl51~
    47518.8023368f,
    // Cl50~
    46581.9055687f,
    // Cl49~
    45643.1085525f,
    // Cl48~
    44706.9197199f,
    // Cl47~
    43768.9983082f,
    // Cl46~
    42833.9365834f,
    // Cl45~
    41898.3252771f,
    // Cl44~
    40965.7506415f,
    // Cl43~
    40030.2138547f,
    // Cl42~
    39097.7603134f,
    // Cl41~
    38163.9188459f,
    // Cl40~
    37232.2104999f,
    // Cl39~
    36298.4693543f,
    // Cl38~
    35366.9779066f,
    // Cl37~
    34433.5202612f,
    // Cl36~
    33504.2657967f,
    // Cl35~
    32573.2800665f,
    // Cl34~
    31646.3589109f,
    // Cl33~
    30718.3018634f,
    // Cl32~
    29794.4806642f,
    // Cl31~
    28869.2564486f,
    // Cl30~
    27949.2662984f,
    // Cl29~
    27026.472351f,
    // Cl28~
    26108.3917636f,
    // S49~
    45663.7132021f,
    // S48~
    44723.8170229f,
    // S47~
    43787.3207972f,
    // S46~
    42848.3281673f,
    // S45~
    41912.4094679f,
    // S44~
    40974.8606538f,
    // S43~
    40041.7643816f,
    // S42~
    39105.5103443f,
    // S41~
    38172.6562606f,
    // S40~
    37236.9145451f,
    // S39~
    36305.1130496f,
    // S38~
    35369.9143952f,
    // S37~
    34438.3855667f,
    // S36~
    33503.1237197f,
    // S35~
    32573.4472045f,
    // S34~
    31640.8676228f,
    // S33~
    30712.7191398f,
    // S32~
    29781.7952888f,
    // S31~
    28857.2722181f,
    // S30~
    27930.7603051f,
    // S29~
    27010.1712042f,
    // S28~
    26085.905496f,
    // S27~
    25167.8528535f,
    // S26~
    24244.8167176f,
    // P46~
    42870.9262142f,
    // P45~
    41931.337428f,
    // P44~
    40994.9436667f,
    // P43~
    40057.329648f,
    // P42~
    39122.8361346f,
    // P41~
    38186.4144285f,
    // P40~
    37251.4272232f,
    // P39~
    36315.6203031f,
    // P38~
    35382.3097872f,
    // P37~
    34446.2886235f,
    // P36~
    33513.5370041f,
    // P35~
    32577.4359182f,
    // P34~
    31646.2415706f,
    // P33~
    30712.9676624f,
    // P32~
    29783.5059498f,
    // P31~
    28851.8761753f,
    // P30~
    27924.6225042f,
    // P29~
    26996.3770806f,
    // P28~
    26074.6735401f,
    // P27~
    25149.5862542f,
    // P26~
    24229.8196625f,
    // P25~
    23306.2246301f,
    // P24~
    22387.8552797f,
    // Si42~
    39137.7493552f,
    // Si41~
    38203.0881729f,
    // Si40~
    37265.1667612f,
    // Si39~
    36330.4124295f,
    // Si38~
    35393.0312843f,
    // Si37~
    34458.7613295f,
    // Si36~
    33521.3894994f,
    // Si35~
    32587.9299444f,
    // Si34~
    31650.8431514f,
    // Si33~
    30718.81344f,
    // Si32~
    29783.7303839f,
    // Si31~
    28853.3682052f,
    // Si30~
    27920.3901862f,
    // Si29~
    26991.4339395f,
    // Si28~
    26060.3420681f,
    // Si27~
    25137.9563268f,
    // Si26~
    24211.7021022f,
    // Si25~
    23291.1782059f,
    // Si24~
    22366.6134882f,
    // Si23~
    21448.1360844f,
    // Si22~
    20525.0347438f,
    // Al39~
    36348.6697139f,
    // Al38~
    35412.518141f,
    // Al37~
    34474.8854924f,
    // Al36~
    33539.7026734f,
    // Al35~
    32602.2376938f,
    // Al34~
    31667.9397942f,
    // Al33~
    30730.8008376f,
    // Al32~
    29796.7451264f,
    // Al31~
    28861.3629676f,
    // Al30~
    27928.9504121f,
    // Al29~
    26995.1134157f,
    // Al28~
    26064.9843061f,
    // Al27~
    25133.1439301f,
    // Al26~
    24206.6363206f,
    // Al25~
    23278.436857f,
    // Al24~
    22355.8034991f,
    // Al23~
    21431.1316595f,
    // Al22~
    20511.0530174f,
    // Al21~
    19587.4952447f,
    // Mg37~
    34494.381664f,
    // Mg36~
    33554.6997285f,
    // Mg35~
    32618.5854153f,
    // Mg34~
    31679.2481326f,
    // Mg33~
    30744.5124307f,
    // Mg32~
    29807.0195063f,
    // Mg31~
    28873.1035193f,
    // Mg30~
    27935.9366178f,
    // Mg29~
    27002.6633617f,
    // Mg28~
    26066.8161079f,
    // Mg27~
    25135.7542561f,
    // Mg26~
    24202.6321814f,
    // Mg25~
    23274.1598273f,
    // Mg24~
    22341.9250753f,
    // Mg23~
    21418.8917339f,
    // Mg22~
    20492.4735291f,
    // Mg21~
    19572.287672f,
    // Mg20~
    18647.452821f,
    // Na35~
    32643.4469929f,
    // Na34~
    31703.3086253f,
    // Na33~
    30764.8190022f,
    // Na32~
    29826.1151354f,
    // Na31~
    28888.9854937f,
    // Na30~
    27953.4207621f,
    // Na29~
    27015.9464676f,
    // Na28~
    26080.8009083f,
    // Na27~
    25144.7611147f,
    // Na26~
    24211.9442907f,
    // Na25~
    23277.9951425f,
    // Na24~
    22347.4408524f,
    // Na23~
    21414.8348628f,
    // Na22~
    20487.6881645f,
    // Na21~
    19559.1918896f,
    // Na20~
    18636.7266664f,
    // Na19~
    17711.316152f,
    // Na18~
    16792.2118526f,
    // Ne32~
    29844.987206f,
    // Ne31~
    28907.1589437f,
    // Ne30~
    27967.0578358f,
    // Ne29~
    27031.3533801f,
    // Ne28~
    26093.1152604f,
    // Ne27~
    25157.4387495f,
    // Ne26~
    24219.2751493f,
    // Ne25~
    23285.2939577f,
    // Ne24~
    22349.9108674f,
    // Ne23~
    21419.2107147f,
    // Ne22~
    20484.8459058f,
    // Ne21~
    19555.6444247f,
    // Ne20~
    18622.8401161f,
    // Ne19~
    17700.1389679f,
    // Ne18~
    16772.200658f,
    // Ne17~
    15851.8871862f,
    // Ne16~
    14927.8981318f,
    // F29~
    27053.625404f,
    // F28~
    26115.0612614f,
    // F27~
    25175.3886408f,
    // F26~
    24237.1318912f,
    // F25~
    23298.6143233f,
    // F24~
    22363.4035595f,
    // F23~
    21427.6897888f,
    // F22~
    20495.6638033f,
    // F21~
    19561.3285507f,
    // F20~
    18629.8646474f,
    // F19~
    17696.9005355f,
    // F18~
    16767.767305f,
    // F17~
    15837.3514443f,
    // F16~
    14914.5861495f,
    // F15~
    13989.1877446f,
    // F14~
    13074.5257406f,
    // O26~
    24254.0105644f,
    // O25~
    23314.4962978f,
    // O24~
    22374.8329921f,
    // O23~
    21438.9794973f,
    // O22~
    20502.1572487f,
    // O21~
    19569.4382315f,
    // O20~
    18633.679004f,
    // O19~
    17701.7217627f,
    // O18~
    16766.1117605f,
    // O17~
    15834.5907379f,
    // O16~
    14899.1686386f,
    // O15~
    13975.2669378f,
    // O14~
    13048.9238953f,
    // O13~
    12132.5336997f,
    // O12~
    11209.9772832f,
    // N24~
    22402.8989094f,
    // N23~
    21462.0991809f,
    // N22~
    20524.9509094f,
    // N21~
    19586.6103253f,
    // N20~
    18651.6510649f,
    // N19~
    17714.2484954f,
    // N18~
    16780.0111429f,
    // N17~
    15843.2708657f,
    // N16~
    14909.5890563f,
    // N15~
    13972.512974f,
    // N14~
    13043.7808511f,
    // N13~
    12114.7687844f,
    // N12~
    11195.2673146f,
    // N11~
    10271.3991682f,
    // N10~
    9354.6413025f,
    // C22~
    20545.4530946f,
    // C21~
    19607.3360691f,
    // C20~
    18667.4398899f,
    // C19~
    17731.2231124f,
    // C18~
    16791.8206251f,
    // C17~
    15856.4366034f,
    // C16~
    14917.599533f,
    // C15~
    13982.2847212f,
    // C14~
    13043.9373261f,
    // C13~
    12112.5483426f,
    // C12~
    11177.9292286f,
    // C11~
    10257.0856435f,
    // C10~
    9330.6395871f,
    // C9~
    8412.3605916f,
    // C8~
    7487.0468594f,
    // B19~
    17757.7520645f,
    // B18~
    16819.2158667f,
    // B17~
    15879.1147588f,
    // B16~
    14940.9884184f,
    // B15~
    14001.3782079f,
    // B14~
    13064.5811096f,
    // B13~
    12125.9855756f,
    // B12~
    11191.2981251f,
    // B11~
    10255.1031446f,
    // B10~
    9326.9917631f,
    // B9~
    8395.8626201f,
    // B8~
    7474.873815f,
    // B7~
    6548.3290202f,
    // Be14~
    13080.8040109f,
    // Be13~
    12143.0782129f,
    // Be12~
    11203.0059814f,
    // Be11~
    10266.6094255f,
    // Be10~
    9327.5475856f,
    // Be9~
    8394.7944758f,
    // Be8~
    7456.8944791f,
    // Be7~
    6536.2281667f,
    // Be6~
    5607.339267f,
    // Be5~
    4695.4661564f,
    // Li12~
    11228.0249814f,
    // Li11~
    10287.2308419f,
    // Li10~
    9347.9913661f,
    // Li9~
    8408.4008101f,
    // Li8~
    7472.8990475f,
    // Li7~
    6535.3663483f,
    // Li6~
    5603.0509476f,
    // Li5~
    4669.151448f,
    // Li4~
    3751.2944192f,
    // He10~
    9363.7513148f,
    // He9~
    8424.264993f,
    // He8~
    7483.550962f,
    // He7~
    6546.5684964f,
    // He6~
    5606.5587681f,
    // He5~
    4668.8533699f,
    // He4~
    3728.4013213f,
    // He3~
    2809.4135146f,
    // H6~
    5630.8259593f,
    // H5~
    4694.3017887f,
    // H4~
    3751.8998904f,
    // T3~
    2809.4321052f,
    // D2~
    1876.1239278f,
    // p~
    938.27208816f,
    // n~
    939.5654205f,
    // K(2)(2250)-
    std::numeric_limits<float>::quiet_NaN(),
    // K(0)*(1950)-
    std::numeric_limits<float>::quiet_NaN(),
    // a(1)(1640)-
    1655.0f,
    // K(3)(2320)-
    std::numeric_limits<float>::quiet_NaN(),
    // K(2)*(1980)-
    1990.0f,
    // K(1830)-
    std::numeric_limits<float>::quiet_NaN(),
    // K(2)*(1980)~0
    1990.0f,
    // pi(1)(1600)-
    1661.0f,
    // pi(1800)-
    1810.0f,
    // K(4)(2500)-
    std::numeric_limits<float>::quiet_NaN(),
    // K(2)(1580)-
    std::numeric_limits<float>::quiet_NaN(),
    // K(1)(1650)-
    1650.0f,
    // K(0)*(700)-
    845.0f,
    // K(1)(1650)~0
    1650.0f,
    // K(0)*(700)~0
    845.0f,
    // a(2)(1700)-
    1706.0f,
    // pi(1)(1400)-
    1354.0f,
    // a(0)(980)-
    980.0f,
    // Lambda(c)(2880)~-
    2881.63f,
    // Omega(2250)~+
    2252.0f,
    // Xi(2030)~0
    2025.0f,
    // Xi(1690)~0
    1690.0f,
    // Xi(2030)~+
    2025.0f,
    // Xi(1690)~+
    1690.0f,
    // Xi(c)(2790)~-
    2791.9f,
    // Xi(c)(2815)~-
    2816.51f,
    // Xi(c)(2790)~0
    2793.9f,
    // Xi(c)(2815)~0
    2819.79f,
    // Lambda(c)(2625)~-
    2628.11f,
    // Xi(1950)~0
    1950.0f,
    // Xi(1950)~+
    1950.0f,
    // K*(1410)-
    1414.0f,
    // K(1460)-
    std::numeric_limits<float>::quiet_NaN(),
    // K*(1410)~0
    1414.0f,
    // rho(1450)-
    1465.0f,
    // pi(1300)-
    1300.0f,
    // Lambda(1810)~
    1790.0f,
    // Lambda(1800)~
    1800.0f,
    // N(1710)~-
    1710.0f,
    // N(1710)~0
    1710.0f,
    // Lambda(1670)~
    1674.0f,
    // Delta(1600)~--
    1570.0f,
    // Delta(1600)~-
    1570.0f,
    // N(1650)~-
    1650.0f,
    // N(1720)~-
    1720.0f,
    // Delta(1600)~0
    1570.0f,
    // N(1650)~0
    1650.0f,
    // N(1720)~0
    1720.0f,
    // Delta(1600)~+
    1570.0f,
    // K*(1680)-
    1718.0f,
    // K*(1680)~0
    1718.0f,
    // rho(1700)-
    1720.0f,
    // Sigma(1910)~-
    1910.0f,
    // Sigma(1750)~-
    1750.0f,
    // Sigma(1910)~0
    1910.0f,
    // Sigma(1750)~0
    1750.0f,
    // Lambda(2110)~
    2090.0f,
    // Lambda(1890)~
    1890.0f,
    // Lambda(1600)~
    1600.0f,
    // Sigma(1910)~+
    1910.0f,
    // Sigma(1750)~+
    1750.0f,
    // Delta(1920)~--
    1920.0f,
    // Delta(1910)~--
    1900.0f,
    // Delta(1920)~-
    1920.0f,
    // N(1535)~-
    1530.0f,
    // N(1700)~-
    1720.0f,
    // Delta(1910)~-
    1900.0f,
    // Delta(1920)~0
    1920.0f,
    // N(1535)~0
    1530.0f,
    // N(1700)~0
    1720.0f,
    // Delta(1910)~0
    1900.0f,
    // Delta(1920)~+
    1920.0f,
    // Delta(1910)~+
    1900.0f,
    // D(s1)(2460)-
    2459.5f,
    // D(1)(2430)~0
    2412.0f,
    // K(2)(1820)-
    1819.0f,
    // K(1)(1400)-
    1403.0f,
    // K(2)(1820)~0
    1819.0f,
    // K(1)(1400)~0
    1403.0f,
    // a(1)(1260)-
    1230.0f,
    // Lambda(c)(2595)~-
    2592.25f,
    // Xi(1820)~0
    1823.0f,
    // Xi(1820)~+
    1823.0f,
    // Sigma(1915)~-
    1915.0f,
    // Sigma(1670)~-
    1675.0f,
    // Sigma(1660)~-
    1660.0f,
    // Sigma(1915)~0
    1915.0f,
    // Sigma(1670)~0
    1675.0f,
    // Sigma(1660)~0
    1660.0f,
    // Lambda(1830)~
    1825.0f,
    // Lambda(1690)~
    1690.0f,
    // Lambda(1405)~
    1405.1f,
    // Sigma(1915)~+
    1915.0f,
    // Sigma(1670)~+
    1675.0f,
    // Sigma(1660)~+
    1660.0f,
    // Delta(1930)~--
    1950.0f,
    // Delta(1700)~--
    1710.0f,
    // Delta(1900)~--
    1860.0f,
    // N(1680)~-
    1685.0f,
    // Delta(1700)~-
    1710.0f,
    // N(1440)~-
    1440.0f,
    // Delta(1930)~-
    1950.0f,
    // Delta(1900)~-
    1860.0f,
    // N(1680)~0
    1685.0f,
    // Delta(1700)~0
    1710.0f,
    // N(1440)~0
    1440.0f,
    // Delta(1930)~0
    1950.0f,
    // Delta(1900)~0
    1860.0f,
    // Delta(1930)~+
    1950.0f,
    // Delta(1700)~+
    1710.0f,
    // Delta(1900)~+
    1860.0f,
    // D(s1)(2536)-
    2535.11f,
    // D(s0)*(2317)-
    2317.8f,
    // D(1)(2420)~0
    2422.1f,
    // D(0)*(2300)~0
    2343.0f,
    // D(1)(2420)-
    2422.1f,
    // D(0)*(2300)-
    2343.0f,
    // K(2)(1770)-
    1773.0f,
    // K(1)(1270)-
    1253.0f,
    // K(0)*(1430)-
    1430.0f,
    // K(2)(1770)~0
    1773.0f,
    // K(1)(1270)~0
    1253.0f,
    // K(0)*(1430)~0
    1430.0f,
    // pi(2)(1670)-
    1670.6f,
    // b(1)(1235)-
    1229.5f,
    // a(0)(1450)-
    1439.0f,
    // (bb)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (bc)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (bc)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Omega(b)~+
    6045.2f,
    // (bs)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (bs)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Xi(b)~0
    5791.9f,
    // Sigma(b)*~-
    5830.32f,
    // Sigma(b)~-
    5810.56f,
    // (bu)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (bu)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Xi(b)~+
    5797.0f,
    // Lambda(b)~0
    5619.6f,
    // Sigma(b)*~+
    5834.74f,
    // Sigma(b)~+
    5815.64f,
    // (bd)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (bd)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // (cc)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // Omega(c)(2770)~0
    2765.9f,
    // Omega(c)~0
    2695.2f,
    // Xi(c)(2645)~-
    2645.1f,
    // Xi(c)'~-
    2578.2f,
    // Xi(c)(2645)~0
    2646.16f,
    // Xi(c)'~0
    2578.7f,
    // (cs)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (cs)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Xi(c)~-
    2467.71f,
    // Sigma(c)(2520)~--
    2518.41f,
    // Sigma(c)(2455)~--
    2453.97f,
    // Sigma(c)(2520)~-
    2517.4f,
    // Sigma(c)(2455)~-
    2452.65f,
    // (cu)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (cu)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Xi(c)~0
    2470.44f,
    // Lambda(c)~-
    2286.46f,
    // Sigma(c)(2520)~0
    2518.48f,
    // Sigma(c)(2455)~0
    2453.75f,
    // (cd)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (cd)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Omega~+
    1672.45f,
    // Xi(1530)~0
    1531.8f,
    // Xi~0
    1314.86f,
    // Xi(1530)~+
    1535.0f,
    // Xi~+
    1321.71f,
    // (ss)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma(2030)~-
    2030.0f,
    // Sigma(1775)~-
    1775.0f,
    // Sigma(1385)~-
    1382.83f,
    // Sigma~-
    1189.37f,
    // Sigma(2030)~0
    2030.0f,
    // Sigma(1775)~0
    1775.0f,
    // Sigma(1385)~0
    1383.7f,
    // Sigma~0
    1192.642f,
    // (su)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (su)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Lambda(2100)~
    2100.0f,
    // Lambda(1820)~
    1820.0f,
    // Lambda(1520)~
    1519.0f,
    // Lambda~
    1115.683f,
    // Sigma(2030)~+
    2030.0f,
    // Sigma(1775)~+
    1775.0f,
    // Sigma(1385)~+
    1387.2f,
    // Sigma~+
    1197.449f,
    // (sd)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (sd)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // Delta(1950)~--
    1930.0f,
    // Delta(1905)~--
    1880.0f,
    // Delta(1232)~--
    1232.0f,
    // Delta(1620)~--
    1610.0f,
    // Delta(1950)~-
    1930.0f,
    // N(1675)~-
    1675.0f,
    // Delta(1232)~-
    1232.0f,
    // p~
    938.27208816f,
    // (uu)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // N(2190)~-
    2180.0f,
    // Delta(1905)~-
    1880.0f,
    // N(1520)~-
    1515.0f,
    // Delta(1620)~-
    1610.0f,
    // Delta(1950)~0
    1930.0f,
    // N(1675)~0
    1675.0f,
    // Delta(1232)~0
    1232.0f,
    // n~
    939.5654205f,
    // (ud)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // (ud)(0)~
    std::numeric_limits<float>::quiet_NaN(),
    // N(2190)~0
    2180.0f,
    // Delta(1905)~0
    1880.0f,
    // N(1520)~0
    1515.0f,
    // Delta(1620)~0
    1610.0f,
    // Delta(1950)~+
    1930.0f,
    // Delta(1905)~+
    1880.0f,
    // Delta(1232)~+
    1232.0f,
    // Delta(1620)~+
    1610.0f,
    // (dd)(1)~
    std::numeric_limits<float>::quiet_NaN(),
    // B(c)-
    6274.47f,
    // B(s2)*(5840)~0
    5839.86f,
    // B(s)*~0
    5415.4f,
    // B(s)~0
    5366.92f,
    // B(2)*(5747)-
    5737.2f,
    // B*-
    5324.71f,
    // B-
    5279.34f,
    // B(2)*(5747)~0
    5739.5f,
    // B*~0
    5324.71f,
    // B~0
    5279.66f,
    // D(s2)*(2573)-
    2569.1f,
    // D(s)*-
    2112.2f,
    // D(s)-
    1968.35f,
    // D(2)*(2460)~0
    2461.1f,
    // D*(2007)~0
    2006.85f,
    // D~0
    1864.84f,
    // D(2)*(2460)-
    2461.1f,
    // D*(2010)-
    2010.26f,
    // D-
    1869.66f,
    // K(4)*(2045)-
    2048.0f,
    // K(3)*(1780)-
    1779.0f,
    // K(2)*(1430)-
    1427.3f,
    // K*(892)-
    891.67f,
    // K-
    493.677f,
    // K(4)*(2045)~0
    2048.0f,
    // K(3)*(1780)~0
    1779.0f,
    // K(2)*(1430)~0
    1432.4f,
    // K*(892)~0
    895.55f,
    // K~0
    497.611f,
    // a(4)(1970)-
    1967.0f,
    // rho(3)(1690)-
    1688.8f,
    // a(2)(1320)-
    1318.2f,
    // rho(770)-
    775.26f,
    // pi-
    139.57039f,
    // W-
    80377.0f,
    // nu(tau')~
    std::numeric_limits<float>::quiet_NaN(),
    // tau'+
    std::numeric_limits<float>::quiet_NaN(),
    // nu(tau)~
    std::numeric_limits<float>::quiet_NaN(),
    // tau+
    1776.86f,
    // nu(mu)~
    std::numeric_limits<float>::quiet_NaN(),
    // mu+
    105.6583755f,
    // nu(e)~
    std::numeric_limits<float>::quiet_NaN(),
    // e+
    0.51099895f,
    // t~
    172500.0f,
    // b~
    4180.0f,
    // c~
    1270.0f,
    // s~
    93.4f,
    // u~
    2.16f,
    // d~
    4.67f,
    // d
    4.67f,
    // u
    2.16f,
    // s
    93.4f,
    // c
    1270.0f,
    // b
    4180.0f,
    // t
    172500.0f,
    // e-
    0.51099895f,
    // nu(e)
    std::numeric_limits<float>::quiet_NaN(),
    // mu-
    105.6583755f,
    // nu(mu)
    std::numeric_limits<float>::quiet_NaN(),
    // tau-
    1776.86f,
    // nu(tau)
    std::numeric_limits<float>::quiet_NaN(),
    // tau'-
    std::numeric_limits<float>::quiet_NaN(),
    // nu(tau')
    std::numeric_limits<float>::quiet_NaN(),
    // g
    0.0f,
    // gamma
    0.0f,
    // Z0
    91187.6f,
    // W+
    80377.0f,
    // H0
    125250.0f,
    // pi0
    134.9768f,
    // rho(770)0
    775.26f,
    // a(2)(1320)0
    1318.2f,
    // rho(3)(1690)0
    1688.8f,
    // a(4)(1970)0
    1967.0f,
    // K(L)0
    497.611f,
    // pi+
    139.57039f,
    // rho(770)+
    775.26f,
    // a(2)(1320)+
    1318.2f,
    // rho(3)(1690)+
    1688.8f,
    // a(4)(1970)+
    1967.0f,
    // eta
    547.862f,
    // omega(782)
    782.66f,
    // f(2)(1270)
    1275.4f,
    // omega(3)(1670)
    1667.0f,
    // f(4)(2050)
    2018.0f,
    // K(S)0
    497.611f,
    // K0
    497.611f,
    // K*(892)0
    895.55f,
    // K(2)*(1430)0
    1432.4f,
    // K(3)*(1780)0
    1779.0f,
    // K(4)*(2045)0
    2048.0f,
    // K+
    493.677f,
    // K*(892)+
    891.67f,
    // K(2)*(1430)+
    1427.3f,
    // K(3)*(1780)+
    1779.0f,
    // K(4)*(2045)+
    2048.0f,
    // eta'(958)
    957.78f,
    // phi(1020)
    1019.461f,
    // f(2)'(1525)
    1517.4f,
    // phi(3)(1850)
    1854.0f,
    // D+
    1869.66f,
    // D*(2010)+
    2010.26f,
    // D(2)*(2460)+
    2461.1f,
    // D0
    1864.84f,
    // D*(2007)0
    2006.85f,
    // D(2)*(2460)0
    2461.1f,
    // D(s)+
    1968.35f,
    // D(s)*+
    2112.2f,
    // D(s2)*(2573)+
    2569.1f,
    // eta(c)(1S)
    2983.9f,
    // J/psi(1S)
    3096.9f,
    // chi(c2)(1P)
    3556.17f,
    // B0
    5279.66f,
    // B*0
    5324.71f,
    // B(2)*(5747)0
    5739.5f,
    // B+
    5279.34f,
    // B*+
    5324.71f,
    // B(2)*(5747)+
    5737.2f,
    // B(s)0
    5366.92f,
    // B(s)*0
    5415.4f,
    // B(s2)*(5840)0
    5839.86f,
    // B(c)+
    6274.47f,
    // eta(b)(1S)
    9398.7f,
    // Upsilon(1S)
    9460.4f,
    // chi(b2)(1P)
    9912.2f,
    // (dd)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Delta(1620)-
    1610.0f,
    // Delta(1232)-
    1232.0f,
    // Delta(1905)-
    1880.0f,
    // Delta(1950)-
    1930.0f,
    // Delta(1620)0
    1610.0f,
    // N(1520)0
    1515.0f,
    // Delta(1905)0
    1880.0f,
    // N(2190)0
    2180.0f,
    // (ud)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (ud)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // n
    939.5654205f,
    // Delta(1232)0
    1232.0f,
    // N(1675)0
    1675.0f,
    // Delta(1950)0
    1930.0f,
    // Delta(1620)+
    1610.0f,
    // N(1520)+
    1515.0f,
    // Delta(1905)+
    1880.0f,
    // N(2190)+
    2180.0f,
    // (uu)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // p
    938.27208816f,
    // Delta(1232)+
    1232.0f,
    // N(1675)+
    1675.0f,
    // Delta(1950)+
    1930.0f,
    // Delta(1620)++
    1610.0f,
    // Delta(1232)++
    1232.0f,
    // Delta(1905)++
    1880.0f,
    // Delta(1950)++
    1930.0f,
    // (sd)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (sd)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma-
    1197.449f,
    // Sigma(1385)-
    1387.2f,
    // Sigma(1775)-
    1775.0f,
    // Sigma(2030)-
    2030.0f,
    // Lambda
    1115.683f,
    // Lambda(1520)
    1519.0f,
    // Lambda(1820)
    1820.0f,
    // Lambda(2100)
    2100.0f,
    // (su)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (su)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma0
    1192.642f,
    // Sigma(1385)0
    1383.7f,
    // Sigma(1775)0
    1775.0f,
    // Sigma(2030)0
    2030.0f,
    // Sigma+
    1189.37f,
    // Sigma(1385)+
    1382.83f,
    // Sigma(1775)+
    1775.0f,
    // Sigma(2030)+
    2030.0f,
    // (ss)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Xi-
    1321.71f,
    // Xi(1530)-
    1535.0f,
    // Xi0
    1314.86f,
    // Xi(1530)0
    1531.8f,
    // Omega-
    1672.45f,
    // (cd)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (cd)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma(c)(2455)0
    2453.75f,
    // Sigma(c)(2520)0
    2518.48f,
    // Lambda(c)+
    2286.46f,
    // Xi(c)0
    2470.44f,
    // (cu)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (cu)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma(c)(2455)+
    2452.65f,
    // Sigma(c)(2520)+
    2517.4f,
    // Sigma(c)(2455)++
    2453.97f,
    // Sigma(c)(2520)++
    2518.41f,
    // Xi(c)+
    2467.71f,
    // (cs)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (cs)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Xi(c)'0
    2578.7f,
    // Xi(c)(2645)0
    2646.16f,
    // Xi(c)'+
    2578.2f,
    // Xi(c)(2645)+
    2645.1f,
    // Omega(c)0
    2695.2f,
    // Omega(c)(2770)0
    2765.9f,
    // (cc)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // (bd)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (bd)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma(b)-
    5815.64f,
    // Sigma(b)*-
    5834.74f,
    // Lambda(b)0
    5619.6f,
    // Xi(b)-
    5797.0f,
    // (bu)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (bu)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Sigma(b)+
    5810.56f,
    // Sigma(b)*+
    5830.32f,
    // Xi(b)0
    5791.9f,
    // (bs)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (bs)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // Omega(b)-
    6045.2f,
    // (bc)(0)
    std::numeric_limits<float>::quiet_NaN(),
    // (bc)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // (bb)(1)
    std::numeric_limits<float>::quiet_NaN(),
    // a(0)(1450)0
    1439.0f,
    // b(1)(1235)0
    1229.5f,
    // pi(2)(1670)0
    1670.6f,
    // a(0)(1450)+
    1439.0f,
    // b(1)(1235)+
    1229.5f,
    // pi(2)(1670)+
    1670.6f,
    // f(0)(1370)
    1350.0f,
    // h(1)(1170)
    1166.0f,
    // eta(2)(1645)
    1617.0f,
    // K(0)*(1430)0
    1430.0f,
    // K(1)(1270)0
    1253.0f,
    // K(2)(1770)0
    1773.0f,
    // K(0)*(1430)+
    1430.0f,
    // K(1)(1270)+
    1253.0f,
    // K(2)(1770)+
    1773.0f,
    // f(0)(1710)
    1733.0f,
    // h(1)(1415)
    1409.0f,
    // eta(2)(1870)
    1842.0f,
    // D(0)*(2300)+
    2343.0f,
    // D(1)(2420)+
    2422.1f,
    // D(0)*(2300)0
    2343.0f,
    // D(1)(2420)0
    2422.1f,
    // D(s0)*(2317)+
    2317.8f,
    // D(s1)(2536)+
    2535.11f,
    // chi(c0)(1P)
    3414.71f,
    // h(c)(1P)
    3525.37f,
    // chi(b0)(1P)
    9859.4f,
    // h(b)(1P)
    9899.3f,
    // Delta(1900)-
    1860.0f,
    // Delta(1700)-
    1710.0f,
    // Delta(1930)-
    1950.0f,
    // Delta(1900)0
    1860.0f,
    // Delta(1930)0
    1950.0f,
    // N(1440)0
    1440.0f,
    // Delta(1700)0
    1710.0f,
    // N(1680)0
    1685.0f,
    // Delta(1900)+
    1860.0f,
    // Delta(1930)+
    1950.0f,
    // N(1440)+
    1440.0f,
    // Delta(1700)+
    1710.0f,
    // N(1680)+
    1685.0f,
    // Delta(1900)++
    1860.0f,
    // Delta(1700)++
    1710.0f,
    // Delta(1930)++
    1950.0f,
    // Sigma(1660)-
    1660.0f,
    // Sigma(1670)-
    1675.0f,
    // Sigma(1915)-
    1915.0f,
    // Lambda(1405)
    1405.1f,
    // Lambda(1690)
    1690.0f,
    // Lambda(1830)
    1825.0f,
    // Sigma(1660)0
    1660.0f,
    // Sigma(1670)0
    1675.0f,
    // Sigma(1915)0
    1915.0f,
    // Sigma(1660)+
    1660.0f,
    // Sigma(1670)+
    1675.0f,
    // Sigma(1915)+
    1915.0f,
    // Xi(1820)-
    1823.0f,
    // Xi(1820)0
    1823.0f,
    // Lambda(c)(2595)+
    2592.25f,
    // a(1)(1260)0
    1230.0f,
    // a(1)(1260)+
    1230.0f,
    // f(1)(1285)
    1281.9f,
    // K(1)(1400)0
    1403.0f,
    // K(2)(1820)0
    1819.0f,
    // K(1)(1400)+
    1403.0f,
    // K(2)(1820)+
    1819.0f,
    // f(1)(1420)
    1426.3f,
    // D(1)(2430)0
    2412.0f,
    // D(s1)(2460)+
    2459.5f,
    // chi(c1)(1P)
    3510.67f,
    // chi(b1)(1P)
    9892.8f,
    // Upsilon(2)(1D)
    10163.7f,
    // Delta(1910)-
    1900.0f,
    // Delta(1920)-
    1920.0f,
    // Delta(1910)0
    1900.0f,
    // N(1700)0
    1720.0f,
    // N(1535)0
    1530.0f,
    // Delta(1920)0
    1920.0f,
    // Delta(1910)+
    1900.0f,
    // N(1700)+
    1720.0f,
    // N(1535)+
    1530.0f,
    // Delta(1920)+
    1920.0f,
    // Delta(1910)++
    1900.0f,
    // Delta(1920)++
    1920.0f,
    // Sigma(1750)-
    1750.0f,
    // Sigma(1910)-
    1910.0f,
    // Lambda(1600)
    1600.0f,
    // Lambda(1890)
    1890.0f,
    // Lambda(2110)
    2090.0f,
    // Sigma(1750)0
    1750.0f,
    // Sigma(1910)0
    1910.0f,
    // Sigma(1750)+
    1750.0f,
    // Sigma(1910)+
    1910.0f,
    // rho(1700)0
    1720.0f,
    // rho(1700)+
    1720.0f,
    // omega(1650)
    1670.0f,
    // K*(1680)0
    1718.0f,
    // K*(1680)+
    1718.0f,
    // psi(3770)
    3773.7f,
    // Delta(1600)-
    1570.0f,
    // N(1720)0
    1720.0f,
    // N(1650)0
    1650.0f,
    // Delta(1600)0
    1570.0f,
    // N(1720)+
    1720.0f,
    // N(1650)+
    1650.0f,
    // Delta(1600)+
    1570.0f,
    // Delta(1600)++
    1570.0f,
    // Lambda(1670)
    1674.0f,
    // N(1710)0
    1710.0f,
    // N(1710)+
    1710.0f,
    // Lambda(1800)
    1800.0f,
    // Lambda(1810)
    1790.0f,
    // pi(1300)0
    1300.0f,
    // rho(1450)0
    1465.0f,
    // pi(1300)+
    1300.0f,
    // rho(1450)+
    1465.0f,
    // eta(1295)
    1294.0f,
    // omega(1420)
    1410.0f,
    // K*(1410)0
    1414.0f,
    // K(1460)+
    std::numeric_limits<float>::quiet_NaN(),
    // K*(1410)+
    1414.0f,
    // eta(1475)
    1475.0f,
    // phi(1680)
    1680.0f,
    // eta(c)(2S)
    3637.7f,
    // psi(2S)
    3686.1f,
    // chi(c2)(3930)
    3922.5f,
    // Upsilon(2S)
    10023.4f,
    // chi(b2)(2P)
    10268.6f,
    // Xi(1950)-
    1950.0f,
    // Xi(1950)0
    1950.0f,
    // Lambda(c)(2625)+
    2628.11f,
    // Xi(c)(2815)0
    2819.79f,
    // Xi(c)(2790)0
    2793.9f,
    // Xi(c)(2815)+
    2816.51f,
    // Xi(c)(2790)+
    2791.9f,
    // chi(b0)(2P)
    10232.5f,
    // h(b)(2P)
    10259.8f,
    // chi(b1)(2P)
    10255.5f,
    // Upsilon(3S)
    10355.1f,
    // chi(b2)(3P)
    10524.0f,
    // Xi(1690)-
    1690.0f,
    // Xi(2030)-
    2025.0f,
    // Xi(1690)0
    1690.0f,
    // Xi(2030)0
    2025.0f,
    // Omega(2250)-
    2252.0f,
    // Lambda(c)(2880)+
    2881.63f,
    // chi(b1)(3P)
    10513.4f,
    // Upsilon(4S)
    10579.4f,
    // a(0)(980)0
    980.0f,
    // pi(1)(1400)0
    1354.0f,
    // a(2)(1700)0
    1706.0f,
    // a(0)(980)+
    980.0f,
    // pi(1)(1400)+
    1354.0f,
    // a(2)(1700)+
    1706.0f,
    // f(0)(500)
    600.0f,
    // K(0)*(700)0
    845.0f,
    // K(1)(1650)0
    1650.0f,
    // K(0)*(700)+
    845.0f,
    // K(1)(1650)+
    1650.0f,
    // K(2)(1580)+
    std::numeric_limits<float>::quiet_NaN(),
    // K(4)(2500)+
    std::numeric_limits<float>::quiet_NaN(),
    // psi(4040)
    4039.0f,
    // Upsilon(10860)
    10885.2f,
    // pi(1800)0
    1810.0f,
    // pi(1)(1600)0
    1661.0f,
    // pi(1800)+
    1810.0f,
    // pi(1)(1600)+
    1661.0f,
    // f(0)(980)
    990.0f,
    // K(2)*(1980)0
    1990.0f,
    // K(1830)+
    std::numeric_limits<float>::quiet_NaN(),
    // K(2)*(1980)+
    1990.0f,
    // K(3)(2320)+
    std::numeric_limits<float>::quiet_NaN(),
    // psi(4160)
    4191.0f,
    // Upsilon(11020)
    11000.0f,
    // a(1)(1640)0
    1655.0f,
    // a(1)(1640)+
    1655.0f,
    // eta(1405)
    1408.8f,
    // K(0)*(1950)+
    std::numeric_limits<float>::quiet_NaN(),
    // K(2)(2250)+
    std::numeric_limits<float>::quiet_NaN(),
    // psi(4415)
    4421.0f,
    // f(0)(1500)
    1522.0f,
    // f(0)(2020)
    1982.0f,
    // f(2)(1950)
    1936.0f,
    // f(2)(2010)
    2010.0f,
    // f(2)(2300)
    2297.0f,
    // f(2)(2340)
    2346.0f,
    // n
    939.5654205f,
    // p
    938.27208816f,
    // D2
    1876.1239278f,
    // T3
    2809.4321052f,
    // H4
    3751.8998904f,
    // H5
    4694.3017887f,
    // H6
    5630.8259593f,
    // He3
    2809.4135146f,
    // He4
    3728.4013213f,
    // He5
    4668.8533699f,
    // He6
    5606.5587681f,
    // He7
    6546.5684964f,
    // He8
    7483.550962f,
    // He9
    8424.264993f,
    // He10
    9363.7513148f,
    // Li4
    3751.2944192f,
    // Li5
    4669.151448f,
    // Li6
    5603.0509476f,
    // Li7
    6535.3663483f,
    // Li8
    7472.8990475f,
    // Li9
    8408.4008101f,
    // Li10
    9347.9913661f,
    // Li11
    10287.2308419f,
    // Li12
    11228.0249814f,
    // Be5
    4695.4661564f,
    // Be6
    5607.339267f,
    // Be7
    6536.2281667f,
    // Be8
    7456.8944791f,
    // Be9
    8394.7944758f,
    // Be10
    9327.5475856f,
    // Be11
    10266.6094255f,
    // Be12
    11203.0059814f,
    // Be13
    12143.0782129f,
    // Be14
    13080.8040109f,
    // B7
    6548.3290202f,
    // B8
    7474.873815f,
    // B9
    8395.8626201f,
    // B10
    9326.9917631f,
    // B11
    10255.1031446f,
    // B12
    11191.2981251f,
    // B13
    12125.9855756f,
    // B14
    13064.5811096f,
    // B15
    14001.3782079f,
    // B16
    14940.9884184f,
    // B17
    15879.1147588f,
    // B18
    16819.2158667f,
    // B19
    17757.7520645f,
    // C8
    7487.0468594f,
    // C9
    8412.3605916f,
    // C10
    9330.6395871f,
    // C11
    10257.0856435f,
    // C12
    11177.9292286f,
    // C13
    12112.5483426f,
    // C14
    13043.9373261f,
    // C15
    13982.2847212f,
    // C16
    14917.599533f,
    // C17
    15856.4366034f,
    // C18
    16791.8206251f,
    // C19
    17731.2231124f,
    // C20
    18667.4398899f,
    // C21
    19607.3360691f,
    // C22
    20545.4530946f,
    // N10
    9354.6413025f,
    // N11
    10271.3991682f,
    // N12
    11195.2673146f,
    // N13
    12114.7687844f,
    // N14
    13043.7808511f,
    // N15
    13972.512974f,
    // N16
    14909.5890563f,
    // N17
    15843.2708657f,
    // N18
    16780.0111429f,
    // N19
    17714.2484954f,
    // N20
    18651.6510649f,
    // N21
    19586.6103253f,
    // N22
    20524.9509094f,
    // N23
    21462.0991809f,
    // N24
    22402.8989094f,
    // O12
    11209.9772832f,
    // O13
    12132.5336997f,
    // O14
    13048.9238953f,
    // O15
    13975.2669378f,
    // O16
    14899.1686386f,
    // O17
    15834.5907379f,
    // O18
    16766.1117605f,
    // O19
    17701.7217627f,
    // O20
    18633.679004f,
    // O21
    19569.4382315f,
    // O22
    20502.1572487f,
    // O23
    21438.9794973f,
    // O24
    22374.8329921f,
    // O25
    23314.4962978f,
    // O26
    24254.0105644f,
    // F14
    13074.5257406f,
    // F15
    13989.1877446f,
    // F16
    14914.5861495f,
    // F17
    15837.3514443f,
    // F18
    16767.767305f,
    // F19
    17696.9005355f,
    // F20
    18629.8646474f,
    // F21
    19561.3285507f,
    // F22
    20495.6638033f,
    // F23
    21427.6897888f,
    // F24
    22363.4035595f,
    // F25
    23298.6143233f,
    // F26
    24237.1318912f,
    // F27
    25175.3886408f,
    // F28
    26115.0612614f,
    // F29
    27053.625404f,
    // Ne16
    14927.8981318f,
    // Ne17
    15851.8871862f,
    // Ne18
    16772.200658f,
    // Ne19
    17700.1389679f,
    // Ne20
    18622.8401161f,
    // Ne21
    19555.6444247f,
    // Ne22
    20484.8459058f,
    // Ne23
    21419.2107147f,
    // Ne24
    22349.9108674f,
    // Ne25
    23285.2939577f,
    // Ne26
    24219.2751493f,
    // Ne27
    25157.4387495f,
    // Ne28
    26093.1152604f,
    // Ne29
    27031.3533801f,
    // Ne30
    27967.0578358f,
    // Ne31
    28907.1589437f,
    // Ne32
    29844.987206f,
    // Na18
    16792.2118526f,
    // Na19
    17711.316152f,
    // Na20
    18636.7266664f,
    // Na21
    19559.1918896f,
    // Na22
    20487.6881645f,
    // Na23
    21414.8348628f,
    // Na24
    22347.4408524f,
    // Na25
    23277.9951425f,
    // Na26
    24211.9442907f,
    // Na27
    25144.7611147f,
    // Na28
    26080.8009083f,
    // Na29
    27015.9464676f,
    // Na30
    27953.4207621f,
    // Na31
    28888.9854937f,
    // Na32
    29826.1151354f,
    // Na33
    30764.8190022f,
    // Na34
    31703.3086253f,
    // Na35
    32643.4469929f,
    // Mg20
    18647.452821f,
    // Mg21
    19572.287672f,
    // Mg22
    20492.4735291f,
    // Mg23
    21418.8917339f,
    // Mg24
    22341.9250753f,
    // Mg25
    23274.1598273f,
    // Mg26
    24202.6321814f,
    // Mg27
    25135.7542561f,
    // Mg28
    26066.8161079f,
    // Mg29
    27002.6633617f,
    // Mg30
    27935.9366178f,
    // Mg31
    28873.1035193f,
    // Mg32
    29807.0195063f,
    // Mg33
    30744.5124307f,
    // Mg34
    31679.2481326f,
    // Mg35
    32618.5854153f,
    // Mg36
    33554.6997285f,
    // Mg37
    34494.381664f,
    // Al21
    19587.4952447f,
    // Al22
    20511.0530174f,
    // Al23
    21431.1316595f,
    // Al24
    22355.8034991f,
    // Al25
    23278.436857f,
    // Al26
    24206.6363206f,
    // Al27
    25133.1439301f,
    // Al28
    26064.9843061f,
    // Al29
    26995.1134157f,
    // Al30
    27928.9504121f,
    // Al31
    28861.3629676f,
    // Al32
    29796.7451264f,
    // Al33
    30730.8008376f,
    // Al34
    31667.9397942f,
    // Al35
    32602.2376938f,
    // Al36
    33539.7026734f,
    // Al37
    34474.8854924f,
    // Al38
    35412.518141f,
    // Al39
    36348.6697139f,
    // Si22
    20525.0347438f,
    // Si23
    21448.1360844f,
    // Si24
    22366.6134882f,
    // Si25
    23291.1782059f,
    // Si26
    24211.7021022f,
    // Si27
    25137.9563268f,
    // Si28
    26060.3420681f,
    // Si29
    26991.4339395f,
    // Si30
    27920.3901862f,
    // Si31
    28853.3682052f,
    // Si32
    29783.7303839f,
    // Si33
    30718.81344f,
    // Si34
    31650.8431514f,
    // Si35
    32587.9299444f,
    // Si36
    33521.3894994f,
    // Si37
    34458.7613295f,
    // Si38
    35393.0312843f,
    // Si39
    36330.4124295f,
    // Si40
    37265.1667612f,
    // Si41
    38203.0881729f,
    // Si42
    39137.7493552f,
    // P24
    22387.8552797f,
    // P25
    23306.2246301f,
    // P26
    24229.8196625f,
    // P27
    25149.5862542f,
    // P28
    26074.6735401f,
    // P29
    26996.3770806f,
    // P30
    27924.6225042f,
    // P31
    28851.8761753f,
    // P32
    29783.5059498f,
    // P33
    30712.9676624f,
    // P34
    31646.2415706f,
    // P35
    32577.4359182f,
    // P36
    33513.5370041f,
    // P37
    34446.2886235f,
    // P38
    35382.3097872f,
    // P39
    36315.6203031f,
    // P40
    37251.4272232f,
    // P41
    38186.4144285f,
    // P42
    39122.8361346f,
    // P43
    40057.329648f,
    // P44
    40994.9436667f,
    // P45
    41931.337428f,
    // P46
    42870.9262142f,
    // S26
    24244.8167176f,
    // S27
    25167.8528535f,
    // S28
    26085.905496f,
    // S29
    27010.1712042f,
    // S30
    27930.7603051f,
    // S31
    28857.2722181f,
    // S32
    29781.7952888f,
    // S33
    30712.7191398f,
    // S34
    31640.8676228f,
    // S35
    32573.4472045f,
    // S36
    33503.1237197f,
    // S37
    34438.3855667f,
    // S38
    35369.9143952f,
    // S39
    36305.1130496f,
    // S40
    37236.9145451f,
    // S41
    38172.6562606f,
    // S42
    39105.5103443f,
    // S43
    40041.7643816f,
    // S44
    40974.8606538f,
    // S45
    41912.4094679f,
    // S46
    42848.3281673f,
    // S47
    43787.3207972f,
    // S48
    44723.8170229f,
    // S49
    45663.7132021f,
    // Cl28
    26108.3917636f,
    // Cl29
    27026.472351f,
    // Cl30
    27949.2662984f,
    // Cl31
    28869.2564486f,
    // Cl32
    29794.4806642f,
    // Cl33
    30718.3018634f,
    // Cl34
    31646.3589109f,
    // Cl35
    32573.2800665f,
    // Cl36
    33504.2657967f,
    // Cl37
    34433.5202612f,
    // Cl38
    35366.9779066f,
    // Cl39
    36298.4693543f,
    // Cl40
    37232.2104999f,
    // Cl41
    38163.9188459f,
    // Cl42
    39097.7603134f,
    // Cl43
    40030.2138547f,
    // Cl44
    40965.7506415f,
    // Cl45
    41898.3252771f,
    // Cl46
    42833.9365834f,
    // Cl47
    43768.9983082f,
    // Cl48
    44706.9197199f,
    // Cl49
    45643.1085525f,
    // Cl50
    46581.9055687f,
    // Cl51
    47518.8023368f,
    // Ar30
    27964.9060844f,
    // Ar31
    28887.6161974f,
    // Ar32
    29805.6315801f,
    // Ar33
    30729.9252331f,
    // Ar34
    31652.4211025f,
    // Ar35
    32579.2453455f,
    // Ar36
    33503.5572371f,
    // Ar37
    34434.333735f,
    // Ar38
    35362.0611547f,
    // Ar39
    36295.027763f,
    // Ar40
    37224.7241963f,
    // Ar41
    38158.1909024f,
    // Ar42
    39088.3335931f,
    // Ar43
    40022.26821f,
    // Ar44
    40953.4782067f,
    // Ar45
    41887.5106305f,
    // Ar46
    42819.0047329f,
    // Ar47
    43754.3179611f,
    // Ar48
    44688.4947665f,
    // Ar49
    45626.611792f,
    // Ar50
    46561.6083122f,
    // Ar51
    47499.9023215f,
    // Ar52
    48435.9886898f,
    // Ar53
    49374.9906347f,
    // K32
    29828.2296271f,
    // K33
    30746.0680259f,
    // K34
    31669.3184055f,
    // K35
    32591.1268322f,
    // K36
    33516.3622257f,
    // K37
    34440.4825369f,
    // K38
    35367.9741861f,
    // K39
    36294.4631844f,
    // K40
    37226.2290688f,
    // K41
    38155.699314f,
    // K42
    39087.7310096f,
    // K43
    40017.6535882f,
    // K44
    40949.9338717f,
    // K45
    41880.6268891f,
    // K46
    42813.309578f,
    // K47
    43744.5260951f,
    // K48
    44679.5924774f,
    // K49
    45612.8908838f,
    // K50
    46549.3498498f,
    // K51
    47484.1973309f,
    // K52
    48421.4946416f,
    // K53
    49357.1897824f,
    // K54
    50295.0832492f,
    // K55
    51231.6074198f,
    // Ca34
    31683.9521778f,
    // Ca35
    32606.7368103f,
    // Ca36
    33527.3510616f,
    // Ca37
    34452.1216396f,
    // Ca38
    35374.7171788f,
    // Ca39
    36300.9937033f,
    // Ca40
    37224.9180188f,
    // Ca41
    38156.1206567f,
    // Ca42
    39084.2054907f,
    // Ca43
    40015.8379199f,
    // Ca44
    40944.2714122f,
    // Ca45
    41876.4220316f,
    // Ca46
    42805.593826f,
    // Ca47
    43737.8831449f,
    // Ca48
    44667.5026154f,
    // Ca49
    45601.9206778f,
    // Ca50
    46535.1333868f,
    // Ca51
    47470.3087539f,
    // Ca52
    48405.1841799f,
    // Ca53
    49341.289178f,
    // Ca54
    50277.0960981f,
    // Ca55
    51214.0580709f,
    // Ca56
    52150.4332024f,
    // Ca57
    53088.047221f,
    // Sc36
    33547.6855779f,
    // Sc37
    34468.1228453f,
    // Sc38
    35391.8389719f,
    // Sc39
    36314.1019677f,
    // Sc40
    37239.2376914f,
    // Sc41
    38162.6159651f,
    // Sc42
    39090.6314027f,
    // Sc43
    40018.0587882f,
    // Sc44
    40947.9246389f,
    // Sc45
    41876.1652187f,
    // Sc46
    42806.9701086f,
    // Sc47
    43735.8911448f,
    // Sc48
    44667.2240987f,
    // Sc49
    45596.6586676f,
    // Sc50
    46530.1675917f,
    // Sc51
    47462.9806898f,
    // Sc52
    48397.3130547f,
    // Sc53
    49331.2197268f,
    // Sc54
    50266.216247f,
    // Sc55
    51201.8368683f,
    // Sc56
    52138.2026848f,
    // Sc57
    53073.7767314f,
    // Sc58
    54010.8877432f,
    // Sc59
    54947.0113713f,
    // Ti38
    35405.876588f,
    // Ti39
    36329.4995652f,
    // Ti40
    37250.9149014f,
    // Ti41
    38175.5438923f,
    // Ti42
    39097.6317672f,
    // Ti43
    40024.9257627f,
    // Ti44
    40948.192164f,
    // Ti45
    41878.2276398f,
    // Ti46
    42804.6033683f,
    // Ti47
    43735.2910763f,
    // Ti48
    44663.2299451f,
    // Ti49
    45594.6529745f,
    // Ti50
    46523.279286f,
    // Ti51
    47456.4723405f,
    // Ti52
    48388.2291242f,
    // Ti53
    49322.3612179f,
    // Ti54
    50254.9172235f,
    // Ti55
    51190.3701759f,
    // Ti56
    52124.5376663f,
    // Ti57
    53060.6054048f,
    // Ti58
    53995.0896032f,
    // Ti59
    54932.0329461f,
    // Ti60
    55866.9549468f,
    // Ti61
    56804.3919815f,
    // V40
    37270.094365f,
    // V41
    38191.0160093f,
    // V42
    39114.5830969f,
    // V43
    40036.2219917f,
    // V44
    40961.8942559f,
    // V45
    41885.3607421f,
    // V46
    42811.6547787f,
    // V47
    43738.2188554f,
    // V48
    44667.2422628f,
    // V49
    45595.2548129f,
    // V50
    46525.4875791f,
    // V51
    47454.0017387f,
    // V52
    48386.2559402f,
    // V53
    49317.3432592f,
    // V54
    50250.7944307f,
    // V55
    51183.0300023f,
    // V56
    52117.4303663f,
    // V57
    53050.7874569f,
    // V58
    53986.277669f,
    // V59
    54920.2402308f,
    // V60
    55856.5781025f,
    // V61
    56790.7828527f,
    // V62
    57727.6144163f,
    // V63
    58662.4712124f,
    // Cr42
    39128.7418073f,
    // Cr43
    40052.1132811f,
    // Cr44
    40972.2058956f,
    // Cr45
    41897.8222702f,
    // Cr46
    42819.2580993f,
    // Cr47
    43745.6709014f,
    // Cr48
    44668.9017196f,
    // Cr49
    45597.8855385f,
    // Cr50
    46524.4506398f,
    // Cr51
    47454.7544791f,
    // Cr52
    48382.2805097f,
    // Cr53
    49313.9067911f,
    // Cr54
    50243.7531736f,
    // Cr55
    51177.0723524f,
    // Cr56
    52108.3809011f,
    // Cr57
    53042.7672927f,
    // Cr58
    53974.7271421f,
    // Cr59
    54910.3011887f,
    // Cr60
    55842.8199346f,
    // Cr61
    56778.3753513f,
    // Cr62
    57711.4623086f,
    // Cr63
    58648.6012652f,
    // Cr64
    59582.2750638f,
    // Cr65
    60519.5164848f,
    // Mn44
    40992.1398694f,
    // Mn45
    41912.1207047f,
    // Mn46
    42836.358468f,
    // Mn47
    43757.9601031f,
    // Mn48
    44682.7195031f,
    // Mn49
    45605.6000795f,
    // Mn50
    46532.0836751f,
    // Mn51
    47457.9622653f,
    // Mn52
    48386.9921932f,
    // Mn53
    49314.5037857f,
    // Mn54
    50245.1302013f,
    // Mn55
    51174.4691989f,
    // Mn56
    52106.7642f,
    // Mn57
    53037.6785404f,
    // Mn58
    53970.7589773f,
    // Mn59
    54902.6815669f,
    // Mn60
    55836.7279632f,
    // Mn61
    56769.405063f,
    // Mn62
    57704.1687097f,
    // Mn63
    58637.3767613f,
    // Mn64
    59572.5223205f,
    // Mn65
    60506.2240639f,
    // Mn66
    61442.1148185f,
    // Mn67
    62376.4034032f,
    // Fe45
    41930.7971615f,
    // Fe46
    42849.4832199f,
    // Fe47
    43773.599889f,
    // Fe48
    44693.6086691f,
    // Fe49
    45618.6288875f,
    // Fe50
    46540.2305225f,
    // Fe51
    47465.9819638f,
    // Fe52
    48389.3646155f,
    // Fe53
    49318.2461564f,
    // Fe54
    50244.4330711f,
    // Fe55
    51174.7005821f,
    // Fe56
    52103.0686834f,
    // Fe57
    53034.988106f,
    // Fe58
    53964.5091176f,
    // Fe59
    54897.4936105f,
    // Fe60
    55828.2392574f,
    // Fe61
    56762.222312f,
    // Fe62
    57693.7359758f,
    // Fe63
    58628.3505834f,
    // Fe64
    59560.5433064f,
    // Fe65
    60495.8285898f,
    // Fe66
    61428.291446f,
    // Fe67
    62363.5301547f,
    // Fe68
    63297.3623073f,
    // Fe69
    64233.690864f,
    // Co48
    44713.3563441f,
    // Co49
    45633.6352575f,
    // Co50
    46557.5097381f,
    // Co51
    47478.9250743f,
    // Co52
    48403.7776238f,
    // Co53
    49326.5482839f,
    // Co54
    50252.6761419f,
    // Co55
    51178.1518609f,
    // Co56
    52107.6346812f,
    // Co57
    53035.824122f,
    // Co58
    53966.8165216f,
    // Co59
    54895.928421f,
    // Co60
    55828.0019127f,
    // Co61
    56758.2452048f,
    // Co62
    57691.2060378f,
    // Co63
    58622.2912143f,
    // Co64
    59555.8336722f,
    // Co65
    60487.9528071f,
    // Co66
    61422.5627573f,
    // Co67
    62354.7834251f,
    // Co68
    63289.7706303f,
    // Co69
    64222.0471878f,
    // Co70
    65157.835478f,
    // Co71
    66091.118049f,
    // Co72
    67026.9715438f,
    // Ni50
    46570.9139383f,
    // Ni51
    47494.7604741f,
    // Ni52
    48415.0393875f,
    // Ni53
    49339.8081024f,
    // Ni54
    50261.474942f,
    // Ni55
    51186.8454022f,
    // Ni56
    52109.7697588f,
    // Ni57
    53039.087891f,
    // Ni58
    53966.4348885f,
    // Ni59
    54897.0009433f,
    // Ni60
    55825.1779952f,
    // Ni61
    56756.9234147f,
    // Ni62
    57685.8916777f,
    // Ni63
    58618.6191714f,
    // Ni64
    59548.5266599f,
    // Ni65
    60481.9940394f,
    // Ni66
    61412.581798f,
    // Ni67
    62346.3627184f,
    // Ni68
    63278.1129816f,
    // Ni69
    64212.7136169f,
    // Ni70
    65145.1019536f,
    // Ni71
    66080.1916232f,
    // Ni72
    67012.8966679f,
    // Ni73
    67948.8433121f,
    // Ni74
    68882.0420487f,
    // Ni75
    69818.2495113f,
    // Ni76
    70751.9419397f,
    // Ni77
    71688.5592597f,
    // Ni78
    72622.8198995f,
    // Cu52
    48435.0665107f,
    // Cu53
    49355.7273366f,
    // Cu54
    50278.9870312f,
    // Cu55
    51200.5514064f,
    // Cu56
    52125.068618f,
    // Cu57
    53047.8588395f,
    // Cu58
    53974.9979275f,
    // Cu59
    54901.8004667f,
    // Cu60
    55831.3048976f,
    // Cu61
    56759.1606772f,
    // Cu62
    57689.839536f,
    // Cu63
    58618.5522901f,
    // Cu64
    59550.2017657f,
    // Cu65
    60479.8569124f,
    // Cu66
    61412.3563764f,
    // Cu67
    62342.8044109f,
    // Cu68
    63276.0590371f,
    // Cu69
    64207.3528683f,
    // Cu70
    65141.6265491f,
    // Cu71
    66073.3171967f,
    // Cu72
    67007.512632f,
    // Cu73
    67939.9102837f,
    // Cu74
    68874.8602292f,
    // Cu75
    69807.7515727f,
    // Cu76
    70743.2417848f,
    // Cu77
    71676.5616156f,
    // Cu78
    72612.5827794f,
    // Cu79
    73546.3776722f,
    // Cu80
    74484.0289506f,
    // Zn54
    50294.1144954f,
    // Zn55
    51217.2530957f,
    // Zn56
    52137.9418665f,
    // Zn57
    53062.4777079f,
    // Zn58
    53984.3681061f,
    // Zn59
    54910.8973449f,
    // Zn60
    55835.4629942f,
    // Zn61
    56764.7978932f,
    // Zn62
    57691.4668562f,
    // Zn63
    58621.9191755f,
    // Zn64
    59549.6230284f,
    // Zn65
    60481.208883f,
    // Zn66
    61409.7144728f,
    // Zn67
    62342.2277229f,
    // Zn68
    63271.5949448f,
    // Zn69
    64204.678083f,
    // Zn70
    65135.0278449f,
    // Zn71
    66068.7593961f,
    // Zn72
    66999.4468246f,
    // Zn73
    67933.6599582f,
    // Zn74
    68864.8559825f,
    // Zn75
    69799.5916844f,
    // Zn76
    70731.5049591f,
    // Zn77
    71666.4455897f,
    // Zn78
    72599.3183033f,
    // Zn79
    73534.6408465f,
    // Zn80
    74467.7464337f,
    // Zn81
    75404.8947052f,
    // Zn82
    76340.4501219f,
    // Ga56
    52158.9284286f,
    // Ga57
    53079.2632316f,
    // Ga58
    54002.6719652f,
    // Ga59
    54924.0314118f,
    // Ga60
    55849.6477864f,
    // Ga61
    56773.7924003f,
    // Ga62
    57700.6383471f,
    // Ga63
    58627.4377192f,
    // Ga64
    59556.7875222f,
    // Ga65
    60484.4637097f,
    // Ga66
    61414.8891089f,
    // Ga67
    62343.2281476f,
    // Ga68
    63274.5160172f,
    // Ga69
    64203.772205f,
    // Ga70
    65135.6826852f,
    // Ga71
    66065.9444209f,
    // Ga72
    66998.9889021f,
    // Ga73
    67929.3657704f,
    // Ga74
    68862.5086174f,
    // Ga75
    69793.5937939f,
    // Ga76
    70727.3504954f,
    // Ga77
    71659.1706207f,
    // Ga78
    72592.8816791f,
    // Ga79
    73525.549464f,
    // Ga80
    74460.4621498f,
    // Ga81
    75393.0367853f,
    // Ga82
    76329.5702708f,
    // Ga83
    77264.5202163f,
    // Ga84
    78201.1095914f,
    // Ge58
    54018.2838064f,
    // Ge59
    54941.1522734f,
    // Ge60
    55861.8783039f,
    // Ge61
    56787.410844f,
    // Ge62
    57710.3910903f,
    // Ge63
    58637.2184073f,
    // Ge64
    59561.1953522f,
    // Ge65
    60490.7053722f,
    // Ge66
    61416.9924225f,
    // Ge67
    62347.4507035f,
    // Ge68
    63274.6217417f,
    // Ge69
    64205.9994074f,
    // Ge70
    65134.0268613f,
    // Ge71
    66066.1763629f,
    // Ge72
    66994.9898116f,
    // Ge73
    67927.7723566f,
    // Ge74
    68857.1415347f,
    // Ge75
    69790.2017581f,
    // Ge76
    70720.3388599f,
    // Ge77
    71653.8317623f,
    // Ge78
    72584.6780105f,
    // Ge79
    73518.5446284f,
    // Ge80
    74450.080648f,
    // Ge81
    75384.718543f,
    // Ge82
    76316.8926361f,
    // Ge83
    77253.0069492f,
    // Ge84
    78187.1092351f,
    // Ge85
    79123.6147757f,
    // Ge86
    80058.443627f,
    // As60
    55883.2467786f,
    // As61
    56803.0878898f,
    // As62
    57727.6703059f,
    // As63
    58650.3058994f,
    // As64
    59576.0992579f,
    // As65
    60500.057573f,
    // As66
    61426.7917405f,
    // As67
    62353.4607034f,
    // As68
    63282.71922f,
    // As69
    64210.012284f,
    // As70
    65140.2488693f,
    // As71
    66068.1893217f,
    // As72
    66999.3462232f,
    // As73
    67928.1129109f,
    // As74
    68859.7039818f,
    // As75
    69789.0251879f,
    // As76
    70721.2621568f,
    // As77
    71651.1296842f,
    // As78
    72583.7241606f,
    // As79
    73514.3976166f,
    // As80
    74447.4100544f,
    // As81
    75378.4896419f,
    // As82
    76312.1885909f,
    // As83
    77244.1298104f,
    // As84
    78179.4244087f,
    // As85
    79113.4801199f,
    // As86
    80049.0914262f,
    // As87
    80983.7060338f,
    // As88
    81919.8389769f,
    // As89
    82855.6831567f,
    // Se65
    60514.1976535f,
    // Se66
    61436.8891366f,
    // Se67
    62363.6139892f,
    // Se68
    63287.45121f,
    // Se69
    64216.793561f,
    // Se70
    65142.6428092f,
    // Se71
    66072.9911738f,
    // Se72
    66999.6806296f,
    // Se73
    67930.8533665f,
    // Se74
    68858.3509866f,
    // Se75
    69789.8888692f,
    // Se76
    70718.3001919f,
    // Se77
    71650.4468059f,
    // Se78
    72579.514273f,
    // Se79
    73512.1171328f,
    // Se80
    74441.7687398f,
    // Se81
    75374.6331632f,
    // Se82
    76304.9229369f,
    // Se83
    77238.6703235f,
    // Se84
    78169.5552287f,
    // Se85
    79104.5657213f,
    // Se86
    80037.9516882f,
    // Se87
    80973.4037091f,
    // Se88
    81907.5991444f,
    // Se89
    82843.3781196f,
    // Se90
    83778.0393019f,
    // Se91
    84715.0757942f,
    // Se92
    85650.2586133f,
    // Br67
    62377.3069525f,
    // Br68
    63302.7090834f,
    // Br69
    64226.6860284f,
    // Br70
    65153.0010236f,
    // Br71
    66079.4930026f,
    // Br72
    67008.4254962f,
    // Br73
    67935.5322614f,
    // Br74
    68865.2574565f,
    // Br75
    69792.9184606f,
    // Br76
    70723.2630993f,
    // Br77
    71651.8118173f,
    // Br78
    72583.0879501f,
    // Br79
    73511.9660444f,
    // Br80
    74443.6393663f,
    // Br81
    75373.0478534f,
    // Br82
    76305.0207437f,
    // Br83
    77235.0011682f,
    // Br84
    78167.7285688f,
    // Br85
    79098.3880525f,
    // Br86
    80032.8526895f,
    // Br87
    80966.1296716f,
    // Br88
    81900.7526627f,
    // Br89
    82834.4078314f,
    // Br90
    83769.8514688f,
    // Br91
    84704.4567615f,
    // Br92
    85640.8784677f,
    // Br93
    86575.9495074f,
    // Br94
    87512.6413469f,
    // Kr69
    64240.7888491f,
    // Kr70
    65163.6107414f,
    // Kr71
    66089.9816262f,
    // Kr72
    67013.4648793f,
    // Kr73
    67942.1831293f,
    // Kr74
    68868.3956601f,
    // Kr75
    69797.8162566f,
    // Kr76
    70724.57278f,
    // Kr77
    71654.8745699f,
    // Kr78
    72582.3800146f,
    // Kr79
    73513.5918742f,
    // Kr80
    74441.634791f,
    // Kr81
    75373.3282331f,
    // Kr82
    76301.9278107f,
    // Kr83
    77234.0286884f,
    // Kr84
    78163.0738928f,
    // Kr85
    79095.5181191f,
    // Kr86
    80025.2268268f,
    // Kr87
    80959.276949f,
    // Kr88
    81891.788895f,
    // Kr89
    82826.2479431f,
    // Kr90
    83759.5062953f,
    // Kr91
    84694.6481286f,
    // Kr92
    85628.6693745f,
    // Kr93
    86564.9299322f,
    // Kr94
    87499.3023513f,
    // Kr95
    88435.9010414f,
    // Kr96
    89370.4038697f,
    // Kr97
    90307.0118747f,
    // Rb71
    66103.7770539f,
    // Rb72
    67029.4586331f,
    // Rb73
    67952.8394218f,
    // Rb74
    68878.837709f,
    // Rb75
    69804.8350647f,
    // Rb76
    70733.0708007f,
    // Rb77
    71660.2204146f,
    // Rb78
    72589.6037513f,
    // Rb79
    73517.2377422f,
    // Rb80
    74447.3550963f,
    // Rb81
    75375.5656819f,
    // Rb82
    76306.32763f,
    // Rb83
    77234.9378266f,
    // Rb84
    78165.7547328f,
    // Rb85
    79094.8309559f,
    // Rb86
    80025.7454827f,
    // Rb87
    80955.3918734f,
    // Rb88
    81888.8751814f,
    // Rb89
    82821.2644496f,
    // Rb90
    83755.1143006f,
    // Rb91
    84688.2152303f,
    // Rb92
    85622.6817304f,
    // Rb93
    86556.3257211f,
    // Rb94
    87491.8941787f,
    // Rb95
    88426.1007919f,
    // Rb96
    89362.2197625f,
    // Rb97
    90296.5605109f,
    // Rb98
    91232.1159276f,
    // Rb99
    92167.075188f,
    // Rb100
    93102.7144392f,
    // Rb101
    94037.3104169f,
    // Rb102
    94974.4027989f,
    // Sr73
    67967.3707298f,
    // Sr74
    68889.8665992f,
    // Sr75
    69815.4084542f,
    // Sr76
    70739.1618406f,
    // Sr77
    71667.0696907f,
    // Sr78
    72593.3651245f,
    // Sr79
    73522.5565735f,
    // Sr80
    74449.2236734f,
    // Sr81
    75379.4956556f,
    // Sr82
    76306.5074083f,
    // Sr83
    77237.2134667f,
    // Sr84
    78164.8604984f,
    // Sr85
    79095.8963057f,
    // Sr86
    80023.9712659f,
    // Sr87
    80955.1085129f,
    // Sr88
    81883.561287f,
    // Sr89
    82816.7680344f,
    // Sr90
    83748.5273332f,
    // Sr91
    84682.3244616f,
    // Sr92
    85614.5823891f,
    // Sr93
    86548.8635219f,
    // Sr94
    87481.6039634f,
    // Sr95
    88416.8221792f,
    // Sr96
    89350.4792109f,
    // Sr97
    90286.1361604f,
    // Sr98
    91219.7931921f,
    // Sr99
    92155.8041094f,
    // Sr100
    93089.1891448f,
    // Sr101
    94025.4990717f,
    // Sr102
    94959.3219093f,
    // Sr103
    95896.3397717f,
    // Sr104
    96830.9823242f,
    // Y77
    71678.1172108f,
    // Y78
    72603.9105693f,
    // Y79
    73529.6759829f,
    // Y80
    74458.3662881f,
    // Y81
    75385.0073062f,
    // Y82
    76314.3217123f,
    // Y83
    77241.6799809f,
    // Y84
    78171.3483549f,
    // Y85
    79099.1509461f,
    // Y86
    80029.2114791f,
    // Y87
    80956.9701038f,
    // Y88
    81887.1839607f,
    // Y89
    82815.2729864f,
    // Y90
    83747.9812914f,
    // Y91
    84679.6166082f,
    // Y92
    85612.6420869f,
    // Y93
    86544.7276881f,
    // Y94
    87478.0959566f,
    // Y95
    88410.7357967f,
    // Y96
    89345.093312f,
    // Y97
    90278.6674407f,
    // Y98
    91213.9704225f,
    // Y99
    92147.7140831f,
    // Y100
    93082.1191046f,
    // Y101
    94015.9885169f,
    // Y102
    94950.5099751f,
    // Y103
    95885.1525276f,
    // Y104
    96820.8476684f,
    // Y105
    97755.7324093f,
    // Y106
    98692.0050764f,
    // Zr79
    73540.6769283f,
    // Zr80
    74464.1508664f,
    // Zr81
    75392.1704958f,
    // Zr82
    76318.327137f,
    // Zr83
    77247.5483938f,
    // Zr84
    78174.012428f,
    // Zr85
    79103.8484709f,
    // Zr86
    80030.6851028f,
    // Zr87
    80960.6394454f,
    // Zr88
    81887.8570583f,
    // Zr89
    82818.1057531f,
    // Zr90
    83745.7012732f,
    // Zr91
    84678.072191f,
    // Zr92
    85609.0028326f,
    // Zr93
    86541.8340948f,
    // Zr94
    87473.1793444f,
    // Zr95
    88406.282044f,
    // Zr96
    89337.9934639f,
    // Zr97
    90271.979313f,
    // Zr98
    91205.1454473f,
    // Zr99
    92140.146625f,
    // Zr100
    93072.8041635f,
    // Zr101
    94007.446716f,
    // Zr102
    94940.6547675f,
    // Zr103
    95875.5208786f,
    // Zr104
    96809.0456381f,
    // Zr105
    97744.5172203f,
    // Zr106
    98678.6753958f,
    // Zr107
    99614.780394f,
    // Zr108
    100549.4602062f,
    // Nb81
    75403.5626687f,
    // Nb82
    76329.542326f,
    // Nb83
    77255.0469213f,
    // Nb84
    78183.6254471f,
    // Nb85
    79109.8472929f,
    // Nb86
    80038.6680072f,
    // Nb87
    80965.8027172f,
    // Nb88
    81895.0612337f,
    // Nb89
    82822.4008724f,
    // Nb90
    83751.812154f,
    // Nb91
    84679.3259821f,
    // Nb92
    85611.0084326f,
    // Nb93
    86541.7427152f,
    // Nb94
    87474.0807513f,
    // Nb95
    88405.1572648f,
    // Nb96
    89337.829521f,
    // Nb97
    90269.320922f,
    // Nb98
    91202.8958891f,
    // Nb99
    92135.5888244f,
    // Nb100
    93069.4703461f,
    // Nb101
    94001.9620787f,
    // Nb102
    94936.0531867f,
    // Nb103
    95868.5719326f,
    // Nb104
    96803.1585954f,
    // Nb105
    97736.0219941f,
    // Nb106
    98671.4842613f,
    // Nb107
    99604.9531312f,
    // Nb108
    100540.8252559f,
    // Nb109
    101474.7598728f,
    // Nb110
    102410.9580204f,
    // Mo83
    77266.2621103f,
    // Mo84
    78189.6987887f,
    // Mo85
    79117.9326617f,
    // Mo86
    80043.9402638f,
    // Mo87
    80972.2952311f,
    // Mo88
    81898.7806897f,
    // Mo89
    82827.9721387f,
    // Mo90
    83754.3011062f,
    // Mo91
    84683.759894f,
    // Mo92
    85610.651484f,
    // Mo93
    86542.1474494f,
    // Mo94
    87472.0352834f,
    // Mo95
    88404.2316392f,
    // Mo96
    89334.6427865f,
    // Mo97
    90267.3870471f,
    // Mo98
    91198.3099573f,
    // Mo99
    92131.9500358f,
    // Mo100
    93063.2256097f,
    // Mo101
    93997.3931001f,
    // Mo102
    94928.8406278f,
    // Mo103
    95863.0388576f,
    // Mo104
    96795.0545967f,
    // Mo105
    97729.5387951f,
    // Mo106
    98662.1171566f,
    // Mo107
    99596.9236521f,
    // Mo108
    100530.1782783f,
    // Mo109
    101465.6126007f,
    // Mo110
    102398.8951718f,
    // Mo111
    103334.841816f,
    // Mo112
    104268.5062996f,
    // Mo113
    105204.8348564f,
    // Tc85
    79129.4366139f,
    // Tc86
    80055.285862f,
    // Tc87
    80980.8649768f,
    // Tc88
    81908.912551f,
    // Tc89
    82835.4790496f,
    // Tc90
    83763.2658055f,
    // Tc91
    84689.9813431f,
    // Tc92
    85618.5226092f,
    // Tc93
    86545.3480631f,
    // Tc94
    87476.290721f,
    // Tc95
    88405.9218352f,
    // Tc96
    89337.6162088f,
    // Tc97
    90267.7074811f,
    // Tc98
    91199.994285f,
    // Tc99
    92130.5928489f,
    // Tc100
    93063.3938375f,
    // Tc101
    93994.5678785f,
    // Tc102
    94927.8308882f,
    // Tc103
    95859.2933198f,
    // Tc104
    96792.8935304f,
    // Tc105
    97724.5925614f,
    // Tc106
    98658.5970404f,
    // Tc107
    99590.766476f,
    // Tc108
    100525.4276584f,
    // Tc109
    101457.992979f,
    // Tc110
    102392.9894992f,
    // Tc111
    103326.0298818f,
    // Tc112
    104261.4269445f,
    // Tc113
    105194.8678695f,
    // Tc114
    106130.6002701f,
    // Tc115
    107064.3299583f,
    // Ru87
    80992.6483772f,
    // Ru88
    81915.9825913f,
    // Ru89
    82843.4619541f,
    // Ru90
    83769.0596988f,
    // Ru91
    84697.3867212f,
    // Ru92
    85623.0496705f,
    // Ru93
    86551.684086f,
    // Ru94
    87477.877987f,
    // Ru95
    88408.4899644f,
    // Ru96
    89337.3619109f,
    // Ru97
    90268.8159591f,
    // Ru98
    91198.1974328f,
    // Ru99
    92130.2991488f,
    // Ru100
    93060.1914539f,
    // Ru101
    93992.954717f,
    // Ru102
    94923.3005666f,
    // Ru103
    95856.6336247f,
    // Ru104
    96787.2952508f,
    // Ru105
    97720.9504195f,
    // Ru106
    98652.0504999f,
    // Ru107
    99585.9506515f,
    // Ru108
    100517.7055723f,
    // Ru109
    101452.0034719f,
    // Ru110
    102384.2148247f,
    // Ru111
    103319.052991f,
    // Ru112
    104251.4692725f,
    // Ru113
    105186.6800364f,
    // Ru114
    106119.5341201f,
    // Ru115
    107055.0429621f,
    // Ru116
    107988.2603286f,
    // Ru117
    108924.0672487f,
    // Ru118
    109857.6478978f,
    // Rh89
    82855.8228808f,
    // Rh90
    83781.2529566f,
    // Rh91
    84706.8600163f,
    // Rh92
    85634.0971906f,
    // Rh93
    86559.7787698f,
    // Rh94
    87487.509636f,
    // Rh95
    88413.6010726f,
    // Rh96
    89343.8078501f,
    // Rh97
    90272.3416642f,
    // Rh98
    91203.2545143f,
    // Rh99
    92132.3416359f,
    // Rh100
    93063.8217659f,
    // Rh101
    93993.4966603f,
    // Rh102
    94925.6232472f,
    // Rh103
    95855.870079f,
    // Rh104
    96788.4363311f,
    // Rh105
    97719.0334046f,
    // Rh106
    98652.0113771f,
    // Rh107
    99583.0080617f,
    // Rh108
    100516.3455909f,
    // Rh109
    101447.8452822f,
    // Rh110
    102381.4017126f,
    // Rh111
    103313.5571758f,
    // Rh112
    104247.7991857f,
    // Rh113
    105180.0477983f,
    // Rh114
    106114.7369255f,
    // Rh115
    107047.4140254f,
    // Rh116
    107982.2521916f,
    // Rh117
    108915.2739443f,
    // Rh118
    109850.5685426f,
    // Rh119
    110783.8604286f,
    // Rh120
    111719.471735f,
    // Rh121
    112653.1082738f,
    // Pd91
    84718.904235f,
    // Pd92
    85641.9590008f,
    // Pd93
    86569.2520648f,
    // Pd94
    87494.0952993f,
    // Pd95
    88421.7889057f,
    // Pd96
    89347.2562413f,
    // Pd97
    90277.1295439f,
    // Pd98
    91205.12216f,
    // Pd99
    92135.7285485f,
    // Pd100
    93064.1831856f,
    // Pd101
    93995.4760853f,
    // Pd102
    94924.472852f,
    // Pd103
    95856.41314f,
    // Pd104
    96785.9958165f,
    // Pd105
    97718.4670562f,
    // Pd106
    98648.4698365f,
    // Pd107
    99581.4962467f,
    // Pd108
    100511.8408854f,
    // Pd109
    101445.2538656f,
    // Pd110
    102376.0009097f,
    // Pd111
    103309.8125695f,
    // Pd112
    104241.0020733f,
    // Pd113
    105175.1388244f,
    // Pd114
    106106.833198f,
    // Pd115
    107041.4152034f,
    // Pd116
    107973.3564229f,
    // Pd117
    108908.2784236f,
    // Pd118
    109840.8344293f,
    // Pd119
    110775.7750598f,
    // Pd120
    111708.5266793f,
    // Pd121
    112643.8864822f,
    // Pd122
    113576.889605f,
    // Pd123
    114512.5381711f,
    // Ag94
    87507.1455317f,
    // Ag95
    88431.8397271f,
    // Ag96
    89358.8626578f,
    // Ag97
    90284.1343796f,
    // Ag98
    91213.5419352f,
    // Ag99
    92141.1610221f,
    // Ag100
    93071.2299385f,
    // Ag101
    93999.6780552f,
    // Ag102
    94930.4269623f,
    // Ag103
    95859.1005005f,
    // Ag104
    96790.2741689f,
    // Ag105
    97719.8121337f,
    // Ag106
    98651.4347823f,
    // Ag107
    99581.4636444f,
    // Ag108
    100513.7597632f,
    // Ag109
    101444.1379357f,
    // Ag110
    102376.8932811f,
    // Ag111
    103307.6282158f,
    // Ag112
    104240.7142416f,
    // Ag113
    105171.8003496f,
    // Ag114
    106105.3828617f,
    // Ag115
    107036.8322524f,
    // Ag116
    107970.7482394f,
    // Ag117
    108902.5404199f,
    // Ag118
    109836.7358552f,
    // Ag119
    110769.2452862f,
    // Ag120
    111703.6456502f,
    // Ag121
    112636.1271363f,
    // Ag122
    113570.8535232f,
    // Ag123
    114503.8193863f,
    // Ag124
    115438.6948123f,
    // Ag125
    116372.0612178f,
    // Ag126
    117307.2440368f,
    // Ag127
    118240.9550952f,
    // Cd96
    89367.3299392f,
    // Cd97
    90294.3249251f,
    // Cd98
    91218.9632309f,
    // Cd99
    92148.0633934f,
    // Cd100
    93075.104954f,
    // Cd101
    94005.1552405f,
    // Cd102
    94933.0165159f,
    // Cd103
    95863.2428548f,
    // Cd104
    96791.4105917f,
    // Cd105
    97722.5507264f,
    // Cd106
    98651.2410315f,
    // Cd107
    99582.880447f,
    // Cd108
    100512.1100872f,
    // Cd109
    101444.3521793f,
    // Cd110
    102374.0019234f,
    // Cd111
    103306.5914629f,
    // Cd112
    104236.7583724f,
    // Cd113
    105169.7835717f,
    // Cd114
    106100.306312f,
    // Cd115
    107033.7313085f,
    // Cd116
    107964.5957209f,
    // Cd117
    108898.3840933f,
    // Cd118
    109829.5950214f,
    // Cd119
    110763.8891951f,
    // Cd120
    111695.3190244f,
    // Cd121
    112629.7277718f,
    // Cd122
    113561.7062511f,
    // Cd123
    114496.4605829f,
    // Cd124
    115428.5601564f,
    // Cd125
    116363.4076376f,
    // Cd126
    117295.9263835f,
    // Cd127
    118231.2209818f,
    // Cd128
    119163.9539713f,
    // Cd129
    120099.6397972f,
    // Cd130
    121032.7360694f,
    // In98
    91232.6189344f,
    // In99
    92157.0057368f,
    // In100
    93085.2768696f,
    // In101
    94012.495414f,
    // In102
    94942.2662523f,
    // In103
    95869.292909f,
    // In104
    96799.3208397f,
    // In105
    97727.3991532f,
    // In106
    98657.7642847f,
    // In107
    99586.3064823f,
    // In108
    100517.26777f,
    // In109
    101446.3716586f,
    // In110
    102377.8797334f,
    // In111
    103307.4568209f,
    // In112
    104239.3440138f,
    // In113
    105169.4669568f,
    // In114
    106101.7584182f,
    // In115
    107032.2846982f,
    // In116
    107965.0661254f,
    // In117
    108895.8671962f,
    // In118
    109829.0743162f,
    // In119
    110760.0942881f,
    // In120
    111693.557569f,
    // In121
    112624.9482756f,
    // In122
    113558.7068401f,
    // In123
    114490.3490501f,
    // In124
    115424.3963778f,
    // In125
    116356.2817077f,
    // In126
    117290.4398832f,
    // In127
    118222.7537004f,
    // In128
    119156.8839311f,
    // In129
    120089.7659597f,
    // In130
    121024.2315283f,
    // In131
    121957.5140993f,
    // In132
    122894.7368905f,
    // In133
    123831.2796909f,
    // In134
    124768.660836f,
    // Sn100
    93092.5425236f,
    // Sn101
    94021.344608f,
    // Sn102
    94947.6502882f,
    // Sn103
    95876.9460645f,
    // Sn104
    96803.8385861f,
    // Sn105
    97733.6559991f,
    // Sn106
    98660.949063f,
    // Sn107
    99591.3160576f,
    // Sn108
    100519.3636318f,
    // Sn109
    101450.2215237f,
    // Sn110
    102378.5168753f,
    // Sn111
    103309.9010614f,
    // Sn112
    104238.68079f,
    // Sn113
    105170.5027783f,
    // Sn114
    106099.7696783f,
    // Sn115
    107031.7891433f,
    // Sn116
    107961.7909922f,
    // Sn117
    108894.4122024f,
    // Sn118
    109824.6506507f,
    // Sn119
    110757.7310876f,
    // Sn120
    111688.1889959f,
    // Sn121
    112621.5836257f,
    // Sn122
    113552.3355136f,
    // Sn123
    114485.9550992f,
    // Sn124
    115417.0325443f,
    // Sn125
    116350.8649763f,
    // Sn126
    117282.2371462f,
    // Sn127
    118216.2434881f,
    // Sn128
    119147.9089854f,
    // Sn129
    120082.1090782f,
    // Sn130
    121013.9850932f,
    // Sn131
    121948.3388824f,
    // Sn132
    122880.600536f,
    // Sn133
    123817.7450816f,
    // Sn134
    124753.5706315f,
    // Sn135
    125690.9052019f,
    // Sn136
    126626.6934921f,
    // Sn137
    127564.1957315f,
    // Sb103
    95888.1146788f,
    // Sb104
    96816.0411588f,
    // Sb105
    97743.1013493f,
    // Sb106
    98672.015213f,
    // Sb107
    99599.2151275f,
    // Sb108
    100528.8555567f,
    // Sb109
    101456.6013268f,
    // Sb110
    102386.8136933f,
    // Sb111
    103315.0009916f,
    // Sb112
    104245.7359263f,
    // Sb113
    105174.419711f,
    // Sb114
    106105.654858f,
    // Sb115
    107034.8192936f,
    // Sb116
    107966.4978319f,
    // Sb117
    108896.1690003f,
    // Sb118
    109828.3076966f,
    // Sb119
    110758.3244493f,
    // Sb120
    111690.8692771f,
    // Sb121
    112621.1934229f,
    // Sb122
    113553.9519353f,
    // Sb123
    114484.5520828f,
    // Sb124
    115417.6500318f,
    // Sb125
    116348.501869f,
    // Sb126
    117281.8608225f,
    // Sb127
    118213.0428744f,
    // Sb128
    119146.6347015f,
    // Sb129
    120078.1129685f,
    // Sb130
    121011.8389307f,
    // Sb131
    121943.7093567f,
    // Sb132
    122877.4977291f,
    // Sb133
    123809.7621771f,
    // Sb134
    124746.2025132f,
    // Sb135
    125682.0001183f,
    // Sb136
    126618.6081233f,
    // Sb137
    127554.4336733f,
    // Sb138
    128491.1907174f,
    // Sb139
    129427.1094167f,
    // Te106
    98680.3427703f,
    // Te107
    99609.3590983f,
    // Te108
    100535.6834084f,
    // Te109
    101465.2865778f,
    // Te110
    102392.076635f,
    // Te111
    103322.36911f,
    // Te112
    104250.0813463f,
    // Te113
    105180.5228603f,
    // Te114
    106108.4120805f,
    // Te115
    107039.4590658f,
    // Te116
    107968.0096468f,
    // Te117
    108899.7030889f,
    // Te118
    109828.5806244f,
    // Te119
    110760.6177878f,
    // Te120
    111689.8874823f,
    // Te121
    112622.2292443f,
    // Te122
    113551.9694364f,
    // Te123
    114484.6054574f,
    // Te124
    115414.7456331f,
    // Te125
    116347.7349699f,
    // Te126
    117278.1865441f,
    // Te127
    118211.4611974f,
    // Te128
    119142.2514629f,
    // Te129
    120075.7339325f,
    // Te130
    121006.8804013f,
    // Te131
    121940.5161018f,
    // Te132
    122872.0121603f,
    // Te133
    123805.7567525f,
    // Te134
    124737.8097513f,
    // Te135
    125673.8774897f,
    // Te136
    126608.7715456f,
    // Te137
    127545.1280472f,
    // Te138
    128480.2549766f,
    // Te139
    129416.8816115f,
    // Te140
    130352.0737454f,
    // Te141
    131288.8680493f,
    // Te142
    132224.1905924f,
    // I108
    100548.5380271f,
    // I109
    101475.2815095f,
    // I110
    102403.9997595f,
    // I111
    103330.9015959f,
    // I112
    104260.2439469f,
    // I113
    105187.7046799f,
    // I114
    106117.5314078f,
    // I115
    107045.3647384f,
    // I116
    107975.7596777f,
    // I117
    108904.3754633f,
    // I118
    109835.6180623f,
    // I119
    110764.1313836f,
    // I120
    111695.5025287f,
    // I121
    112624.4983639f,
    // I122
    113556.202984f,
    // I123
    114485.8396871f,
    // I124
    115417.905168f,
    // I125
    116347.9207098f,
    // I126
    117280.3415557f,
    // I127
    118210.7635083f,
    // I128
    119143.5030183f,
    // I129
    120074.2351585f,
    // I130
    121007.3006915f,
    // I131
    121938.2826584f,
    // I132
    122871.5194f,
    // I133
    123802.83745f,
    // I134
    124736.2606766f,
    // I135
    125667.9159275f,
    // I136
    126603.7042177f,
    // I137
    127538.1912106f,
    // I138
    128473.8835569f,
    // I139
    129408.8335024f,
    // I140
    130345.0968546f,
    // I141
    131279.9629657f,
    // I142
    132216.4405615f,
    // I143
    133151.5581759f,
    // I144
    134088.2127556f,
    // Xe110
    102412.6347098f,
    // Xe111
    103341.474054f,
    // Xe112
    104267.4164515f,
    // Xe113
    105196.7774324f,
    // Xe114
    106123.3998207f,
    // Xe115
    107053.3942175f,
    // Xe116
    107980.4171482f,
    // Xe117
    108910.8120876f,
    // Xe118
    109838.5895285f,
    // Xe119
    110769.1335069f,
    // Xe120
    111697.4605293f,
    // Xe121
    112628.2429702f,
    // Xe122
    113557.0953553f,
    // Xe123
    114488.5158697f,
    // Xe124
    115417.6111885f,
    // Xe125
    116349.5732735f,
    // Xe126
    117279.0840386f,
    // Xe127
    118211.4267321f,
    // Xe128
    119141.3842418f,
    // Xe129
    120074.0418735f,
    // Xe130
    121004.351488f,
    // Xe131
    121937.3117621f,
    // Xe132
    122867.9419969f,
    // Xe133
    123801.0676112f,
    // Xe134
    124732.0852543f,
    // Xe135
    125665.2676898f,
    // Xe136
    126596.7739016f,
    // Xe137
    127532.3134828f,
    // Xe138
    128466.0683214f,
    // Xe139
    129402.030801f,
    // Xe140
    130336.1824561f,
    // Xe141
    131272.3433439f,
    // Xe142
    132206.6785033f,
    // Xe143
    133143.0070601f,
    // Xe144
    134077.6123528f,
    // Xe145
    135014.1737831f,
    // Xe146
    135949.049209f,
    // Xe147
    136885.8621428f,
    // Cs112
    104281.0721551f,
    // Cs113
    105207.1729066f,
    // Cs114
    106135.7607474f,
    // Cs115
    107062.1502621f,
    // Cs116
    107990.8219374f,
    // Cs117
    108918.3385599f,
    // Cs118
    109847.8904971f,
    // Cs119
    110775.4872282f,
    // Cs120
    111705.404311f,
    // Cs121
    112633.643773f,
    // Cs122
    113564.1486287f,
    // Cs123
    114492.7252915f,
    // Cs124
    115423.5263623f,
    // Cs125
    116352.6721681f,
    // Cs126
    117283.9082466f,
    // Cs127
    118213.5114159f,
    // Cs128
    119145.3129114f,
    // Cs129
    120075.2374462f,
    // Cs130
    121007.3304993f,
    // Cs131
    121937.66396f,
    // Cs132
    122870.0616117f,
    // Cs133
    123800.6400554f,
    // Cs134
    124733.3134293f,
    // Cs135
    125664.1172945f,
    // Cs136
    126596.8540101f,
    // Cs137
    127528.1413208f,
    // Cs138
    128463.2934005f,
    // Cs139
    129396.9737195f,
    // Cs140
    130332.1183473f,
    // Cs141
    131266.1898939f,
    // Cs142
    132201.6409832f,
    // Cs143
    133135.9649647f,
    // Cs144
    134071.8370893f,
    // Cs145
    135006.4610119f,
    // Cs146
    135942.3983412f,
    // Cs147
    136877.3389717f,
    // Cs148
    137813.5278044f,
    // Cs149
    138748.5802142f,
    // Cs150
    139684.9646607f,
    // Cs151
    140620.2126843f,
    // Ba114
    106144.6285712f,
    // Ba115
    107073.1139477f,
    // Ba116
    107998.9911406f,
    // Ba117
    108927.8584296f,
    // Ba118
    109854.303834f,
    // Ba119
    110783.5716655f,
    // Ba120
    111710.4082974f,
    // Ba121
    112640.4492689f,
    // Ba122
    113568.0031513f,
    // Ba123
    114498.183847f,
    // Ba124
    115426.1736685f,
    // Ba125
    116357.2318317f,
    // Ba126
    117285.58121f,
    // Ba127
    118216.9598071f,
    // Ba128
    119145.8354796f,
    // Ba129
    120077.6695773f,
    // Ba130
    121006.9616276f,
    // Ba131
    121939.0341878f,
    // Ba132
    122868.7817388f,
    // Ba133
    123801.1570346f,
    // Ba134
    124731.2548273f,
    // Ba135
    125663.8480927f,
    // Ba136
    126594.3054422f,
    // Ba137
    127526.9648437f,
    // Ba138
    128457.9186795f,
    // Ba139
    129392.7605717f,
    // Ba140
    130325.8978297f,
    // Ba141
    131260.9381301f,
    // Ba142
    132194.3343435f,
    // Ba143
    133129.7118448f,
    // Ba144
    134063.3698079f,
    // Ba145
    134998.5712568f,
    // Ba146
    135933.0368254f,
    // Ba147
    136868.1451249f,
    // Ba148
    137803.0764405f,
    // Ba149
    138739.0230847f,
    // Ba150
    139673.4607085f,
    // Ba151
    140609.6868009f,
    // Ba152
    141544.4038729f,
    // Ba153
    142480.9746181f,
    // La117
    108938.2445889f,
    // La118
    109866.5343516f,
    // La119
    110792.8307169f,
    // La120
    111721.6048565f,
    // La121
    112648.3855987f,
    // La122
    113577.7372646f,
    // La123
    114505.0675884f,
    // La124
    115434.9688359f,
    // La125
    116362.867371f,
    // La126
    117293.1505311f,
    // La127
    118221.6545374f,
    // La128
    119152.4872789f,
    // La129
    120081.3918277f,
    // La130
    121012.5599072f,
    // La131
    121941.9954076f,
    // La132
    122873.48951f,
    // La133
    123803.3907575f,
    // La134
    124734.9686943f,
    // La135
    125665.0478571f,
    // La136
    126597.174444f,
    // La137
    127527.5693834f,
    // La138
    128459.6568475f,
    // La139
    129390.4439459f,
    // La140
    130324.8489673f,
    // La141
    131257.725407f,
    // La142
    132192.1229765f,
    // La143
    133125.4660946f,
    // La144
    134060.2493027f,
    // La145
    134993.652968f,
    // La146
    135928.9289364f,
    // La147
    136862.3978063f,
    // La148
    137797.9625379f,
    // La149
    138731.4872975f,
    // La150
    139666.8936751f,
    // La151
    140601.1729448f,
    // La152
    141536.9053454f,
    // La153
    142471.5106381f,
    // La154
    143407.6156362f,
    // La155
    144342.5842116f,
    // Ce119
    110803.7944024f,
    // Ce120
    111729.5877609f,
    // Ce121
    112658.3153258f,
    // Ce122
    113584.5371716f,
    // Ce123
    114513.7025387f,
    // Ce124
    115440.5484855f,
    // Ce125
    116370.1982296f,
    // Ce126
    117297.5564982f,
    // Ce127
    118227.7930835f,
    // Ce128
    119155.6729888f,
    // Ce129
    120086.4405258f,
    // Ce130
    121014.7675482f,
    // Ce131
    121946.0101472f,
    // Ce132
    122874.7749718f,
    // Ce133
    123806.3249639f,
    // Ce134
    124735.4717011f,
    // Ce135
    125667.0738568f,
    // Ce136
    126596.699382f,
    // Ce137
    127528.7896406f,
    // Ce138
    128458.6126426f,
    // Ce139
    129390.7224626f,
    // Ce140
    130321.0866626f,
    // Ce141
    131255.2234138f,
    // Ce142
    132187.620134f,
    // Ce143
    133122.0400593f,
    // Ce144
    134054.7097073f,
    // Ce145
    134989.545079f,
    // Ce146
    135922.3991628f,
    // Ce147
    136857.4515726f,
    // Ce148
    137790.6968839f,
    // Ce149
    138725.8238133f,
    // Ce150
    139659.1250143f,
    // Ce151
    140594.1681092f,
    // Ce152
    141527.8419078f,
    // Ce153
    142463.2482854f,
    // Ce154
    143397.2946816f,
    // Ce155
    144333.1854361f,
    // Ce156
    145267.6789495f,
    // Ce157
    146203.905042f,
    // Pr121
    112669.2044919f,
    // Pr122
    113597.2427511f,
    // Pr123
    114523.4366521f,
    // Pr124
    115452.1362722f,
    // Pr125
    116378.8518098f,
    // Pr126
    117307.9985471f,
    // Pr127
    118235.3195559f,
    // Pr128
    119164.9227252f,
    // Pr129
    120092.7467408f,
    // Pr130
    121022.8622319f,
    // Pr131
    121951.2637739f,
    // Pr132
    122881.8822718f,
    // Pr133
    123810.6564114f,
    // Pr134
    124741.656822f,
    // Pr135
    125670.7942443f,
    // Pr136
    126601.8319145f,
    // Pr137
    127531.4909735f,
    // Pr138
    128463.049349f,
    // Pr139
    129392.8509266f,
    // Pr140
    130324.4745067f,
    // Pr141
    131254.643093f,
    // Pr142
    132188.3653292f,
    // Pr143
    133120.5785451f,
    // Pr144
    134054.3911363f,
    // Pr145
    134987.0086206f,
    // Pr146
    135921.3745193f,
    // Pr147
    136854.1633984f,
    // Pr148
    137788.638282f,
    // Pr149
    138721.6330213f,
    // Pr150
    139656.1162883f,
    // Pr151
    140588.7561284f,
    // Pr152
    141523.3893659f,
    // Pr153
    142456.7930312f,
    // Pr154
    143391.7709216f,
    // Pr155
    144325.6869086f,
    // Pr156
    145261.0280816f,
    // Pr157
    146195.363241f,
    // Pr158
    147131.1515312f,
    // Pr159
    148065.8592883f,
    // Nd126
    117315.2269413f,
    // Nd127
    118244.3271038f,
    // Nd128
    119171.0612713f,
    // Nd129
    120100.5619764f,
    // Nd130
    121027.8923001f,
    // Nd131
    121957.8214924f,
    // Nd132
    122885.6082483f,
    // Nd133
    123816.254691f,
    // Nd134
    124744.4326744f,
    // Nd135
    125675.5448642f,
    // Nd136
    126604.0395556f,
    // Nd137
    127535.1796902f,
    // Nd138
    128464.1494436f,
    // Nd139
    129395.634231f,
    // Nd140
    130324.6971338f,
    // Nd141
    131256.4660269f,
    // Nd142
    132186.2033314f,
    // Nd143
    133119.645188f,
    // Nd144
    134051.3935883f,
    // Nd145
    134985.203385f,
    // Nd146
    135917.2032887f,
    // Nd147
    136851.4769695f,
    // Nd148
    137783.7097467f,
    // Nd149
    138718.2358624f,
    // Nd150
    139650.4220649f,
    // Nd151
    140584.6528969f,
    // Nd152
    141516.9434268f,
    // Nd153
    142451.2459839f,
    // Nd154
    143384.4028032f,
    // Nd155
    144318.831112f,
    // Nd156
    145252.7191543f,
    // Nd157
    146188.0044376f,
    // Nd158
    147121.9204247f,
    // Nd159
    148057.6248804f,
    // Nd160
    148991.9134651f,
    // Nd161
    149928.0091484f,
    // Pm128
    119183.0496004f,
    // Pm129
    120109.7930829f,
    // Pm130
    121038.7628363f,
    // Pm131
    121965.9254911f,
    // Pm132
    122895.5100306f,
    // Pm133
    123823.2502117f,
    // Pm134
    124753.5985764f,
    // Pm135
    125681.4877966f,
    // Pm136
    126611.8920508f,
    // Pm137
    127540.8338594f,
    // Pm138
    128471.1542792f,
    // Pm139
    129400.1426625f,
    // Pm140
    130330.7425305f,
    // Pm141
    131260.1938663f,
    // Pm142
    132191.0759771f,
    // Pm143
    133120.6865984f,
    // Pm144
    134053.725118f,
    // Pm145
    134985.3663965f,
    // Pm146
    135918.6750494f,
    // Pm147
    136850.5808721f,
    // Pm148
    137784.2490817f,
    // Pm149
    138716.5452006f,
    // Pm150
    139650.5077623f,
    // Pm151
    140582.2105194f,
    // Pm152
    141515.8349488f,
    // Pm153
    142447.909372f,
    // Pm154
    143381.6735255f,
    // Pm155
    144314.6114437f,
    // Pm156
    145248.8627687f,
    // Pm157
    146182.3502684f,
    // Pm158
    147117.0952852f,
    // Pm159
    148050.8622332f,
    // Pm160
    148985.9519029f,
    // Pm161
    149920.1193933f,
    // Pm162
    150855.7400146f,
    // Pm163
    151790.2428429f,
    // Sm130
    121046.382458f,
    // Sm131
    121975.3242666f,
    // Sm132
    122902.0956939f,
    // Sm133
    123831.6429736f,
    // Sm134
    124758.7497387f,
    // Sm135
    125688.688246f,
    // Sm136
    126616.4097972f,
    // Sm137
    127546.739532f,
    // Sm138
    128474.9640901f,
    // Sm139
    129405.3050028f,
    // Sm140
    130333.7149282f,
    // Sm141
    131264.7227906f,
    // Sm142
    132193.1653184f,
    // Sm143
    133124.1294006f,
    // Sm144
    134053.174605f,
    // Sm145
    134985.9830455f,
    // Sm146
    135917.1334266f,
    // Sm147
    136850.3563821f,
    // Sm148
    137781.7806224f,
    // Sm149
    138715.4749138f,
    // Sm150
    139647.0537822f,
    // Sm151
    140581.0228644f,
    // Sm152
    141512.330668f,
    // Sm153
    142446.0286854f,
    // Sm154
    143377.6261836f,
    // Sm155
    144311.3847482f,
    // Sm156
    145243.7078803f,
    // Sm157
    146177.832522f,
    // Sm158
    147110.8542748f,
    // Sm159
    148045.3384732f,
    // Sm160
    148978.6396741f,
    // Sm161
    149913.5709898f,
    // Sm162
    150847.2913631f,
    // Sm163
    151782.641851f,
    // Sm164
    152716.8559162f,
    // Sm165
    153652.7280409f,
    // Eu132
    122914.5218252f,
    // Eu133
    123841.1162686f,
    // Eu134
    124770.2071162f,
    // Eu135
    125697.4163457f,
    // Eu136
    126626.8425312f,
    // Eu137
    127554.3405239f,
    // Eu138
    128484.1951966f,
    // Eu139
    129412.3266053f,
    // Eu140
    130342.1812781f,
    // Eu141
    131270.7039143f,
    // Eu142
    132200.8100905f,
    // Eu143
    133129.4044517f,
    // Eu144
    134059.4892035f,
    // Eu145
    134988.6424612f,
    // Eu146
    135921.0112366f,
    // Eu147
    136852.0777832f,
    // Eu148
    137784.8880867f,
    // Eu149
    138716.1698084f,
    // Eu150
    139649.3145184f,
    // Eu151
    140580.9464819f,
    // Eu152
    141514.2048341f,
    // Eu153
    142445.2201485f,
    // Eu154
    143378.3434341f,
    // Eu155
    144309.757428f,
    // Eu156
    145242.9859724f,
    // Eu157
    146175.1023128f,
    // Eu158
    147108.8515624f,
    // Eu159
    148041.5044435f,
    // Eu160
    148975.6868378f,
    // Eu161
    149908.7737951f,
    // Eu162
    150843.3977177f,
    // Eu163
    151776.9131623f,
    // Eu164
    152711.9283124f,
    // Eu165
    153645.9653937f,
    // Eu166
    154581.418346f,
    // Eu167
    155515.7814502f,
    // Gd136
    126633.8939415f,
    // Gd137
    127563.1338282f,
    // Gd138
    128490.2685382f,
    // Gd139
    129420.0021167f,
    // Gd140
    130347.6491485f,
    // Gd141
    131277.5224511f,
    // Gd142
    132205.309207f,
    // Gd143
    133135.4153831f,
    // Gd144
    134063.2300838f,
    // Gd145
    134993.6995427f,
    // Gd146
    135922.0405375f,
    // Gd147
    136854.2649313f,
    // Gd148
    137784.847101f,
    // Gd149
    138717.4832151f,
    // Gd150
    139648.34297f,
    // Gd151
    140581.4103659f,
    // Gd152
    141512.3865576f,
    // Gd153
    142445.7045254f,
    // Gd154
    143376.375187f,
    // Gd155
    144309.5059246f,
    // Gd156
    145240.5352114f,
    // Gd157
    146173.7404684f,
    // Gd158
    147105.368706f,
    // Gd159
    148038.9903409f,
    // Gd160
    148971.1048184f,
    // Gd161
    149905.0347778f,
    // Gd162
    150837.7537949f,
    // Gd163
    151772.0507631f,
    // Gd164
    152705.2867594f,
    // Gd165
    153640.0597211f,
    // Gd166
    154573.6217404f,
    // Gd167
    155508.8138743f,
    // Gd168
    156442.9068453f,
    // Gd169
    157378.6019861f,
    // Tb138
    128502.2848121f,
    // Tb139
    129429.270483f,
    // Tb140
    130358.4451651f,
    // Tb141
    131285.8593233f,
    // Tb142
    132215.2109893f,
    // Tb143
    133142.8766509f,
    // Tb144
    134072.3028364f,
    // Tb145
    135000.3969853f,
    // Tb146
    135930.3075477f,
    // Tb147
    136858.8739641f,
    // Tb148
    137790.6130495f,
    // Tb149
    138721.1216311f,
    // Tb150
    139652.999509f,
    // Tb151
    140583.9757007f,
    // Tb152
    141516.3752154f,
    // Tb153
    142447.274093f,
    // Tb154
    143379.9409465f,
    // Tb155
    144310.3265709f,
    // Tb156
    145242.9794519f,
    // Tb157
    146173.8000841f,
    // Tb158
    147106.5880318f,
    // Tb159
    148038.019724f,
    // Tb160
    148971.2100772f,
    // Tb161
    149903.0786402f,
    // Tb162
    150836.3556223f,
    // Tb163
    151768.9339838f,
    // Tb164
    152702.9487092f,
    // Tb165
    153635.8679976f,
    // Tb166
    154570.3149363f,
    // Tb167
    155503.6720269f,
    // Tb168
    156438.5101931f,
    // Tb169
    157372.4075503f,
    // Tb170
    158307.6555739f,
    // Tb171
    159241.9907333f,
    // Dy140
    130366.1299915f,
    // Dy141
    131295.2022092f,
    // Dy142
    132222.1133606f,
    // Dy143
    133151.3346174f,
    // Dy144
    134078.3948078f,
    // Dy145
    135007.9141427f,
    // Dy146
    135935.468025f,
    // Dy147
    136865.2481783f,
    // Dy148
    137793.2957525f,
    // Dy149
    138724.9333049f,
    // Dy150
    139654.7935667f,
    // Dy151
    140586.8465655f,
    // Dy152
    141516.9750976f,
    // Dy153
    142449.4444743f,
    // Dy154
    143379.691306f,
    // Dy155
    144312.4215011f,
    // Dy156
    145242.5453757f,
    // Dy157
    146175.1414356f,
    // Dy158
    147105.6518802f,
    // Dy159
    148038.3858012f,
    // Dy160
    148969.3750338f,
    // Dy161
    149902.48621f,
    // Dy162
    150833.8545606f,
    // Dy163
    151767.1492411f,
    // Dy164
    152699.0559954f,
    // Dy165
    153632.9058464f,
    // Dy166
    154565.4273867f,
    // Dy167
    155499.5734528f,
    // Dy168
    156432.5393159f,
    // Dy169
    157366.8931052f,
    // Dy170
    158300.5948486f,
    // Dy171
    159235.6379435f,
    // Dy172
    160169.5818754f,
    // Dy173
    161105.1093472f,
    // Ho142
    132234.7723654f,
    // Ho143
    133161.4506433f,
    // Ho144
    134090.1036887f,
    // Ho145
    135017.1638791f,
    // Ho146
    135946.0684279f,
    // Ho147
    136873.5943654f,
    // Ho148
    137802.694528f,
    // Ho149
    138730.9470309f,
    // Ho150
    139662.0312759f,
    // Ho151
    140591.9707146f,
    // Ho152
    141523.5197751f,
    // Ho153
    142453.5747191f,
    // Ho154
    143385.4423506f,
    // Ho155
    144315.5233765f,
    // Ho156
    145247.6052516f,
    // Ho157
    146177.683483f,
    // Ho158
    147109.8855209f,
    // Ho159
    148040.2236391f,
    // Ho160
    148972.665071f,
    // Ho161
    149903.3450475f,
    // Ho162
    150835.9942026f,
    // Ho163
    151767.1511041f,
    // Ho164
    152700.0433791f,
    // Ho165
    153631.619453f,
    // Ho166
    154564.9411468f,
    // Ho167
    155497.2223617f,
    // Ho168
    156430.9278311f,
    // Ho169
    157363.6962174f,
    // Ho170
    158297.7444766f,
    // Ho171
    159230.9618431f,
    // Ho172
    160165.5857657f,
    // Ho173
    161099.3806585f,
    // Ho174
    162034.4703281f,
    // Ho175
    162968.6657634f,
    // Er144
    134098.4405609f,
    // Er145
    135027.0190867f,
    // Er146
    135953.5390106f,
    // Er147
    136882.4156146f,
    // Er148
    137809.3733407f,
    // Er149
    138738.7529515f,
    // Er150
    139666.1391648f,
    // Er151
    140597.353819f,
    // Er152
    141526.6309654f,
    // Er153
    142458.1371772f,
    // Er154
    143387.4739393f,
    // Er155
    144319.3620637f,
    // Er156
    145248.8255089f,
    // Er157
    146181.1859008f,
    // Er158
    147110.7797552f,
    // Er159
    148042.9920396f,
    // Er160
    148972.9948199f,
    // Er161
    149905.3468283f,
    // Er162
    150835.698919f,
    // Er163
    151768.3611149f,
    // Er164
    152699.0802142f,
    // Er165
    153631.9957766f,
    // Er166
    154563.0865421f,
    // Er167
    155496.2154166f,
    // Er168
    156428.0103916f,
    // Er169
    157361.5724109f,
    // Er170
    158293.8787761f,
    // Er171
    159227.7630924f,
    // Er172
    160160.4923559f,
    // Er173
    161094.8256523f,
    // Er174
    162028.1268533f,
    // Er175
    162962.9650195f,
    // Er176
    163896.657448f,
    // Er177
    164831.9520463f,
    // Tm146
    135966.9338958f,
    // Tm147
    136893.3793002f,
    // Tm148
    137821.5852284f,
    // Tm149
    138748.5150096f,
    // Tm150
    139677.2332596f,
    // Tm151
    140604.777827f,
    // Tm152
    141535.219341f,
    // Tm153
    142464.5970888f,
    // Tm154
    143395.5248428f,
    // Tm155
    144324.9435763f,
    // Tm156
    145256.2681468f,
    // Tm157
    146185.6663874f,
    // Tm158
    147117.3840484f,
    // Tm159
    148046.8381787f,
    // Tm160
    148978.5930994f,
    // Tm161
    149908.5129768f,
    // Tm162
    150840.5380308f,
    // Tm163
    151770.800698f,
    // Tm164
    152703.0427902f,
    // Tm165
    153633.5877f,
    // Tm166
    154566.1260073f,
    // Tm167
    155496.9643379f,
    // Tm168
    156429.688944f,
    // Tm169
    157361.2212376f,
    // Tm170
    158294.1936211f,
    // Tm171
    159226.2727018f,
    // Tm172
    160159.6018476f,
    // Tm173
    161092.2174689f,
    // Tm174
    162026.0961961f,
    // Tm175
    162959.1458937f,
    // Tm176
    163893.5835174f,
    // Tm177
    164826.9871827f,
    // Tm178
    165761.8346639f,
    // Tm179
    166695.8438003f,
    // Yb148
    137830.164289f,
    // Yb149
    138758.6030908f,
    // Yb150
    139684.9832905f,
    // Yb151
    140613.9250991f,
    // Yb152
    141540.6872114f,
    // Yb153
    142471.2870795f,
    // Yb154
    143400.0146444f,
    // Yb155
    144331.0895744f,
    // Yb156
    145259.8450841f,
    // Yb157
    146191.1622026f,
    // Yb158
    147120.0462586f,
    // Yb159
    148051.8123572f,
    // Yb160
    148980.8938899f,
    // Yb161
    149912.6581256f,
    // Yb162
    150842.1960903f,
    // Yb163
    151774.1745696f,
    // Yb164
    152704.0385573f,
    // Yb165
    153636.3505116f,
    // Yb166
    154566.4306059f,
    // Yb167
    155498.9186125f,
    // Yb168
    156429.4318516f,
    // Yb169
    157362.1303758f,
    // Yb170
    158293.2257987f,
    // Yb171
    159226.1758264f,
    // Yb172
    160157.721813f,
    // Yb173
    161090.9197113f,
    // Yb174
    162023.0204958f,
    // Yb175
    162956.7635975f,
    // Yb176
    163889.4644505f,
    // Yb177
    164823.4633405f,
    // Yb178
    165756.2484937f,
    // Yb179
    166691.0279758f,
    // Yb180
    167624.5341055f,
    // Yb181
    168559.5865153f,
    // Lu150
    139698.657624f,
    // Lu151
    140625.0098789f,
    // Lu152
    141553.2064922f,
    // Lu153
    142480.1176436f,
    // Lu154
    143410.1306703f,
    // Lu155
    144338.9513846f,
    // Lu156
    145269.2159148f,
    // Lu157
    146198.0943818f,
    // Lu158
    147128.7203316f,
    // Lu159
    148057.8391241f,
    // Lu160
    148988.77433f,
    // Lu161
    149917.958327f,
    // Lu162
    150849.1543513f,
    // Lu163
    151778.7668356f,
    // Lu164
    152710.2795678f,
    // Lu165
    153640.2739647f,
    // Lu166
    154571.9077912f,
    // Lu167
    155502.0512271f,
    // Lu168
    156433.9086122f,
    // Lu169
    157364.4237143f,
    // Lu170
    158296.6844363f,
    // Lu171
    159227.655039f,
    // Lu172
    160160.2408525f,
    // Lu173
    161091.5905733f,
    // Lu174
    162024.3948222f,
    // Lu175
    162956.2935656f,
    // Lu176
    163889.5710134f,
    // Lu177
    164822.0642364f,
    // Lu178
    165755.6038998f,
    // Lu179
    166688.3769436f,
    // Lu180
    167622.2519449f,
    // Lu181
    168555.69287f,
    // Lu182
    169490.2050133f,
    // Lu183
    170423.8974417f,
    // Lu184
    171358.7449229f,
    // Hf154
    143416.7908532f,
    // Hf155
    144346.8970293f,
    // Hf156
    145275.1215874f,
    // Hf157
    146205.5724164f,
    // Hf158
    147133.8249193f,
    // Hf159
    148064.7135505f,
    // Hf160
    148993.1430373f,
    // Hf161
    149924.2831719f,
    // Hf162
    150852.8644923f,
    // Hf163
    151784.225391f,
    // Hf164
    152713.260349f,
    // Hf165
    153644.8662306f,
    // Hf166
    154574.2272115f,
    // Hf167
    155506.0473368f,
    // Hf168
    156435.7063959f,
    // Hf169
    157367.6941901f,
    // Hf170
    158297.7817364f,
    // Hf171
    159230.0582938f,
    // Hf172
    160160.5929573f,
    // Hf173
    161093.1955377f,
    // Hf174
    162024.1214286f,
    // Hf175
    162956.9783069f,
    // Hf176
    163888.3781421f,
    // Hf177
    164821.565887f,
    // Hf178
    165753.5049642f,
    // Hf179
    166686.9714122f,
    // Hf180
    167619.1489518f,
    // Hf181
    168553.0186436f,
    // Hf182
    169485.8670452f,
    // Hf183
    170420.1342056f,
    // Hf184
    171353.4167766f,
    // Hf185
    172288.0127544f,
    // Hf186
    173221.5002541f,
    // Ta156
    145286.7093741f,
    // Ta157
    146214.9059873f,
    // Ta158
    147144.7420302f,
    // Ta159
    148073.013163f,
    // Ta160
    149003.0634495f,
    // Ta161
    149931.7723845f,
    // Ta162
    150862.1300641f,
    // Ta163
    151790.9880382f,
    // Ta164
    152721.78352f,
    // Ta165
    153650.7160136f,
    // Ta166
    154581.884093f,
    // Ta167
    155511.0494602f,
    // Ta168
    156442.3758936f,
    // Ta169
    157372.128102f,
    // Ta170
    158303.7805584f,
    // Ta171
    159233.7563254f,
    // Ta172
    160165.5112462f,
    // Ta173
    161095.8875556f,
    // Ta174
    162027.9684993f,
    // Ta175
    162958.9782247f,
    // Ta176
    163891.4876557f,
    // Ta177
    164822.7321177f,
    // Ta178
    165755.4166695f,
    // Ta179
    166687.0821668f,
    // Ta180
    167620.0033182f,
    // Ta181
    168551.9911124f,
    // Ta182
    169485.4935161f,
    // Ta183
    170418.1249728f,
    // Ta184
    171352.0744936f,
    // Ta185
    172285.0124119f,
    // Ta186
    173219.2926131f,
    // Ta187
    174152.5192945f,
    // Ta188
    175087.0873274f,
    // W158
    147151.7934406f,
    // W159
    148081.7412627f,
    // W160
    149009.5932232f,
    // W161
    149939.8950131f,
    // W162
    150867.8960126f,
    // W163
    151798.6356048f,
    // W164
    152726.8229031f,
    // W165
    153657.7208493f,
    // W166
    154586.1223912f,
    // W167
    155517.2904707f,
    // W168
    156446.1670746f,
    // W169
    157377.5680276f,
    // W170
    158306.7613395f,
    // W171
    159238.4137959f,
    // W172
    160168.0076503f,
    // W173
    161099.8836653f,
    // W174
    162029.8221725f,
    // W175
    162961.8844863f,
    // W176
    163892.2794257f,
    // W177
    164824.732967f,
    // W178
    165755.5098189f,
    // W179
    166688.1422071f,
    // W180
    167619.2953826f,
    // W181
    168552.1792742f,
    // W182
    169483.6808286f,
    // W183
    170417.0551518f,
    // W184
    171349.2088452f,
    // W185
    172283.0205049f,
    // W186
    173215.3915158f,
    // W187
    174149.4900757f,
    // W188
    175082.2221337f,
    // W189
    176016.9047404f,
    // W190
    176949.5818403f,
    // Re160
    149021.8144258f,
    // Re161
    149949.7409058f,
    // Re162
    150879.4185947f,
    // Re163
    151807.4289091f,
    // Re164
    152737.3860462f,
    // Re165
    153665.8341629f,
    // Re166
    154596.1638976f,
    // Re167
    155524.6399591f,
    // Re168
    156455.2491421f,
    // Re169
    157384.1536909f,
    // Re170
    158315.0236922f,
    // Re171
    159244.086595f,
    // Re172
    160175.3385089f,
    // Re173
    161104.7553795f,
    // Re174
    162036.2960566f,
    // Re175
    162966.1879891f,
    // Re176
    163897.8497604f,
    // Re177
    164828.1329205f,
    // Re178
    165760.1672894f,
    // Re179
    166690.8509919f,
    // Re180
    167623.0996046f,
    // Re181
    168553.9183737f,
    // Re182
    169486.4790368f,
    // Re183
    170417.610788f,
    // Re184
    171350.6912249f,
    // Re185
    172282.5874533f,
    // Re186
    173215.9736996f,
    // Re187
    174148.1792772f,
    // Re188
    175081.8731029f,
    // Re189
    176014.4064733f,
    // Re190
    176948.3150084f,
    // Re191
    177881.0237791f,
    // Re192
    178815.1595987f,
    // Os162
    150886.9730118f,
    // Os163
    151816.8183696f,
    // Os164
    152744.4747163f,
    // Os165
    153674.6181523f,
    // Os166
    154602.4328529f,
    // Os167
    155533.0140911f,
    // Os168
    156461.0430354f,
    // Os169
    157391.8385172f,
    // Os170
    158320.0630753f,
    // Os171
    159251.0634858f,
    // Os172
    160179.8003657f,
    // Os173
    161111.0243348f,
    // Os174
    162040.0313479f,
    // Os175
    162971.4881905f,
    // Os176
    163900.9982105f,
    // Os177
    164832.5854623f,
    // Os178
    165762.4960247f,
    // Os179
    166694.5490235f,
    // Os180
    167624.5527354f,
    // Os181
    168556.9038123f,
    // Os182
    169487.3881751f,
    // Os183
    170419.742978f,
    // Os184
    171350.6604856f,
    // Os185
    172283.6002668f,
    // Os186
    173214.9034129f,
    // Os187
    174148.1765759f,
    // Os188
    175079.7527429f,
    // Os189
    176013.397572f,
    // Os190
    176945.1712158f,
    // Os191
    177878.978218f,
    // Os192
    178810.9855736f,
    // Os193
    179744.9658338f,
    // Os194
    180677.4203066f,
    // Os195
    181611.6539331f,
    // Os196
    182544.5452767f,
    // Ir165
    153684.9577368f,
    // Ir166
    154614.5236464f,
    // Ir167
    155542.3197172f,
    // Ir168
    156472.3513738f,
    // Ir169
    157400.5107273f,
    // Ir170
    158330.7379977f,
    // Ir171
    159259.2047443f,
    // Ir172
    160189.6369434f,
    // Ir173
    161118.4017681f,
    // Ir174
    162049.0482108f,
    // Ir175
    162978.1949481f,
    // Ir176
    163908.9718f,
    // Ir177
    164838.2862062f,
    // Ir178
    165769.6964741f,
    // Ir179
    166699.3927929f,
    // Ir180
    167630.9800447f,
    // Ir181
    168560.9744415f,
    // Ir182
    169492.924976f,
    // Ir183
    170423.1895062f,
    // Ir184
    171355.2238752f,
    // Ir185
    172285.9727823f,
    // Ir186
    173218.7346481f,
    // Ir187
    174149.679169f,
    // Ir188
    175082.5621291f,
    // Ir189
    176013.9295483f,
    // Ir190
    176947.1692706f,
    // Ir191
    177878.6643045f,
    // Ir192
    178812.0316415f,
    // Ir193
    179743.825685f,
    // Ir194
    180677.3243627f,
    // Ir195
    181609.6577413f,
    // Ir196
    182543.390224f,
    // Ir197
    183476.054283f,
    // Ir198
    184410.0112557f,
    // Ir199
    185342.9119142f,
    // Pt168
    156479.8685312f,
    // Pt169
    157409.8536132f,
    // Pt170
    158337.5379047f,
    // Pt171
    159268.0259934f,
    // Pt172
    160195.9152137f,
    // Pt173
    161126.5896012f,
    // Pt174
    162054.6474219f,
    // Pt175
    162985.6469009f,
    // Pt176
    163914.0857026f,
    // Pt177
    164845.0674832f,
    // Pt178
    165774.0092918f,
    // Pt179
    166705.2891505f,
    // Pt180
    167634.6780762f,
    // Pt181
    168566.1349189f,
    // Pt182
    169495.8498675f,
    // Pt183
    170427.7724572f,
    // Pt184
    171357.5619254f,
    // Pt185
    172289.8477977f,
    // Pt186
    173220.1123279f,
    // Pt187
    174152.6590186f,
    // Pt188
    175083.0688619f,
    // Pt189
    176015.9005898f,
    // Pt190
    176946.5544845f,
    // Pt191
    177879.683359f,
    // Pt192
    178810.5719903f,
    // Pt193
    179743.8825061f,
    // Pt194
    180675.0775989f,
    // Pt195
    181608.5371539f,
    // Pt196
    182540.1812268f,
    // Pt197
    183473.8997371f,
    // Pt198
    184405.9089557f,
    // Pt199
    185339.9180922f,
    // Pt200
    186272.2021016f,
    // Pt201
    187206.5614798f,
    // Pt202
    188139.2106349f,
    // Au171
    159277.8253114f,
    // Au172
    160207.7731336f,
    // Au173
    161135.8113928f,
    // Au174
    162065.926884f,
    // Au175
    162994.2818512f,
    // Au176
    163924.5836412f,
    // Au177
    164853.2366865f,
    // Au178
    165783.5757362f,
    // Au179
    166712.6758988f,
    // Au180
    167643.2291921f,
    // Au181
    168572.4411339f,
    // Au182
    169503.6278433f,
    // Au183
    170433.2589575f,
    // Au184
    171364.6133357f,
    // Au185
    172294.5611579f,
    // Au186
    173226.2322442f,
    // Au187
    174156.384995f,
    // Au188
    175088.3727893f,
    // Au189
    176018.7490988f,
    // Au190
    176950.9967799f,
    // Au191
    177881.5137449f,
    // Au192
    178814.0883805f,
    // Au193
    179744.9509299f,
    // Au194
    180677.5693456f,
    // Au195
    181608.7644384f,
    // Au196
    182541.6865213f,
    // Au197
    183473.1815551f,
    // Au198
    184406.2340472f,
    // Au199
    185338.215321f,
    // Au200
    186271.5463297f,
    // Au201
    187203.8983382f,
    // Au202
    188137.3942214f,
    // Au203
    189070.1430463f,
    // Au204
    190004.033883f,
    // Au205
    190937.2978242f,
    // Hg175
    163003.4663831f,
    // Hg176
    163931.234509f,
    // Hg177
    164861.7319127f,
    // Hg178
    165789.6267219f,
    // Hg179
    166720.4725044f,
    // Hg180
    167648.7436372f,
    // Hg181
    168579.7626776f,
    // Hg182
    169508.406408f,
    // Hg183
    170439.7235265f,
    // Hg184
    171368.7398546f,
    // Hg185
    172300.3084765f,
    // Hg186
    173229.4552138f,
    // Hg187
    174161.2567092f,
    // Hg188
    175090.6735797f,
    // Hg189
    176022.6986338f,
    // Hg190
    176952.4694721f,
    // Hg191
    177884.6901398f,
    // Hg192
    178814.796316f,
    // Hg193
    179747.2908431f,
    // Hg194
    180677.6093999f,
    // Hg195
    181610.2753219f,
    // Hg196
    182541.0009416f,
    // Hg197
    183473.7805059f,
    // Hg198
    184404.8619564f,
    // Hg199
    185337.7626148f,
    // Hg200
    186269.3004974f,
    // Hg201
    187202.6352322f,
    // Hg202
    188134.446974f,
    // Hg203
    189068.0192398f,
    // Hg204
    190000.089937f,
    // Hg205
    190933.9872942f,
    // Hg206
    191866.8255426f,
    // Hg207
    192803.0525665f,
    // Hg208
    193737.676489f,
    // Tl177
    164871.5498606f,
    // Tl178
    165801.5069977f,
    // Tl179
    166729.4986823f,
    // Tl180
    167659.8004722f,
    // Tl181
    168588.229959f,
    // Tl182
    169518.522434f,
    // Tl183
    170447.3058885f,
    // Tl184
    171377.9243864f,
    // Tl185
    172306.9407145f,
    // Tl186
    173237.9224951f,
    // Tl187
    174167.1996416f,
    // Tl188
    175098.4608704f,
    // Tl189
    176027.877741f,
    // Tl190
    176959.4649928f,
    // Tl191
    177889.1892564f,
    // Tl192
    178820.9162323f,
    // Tl193
    179750.929259f,
    // Tl194
    180682.8891085f,
    // Tl195
    181613.0791191f,
    // Tl196
    182545.3836214f,
    // Tl197
    183475.9648595f,
    // Tl198
    184408.3252514f,
    // Tl199
    185339.2045677f,
    // Tl200
    186271.7559159f,
    // Tl201
    187203.1186776f,
    // Tl202
    188135.8116129f,
    // Tl203
    189067.5274109f,
    // Tl204
    190000.4373843f,
    // Tl205
    190932.4559179f,
    // Tl206
    191865.5177248f,
    // Tl207
    192798.234879f,
    // Tl208
    193734.0110597f,
    // Tl209
    194668.6200784f,
    // Tl210
    195604.5080385f,
    // Pb181
    168597.3679161f,
    // Pb182
    169525.1043713f,
    // Pb183
    170455.9035791f,
    // Pb184
    171383.9232085f,
    // Pb185
    172314.8397845f,
    // Pb186
    173243.2785862f,
    // Pb187
    174174.5211852f,
    // Pb188
    175103.2487501f,
    // Pb189
    176034.5751836f,
    // Pb190
    176963.5542519f,
    // Pb191
    177895.0669841f,
    // Pb192
    178824.2882409f,
    // Pb193
    179756.0804214f,
    // Pb194
    180685.6090712f,
    // Pb195
    181617.5689207f,
    // Pb196
    182547.4235934f,
    // Pb197
    183479.5417969f,
    // Pb198
    184409.7318075f,
    // Pb199
    185342.0921994f,
    // Pb200
    186272.5672473f,
    // Pb201
    187205.0245145f,
    // Pb202
    188135.8609821f,
    // Pb203
    189068.5017537f,
    // Pb204
    189999.6735591f,
    // Pb205
    190932.50715f,
    // Pb206
    191863.9844855f,
    // Pb207
    192796.8124875f,
    // Pb208
    193729.0098679f,
    // Pb209
    194664.6388726f,
    // Pb210
    195599.0187437f,
    // Pb211
    196534.7585962f,
    // Pb212
    197469.1929598f,
    // Pb213
    198404.9835787f,
    // Pb214
    199339.5498418f,
    // Bi185
    172324.2758198f,
    // Bi186
    173254.6241844f,
    // Bi187
    174183.3051746f,
    // Bi188
    175113.5976496f,
    // Bi189
    176042.6139777f,
    // Bi190
    176973.1859009f,
    // Bi191
    177902.3792128f,
    // Bi192
    178833.2398992f,
    // Bi193
    179762.5822502f,
    // Bi194
    180693.7875895f,
    // Bi195
    181623.4187036f,
    // Bi196
    182554.7823969f,
    // Bi197
    183484.7115891f,
    // Bi198
    184416.289526f,
    // Bi199
    185346.4422769f,
    // Bi200
    186278.458016f,
    // Bi201
    187208.8622702f,
    // Bi202
    188141.0084185f,
    // Bi203
    189071.7554626f,
    // Bi204
    190004.122375f,
    // Bi205
    190935.2159349f,
    // Bi206
    191867.7421327f,
    // Bi207
    192799.2101533f,
    // Bi208
    193731.8891162f,
    // Bi209
    194663.9942787f,
    // Bi210
    195598.9554021f,
    // Bi211
    196533.3865054f,
    // Bi212
    197468.6196251f,
    // Bi213
    198403.0041537f,
    // Bi214
    199338.5260366f,
    // Bi215
    200272.936647f,
    // Bi216
    201208.5013786f,
    // Po190
    176979.324447f,
    // Po191
    177910.3900621f,
    // Po192
    178838.968588f,
    // Po193
    179770.0714628f,
    // Po194
    180698.9387518f,
    // Po195
    181630.2186106f,
    // Po196
    182559.346718f,
    // Po197
    183490.89671f,
    // Po198
    184420.3135805f,
    // Po199
    185352.0498714f,
    // Po200
    186281.8113947f,
    // Po201
    187213.7432993f,
    // Po202
    188143.8308456f,
    // Po203
    189075.9863088f,
    // Po204
    190006.4529732f,
    // Po205
    190938.750955f,
    // Po206
    191869.5883541f,
    // Po207
    192802.1192094f,
    // Po208
    193733.2900833f,
    // Po209
    194665.8880062f,
    // Po210
    195597.7928975f,
    // Po211
    196532.8080476f,
    // Po212
    197466.3654094f,
    // Po213
    198401.5771048f,
    // Po214
    199335.2536978f,
    // Po215
    200270.6870888f,
    // Po216
    201204.5007978f,
    // Po217
    202140.0420557f,
    // Po218
    203074.0659098f,
    // At193
    179778.5387442f,
    // At194
    180708.8964238f,
    // At195
    181638.1363105f,
    // At196
    182568.8386429f,
    // At197
    183498.0878445f,
    // At198
    184429.07894f,
    // At199
    185358.5982749f,
    // At200
    186289.7756693f,
    // At201
    187219.5930823f,
    // At202
    188151.0499249f,
    // At203
    189081.0536367f,
    // At204
    190012.9296517f,
    // At205
    190943.2873313f,
    // At206
    191875.3030704f,
    // At207
    192806.0296216f,
    // At208
    193738.2754397f,
    // At209
    194669.3745886f,
    // At210
    195601.7741033f,
    // At211
    196533.5942286f,
    // At212
    197468.1194128f,
    // At213
    198401.6497613f,
    // At214
    199336.3435459f,
    // At215
    200269.9661123f,
    // At216
    201204.9700845f,
    // At217
    202138.6075548f,
    // At218
    203073.8006203f,
    // At219
    204007.7343057f,
    // At220
    204942.9543845f,
    // At221
    205877.0939301f,
    // At222
    206812.4909928f,
    // At223
    207746.7888925f,
    // Rn196
    182574.9958189f,
    // Rn197
    183505.8844501f,
    // Rn198
    184434.6958495f,
    // Rn199
    185365.7521496f,
    // Rn200
    186294.7964225f,
    // Rn201
    187226.1601157f,
    // Rn202
    188155.4931518f,
    // Rn203
    189087.0804036f,
    // Rn204
    190016.7580925f,
    // Rn205
    190948.5316431f,
    // Rn206
    191878.6191894f,
    // Rn207
    192810.6442434f,
    // Rn208
    193741.1146338f,
    // Rn209
    194673.3064252f,
    // Rn210
    195604.1484818f,
    // Rn211
    196536.4855863f,
    // Rn212
    197468.0765641f,
    // Rn213
    198402.5318862f,
    // Rn214
    199335.4027369f,
    // Rn215
    200270.0480838f,
    // Rn216
    201202.9664407f,
    // Rn217
    202137.867017f,
    // Rn218
    203070.917646f,
    // Rn219
    204006.034329f,
    // Rn220
    204939.3067468f,
    // Rn221
    205874.5975259f,
    // Rn222
    206808.0575466f,
    // Rn223
    207743.4820884f,
    // Rn224
    208677.1186272f,
    // Rn225
    209612.6647289f,
    // Rn226
    210546.4409919f,
    // Rn227
    211482.1454476f,
    // Rn228
    212416.1266392f,
    // Fr200
    186304.8751887f,
    // Fr201
    187234.0312409f,
    // Fr202
    188164.8732974f,
    // Fr203
    189094.280853f,
    // Fr204
    190025.3464681f,
    // Fr205
    190955.0427869f,
    // Fr206
    191886.3785353f,
    // Fr207
    192816.3543023f,
    // Fr208
    193748.099908f,
    // Fr209
    194678.4669026f,
    // Fr210
    195610.4062591f,
    // Fr211
    196541.0908931f,
    // Fr212
    197473.2053706f,
    // Fr213
    198404.6808431f,
    // Fr214
    199338.7644991f,
    // Fr215
    200271.5356799f,
    // Fr216
    201205.6957184f,
    // Fr217
    202138.5199944f,
    // Fr218
    203072.7592099f,
    // Fr219
    204005.8163594f,
    // Fr220
    204940.1720116f,
    // Fr221
    205873.4666921f,
    // Fr222
    206808.032862f,
    // Fr223
    207741.5638626f,
    // Fr224
    208676.3268572f,
    // Fr225
    209610.0258061f,
    // Fr226
    210544.997176f,
    // Fr227
    211478.8106987f,
    // Fr228
    212413.9283132f,
    // Fr229
    213347.9467646f,
    // Fr230
    214283.2413629f,
    // Fr231
    215217.4367982f,
    // Fr232
    216152.8804355f,
    // Ra203
    189101.8818449f,
    // Ra204
    190030.8329684f,
    // Ra205
    190962.0569375f,
    // Ra206
    191891.3061391f,
    // Ra207
    192822.7536667f,
    // Ra208
    193752.4313556f,
    // Ra209
    194684.0744971f,
    // Ra210
    195614.1806732f,
    // Ra211
    196546.084633f,
    // Ra212
    197476.5475714f,
    // Ra213
    198408.569831f,
    // Ra214
    199339.8226764f,
    // Ra215
    200273.7507729f,
    // Ra216
    201206.0031115f,
    // Ra217
    202140.0942194f,
    // Ra218
    203072.350284f,
    // Ra219
    204006.5876365f,
    // Ra220
    204938.9629323f,
    // Ra221
    205873.1518471f,
    // Ra222
    206806.0003419f,
    // Ra223
    207740.4146783f,
    // Ra224
    208673.4969781f,
    // Ra225
    209608.1600235f,
    // Ra226
    210541.3295111f,
    // Ra227
    211476.3335764f,
    // Ra228
    212409.5913698f,
    // Ra229
    213344.5840709f,
    // Ra230
    214278.1833499f,
    // Ra231
    215213.5338379f,
    // Ra232
    216147.3287307f,
    // Ra233
    217082.8375727f,
    // Ra234
    218016.706985f,
    // Ac207
    192830.5409574f,
    // Ac208
    193761.4761634f,
    // Ac209
    194691.1817971f,
    // Ac210
    195622.3871363f,
    // Ac211
    196552.3815332f,
    // Ac212
    197484.0246746f,
    // Ac213
    198414.3637243f,
    // Ac214
    199346.1559048f,
    // Ac215
    200277.2401498f,
    // Ac216
    201210.8496753f,
    // Ac217
    202142.913852f,
    // Ac218
    203076.5475964f,
    // Ac219
    204008.7589492f,
    // Ac220
    204942.4420628f,
    // Ac221
    205874.7093052f,
    // Ac222
    206808.2983379f,
    // Ac223
    207741.0005881f,
    // Ac224
    208674.8998083f,
    // Ac225
    209607.8032612f,
    // Ac226
    210541.9698202f,
    // Ac227
    211475.0074083f,
    // Ac228
    212409.5454471f,
    // Ac229
    213342.823547f,
    // Ac230
    214277.2052811f,
    // Ac231
    215211.0467486f,
    // Ac232
    216145.7731355f,
    // Ac233
    217079.623918f,
    // Ac234
    218014.7229026f,
    // Ac235
    218948.7134092f,
    // Ac236
    219884.0080075f,
    // Th210
    195627.7618572f,
    // Th211
    196559.0976056f,
    // Th212
    197488.7846095f,
    // Th213
    198420.3159716f,
    // Th214
    199350.4035179f,
    // Th215
    200282.1584386f,
    // Th216
    201213.0200565f,
    // Th217
    202146.3948455f,
    // Th218
    203078.0733837f,
    // Th219
    204011.6652108f,
    // Th220
    204943.3577215f,
    // Th221
    205877.1228065f,
    // Th222
    206808.8805217f,
    // Th223
    207742.5552518f,
    // Th224
    208674.6678662f,
    // Th225
    209608.473937f,
    // Th226
    210540.8529588f,
    // Th227
    211474.9626966f,
    // Th228
    212407.4183803f,
    // Th229
    213341.7290414f,
    // Th230
    214274.5007811f,
    // Th231
    215208.9481856f,
    // Th232
    216142.0754766f,
    // Th233
    217076.8544929f,
    // Th234
    218010.2284435f,
    // Th235
    218945.3600304f,
    // Th236
    219878.9127347f,
    // Th237
    220814.3004825f,
    // Th238
    221747.983596f,
    // Pa213
    198427.9728531f,
    // Pa214
    199359.0570981f,
    // Pa215
    200289.0235502f,
    // Pa216
    201220.5269675f,
    // Pa217
    202151.2572447f,
    // Pa218
    203084.353517f,
    // Pa219
    204015.7265251f,
    // Pa220
    204949.0836157f,
    // Pa221
    205880.5590882f,
    // Pa222
    206813.7950846f,
    // Pa223
    207745.5034306f,
    // Pa224
    208678.5344982f,
    // Pa225
    209610.5036626f,
    // Pa226
    210543.6865638f,
    // Pa227
    211475.9817511f,
    // Pa228
    212409.5661263f,
    // Pa229
    213342.0401605f,
    // Pa230
    214275.8108344f,
    // Pa231
    215208.5586347f,
    // Pa232
    216142.5706588f,
    // Pa233
    217075.6093647f,
    // Pa234
    218009.9555158f,
    // Pa235
    218943.4411525f,
    // Pa236
    219877.9532958f,
    // Pa237
    220811.7388737f,
    // Pa238
    221746.3627963f,
    // Pa239
    222680.3067281f,
    // Pa240
    223615.3870828f,
    // U218
    203087.5951164f,
    // U219
    204020.4212554f,
    // U220
    204951.719744f,
    // U221
    205884.7414967f,
    // U222
    206815.9747808f,
    // U223
    207749.0058484f,
    // U224
    208680.3788566f,
    // U225
    209613.5403334f,
    // U226
    210544.997176f,
    // U227
    211478.1679678f,
    // U228
    212409.8725878f,
    // U229
    213343.3507727f,
    // U230
    214275.246349f,
    // U231
    215208.9406405f,
    // U232
    216141.2333127f,
    // U233
    217075.039104f,
    // U234
    218007.7605431f,
    // U235
    218942.0281691f,
    // U236
    219875.048804f,
    // U237
    220809.4883839f,
    // U238
    221742.9000601f,
    // U239
    222677.6592356f,
    // U240
    223611.2940977f,
    // U241
    224546.275714f,
    // U242
    225480.1917011f,
    // Np225
    209617.7506867f,
    // Np226
    210550.3905269f,
    // Np227
    211481.7262753f,
    // Np228
    212414.3568004f,
    // Np229
    213345.9161074f,
    // Np230
    214278.8633406f,
    // Np231
    215210.7486705f,
    // Np232
    216143.9846669f,
    // Np233
    217076.0656105f,
    // Np234
    218009.5708087f,
    // Np235
    218942.1518715f,
    // Np236
    219875.9785283f,
    // Np237
    220808.9698212f,
    // Np238
    221743.047143f,
    // Np239
    222676.395757f,
    // Np240
    223610.9056647f,
    // Np241
    224544.3382063f,
    // Np242
    225478.9900737f,
    // Np243
    226412.9340056f,
    // Np244
    227347.7628568f,
    // Pu228
    212416.7321104f,
    // Pu229
    213349.5396195f,
    // Pu230
    214280.5735638f,
    // Pu231
    215213.5710976f,
    // Pu232
    216144.989749f,
    // Pu233
    217078.1707872f,
    // Pu234
    218009.9583102f,
    // Pu235
    218943.2939765f,
    // Pu236
    219875.5016965f,
    // Pu237
    220809.1901195f,
    // Pu238
    221741.7550675f,
    // Pu239
    222675.6739422f,
    // Pu240
    223608.7059414f,
    // Pu241
    224543.0297365f,
    // Pu242
    225476.28576f,
    // Pu243
    226410.8167195f,
    // Pu244
    227344.3610404f,
    // Pu245
    228279.1535634f,
    // Pu246
    229212.9382098f,
    // Pu247
    230148.0390573f,
    // Am231
    215217.5765223f,
    // Am232
    216150.0300636f,
    // Am233
    217081.4123867f,
    // Am234
    218014.1360613f,
    // Am235
    218945.8537223f,
    // Am236
    219878.7823256f,
    // Am237
    220810.6490256f,
    // Am238
    221744.0154311f,
    // Am239
    222676.4764244f,
    // Am240
    223610.0850184f,
    // Am241
    224543.0088711f,
    // Am242
    225477.0367306f,
    // Am243
    226410.2351877f,
    // Am244
    227344.436864f,
    // Am245
    228277.94821f,
    // Am246
    229212.5376673f,
    // Am247
    230146.194699f,
    // Am248
    231081.0980698f,
    // Am249
    232015.1351511f,
    // Cm233
    217085.4457561f,
    // Cm234
    218016.4182218f,
    // Cm235
    218949.1698413f,
    // Cm236
    219880.4962747f,
    // Cm237
    220813.3689884f,
    // Cm238
    221744.984185f,
    // Cm239
    222678.276071f,
    // Cm240
    223610.3001935f,
    // Cm241
    224543.7762359f,
    // Cm242
    225476.3719232f,
    // Cm243
    226410.2440369f,
    // Cm244
    227343.0087904f,
    // Cm245
    228277.0545346f,
    // Cm246
    229210.1619847f,
    // Cm247
    230144.5711048f,
    // Cm248
    231077.9235379f,
    // Cm249
    232012.7756765f,
    // Cm250
    232946.5090907f,
    // Cm251
    233881.6611704f,
    // Cm252
    234815.5697055f,
    // Bk235
    218953.8179968f,
    // Bk236
    219886.0107198f,
    // Bk237
    220817.3185234f,
    // Bk238
    221749.874529f,
    // Bk239
    222681.4524659f,
    // Bk240
    223614.2413451f,
    // Bk241
    224546.1732497f,
    // Bk242
    225479.3719863f,
    // Bk243
    226411.752871f,
    // Bk244
    227345.2645896f,
    // Bk245
    228277.8647481f,
    // Bk246
    229211.5148868f,
    // Bk247
    230144.526393f,
    // Bk248
    231078.6109805f,
    // Bk249
    232011.8749217f,
    // Bk250
    232946.4718309f,
    // Bk251
    233880.2406419f,
    // Bk252
    234815.0387539f,
    // Bk253
    235748.9361111f,
    // Bk254
    236683.8953715f,
    // Cf237
    220821.9201042f,
    // Cf238
    221752.7994205f,
    // Cf239
    222685.383371f,
    // Cf240
    223616.616655f,
    // Cf241
    224549.433479f,
    // Cf242
    225480.8996366f,
    // Cf243
    226414.0052238f,
    // Cf244
    227346.0302778f,
    // Cf245
    228279.4339431f,
    // Cf246
    229211.6348632f,
    // Cf247
    230145.1719185f,
    // Cf248
    231077.7707728f,
    // Cf249
    232011.751033f,
    // Cf250
    232944.6917457f,
    // Cf251
    233879.1479993f,
    // Cf252
    234812.5423497f,
    // Cf253
    235747.3032019f,
    // Cf254
    236680.8363449f,
    // Cf255
    237615.7993313f,
    // Cf256
    238549.5290195f,
    // Es240
    223622.783146f,
    // Es241
    224554.0350599f,
    // Es242
    225486.4979162f,
    // Es243
    226417.9268139f,
    // Es244
    227350.6691184f,
    // Es245
    228282.4892438f,
    // Es246
    229215.5203114f,
    // Es247
    230147.6478298f,
    // Es248
    231080.8279365f,
    // Es249
    232013.2069583f,
    // Es250
    232946.7876074f,
    // Es251
    233879.524323f,
    // Es252
    234813.7998667f,
    // Es253
    235747.0153702f,
    // Es254
    236681.4883908f,
    // Es255
    237615.0783549f,
    // Es256
    238549.6687436f,
    // Es257
    239483.3891169f,
    // Fm242
    225489.9723892f,
    // Fm243
    226422.4725052f,
    // Fm244
    227353.5660651f,
    // Fm245
    228286.2711098f,
    // Fm246
    229217.6720628f,
    // Fm247
    230150.6006661f,
    // Fm248
    231082.4338323f,
    // Fm249
    232015.6381579f,
    // Fm250
    232947.5933498f,
    // Fm251
    233880.9979466f,
    // Fm252
    234813.3248047f,
    // Fm253
    235747.3488451f,
    // Fm254
    236680.4004056f,
    // Fm255
    237614.7886602f,
    // Fm256
    238547.9706299f,
    // Fm257
    239482.5684706f,
    // Fm258
    240415.8985479f,
    // Fm259
    241350.6715095f,
    // Md245
    228291.5247365f,
    // Md246
    229223.8664986f,
    // Md247
    230155.2395067f,
    // Md248
    231087.7675676f,
    // Md249
    232019.3455044f,
    // Md250
    232952.227533f,
    // Md251
    233884.1221779f,
    // Md252
    234817.2091352f,
    // Md253
    235749.3087087f,
    // Md254
    236683.0849716f,
    // Md255
    237615.8319336f,
    // Md256
    238550.0972309f,
    // Md257
    239482.9746021f,
    // Md258
    240417.1607224f,
    // Md259
    241350.5876751f,
    // Md260
    242285.0159839f,
    // No249
    232023.835306f,
    // No250
    232955.0220153f,
    // No251
    233887.885414f,
    // No252
    234819.3851054f,
    // No253
    235752.4478438f,
    // No254
    236684.220463f,
    // No255
    237617.8411664f,
    // No256
    238550.3077486f,
    // No257
    239484.1995168f,
    // No258
    240416.9511362f,
    // No259
    241351.072052f,
    // No260
    242284.0751748f,
    // No261
    243218.4569089f,
    // No262
    244151.6090708f,
    // Lr251
    233892.9154822f,
    // Lr252
    234825.3131338f,
    // Lr253
    235756.7420316f,
    // Lr254
    236689.4750212f,
    // Lr255
    237621.1367925f,
    // Lr256
    238554.4845682f,
    // Lr257
    239486.7704405f,
    // Lr258
    240420.3790345f,
    // Lr259
    241352.9070954f,
    // Lr260
    242286.8044525f,
    // Lr261
    243219.5747018f,
    // Lr262
    244153.630413f,
    // Lr263
    245086.7080554f,
    // Rf253
    235761.7907297f,
    // Rf254
    236692.8097701f,
    // Rf255
    237625.5334447f,
    // Rf256
    238556.7387839f,
    // Rf257
    239489.9934101f,
    // Rf258
    240421.9532596f,
    // Rf259
    241355.3662398f,
    // Rf260
    242287.6055375f,
    // Rf261
    243221.2607062f,
    // Rf262
    244153.8446567f,
    // Rf263
    245087.7792736f,
    // Rf264
    246020.6147275f,
    // Db255
    237631.0385748f,
    // Db256
    238563.194038f,
    // Db257
    239494.4552669f,
    // Db258
    240427.4211299f,
    // Db259
    241359.1760507f,
    // Db260
    242292.263008f,
    // Db261
    243224.3905264f,
    // Db262
    244157.7848767f,
    // Db263
    245090.1452686f,
    // Db264
    246023.8656419f,
    // Db265
    246956.4682223f,
    // Sg258
    240430.8769731f,
    // Sg259
    241363.7683166f,
    // Sg260
    242295.0668052f,
    // Sg261
    243228.2003372f,
    // Sg262
    244159.955258f,
    // Sg263
    245093.1539946f,
    // Sg264
    246025.2163083f,
    // Sg265
    246958.713123f,
    // Sg266
    247891.0083104f,
    // Bh260
    242301.9226018f,
    // Bh261
    243233.4167042f,
    // Bh262
    244166.0379145f,
    // Bh263
    245097.662426f,
    // Bh264
    246030.6282891f,
    // Bh265
    246962.5601937f,
    // Bh266
    247895.7403004f,
    // Bh267
    248827.9143935f,
    // Hs263
    245102.8415332f,
    // Hs264
    246034.0561874f,
    // Hs265
    246967.0313654f,
    // Hs266
    247898.5627275f,
    // Hs267
    248831.6683147f,
    // Hs268
    249763.5256998f,
    // Hs269
    250696.8362157f,
    // Hs277
    0.0f,
    // Mt265
    246973.1512816f,
    // Mt266
    247905.9215309f,
    // Mt267
    248837.0337207f,
    // Mt268
    249769.7294505f,
    // Mt269
    250701.4936862f,
    // Mt270
    251634.4874941f,
    // Mt271
    252566.4566585f,
    // Ds267
    248843.0232278f,
    // Ds268
    249774.1167877f,
    // Ds269
    250707.1105956f,
    // Ds270
    251638.129636f,
    // Ds271
    252570.9744049f,
    // Ds272
    253502.6827509f,
    // Ds273
    254436.9154459f,
    // Ds281
    0.0f,
    // Rg272
    253509.3615636f,
    // Cn285
    0.0f,
    // Nh286
    0.0f,
    // Fl289
    0.0f,
    // Mc289
    0.0f,
    // Lv293
    0.0f,
    // Ts294
    0.0f,
    // Og294
    0.0f,
};
static const std::array<const char* const, kParticlesCount> kParticlesName = {
    "Og294~",
    "Ts294~",
    "Lv293~",
    "Mc289~",
    "Fl289~",
    "Nh286~",
    "Cn285~",
    "Rg272~",
    "Ds281~",
    "Ds273~",
    "Ds272~",
    "Ds271~",
    "Ds270~",
    "Ds269~",
    "Ds268~",
    "Ds267~",
    "Mt271~",
    "Mt270~",
    "Mt269~",
    "Mt268~",
    "Mt267~",
    "Mt266~",
    "Mt265~",
    "Hs277~",
    "Hs269~",
    "Hs268~",
    "Hs267~",
    "Hs266~",
    "Hs265~",
    "Hs264~",
    "Hs263~",
    "Bh267~",
    "Bh266~",
    "Bh265~",
    "Bh264~",
    "Bh263~",
    "Bh262~",
    "Bh261~",
    "Bh260~",
    "Sg266~",
    "Sg265~",
    "Sg264~",
    "Sg263~",
    "Sg262~",
    "Sg261~",
    "Sg260~",
    "Sg259~",
    "Sg258~",
    "Db265~",
    "Db264~",
    "Db263~",
    "Db262~",
    "Db261~",
    "Db260~",
    "Db259~",
    "Db258~",
    "Db257~",
    "Db256~",
    "Db255~",
    "Rf264~",
    "Rf263~",
    "Rf262~",
    "Rf261~",
    "Rf260~",
    "Rf259~",
    "Rf258~",
    "Rf257~",
    "Rf256~",
    "Rf255~",
    "Rf254~",
    "Rf253~",
    "Lr263~",
    "Lr262~",
    "Lr261~",
    "Lr260~",
    "Lr259~",
    "Lr258~",
    "Lr257~",
    "Lr256~",
    "Lr255~",
    "Lr254~",
    "Lr253~",
    "Lr252~",
    "Lr251~",
    "No262~",
    "No261~",
    "No260~",
    "No259~",
    "No258~",
    "No257~",
    "No256~",
    "No255~",
    "No254~",
    "No253~",
    "No252~",
    "No251~",
    "No250~",
    "No249~",
    "Md260~",
    "Md259~",
    "Md258~",
    "Md257~",
    "Md256~",
    "Md255~",
    "Md254~",
    "Md253~",
    "Md252~",
    "Md251~",
    "Md250~",
    "Md249~",
    "Md248~",
    "Md247~",
    "Md246~",
    "Md245~",
    "Fm259~",
    "Fm258~",
    "Fm257~",
    "Fm256~",
    "Fm255~",
    "Fm254~",
    "Fm253~",
    "Fm252~",
    "Fm251~",
    "Fm250~",
    "Fm249~",
    "Fm248~",
    "Fm247~",
    "Fm246~",
    "Fm245~",
    "Fm244~",
    "Fm243~",
    "Fm242~",
    "Es257~",
    "Es256~",
    "Es255~",
    "Es254~",
    "Es253~",
    "Es252~",
    "Es251~",
    "Es250~",
    "Es249~",
    "Es248~",
    "Es247~",
    "Es246~",
    "Es245~",
    "Es244~",
    "Es243~",
    "Es242~",
    "Es241~",
    "Es240~",
    "Cf256~",
    "Cf255~",
    "Cf254~",
    "Cf253~",
    "Cf252~",
    "Cf251~",
    "Cf250~",
    "Cf249~",
    "Cf248~",
    "Cf247~",
    "Cf246~",
    "Cf245~",
    "Cf244~",
    "Cf243~",
    "Cf242~",
    "Cf241~",
    "Cf240~",
    "Cf239~",
    "Cf238~",
    "Cf237~",
    "Bk254~",
    "Bk253~",
    "Bk252~",
    "Bk251~",
    "Bk250~",
    "Bk249~",
    "Bk248~",
    "Bk247~",
    "Bk246~",
    "Bk245~",
    "Bk244~",
    "Bk243~",
    "Bk242~",
    "Bk241~",
    "Bk240~",
    "Bk239~",
    "Bk238~",
    "Bk237~",
    "Bk236~",
    "Bk235~",
    "Cm252~",
    "Cm251~",
    "Cm250~",
    "Cm249~",
    "Cm248~",
    "Cm247~",
    "Cm246~",
    "Cm245~",
    "Cm244~",
    "Cm243~",
    "Cm242~",
    "Cm241~",
    "Cm240~",
    "Cm239~",
    "Cm238~",
    "Cm237~",
    "Cm236~",
    "Cm235~",
    "Cm234~",
    "Cm233~",
    "Am249~",
    "Am248~",
    "Am247~",
    "Am246~",
    "Am245~",
    "Am244~",
    "Am243~",
    "Am242~",
    "Am241~",
    "Am240~",
    "Am239~",
    "Am238~",
    "Am237~",
    "Am236~",
    "Am235~",
    "Am234~",
    "Am233~",
    "Am232~",
    "Am231~",
    "Pu247~",
    "Pu246~",
    "Pu245~",
    "Pu244~",
    "Pu243~",
    "Pu242~",
    "Pu241~",
    "Pu240~",
    "Pu239~",
    "Pu238~",
    "Pu237~",
    "Pu236~",
    "Pu235~",
    "Pu234~",
    "Pu233~",
    "Pu232~",
    "Pu231~",
    "Pu230~",
    "Pu229~",
    "Pu228~",
    "Np244~",
    "Np243~",
    "Np242~",
    "Np241~",
    "Np240~",
    "Np239~",
    "Np238~",
    "Np237~",
    "Np236~",
    "Np235~",
    "Np234~",
    "Np233~",
    "Np232~",
    "Np231~",
    "Np230~",
    "Np229~",
    "Np228~",
    "Np227~",
    "Np226~",
    "Np225~",
    "U242~",
    "U241~",
    "U240~",
    "U239~",
    "U238~",
    "U237~",
    "U236~",
    "U235~",
    "U234~",
    "U233~",
    "U232~",
    "U231~",
    "U230~",
    "U229~",
    "U228~",
    "U227~",
    "U226~",
    "U225~",
    "U224~",
    "U223~",
    "U222~",
    "U221~",
    "U220~",
    "U219~",
    "U218~",
    "Pa240~",
    "Pa239~",
    "Pa238~",
    "Pa237~",
    "Pa236~",
    "Pa235~",
    "Pa234~",
    "Pa233~",
    "Pa232~",
    "Pa231~",
    "Pa230~",
    "Pa229~",
    "Pa228~",
    "Pa227~",
    "Pa226~",
    "Pa225~",
    "Pa224~",
    "Pa223~",
    "Pa222~",
    "Pa221~",
    "Pa220~",
    "Pa219~",
    "Pa218~",
    "Pa217~",
    "Pa216~",
    "Pa215~",
    "Pa214~",
    "Pa213~",
    "Th238~",
    "Th237~",
    "Th236~",
    "Th235~",
    "Th234~",
    "Th233~",
    "Th232~",
    "Th231~",
    "Th230~",
    "Th229~",
    "Th228~",
    "Th227~",
    "Th226~",
    "Th225~",
    "Th224~",
    "Th223~",
    "Th222~",
    "Th221~",
    "Th220~",
    "Th219~",
    "Th218~",
    "Th217~",
    "Th216~",
    "Th215~",
    "Th214~",
    "Th213~",
    "Th212~",
    "Th211~",
    "Th210~",
    "Ac236~",
    "Ac235~",
    "Ac234~",
    "Ac233~",
    "Ac232~",
    "Ac231~",
    "Ac230~",
    "Ac229~",
    "Ac228~",
    "Ac227~",
    "Ac226~",
    "Ac225~",
    "Ac224~",
    "Ac223~",
    "Ac222~",
    "Ac221~",
    "Ac220~",
    "Ac219~",
    "Ac218~",
    "Ac217~",
    "Ac216~",
    "Ac215~",
    "Ac214~",
    "Ac213~",
    "Ac212~",
    "Ac211~",
    "Ac210~",
    "Ac209~",
    "Ac208~",
    "Ac207~",
    "Ra234~",
    "Ra233~",
    "Ra232~",
    "Ra231~",
    "Ra230~",
    "Ra229~",
    "Ra228~",
    "Ra227~",
    "Ra226~",
    "Ra225~",
    "Ra224~",
    "Ra223~",
    "Ra222~",
    "Ra221~",
    "Ra220~",
    "Ra219~",
    "Ra218~",
    "Ra217~",
    "Ra216~",
    "Ra215~",
    "Ra214~",
    "Ra213~",
    "Ra212~",
    "Ra211~",
    "Ra210~",
    "Ra209~",
    "Ra208~",
    "Ra207~",
    "Ra206~",
    "Ra205~",
    "Ra204~",
    "Ra203~",
    "Fr232~",
    "Fr231~",
    "Fr230~",
    "Fr229~",
    "Fr228~",
    "Fr227~",
    "Fr226~",
    "Fr225~",
    "Fr224~",
    "Fr223~",
    "Fr222~",
    "Fr221~",
    "Fr220~",
    "Fr219~",
    "Fr218~",
    "Fr217~",
    "Fr216~",
    "Fr215~",
    "Fr214~",
    "Fr213~",
    "Fr212~",
    "Fr211~",
    "Fr210~",
    "Fr209~",
    "Fr208~",
    "Fr207~",
    "Fr206~",
    "Fr205~",
    "Fr204~",
    "Fr203~",
    "Fr202~",
    "Fr201~",
    "Fr200~",
    "Rn228~",
    "Rn227~",
    "Rn226~",
    "Rn225~",
    "Rn224~",
    "Rn223~",
    "Rn222~",
    "Rn221~",
    "Rn220~",
    "Rn219~",
    "Rn218~",
    "Rn217~",
    "Rn216~",
    "Rn215~",
    "Rn214~",
    "Rn213~",
    "Rn212~",
    "Rn211~",
    "Rn210~",
    "Rn209~",
    "Rn208~",
    "Rn207~",
    "Rn206~",
    "Rn205~",
    "Rn204~",
    "Rn203~",
    "Rn202~",
    "Rn201~",
    "Rn200~",
    "Rn199~",
    "Rn198~",
    "Rn197~",
    "Rn196~",
    "At223~",
    "At222~",
    "At221~",
    "At220~",
    "At219~",
    "At218~",
    "At217~",
    "At216~",
    "At215~",
    "At214~",
    "At213~",
    "At212~",
    "At211~",
    "At210~",
    "At209~",
    "At208~",
    "At207~",
    "At206~",
    "At205~",
    "At204~",
    "At203~",
    "At202~",
    "At201~",
    "At200~",
    "At199~",
    "At198~",
    "At197~",
    "At196~",
    "At195~",
    "At194~",
    "At193~",
    "Po218~",
    "Po217~",
    "Po216~",
    "Po215~",
    "Po214~",
    "Po213~",
    "Po212~",
    "Po211~",
    "Po210~",
    "Po209~",
    "Po208~",
    "Po207~",
    "Po206~",
    "Po205~",
    "Po204~",
    "Po203~",
    "Po202~",
    "Po201~",
    "Po200~",
    "Po199~",
    "Po198~",
    "Po197~",
    "Po196~",
    "Po195~",
    "Po194~",
    "Po193~",
    "Po192~",
    "Po191~",
    "Po190~",
    "Bi216~",
    "Bi215~",
    "Bi214~",
    "Bi213~",
    "Bi212~",
    "Bi211~",
    "Bi210~",
    "Bi209~",
    "Bi208~",
    "Bi207~",
    "Bi206~",
    "Bi205~",
    "Bi204~",
    "Bi203~",
    "Bi202~",
    "Bi201~",
    "Bi200~",
    "Bi199~",
    "Bi198~",
    "Bi197~",
    "Bi196~",
    "Bi195~",
    "Bi194~",
    "Bi193~",
    "Bi192~",
    "Bi191~",
    "Bi190~",
    "Bi189~",
    "Bi188~",
    "Bi187~",
    "Bi186~",
    "Bi185~",
    "Pb214~",
    "Pb213~",
    "Pb212~",
    "Pb211~",
    "Pb210~",
    "Pb209~",
    "Pb208~",
    "Pb207~",
    "Pb206~",
    "Pb205~",
    "Pb204~",
    "Pb203~",
    "Pb202~",
    "Pb201~",
    "Pb200~",
    "Pb199~",
    "Pb198~",
    "Pb197~",
    "Pb196~",
    "Pb195~",
    "Pb194~",
    "Pb193~",
    "Pb192~",
    "Pb191~",
    "Pb190~",
    "Pb189~",
    "Pb188~",
    "Pb187~",
    "Pb186~",
    "Pb185~",
    "Pb184~",
    "Pb183~",
    "Pb182~",
    "Pb181~",
    "Tl210~",
    "Tl209~",
    "Tl208~",
    "Tl207~",
    "Tl206~",
    "Tl205~",
    "Tl204~",
    "Tl203~",
    "Tl202~",
    "Tl201~",
    "Tl200~",
    "Tl199~",
    "Tl198~",
    "Tl197~",
    "Tl196~",
    "Tl195~",
    "Tl194~",
    "Tl193~",
    "Tl192~",
    "Tl191~",
    "Tl190~",
    "Tl189~",
    "Tl188~",
    "Tl187~",
    "Tl186~",
    "Tl185~",
    "Tl184~",
    "Tl183~",
    "Tl182~",
    "Tl181~",
    "Tl180~",
    "Tl179~",
    "Tl178~",
    "Tl177~",
    "Hg208~",
    "Hg207~",
    "Hg206~",
    "Hg205~",
    "Hg204~",
    "Hg203~",
    "Hg202~",
    "Hg201~",
    "Hg200~",
    "Hg199~",
    "Hg198~",
    "Hg197~",
    "Hg196~",
    "Hg195~",
    "Hg194~",
    "Hg193~",
    "Hg192~",
    "Hg191~",
    "Hg190~",
    "Hg189~",
    "Hg188~",
    "Hg187~",
    "Hg186~",
    "Hg185~",
    "Hg184~",
    "Hg183~",
    "Hg182~",
    "Hg181~",
    "Hg180~",
    "Hg179~",
    "Hg178~",
    "Hg177~",
    "Hg176~",
    "Hg175~",
    "Au205~",
    "Au204~",
    "Au203~",
    "Au202~",
    "Au201~",
    "Au200~",
    "Au199~",
    "Au198~",
    "Au197~",
    "Au196~",
    "Au195~",
    "Au194~",
    "Au193~",
    "Au192~",
    "Au191~",
    "Au190~",
    "Au189~",
    "Au188~",
    "Au187~",
    "Au186~",
    "Au185~",
    "Au184~",
    "Au183~",
    "Au182~",
    "Au181~",
    "Au180~",
    "Au179~",
    "Au178~",
    "Au177~",
    "Au176~",
    "Au175~",
    "Au174~",
    "Au173~",
    "Au172~",
    "Au171~",
    "Pt202~",
    "Pt201~",
    "Pt200~",
    "Pt199~",
    "Pt198~",
    "Pt197~",
    "Pt196~",
    "Pt195~",
    "Pt194~",
    "Pt193~",
    "Pt192~",
    "Pt191~",
    "Pt190~",
    "Pt189~",
    "Pt188~",
    "Pt187~",
    "Pt186~",
    "Pt185~",
    "Pt184~",
    "Pt183~",
    "Pt182~",
    "Pt181~",
    "Pt180~",
    "Pt179~",
    "Pt178~",
    "Pt177~",
    "Pt176~",
    "Pt175~",
    "Pt174~",
    "Pt173~",
    "Pt172~",
    "Pt171~",
    "Pt170~",
    "Pt169~",
    "Pt168~",
    "Ir199~",
    "Ir198~",
    "Ir197~",
    "Ir196~",
    "Ir195~",
    "Ir194~",
    "Ir193~",
    "Ir192~",
    "Ir191~",
    "Ir190~",
    "Ir189~",
    "Ir188~",
    "Ir187~",
    "Ir186~",
    "Ir185~",
    "Ir184~",
    "Ir183~",
    "Ir182~",
    "Ir181~",
    "Ir180~",
    "Ir179~",
    "Ir178~",
    "Ir177~",
    "Ir176~",
    "Ir175~",
    "Ir174~",
    "Ir173~",
    "Ir172~",
    "Ir171~",
    "Ir170~",
    "Ir169~",
    "Ir168~",
    "Ir167~",
    "Ir166~",
    "Ir165~",
    "Os196~",
    "Os195~",
    "Os194~",
    "Os193~",
    "Os192~",
    "Os191~",
    "Os190~",
    "Os189~",
    "Os188~",
    "Os187~",
    "Os186~",
    "Os185~",
    "Os184~",
    "Os183~",
    "Os182~",
    "Os181~",
    "Os180~",
    "Os179~",
    "Os178~",
    "Os177~",
    "Os176~",
    "Os175~",
    "Os174~",
    "Os173~",
    "Os172~",
    "Os171~",
    "Os170~",
    "Os169~",
    "Os168~",
    "Os167~",
    "Os166~",
    "Os165~",
    "Os164~",
    "Os163~",
    "Os162~",
    "Re192~",
    "Re191~",
    "Re190~",
    "Re189~",
    "Re188~",
    "Re187~",
    "Re186~",
    "Re185~",
    "Re184~",
    "Re183~",
    "Re182~",
    "Re181~",
    "Re180~",
    "Re179~",
    "Re178~",
    "Re177~",
    "Re176~",
    "Re175~",
    "Re174~",
    "Re173~",
    "Re172~",
    "Re171~",
    "Re170~",
    "Re169~",
    "Re168~",
    "Re167~",
    "Re166~",
    "Re165~",
    "Re164~",
    "Re163~",
    "Re162~",
    "Re161~",
    "Re160~",
    "W190~",
    "W189~",
    "W188~",
    "W187~",
    "W186~",
    "W185~",
    "W184~",
    "W183~",
    "W182~",
    "W181~",
    "W180~",
    "W179~",
    "W178~",
    "W177~",
    "W176~",
    "W175~",
    "W174~",
    "W173~",
    "W172~",
    "W171~",
    "W170~",
    "W169~",
    "W168~",
    "W167~",
    "W166~",
    "W165~",
    "W164~",
    "W163~",
    "W162~",
    "W161~",
    "W160~",
    "W159~",
    "W158~",
    "Ta188~",
    "Ta187~",
    "Ta186~",
    "Ta185~",
    "Ta184~",
    "Ta183~",
    "Ta182~",
    "Ta181~",
    "Ta180~",
    "Ta179~",
    "Ta178~",
    "Ta177~",
    "Ta176~",
    "Ta175~",
    "Ta174~",
    "Ta173~",
    "Ta172~",
    "Ta171~",
    "Ta170~",
    "Ta169~",
    "Ta168~",
    "Ta167~",
    "Ta166~",
    "Ta165~",
    "Ta164~",
    "Ta163~",
    "Ta162~",
    "Ta161~",
    "Ta160~",
    "Ta159~",
    "Ta158~",
    "Ta157~",
    "Ta156~",
    "Hf186~",
    "Hf185~",
    "Hf184~",
    "Hf183~",
    "Hf182~",
    "Hf181~",
    "Hf180~",
    "Hf179~",
    "Hf178~",
    "Hf177~",
    "Hf176~",
    "Hf175~",
    "Hf174~",
    "Hf173~",
    "Hf172~",
    "Hf171~",
    "Hf170~",
    "Hf169~",
    "Hf168~",
    "Hf167~",
    "Hf166~",
    "Hf165~",
    "Hf164~",
    "Hf163~",
    "Hf162~",
    "Hf161~",
    "Hf160~",
    "Hf159~",
    "Hf158~",
    "Hf157~",
    "Hf156~",
    "Hf155~",
    "Hf154~",
    "Lu184~",
    "Lu183~",
    "Lu182~",
    "Lu181~",
    "Lu180~",
    "Lu179~",
    "Lu178~",
    "Lu177~",
    "Lu176~",
    "Lu175~",
    "Lu174~",
    "Lu173~",
    "Lu172~",
    "Lu171~",
    "Lu170~",
    "Lu169~",
    "Lu168~",
    "Lu167~",
    "Lu166~",
    "Lu165~",
    "Lu164~",
    "Lu163~",
    "Lu162~",
    "Lu161~",
    "Lu160~",
    "Lu159~",
    "Lu158~",
    "Lu157~",
    "Lu156~",
    "Lu155~",
    "Lu154~",
    "Lu153~",
    "Lu152~",
    "Lu151~",
    "Lu150~",
    "Yb181~",
    "Yb180~",
    "Yb179~",
    "Yb178~",
    "Yb177~",
    "Yb176~",
    "Yb175~",
    "Yb174~",
    "Yb173~",
    "Yb172~",
    "Yb171~",
    "Yb170~",
    "Yb169~",
    "Yb168~",
    "Yb167~",
    "Yb166~",
    "Yb165~",
    "Yb164~",
    "Yb163~",
    "Yb162~",
    "Yb161~",
    "Yb160~",
    "Yb159~",
    "Yb158~",
    "Yb157~",
    "Yb156~",
    "Yb155~",
    "Yb154~",
    "Yb153~",
    "Yb152~",
    "Yb151~",
    "Yb150~",
    "Yb149~",
    "Yb148~",
    "Tm179~",
    "Tm178~",
    "Tm177~",
    "Tm176~",
    "Tm175~",
    "Tm174~",
    "Tm173~",
    "Tm172~",
    "Tm171~",
    "Tm170~",
    "Tm169~",
    "Tm168~",
    "Tm167~",
    "Tm166~",
    "Tm165~",
    "Tm164~",
    "Tm163~",
    "Tm162~",
    "Tm161~",
    "Tm160~",
    "Tm159~",
    "Tm158~",
    "Tm157~",
    "Tm156~",
    "Tm155~",
    "Tm154~",
    "Tm153~",
    "Tm152~",
    "Tm151~",
    "Tm150~",
    "Tm149~",
    "Tm148~",
    "Tm147~",
    "Tm146~",
    "Er177~",
    "Er176~",
    "Er175~",
    "Er174~",
    "Er173~",
    "Er172~",
    "Er171~",
    "Er170~",
    "Er169~",
    "Er168~",
    "Er167~",
    "Er166~",
    "Er165~",
    "Er164~",
    "Er163~",
    "Er162~",
    "Er161~",
    "Er160~",
    "Er159~",
    "Er158~",
    "Er157~",
    "Er156~",
    "Er155~",
    "Er154~",
    "Er153~",
    "Er152~",
    "Er151~",
    "Er150~",
    "Er149~",
    "Er148~",
    "Er147~",
    "Er146~",
    "Er145~",
    "Er144~",
    "Ho175~",
    "Ho174~",
    "Ho173~",
    "Ho172~",
    "Ho171~",
    "Ho170~",
    "Ho169~",
    "Ho168~",
    "Ho167~",
    "Ho166~",
    "Ho165~",
    "Ho164~",
    "Ho163~",
    "Ho162~",
    "Ho161~",
    "Ho160~",
    "Ho159~",
    "Ho158~",
    "Ho157~",
    "Ho156~",
    "Ho155~",
    "Ho154~",
    "Ho153~",
    "Ho152~",
    "Ho151~",
    "Ho150~",
    "Ho149~",
    "Ho148~",
    "Ho147~",
    "Ho146~",
    "Ho145~",
    "Ho144~",
    "Ho143~",
    "Ho142~",
    "Dy173~",
    "Dy172~",
    "Dy171~",
    "Dy170~",
    "Dy169~",
    "Dy168~",
    "Dy167~",
    "Dy166~",
    "Dy165~",
    "Dy164~",
    "Dy163~",
    "Dy162~",
    "Dy161~",
    "Dy160~",
    "Dy159~",
    "Dy158~",
    "Dy157~",
    "Dy156~",
    "Dy155~",
    "Dy154~",
    "Dy153~",
    "Dy152~",
    "Dy151~",
    "Dy150~",
    "Dy149~",
    "Dy148~",
    "Dy147~",
    "Dy146~",
    "Dy145~",
    "Dy144~",
    "Dy143~",
    "Dy142~",
    "Dy141~",
    "Dy140~",
    "Tb171~",
    "Tb170~",
    "Tb169~",
    "Tb168~",
    "Tb167~",
    "Tb166~",
    "Tb165~",
    "Tb164~",
    "Tb163~",
    "Tb162~",
    "Tb161~",
    "Tb160~",
    "Tb159~",
    "Tb158~",
    "Tb157~",
    "Tb156~",
    "Tb155~",
    "Tb154~",
    "Tb153~",
    "Tb152~",
    "Tb151~",
    "Tb150~",
    "Tb149~",
    "Tb148~",
    "Tb147~",
    "Tb146~",
    "Tb145~",
    "Tb144~",
    "Tb143~",
    "Tb142~",
    "Tb141~",
    "Tb140~",
    "Tb139~",
    "Tb138~",
    "Gd169~",
    "Gd168~",
    "Gd167~",
    "Gd166~",
    "Gd165~",
    "Gd164~",
    "Gd163~",
    "Gd162~",
    "Gd161~",
    "Gd160~",
    "Gd159~",
    "Gd158~",
    "Gd157~",
    "Gd156~",
    "Gd155~",
    "Gd154~",
    "Gd153~",
    "Gd152~",
    "Gd151~",
    "Gd150~",
    "Gd149~",
    "Gd148~",
    "Gd147~",
    "Gd146~",
    "Gd145~",
    "Gd144~",
    "Gd143~",
    "Gd142~",
    "Gd141~",
    "Gd140~",
    "Gd139~",
    "Gd138~",
    "Gd137~",
    "Gd136~",
    "Eu167~",
    "Eu166~",
    "Eu165~",
    "Eu164~",
    "Eu163~",
    "Eu162~",
    "Eu161~",
    "Eu160~",
    "Eu159~",
    "Eu158~",
    "Eu157~",
    "Eu156~",
    "Eu155~",
    "Eu154~",
    "Eu153~",
    "Eu152~",
    "Eu151~",
    "Eu150~",
    "Eu149~",
    "Eu148~",
    "Eu147~",
    "Eu146~",
    "Eu145~",
    "Eu144~",
    "Eu143~",
    "Eu142~",
    "Eu141~",
    "Eu140~",
    "Eu139~",
    "Eu138~",
    "Eu137~",
    "Eu136~",
    "Eu135~",
    "Eu134~",
    "Eu133~",
    "Eu132~",
    "Sm165~",
    "Sm164~",
    "Sm163~",
    "Sm162~",
    "Sm161~",
    "Sm160~",
    "Sm159~",
    "Sm158~",
    "Sm157~",
    "Sm156~",
    "Sm155~",
    "Sm154~",
    "Sm153~",
    "Sm152~",
    "Sm151~",
    "Sm150~",
    "Sm149~",
    "Sm148~",
    "Sm147~",
    "Sm146~",
    "Sm145~",
    "Sm144~",
    "Sm143~",
    "Sm142~",
    "Sm141~",
    "Sm140~",
    "Sm139~",
    "Sm138~",
    "Sm137~",
    "Sm136~",
    "Sm135~",
    "Sm134~",
    "Sm133~",
    "Sm132~",
    "Sm131~",
    "Sm130~",
    "Pm163~",
    "Pm162~",
    "Pm161~",
    "Pm160~",
    "Pm159~",
    "Pm158~",
    "Pm157~",
    "Pm156~",
    "Pm155~",
    "Pm154~",
    "Pm153~",
    "Pm152~",
    "Pm151~",
    "Pm150~",
    "Pm149~",
    "Pm148~",
    "Pm147~",
    "Pm146~",
    "Pm145~",
    "Pm144~",
    "Pm143~",
    "Pm142~",
    "Pm141~",
    "Pm140~",
    "Pm139~",
    "Pm138~",
    "Pm137~",
    "Pm136~",
    "Pm135~",
    "Pm134~",
    "Pm133~",
    "Pm132~",
    "Pm131~",
    "Pm130~",
    "Pm129~",
    "Pm128~",
    "Nd161~",
    "Nd160~",
    "Nd159~",
    "Nd158~",
    "Nd157~",
    "Nd156~",
    "Nd155~",
    "Nd154~",
    "Nd153~",
    "Nd152~",
    "Nd151~",
    "Nd150~",
    "Nd149~",
    "Nd148~",
    "Nd147~",
    "Nd146~",
    "Nd145~",
    "Nd144~",
    "Nd143~",
    "Nd142~",
    "Nd141~",
    "Nd140~",
    "Nd139~",
    "Nd138~",
    "Nd137~",
    "Nd136~",
    "Nd135~",
    "Nd134~",
    "Nd133~",
    "Nd132~",
    "Nd131~",
    "Nd130~",
    "Nd129~",
    "Nd128~",
    "Nd127~",
    "Nd126~",
    "Pr159~",
    "Pr158~",
    "Pr157~",
    "Pr156~",
    "Pr155~",
    "Pr154~",
    "Pr153~",
    "Pr152~",
    "Pr151~",
    "Pr150~",
    "Pr149~",
    "Pr148~",
    "Pr147~",
    "Pr146~",
    "Pr145~",
    "Pr144~",
    "Pr143~",
    "Pr142~",
    "Pr141~",
    "Pr140~",
    "Pr139~",
    "Pr138~",
    "Pr137~",
    "Pr136~",
    "Pr135~",
    "Pr134~",
    "Pr133~",
    "Pr132~",
    "Pr131~",
    "Pr130~",
    "Pr129~",
    "Pr128~",
    "Pr127~",
    "Pr126~",
    "Pr125~",
    "Pr124~",
    "Pr123~",
    "Pr122~",
    "Pr121~",
    "Ce157~",
    "Ce156~",
    "Ce155~",
    "Ce154~",
    "Ce153~",
    "Ce152~",
    "Ce151~",
    "Ce150~",
    "Ce149~",
    "Ce148~",
    "Ce147~",
    "Ce146~",
    "Ce145~",
    "Ce144~",
    "Ce143~",
    "Ce142~",
    "Ce141~",
    "Ce140~",
    "Ce139~",
    "Ce138~",
    "Ce137~",
    "Ce136~",
    "Ce135~",
    "Ce134~",
    "Ce133~",
    "Ce132~",
    "Ce131~",
    "Ce130~",
    "Ce129~",
    "Ce128~",
    "Ce127~",
    "Ce126~",
    "Ce125~",
    "Ce124~",
    "Ce123~",
    "Ce122~",
    "Ce121~",
    "Ce120~",
    "Ce119~",
    "La155~",
    "La154~",
    "La153~",
    "La152~",
    "La151~",
    "La150~",
    "La149~",
    "La148~",
    "La147~",
    "La146~",
    "La145~",
    "La144~",
    "La143~",
    "La142~",
    "La141~",
    "La140~",
    "La139~",
    "La138~",
    "La137~",
    "La136~",
    "La135~",
    "La134~",
    "La133~",
    "La132~",
    "La131~",
    "La130~",
    "La129~",
    "La128~",
    "La127~",
    "La126~",
    "La125~",
    "La124~",
    "La123~",
    "La122~",
    "La121~",
    "La120~",
    "La119~",
    "La118~",
    "La117~",
    "Ba153~",
    "Ba152~",
    "Ba151~",
    "Ba150~",
    "Ba149~",
    "Ba148~",
    "Ba147~",
    "Ba146~",
    "Ba145~",
    "Ba144~",
    "Ba143~",
    "Ba142~",
    "Ba141~",
    "Ba140~",
    "Ba139~",
    "Ba138~",
    "Ba137~",
    "Ba136~",
    "Ba135~",
    "Ba134~",
    "Ba133~",
    "Ba132~",
    "Ba131~",
    "Ba130~",
    "Ba129~",
    "Ba128~",
    "Ba127~",
    "Ba126~",
    "Ba125~",
    "Ba124~",
    "Ba123~",
    "Ba122~",
    "Ba121~",
    "Ba120~",
    "Ba119~",
    "Ba118~",
    "Ba117~",
    "Ba116~",
    "Ba115~",
    "Ba114~",
    "Cs151~",
    "Cs150~",
    "Cs149~",
    "Cs148~",
    "Cs147~",
    "Cs146~",
    "Cs145~",
    "Cs144~",
    "Cs143~",
    "Cs142~",
    "Cs141~",
    "Cs140~",
    "Cs139~",
    "Cs138~",
    "Cs137~",
    "Cs136~",
    "Cs135~",
    "Cs134~",
    "Cs133~",
    "Cs132~",
    "Cs131~",
    "Cs130~",
    "Cs129~",
    "Cs128~",
    "Cs127~",
    "Cs126~",
    "Cs125~",
    "Cs124~",
    "Cs123~",
    "Cs122~",
    "Cs121~",
    "Cs120~",
    "Cs119~",
    "Cs118~",
    "Cs117~",
    "Cs116~",
    "Cs115~",
    "Cs114~",
    "Cs113~",
    "Cs112~",
    "Xe147~",
    "Xe146~",
    "Xe145~",
    "Xe144~",
    "Xe143~",
    "Xe142~",
    "Xe141~",
    "Xe140~",
    "Xe139~",
    "Xe138~",
    "Xe137~",
    "Xe136~",
    "Xe135~",
    "Xe134~",
    "Xe133~",
    "Xe132~",
    "Xe131~",
    "Xe130~",
    "Xe129~",
    "Xe128~",
    "Xe127~",
    "Xe126~",
    "Xe125~",
    "Xe124~",
    "Xe123~",
    "Xe122~",
    "Xe121~",
    "Xe120~",
    "Xe119~",
    "Xe118~",
    "Xe117~",
    "Xe116~",
    "Xe115~",
    "Xe114~",
    "Xe113~",
    "Xe112~",
    "Xe111~",
    "Xe110~",
    "I144~",
    "I143~",
    "I142~",
    "I141~",
    "I140~",
    "I139~",
    "I138~",
    "I137~",
    "I136~",
    "I135~",
    "I134~",
    "I133~",
    "I132~",
    "I131~",
    "I130~",
    "I129~",
    "I128~",
    "I127~",
    "I126~",
    "I125~",
    "I124~",
    "I123~",
    "I122~",
    "I121~",
    "I120~",
    "I119~",
    "I118~",
    "I117~",
    "I116~",
    "I115~",
    "I114~",
    "I113~",
    "I112~",
    "I111~",
    "I110~",
    "I109~",
    "I108~",
    "Te142~",
    "Te141~",
    "Te140~",
    "Te139~",
    "Te138~",
    "Te137~",
    "Te136~",
    "Te135~",
    "Te134~",
    "Te133~",
    "Te132~",
    "Te131~",
    "Te130~",
    "Te129~",
    "Te128~",
    "Te127~",
    "Te126~",
    "Te125~",
    "Te124~",
    "Te123~",
    "Te122~",
    "Te121~",
    "Te120~",
    "Te119~",
    "Te118~",
    "Te117~",
    "Te116~",
    "Te115~",
    "Te114~",
    "Te113~",
    "Te112~",
    "Te111~",
    "Te110~",
    "Te109~",
    "Te108~",
    "Te107~",
    "Te106~",
    "Sb139~",
    "Sb138~",
    "Sb137~",
    "Sb136~",
    "Sb135~",
    "Sb134~",
    "Sb133~",
    "Sb132~",
    "Sb131~",
    "Sb130~",
    "Sb129~",
    "Sb128~",
    "Sb127~",
    "Sb126~",
    "Sb125~",
    "Sb124~",
    "Sb123~",
    "Sb122~",
    "Sb121~",
    "Sb120~",
    "Sb119~",
    "Sb118~",
    "Sb117~",
    "Sb116~",
    "Sb115~",
    "Sb114~",
    "Sb113~",
    "Sb112~",
    "Sb111~",
    "Sb110~",
    "Sb109~",
    "Sb108~",
    "Sb107~",
    "Sb106~",
    "Sb105~",
    "Sb104~",
    "Sb103~",
    "Sn137~",
    "Sn136~",
    "Sn135~",
    "Sn134~",
    "Sn133~",
    "Sn132~",
    "Sn131~",
    "Sn130~",
    "Sn129~",
    "Sn128~",
    "Sn127~",
    "Sn126~",
    "Sn125~",
    "Sn124~",
    "Sn123~",
    "Sn122~",
    "Sn121~",
    "Sn120~",
    "Sn119~",
    "Sn118~",
    "Sn117~",
    "Sn116~",
    "Sn115~",
    "Sn114~",
    "Sn113~",
    "Sn112~",
    "Sn111~",
    "Sn110~",
    "Sn109~",
    "Sn108~",
    "Sn107~",
    "Sn106~",
    "Sn105~",
    "Sn104~",
    "Sn103~",
    "Sn102~",
    "Sn101~",
    "Sn100~",
    "In134~",
    "In133~",
    "In132~",
    "In131~",
    "In130~",
    "In129~",
    "In128~",
    "In127~",
    "In126~",
    "In125~",
    "In124~",
    "In123~",
    "In122~",
    "In121~",
    "In120~",
    "In119~",
    "In118~",
    "In117~",
    "In116~",
    "In115~",
    "In114~",
    "In113~",
    "In112~",
    "In111~",
    "In110~",
    "In109~",
    "In108~",
    "In107~",
    "In106~",
    "In105~",
    "In104~",
    "In103~",
    "In102~",
    "In101~",
    "In100~",
    "In99~",
    "In98~",
    "Cd130~",
    "Cd129~",
    "Cd128~",
    "Cd127~",
    "Cd126~",
    "Cd125~",
    "Cd124~",
    "Cd123~",
    "Cd122~",
    "Cd121~",
    "Cd120~",
    "Cd119~",
    "Cd118~",
    "Cd117~",
    "Cd116~",
    "Cd115~",
    "Cd114~",
    "Cd113~",
    "Cd112~",
    "Cd111~",
    "Cd110~",
    "Cd109~",
    "Cd108~",
    "Cd107~",
    "Cd106~",
    "Cd105~",
    "Cd104~",
    "Cd103~",
    "Cd102~",
    "Cd101~",
    "Cd100~",
    "Cd99~",
    "Cd98~",
    "Cd97~",
    "Cd96~",
    "Ag127~",
    "Ag126~",
    "Ag125~",
    "Ag124~",
    "Ag123~",
    "Ag122~",
    "Ag121~",
    "Ag120~",
    "Ag119~",
    "Ag118~",
    "Ag117~",
    "Ag116~",
    "Ag115~",
    "Ag114~",
    "Ag113~",
    "Ag112~",
    "Ag111~",
    "Ag110~",
    "Ag109~",
    "Ag108~",
    "Ag107~",
    "Ag106~",
    "Ag105~",
    "Ag104~",
    "Ag103~",
    "Ag102~",
    "Ag101~",
    "Ag100~",
    "Ag99~",
    "Ag98~",
    "Ag97~",
    "Ag96~",
    "Ag95~",
    "Ag94~",
    "Pd123~",
    "Pd122~",
    "Pd121~",
    "Pd120~",
    "Pd119~",
    "Pd118~",
    "Pd117~",
    "Pd116~",
    "Pd115~",
    "Pd114~",
    "Pd113~",
    "Pd112~",
    "Pd111~",
    "Pd110~",
    "Pd109~",
    "Pd108~",
    "Pd107~",
    "Pd106~",
    "Pd105~",
    "Pd104~",
    "Pd103~",
    "Pd102~",
    "Pd101~",
    "Pd100~",
    "Pd99~",
    "Pd98~",
    "Pd97~",
    "Pd96~",
    "Pd95~",
    "Pd94~",
    "Pd93~",
    "Pd92~",
    "Pd91~",
    "Rh121~",
    "Rh120~",
    "Rh119~",
    "Rh118~",
    "Rh117~",
    "Rh116~",
    "Rh115~",
    "Rh114~",
    "Rh113~",
    "Rh112~",
    "Rh111~",
    "Rh110~",
    "Rh109~",
    "Rh108~",
    "Rh107~",
    "Rh106~",
    "Rh105~",
    "Rh104~",
    "Rh103~",
    "Rh102~",
    "Rh101~",
    "Rh100~",
    "Rh99~",
    "Rh98~",
    "Rh97~",
    "Rh96~",
    "Rh95~",
    "Rh94~",
    "Rh93~",
    "Rh92~",
    "Rh91~",
    "Rh90~",
    "Rh89~",
    "Ru118~",
    "Ru117~",
    "Ru116~",
    "Ru115~",
    "Ru114~",
    "Ru113~",
    "Ru112~",
    "Ru111~",
    "Ru110~",
    "Ru109~",
    "Ru108~",
    "Ru107~",
    "Ru106~",
    "Ru105~",
    "Ru104~",
    "Ru103~",
    "Ru102~",
    "Ru101~",
    "Ru100~",
    "Ru99~",
    "Ru98~",
    "Ru97~",
    "Ru96~",
    "Ru95~",
    "Ru94~",
    "Ru93~",
    "Ru92~",
    "Ru91~",
    "Ru90~",
    "Ru89~",
    "Ru88~",
    "Ru87~",
    "Tc115~",
    "Tc114~",
    "Tc113~",
    "Tc112~",
    "Tc111~",
    "Tc110~",
    "Tc109~",
    "Tc108~",
    "Tc107~",
    "Tc106~",
    "Tc105~",
    "Tc104~",
    "Tc103~",
    "Tc102~",
    "Tc101~",
    "Tc100~",
    "Tc99~",
    "Tc98~",
    "Tc97~",
    "Tc96~",
    "Tc95~",
    "Tc94~",
    "Tc93~",
    "Tc92~",
    "Tc91~",
    "Tc90~",
    "Tc89~",
    "Tc88~",
    "Tc87~",
    "Tc86~",
    "Tc85~",
    "Mo113~",
    "Mo112~",
    "Mo111~",
    "Mo110~",
    "Mo109~",
    "Mo108~",
    "Mo107~",
    "Mo106~",
    "Mo105~",
    "Mo104~",
    "Mo103~",
    "Mo102~",
    "Mo101~",
    "Mo100~",
    "Mo99~",
    "Mo98~",
    "Mo97~",
    "Mo96~",
    "Mo95~",
    "Mo94~",
    "Mo93~",
    "Mo92~",
    "Mo91~",
    "Mo90~",
    "Mo89~",
    "Mo88~",
    "Mo87~",
    "Mo86~",
    "Mo85~",
    "Mo84~",
    "Mo83~",
    "Nb110~",
    "Nb109~",
    "Nb108~",
    "Nb107~",
    "Nb106~",
    "Nb105~",
    "Nb104~",
    "Nb103~",
    "Nb102~",
    "Nb101~",
    "Nb100~",
    "Nb99~",
    "Nb98~",
    "Nb97~",
    "Nb96~",
    "Nb95~",
    "Nb94~",
    "Nb93~",
    "Nb92~",
    "Nb91~",
    "Nb90~",
    "Nb89~",
    "Nb88~",
    "Nb87~",
    "Nb86~",
    "Nb85~",
    "Nb84~",
    "Nb83~",
    "Nb82~",
    "Nb81~",
    "Zr108~",
    "Zr107~",
    "Zr106~",
    "Zr105~",
    "Zr104~",
    "Zr103~",
    "Zr102~",
    "Zr101~",
    "Zr100~",
    "Zr99~",
    "Zr98~",
    "Zr97~",
    "Zr96~",
    "Zr95~",
    "Zr94~",
    "Zr93~",
    "Zr92~",
    "Zr91~",
    "Zr90~",
    "Zr89~",
    "Zr88~",
    "Zr87~",
    "Zr86~",
    "Zr85~",
    "Zr84~",
    "Zr83~",
    "Zr82~",
    "Zr81~",
    "Zr80~",
    "Zr79~",
    "Y106~",
    "Y105~",
    "Y104~",
    "Y103~",
    "Y102~",
    "Y101~",
    "Y100~",
    "Y99~",
    "Y98~",
    "Y97~",
    "Y96~",
    "Y95~",
    "Y94~",
    "Y93~",
    "Y92~",
    "Y91~",
    "Y90~",
    "Y89~",
    "Y88~",
    "Y87~",
    "Y86~",
    "Y85~",
    "Y84~",
    "Y83~",
    "Y82~",
    "Y81~",
    "Y80~",
    "Y79~",
    "Y78~",
    "Y77~",
    "Sr104~",
    "Sr103~",
    "Sr102~",
    "Sr101~",
    "Sr100~",
    "Sr99~",
    "Sr98~",
    "Sr97~",
    "Sr96~",
    "Sr95~",
    "Sr94~",
    "Sr93~",
    "Sr92~",
    "Sr91~",
    "Sr90~",
    "Sr89~",
    "Sr88~",
    "Sr87~",
    "Sr86~",
    "Sr85~",
    "Sr84~",
    "Sr83~",
    "Sr82~",
    "Sr81~",
    "Sr80~",
    "Sr79~",
    "Sr78~",
    "Sr77~",
    "Sr76~",
    "Sr75~",
    "Sr74~",
    "Sr73~",
    "Rb102~",
    "Rb101~",
    "Rb100~",
    "Rb99~",
    "Rb98~",
    "Rb97~",
    "Rb96~",
    "Rb95~",
    "Rb94~",
    "Rb93~",
    "Rb92~",
    "Rb91~",
    "Rb90~",
    "Rb89~",
    "Rb88~",
    "Rb87~",
    "Rb86~",
    "Rb85~",
    "Rb84~",
    "Rb83~",
    "Rb82~",
    "Rb81~",
    "Rb80~",
    "Rb79~",
    "Rb78~",
    "Rb77~",
    "Rb76~",
    "Rb75~",
    "Rb74~",
    "Rb73~",
    "Rb72~",
    "Rb71~",
    "Kr97~",
    "Kr96~",
    "Kr95~",
    "Kr94~",
    "Kr93~",
    "Kr92~",
    "Kr91~",
    "Kr90~",
    "Kr89~",
    "Kr88~",
    "Kr87~",
    "Kr86~",
    "Kr85~",
    "Kr84~",
    "Kr83~",
    "Kr82~",
    "Kr81~",
    "Kr80~",
    "Kr79~",
    "Kr78~",
    "Kr77~",
    "Kr76~",
    "Kr75~",
    "Kr74~",
    "Kr73~",
    "Kr72~",
    "Kr71~",
    "Kr70~",
    "Kr69~",
    "Br94~",
    "Br93~",
    "Br92~",
    "Br91~",
    "Br90~",
    "Br89~",
    "Br88~",
    "Br87~",
    "Br86~",
    "Br85~",
    "Br84~",
    "Br83~",
    "Br82~",
    "Br81~",
    "Br80~",
    "Br79~",
    "Br78~",
    "Br77~",
    "Br76~",
    "Br75~",
    "Br74~",
    "Br73~",
    "Br72~",
    "Br71~",
    "Br70~",
    "Br69~",
    "Br68~",
    "Br67~",
    "Se92~",
    "Se91~",
    "Se90~",
    "Se89~",
    "Se88~",
    "Se87~",
    "Se86~",
    "Se85~",
    "Se84~",
    "Se83~",
    "Se82~",
    "Se81~",
    "Se80~",
    "Se79~",
    "Se78~",
    "Se77~",
    "Se76~",
    "Se75~",
    "Se74~",
    "Se73~",
    "Se72~",
    "Se71~",
    "Se70~",
    "Se69~",
    "Se68~",
    "Se67~",
    "Se66~",
    "Se65~",
    "As89~",
    "As88~",
    "As87~",
    "As86~",
    "As85~",
    "As84~",
    "As83~",
    "As82~",
    "As81~",
    "As80~",
    "As79~",
    "As78~",
    "As77~",
    "As76~",
    "As75~",
    "As74~",
    "As73~",
    "As72~",
    "As71~",
    "As70~",
    "As69~",
    "As68~",
    "As67~",
    "As66~",
    "As65~",
    "As64~",
    "As63~",
    "As62~",
    "As61~",
    "As60~",
    "Ge86~",
    "Ge85~",
    "Ge84~",
    "Ge83~",
    "Ge82~",
    "Ge81~",
    "Ge80~",
    "Ge79~",
    "Ge78~",
    "Ge77~",
    "Ge76~",
    "Ge75~",
    "Ge74~",
    "Ge73~",
    "Ge72~",
    "Ge71~",
    "Ge70~",
    "Ge69~",
    "Ge68~",
    "Ge67~",
    "Ge66~",
    "Ge65~",
    "Ge64~",
    "Ge63~",
    "Ge62~",
    "Ge61~",
    "Ge60~",
    "Ge59~",
    "Ge58~",
    "Ga84~",
    "Ga83~",
    "Ga82~",
    "Ga81~",
    "Ga80~",
    "Ga79~",
    "Ga78~",
    "Ga77~",
    "Ga76~",
    "Ga75~",
    "Ga74~",
    "Ga73~",
    "Ga72~",
    "Ga71~",
    "Ga70~",
    "Ga69~",
    "Ga68~",
    "Ga67~",
    "Ga66~",
    "Ga65~",
    "Ga64~",
    "Ga63~",
    "Ga62~",
    "Ga61~",
    "Ga60~",
    "Ga59~",
    "Ga58~",
    "Ga57~",
    "Ga56~",
    "Zn82~",
    "Zn81~",
    "Zn80~",
    "Zn79~",
    "Zn78~",
    "Zn77~",
    "Zn76~",
    "Zn75~",
    "Zn74~",
    "Zn73~",
    "Zn72~",
    "Zn71~",
    "Zn70~",
    "Zn69~",
    "Zn68~",
    "Zn67~",
    "Zn66~",
    "Zn65~",
    "Zn64~",
    "Zn63~",
    "Zn62~",
    "Zn61~",
    "Zn60~",
    "Zn59~",
    "Zn58~",
    "Zn57~",
    "Zn56~",
    "Zn55~",
    "Zn54~",
    "Cu80~",
    "Cu79~",
    "Cu78~",
    "Cu77~",
    "Cu76~",
    "Cu75~",
    "Cu74~",
    "Cu73~",
    "Cu72~",
    "Cu71~",
    "Cu70~",
    "Cu69~",
    "Cu68~",
    "Cu67~",
    "Cu66~",
    "Cu65~",
    "Cu64~",
    "Cu63~",
    "Cu62~",
    "Cu61~",
    "Cu60~",
    "Cu59~",
    "Cu58~",
    "Cu57~",
    "Cu56~",
    "Cu55~",
    "Cu54~",
    "Cu53~",
    "Cu52~",
    "Ni78~",
    "Ni77~",
    "Ni76~",
    "Ni75~",
    "Ni74~",
    "Ni73~",
    "Ni72~",
    "Ni71~",
    "Ni70~",
    "Ni69~",
    "Ni68~",
    "Ni67~",
    "Ni66~",
    "Ni65~",
    "Ni64~",
    "Ni63~",
    "Ni62~",
    "Ni61~",
    "Ni60~",
    "Ni59~",
    "Ni58~",
    "Ni57~",
    "Ni56~",
    "Ni55~",
    "Ni54~",
    "Ni53~",
    "Ni52~",
    "Ni51~",
    "Ni50~",
    "Co72~",
    "Co71~",
    "Co70~",
    "Co69~",
    "Co68~",
    "Co67~",
    "Co66~",
    "Co65~",
    "Co64~",
    "Co63~",
    "Co62~",
    "Co61~",
    "Co60~",
    "Co59~",
    "Co58~",
    "Co57~",
    "Co56~",
    "Co55~",
    "Co54~",
    "Co53~",
    "Co52~",
    "Co51~",
    "Co50~",
    "Co49~",
    "Co48~",
    "Fe69~",
    "Fe68~",
    "Fe67~",
    "Fe66~",
    "Fe65~",
    "Fe64~",
    "Fe63~",
    "Fe62~",
    "Fe61~",
    "Fe60~",
    "Fe59~",
    "Fe58~",
    "Fe57~",
    "Fe56~",
    "Fe55~",
    "Fe54~",
    "Fe53~",
    "Fe52~",
    "Fe51~",
    "Fe50~",
    "Fe49~",
    "Fe48~",
    "Fe47~",
    "Fe46~",
    "Fe45~",
    "Mn67~",
    "Mn66~",
    "Mn65~",
    "Mn64~",
    "Mn63~",
    "Mn62~",
    "Mn61~",
    "Mn60~",
    "Mn59~",
    "Mn58~",
    "Mn57~",
    "Mn56~",
    "Mn55~",
    "Mn54~",
    "Mn53~",
    "Mn52~",
    "Mn51~",
    "Mn50~",
    "Mn49~",
    "Mn48~",
    "Mn47~",
    "Mn46~",
    "Mn45~",
    "Mn44~",
    "Cr65~",
    "Cr64~",
    "Cr63~",
    "Cr62~",
    "Cr61~",
    "Cr60~",
    "Cr59~",
    "Cr58~",
    "Cr57~",
    "Cr56~",
    "Cr55~",
    "Cr54~",
    "Cr53~",
    "Cr52~",
    "Cr51~",
    "Cr50~",
    "Cr49~",
    "Cr48~",
    "Cr47~",
    "Cr46~",
    "Cr45~",
    "Cr44~",
    "Cr43~",
    "Cr42~",
    "V63~",
    "V62~",
    "V61~",
    "V60~",
    "V59~",
    "V58~",
    "V57~",
    "V56~",
    "V55~",
    "V54~",
    "V53~",
    "V52~",
    "V51~",
    "V50~",
    "V49~",
    "V48~",
    "V47~",
    "V46~",
    "V45~",
    "V44~",
    "V43~",
    "V42~",
    "V41~",
    "V40~",
    "Ti61~",
    "Ti60~",
    "Ti59~",
    "Ti58~",
    "Ti57~",
    "Ti56~",
    "Ti55~",
    "Ti54~",
    "Ti53~",
    "Ti52~",
    "Ti51~",
    "Ti50~",
    "Ti49~",
    "Ti48~",
    "Ti47~",
    "Ti46~",
    "Ti45~",
    "Ti44~",
    "Ti43~",
    "Ti42~",
    "Ti41~",
    "Ti40~",
    "Ti39~",
    "Ti38~",
    "Sc59~",
    "Sc58~",
    "Sc57~",
    "Sc56~",
    "Sc55~",
    "Sc54~",
    "Sc53~",
    "Sc52~",
    "Sc51~",
    "Sc50~",
    "Sc49~",
    "Sc48~",
    "Sc47~",
    "Sc46~",
    "Sc45~",
    "Sc44~",
    "Sc43~",
    "Sc42~",
    "Sc41~",
    "Sc40~",
    "Sc39~",
    "Sc38~",
    "Sc37~",
    "Sc36~",
    "Ca57~",
    "Ca56~",
    "Ca55~",
    "Ca54~",
    "Ca53~",
    "Ca52~",
    "Ca51~",
    "Ca50~",
    "Ca49~",
    "Ca48~",
    "Ca47~",
    "Ca46~",
    "Ca45~",
    "Ca44~",
    "Ca43~",
    "Ca42~",
    "Ca41~",
    "Ca40~",
    "Ca39~",
    "Ca38~",
    "Ca37~",
    "Ca36~",
    "Ca35~",
    "Ca34~",
    "K55~",
    "K54~",
    "K53~",
    "K52~",
    "K51~",
    "K50~",
    "K49~",
    "K48~",
    "K47~",
    "K46~",
    "K45~",
    "K44~",
    "K43~",
    "K42~",
    "K41~",
    "K40~",
    "K39~",
    "K38~",
    "K37~",
    "K36~",
    "K35~",
    "K34~",
    "K33~",
    "K32~",
    "Ar53~",
    "Ar52~",
    "Ar51~",
    "Ar50~",
    "Ar49~",
    "Ar48~",
    "Ar47~",
    "Ar46~",
    "Ar45~",
    "Ar44~",
    "Ar43~",
    "Ar42~",
    "Ar41~",
    "Ar40~",
    "Ar39~",
    "Ar38~",
    "Ar37~",
    "Ar36~",
    "Ar35~",
    "Ar34~",
    "Ar33~",
    "Ar32~",
    "Ar31~",
    "Ar30~",
    "Cl51~",
    "Cl50~",
    "Cl49~",
    "Cl48~",
    "Cl47~",
    "Cl46~",
    "Cl45~",
    "Cl44~",
    "Cl43~",
    "Cl42~",
    "Cl41~",
    "Cl40~",
    "Cl39~",
    "Cl38~",
    "Cl37~",
    "Cl36~",
    "Cl35~",
    "Cl34~",
    "Cl33~",
    "Cl32~",
    "Cl31~",
    "Cl30~",
    "Cl29~",
    "Cl28~",
    "S49~",
    "S48~",
    "S47~",
    "S46~",
    "S45~",
    "S44~",
    "S43~",
    "S42~",
    "S41~",
    "S40~",
    "S39~",
    "S38~",
    "S37~",
    "S36~",
    "S35~",
    "S34~",
    "S33~",
    "S32~",
    "S31~",
    "S30~",
    "S29~",
    "S28~",
    "S27~",
    "S26~",
    "P46~",
    "P45~",
    "P44~",
    "P43~",
    "P42~",
    "P41~",
    "P40~",
    "P39~",
    "P38~",
    "P37~",
    "P36~",
    "P35~",
    "P34~",
    "P33~",
    "P32~",
    "P31~",
    "P30~",
    "P29~",
    "P28~",
    "P27~",
    "P26~",
    "P25~",
    "P24~",
    "Si42~",
    "Si41~",
    "Si40~",
    "Si39~",
    "Si38~",
    "Si37~",
    "Si36~",
    "Si35~",
    "Si34~",
    "Si33~",
    "Si32~",
    "Si31~",
    "Si30~",
    "Si29~",
    "Si28~",
    "Si27~",
    "Si26~",
    "Si25~",
    "Si24~",
    "Si23~",
    "Si22~",
    "Al39~",
    "Al38~",
    "Al37~",
    "Al36~",
    "Al35~",
    "Al34~",
    "Al33~",
    "Al32~",
    "Al31~",
    "Al30~",
    "Al29~",
    "Al28~",
    "Al27~",
    "Al26~",
    "Al25~",
    "Al24~",
    "Al23~",
    "Al22~",
    "Al21~",
    "Mg37~",
    "Mg36~",
    "Mg35~",
    "Mg34~",
    "Mg33~",
    "Mg32~",
    "Mg31~",
    "Mg30~",
    "Mg29~",
    "Mg28~",
    "Mg27~",
    "Mg26~",
    "Mg25~",
    "Mg24~",
    "Mg23~",
    "Mg22~",
    "Mg21~",
    "Mg20~",
    "Na35~",
    "Na34~",
    "Na33~",
    "Na32~",
    "Na31~",
    "Na30~",
    "Na29~",
    "Na28~",
    "Na27~",
    "Na26~",
    "Na25~",
    "Na24~",
    "Na23~",
    "Na22~",
    "Na21~",
    "Na20~",
    "Na19~",
    "Na18~",
    "Ne32~",
    "Ne31~",
    "Ne30~",
    "Ne29~",
    "Ne28~",
    "Ne27~",
    "Ne26~",
    "Ne25~",
    "Ne24~",
    "Ne23~",
    "Ne22~",
    "Ne21~",
    "Ne20~",
    "Ne19~",
    "Ne18~",
    "Ne17~",
    "Ne16~",
    "F29~",
    "F28~",
    "F27~",
    "F26~",
    "F25~",
    "F24~",
    "F23~",
    "F22~",
    "F21~",
    "F20~",
    "F19~",
    "F18~",
    "F17~",
    "F16~",
    "F15~",
    "F14~",
    "O26~",
    "O25~",
    "O24~",
    "O23~",
    "O22~",
    "O21~",
    "O20~",
    "O19~",
    "O18~",
    "O17~",
    "O16~",
    "O15~",
    "O14~",
    "O13~",
    "O12~",
    "N24~",
    "N23~",
    "N22~",
    "N21~",
    "N20~",
    "N19~",
    "N18~",
    "N17~",
    "N16~",
    "N15~",
    "N14~",
    "N13~",
    "N12~",
    "N11~",
    "N10~",
    "C22~",
    "C21~",
    "C20~",
    "C19~",
    "C18~",
    "C17~",
    "C16~",
    "C15~",
    "C14~",
    "C13~",
    "C12~",
    "C11~",
    "C10~",
    "C9~",
    "C8~",
    "B19~",
    "B18~",
    "B17~",
    "B16~",
    "B15~",
    "B14~",
    "B13~",
    "B12~",
    "B11~",
    "B10~",
    "B9~",
    "B8~",
    "B7~",
    "Be14~",
    "Be13~",
    "Be12~",
    "Be11~",
    "Be10~",
    "Be9~",
    "Be8~",
    "Be7~",
    "Be6~",
    "Be5~",
    "Li12~",
    "Li11~",
    "Li10~",
    "Li9~",
    "Li8~",
    "Li7~",
    "Li6~",
    "Li5~",
    "Li4~",
    "He10~",
    "He9~",
    "He8~",
    "He7~",
    "He6~",
    "He5~",
    "He4~",
    "He3~",
    "H6~",
    "H5~",
    "H4~",
    "T3~",
    "D2~",
    "p~",
    "n~",
    "K(2)(2250)-",
    "K(0)*(1950)-",
    "a(1)(1640)-",
    "K(3)(2320)-",
    "K(2)*(1980)-",
    "K(1830)-",
    "K(2)*(1980)~0",
    "pi(1)(1600)-",
    "pi(1800)-",
    "K(4)(2500)-",
    "K(2)(1580)-",
    "K(1)(1650)-",
    "K(0)*(700)-",
    "K(1)(1650)~0",
    "K(0)*(700)~0",
    "a(2)(1700)-",
    "pi(1)(1400)-",
    "a(0)(980)-",
    "Lambda(c)(2880)~-",
    "Omega(2250)~+",
    "Xi(2030)~0",
    "Xi(1690)~0",
    "Xi(2030)~+",
    "Xi(1690)~+",
    "Xi(c)(2790)~-",
    "Xi(c)(2815)~-",
    "Xi(c)(2790)~0",
    "Xi(c)(2815)~0",
    "Lambda(c)(2625)~-",
    "Xi(1950)~0",
    "Xi(1950)~+",
    "K*(1410)-",
    "K(1460)-",
    "K*(1410)~0",
    "rho(1450)-",
    "pi(1300)-",
    "Lambda(1810)~",
    "Lambda(1800)~",
    "N(1710)~-",
    "N(1710)~0",
    "Lambda(1670)~",
    "Delta(1600)~--",
    "Delta(1600)~-",
    "N(1650)~-",
    "N(1720)~-",
    "Delta(1600)~0",
    "N(1650)~0",
    "N(1720)~0",
    "Delta(1600)~+",
    "K*(1680)-",
    "K*(1680)~0",
    "rho(1700)-",
    "Sigma(1910)~-",
    "Sigma(1750)~-",
    "Sigma(1910)~0",
    "Sigma(1750)~0",
    "Lambda(2110)~",
    "Lambda(1890)~",
    "Lambda(1600)~",
    "Sigma(1910)~+",
    "Sigma(1750)~+",
    "Delta(1920)~--",
    "Delta(1910)~--",
    "Delta(1920)~-",
    "N(1535)~-",
    "N(1700)~-",
    "Delta(1910)~-",
    "Delta(1920)~0",
    "N(1535)~0",
    "N(1700)~0",
    "Delta(1910)~0",
    "Delta(1920)~+",
    "Delta(1910)~+",
    "D(s1)(2460)-",
    "D(1)(2430)~0",
    "K(2)(1820)-",
    "K(1)(1400)-",
    "K(2)(1820)~0",
    "K(1)(1400)~0",
    "a(1)(1260)-",
    "Lambda(c)(2595)~-",
    "Xi(1820)~0",
    "Xi(1820)~+",
    "Sigma(1915)~-",
    "Sigma(1670)~-",
    "Sigma(1660)~-",
    "Sigma(1915)~0",
    "Sigma(1670)~0",
    "Sigma(1660)~0",
    "Lambda(1830)~",
    "Lambda(1690)~",
    "Lambda(1405)~",
    "Sigma(1915)~+",
    "Sigma(1670)~+",
    "Sigma(1660)~+",
    "Delta(1930)~--",
    "Delta(1700)~--",
    "Delta(1900)~--",
    "N(1680)~-",
    "Delta(1700)~-",
    "N(1440)~-",
    "Delta(1930)~-",
    "Delta(1900)~-",
    "N(1680)~0",
    "Delta(1700)~0",
    "N(1440)~0",
    "Delta(1930)~0",
    "Delta(1900)~0",
    "Delta(1930)~+",
    "Delta(1700)~+",
    "Delta(1900)~+",
    "D(s1)(2536)-",
    "D(s0)*(2317)-",
    "D(1)(2420)~0",
    "D(0)*(2300)~0",
    "D(1)(2420)-",
    "D(0)*(2300)-",
    "K(2)(1770)-",
    "K(1)(1270)-",
    "K(0)*(1430)-",
    "K(2)(1770)~0",
    "K(1)(1270)~0",
    "K(0)*(1430)~0",
    "pi(2)(1670)-",
    "b(1)(1235)-",
    "a(0)(1450)-",
    "(bb)(1)~",
    "(bc)(1)~",
    "(bc)(0)~",
    "Omega(b)~+",
    "(bs)(1)~",
    "(bs)(0)~",
    "Xi(b)~0",
    "Sigma(b)*~-",
    "Sigma(b)~-",
    "(bu)(1)~",
    "(bu)(0)~",
    "Xi(b)~+",
    "Lambda(b)~0",
    "Sigma(b)*~+",
    "Sigma(b)~+",
    "(bd)(1)~",
    "(bd)(0)~",
    "(cc)(1)~",
    "Omega(c)(2770)~0",
    "Omega(c)~0",
    "Xi(c)(2645)~-",
    "Xi(c)'~-",
    "Xi(c)(2645)~0",
    "Xi(c)'~0",
    "(cs)(1)~",
    "(cs)(0)~",
    "Xi(c)~-",
    "Sigma(c)(2520)~--",
    "Sigma(c)(2455)~--",
    "Sigma(c)(2520)~-",
    "Sigma(c)(2455)~-",
    "(cu)(1)~",
    "(cu)(0)~",
    "Xi(c)~0",
    "Lambda(c)~-",
    "Sigma(c)(2520)~0",
    "Sigma(c)(2455)~0",
    "(cd)(1)~",
    "(cd)(0)~",
    "Omega~+",
    "Xi(1530)~0",
    "Xi~0",
    "Xi(1530)~+",
    "Xi~+",
    "(ss)(1)~",
    "Sigma(2030)~-",
    "Sigma(1775)~-",
    "Sigma(1385)~-",
    "Sigma~-",
    "Sigma(2030)~0",
    "Sigma(1775)~0",
    "Sigma(1385)~0",
    "Sigma~0",
    "(su)(1)~",
    "(su)(0)~",
    "Lambda(2100)~",
    "Lambda(1820)~",
    "Lambda(1520)~",
    "Lambda~",
    "Sigma(2030)~+",
    "Sigma(1775)~+",
    "Sigma(1385)~+",
    "Sigma~+",
    "(sd)(1)~",
    "(sd)(0)~",
    "Delta(1950)~--",
    "Delta(1905)~--",
    "Delta(1232)~--",
    "Delta(1620)~--",
    "Delta(1950)~-",
    "N(1675)~-",
    "Delta(1232)~-",
    "p~",
    "(uu)(1)~",
    "N(2190)~-",
    "Delta(1905)~-",
    "N(1520)~-",
    "Delta(1620)~-",
    "Delta(1950)~0",
    "N(1675)~0",
    "Delta(1232)~0",
    "n~",
    "(ud)(1)~",
    "(ud)(0)~",
    "N(2190)~0",
    "Delta(1905)~0",
    "N(1520)~0",
    "Delta(1620)~0",
    "Delta(1950)~+",
    "Delta(1905)~+",
    "Delta(1232)~+",
    "Delta(1620)~+",
    "(dd)(1)~",
    "B(c)-",
    "B(s2)*(5840)~0",
    "B(s)*~0",
    "B(s)~0",
    "B(2)*(5747)-",
    "B*-",
    "B-",
    "B(2)*(5747)~0",
    "B*~0",
    "B~0",
    "D(s2)*(2573)-",
    "D(s)*-",
    "D(s)-",
    "D(2)*(2460)~0",
    "D*(2007)~0",
    "D~0",
    "D(2)*(2460)-",
    "D*(2010)-",
    "D-",
    "K(4)*(2045)-",
    "K(3)*(1780)-",
    "K(2)*(1430)-",
    "K*(892)-",
    "K-",
    "K(4)*(2045)~0",
    "K(3)*(1780)~0",
    "K(2)*(1430)~0",
    "K*(892)~0",
    "K~0",
    "a(4)(1970)-",
    "rho(3)(1690)-",
    "a(2)(1320)-",
    "rho(770)-",
    "pi-",
    "W-",
    "nu(tau')~",
    "tau'+",
    "nu(tau)~",
    "tau+",
    "nu(mu)~",
    "mu+",
    "nu(e)~",
    "e+",
    "t~",
    "b~",
    "c~",
    "s~",
    "u~",
    "d~",
    "d",
    "u",
    "s",
    "c",
    "b",
    "t",
    "e-",
    "nu(e)",
    "mu-",
    "nu(mu)",
    "tau-",
    "nu(tau)",
    "tau'-",
    "nu(tau')",
    "g",
    "gamma",
    "Z0",
    "W+",
    "H0",
    "pi0",
    "rho(770)0",
    "a(2)(1320)0",
    "rho(3)(1690)0",
    "a(4)(1970)0",
    "K(L)0",
    "pi+",
    "rho(770)+",
    "a(2)(1320)+",
    "rho(3)(1690)+",
    "a(4)(1970)+",
    "eta",
    "omega(782)",
    "f(2)(1270)",
    "omega(3)(1670)",
    "f(4)(2050)",
    "K(S)0",
    "K0",
    "K*(892)0",
    "K(2)*(1430)0",
    "K(3)*(1780)0",
    "K(4)*(2045)0",
    "K+",
    "K*(892)+",
    "K(2)*(1430)+",
    "K(3)*(1780)+",
    "K(4)*(2045)+",
    "eta'(958)",
    "phi(1020)",
    "f(2)'(1525)",
    "phi(3)(1850)",
    "D+",
    "D*(2010)+",
    "D(2)*(2460)+",
    "D0",
    "D*(2007)0",
    "D(2)*(2460)0",
    "D(s)+",
    "D(s)*+",
    "D(s2)*(2573)+",
    "eta(c)(1S)",
    "J/psi(1S)",
    "chi(c2)(1P)",
    "B0",
    "B*0",
    "B(2)*(5747)0",
    "B+",
    "B*+",
    "B(2)*(5747)+",
    "B(s)0",
    "B(s)*0",
    "B(s2)*(5840)0",
    "B(c)+",
    "eta(b)(1S)",
    "Upsilon(1S)",
    "chi(b2)(1P)",
    "(dd)(1)",
    "Delta(1620)-",
    "Delta(1232)-",
    "Delta(1905)-",
    "Delta(1950)-",
    "Delta(1620)0",
    "N(1520)0",
    "Delta(1905)0",
    "N(2190)0",
    "(ud)(0)",
    "(ud)(1)",
    "n",
    "Delta(1232)0",
    "N(1675)0",
    "Delta(1950)0",
    "Delta(1620)+",
    "N(1520)+",
    "Delta(1905)+",
    "N(2190)+",
    "(uu)(1)",
    "p",
    "Delta(1232)+",
    "N(1675)+",
    "Delta(1950)+",
    "Delta(1620)++",
    "Delta(1232)++",
    "Delta(1905)++",
    "Delta(1950)++",
    "(sd)(0)",
    "(sd)(1)",
    "Sigma-",
    "Sigma(1385)-",
    "Sigma(1775)-",
    "Sigma(2030)-",
    "Lambda",
    "Lambda(1520)",
    "Lambda(1820)",
    "Lambda(2100)",
    "(su)(0)",
    "(su)(1)",
    "Sigma0",
    "Sigma(1385)0",
    "Sigma(1775)0",
    "Sigma(2030)0",
    "Sigma+",
    "Sigma(1385)+",
    "Sigma(1775)+",
    "Sigma(2030)+",
    "(ss)(1)",
    "Xi-",
    "Xi(1530)-",
    "Xi0",
    "Xi(1530)0",
    "Omega-",
    "(cd)(0)",
    "(cd)(1)",
    "Sigma(c)(2455)0",
    "Sigma(c)(2520)0",
    "Lambda(c)+",
    "Xi(c)0",
    "(cu)(0)",
    "(cu)(1)",
    "Sigma(c)(2455)+",
    "Sigma(c)(2520)+",
    "Sigma(c)(2455)++",
    "Sigma(c)(2520)++",
    "Xi(c)+",
    "(cs)(0)",
    "(cs)(1)",
    "Xi(c)'0",
    "Xi(c)(2645)0",
    "Xi(c)'+",
    "Xi(c)(2645)+",
    "Omega(c)0",
    "Omega(c)(2770)0",
    "(cc)(1)",
    "(bd)(0)",
    "(bd)(1)",
    "Sigma(b)-",
    "Sigma(b)*-",
    "Lambda(b)0",
    "Xi(b)-",
    "(bu)(0)",
    "(bu)(1)",
    "Sigma(b)+",
    "Sigma(b)*+",
    "Xi(b)0",
    "(bs)(0)",
    "(bs)(1)",
    "Omega(b)-",
    "(bc)(0)",
    "(bc)(1)",
    "(bb)(1)",
    "a(0)(1450)0",
    "b(1)(1235)0",
    "pi(2)(1670)0",
    "a(0)(1450)+",
    "b(1)(1235)+",
    "pi(2)(1670)+",
    "f(0)(1370)",
    "h(1)(1170)",
    "eta(2)(1645)",
    "K(0)*(1430)0",
    "K(1)(1270)0",
    "K(2)(1770)0",
    "K(0)*(1430)+",
    "K(1)(1270)+",
    "K(2)(1770)+",
    "f(0)(1710)",
    "h(1)(1415)",
    "eta(2)(1870)",
    "D(0)*(2300)+",
    "D(1)(2420)+",
    "D(0)*(2300)0",
    "D(1)(2420)0",
    "D(s0)*(2317)+",
    "D(s1)(2536)+",
    "chi(c0)(1P)",
    "h(c)(1P)",
    "chi(b0)(1P)",
    "h(b)(1P)",
    "Delta(1900)-",
    "Delta(1700)-",
    "Delta(1930)-",
    "Delta(1900)0",
    "Delta(1930)0",
    "N(1440)0",
    "Delta(1700)0",
    "N(1680)0",
    "Delta(1900)+",
    "Delta(1930)+",
    "N(1440)+",
    "Delta(1700)+",
    "N(1680)+",
    "Delta(1900)++",
    "Delta(1700)++",
    "Delta(1930)++",
    "Sigma(1660)-",
    "Sigma(1670)-",
    "Sigma(1915)-",
    "Lambda(1405)",
    "Lambda(1690)",
    "Lambda(1830)",
    "Sigma(1660)0",
    "Sigma(1670)0",
    "Sigma(1915)0",
    "Sigma(1660)+",
    "Sigma(1670)+",
    "Sigma(1915)+",
    "Xi(1820)-",
    "Xi(1820)0",
    "Lambda(c)(2595)+",
    "a(1)(1260)0",
    "a(1)(1260)+",
    "f(1)(1285)",
    "K(1)(1400)0",
    "K(2)(1820)0",
    "K(1)(1400)+",
    "K(2)(1820)+",
    "f(1)(1420)",
    "D(1)(2430)0",
    "D(s1)(2460)+",
    "chi(c1)(1P)",
    "chi(b1)(1P)",
    "Upsilon(2)(1D)",
    "Delta(1910)-",
    "Delta(1920)-",
    "Delta(1910)0",
    "N(1700)0",
    "N(1535)0",
    "Delta(1920)0",
    "Delta(1910)+",
    "N(1700)+",
    "N(1535)+",
    "Delta(1920)+",
    "Delta(1910)++",
    "Delta(1920)++",
    "Sigma(1750)-",
    "Sigma(1910)-",
    "Lambda(1600)",
    "Lambda(1890)",
    "Lambda(2110)",
    "Sigma(1750)0",
    "Sigma(1910)0",
    "Sigma(1750)+",
    "Sigma(1910)+",
    "rho(1700)0",
    "rho(1700)+",
    "omega(1650)",
    "K*(1680)0",
    "K*(1680)+",
    "psi(3770)",
    "Delta(1600)-",
    "N(1720)0",
    "N(1650)0",
    "Delta(1600)0",
    "N(1720)+",
    "N(1650)+",
    "Delta(1600)+",
    "Delta(1600)++",
    "Lambda(1670)",
    "N(1710)0",
    "N(1710)+",
    "Lambda(1800)",
    "Lambda(1810)",
    "pi(1300)0",
    "rho(1450)0",
    "pi(1300)+",
    "rho(1450)+",
    "eta(1295)",
    "omega(1420)",
    "K*(1410)0",
    "K(1460)+",
    "K*(1410)+",
    "eta(1475)",
    "phi(1680)",
    "eta(c)(2S)",
    "psi(2S)",
    "chi(c2)(3930)",
    "Upsilon(2S)",
    "chi(b2)(2P)",
    "Xi(1950)-",
    "Xi(1950)0",
    "Lambda(c)(2625)+",
    "Xi(c)(2815)0",
    "Xi(c)(2790)0",
    "Xi(c)(2815)+",
    "Xi(c)(2790)+",
    "chi(b0)(2P)",
    "h(b)(2P)",
    "chi(b1)(2P)",
    "Upsilon(3S)",
    "chi(b2)(3P)",
    "Xi(1690)-",
    "Xi(2030)-",
    "Xi(1690)0",
    "Xi(2030)0",
    "Omega(2250)-",
    "Lambda(c)(2880)+",
    "chi(b1)(3P)",
    "Upsilon(4S)",
    "a(0)(980)0",
    "pi(1)(1400)0",
    "a(2)(1700)0",
    "a(0)(980)+",
    "pi(1)(1400)+",
    "a(2)(1700)+",
    "f(0)(500)",
    "K(0)*(700)0",
    "K(1)(1650)0",
    "K(0)*(700)+",
    "K(1)(1650)+",
    "K(2)(1580)+",
    "K(4)(2500)+",
    "psi(4040)",
    "Upsilon(10860)",
    "pi(1800)0",
    "pi(1)(1600)0",
    "pi(1800)+",
    "pi(1)(1600)+",
    "f(0)(980)",
    "K(2)*(1980)0",
    "K(1830)+",
    "K(2)*(1980)+",
    "K(3)(2320)+",
    "psi(4160)",
    "Upsilon(11020)",
    "a(1)(1640)0",
    "a(1)(1640)+",
    "eta(1405)",
    "K(0)*(1950)+",
    "K(2)(2250)+",
    "psi(4415)",
    "f(0)(1500)",
    "f(0)(2020)",
    "f(2)(1950)",
    "f(2)(2010)",
    "f(2)(2300)",
    "f(2)(2340)",
    "n",
    "p",
    "D2",
    "T3",
    "H4",
    "H5",
    "H6",
    "He3",
    "He4",
    "He5",
    "He6",
    "He7",
    "He8",
    "He9",
    "He10",
    "Li4",
    "Li5",
    "Li6",
    "Li7",
    "Li8",
    "Li9",
    "Li10",
    "Li11",
    "Li12",
    "Be5",
    "Be6",
    "Be7",
    "Be8",
    "Be9",
    "Be10",
    "Be11",
    "Be12",
    "Be13",
    "Be14",
    "B7",
    "B8",
    "B9",
    "B10",
    "B11",
    "B12",
    "B13",
    "B14",
    "B15",
    "B16",
    "B17",
    "B18",
    "B19",
    "C8",
    "C9",
    "C10",
    "C11",
    "C12",
    "C13",
    "C14",
    "C15",
    "C16",
    "C17",
    "C18",
    "C19",
    "C20",
    "C21",
    "C22",
    "N10",
    "N11",
    "N12",
    "N13",
    "N14",
    "N15",
    "N16",
    "N17",
    "N18",
    "N19",
    "N20",
    "N21",
    "N22",
    "N23",
    "N24",
    "O12",
    "O13",
    "O14",
    "O15",
    "O16",
    "O17",
    "O18",
    "O19",
    "O20",
    "O21",
    "O22",
    "O23",
    "O24",
    "O25",
    "O26",
    "F14",
    "F15",
    "F16",
    "F17",
    "F18",
    "F19",
    "F20",
    "F21",
    "F22",
    "F23",
    "F24",
    "F25",
    "F26",
    "F27",
    "F28",
    "F29",
    "Ne16",
    "Ne17",
    "Ne18",
    "Ne19",
    "Ne20",
    "Ne21",
    "Ne22",
    "Ne23",
    "Ne24",
    "Ne25",
    "Ne26",
    "Ne27",
    "Ne28",
    "Ne29",
    "Ne30",
    "Ne31",
    "Ne32",
    "Na18",
    "Na19",
    "Na20",
    "Na21",
    "Na22",
    "Na23",
    "Na24",
    "Na25",
    "Na26",
    "Na27",
    "Na28",
    "Na29",
    "Na30",
    "Na31",
    "Na32",
    "Na33",
    "Na34",
    "Na35",
    "Mg20",
    "Mg21",
    "Mg22",
    "Mg23",
    "Mg24",
    "Mg25",
    "Mg26",
    "Mg27",
    "Mg28",
    "Mg29",
    "Mg30",
    "Mg31",
    "Mg32",
    "Mg33",
    "Mg34",
    "Mg35",
    "Mg36",
    "Mg37",
    "Al21",
    "Al22",
    "Al23",
    "Al24",
    "Al25",
    "Al26",
    "Al27",
    "Al28",
    "Al29",
    "Al30",
    "Al31",
    "Al32",
    "Al33",
    "Al34",
    "Al35",
    "Al36",
    "Al37",
    "Al38",
    "Al39",
    "Si22",
    "Si23",
    "Si24",
    "Si25",
    "Si26",
    "Si27",
    "Si28",
    "Si29",
    "Si30",
    "Si31",
    "Si32",
    "Si33",
    "Si34",
    "Si35",
    "Si36",
    "Si37",
    "Si38",
    "Si39",
    "Si40",
    "Si41",
    "Si42",
    "P24",
    "P25",
    "P26",
    "P27",
    "P28",
    "P29",
    "P30",
    "P31",
    "P32",
    "P33",
    "P34",
    "P35",
    "P36",
    "P37",
    "P38",
    "P39",
    "P40",
    "P41",
    "P42",
    "P43",
    "P44",
    "P45",
    "P46",
    "S26",
    "S27",
    "S28",
    "S29",
    "S30",
    "S31",
    "S32",
    "S33",
    "S34",
    "S35",
    "S36",
    "S37",
    "S38",
    "S39",
    "S40",
    "S41",
    "S42",
    "S43",
    "S44",
    "S45",
    "S46",
    "S47",
    "S48",
    "S49",
    "Cl28",
    "Cl29",
    "Cl30",
    "Cl31",
    "Cl32",
    "Cl33",
    "Cl34",
    "Cl35",
    "Cl36",
    "Cl37",
    "Cl38",
    "Cl39",
    "Cl40",
    "Cl41",
    "Cl42",
    "Cl43",
    "Cl44",
    "Cl45",
    "Cl46",
    "Cl47",
    "Cl48",
    "Cl49",
    "Cl50",
    "Cl51",
    "Ar30",
    "Ar31",
    "Ar32",
    "Ar33",
    "Ar34",
    "Ar35",
    "Ar36",
    "Ar37",
    "Ar38",
    "Ar39",
    "Ar40",
    "Ar41",
    "Ar42",
    "Ar43",
    "Ar44",
    "Ar45",
    "Ar46",
    "Ar47",
    "Ar48",
    "Ar49",
    "Ar50",
    "Ar51",
    "Ar52",
    "Ar53",
    "K32",
    "K33",
    "K34",
    "K35",
    "K36",
    "K37",
    "K38",
    "K39",
    "K40",
    "K41",
    "K42",
    "K43",
    "K44",
    "K45",
    "K46",
    "K47",
    "K48",
    "K49",
    "K50",
    "K51",
    "K52",
    "K53",
    "K54",
    "K55",
    "Ca34",
    "Ca35",
    "Ca36",
    "Ca37",
    "Ca38",
    "Ca39",
    "Ca40",
    "Ca41",
    "Ca42",
    "Ca43",
    "Ca44",
    "Ca45",
    "Ca46",
    "Ca47",
    "Ca48",
    "Ca49",
    "Ca50",
    "Ca51",
    "Ca52",
    "Ca53",
    "Ca54",
    "Ca55",
    "Ca56",
    "Ca57",
    "Sc36",
    "Sc37",
    "Sc38",
    "Sc39",
    "Sc40",
    "Sc41",
    "Sc42",
    "Sc43",
    "Sc44",
    "Sc45",
    "Sc46",
    "Sc47",
    "Sc48",
    "Sc49",
    "Sc50",
    "Sc51",
    "Sc52",
    "Sc53",
    "Sc54",
    "Sc55",
    "Sc56",
    "Sc57",
    "Sc58",
    "Sc59",
    "Ti38",
    "Ti39",
    "Ti40",
    "Ti41",
    "Ti42",
    "Ti43",
    "Ti44",
    "Ti45",
    "Ti46",
    "Ti47",
    "Ti48",
    "Ti49",
    "Ti50",
    "Ti51",
    "Ti52",
    "Ti53",
    "Ti54",
    "Ti55",
    "Ti56",
    "Ti57",
    "Ti58",
    "Ti59",
    "Ti60",
    "Ti61",
    "V40",
    "V41",
    "V42",
    "V43",
    "V44",
    "V45",
    "V46",
    "V47",
    "V48",
    "V49",
    "V50",
    "V51",
    "V52",
    "V53",
    "V54",
    "V55",
    "V56",
    "V57",
    "V58",
    "V59",
    "V60",
    "V61",
    "V62",
    "V63",
    "Cr42",
    "Cr43",
    "Cr44",
    "Cr45",
    "Cr46",
    "Cr47",
    "Cr48",
    "Cr49",
    "Cr50",
    "Cr51",
    "Cr52",
    "Cr53",
    "Cr54",
    "Cr55",
    "Cr56",
    "Cr57",
    "Cr58",
    "Cr59",
    "Cr60",
    "Cr61",
    "Cr62",
    "Cr63",
    "Cr64",
    "Cr65",
    "Mn44",
    "Mn45",
    "Mn46",
    "Mn47",
    "Mn48",
    "Mn49",
    "Mn50",
    "Mn51",
    "Mn52",
    "Mn53",
    "Mn54",
    "Mn55",
    "Mn56",
    "Mn57",
    "Mn58",
    "Mn59",
    "Mn60",
    "Mn61",
    "Mn62",
    "Mn63",
    "Mn64",
    "Mn65",
    "Mn66",
    "Mn67",
    "Fe45",
    "Fe46",
    "Fe47",
    "Fe48",
    "Fe49",
    "Fe50",
    "Fe51",
    "Fe52",
    "Fe53",
    "Fe54",
    "Fe55",
    "Fe56",
    "Fe57",
    "Fe58",
    "Fe59",
    "Fe60",
    "Fe61",
    "Fe62",
    "Fe63",
    "Fe64",
    "Fe65",
    "Fe66",
    "Fe67",
    "Fe68",
    "Fe69",
    "Co48",
    "Co49",
    "Co50",
    "Co51",
    "Co52",
    "Co53",
    "Co54",
    "Co55",
    "Co56",
    "Co57",
    "Co58",
    "Co59",
    "Co60",
    "Co61",
    "Co62",
    "Co63",
    "Co64",
    "Co65",
    "Co66",
    "Co67",
    "Co68",
    "Co69",
    "Co70",
    "Co71",
    "Co72",
    "Ni50",
    "Ni51",
    "Ni52",
    "Ni53",
    "Ni54",
    "Ni55",
    "Ni56",
    "Ni57",
    "Ni58",
    "Ni59",
    "Ni60",
    "Ni61",
    "Ni62",
    "Ni63",
    "Ni64",
    "Ni65",
    "Ni66",
    "Ni67",
    "Ni68",
    "Ni69",
    "Ni70",
    "Ni71",
    "Ni72",
    "Ni73",
    "Ni74",
    "Ni75",
    "Ni76",
    "Ni77",
    "Ni78",
    "Cu52",
    "Cu53",
    "Cu54",
    "Cu55",
    "Cu56",
    "Cu57",
    "Cu58",
    "Cu59",
    "Cu60",
    "Cu61",
    "Cu62",
    "Cu63",
    "Cu64",
    "Cu65",
    "Cu66",
    "Cu67",
    "Cu68",
    "Cu69",
    "Cu70",
    "Cu71",
    "Cu72",
    "Cu73",
    "Cu74",
    "Cu75",
    "Cu76",
    "Cu77",
    "Cu78",
    "Cu79",
    "Cu80",
    "Zn54",
    "Zn55",
    "Zn56",
    "Zn57",
    "Zn58",
    "Zn59",
    "Zn60",
    "Zn61",
    "Zn62",
    "Zn63",
    "Zn64",
    "Zn65",
    "Zn66",
    "Zn67",
    "Zn68",
    "Zn69",
    "Zn70",
    "Zn71",
    "Zn72",
    "Zn73",
    "Zn74",
    "Zn75",
    "Zn76",
    "Zn77",
    "Zn78",
    "Zn79",
    "Zn80",
    "Zn81",
    "Zn82",
    "Ga56",
    "Ga57",
    "Ga58",
    "Ga59",
    "Ga60",
    "Ga61",
    "Ga62",
    "Ga63",
    "Ga64",
    "Ga65",
    "Ga66",
    "Ga67",
    "Ga68",
    "Ga69",
    "Ga70",
    "Ga71",
    "Ga72",
    "Ga73",
    "Ga74",
    "Ga75",
    "Ga76",
    "Ga77",
    "Ga78",
    "Ga79",
    "Ga80",
    "Ga81",
    "Ga82",
    "Ga83",
    "Ga84",
    "Ge58",
    "Ge59",
    "Ge60",
    "Ge61",
    "Ge62",
    "Ge63",
    "Ge64",
    "Ge65",
    "Ge66",
    "Ge67",
    "Ge68",
    "Ge69",
    "Ge70",
    "Ge71",
    "Ge72",
    "Ge73",
    "Ge74",
    "Ge75",
    "Ge76",
    "Ge77",
    "Ge78",
    "Ge79",
    "Ge80",
    "Ge81",
    "Ge82",
    "Ge83",
    "Ge84",
    "Ge85",
    "Ge86",
    "As60",
    "As61",
    "As62",
    "As63",
    "As64",
    "As65",
    "As66",
    "As67",
    "As68",
    "As69",
    "As70",
    "As71",
    "As72",
    "As73",
    "As74",
    "As75",
    "As76",
    "As77",
    "As78",
    "As79",
    "As80",
    "As81",
    "As82",
    "As83",
    "As84",
    "As85",
    "As86",
    "As87",
    "As88",
    "As89",
    "Se65",
    "Se66",
    "Se67",
    "Se68",
    "Se69",
    "Se70",
    "Se71",
    "Se72",
    "Se73",
    "Se74",
    "Se75",
    "Se76",
    "Se77",
    "Se78",
    "Se79",
    "Se80",
    "Se81",
    "Se82",
    "Se83",
    "Se84",
    "Se85",
    "Se86",
    "Se87",
    "Se88",
    "Se89",
    "Se90",
    "Se91",
    "Se92",
    "Br67",
    "Br68",
    "Br69",
    "Br70",
    "Br71",
    "Br72",
    "Br73",
    "Br74",
    "Br75",
    "Br76",
    "Br77",
    "Br78",
    "Br79",
    "Br80",
    "Br81",
    "Br82",
    "Br83",
    "Br84",
    "Br85",
    "Br86",
    "Br87",
    "Br88",
    "Br89",
    "Br90",
    "Br91",
    "Br92",
    "Br93",
    "Br94",
    "Kr69",
    "Kr70",
    "Kr71",
    "Kr72",
    "Kr73",
    "Kr74",
    "Kr75",
    "Kr76",
    "Kr77",
    "Kr78",
    "Kr79",
    "Kr80",
    "Kr81",
    "Kr82",
    "Kr83",
    "Kr84",
    "Kr85",
    "Kr86",
    "Kr87",
    "Kr88",
    "Kr89",
    "Kr90",
    "Kr91",
    "Kr92",
    "Kr93",
    "Kr94",
    "Kr95",
    "Kr96",
    "Kr97",
    "Rb71",
    "Rb72",
    "Rb73",
    "Rb74",
    "Rb75",
    "Rb76",
    "Rb77",
    "Rb78",
    "Rb79",
    "Rb80",
    "Rb81",
    "Rb82",
    "Rb83",
    "Rb84",
    "Rb85",
    "Rb86",
    "Rb87",
    "Rb88",
    "Rb89",
    "Rb90",
    "Rb91",
    "Rb92",
    "Rb93",
    "Rb94",
    "Rb95",
    "Rb96",
    "Rb97",
    "Rb98",
    "Rb99",
    "Rb100",
    "Rb101",
    "Rb102",
    "Sr73",
    "Sr74",
    "Sr75",
    "Sr76",
    "Sr77",
    "Sr78",
    "Sr79",
    "Sr80",
    "Sr81",
    "Sr82",
    "Sr83",
    "Sr84",
    "Sr85",
    "Sr86",
    "Sr87",
    "Sr88",
    "Sr89",
    "Sr90",
    "Sr91",
    "Sr92",
    "Sr93",
    "Sr94",
    "Sr95",
    "Sr96",
    "Sr97",
    "Sr98",
    "Sr99",
    "Sr100",
    "Sr101",
    "Sr102",
    "Sr103",
    "Sr104",
    "Y77",
    "Y78",
    "Y79",
    "Y80",
    "Y81",
    "Y82",
    "Y83",
    "Y84",
    "Y85",
    "Y86",
    "Y87",
    "Y88",
    "Y89",
    "Y90",
    "Y91",
    "Y92",
    "Y93",
    "Y94",
    "Y95",
    "Y96",
    "Y97",
    "Y98",
    "Y99",
    "Y100",
    "Y101",
    "Y102",
    "Y103",
    "Y104",
    "Y105",
    "Y106",
    "Zr79",
    "Zr80",
    "Zr81",
    "Zr82",
    "Zr83",
    "Zr84",
    "Zr85",
    "Zr86",
    "Zr87",
    "Zr88",
    "Zr89",
    "Zr90",
    "Zr91",
    "Zr92",
    "Zr93",
    "Zr94",
    "Zr95",
    "Zr96",
    "Zr97",
    "Zr98",
    "Zr99",
    "Zr100",
    "Zr101",
    "Zr102",
    "Zr103",
    "Zr104",
    "Zr105",
    "Zr106",
    "Zr107",
    "Zr108",
    "Nb81",
    "Nb82",
    "Nb83",
    "Nb84",
    "Nb85",
    "Nb86",
    "Nb87",
    "Nb88",
    "Nb89",
    "Nb90",
    "Nb91",
    "Nb92",
    "Nb93",
    "Nb94",
    "Nb95",
    "Nb96",
    "Nb97",
    "Nb98",
    "Nb99",
    "Nb100",
    "Nb101",
    "Nb102",
    "Nb103",
    "Nb104",
    "Nb105",
    "Nb106",
    "Nb107",
    "Nb108",
    "Nb109",
    "Nb110",
    "Mo83",
    "Mo84",
    "Mo85",
    "Mo86",
    "Mo87",
    "Mo88",
    "Mo89",
    "Mo90",
    "Mo91",
    "Mo92",
    "Mo93",
    "Mo94",
    "Mo95",
    "Mo96",
    "Mo97",
    "Mo98",
    "Mo99",
    "Mo100",
    "Mo101",
    "Mo102",
    "Mo103",
    "Mo104",
    "Mo105",
    "Mo106",
    "Mo107",
    "Mo108",
    "Mo109",
    "Mo110",
    "Mo111",
    "Mo112",
    "Mo113",
    "Tc85",
    "Tc86",
    "Tc87",
    "Tc88",
    "Tc89",
    "Tc90",
    "Tc91",
    "Tc92",
    "Tc93",
    "Tc94",
    "Tc95",
    "Tc96",
    "Tc97",
    "Tc98",
    "Tc99",
    "Tc100",
    "Tc101",
    "Tc102",
    "Tc103",
    "Tc104",
    "Tc105",
    "Tc106",
    "Tc107",
    "Tc108",
    "Tc109",
    "Tc110",
    "Tc111",
    "Tc112",
    "Tc113",
    "Tc114",
    "Tc115",
    "Ru87",
    "Ru88",
    "Ru89",
    "Ru90",
    "Ru91",
    "Ru92",
    "Ru93",
    "Ru94",
    "Ru95",
    "Ru96",
    "Ru97",
    "Ru98",
    "Ru99",
    "Ru100",
    "Ru101",
    "Ru102",
    "Ru103",
    "Ru104",
    "Ru105",
    "Ru106",
    "Ru107",
    "Ru108",
    "Ru109",
    "Ru110",
    "Ru111",
    "Ru112",
    "Ru113",
    "Ru114",
    "Ru115",
    "Ru116",
    "Ru117",
    "Ru118",
    "Rh89",
    "Rh90",
    "Rh91",
    "Rh92",
    "Rh93",
    "Rh94",
    "Rh95",
    "Rh96",
    "Rh97",
    "Rh98",
    "Rh99",
    "Rh100",
    "Rh101",
    "Rh102",
    "Rh103",
    "Rh104",
    "Rh105",
    "Rh106",
    "Rh107",
    "Rh108",
    "Rh109",
    "Rh110",
    "Rh111",
    "Rh112",
    "Rh113",
    "Rh114",
    "Rh115",
    "Rh116",
    "Rh117",
    "Rh118",
    "Rh119",
    "Rh120",
    "Rh121",
    "Pd91",
    "Pd92",
    "Pd93",
    "Pd94",
    "Pd95",
    "Pd96",
    "Pd97",
    "Pd98",
    "Pd99",
    "Pd100",
    "Pd101",
    "Pd102",
    "Pd103",
    "Pd104",
    "Pd105",
    "Pd106",
    "Pd107",
    "Pd108",
    "Pd109",
    "Pd110",
    "Pd111",
    "Pd112",
    "Pd113",
    "Pd114",
    "Pd115",
    "Pd116",
    "Pd117",
    "Pd118",
    "Pd119",
    "Pd120",
    "Pd121",
    "Pd122",
    "Pd123",
    "Ag94",
    "Ag95",
    "Ag96",
    "Ag97",
    "Ag98",
    "Ag99",
    "Ag100",
    "Ag101",
    "Ag102",
    "Ag103",
    "Ag104",
    "Ag105",
    "Ag106",
    "Ag107",
    "Ag108",
    "Ag109",
    "Ag110",
    "Ag111",
    "Ag112",
    "Ag113",
    "Ag114",
    "Ag115",
    "Ag116",
    "Ag117",
    "Ag118",
    "Ag119",
    "Ag120",
    "Ag121",
    "Ag122",
    "Ag123",
    "Ag124",
    "Ag125",
    "Ag126",
    "Ag127",
    "Cd96",
    "Cd97",
    "Cd98",
    "Cd99",
    "Cd100",
    "Cd101",
    "Cd102",
    "Cd103",
    "Cd104",
    "Cd105",
    "Cd106",
    "Cd107",
    "Cd108",
    "Cd109",
    "Cd110",
    "Cd111",
    "Cd112",
    "Cd113",
    "Cd114",
    "Cd115",
    "Cd116",
    "Cd117",
    "Cd118",
    "Cd119",
    "Cd120",
    "Cd121",
    "Cd122",
    "Cd123",
    "Cd124",
    "Cd125",
    "Cd126",
    "Cd127",
    "Cd128",
    "Cd129",
    "Cd130",
    "In98",
    "In99",
    "In100",
    "In101",
    "In102",
    "In103",
    "In104",
    "In105",
    "In106",
    "In107",
    "In108",
    "In109",
    "In110",
    "In111",
    "In112",
    "In113",
    "In114",
    "In115",
    "In116",
    "In117",
    "In118",
    "In119",
    "In120",
    "In121",
    "In122",
    "In123",
    "In124",
    "In125",
    "In126",
    "In127",
    "In128",
    "In129",
    "In130",
    "In131",
    "In132",
    "In133",
    "In134",
    "Sn100",
    "Sn101",
    "Sn102",
    "Sn103",
    "Sn104",
    "Sn105",
    "Sn106",
    "Sn107",
    "Sn108",
    "Sn109",
    "Sn110",
    "Sn111",
    "Sn112",
    "Sn113",
    "Sn114",
    "Sn115",
    "Sn116",
    "Sn117",
    "Sn118",
    "Sn119",
    "Sn120",
    "Sn121",
    "Sn122",
    "Sn123",
    "Sn124",
    "Sn125",
    "Sn126",
    "Sn127",
    "Sn128",
    "Sn129",
    "Sn130",
    "Sn131",
    "Sn132",
    "Sn133",
    "Sn134",
    "Sn135",
    "Sn136",
    "Sn137",
    "Sb103",
    "Sb104",
    "Sb105",
    "Sb106",
    "Sb107",
    "Sb108",
    "Sb109",
    "Sb110",
    "Sb111",
    "Sb112",
    "Sb113",
    "Sb114",
    "Sb115",
    "Sb116",
    "Sb117",
    "Sb118",
    "Sb119",
    "Sb120",
    "Sb121",
    "Sb122",
    "Sb123",
    "Sb124",
    "Sb125",
    "Sb126",
    "Sb127",
    "Sb128",
    "Sb129",
    "Sb130",
    "Sb131",
    "Sb132",
    "Sb133",
    "Sb134",
    "Sb135",
    "Sb136",
    "Sb137",
    "Sb138",
    "Sb139",
    "Te106",
    "Te107",
    "Te108",
    "Te109",
    "Te110",
    "Te111",
    "Te112",
    "Te113",
    "Te114",
    "Te115",
    "Te116",
    "Te117",
    "Te118",
    "Te119",
    "Te120",
    "Te121",
    "Te122",
    "Te123",
    "Te124",
    "Te125",
    "Te126",
    "Te127",
    "Te128",
    "Te129",
    "Te130",
    "Te131",
    "Te132",
    "Te133",
    "Te134",
    "Te135",
    "Te136",
    "Te137",
    "Te138",
    "Te139",
    "Te140",
    "Te141",
    "Te142",
    "I108",
    "I109",
    "I110",
    "I111",
    "I112",
    "I113",
    "I114",
    "I115",
    "I116",
    "I117",
    "I118",
    "I119",
    "I120",
    "I121",
    "I122",
    "I123",
    "I124",
    "I125",
    "I126",
    "I127",
    "I128",
    "I129",
    "I130",
    "I131",
    "I132",
    "I133",
    "I134",
    "I135",
    "I136",
    "I137",
    "I138",
    "I139",
    "I140",
    "I141",
    "I142",
    "I143",
    "I144",
    "Xe110",
    "Xe111",
    "Xe112",
    "Xe113",
    "Xe114",
    "Xe115",
    "Xe116",
    "Xe117",
    "Xe118",
    "Xe119",
    "Xe120",
    "Xe121",
    "Xe122",
    "Xe123",
    "Xe124",
    "Xe125",
    "Xe126",
    "Xe127",
    "Xe128",
    "Xe129",
    "Xe130",
    "Xe131",
    "Xe132",
    "Xe133",
    "Xe134",
    "Xe135",
    "Xe136",
    "Xe137",
    "Xe138",
    "Xe139",
    "Xe140",
    "Xe141",
    "Xe142",
    "Xe143",
    "Xe144",
    "Xe145",
    "Xe146",
    "Xe147",
    "Cs112",
    "Cs113",
    "Cs114",
    "Cs115",
    "Cs116",
    "Cs117",
    "Cs118",
    "Cs119",
    "Cs120",
    "Cs121",
    "Cs122",
    "Cs123",
    "Cs124",
    "Cs125",
    "Cs126",
    "Cs127",
    "Cs128",
    "Cs129",
    "Cs130",
    "Cs131",
    "Cs132",
    "Cs133",
    "Cs134",
    "Cs135",
    "Cs136",
    "Cs137",
    "Cs138",
    "Cs139",
    "Cs140",
    "Cs141",
    "Cs142",
    "Cs143",
    "Cs144",
    "Cs145",
    "Cs146",
    "Cs147",
    "Cs148",
    "Cs149",
    "Cs150",
    "Cs151",
    "Ba114",
    "Ba115",
    "Ba116",
    "Ba117",
    "Ba118",
    "Ba119",
    "Ba120",
    "Ba121",
    "Ba122",
    "Ba123",
    "Ba124",
    "Ba125",
    "Ba126",
    "Ba127",
    "Ba128",
    "Ba129",
    "Ba130",
    "Ba131",
    "Ba132",
    "Ba133",
    "Ba134",
    "Ba135",
    "Ba136",
    "Ba137",
    "Ba138",
    "Ba139",
    "Ba140",
    "Ba141",
    "Ba142",
    "Ba143",
    "Ba144",
    "Ba145",
    "Ba146",
    "Ba147",
    "Ba148",
    "Ba149",
    "Ba150",
    "Ba151",
    "Ba152",
    "Ba153",
    "La117",
    "La118",
    "La119",
    "La120",
    "La121",
    "La122",
    "La123",
    "La124",
    "La125",
    "La126",
    "La127",
    "La128",
    "La129",
    "La130",
    "La131",
    "La132",
    "La133",
    "La134",
    "La135",
    "La136",
    "La137",
    "La138",
    "La139",
    "La140",
    "La141",
    "La142",
    "La143",
    "La144",
    "La145",
    "La146",
    "La147",
    "La148",
    "La149",
    "La150",
    "La151",
    "La152",
    "La153",
    "La154",
    "La155",
    "Ce119",
    "Ce120",
    "Ce121",
    "Ce122",
    "Ce123",
    "Ce124",
    "Ce125",
    "Ce126",
    "Ce127",
    "Ce128",
    "Ce129",
    "Ce130",
    "Ce131",
    "Ce132",
    "Ce133",
    "Ce134",
    "Ce135",
    "Ce136",
    "Ce137",
    "Ce138",
    "Ce139",
    "Ce140",
    "Ce141",
    "Ce142",
    "Ce143",
    "Ce144",
    "Ce145",
    "Ce146",
    "Ce147",
    "Ce148",
    "Ce149",
    "Ce150",
    "Ce151",
    "Ce152",
    "Ce153",
    "Ce154",
    "Ce155",
    "Ce156",
    "Ce157",
    "Pr121",
    "Pr122",
    "Pr123",
    "Pr124",
    "Pr125",
    "Pr126",
    "Pr127",
    "Pr128",
    "Pr129",
    "Pr130",
    "Pr131",
    "Pr132",
    "Pr133",
    "Pr134",
    "Pr135",
    "Pr136",
    "Pr137",
    "Pr138",
    "Pr139",
    "Pr140",
    "Pr141",
    "Pr142",
    "Pr143",
    "Pr144",
    "Pr145",
    "Pr146",
    "Pr147",
    "Pr148",
    "Pr149",
    "Pr150",
    "Pr151",
    "Pr152",
    "Pr153",
    "Pr154",
    "Pr155",
    "Pr156",
    "Pr157",
    "Pr158",
    "Pr159",
    "Nd126",
    "Nd127",
    "Nd128",
    "Nd129",
    "Nd130",
    "Nd131",
    "Nd132",
    "Nd133",
    "Nd134",
    "Nd135",
    "Nd136",
    "Nd137",
    "Nd138",
    "Nd139",
    "Nd140",
    "Nd141",
    "Nd142",
    "Nd143",
    "Nd144",
    "Nd145",
    "Nd146",
    "Nd147",
    "Nd148",
    "Nd149",
    "Nd150",
    "Nd151",
    "Nd152",
    "Nd153",
    "Nd154",
    "Nd155",
    "Nd156",
    "Nd157",
    "Nd158",
    "Nd159",
    "Nd160",
    "Nd161",
    "Pm128",
    "Pm129",
    "Pm130",
    "Pm131",
    "Pm132",
    "Pm133",
    "Pm134",
    "Pm135",
    "Pm136",
    "Pm137",
    "Pm138",
    "Pm139",
    "Pm140",
    "Pm141",
    "Pm142",
    "Pm143",
    "Pm144",
    "Pm145",
    "Pm146",
    "Pm147",
    "Pm148",
    "Pm149",
    "Pm150",
    "Pm151",
    "Pm152",
    "Pm153",
    "Pm154",
    "Pm155",
    "Pm156",
    "Pm157",
    "Pm158",
    "Pm159",
    "Pm160",
    "Pm161",
    "Pm162",
    "Pm163",
    "Sm130",
    "Sm131",
    "Sm132",
    "Sm133",
    "Sm134",
    "Sm135",
    "Sm136",
    "Sm137",
    "Sm138",
    "Sm139",
    "Sm140",
    "Sm141",
    "Sm142",
    "Sm143",
    "Sm144",
    "Sm145",
    "Sm146",
    "Sm147",
    "Sm148",
    "Sm149",
    "Sm150",
    "Sm151",
    "Sm152",
    "Sm153",
    "Sm154",
    "Sm155",
    "Sm156",
    "Sm157",
    "Sm158",
    "Sm159",
    "Sm160",
    "Sm161",
    "Sm162",
    "Sm163",
    "Sm164",
    "Sm165",
    "Eu132",
    "Eu133",
    "Eu134",
    "Eu135",
    "Eu136",
    "Eu137",
    "Eu138",
    "Eu139",
    "Eu140",
    "Eu141",
    "Eu142",
    "Eu143",
    "Eu144",
    "Eu145",
    "Eu146",
    "Eu147",
    "Eu148",
    "Eu149",
    "Eu150",
    "Eu151",
    "Eu152",
    "Eu153",
    "Eu154",
    "Eu155",
    "Eu156",
    "Eu157",
    "Eu158",
    "Eu159",
    "Eu160",
    "Eu161",
    "Eu162",
    "Eu163",
    "Eu164",
    "Eu165",
    "Eu166",
    "Eu167",
    "Gd136",
    "Gd137",
    "Gd138",
    "Gd139",
    "Gd140",
    "Gd141",
    "Gd142",
    "Gd143",
    "Gd144",
    "Gd145",
    "Gd146",
    "Gd147",
    "Gd148",
    "Gd149",
    "Gd150",
    "Gd151",
    "Gd152",
    "Gd153",
    "Gd154",
    "Gd155",
    "Gd156",
    "Gd157",
    "Gd158",
    "Gd159",
    "Gd160",
    "Gd161",
    "Gd162",
    "Gd163",
    "Gd164",
    "Gd165",
    "Gd166",
    "Gd167",
    "Gd168",
    "Gd169",
    "Tb138",
    "Tb139",
    "Tb140",
    "Tb141",
    "Tb142",
    "Tb143",
    "Tb144",
    "Tb145",
    "Tb146",
    "Tb147",
    "Tb148",
    "Tb149",
    "Tb150",
    "Tb151",
    "Tb152",
    "Tb153",
    "Tb154",
    "Tb155",
    "Tb156",
    "Tb157",
    "Tb158",
    "Tb159",
    "Tb160",
    "Tb161",
    "Tb162",
    "Tb163",
    "Tb164",
    "Tb165",
    "Tb166",
    "Tb167",
    "Tb168",
    "Tb169",
    "Tb170",
    "Tb171",
    "Dy140",
    "Dy141",
    "Dy142",
    "Dy143",
    "Dy144",
    "Dy145",
    "Dy146",
    "Dy147",
    "Dy148",
    "Dy149",
    "Dy150",
    "Dy151",
    "Dy152",
    "Dy153",
    "Dy154",
    "Dy155",
    "Dy156",
    "Dy157",
    "Dy158",
    "Dy159",
    "Dy160",
    "Dy161",
    "Dy162",
    "Dy163",
    "Dy164",
    "Dy165",
    "Dy166",
    "Dy167",
    "Dy168",
    "Dy169",
    "Dy170",
    "Dy171",
    "Dy172",
    "Dy173",
    "Ho142",
    "Ho143",
    "Ho144",
    "Ho145",
    "Ho146",
    "Ho147",
    "Ho148",
    "Ho149",
    "Ho150",
    "Ho151",
    "Ho152",
    "Ho153",
    "Ho154",
    "Ho155",
    "Ho156",
    "Ho157",
    "Ho158",
    "Ho159",
    "Ho160",
    "Ho161",
    "Ho162",
    "Ho163",
    "Ho164",
    "Ho165",
    "Ho166",
    "Ho167",
    "Ho168",
    "Ho169",
    "Ho170",
    "Ho171",
    "Ho172",
    "Ho173",
    "Ho174",
    "Ho175",
    "Er144",
    "Er145",
    "Er146",
    "Er147",
    "Er148",
    "Er149",
    "Er150",
    "Er151",
    "Er152",
    "Er153",
    "Er154",
    "Er155",
    "Er156",
    "Er157",
    "Er158",
    "Er159",
    "Er160",
    "Er161",
    "Er162",
    "Er163",
    "Er164",
    "Er165",
    "Er166",
    "Er167",
    "Er168",
    "Er169",
    "Er170",
    "Er171",
    "Er172",
    "Er173",
    "Er174",
    "Er175",
    "Er176",
    "Er177",
    "Tm146",
    "Tm147",
    "Tm148",
    "Tm149",
    "Tm150",
    "Tm151",
    "Tm152",
    "Tm153",
    "Tm154",
    "Tm155",
    "Tm156",
    "Tm157",
    "Tm158",
    "Tm159",
    "Tm160",
    "Tm161",
    "Tm162",
    "Tm163",
    "Tm164",
    "Tm165",
    "Tm166",
    "Tm167",
    "Tm168",
    "Tm169",
    "Tm170",
    "Tm171",
    "Tm172",
    "Tm173",
    "Tm174",
    "Tm175",
    "Tm176",
    "Tm177",
    "Tm178",
    "Tm179",
    "Yb148",
    "Yb149",
    "Yb150",
    "Yb151",
    "Yb152",
    "Yb153",
    "Yb154",
    "Yb155",
    "Yb156",
    "Yb157",
    "Yb158",
    "Yb159",
    "Yb160",
    "Yb161",
    "Yb162",
    "Yb163",
    "Yb164",
    "Yb165",
    "Yb166",
    "Yb167",
    "Yb168",
    "Yb169",
    "Yb170",
    "Yb171",
    "Yb172",
    "Yb173",
    "Yb174",
    "Yb175",
    "Yb176",
    "Yb177",
    "Yb178",
    "Yb179",
    "Yb180",
    "Yb181",
    "Lu150",
    "Lu151",
    "Lu152",
    "Lu153",
    "Lu154",
    "Lu155",
    "Lu156",
    "Lu157",
    "Lu158",
    "Lu159",
    "Lu160",
    "Lu161",
    "Lu162",
    "Lu163",
    "Lu164",
    "Lu165",
    "Lu166",
    "Lu167",
    "Lu168",
    "Lu169",
    "Lu170",
    "Lu171",
    "Lu172",
    "Lu173",
    "Lu174",
    "Lu175",
    "Lu176",
    "Lu177",
    "Lu178",
    "Lu179",
    "Lu180",
    "Lu181",
    "Lu182",
    "Lu183",
    "Lu184",
    "Hf154",
    "Hf155",
    "Hf156",
    "Hf157",
    "Hf158",
    "Hf159",
    "Hf160",
    "Hf161",
    "Hf162",
    "Hf163",
    "Hf164",
    "Hf165",
    "Hf166",
    "Hf167",
    "Hf168",
    "Hf169",
    "Hf170",
    "Hf171",
    "Hf172",
    "Hf173",
    "Hf174",
    "Hf175",
    "Hf176",
    "Hf177",
    "Hf178",
    "Hf179",
    "Hf180",
    "Hf181",
    "Hf182",
    "Hf183",
    "Hf184",
    "Hf185",
    "Hf186",
    "Ta156",
    "Ta157",
    "Ta158",
    "Ta159",
    "Ta160",
    "Ta161",
    "Ta162",
    "Ta163",
    "Ta164",
    "Ta165",
    "Ta166",
    "Ta167",
    "Ta168",
    "Ta169",
    "Ta170",
    "Ta171",
    "Ta172",
    "Ta173",
    "Ta174",
    "Ta175",
    "Ta176",
    "Ta177",
    "Ta178",
    "Ta179",
    "Ta180",
    "Ta181",
    "Ta182",
    "Ta183",
    "Ta184",
    "Ta185",
    "Ta186",
    "Ta187",
    "Ta188",
    "W158",
    "W159",
    "W160",
    "W161",
    "W162",
    "W163",
    "W164",
    "W165",
    "W166",
    "W167",
    "W168",
    "W169",
    "W170",
    "W171",
    "W172",
    "W173",
    "W174",
    "W175",
    "W176",
    "W177",
    "W178",
    "W179",
    "W180",
    "W181",
    "W182",
    "W183",
    "W184",
    "W185",
    "W186",
    "W187",
    "W188",
    "W189",
    "W190",
    "Re160",
    "Re161",
    "Re162",
    "Re163",
    "Re164",
    "Re165",
    "Re166",
    "Re167",
    "Re168",
    "Re169",
    "Re170",
    "Re171",
    "Re172",
    "Re173",
    "Re174",
    "Re175",
    "Re176",
    "Re177",
    "Re178",
    "Re179",
    "Re180",
    "Re181",
    "Re182",
    "Re183",
    "Re184",
    "Re185",
    "Re186",
    "Re187",
    "Re188",
    "Re189",
    "Re190",
    "Re191",
    "Re192",
    "Os162",
    "Os163",
    "Os164",
    "Os165",
    "Os166",
    "Os167",
    "Os168",
    "Os169",
    "Os170",
    "Os171",
    "Os172",
    "Os173",
    "Os174",
    "Os175",
    "Os176",
    "Os177",
    "Os178",
    "Os179",
    "Os180",
    "Os181",
    "Os182",
    "Os183",
    "Os184",
    "Os185",
    "Os186",
    "Os187",
    "Os188",
    "Os189",
    "Os190",
    "Os191",
    "Os192",
    "Os193",
    "Os194",
    "Os195",
    "Os196",
    "Ir165",
    "Ir166",
    "Ir167",
    "Ir168",
    "Ir169",
    "Ir170",
    "Ir171",
    "Ir172",
    "Ir173",
    "Ir174",
    "Ir175",
    "Ir176",
    "Ir177",
    "Ir178",
    "Ir179",
    "Ir180",
    "Ir181",
    "Ir182",
    "Ir183",
    "Ir184",
    "Ir185",
    "Ir186",
    "Ir187",
    "Ir188",
    "Ir189",
    "Ir190",
    "Ir191",
    "Ir192",
    "Ir193",
    "Ir194",
    "Ir195",
    "Ir196",
    "Ir197",
    "Ir198",
    "Ir199",
    "Pt168",
    "Pt169",
    "Pt170",
    "Pt171",
    "Pt172",
    "Pt173",
    "Pt174",
    "Pt175",
    "Pt176",
    "Pt177",
    "Pt178",
    "Pt179",
    "Pt180",
    "Pt181",
    "Pt182",
    "Pt183",
    "Pt184",
    "Pt185",
    "Pt186",
    "Pt187",
    "Pt188",
    "Pt189",
    "Pt190",
    "Pt191",
    "Pt192",
    "Pt193",
    "Pt194",
    "Pt195",
    "Pt196",
    "Pt197",
    "Pt198",
    "Pt199",
    "Pt200",
    "Pt201",
    "Pt202",
    "Au171",
    "Au172",
    "Au173",
    "Au174",
    "Au175",
    "Au176",
    "Au177",
    "Au178",
    "Au179",
    "Au180",
    "Au181",
    "Au182",
    "Au183",
    "Au184",
    "Au185",
    "Au186",
    "Au187",
    "Au188",
    "Au189",
    "Au190",
    "Au191",
    "Au192",
    "Au193",
    "Au194",
    "Au195",
    "Au196",
    "Au197",
    "Au198",
    "Au199",
    "Au200",
    "Au201",
    "Au202",
    "Au203",
    "Au204",
    "Au205",
    "Hg175",
    "Hg176",
    "Hg177",
    "Hg178",
    "Hg179",
    "Hg180",
    "Hg181",
    "Hg182",
    "Hg183",
    "Hg184",
    "Hg185",
    "Hg186",
    "Hg187",
    "Hg188",
    "Hg189",
    "Hg190",
    "Hg191",
    "Hg192",
    "Hg193",
    "Hg194",
    "Hg195",
    "Hg196",
    "Hg197",
    "Hg198",
    "Hg199",
    "Hg200",
    "Hg201",
    "Hg202",
    "Hg203",
    "Hg204",
    "Hg205",
    "Hg206",
    "Hg207",
    "Hg208",
    "Tl177",
    "Tl178",
    "Tl179",
    "Tl180",
    "Tl181",
    "Tl182",
    "Tl183",
    "Tl184",
    "Tl185",
    "Tl186",
    "Tl187",
    "Tl188",
    "Tl189",
    "Tl190",
    "Tl191",
    "Tl192",
    "Tl193",
    "Tl194",
    "Tl195",
    "Tl196",
    "Tl197",
    "Tl198",
    "Tl199",
    "Tl200",
    "Tl201",
    "Tl202",
    "Tl203",
    "Tl204",
    "Tl205",
    "Tl206",
    "Tl207",
    "Tl208",
    "Tl209",
    "Tl210",
    "Pb181",
    "Pb182",
    "Pb183",
    "Pb184",
    "Pb185",
    "Pb186",
    "Pb187",
    "Pb188",
    "Pb189",
    "Pb190",
    "Pb191",
    "Pb192",
    "Pb193",
    "Pb194",
    "Pb195",
    "Pb196",
    "Pb197",
    "Pb198",
    "Pb199",
    "Pb200",
    "Pb201",
    "Pb202",
    "Pb203",
    "Pb204",
    "Pb205",
    "Pb206",
    "Pb207",
    "Pb208",
    "Pb209",
    "Pb210",
    "Pb211",
    "Pb212",
    "Pb213",
    "Pb214",
    "Bi185",
    "Bi186",
    "Bi187",
    "Bi188",
    "Bi189",
    "Bi190",
    "Bi191",
    "Bi192",
    "Bi193",
    "Bi194",
    "Bi195",
    "Bi196",
    "Bi197",
    "Bi198",
    "Bi199",
    "Bi200",
    "Bi201",
    "Bi202",
    "Bi203",
    "Bi204",
    "Bi205",
    "Bi206",
    "Bi207",
    "Bi208",
    "Bi209",
    "Bi210",
    "Bi211",
    "Bi212",
    "Bi213",
    "Bi214",
    "Bi215",
    "Bi216",
    "Po190",
    "Po191",
    "Po192",
    "Po193",
    "Po194",
    "Po195",
    "Po196",
    "Po197",
    "Po198",
    "Po199",
    "Po200",
    "Po201",
    "Po202",
    "Po203",
    "Po204",
    "Po205",
    "Po206",
    "Po207",
    "Po208",
    "Po209",
    "Po210",
    "Po211",
    "Po212",
    "Po213",
    "Po214",
    "Po215",
    "Po216",
    "Po217",
    "Po218",
    "At193",
    "At194",
    "At195",
    "At196",
    "At197",
    "At198",
    "At199",
    "At200",
    "At201",
    "At202",
    "At203",
    "At204",
    "At205",
    "At206",
    "At207",
    "At208",
    "At209",
    "At210",
    "At211",
    "At212",
    "At213",
    "At214",
    "At215",
    "At216",
    "At217",
    "At218",
    "At219",
    "At220",
    "At221",
    "At222",
    "At223",
    "Rn196",
    "Rn197",
    "Rn198",
    "Rn199",
    "Rn200",
    "Rn201",
    "Rn202",
    "Rn203",
    "Rn204",
    "Rn205",
    "Rn206",
    "Rn207",
    "Rn208",
    "Rn209",
    "Rn210",
    "Rn211",
    "Rn212",
    "Rn213",
    "Rn214",
    "Rn215",
    "Rn216",
    "Rn217",
    "Rn218",
    "Rn219",
    "Rn220",
    "Rn221",
    "Rn222",
    "Rn223",
    "Rn224",
    "Rn225",
    "Rn226",
    "Rn227",
    "Rn228",
    "Fr200",
    "Fr201",
    "Fr202",
    "Fr203",
    "Fr204",
    "Fr205",
    "Fr206",
    "Fr207",
    "Fr208",
    "Fr209",
    "Fr210",
    "Fr211",
    "Fr212",
    "Fr213",
    "Fr214",
    "Fr215",
    "Fr216",
    "Fr217",
    "Fr218",
    "Fr219",
    "Fr220",
    "Fr221",
    "Fr222",
    "Fr223",
    "Fr224",
    "Fr225",
    "Fr226",
    "Fr227",
    "Fr228",
    "Fr229",
    "Fr230",
    "Fr231",
    "Fr232",
    "Ra203",
    "Ra204",
    "Ra205",
    "Ra206",
    "Ra207",
    "Ra208",
    "Ra209",
    "Ra210",
    "Ra211",
    "Ra212",
    "Ra213",
    "Ra214",
    "Ra215",
    "Ra216",
    "Ra217",
    "Ra218",
    "Ra219",
    "Ra220",
    "Ra221",
    "Ra222",
    "Ra223",
    "Ra224",
    "Ra225",
    "Ra226",
    "Ra227",
    "Ra228",
    "Ra229",
    "Ra230",
    "Ra231",
    "Ra232",
    "Ra233",
    "Ra234",
    "Ac207",
    "Ac208",
    "Ac209",
    "Ac210",
    "Ac211",
    "Ac212",
    "Ac213",
    "Ac214",
    "Ac215",
    "Ac216",
    "Ac217",
    "Ac218",
    "Ac219",
    "Ac220",
    "Ac221",
    "Ac222",
    "Ac223",
    "Ac224",
    "Ac225",
    "Ac226",
    "Ac227",
    "Ac228",
    "Ac229",
    "Ac230",
    "Ac231",
    "Ac232",
    "Ac233",
    "Ac234",
    "Ac235",
    "Ac236",
    "Th210",
    "Th211",
    "Th212",
    "Th213",
    "Th214",
    "Th215",
    "Th216",
    "Th217",
    "Th218",
    "Th219",
    "Th220",
    "Th221",
    "Th222",
    "Th223",
    "Th224",
    "Th225",
    "Th226",
    "Th227",
    "Th228",
    "Th229",
    "Th230",
    "Th231",
    "Th232",
    "Th233",
    "Th234",
    "Th235",
    "Th236",
    "Th237",
    "Th238",
    "Pa213",
    "Pa214",
    "Pa215",
    "Pa216",
    "Pa217",
    "Pa218",
    "Pa219",
    "Pa220",
    "Pa221",
    "Pa222",
    "Pa223",
    "Pa224",
    "Pa225",
    "Pa226",
    "Pa227",
    "Pa228",
    "Pa229",
    "Pa230",
    "Pa231",
    "Pa232",
    "Pa233",
    "Pa234",
    "Pa235",
    "Pa236",
    "Pa237",
    "Pa238",
    "Pa239",
    "Pa240",
    "U218",
    "U219",
    "U220",
    "U221",
    "U222",
    "U223",
    "U224",
    "U225",
    "U226",
    "U227",
    "U228",
    "U229",
    "U230",
    "U231",
    "U232",
    "U233",
    "U234",
    "U235",
    "U236",
    "U237",
    "U238",
    "U239",
    "U240",
    "U241",
    "U242",
    "Np225",
    "Np226",
    "Np227",
    "Np228",
    "Np229",
    "Np230",
    "Np231",
    "Np232",
    "Np233",
    "Np234",
    "Np235",
    "Np236",
    "Np237",
    "Np238",
    "Np239",
    "Np240",
    "Np241",
    "Np242",
    "Np243",
    "Np244",
    "Pu228",
    "Pu229",
    "Pu230",
    "Pu231",
    "Pu232",
    "Pu233",
    "Pu234",
    "Pu235",
    "Pu236",
    "Pu237",
    "Pu238",
    "Pu239",
    "Pu240",
    "Pu241",
    "Pu242",
    "Pu243",
    "Pu244",
    "Pu245",
    "Pu246",
    "Pu247",
    "Am231",
    "Am232",
    "Am233",
    "Am234",
    "Am235",
    "Am236",
    "Am237",
    "Am238",
    "Am239",
    "Am240",
    "Am241",
    "Am242",
    "Am243",
    "Am244",
    "Am245",
    "Am246",
    "Am247",
    "Am248",
    "Am249",
    "Cm233",
    "Cm234",
    "Cm235",
    "Cm236",
    "Cm237",
    "Cm238",
    "Cm239",
    "Cm240",
    "Cm241",
    "Cm242",
    "Cm243",
    "Cm244",
    "Cm245",
    "Cm246",
    "Cm247",
    "Cm248",
    "Cm249",
    "Cm250",
    "Cm251",
    "Cm252",
    "Bk235",
    "Bk236",
    "Bk237",
    "Bk238",
    "Bk239",
    "Bk240",
    "Bk241",
    "Bk242",
    "Bk243",
    "Bk244",
    "Bk245",
    "Bk246",
    "Bk247",
    "Bk248",
    "Bk249",
    "Bk250",
    "Bk251",
    "Bk252",
    "Bk253",
    "Bk254",
    "Cf237",
    "Cf238",
    "Cf239",
    "Cf240",
    "Cf241",
    "Cf242",
    "Cf243",
    "Cf244",
    "Cf245",
    "Cf246",
    "Cf247",
    "Cf248",
    "Cf249",
    "Cf250",
    "Cf251",
    "Cf252",
    "Cf253",
    "Cf254",
    "Cf255",
    "Cf256",
    "Es240",
    "Es241",
    "Es242",
    "Es243",
    "Es244",
    "Es245",
    "Es246",
    "Es247",
    "Es248",
    "Es249",
    "Es250",
    "Es251",
    "Es252",
    "Es253",
    "Es254",
    "Es255",
    "Es256",
    "Es257",
    "Fm242",
    "Fm243",
    "Fm244",
    "Fm245",
    "Fm246",
    "Fm247",
    "Fm248",
    "Fm249",
    "Fm250",
    "Fm251",
    "Fm252",
    "Fm253",
    "Fm254",
    "Fm255",
    "Fm256",
    "Fm257",
    "Fm258",
    "Fm259",
    "Md245",
    "Md246",
    "Md247",
    "Md248",
    "Md249",
    "Md250",
    "Md251",
    "Md252",
    "Md253",
    "Md254",
    "Md255",
    "Md256",
    "Md257",
    "Md258",
    "Md259",
    "Md260",
    "No249",
    "No250",
    "No251",
    "No252",
    "No253",
    "No254",
    "No255",
    "No256",
    "No257",
    "No258",
    "No259",
    "No260",
    "No261",
    "No262",
    "Lr251",
    "Lr252",
    "Lr253",
    "Lr254",
    "Lr255",
    "Lr256",
    "Lr257",
    "Lr258",
    "Lr259",
    "Lr260",
    "Lr261",
    "Lr262",
    "Lr263",
    "Rf253",
    "Rf254",
    "Rf255",
    "Rf256",
    "Rf257",
    "Rf258",
    "Rf259",
    "Rf260",
    "Rf261",
    "Rf262",
    "Rf263",
    "Rf264",
    "Db255",
    "Db256",
    "Db257",
    "Db258",
    "Db259",
    "Db260",
    "Db261",
    "Db262",
    "Db263",
    "Db264",
    "Db265",
    "Sg258",
    "Sg259",
    "Sg260",
    "Sg261",
    "Sg262",
    "Sg263",
    "Sg264",
    "Sg265",
    "Sg266",
    "Bh260",
    "Bh261",
    "Bh262",
    "Bh263",
    "Bh264",
    "Bh265",
    "Bh266",
    "Bh267",
    "Hs263",
    "Hs264",
    "Hs265",
    "Hs266",
    "Hs267",
    "Hs268",
    "Hs269",
    "Hs277",
    "Mt265",
    "Mt266",
    "Mt267",
    "Mt268",
    "Mt269",
    "Mt270",
    "Mt271",
    "Ds267",
    "Ds268",
    "Ds269",
    "Ds270",
    "Ds271",
    "Ds272",
    "Ds273",
    "Ds281",
    "Rg272",
    "Cn285",
    "Nh286",
    "Fl289",
    "Mc289",
    "Lv293",
    "Ts294",
    "Og294",
};
