# Code Of Conduct

The Acts project observes [CERN's Code of Conduct](https://cern.ch/codeofconduct).
Below is a plain text summary of the [official PDF](https://cds.cern.ch/record/2240689/files/BrochureCodeofConductEN.pdf?)
as of 1. April 2020. Please consult the [PDF](https://cds.cern.ch/record/2240689/files/BrochureCodeofConductEN.pdf?)
for up-to-date information.

## USING THE CODE OF CONDUCT

We encourage a culture of openness where all contributors feel free to engage in a discussion about the Code of Conduct.

If you are unsure about any aspect of the Code of Conduct, there are a number of resources you may wish to access, including your hierarchy, the Human Resources Department, the Ombud Oﬃce or the Internal Audit.

In addition, to increase understanding of how the Code of Conduct applies to practical situations, you are encouraged to consult the Code of Conduct online FAQ’s, accessible at cern.ch/codeofconduct. This website will be updated on a regular basis.

## INTRODUCTION BY THE DIRECTOR-GENERAL

What we do in our working lives is important, and the way we do it is equally so. This is particularly true with the diverse community we have at CERN. People from all over the world come here, bringing with them different cultures and different ways of working. This diversity is part of our strength, and it’s something that we need to nurture constantly. That’s why CERN has developed a Code of Conduct that is built on a set of core CERN values, defined following broad consultation by the HR Department across the Organization in order to determine the values that underline the spirit of CERN.

Those values are integrity, commitment, professionalism, creativity and diversity. Taken together, they provide the basis for respect: respect for others, respect for the Organization and respect for its mission.

The Code of Conduct is the blueprint for how we work together. It was launched in 2010, accompanied by an Ombud Oﬃce to provide an informal route to the resolution of potential conflicts, and to serve as an interpreter of the Code of Conduct if and when necessary. I think it is fair to say that since then CERN’s values have become a natural and inherent part of the Organisation’s working landscape.

There have been occasions where people have had to be reminded of the Code’s stipulations, but these have been rare. Rather than a tool for the Organization to use as a stick, the Code is a tool for all of us to use as a guide.

Our Code of Conduct sets out in black and white the basic standards and rules of behaviour that we can expect to find in the workplace, and it provides guidance on how our actions may influence and support the good reputation of CERN. It is there to ensure that we pursue our mission of research, innovation, training and collaboration while respecting the highest ethical standards of behaviour.

It is not an exhaustive list of dos and don’ts. Rather, it is a practical guide, assisting us in understanding the consequences of how we treat others, how can we expect to be treated in the workplace, and how we should behave as ambassadors for CERN and for particle physics. It serves to help us maintain and develop a workplace marked by mutual respect.

Nurturing respect generates self-respect, and a respectful workplace is one where everyone can give their best in a supportive, collaborative, and pleasant environment.

**Fabiola Gianotti**, Director-General

## INTEGRITY
BEHAVING ETHICALLY, WITH INTELLECTUAL HONESTY AND BEING ACCOUNTABLE FOR ONE’S OWN ACTIONS.

A high standard of integrity in the performance of our work and in our relationships with others promotes a culture of trust and responsibility.

### AS CERN CONTRIBUTORS, WE:

- Exercise our authority responsibly. In particular, we abstain from using our authority or position to obtain personal benefits or favours.
- Demonstrate fairness and impartiality.
- Ensure that we credit others for their contribution.
- Avoid conflict of interest or situations that could be perceived as such.
- Refrain from any act or omission designed to deceive others, or to achieve a gain resulting in a loss of funds or reputation for CERN.
- Safeguard confidential information, documents or data, and ensure that such material in our possession is properly protected.
- Respect the privacy of others and protect personal information given to us in confidence.

## COMMITMENT
DEMONSTRATING A HIGH LEVEL OF MOTIVATION AND DEDICATION TO THE ORGANIZATION

Our collective commitment to CERN is essential both to the achievement of its mission and the protection of its reputation.

### AS CERN CONTRIBUTORS, WE:
- Promote the CERN mission and act in accordance with CERN values.
- Appreciate that our behaviour, both on site and outside CERN, may reflect upon CERN.
- Protect the reputation of CERN and our colleagues in communications with internal and external parties.
- Familiarize ourselves with all applicable rules and regulations.
- Promote and maintain a safe and healthy environment, following relevant safety rules.
- Educate ourselves on the responsibilities which accompany the privileges and immunities which may be granted to us for the benefit of CERN.
- Demonstrate flexibility and adapt to CERN’s evolving needs.

## PROFESSIONALISM
PRODUCING A HIGH LEVEL OF RESULTS WITHIN RESOURCE AND TIME CONSTRAINTS AND FOSTERING MUTUAL UNDERSTANDING

Our ability to deliver and to create a positive work environment permits us to achieve high professional standards, individually and collectively.

### AS CERN CONTRIBUTORS, WE:

- Define clear and realistic objectives and deliverables for our activities, and communicate them to our colleagues.
- Ensure that the human, material and financial resources entrusted to us are used optimally for the benefit of CERN.
- Invest in CERN’s future by taking long-term effectiveness into account when managing short and medium-term activities.
- Maintain a professional environment characterized by good working relations and an atmosphere of tolerance and mutual respect.
- Provide advice and guidance to colleagues, where appropriate, and exercise adequate supervision and control over tasks that we delegate.
- Address conflict proactively and impartially.
- Abstain from and actively discourage all forms of harassment as well as verbal, non-verbal, written or physical abuse.

## CREATIVITY
BEING AT THE FOREFRONT OF ONE’S PROFESSIONAL FIELD, FURTHERING INNOVATION AND ORGANIZATIONAL DEVELOPMENT

CERN encourages continuous learning and development and values innovation as well as a proactive approach to acquiring and sharing information.

### AS CERN CONTRIBUTORS, WE:
- Follow developments within our domain.
- Use our professional experience in a constructive manner.
- Contribute to the evolution of CERN by committing to sharing our knowledge.
- Share with internal parties any information that could benefit them in their work.
- Are open to new ideas and approaches.
- Adopt alternative outlooks in order to generate new thoughts and concepts.
- Conduct our work in a structured way to enhance knowledge transfer and continuity.

## DIVERSITY
APPRECIATING DIFFERENCES, FOSTERING EQUALITY, AND PROMOTING COLLABORATION

CERN’s excellence derives from an environment in which the knowledge and perspectives of a diverse workforce are valued and dialogue is encouraged at all levels.

### AS CERN CONTRIBUTORS, WE:
- Respect and value differences.
- Promote inclusiveness in the workplace in terms of both personal characteristics and professional abilities.
- Demonstrate team spirit and invest in team building.
- Treat others with tact, courtesy and respect.
- Abstain from and actively discourage discrimination in all forms.
- Avoid offending others by exercising restraint, and are aware that statements or actions not intended to be offensive to another person may be perceived as such.
- Refrain from unpleasant or disparaging remarks or actions, in particular on the basis of sex, age, religion, beliefs, nationality, culture, ethnicity, race, sexual orientation, status at CERN, disability, or family situation.
