/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;

public class AsyncWriteEngine
extends EngineWrapper
implements Engine {
    protected static final AtomicLong threadCounter = new AtomicLong();
    protected static final Object TOMBSTONE = new Object();
    protected final int maxSize;
    protected final AtomicInteger size = new AtomicInteger();
    protected final LongConcurrentHashMap<Fun.Tuple2<Object, Serializer>> writeCache = new LongConcurrentHashMap();
    protected final ReentrantReadWriteLock commitLock = new ReentrantReadWriteLock(false);
    protected final CountDownLatch activeThreadsCount = new CountDownLatch(1);
    protected volatile Throwable threadFailedException = null;
    protected volatile boolean closeInProgress = false;
    protected final int asyncFlushDelay;
    protected final AtomicReference<CountDownLatch> action = new AtomicReference<Object>(null);

    public AsyncWriteEngine(Engine engine, int _asyncFlushDelay, int queueSize, Executor executor) {
        super(engine);
        this.asyncFlushDelay = _asyncFlushDelay;
        this.maxSize = queueSize;
        this.startThreads(executor);
    }

    public AsyncWriteEngine(Engine engine) {
        this(engine, 100, 32000, null);
    }

    protected void startThreads(Executor executor) {
        WriterRunnable writerRun = new WriterRunnable(this);
        if (executor != null) {
            executor.execute(writerRun);
            return;
        }
        long threadNum = threadCounter.incrementAndGet();
        Thread writerThread = new Thread((Runnable)writerRun, "MapDB writer #" + threadNum);
        writerThread.setDaemon(true);
        writerThread.start();
    }

    protected boolean runWriter() throws InterruptedException {
        CountDownLatch latch = this.action.getAndSet(null);
        do {
            LongMap.LongMapIterator<Fun.Tuple2<Object, Serializer>> iter = this.writeCache.longMapIterator();
            while (iter.moveToNext()) {
                long recid = iter.key();
                Fun.Tuple2<Object, Serializer> item = iter.value();
                if (item == null) continue;
                if (item.a == TOMBSTONE) {
                    AsyncWriteEngine.super.delete(recid, (Serializer)item.b);
                } else {
                    AsyncWriteEngine.super.update(recid, item.a, (Serializer)item.b);
                }
                if (!this.writeCache.remove(recid, item)) continue;
                this.size.decrementAndGet();
            }
        } while (latch != null && !this.writeCache.isEmpty());
        if (latch != null) {
            assert (this.writeCache.isEmpty());
            long count = latch.getCount();
            if (count == 0L) {
                return false;
            }
            if (count == 1L) {
                AsyncWriteEngine.super.commit();
                latch.countDown();
            } else if (count == 2L) {
                AsyncWriteEngine.super.rollback();
                latch.countDown();
                latch.countDown();
            } else if (count == 3L) {
                AsyncWriteEngine.super.compact();
                latch.countDown();
                latch.countDown();
                latch.countDown();
            } else {
                throw new AssertionError();
            }
        }
        return true;
    }

    protected void checkState() {
        if (this.closeInProgress) {
            throw new IllegalAccessError("db has been closed");
        }
        if (this.threadFailedException != null) {
            throw new RuntimeException("Writer thread failed", this.threadFailedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        int size2 = 0;
        long recid = 0L;
        this.commitLock.readLock().lock();
        try {
            this.checkState();
            recid = this.preallocate();
            if (this.writeCache.put(recid, new Fun.Tuple2<A, Serializer<A>>(value, serializer)) == null) {
                size2 = this.size.incrementAndGet();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
        if (size2 > this.maxSize) {
            this.clearCache();
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.checkState();
            Fun.Tuple2<Object, Serializer> item = this.writeCache.get(recid);
            if (item != null) {
                if (item.a == TOMBSTONE) {
                    A a = null;
                    return a;
                }
                Object a = item.a;
                return a;
            }
            A a = super.get(recid, serializer);
            return a;
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        int size2 = 0;
        this.commitLock.readLock().lock();
        try {
            this.checkState();
            if (this.writeCache.put(recid, new Fun.Tuple2<A, Serializer<A>>(value, serializer)) == null) {
                size2 = this.size.incrementAndGet();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
        if (size2 > this.maxSize) {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        boolean ret;
        int size2 = 0;
        this.commitLock.writeLock().lock();
        try {
            Object oldValue;
            this.checkState();
            Fun.Tuple2<Object, Serializer> existing = this.writeCache.get(recid);
            Object a = oldValue = existing != null ? existing.a : super.get(recid, serializer);
            if (oldValue == expectedOldValue || oldValue != null && oldValue.equals(expectedOldValue)) {
                if (this.writeCache.put(recid, new Fun.Tuple2<A, Serializer<A>>(newValue, serializer)) == null) {
                    size2 = this.size.incrementAndGet();
                }
                ret = true;
            } else {
                ret = false;
            }
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
        if (size2 > this.maxSize) {
            this.clearCache();
        }
        return ret;
    }

    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.update(recid, TOMBSTONE, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.commitLock.writeLock().lock();
        try {
            if (this.closeInProgress) {
                return;
            }
            try {
                this.checkState();
                this.closeInProgress = true;
                if (!this.action.compareAndSet(null, new CountDownLatch(0))) {
                    throw new AssertionError();
                }
                while (!this.activeThreadsCount.await(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
            finally {
                AsyncWriteEngine.super.close();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    protected void waitForAction(int actionNumber) {
        this.commitLock.writeLock().lock();
        try {
            this.checkState();
            CountDownLatch msg = new CountDownLatch(actionNumber);
            if (!this.action.compareAndSet(null, msg)) {
                throw new AssertionError();
            }
            while (!msg.await(100L, TimeUnit.MILLISECONDS)) {
                this.checkState();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    @Override
    public void commit() {
        this.waitForAction(1);
    }

    @Override
    public void rollback() {
        this.waitForAction(2);
    }

    @Override
    public void compact() {
        this.waitForAction(3);
    }

    @Override
    public void clearCache() {
        this.commitLock.writeLock().lock();
        try {
            this.checkState();
            while (!this.writeCache.isEmpty()) {
                this.checkState();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
        super.clearCache();
    }

    protected static final class WriterRunnable
    implements Runnable {
        protected final WeakReference<AsyncWriteEngine> engineRef;
        protected final long asyncFlushDelay;
        protected final AtomicInteger size;
        protected final int maxParkSize;
        private final ReentrantReadWriteLock commitLock;

        public WriterRunnable(AsyncWriteEngine engine) {
            this.engineRef = new WeakReference<AsyncWriteEngine>(engine);
            this.asyncFlushDelay = engine.asyncFlushDelay;
            this.commitLock = engine.commitLock;
            this.size = engine.size;
            this.maxParkSize = engine.maxSize / 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    if (this.asyncFlushDelay != 0L && !this.commitLock.isWriteLocked() && this.size.get() < this.maxParkSize) {
                        LockSupport.parkNanos(1000000L * this.asyncFlushDelay);
                    }
                    if ((engine = (AsyncWriteEngine)this.engineRef.get()) == null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable e) {
                    engine = (AsyncWriteEngine)this.engineRef.get();
                    if (engine != null) {
                        engine.threadFailedException = e;
                    }
                    if ((engine = (AsyncWriteEngine)this.engineRef.get()) == null) return;
                    engine.activeThreadsCount.countDown();
                    return;
                }
                catch (Throwable var3_8) {
                    engine = (AsyncWriteEngine)this.engineRef.get();
                    if (engine == null) throw var3_8;
                    engine.activeThreadsCount.countDown();
                    throw var3_8;
                }
                engine = (AsyncWriteEngine)this.engineRef.get();
                if (engine == null) return;
                engine.activeThreadsCount.countDown();
                return;
lbl-1000:
                // 1 sources

                {
                    if (engine.threadFailedException == null) continue;
                }
                engine = (AsyncWriteEngine)this.engineRef.get();
                if (engine == null) return;
                engine.activeThreadsCount.countDown();
                return;
                {
                    if (engine.runWriter()) continue;
                }
                break;
            }
            engine = (AsyncWriteEngine)this.engineRef.get();
            if (engine == null) return;
            engine.activeThreadsCount.countDown();
        }
    }
}

