/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebFilterAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(WebFilterAnnotation.class);

    public WebFilterAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebFilterAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    public void apply() {
        FilterHolder holder;
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        if (!Filter.class.isAssignableFrom(clazz)) {
            LOG.warn(clazz.getName() + " is not assignable from javax.servlet.Filter", new Object[0]);
            return;
        }
        MetaData metaData = this._context.getMetaData();
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation.value().length > 0 && filterAnnotation.urlPatterns().length > 0) {
            LOG.warn(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns", new Object[0]);
            return;
        }
        String name = filterAnnotation.filterName().equals("") ? clazz.getName() : filterAnnotation.filterName();
        String[] urlPatterns = filterAnnotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = filterAnnotation.urlPatterns();
        }
        if ((holder = this._context.getServletHandler().getFilter(name)) == null) {
            String s;
            int n;
            holder = this._context.getServletHandler().newFilterHolder(BaseHolder.Source.ANNOTATION);
            holder.setName(name);
            holder.setHeldClass(clazz);
            metaData.setOrigin(name + ".filter.filter-class", (Annotation)filterAnnotation, clazz);
            holder.setDisplayName(filterAnnotation.displayName());
            metaData.setOrigin(name + ".filter.display-name", (Annotation)filterAnnotation, clazz);
            for (WebInitParam ip : filterAnnotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            if (urlPatterns.length > 0) {
                ArrayList<String> paths = new ArrayList<String>();
                String[] stringArray = urlPatterns;
                int ip = stringArray.length;
                for (n = 0; n < ip; ++n) {
                    s = stringArray[n];
                    paths.add(Util.normalizePattern(s));
                }
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            }
            if (filterAnnotation.servletNames().length > 0) {
                ArrayList<String> names = new ArrayList<String>();
                String[] stringArray = filterAnnotation.servletNames();
                int ip = stringArray.length;
                for (n = 0; n < ip; ++n) {
                    s = stringArray[n];
                    names.add(s);
                }
                mapping.setServletNames(names.toArray(new String[names.size()]));
            }
            EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
            for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                dispatcherSet.add(d);
            }
            mapping.setDispatcherTypes(dispatcherSet);
            metaData.setOrigin(name + ".filter.mappings", (Annotation)filterAnnotation, clazz);
            holder.setAsyncSupported(filterAnnotation.asyncSupported());
            metaData.setOrigin(name + ".filter.async-supported", (Annotation)filterAnnotation, clazz);
            this._context.getServletHandler().addFilter(holder);
            this._context.getServletHandler().addFilterMapping(mapping);
        } else {
            for (WebInitParam ip : filterAnnotation.initParams()) {
                if (metaData.getOrigin(name + ".filter.init-param." + ip.name()) != Origin.NotSet) continue;
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            FilterMapping[] mappings = this._context.getServletHandler().getFilterMappings();
            boolean mappingExists = false;
            if (mappings != null) {
                for (FilterMapping m : mappings) {
                    if (!m.getFilterName().equals(name)) continue;
                    mappingExists = true;
                    break;
                }
            }
            if (!mappingExists) {
                String s;
                int n;
                FilterMapping mapping = new FilterMapping();
                mapping.setFilterName(holder.getName());
                if (urlPatterns.length > 0) {
                    ArrayList<String> paths = new ArrayList<String>();
                    String[] stringArray = urlPatterns;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        s = stringArray[n];
                        paths.add(Util.normalizePattern(s));
                    }
                    mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                }
                if (filterAnnotation.servletNames().length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    String[] stringArray = filterAnnotation.servletNames();
                    int n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        s = stringArray[n];
                        names.add(s);
                    }
                    mapping.setServletNames(names.toArray(new String[names.size()]));
                }
                EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
                for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                    dispatcherSet.add(d);
                }
                mapping.setDispatcherTypes(dispatcherSet);
                this._context.getServletHandler().addFilterMapping(mapping);
                metaData.setOrigin(name + ".filter.mappings", (Annotation)filterAnnotation, clazz);
            }
        }
    }
}

