/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.nosql.mongodb.MongoSessionIdManager;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Mongo Session Manager")
public class MongoSessionManager
extends NoSqlSessionManager {
    private static final Logger LOG = Log.getLogger(MongoSessionManager.class);
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private static final String __METADATA = "__metadata__";
    public static final String __ID = "id";
    private static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __INVALIDATED = "invalidated";
    public static final String __ACCESSED = "accessed";
    public static final String __EXPIRY = "expiry";
    public static final String __MAX_IDLE = "maxIdle";
    private static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    private String _contextId = null;
    private DBCollection _dbSessions;
    private DBObject _version_1;

    @Override
    public void doStart() throws Exception {
        String contextPath;
        super.doStart();
        String[] hosts = this.getContextHandler().getVirtualHosts();
        if (hosts == null || hosts.length == 0) {
            hosts = new String[]{"::"};
        }
        if ((contextPath = this.getContext().getContextPath()) == null || "".equals(contextPath)) {
            contextPath = "*";
        }
        this._contextId = this.createContextId(hosts, contextPath);
        this._version_1 = new BasicDBObject(this.getContextAttributeKey(__VERSION), (Object)1);
    }

    public void setSessionIdManager(SessionIdManager metaManager) {
        MongoSessionIdManager msim = (MongoSessionIdManager)metaManager;
        this._dbSessions = msim.getSessions();
        super.setSessionIdManager(metaManager);
    }

    @Override
    protected synchronized Object save(NoSqlSession session, Object version, boolean activateAfterSave) {
        try {
            __log.debug("MongoSessionManager:save session {}", new Object[]{session.getClusterId()});
            session.willPassivate();
            BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
            BasicDBObject update = new BasicDBObject();
            boolean upsert = false;
            BasicDBObject sets = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            if (session.isValid()) {
                long expiry = session.getMaxInactiveInterval() > 0 ? session.getAccessed() + 1000L * (long)this.getMaxInactiveInterval() : 0L;
                __log.debug("MongoSessionManager: calculated expiry {} for session {}", new Object[]{expiry, session.getId()});
                if (version == null) {
                    upsert = true;
                    version = new Long(1L);
                    sets.put(__CREATED, (Object)session.getCreationTime());
                    sets.put(__VALID, (Object)true);
                    sets.put(this.getContextAttributeKey(__VERSION), version);
                    sets.put(__MAX_IDLE, (Object)this.getMaxInactiveInterval());
                    sets.put(__EXPIRY, (Object)expiry);
                } else {
                    version = new Long(((Number)version).longValue() + 1L);
                    update.put("$inc", (Object)this._version_1);
                    BasicDBObject fields = new BasicDBObject();
                    fields.append(__MAX_IDLE, (Object)true);
                    fields.append(__EXPIRY, (Object)true);
                    DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)session.getClusterId()), (DBObject)fields);
                    if (o != null) {
                        Integer currentMaxIdle = (Integer)o.get(__MAX_IDLE);
                        Long currentExpiry = (Long)o.get(__EXPIRY);
                        if (currentMaxIdle != null && this.getMaxInactiveInterval() > 0 && this.getMaxInactiveInterval() < currentMaxIdle) {
                            sets.put(__MAX_IDLE, (Object)this.getMaxInactiveInterval());
                        }
                        if (currentExpiry != null && expiry > 0L && expiry != currentExpiry) {
                            sets.put(__EXPIRY, (Object)expiry);
                        }
                    }
                }
                sets.put(__ACCESSED, (Object)session.getAccessed());
                Set<String> names = session.takeDirty();
                if (this.isSaveAllAttributes() || upsert) {
                    names.addAll(session.getNames());
                }
                for (String name : names) {
                    Object value = session.getAttribute(name);
                    if (value == null) {
                        unsets.put(this.getContextKey() + "." + this.encodeName(name), (Object)1);
                        continue;
                    }
                    sets.put(this.getContextKey() + "." + this.encodeName(name), this.encodeName(value));
                }
            } else {
                sets.put(__VALID, (Object)false);
                sets.put(__INVALIDATED, (Object)System.currentTimeMillis());
                unsets.put(this.getContextKey(), (Object)1);
            }
            if (!sets.isEmpty()) {
                update.put("$set", (Object)sets);
            }
            if (!unsets.isEmpty()) {
                update.put("$unset", (Object)unsets);
            }
            this._dbSessions.update((DBObject)key, (DBObject)update, upsert, false, WriteConcern.SAFE);
            if (__log.isDebugEnabled()) {
                __log.debug("MongoSessionManager:save:db.sessions.update( {}, {} )", new Object[]{key, update});
            }
            if (activateAfterSave) {
                session.didActivate();
            }
            return version;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected Object refresh(NoSqlSession session, Object version) {
        DBObject o;
        __log.debug("MongoSessionManager:refresh session {}", new Object[]{session.getId()});
        if (version != null && (o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)session.getClusterId()), this._version_1)) != null) {
            Object saved = this.getNestedValue(o, this.getContextAttributeKey(__VERSION));
            if (saved != null && saved.equals(version)) {
                __log.debug("MongoSessionManager:refresh not needed session {}", new Object[]{session.getId()});
                return version;
            }
            version = saved;
        }
        if ((o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)session.getClusterId()))) == null) {
            __log.debug("MongoSessionManager:refresh:marking session {} invalid, no object", new Object[]{session.getClusterId()});
            session.invalidate();
            return null;
        }
        Boolean valid = (Boolean)o.get(__VALID);
        if (valid == null || !valid.booleanValue()) {
            __log.debug("MongoSessionManager:refresh:marking session {} invalid, valid flag {}", new Object[]{session.getClusterId(), valid});
            session.invalidate();
            return null;
        }
        session.willPassivate();
        try {
            DBObject attrs = (DBObject)this.getNestedValue(o, this.getContextKey());
            if (attrs == null || attrs.keySet().size() == 0) {
                session.clearAttributes();
            } else {
                for (String name : attrs.keySet()) {
                    if (__METADATA.equals(name)) continue;
                    String attr = this.decodeName(name);
                    Object value = this.decodeValue(attrs.get(name));
                    if (session.getAttribute(attr) == null) {
                        session.doPutOrRemove(attr, value);
                        session.bindValue(attr, value);
                        continue;
                    }
                    session.doPutOrRemove(attr, value);
                }
                for (String str : session.getNames()) {
                    if (attrs.keySet().contains(this.encodeName(str))) continue;
                    session.doPutOrRemove(str, null);
                    session.unbindValue(str, session.getAttribute(str));
                }
            }
            BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
            BasicDBObject sets = new BasicDBObject();
            BasicDBObject update = new BasicDBObject();
            sets.put(__ACCESSED, (Object)System.currentTimeMillis());
            if (!sets.isEmpty()) {
                update.put("$set", (Object)sets);
            }
            this._dbSessions.update((DBObject)key, (DBObject)update, false, false, WriteConcern.SAFE);
            session.didActivate();
            return version;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected synchronized NoSqlSession loadSession(String clusterId) {
        DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)clusterId));
        __log.debug("MongoSessionManager:id={} loaded={}", new Object[]{clusterId, o});
        if (o == null) {
            return null;
        }
        Boolean valid = (Boolean)o.get(__VALID);
        __log.debug("MongoSessionManager:id={} valid={}", new Object[]{clusterId, valid});
        if (valid == null || !valid.booleanValue()) {
            return null;
        }
        try {
            Object version = o.get(this.getContextAttributeKey(__VERSION));
            Long created = (Long)o.get(__CREATED);
            Long accessed = (Long)o.get(__ACCESSED);
            NoSqlSession session = null;
            DBObject attrs = (DBObject)this.getNestedValue(o, this.getContextKey());
            __log.debug("MongoSessionManager:attrs {}", new Object[]{attrs});
            if (attrs != null) {
                __log.debug("MongoSessionManager: session {} present for context {}", new Object[]{clusterId, this.getContextKey()});
                session = new NoSqlSession(this, created, accessed, clusterId, version);
                for (String name : attrs.keySet()) {
                    if (__METADATA.equals(name)) continue;
                    String attr = this.decodeName(name);
                    Object value = this.decodeValue(attrs.get(name));
                    session.doPutOrRemove(attr, value);
                    session.bindValue(attr, value);
                }
                session.didActivate();
            } else {
                __log.debug("MongoSessionManager: session  {} not present for context {}", new Object[]{clusterId, this.getContextKey()});
            }
            return session;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean remove(NoSqlSession session) {
        __log.debug("MongoSessionManager:remove:session {} for context {}", new Object[]{session.getClusterId(), this.getContextKey()});
        BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
        DBObject o = this._dbSessions.findOne((DBObject)key, this._version_1);
        if (o != null) {
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put(this.getContextKey(), (Object)1);
            remove.put("$unset", (Object)unsets);
            this._dbSessions.update((DBObject)key, (DBObject)remove, false, false, WriteConcern.SAFE);
            return true;
        }
        return false;
    }

    @Override
    protected void expire(String idInCluster) {
        __log.debug("MongoSessionManager:expire session {} ", new Object[]{idInCluster});
        super.expire(idInCluster);
        BasicDBObject validKey = new BasicDBObject(__VALID, (Object)true);
        DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)idInCluster), (DBObject)validKey);
        if (o != null && ((Boolean)o.get(__VALID)).booleanValue()) {
            BasicDBObject update = new BasicDBObject();
            BasicDBObject sets = new BasicDBObject();
            sets.put(__VALID, (Object)false);
            sets.put(__INVALIDATED, (Object)System.currentTimeMillis());
            update.put("$set", (Object)sets);
            BasicDBObject key = new BasicDBObject(__ID, (Object)idInCluster);
            this._dbSessions.update((DBObject)key, (DBObject)update, false, false, WriteConcern.SAFE);
        }
    }

    @Override
    protected void update(NoSqlSession session, String newClusterId, String newNodeId) throws Exception {
        BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
        BasicDBObject sets = new BasicDBObject();
        BasicDBObject update = new BasicDBObject(__ID, (Object)newClusterId);
        sets.put("$set", (Object)update);
        this._dbSessions.update((DBObject)key, (DBObject)sets, false, false, WriteConcern.SAFE);
    }

    protected String encodeName(String name) {
        return name.replace("%", "%25").replace(".", "%2E");
    }

    protected String decodeName(String name) {
        return name.replace("%2E", ".").replace("%25", "%");
    }

    protected Object encodeName(Object value) throws IOException {
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            return value;
        }
        if (value.getClass().equals(HashMap.class)) {
            BasicDBObject o = new BasicDBObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    o = null;
                    break;
                }
                o.append(this.encodeName(entry.getKey().toString()), this.encodeName(entry.getValue()));
            }
            if (o != null) {
                return o;
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.reset();
        out.writeUnshared(value);
        out.flush();
        return bout.toByteArray();
    }

    protected Object decodeValue(Object valueToDecode) throws IOException, ClassNotFoundException {
        if (valueToDecode == null || valueToDecode instanceof Number || valueToDecode instanceof String || valueToDecode instanceof Boolean || valueToDecode instanceof Date) {
            return valueToDecode;
        }
        if (valueToDecode instanceof byte[]) {
            byte[] decodeObject = (byte[])valueToDecode;
            ByteArrayInputStream bais = new ByteArrayInputStream(decodeObject);
            ClassLoadingObjectInputStream objectInputStream = new ClassLoadingObjectInputStream(bais);
            return objectInputStream.readUnshared();
        }
        if (valueToDecode instanceof DBObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : ((DBObject)valueToDecode).keySet()) {
                String attr = this.decodeName(name);
                map.put(attr, this.decodeValue(((DBObject)valueToDecode).get(name)));
            }
            return map;
        }
        throw new IllegalStateException(valueToDecode.getClass().toString());
    }

    private String getContextKey() {
        return "context." + this._contextId;
    }

    private String getContextAttributeKey(String attr) {
        return this.getContextKey() + "." + attr;
    }

    @ManagedOperation(value="purge invalid sessions in the session store based on normal criteria", impact="ACTION")
    public void purge() {
        ((MongoSessionIdManager)this._sessionIdManager).purge();
    }

    @ManagedOperation(value="full purge of invalid sessions in the session store", impact="ACTION")
    public void purgeFully() {
        ((MongoSessionIdManager)this._sessionIdManager).purgeFully();
    }

    @ManagedOperation(value="scavenge sessions known to this manager", impact="ACTION")
    public void scavenge() {
        ((MongoSessionIdManager)this._sessionIdManager).scavenge();
    }

    @ManagedOperation(value="scanvenge all sessions", impact="ACTION")
    public void scavengeFully() {
        ((MongoSessionIdManager)this._sessionIdManager).scavengeFully();
    }

    @ManagedAttribute(value="total number of known sessions in the store")
    public long getSessionStoreCount() {
        return this._dbSessions.find().count();
    }

    private String createContextId(String[] virtualHosts, String contextPath) {
        String contextId = virtualHosts[0] + contextPath;
        contextId.replace('/', '_');
        contextId.replace('.', '_');
        contextId.replace('\\', '_');
        return contextId;
    }

    private Object getNestedValue(DBObject dbObject, String nestedKey) {
        String[] keyChain = nestedKey.split("\\.");
        DBObject temp = dbObject;
        for (int i = 0; i < keyChain.length - 1; ++i) {
            if ((temp = (DBObject)temp.get(keyChain[i])) != null) continue;
            return null;
        }
        return temp.get(keyChain[keyChain.length - 1]);
    }

    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }
}

