/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.template.InheritanceChain;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.template.ScopeChain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class EvaluationContext {
    private final boolean strictVariables;
    private final InheritanceChain inheritanceChain;
    private final ScopeChain scopeChain;
    private final Locale locale;
    private final Map<String, Filter> filters;
    private final Map<String, Test> tests;
    private final Map<String, Function> functions;
    private final ExecutorService executorService;
    private final List<PebbleTemplateImpl> importedTemplates = new ArrayList<PebbleTemplateImpl>();

    public EvaluationContext(PebbleTemplateImpl self, boolean strictVariables, Locale locale, Map<String, Filter> filters, Map<String, Test> tests, Map<String, Function> functions, ExecutorService executorService, ScopeChain scopeChain, InheritanceChain inheritanceChain) {
        if (inheritanceChain == null) {
            inheritanceChain = new InheritanceChain(self);
        }
        this.strictVariables = strictVariables;
        this.locale = locale;
        this.filters = filters;
        this.tests = tests;
        this.functions = functions;
        this.executorService = executorService;
        this.scopeChain = scopeChain;
        this.inheritanceChain = inheritanceChain;
    }

    public EvaluationContext shallowCopyWithoutInheritanceChain(PebbleTemplateImpl self) {
        EvaluationContext result = new EvaluationContext(self, this.strictVariables, this.locale, this.filters, this.tests, this.functions, this.executorService, this.scopeChain, null);
        return result;
    }

    public EvaluationContext deepCopy(PebbleTemplateImpl self) {
        EvaluationContext result = new EvaluationContext(self, this.strictVariables, this.locale, this.filters, this.tests, this.functions, this.executorService, this.scopeChain.deepCopy(), this.inheritanceChain);
        return result;
    }

    public void put(String key, Object value) {
        this.scopeChain.put(key, value);
    }

    public Object get(String key) {
        return this.scopeChain.get(key);
    }

    public void ascendInheritanceChain() {
        this.inheritanceChain.ascend();
    }

    public void descendInheritanceChain() {
        this.inheritanceChain.descend();
    }

    public PebbleTemplateImpl getParentTemplate() {
        return this.inheritanceChain.getParent();
    }

    public PebbleTemplateImpl getChildTemplate() {
        return this.inheritanceChain.getChild();
    }

    public void pushScope() {
        this.pushScope(new HashMap<String, Object>());
    }

    public void pushScope(Map<String, Object> map) {
        this.scopeChain.pushScope(map);
    }

    public boolean currentScopeContainsVariable(String variableName) {
        return this.scopeChain.currentScopeContainsVariable(variableName);
    }

    public void pushLocalScope() {
        this.scopeChain.pushLocalScope();
    }

    public void popScope() {
        this.scopeChain.popScope();
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, Test> getTests() {
        return this.tests;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void addImportedTemplate(PebbleTemplateImpl template) {
        this.importedTemplates.add(template);
    }

    public List<PebbleTemplateImpl> getImportedTemplates() {
        return this.importedTemplates;
    }

    public void setParent(PebbleTemplateImpl parent) {
        this.inheritanceChain.pushAncestor(parent);
    }
}

