/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.LocaleAware;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.node.expression.FilterInvocationExpression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.Map;

public class FilterExpression
extends BinaryExpression<Object> {
    private Filter filter = null;

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) throws PebbleException {
        FilterInvocationExpression filterInvocation = (FilterInvocationExpression)this.getRightExpression();
        ArgumentsNode args = filterInvocation.getArgs();
        String filterName = filterInvocation.getFilterName();
        if (this.filter == null) {
            Map<String, Filter> filters = context.getFilters();
            this.filter = filters.get(filterInvocation.getFilterName());
        }
        if (this.filter == null) {
            throw new PebbleException(null, String.format("Filter [%s] does not exist.", filterName));
        }
        if (this.filter instanceof LocaleAware) {
            ((LocaleAware)((Object)this.filter)).setLocale(context.getLocale());
        }
        Map<String, Object> namedArguments = args.getArgumentMap(self, context, this.filter);
        return this.filter.apply(this.getLeftExpression().evaluate(self, context), namedArguments);
    }
}

