/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.utils.Pair;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class IfNode
extends AbstractRenderableNode {
    private final List<Pair<Expression<?>, BodyNode>> conditionsWithBodies;
    private final BodyNode elseBody;

    public IfNode(int lineNumber, List<Pair<Expression<?>, BodyNode>> conditionsWithBodies) {
        this(lineNumber, conditionsWithBodies, null);
    }

    public IfNode(int lineNumber, List<Pair<Expression<?>, BodyNode>> conditionsWithBodies, BodyNode elseBody) {
        super(lineNumber);
        this.conditionsWithBodies = conditionsWithBodies;
        this.elseBody = elseBody;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
        boolean satisfied = false;
        for (Pair<Expression<?>, BodyNode> ifStatement : this.conditionsWithBodies) {
            Object result = ifStatement.getLeft().evaluate(self, context);
            if (result != null) {
                satisfied = (Boolean)result;
            }
            if (!satisfied) continue;
            ifStatement.getRight().render(self, writer, context);
            break;
        }
        if (!satisfied && this.elseBody != null) {
            this.elseBody.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<Pair<Expression<?>, BodyNode>> getConditionsWithBodies() {
        return this.conditionsWithBodies;
    }

    public BodyNode getElseBody() {
        return this.elseBody;
    }
}

