/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.extension.core.CoreExtension;
import com.mitchellbosecke.pebble.extension.escaper.EscaperExtension;
import com.mitchellbosecke.pebble.extension.i18n.I18nExtension;
import com.mitchellbosecke.pebble.lexer.Lexer;
import com.mitchellbosecke.pebble.lexer.LexerImpl;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.DelegatingLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.parser.ParserImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;

public class PebbleEngine {
    private Loader loader;
    private final Parser parser;
    private final Lexer lexer;
    private boolean strictVariables = false;
    private Locale defaultLocale = Locale.getDefault();
    private ExecutorService executorService;
    private Cache<String, PebbleTemplate> templateCache;
    private HashMap<Class<? extends Extension>, Extension> extensions = new HashMap();
    private Map<String, TokenParser> tokenParsers = new HashMap<String, TokenParser>();
    private Map<String, UnaryOperator> unaryOperators = new HashMap<String, UnaryOperator>();
    private Map<String, BinaryOperator> binaryOperators = new HashMap<String, BinaryOperator>();
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private Map<String, Test> tests = new HashMap<String, Test>();
    private Map<String, Object> globalVariables = new HashMap<String, Object>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private List<NodeVisitor> nodeVisitors = new ArrayList<NodeVisitor>();
    private final Semaphore compilationMutex = new Semaphore(1, true);

    public PebbleEngine() {
        this(null);
    }

    public PebbleEngine(Loader loader) {
        if (loader == null) {
            ArrayList<Loader> defaultLoadingStrategies = new ArrayList<Loader>();
            defaultLoadingStrategies.add(new FileLoader());
            defaultLoadingStrategies.add(new ClasspathLoader());
            loader = new DelegatingLoader(defaultLoadingStrategies);
        }
        this.templateCache = CacheBuilder.newBuilder().maximumSize(200L).build();
        this.loader = loader;
        this.lexer = new LexerImpl(this);
        this.parser = new ParserImpl(this);
        this.addExtension(new CoreExtension());
        this.addExtension(new EscaperExtension());
        this.addExtension(new I18nExtension());
    }

    public PebbleTemplate getTemplate(final String templateName) throws PebbleException {
        if (templateName == null) {
            return null;
        }
        if (this.loader == null) {
            throw new LoaderException(null, "Loader has not yet been specified.");
        }
        final PebbleEngine self = this;
        PebbleTemplate result = null;
        try {
            result = (PebbleTemplate)this.templateCache.get((Object)templateName, (Callable)new Callable<PebbleTemplate>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PebbleTemplateImpl call() throws Exception {
                    PebbleEngine.this.compilationMutex.acquire();
                    PebbleTemplateImpl instance = null;
                    RootNode root = null;
                    try {
                        Reader templateReader = PebbleEngine.this.loader.getReader(templateName);
                        TokenStream tokenStream = PebbleEngine.this.lexer.tokenize(templateReader, templateName);
                        root = PebbleEngine.this.parser.parse(tokenStream);
                        instance = new PebbleTemplateImpl(self, root, templateName);
                        for (NodeVisitor visitor : PebbleEngine.this.nodeVisitors) {
                            visitor.setTemplate(instance);
                            visitor.visit(root);
                        }
                    }
                    finally {
                        PebbleEngine.this.compilationMutex.release();
                    }
                    return instance;
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof PebbleException) {
                throw (PebbleException)e.getCause();
            }
            throw new PebbleException(e, String.format("An error occurred while compiling %s", templateName));
        }
        return result;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void addExtension(Extension extension) {
        List<NodeVisitor> nodeVisitors;
        Map<String, Object> globalVariables;
        Map<String, Function> functions;
        Map<String, Test> tests;
        Map<String, Filter> map;
        List<UnaryOperator> list;
        List<BinaryOperator> binaryOperators;
        this.extensions.put(extension.getClass(), extension);
        List<TokenParser> tokenParsers = extension.getTokenParsers();
        if (tokenParsers != null) {
            for (TokenParser tokenParser : tokenParsers) {
                this.tokenParsers.put(tokenParser.getTag(), tokenParser);
            }
        }
        if ((binaryOperators = extension.getBinaryOperators()) != null) {
            for (BinaryOperator binaryOperator : binaryOperators) {
                if (this.binaryOperators.containsKey(binaryOperator.getSymbol())) continue;
                this.binaryOperators.put(binaryOperator.getSymbol(), binaryOperator);
            }
        }
        if ((list = extension.getUnaryOperators()) != null) {
            for (UnaryOperator operator : list) {
                if (this.unaryOperators.containsKey(operator.getSymbol())) continue;
                this.unaryOperators.put(operator.getSymbol(), operator);
            }
        }
        if ((map = extension.getFilters()) != null) {
            this.filters.putAll(map);
        }
        if ((tests = extension.getTests()) != null) {
            this.tests.putAll(tests);
        }
        if ((functions = extension.getFunctions()) != null) {
            this.functions.putAll(functions);
        }
        if ((globalVariables = extension.getGlobalVariables()) != null) {
            this.globalVariables.putAll(globalVariables);
        }
        if ((nodeVisitors = extension.getNodeVisitors()) != null) {
            this.nodeVisitors.addAll(nodeVisitors);
        }
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public Map<String, TokenParser> getTokenParsers() {
        return this.tokenParsers;
    }

    public Map<String, BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public Map<String, UnaryOperator> getUnaryOperators() {
        return this.unaryOperators;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public Map<String, Test> getTests() {
        return this.tests;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<NodeVisitor> getNodeVisitors() {
        return this.nodeVisitors;
    }

    public Cache<String, PebbleTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public void setTemplateCache(Cache<String, PebbleTemplate> cache) {
        this.templateCache = cache == null ? CacheBuilder.newBuilder().maximumSize(0L).build() : cache;
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public void setStrictVariables(boolean strictVariables) {
        this.strictVariables = strictVariables;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

