/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Hasher;
import org.mapdb.LongHashMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;

public class SerializerBase
implements Serializer<Object> {
    protected static final String EMPTY_STRING = "";

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        this.serialize(out, obj, null);
    }

    public void serialize(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        if (objectStack != null) {
            int indexInObjectStack = objectStack.identityIndexOf(obj);
            if (indexInObjectStack != -1) {
                out.write(174);
                DataOutput2.packInt(out, indexInObjectStack);
                return;
            }
            objectStack.add(obj);
        }
        if (obj == null) {
            out.write(1);
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.class) {
            this.serializeInt(out, obj);
            return;
        }
        if (clazz == Long.class) {
            this.serializeLong(out, obj);
            return;
        }
        if (clazz == String.class) {
            this.serializeString(out, obj);
            return;
        }
        if (clazz == Boolean.class) {
            out.write((Boolean)obj != false ? 2 : 3);
            return;
        }
        if (clazz == Byte.class) {
            this.serializeByte(out, obj);
            return;
        }
        if (clazz == Character.class) {
            this.serializerChar(out, obj);
            return;
        }
        if (clazz == Short.class) {
            this.serializeShort(out, obj);
            return;
        }
        if (clazz == Float.class) {
            this.serializeFloat(out, obj);
            return;
        }
        if (clazz == Double.class) {
            this.serializeDouble(out, obj);
            return;
        }
        this.serialize2(out, obj, objectStack, clazz);
    }

    private void serialize2(DataOutput out, Object obj, FastArrayList<Object> objectStack, Class<?> clazz) throws IOException {
        if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            this.serializeByteArray(out, b);
            return;
        }
        if (obj instanceof boolean[]) {
            out.write(111);
            boolean[] a_bool = (boolean[])obj;
            DataOutput2.packInt(out, a_bool.length);
            byte[] a = SerializerBase.booleanToByteArray(a_bool);
            out.write(a);
            return;
        }
        if (obj instanceof short[]) {
            out.write(112);
            short[] a = (short[])obj;
            DataOutput2.packInt(out, a.length);
            short[] sArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                short s = sArray[n2];
                out.writeShort(s);
                ++n2;
            }
            return;
        }
        if (obj instanceof char[]) {
            out.write(113);
            char[] a = (char[])obj;
            DataOutput2.packInt(out, a.length);
            char[] cArray = a;
            int n = a.length;
            int n3 = 0;
            while (n3 < n) {
                char s = cArray[n3];
                out.writeChar(s);
                ++n3;
            }
            return;
        }
        if (obj instanceof float[]) {
            out.write(114);
            float[] a = (float[])obj;
            DataOutput2.packInt(out, a.length);
            float[] fArray = a;
            int n = a.length;
            int n4 = 0;
            while (n4 < n) {
                float s = fArray[n4];
                out.writeFloat(s);
                ++n4;
            }
            return;
        }
        if (obj instanceof double[]) {
            out.write(115);
            double[] a = (double[])obj;
            DataOutput2.packInt(out, a.length);
            double[] dArray = a;
            int n = a.length;
            int n5 = 0;
            while (n5 < n) {
                double s = dArray[n5];
                out.writeDouble(s);
                ++n5;
            }
            return;
        }
        if (obj instanceof int[]) {
            this.serializeIntArray(out, (int[])obj);
            return;
        }
        if (obj instanceof long[]) {
            this.serializeLongArray(out, (long[])obj);
            return;
        }
        if (clazz == BigInteger.class) {
            out.write(138);
            byte[] buf = ((BigInteger)obj).toByteArray();
            DataOutput2.packInt(out, buf.length);
            out.write(buf);
            return;
        }
        if (clazz == BigDecimal.class) {
            out.write(137);
            BigDecimal d = (BigDecimal)obj;
            byte[] buf = d.unscaledValue().toByteArray();
            DataOutput2.packInt(out, buf.length);
            out.write(buf);
            DataOutput2.packInt(out, d.scale());
            return;
        }
        if (obj instanceof Class) {
            out.write(139);
            this.serializeClass(out, (Class)obj);
            return;
        }
        if (clazz == Date.class) {
            out.write(140);
            out.writeLong(((Date)obj).getTime());
            return;
        }
        if (clazz == UUID.class) {
            out.write(142);
            out.writeLong(((UUID)obj).getMostSignificantBits());
            out.writeLong(((UUID)obj).getLeastSignificantBits());
            return;
        }
        if (obj == Fun.HI) {
            out.write(141);
            return;
        }
        Integer mapdbSingletonHeader = singletons.all.get(obj);
        if (mapdbSingletonHeader != null) {
            out.write(150);
            DataOutput2.packInt(out, mapdbSingletonHeader);
            return;
        }
        if (obj instanceof Atomic.Long) {
            out.write(176);
            DataOutput2.packLong(out, ((Atomic.Long)obj).recid);
            return;
        }
        if (obj instanceof Atomic.Integer) {
            out.write(177);
            DataOutput2.packLong(out, ((Atomic.Integer)obj).recid);
            return;
        }
        if (obj instanceof Atomic.Boolean) {
            out.write(178);
            DataOutput2.packLong(out, ((Atomic.Boolean)obj).recid);
            return;
        }
        if (obj instanceof Atomic.String) {
            out.write(179);
            DataOutput2.packLong(out, ((Atomic.String)obj).recid);
            return;
        }
        if (obj == this) {
            out.write(150);
            DataOutput2.packInt(out, 12);
            return;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList();
            objectStack.add(obj);
        }
        if (obj instanceof Object[]) {
            Class<?> componentType;
            Object o;
            int n;
            int n6;
            Object[] objectArray;
            Object[] b = (Object[])obj;
            boolean packableLongs = b.length <= 255;
            boolean allNull = true;
            if (packableLongs) {
                objectArray = b;
                n6 = b.length;
                n = 0;
                while (n < n6) {
                    o = objectArray[n];
                    if (o != null) {
                        allNull = false;
                        if (o.getClass() != Long.class || (Long)o < 0L && (Long)o != Long.MAX_VALUE) {
                            packableLongs = false;
                        }
                    }
                    if (packableLongs || allNull) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                objectArray = b;
                n6 = b.length;
                n = 0;
                while (n < n6) {
                    o = objectArray[n];
                    if (o != null) {
                        allNull = false;
                        break;
                    }
                    ++n;
                }
            }
            if (allNull) {
                out.write(161);
                DataOutput2.packInt(out, b.length);
                componentType = obj.getClass().getComponentType();
                this.serializeClass(out, componentType);
            } else if (packableLongs) {
                out.write(159);
                out.write(b.length);
                objectArray = b;
                n6 = b.length;
                n = 0;
                while (n < n6) {
                    o = objectArray[n];
                    if (o == null) {
                        DataOutput2.packLong(out, 0L);
                    } else {
                        DataOutput2.packLong(out, (Long)o + 1L);
                    }
                    ++n;
                }
            } else {
                out.write(158);
                DataOutput2.packInt(out, b.length);
                componentType = obj.getClass().getComponentType();
                this.serializeClass(out, componentType);
                Object[] objectArray2 = b;
                int n7 = b.length;
                n6 = 0;
                while (n6 < n7) {
                    Object o2 = objectArray2[n6];
                    this.serialize(out, o2, objectStack);
                    ++n6;
                }
            }
        } else if (clazz == ArrayList.class) {
            boolean packableLongs;
            ArrayList l = (ArrayList)obj;
            boolean bl = packableLongs = l.size() < 255;
            if (packableLongs) {
                for (Object o : l) {
                    if (o == null || o.getClass() == Long.class && ((Long)o >= 0L || (Long)o == Long.MAX_VALUE)) continue;
                    packableLongs = false;
                    break;
                }
            }
            if (packableLongs) {
                out.write(160);
                out.write(l.size());
                for (Object o : l) {
                    if (o == null) {
                        DataOutput2.packLong(out, 0L);
                        continue;
                    }
                    DataOutput2.packLong(out, (Long)o + 1L);
                }
            } else {
                this.serializeCollection(163, out, obj, objectStack);
            }
        } else if (clazz == LinkedList.class) {
            this.serializeCollection(170, out, obj, objectStack);
        } else if (clazz == TreeSet.class) {
            TreeSet l = (TreeSet)obj;
            out.write(167);
            DataOutput2.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l) {
                this.serialize(out, o, objectStack);
            }
        } else if (clazz == HashSet.class) {
            this.serializeCollection(168, out, obj, objectStack);
        } else if (clazz == LinkedHashSet.class) {
            this.serializeCollection(169, out, obj, objectStack);
        } else if (clazz == TreeMap.class) {
            TreeMap l = (TreeMap)obj;
            out.write(164);
            DataOutput2.packInt(out, l.size());
            this.serialize(out, l.comparator(), objectStack);
            for (Object o : l.keySet()) {
                this.serialize(out, o, objectStack);
                this.serialize(out, l.get(o), objectStack);
            }
        } else if (clazz == HashMap.class) {
            this.serializeMap(165, out, obj, objectStack);
        } else if (clazz == LinkedHashMap.class) {
            this.serializeMap(166, out, obj, objectStack);
        } else if (clazz == Properties.class) {
            this.serializeMap(171, out, obj, objectStack);
        } else if (clazz == Fun.Tuple2.class) {
            out.write(151);
            Fun.Tuple2 t = (Fun.Tuple2)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
        } else if (clazz == Fun.Tuple3.class) {
            out.write(152);
            Fun.Tuple3 t = (Fun.Tuple3)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
        } else if (clazz == Fun.Tuple4.class) {
            out.write(153);
            Fun.Tuple4 t = (Fun.Tuple4)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
            this.serialize(out, t.d, objectStack);
        } else if (clazz == Fun.Tuple5.class) {
            out.write(154);
            Fun.Tuple5 t = (Fun.Tuple5)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
            this.serialize(out, t.d, objectStack);
            this.serialize(out, t.e, objectStack);
        } else if (clazz == Fun.Tuple6.class) {
            out.write(155);
            Fun.Tuple6 t = (Fun.Tuple6)obj;
            this.serialize(out, t.a, objectStack);
            this.serialize(out, t.b, objectStack);
            this.serialize(out, t.c, objectStack);
            this.serialize(out, t.d, objectStack);
            this.serialize(out, t.e, objectStack);
            this.serialize(out, t.f, objectStack);
        } else if (clazz == BTreeKeySerializer.Tuple2KeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 7);
            BTreeKeySerializer.Tuple2KeySerializer s = (BTreeKeySerializer.Tuple2KeySerializer)obj;
            this.serialize(out, s.aComparator, objectStack);
            this.serialize(out, s.aSerializer, objectStack);
            this.serialize(out, s.bSerializer, objectStack);
        } else if (clazz == BTreeKeySerializer.Tuple3KeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 8);
            BTreeKeySerializer.Tuple3KeySerializer s = (BTreeKeySerializer.Tuple3KeySerializer)obj;
            this.serialize(out, s.aComparator, objectStack);
            this.serialize(out, s.bComparator, objectStack);
            this.serialize(out, s.aSerializer, objectStack);
            this.serialize(out, s.bSerializer, objectStack);
            this.serialize(out, s.cSerializer, objectStack);
        } else if (clazz == BTreeKeySerializer.Tuple4KeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 9);
            BTreeKeySerializer.Tuple4KeySerializer s = (BTreeKeySerializer.Tuple4KeySerializer)obj;
            this.serialize(out, s.aComparator, objectStack);
            this.serialize(out, s.bComparator, objectStack);
            this.serialize(out, s.cComparator, objectStack);
            this.serialize(out, s.aSerializer, objectStack);
            this.serialize(out, s.bSerializer, objectStack);
            this.serialize(out, s.cSerializer, objectStack);
            this.serialize(out, s.dSerializer, objectStack);
        } else if (clazz == BTreeKeySerializer.Tuple5KeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 55);
            BTreeKeySerializer.Tuple5KeySerializer s = (BTreeKeySerializer.Tuple5KeySerializer)obj;
            this.serialize(out, s.aComparator, objectStack);
            this.serialize(out, s.bComparator, objectStack);
            this.serialize(out, s.cComparator, objectStack);
            this.serialize(out, s.dComparator, objectStack);
            this.serialize(out, s.aSerializer, objectStack);
            this.serialize(out, s.bSerializer, objectStack);
            this.serialize(out, s.cSerializer, objectStack);
            this.serialize(out, s.dSerializer, objectStack);
            this.serialize(out, s.eSerializer, objectStack);
        } else if (clazz == BTreeKeySerializer.Tuple6KeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 56);
            BTreeKeySerializer.Tuple6KeySerializer s = (BTreeKeySerializer.Tuple6KeySerializer)obj;
            this.serialize(out, s.aComparator, objectStack);
            this.serialize(out, s.bComparator, objectStack);
            this.serialize(out, s.cComparator, objectStack);
            this.serialize(out, s.dComparator, objectStack);
            this.serialize(out, s.eComparator, objectStack);
            this.serialize(out, s.aSerializer, objectStack);
            this.serialize(out, s.bSerializer, objectStack);
            this.serialize(out, s.cSerializer, objectStack);
            this.serialize(out, s.dSerializer, objectStack);
            this.serialize(out, s.eSerializer, objectStack);
            this.serialize(out, s.fSerializer, objectStack);
        } else if (clazz == BTreeKeySerializer.BasicKeySerializer.class) {
            out.write(150);
            DataOutput2.packInt(out, 15);
            this.serialize(out, ((BTreeKeySerializer.BasicKeySerializer)obj).defaultSerializer, objectStack);
        } else if (clazz == Fun.ArrayComparator.class) {
            out.write(150);
            DataOutput2.packInt(out, 45);
            this.serialize(out, ((Fun.ArrayComparator)obj).comparators, objectStack);
        } else if (clazz == Serializer.CompressionWrapper.class) {
            out.write(150);
            DataOutput2.packInt(out, 47);
            this.serialize(out, ((Serializer.CompressionWrapper)obj).serializer, objectStack);
        } else if (obj instanceof Fun.Tuple2Comparator) {
            out.write(150);
            DataOutput2.packInt(out, 22);
            Fun.Tuple2Comparator c = (Fun.Tuple2Comparator)obj;
            this.serialize(out, c.a, objectStack);
            this.serialize(out, c.b, objectStack);
        } else if (obj instanceof Fun.Tuple3Comparator) {
            out.write(150);
            DataOutput2.packInt(out, 23);
            Fun.Tuple3Comparator c = (Fun.Tuple3Comparator)obj;
            this.serialize(out, c.a, objectStack);
            this.serialize(out, c.b, objectStack);
            this.serialize(out, c.c, objectStack);
        } else if (obj instanceof Fun.Tuple4Comparator) {
            out.write(150);
            DataOutput2.packInt(out, 24);
            Fun.Tuple4Comparator c = (Fun.Tuple4Comparator)obj;
            this.serialize(out, c.a, objectStack);
            this.serialize(out, c.b, objectStack);
            this.serialize(out, c.c, objectStack);
            this.serialize(out, c.d, objectStack);
        } else if (obj instanceof Fun.Tuple5Comparator) {
            out.write(150);
            DataOutput2.packInt(out, 51);
            Fun.Tuple5Comparator c = (Fun.Tuple5Comparator)obj;
            this.serialize(out, c.a, objectStack);
            this.serialize(out, c.b, objectStack);
            this.serialize(out, c.c, objectStack);
            this.serialize(out, c.d, objectStack);
            this.serialize(out, c.e, objectStack);
        } else if (obj instanceof Fun.Tuple6Comparator) {
            out.write(150);
            DataOutput2.packInt(out, 52);
            Fun.Tuple6Comparator c = (Fun.Tuple6Comparator)obj;
            this.serialize(out, c.a, objectStack);
            this.serialize(out, c.b, objectStack);
            this.serialize(out, c.c, objectStack);
            this.serialize(out, c.d, objectStack);
            this.serialize(out, c.e, objectStack);
            this.serialize(out, c.f, objectStack);
        } else if (obj instanceof Atomic.Var) {
            out.write(180);
            Atomic.Var v = (Atomic.Var)obj;
            DataOutput2.packLong(out, v.recid);
            this.serialize(out, v.serializer, objectStack);
        } else {
            this.serializeUnknownObject(out, obj, objectStack);
        }
    }

    private void serializeString(DataOutput out, Object obj) throws IOException {
        String val = (String)obj;
        int len = val.length();
        if (len == 0) {
            out.write(125);
        } else {
            if (len <= 10) {
                out.write(125 + len);
            } else {
                out.write(136);
                DataOutput2.packInt(out, len);
            }
            int i = 0;
            while (i < len) {
                DataOutput2.packInt(out, ((String)obj).charAt(i));
                ++i;
            }
        }
    }

    private void serializeLongArray(DataOutput out, long[] val) throws IOException {
        long i;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        long[] lArray = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            i = lArray[n2];
            max = Math.max(max, i);
            min = Math.min(min, i);
            ++n2;
        }
        if (-128L <= min && max <= 127L) {
            out.write(120);
            DataOutput2.packInt(out, val.length);
            lArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = lArray[n2];
                out.write((int)i);
                ++n2;
            }
        } else if (-32768L <= min && max <= 32767L) {
            out.write(121);
            DataOutput2.packInt(out, val.length);
            lArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = lArray[n2];
                out.writeShort((int)i);
                ++n2;
            }
        } else if (0L <= min) {
            out.write(122);
            DataOutput2.packInt(out, val.length);
            lArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                DataOutput2.packLong(out, l);
                ++n2;
            }
        } else if (Integer.MIN_VALUE <= min && max <= Integer.MAX_VALUE) {
            out.write(123);
            DataOutput2.packInt(out, val.length);
            lArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = lArray[n2];
                out.writeInt((int)i);
                ++n2;
            }
        } else {
            out.write(124);
            DataOutput2.packInt(out, val.length);
            lArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = lArray[n2];
                out.writeLong(i);
                ++n2;
            }
        }
    }

    private void serializeIntArray(DataOutput out, int[] val) throws IOException {
        int i;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int[] nArray = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            max = Math.max(max, i);
            min = Math.min(min, i);
            ++n2;
        }
        if (-128 <= min && max <= 127) {
            out.write(116);
            DataOutput2.packInt(out, val.length);
            nArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = nArray[n2];
                out.write(i);
                ++n2;
            }
        } else if (Short.MIN_VALUE <= min && max <= Short.MAX_VALUE) {
            out.write(117);
            DataOutput2.packInt(out, val.length);
            nArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = nArray[n2];
                out.writeShort(i);
                ++n2;
            }
        } else if (min >= 0) {
            out.write(118);
            DataOutput2.packInt(out, val.length);
            nArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                int l = nArray[n2];
                DataOutput2.packInt(out, l);
                ++n2;
            }
        } else {
            out.write(119);
            DataOutput2.packInt(out, val.length);
            nArray = val;
            n = val.length;
            n2 = 0;
            while (n2 < n) {
                i = nArray[n2];
                out.writeInt(i);
                ++n2;
            }
        }
    }

    private void serializeDouble(DataOutput out, Object obj) throws IOException {
        double v = (Double)obj;
        if (v == -1.0) {
            out.write(102);
        } else if (v == 0.0) {
            out.write(103);
        } else if (v == 1.0) {
            out.write(104);
        } else if (v >= 0.0 && v <= 255.0 && (double)((int)v) == v) {
            out.write(105);
            out.write((int)v);
        } else if (v >= -32768.0 && v <= 32767.0 && (double)((short)v) == v) {
            out.write(106);
            out.writeShort((int)v);
        } else if (v >= -2.147483648E9 && v <= 2.147483647E9 && (double)((int)v) == v) {
            out.write(107);
            out.writeInt((int)v);
        } else {
            out.write(108);
            out.writeDouble(v);
        }
    }

    private void serializeFloat(DataOutput out, Object obj) throws IOException {
        float v = ((Float)obj).floatValue();
        if (v == -1.0f) {
            out.write(96);
        } else if (v == 0.0f) {
            out.write(97);
        } else if (v == 1.0f) {
            out.write(98);
        } else if (v >= 0.0f && v <= 255.0f && (float)((int)v) == v) {
            out.write(99);
            out.write((int)v);
        } else if (v >= -32768.0f && v <= 32767.0f && (float)((short)v) == v) {
            out.write(100);
            out.writeShort((int)v);
        } else {
            out.write(101);
            out.writeFloat(v);
        }
    }

    private void serializeShort(DataOutput out, Object obj) throws IOException {
        short val = (Short)obj;
        if (val == -1) {
            out.write(90);
        } else if (val == 0) {
            out.write(91);
        } else if (val == 1) {
            out.write(92);
        } else if (val > 0 && val < 255) {
            out.write(93);
            out.write(val);
        } else if (val < 0 && val > -255) {
            out.write(94);
            out.write(-val);
        } else {
            out.write(95);
            out.writeShort(val);
        }
    }

    private void serializerChar(DataOutput out, Object obj) throws IOException {
        char val = ((Character)obj).charValue();
        if (val == '\u0000') {
            out.write(86);
        } else if (val == '\u0001') {
            out.write(87);
        } else if (val <= '\u00ff') {
            out.write(88);
            out.write(val);
        } else {
            out.write(89);
            out.writeChar(((Character)obj).charValue());
        }
    }

    private void serializeByte(DataOutput out, Object obj) throws IOException {
        byte val = (Byte)obj;
        if (val == -1) {
            out.write(82);
        } else if (val == 0) {
            out.write(83);
        } else if (val == 1) {
            out.write(84);
        } else {
            out.write(85);
            out.writeByte(val);
        }
    }

    private void serializeLong(DataOutput out, Object obj) throws IOException {
        long val = (Long)obj;
        if (val >= -9L && val <= 16L) {
            out.write((int)(39L + (val + 9L)));
            return;
        }
        if (val == Long.MIN_VALUE) {
            out.write(65);
            return;
        }
        if (val == Long.MAX_VALUE) {
            out.write(66);
            return;
        }
        if ((Math.abs(val) >>> 56 & 0xFFL) != 0L) {
            out.write(81);
            out.writeLong(val);
            return;
        }
        int neg = 0;
        if (val < 0L) {
            neg = -1;
            val = -val;
        }
        int size = 48;
        while ((val >> size & 0xFFL) == 0L) {
            size -= 8;
        }
        out.write(68 + size / 8 * 2 + neg);
        while (size >= 0) {
            out.write((int)(val >> size & 0xFFL));
            size -= 8;
        }
    }

    private void serializeInt(DataOutput out, Object obj) throws IOException {
        int val = (Integer)obj;
        switch (val) {
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                out.write(4 + (val + 9));
                return;
            }
            case -2147483648: {
                out.write(30);
                return;
            }
            case 0x7FFFFFFF: {
                out.write(31);
                return;
            }
        }
        if ((Math.abs(val) >>> 24 & 0xFF) != 0) {
            out.write(38);
            out.writeInt(val);
            return;
        }
        int neg = 0;
        if (val < 0) {
            neg = -1;
            val = -val;
        }
        int size = 24;
        while (((long)(val >> size) & 0xFFL) == 0L) {
            size -= 8;
        }
        out.write(33 + size / 8 * 2 + neg);
        while (size >= 0) {
            out.write((int)((long)(val >> size) & 0xFFL));
            size -= 8;
        }
    }

    protected void serializeClass(DataOutput out, Class clazz) throws IOException {
        out.writeUTF(clazz.getName());
    }

    private void serializeMap(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Map l = (Map)obj;
        out.write(header);
        DataOutput2.packInt(out, l.size());
        for (Object o : l.keySet()) {
            this.serialize(out, o, objectStack);
            this.serialize(out, l.get(o), objectStack);
        }
    }

    private void serializeCollection(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Collection l = (Collection)obj;
        out.write(header);
        DataOutput2.packInt(out, l.size());
        for (Object o : l) {
            this.serialize(out, o, objectStack);
        }
    }

    private void serializeByteArray(DataOutput out, byte[] b) throws IOException {
        boolean allEqual = b.length > 0;
        int i = 1;
        while (i < b.length) {
            if (b[i - 1] != b[i]) {
                allEqual = false;
                break;
            }
            ++i;
        }
        if (allEqual) {
            out.write(110);
            DataOutput2.packInt(out, b.length);
            out.write(b[0]);
        } else {
            out.write(109);
            DataOutput2.packInt(out, b.length);
            out.write(b);
        }
    }

    static String deserializeString(DataInput buf, int len) throws IOException {
        char[] b = new char[len];
        int i = 0;
        while (i < len) {
            b[i] = (char)DataInput2.unpackInt(buf);
            ++i;
        }
        return new String(b);
    }

    @Override
    public Object deserialize(DataInput is, int capacity) throws IOException {
        if (capacity == 0) {
            return null;
        }
        return this.deserialize(is, null);
    }

    public Object deserialize(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        Object ret = null;
        int ir = 0;
        long lr = 0L;
        int head = is.readUnsignedByte();
        switch (head) {
            case 0: {
                throw new IOError(new IOException("Zero Header, data corrupted"));
            }
            case 1: {
                break;
            }
            case 2: {
                ret = Boolean.TRUE;
                break;
            }
            case 3: {
                ret = Boolean.FALSE;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                ret = head - 4 - 9;
                break;
            }
            case 30: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 31: {
                ret = Integer.MAX_VALUE;
                break;
            }
            case 36: 
            case 37: {
                ir = is.readUnsignedByte() & 0xFF;
            }
            case 34: 
            case 35: {
                ir = ir << 8 | is.readUnsignedByte() & 0xFF;
            }
            case 32: 
            case 33: {
                ir = ir << 8 | is.readUnsignedByte() & 0xFF;
                if (head % 2 == 0) {
                    ir = -ir;
                }
                ret = ir;
                break;
            }
            case 38: {
                ret = is.readInt();
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                ret = (long)(head - 39 - 9);
                break;
            }
            case 65: {
                ret = Long.MIN_VALUE;
                break;
            }
            case 66: {
                ret = Long.MAX_VALUE;
                break;
            }
            case 79: 
            case 80: {
                lr = (long)is.readUnsignedByte() & 0xFFL;
            }
            case 77: 
            case 78: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
            }
            case 75: 
            case 76: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
            }
            case 73: 
            case 74: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
            }
            case 71: 
            case 72: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
            }
            case 69: 
            case 70: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
            }
            case 67: 
            case 68: {
                lr = lr << 8 | (long)is.readUnsignedByte() & 0xFFL;
                if (head % 2 == 1) {
                    lr = -lr;
                }
                ret = lr;
                break;
            }
            case 81: {
                ret = is.readLong();
                break;
            }
            case 82: {
                ret = (byte)-1;
                break;
            }
            case 83: {
                ret = (byte)0;
                break;
            }
            case 84: {
                ret = (byte)1;
                break;
            }
            case 85: {
                ret = is.readByte();
                break;
            }
            case 86: {
                ret = Character.valueOf('\u0000');
                break;
            }
            case 87: {
                ret = Character.valueOf('\u0001');
                break;
            }
            case 88: {
                ret = Character.valueOf((char)is.readUnsignedByte());
                break;
            }
            case 89: {
                ret = Character.valueOf(is.readChar());
                break;
            }
            case 90: {
                ret = (short)-1;
                break;
            }
            case 91: {
                ret = (short)0;
                break;
            }
            case 92: {
                ret = (short)1;
                break;
            }
            case 93: {
                ret = (short)is.readUnsignedByte();
                break;
            }
            case 94: {
                ret = (short)(-is.readUnsignedByte());
                break;
            }
            case 95: {
                ret = is.readShort();
                break;
            }
            case 96: {
                ret = Float.valueOf(-1.0f);
                break;
            }
            case 97: {
                ret = Float.valueOf(0.0f);
                break;
            }
            case 98: {
                ret = Float.valueOf(1.0f);
                break;
            }
            case 99: {
                ret = Float.valueOf(is.readUnsignedByte());
                break;
            }
            case 100: {
                ret = Float.valueOf(is.readShort());
                break;
            }
            case 101: {
                ret = Float.valueOf(is.readFloat());
                break;
            }
            case 102: {
                ret = -1.0;
                break;
            }
            case 103: {
                ret = 0.0;
                break;
            }
            case 104: {
                ret = 1.0;
                break;
            }
            case 105: {
                ret = (double)is.readUnsignedByte();
                break;
            }
            case 106: {
                ret = (double)is.readShort();
                break;
            }
            case 107: {
                ret = (double)is.readInt();
                break;
            }
            case 108: {
                ret = is.readDouble();
                break;
            }
            case 136: {
                ret = SerializerBase.deserializeString(is, DataInput2.unpackInt(is));
                break;
            }
            case 125: {
                ret = EMPTY_STRING;
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                ret = SerializerBase.deserializeString(is, head - 125);
                break;
            }
            case -1: {
                throw new EOFException();
            }
        }
        if (ret == null) {
            ret = this.deserialize2(head, is);
        }
        if (ret != null || head == 1) {
            if (objectStack != null) {
                objectStack.add(ret);
            }
            return ret;
        }
        if (objectStack == null) {
            objectStack = new FastArrayList();
        }
        int oldObjectStackSize = objectStack.size;
        ret = this.deserialize3(is, objectStack, head);
        if (head != 174 && objectStack.size == oldObjectStackSize) {
            objectStack.add(ret);
        }
        return ret;
    }

    private Object deserialize3(DataInput is, FastArrayList<Object> objectStack, int head) throws IOException {
        Object ret;
        switch (head) {
            case 174: {
                ret = objectStack.data[DataInput2.unpackInt(is)];
                break;
            }
            case 163: {
                ret = this.deserializeArrayList(is, objectStack);
                break;
            }
            case 158: {
                ret = this.deserializeArrayObject(is, objectStack);
                break;
            }
            case 170: {
                ret = this.deserializeLinkedList(is, objectStack);
                break;
            }
            case 167: {
                ret = this.deserializeTreeSet(is, objectStack);
                break;
            }
            case 168: {
                ret = this.deserializeHashSet(is, objectStack);
                break;
            }
            case 169: {
                ret = this.deserializeLinkedHashSet(is, objectStack);
                break;
            }
            case 164: {
                ret = this.deserializeTreeMap(is, objectStack);
                break;
            }
            case 165: {
                ret = this.deserializeHashMap(is, objectStack);
                break;
            }
            case 166: {
                ret = this.deserializeLinkedHashMap(is, objectStack);
                break;
            }
            case 171: {
                ret = this.deserializeProperties(is, objectStack);
                break;
            }
            case 176: {
                ret = new Atomic.Long(this.getEngine(), DataInput2.unpackLong(is));
                break;
            }
            case 177: {
                ret = new Atomic.Integer(this.getEngine(), DataInput2.unpackLong(is));
                break;
            }
            case 178: {
                ret = new Atomic.Boolean(this.getEngine(), DataInput2.unpackLong(is));
                break;
            }
            case 179: {
                ret = new Atomic.String(this.getEngine(), DataInput2.unpackLong(is));
                break;
            }
            case 151: {
                ret = new Fun.Tuple2(this, is, objectStack);
                break;
            }
            case 152: {
                ret = new Fun.Tuple3(this, is, objectStack, 0);
                break;
            }
            case 153: {
                ret = new Fun.Tuple4(this, is, objectStack);
                break;
            }
            case 154: {
                ret = new Fun.Tuple5(this, is, objectStack);
                break;
            }
            case 155: {
                ret = new Fun.Tuple6(this, is, objectStack);
                break;
            }
            case 180: {
                ret = new Atomic.Var(this.getEngine(), this, is, objectStack);
                break;
            }
            case 150: {
                ret = this.deserializeMapDB(is, objectStack);
                break;
            }
            default: {
                ret = this.deserializeUnknownHeader(is, head, objectStack);
            }
        }
        return ret;
    }

    private Object deserialize2(int head, DataInput is) throws IOException {
        Object ret;
        switch (head) {
            case 110: {
                byte[] b = new byte[DataInput2.unpackInt(is)];
                Arrays.fill(b, is.readByte());
                ret = b;
                break;
            }
            case 109: {
                ret = this.deserializeArrayByte(is);
                break;
            }
            case 111: {
                ret = SerializerBase.readBooleanArray(DataInput2.unpackInt(is), is);
                break;
            }
            case 112: {
                int size = DataInput2.unpackInt(is);
                ret = new short[size];
                int i = 0;
                while (i < size) {
                    ((short[])ret)[i] = is.readShort();
                    ++i;
                }
                break;
            }
            case 115: {
                int size = DataInput2.unpackInt(is);
                ret = new double[size];
                int i = 0;
                while (i < size) {
                    ((double[])ret)[i] = is.readDouble();
                    ++i;
                }
                break;
            }
            case 114: {
                int size = DataInput2.unpackInt(is);
                ret = new float[size];
                int i = 0;
                while (i < size) {
                    ((float[])ret)[i] = is.readFloat();
                    ++i;
                }
                break;
            }
            case 113: {
                int size = DataInput2.unpackInt(is);
                ret = new char[size];
                int i = 0;
                while (i < size) {
                    ((char[])ret)[i] = is.readChar();
                    ++i;
                }
                break;
            }
            case 116: {
                int size = DataInput2.unpackInt(is);
                ret = new int[size];
                int i = 0;
                while (i < size) {
                    ((int[])ret)[i] = is.readByte();
                    ++i;
                }
                break;
            }
            case 117: {
                int size = DataInput2.unpackInt(is);
                ret = new int[size];
                int i = 0;
                while (i < size) {
                    ((int[])ret)[i] = is.readShort();
                    ++i;
                }
                break;
            }
            case 118: {
                int size = DataInput2.unpackInt(is);
                ret = new int[size];
                int i = 0;
                while (i < size) {
                    ((int[])ret)[i] = DataInput2.unpackInt(is);
                    ++i;
                }
                break;
            }
            case 119: {
                int size = DataInput2.unpackInt(is);
                ret = new int[size];
                int i = 0;
                while (i < size) {
                    ((int[])ret)[i] = is.readInt();
                    ++i;
                }
                break;
            }
            case 120: {
                int size = DataInput2.unpackInt(is);
                ret = new long[size];
                int i = 0;
                while (i < size) {
                    ((long[])ret)[i] = is.readByte();
                    ++i;
                }
                break;
            }
            case 121: {
                int size = DataInput2.unpackInt(is);
                ret = new long[size];
                int i = 0;
                while (i < size) {
                    ((long[])ret)[i] = is.readShort();
                    ++i;
                }
                break;
            }
            case 122: {
                int size = DataInput2.unpackInt(is);
                ret = new long[size];
                int i = 0;
                while (i < size) {
                    ((long[])ret)[i] = DataInput2.unpackLong(is);
                    ++i;
                }
                break;
            }
            case 123: {
                int size = DataInput2.unpackInt(is);
                ret = new long[size];
                int i = 0;
                while (i < size) {
                    ((long[])ret)[i] = is.readInt();
                    ++i;
                }
                break;
            }
            case 124: {
                int size = DataInput2.unpackInt(is);
                ret = new long[size];
                int i = 0;
                while (i < size) {
                    ((long[])ret)[i] = is.readLong();
                    ++i;
                }
                break;
            }
            case 138: {
                ret = new BigInteger(this.deserializeArrayByte(is));
                break;
            }
            case 137: {
                ret = new BigDecimal(new BigInteger(this.deserializeArrayByte(is)), DataInput2.unpackInt(is));
                break;
            }
            case 139: {
                ret = this.deserializeClass(is);
                break;
            }
            case 140: {
                ret = new Date(is.readLong());
                break;
            }
            case 142: {
                ret = new UUID(is.readLong(), is.readLong());
                break;
            }
            case 160: {
                ret = this.deserializeArrayListPackedLong(is);
                break;
            }
            case 141: {
                ret = Fun.HI;
                break;
            }
            case 172: {
                throw new AssertionError((Object)"Wrong header, data were probably serialized with java.lang.ObjectOutputStream, not with MapDB serialization");
            }
            case 159: {
                ret = this.deserializeArrayObjectPackedLong(is);
                break;
            }
            case 161: {
                ret = this.deserializeArrayObjectAllNull(is);
                break;
            }
            case 162: {
                ret = this.deserializeArrayObjectNoRefs(is);
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public static void assertSerializable(Object o) {
        if (o != null && !(o instanceof Serializable) && !singletons.all.containsKey(o)) {
            throw new IllegalArgumentException("Not serializable: " + o.getClass());
        }
    }

    protected Object deserializeMapDB(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int head = DataInput2.unpackInt(is);
        Object singleton = singletons.reverse.get(head);
        if (singleton != null) {
            return singleton;
        }
        assert (objectStack != null);
        switch (head) {
            case 7: {
                return new BTreeKeySerializer.Tuple2KeySerializer(this, is, objectStack, 0);
            }
            case 45: {
                return new Fun.ArrayComparator(this, is, objectStack);
            }
            case 47: {
                return new Serializer.CompressionWrapper(this, is, objectStack);
            }
            case 8: {
                return new BTreeKeySerializer.Tuple3KeySerializer(this, is, objectStack);
            }
            case 9: {
                return new BTreeKeySerializer.Tuple4KeySerializer(this, is, objectStack);
            }
            case 55: {
                return new BTreeKeySerializer.Tuple5KeySerializer(this, is, objectStack);
            }
            case 56: {
                return new BTreeKeySerializer.Tuple6KeySerializer(this, is, objectStack);
            }
            case 22: {
                return new Fun.Tuple2Comparator(this, is, objectStack);
            }
            case 23: {
                return new Fun.Tuple3Comparator(this, is, objectStack, 0);
            }
            case 24: {
                return new Fun.Tuple4Comparator(this, is, objectStack);
            }
            case 51: {
                return new Fun.Tuple5Comparator(this, is, objectStack);
            }
            case 52: {
                return new Fun.Tuple6Comparator(this, is, objectStack);
            }
            case 15: {
                return new BTreeKeySerializer.BasicKeySerializer(this, is, objectStack);
            }
            case 12: {
                return this;
            }
        }
        throw new IOError(new IOException("Unknown header byte, data corrupted"));
    }

    protected Engine getEngine() {
        throw new UnsupportedOperationException();
    }

    protected Class deserializeClass(DataInput is) throws IOException {
        return SerializerPojo.classForName(is.readUTF());
    }

    private byte[] deserializeArrayByte(DataInput is) throws IOException {
        byte[] bb = new byte[DataInput2.unpackInt(is)];
        is.readFully(bb);
        return bb;
    }

    private Object[] deserializeArrayObject(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s[i] = this.deserialize(is, objectStack);
            ++i;
        }
        return s;
    }

    private Object[] deserializeArrayObjectNoRefs(DataInput is) throws IOException {
        int size = DataInput2.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        int i = 0;
        while (i < size) {
            s[i] = this.deserialize(is, null);
            ++i;
        }
        return s;
    }

    private Object[] deserializeArrayObjectAllNull(DataInput is) throws IOException {
        int size = DataInput2.unpackInt(is);
        Class clazz = this.deserializeClass(is);
        return (Object[])Array.newInstance(clazz, size);
    }

    private Object[] deserializeArrayObjectPackedLong(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        Object[] s = new Object[size];
        int i = 0;
        while (i < size) {
            long l = DataInput2.unpackLong(is);
            s[i] = l == 0L ? null : Long.valueOf(l - 1L);
            ++i;
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        ArrayList<Object> s = new ArrayList<Object>(size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.add(this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayListPackedLong(DataInput is) throws IOException {
        int size = is.readUnsignedByte();
        if (size < 0) {
            throw new EOFException();
        }
        ArrayList<Object> s = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            long l = DataInput2.unpackLong(is);
            if (l == 0L) {
                s.add(null);
            } else {
                s.add(l - 1L);
            }
            ++i;
        }
        return s;
    }

    private LinkedList deserializeLinkedList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        LinkedList<Object> s = new LinkedList<Object>();
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.add(this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private HashSet<Object> deserializeHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        HashSet<Object> s = new HashSet<Object>(size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.add(this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private LinkedHashSet<Object> deserializeLinkedHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.add(this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private TreeSet<Object> deserializeTreeSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        TreeSet<Object> s = new TreeSet<Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        int i = 0;
        while (i < size) {
            s.add(this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private TreeMap<Object, Object> deserializeTreeMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        int i = 0;
        while (i < size) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private HashMap<Object, Object> deserializeHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private LinkedHashMap<Object, Object> deserializeLinkedHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    private Properties deserializeProperties(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = DataInput2.unpackInt(is);
        Properties s = new Properties();
        objectStack.add(s);
        int i = 0;
        while (i < size) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
            ++i;
        }
        return s;
    }

    protected void serializeUnknownObject(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        throw new AssertionError((Object)("Could not serialize unknown object: " + obj.getClass().getName()));
    }

    protected Object deserializeUnknownHeader(DataInput is, int head, FastArrayList<Object> objectStack) throws IOException {
        throw new AssertionError((Object)("Unknown serialization header: " + head));
    }

    protected static byte[] booleanToByteArray(boolean[] bool) {
        byte b;
        int boolLen = bool.length;
        int mod8 = boolLen % 8;
        byte[] boolBytes = new byte[boolLen / 8 + (boolLen % 8 == 0 ? 0 : 1)];
        boolean isFlushWith8 = mod8 == 0;
        int length = isFlushWith8 ? boolBytes.length : boolBytes.length - 1;
        int x = 0;
        int boolByteIndex = 0;
        while (boolByteIndex < length) {
            b = (byte)((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3 | (bool[x++] ? 1 : 0) << 4 | (bool[x++] ? 1 : 0) << 5 | (bool[x++] ? 1 : 0) << 6 | (bool[x++] ? 1 : 0) << 7);
            boolBytes[boolByteIndex++] = b;
        }
        if (!isFlushWith8) {
            b = 0;
            switch (mod8) {
                case 1: {
                    b = (byte)(b | (bool[x++] ? 1 : 0) << 0);
                    break;
                }
                case 2: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1));
                    break;
                }
                case 3: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2));
                    break;
                }
                case 4: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3));
                    break;
                }
                case 5: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3 | (bool[x++] ? 1 : 0) << 4));
                    break;
                }
                case 6: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3 | (bool[x++] ? 1 : 0) << 4 | (bool[x++] ? 1 : 0) << 5));
                    break;
                }
                case 7: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3 | (bool[x++] ? 1 : 0) << 4 | (bool[x++] ? 1 : 0) << 5 | (bool[x++] ? 1 : 0) << 6));
                    break;
                }
                case 8: {
                    b = (byte)(b | ((bool[x++] ? 1 : 0) << 0 | (bool[x++] ? 1 : 0) << 1 | (bool[x++] ? 1 : 0) << 2 | (bool[x++] ? 1 : 0) << 3 | (bool[x++] ? 1 : 0) << 4 | (bool[x++] ? 1 : 0) << 5 | (bool[x++] ? 1 : 0) << 6 | (bool[x++] ? 1 : 0) << 7));
                }
            }
            boolBytes[boolByteIndex++] = b;
        }
        return boolBytes;
    }

    protected static boolean[] readBooleanArray(int numBools, DataInput is) throws IOException {
        int length = numBools / 8 + (numBools % 8 == 0 ? 0 : 1);
        byte[] boolBytes = new byte[length];
        is.readFully(boolBytes);
        boolean[] tmp = new boolean[boolBytes.length * 8];
        int len = boolBytes.length;
        int boolIndex = 0;
        byte[] byArray = boolBytes;
        int n = boolBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte boolByte = byArray[n2];
            int y = 0;
            while (y < 8) {
                tmp[boolIndex++] = (boolByte & 1 << y) != 0;
                ++y;
            }
            ++n2;
        }
        boolean[] finalBoolArray = new boolean[numBools];
        System.arraycopy(tmp, 0, finalBoolArray, 0, numBools);
        return finalBoolArray;
    }

    @Override
    public int fixedSize() {
        return -1;
    }

    protected static final class FastArrayList<K> {
        public int size = 0;
        public K[] data = new Object[1];
        public boolean forwardRefs = false;

        public void add(K o) {
            if (this.data.length == this.size) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.size] = o;
            ++this.size;
        }

        public int identityIndexOf(Object obj) {
            int i = 0;
            while (i < this.size) {
                if (obj == this.data[i]) {
                    this.forwardRefs = true;
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    protected static interface Header {
        public static final int ZERO_FAIL = 0;
        public static final int NULL = 1;
        public static final int BOOLEAN_TRUE = 2;
        public static final int BOOLEAN_FALSE = 3;
        public static final int INT_M9 = 4;
        public static final int INT_M8 = 5;
        public static final int INT_M7 = 6;
        public static final int INT_M6 = 7;
        public static final int INT_M5 = 8;
        public static final int INT_M4 = 9;
        public static final int INT_M3 = 10;
        public static final int INT_M2 = 11;
        public static final int INT_M1 = 12;
        public static final int INT_0 = 13;
        public static final int INT_1 = 14;
        public static final int INT_2 = 15;
        public static final int INT_3 = 16;
        public static final int INT_4 = 17;
        public static final int INT_5 = 18;
        public static final int INT_6 = 19;
        public static final int INT_7 = 20;
        public static final int INT_8 = 21;
        public static final int INT_9 = 22;
        public static final int INT_10 = 23;
        public static final int INT_11 = 24;
        public static final int INT_12 = 25;
        public static final int INT_13 = 26;
        public static final int INT_14 = 27;
        public static final int INT_15 = 28;
        public static final int INT_16 = 29;
        public static final int INT_MIN_VALUE = 30;
        public static final int INT_MAX_VALUE = 31;
        public static final int INT_MF1 = 32;
        public static final int INT_F1 = 33;
        public static final int INT_MF2 = 34;
        public static final int INT_F2 = 35;
        public static final int INT_MF3 = 36;
        public static final int INT_F3 = 37;
        public static final int INT = 38;
        public static final int LONG_M9 = 39;
        public static final int LONG_M8 = 40;
        public static final int LONG_M7 = 41;
        public static final int LONG_M6 = 42;
        public static final int LONG_M5 = 43;
        public static final int LONG_M4 = 44;
        public static final int LONG_M3 = 45;
        public static final int LONG_M2 = 46;
        public static final int LONG_M1 = 47;
        public static final int LONG_0 = 48;
        public static final int LONG_1 = 49;
        public static final int LONG_2 = 50;
        public static final int LONG_3 = 51;
        public static final int LONG_4 = 52;
        public static final int LONG_5 = 53;
        public static final int LONG_6 = 54;
        public static final int LONG_7 = 55;
        public static final int LONG_8 = 56;
        public static final int LONG_9 = 57;
        public static final int LONG_10 = 58;
        public static final int LONG_11 = 59;
        public static final int LONG_12 = 60;
        public static final int LONG_13 = 61;
        public static final int LONG_14 = 62;
        public static final int LONG_15 = 63;
        public static final int LONG_16 = 64;
        public static final int LONG_MIN_VALUE = 65;
        public static final int LONG_MAX_VALUE = 66;
        public static final int LONG_MF1 = 67;
        public static final int LONG_F1 = 68;
        public static final int LONG_MF2 = 69;
        public static final int LONG_F2 = 70;
        public static final int LONG_MF3 = 71;
        public static final int LONG_F3 = 72;
        public static final int LONG_MF4 = 73;
        public static final int LONG_F4 = 74;
        public static final int LONG_MF5 = 75;
        public static final int LONG_F5 = 76;
        public static final int LONG_MF6 = 77;
        public static final int LONG_F6 = 78;
        public static final int LONG_MF7 = 79;
        public static final int LONG_F7 = 80;
        public static final int LONG = 81;
        public static final int BYTE_M1 = 82;
        public static final int BYTE_0 = 83;
        public static final int BYTE_1 = 84;
        public static final int BYTE = 85;
        public static final int CHAR_0 = 86;
        public static final int CHAR_1 = 87;
        public static final int CHAR_255 = 88;
        public static final int CHAR = 89;
        public static final int SHORT_M1 = 90;
        public static final int SHORT_0 = 91;
        public static final int SHORT_1 = 92;
        public static final int SHORT_255 = 93;
        public static final int SHORT_M255 = 94;
        public static final int SHORT = 95;
        public static final int FLOAT_M1 = 96;
        public static final int FLOAT_0 = 97;
        public static final int FLOAT_1 = 98;
        public static final int FLOAT_255 = 99;
        public static final int FLOAT_SHORT = 100;
        public static final int FLOAT = 101;
        public static final int DOUBLE_M1 = 102;
        public static final int DOUBLE_0 = 103;
        public static final int DOUBLE_1 = 104;
        public static final int DOUBLE_255 = 105;
        public static final int DOUBLE_SHORT = 106;
        public static final int DOUBLE_INT = 107;
        public static final int DOUBLE = 108;
        public static final int ARRAY_BYTE = 109;
        public static final int ARRAY_BYTE_ALL_EQUAL = 110;
        public static final int ARRAY_BOOLEAN = 111;
        public static final int ARRAY_SHORT = 112;
        public static final int ARRAY_CHAR = 113;
        public static final int ARRAY_FLOAT = 114;
        public static final int ARRAY_DOUBLE = 115;
        public static final int ARRAY_INT_BYTE = 116;
        public static final int ARRAY_INT_SHORT = 117;
        public static final int ARRAY_INT_PACKED = 118;
        public static final int ARRAY_INT = 119;
        public static final int ARRAY_LONG_BYTE = 120;
        public static final int ARRAY_LONG_SHORT = 121;
        public static final int ARRAY_LONG_PACKED = 122;
        public static final int ARRAY_LONG_INT = 123;
        public static final int ARRAY_LONG = 124;
        public static final int STRING_0 = 125;
        public static final int STRING_1 = 126;
        public static final int STRING_2 = 127;
        public static final int STRING_3 = 128;
        public static final int STRING_4 = 129;
        public static final int STRING_5 = 130;
        public static final int STRING_6 = 131;
        public static final int STRING_7 = 132;
        public static final int STRING_8 = 133;
        public static final int STRING_9 = 134;
        public static final int STRING_10 = 135;
        public static final int STRING = 136;
        public static final int BIGDECIMAL = 137;
        public static final int BIGINTEGER = 138;
        public static final int CLASS = 139;
        public static final int DATE = 140;
        public static final int FUN_HI = 141;
        public static final int UUID = 142;
        public static final int MAPDB = 150;
        public static final int TUPLE2 = 151;
        public static final int TUPLE3 = 152;
        public static final int TUPLE4 = 153;
        public static final int TUPLE5 = 154;
        public static final int TUPLE6 = 155;
        public static final int TUPLE7 = 156;
        public static final int TUPLE8 = 157;
        public static final int ARRAY_OBJECT = 158;
        public static final int ARRAY_OBJECT_PACKED_LONG = 159;
        public static final int ARRAYLIST_PACKED_LONG = 160;
        public static final int ARRAY_OBJECT_ALL_NULL = 161;
        public static final int ARRAY_OBJECT_NO_REFS = 162;
        public static final int ARRAYLIST = 163;
        public static final int TREEMAP = 164;
        public static final int HASHMAP = 165;
        public static final int LINKEDHASHMAP = 166;
        public static final int TREESET = 167;
        public static final int HASHSET = 168;
        public static final int LINKEDHASHSET = 169;
        public static final int LINKEDLIST = 170;
        public static final int PROPERTIES = 171;
        public static final int JAVA_SERIALIZATION = 172;
        public static final int POJO = 173;
        public static final int OBJECT_STACK = 174;
        public static final int NAMED = 175;
        public static final int MA_LONG = 176;
        public static final int MA_INT = 177;
        public static final int MA_BOOL = 178;
        public static final int MA_STRING = 179;
        public static final int MA_VAR = 180;
    }

    protected static interface HeaderMapDB {
        public static final int B_TREE_SERIALIZER_POS_LONG = 1;
        public static final int B_TREE_SERIALIZER_STRING = 2;
        public static final int B_TREE_SERIALIZER_POS_INT = 3;
        public static final int SERIALIZER_LONG = 4;
        public static final int SERIALIZER_INT = 5;
        public static final int SERIALIZER_ILLEGAL_ACCESS = 6;
        public static final int SERIALIZER_KEY_TUPLE2 = 7;
        public static final int SERIALIZER_KEY_TUPLE3 = 8;
        public static final int SERIALIZER_KEY_TUPLE4 = 9;
        public static final int FUN_COMPARATOR = 10;
        public static final int COMPARABLE_COMPARATOR = 11;
        public static final int THIS_SERIALIZER = 12;
        public static final int SERIALIZER_BASIC = 13;
        public static final int SERIALIZER_STRING_NOSIZE = 14;
        public static final int B_TREE_BASIC_KEY_SERIALIZER = 15;
        public static final int SERIALIZER_BOOLEAN = 16;
        public static final int SERIALIZER_BYTE_ARRAY_NOSIZE = 17;
        public static final int SERIALIZER_JAVA = 18;
        public static final int SERIALIZER_UUID = 19;
        public static final int SERIALIZER_STRING = 20;
        public static final int BYTE_ARRAY_SERIALIZER = 21;
        public static final int TUPLE2_COMPARATOR = 22;
        public static final int TUPLE3_COMPARATOR = 23;
        public static final int TUPLE4_COMPARATOR = 24;
        public static final int TUPLE2_COMPARATOR_STATIC = 25;
        public static final int TUPLE3_COMPARATOR_STATIC = 26;
        public static final int TUPLE4_COMPARATOR_STATIC = 27;
        public static final int FUN_COMPARATOR_REVERSE = 28;
        public static final int SERIALIZER_CHAR_ARRAY = 29;
        public static final int SERIALIZER_INT_ARRAY = 30;
        public static final int SERIALIZER_LONG_ARRAY = 31;
        public static final int SERIALIZER_DOUBLE_ARRAY = 32;
        public static final int HASHER_BASIC = 33;
        public static final int HASHER_BYTE_ARRAY = 34;
        public static final int HASHER_CHAR_ARRAY = 35;
        public static final int HASHER_INT_ARRAY = 36;
        public static final int HASHER_LONG_ARRAY = 37;
        public static final int HASHER_DOUBLE_ARRAY = 38;
        public static final int COMPARATOR_BYTE_ARRAY = 39;
        public static final int COMPARATOR_CHAR_ARRAY = 40;
        public static final int COMPARATOR_INT_ARRAY = 41;
        public static final int COMPARATOR_LONG_ARRAY = 42;
        public static final int COMPARATOR_DOUBLE_ARRAY = 43;
        public static final int COMPARATOR_COMPARABLE_ARRAY = 44;
        public static final int COMPARATOR_ARRAY = 45;
        public static final int SERIALIZER_STRING_ASCII = 46;
        public static final int SERIALIZER_COMPRESSION_WRAPPER = 47;
        public static final int B_TREE_COMPRESSION_SERIALIZER = 48;
        public static final int SERIALIZER_STRING_INTERN = 49;
        public static final int FUN_EMPTY_ITERATOR = 50;
        public static final int TUPLE5_COMPARATOR = 51;
        public static final int TUPLE6_COMPARATOR = 52;
        public static final int TUPLE5_COMPARATOR_STATIC = 53;
        public static final int TUPLE6_COMPARATOR_STATIC = 54;
        public static final int SERIALIZER_KEY_TUPLE5 = 55;
        public static final int SERIALIZER_KEY_TUPLE6 = 56;
        public static final int HASHER_ARRAY = 57;
    }

    protected static final class singletons {
        static final Map<Object, Integer> all = new IdentityHashMap<Object, Integer>();
        static final LongHashMap<Object> reverse = new LongHashMap();

        static {
            all.put(BTreeKeySerializer.STRING, 2);
            all.put(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG, 1);
            all.put(BTreeKeySerializer.ZERO_OR_POSITIVE_INT, 3);
            all.put(BTreeMap.COMPARABLE_COMPARATOR, 11);
            all.put(Fun.COMPARATOR, 10);
            all.put(Fun.REVERSE_COMPARATOR, 28);
            all.put(Fun.EMPTY_ITERATOR, 50);
            all.put(Fun.TUPLE2_COMPARATOR, 25);
            all.put(Fun.TUPLE3_COMPARATOR, 26);
            all.put(Fun.TUPLE4_COMPARATOR, 27);
            all.put(Fun.TUPLE5_COMPARATOR, 53);
            all.put(Fun.TUPLE6_COMPARATOR, 54);
            all.put(Serializer.STRING_NOSIZE, 14);
            all.put(Serializer.STRING_ASCII, 46);
            all.put(Serializer.STRING_INTERN, 49);
            all.put(Serializer.LONG, 4);
            all.put(Serializer.INTEGER, 5);
            all.put(Serializer.ILLEGAL_ACCESS, 6);
            all.put(Serializer.BASIC, 13);
            all.put(Serializer.BOOLEAN, 16);
            all.put(Serializer.BYTE_ARRAY_NOSIZE, 17);
            all.put(Serializer.BYTE_ARRAY, 21);
            all.put(Serializer.JAVA, 18);
            all.put(Serializer.UUID, 19);
            all.put(Serializer.STRING, 20);
            all.put(Serializer.CHAR_ARRAY, 29);
            all.put(Serializer.INT_ARRAY, 30);
            all.put(Serializer.LONG_ARRAY, 31);
            all.put(Serializer.DOUBLE_ARRAY, 32);
            all.put(Hasher.BASIC, 33);
            all.put(Hasher.BYTE_ARRAY, 34);
            all.put(Hasher.CHAR_ARRAY, 35);
            all.put(Hasher.INT_ARRAY, 36);
            all.put(Hasher.LONG_ARRAY, 37);
            all.put(Hasher.DOUBLE_ARRAY, 38);
            all.put(Hasher.ARRAY, 57);
            all.put(Fun.BYTE_ARRAY_COMPARATOR, 39);
            all.put(Fun.CHAR_ARRAY_COMPARATOR, 40);
            all.put(Fun.INT_ARRAY_COMPARATOR, 41);
            all.put(Fun.LONG_ARRAY_COMPARATOR, 42);
            all.put(Fun.DOUBLE_ARRAY_COMPARATOR, 43);
            all.put(Fun.COMPARABLE_ARRAY_COMPARATOR, 44);
            all.put(Fun.HI, Integer.MIN_VALUE);
            for (Map.Entry<Object, Integer> e : all.entrySet()) {
                reverse.put(e.getValue().intValue(), e.getKey());
            }
        }

        protected singletons() {
        }
    }
}

