/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Hasher;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.Store;
import org.mapdb.TxEngine;

public class HTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Bind.MapWithModificationListener<K, V> {
    protected static final int BUCKET_OVERFLOW = 4;
    protected static final int DIV8 = 3;
    protected static final int MOD8 = 7;
    protected final boolean hasValues;
    protected final int hashSalt;
    protected final Atomic.Long counter;
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Hasher<K> hasher;
    protected final Engine engine;
    protected final boolean expireFlag;
    protected final long expireTimeStart;
    protected final long expire;
    protected final boolean expireAccessFlag;
    protected final long expireAccess;
    protected final long expireMaxSize;
    protected final long expireStoreSize;
    protected final boolean expireMaxSizeFlag;
    protected final long[] expireHeads;
    protected final long[] expireTails;
    protected final Fun.Function1<V, K> valueCreator;
    protected final CountDownLatch closeLatch = new CountDownLatch(2);
    protected final Runnable closeListener = new Runnable(){

        @Override
        public void run() {
            if (HTreeMap.this.closeLatch.getCount() > 1L) {
                HTreeMap.this.closeLatch.countDown();
            }
            try {
                HTreeMap.this.closeLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            HTreeMap.this.engine.closeListenerUnregister(HTreeMap.this.closeListener);
        }
    };
    protected final Serializer<LinkedNode<K, V>> LN_SERIALIZER = new Serializer<LinkedNode<K, V>>(){

        @Override
        public void serialize(DataOutput out, LinkedNode<K, V> value) throws IOException {
            DataOutput2.packLong(out, value.next);
            if (HTreeMap.this.expireFlag) {
                DataOutput2.packLong(out, value.expireLinkNodeRecid);
            }
            HTreeMap.this.keySerializer.serialize(out, value.key);
            if (HTreeMap.this.hasValues) {
                HTreeMap.this.valueSerializer.serialize(out, value.value);
            }
        }

        @Override
        public LinkedNode<K, V> deserialize(DataInput in, int available) throws IOException {
            if (!$assertionsDisabled && available == 0) {
                throw new AssertionError();
            }
            return new LinkedNode(DataInput2.unpackLong(in), HTreeMap.this.expireFlag ? DataInput2.unpackLong(in) : 0L, HTreeMap.this.keySerializer.deserialize(in, -1), HTreeMap.this.hasValues ? HTreeMap.this.valueSerializer.deserialize(in, -1) : BTreeMap.EMPTY);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    protected static final Serializer<long[][]> DIR_SERIALIZER = new Serializer<long[][]>(){

        @Override
        public void serialize(DataOutput out, long[][] value) throws IOException {
            long l;
            int n;
            int n2;
            long[] lArray;
            if (!$assertionsDisabled && value.length != 16) {
                throw new AssertionError();
            }
            int nulls = 0;
            int i = 0;
            while (i < 16) {
                if (value[i] != null) {
                    lArray = value[i];
                    n2 = lArray.length;
                    n = 0;
                    while (n < n2) {
                        l = lArray[n];
                        if (l != 0L) {
                            nulls |= 1 << i;
                            break;
                        }
                        ++n;
                    }
                }
                ++i;
            }
            out.writeShort(nulls);
            i = 0;
            while (i < 16) {
                if (value[i] != null) {
                    if (!$assertionsDisabled && value[i].length != 8) {
                        throw new AssertionError();
                    }
                    lArray = value[i];
                    n2 = lArray.length;
                    n = 0;
                    while (n < n2) {
                        l = lArray[n];
                        DataOutput2.packLong(out, l);
                        ++n;
                    }
                }
                ++i;
            }
        }

        @Override
        public long[][] deserialize(DataInput in, int available) throws IOException {
            long[][] ret = new long[16][];
            int nulls = in.readUnsignedShort();
            int i = 0;
            while (i < 16) {
                if ((nulls & 1) != 0) {
                    long[] subarray = new long[8];
                    int j = 0;
                    while (j < 8) {
                        subarray[j] = DataInput2.unpackLong(in);
                        ++j;
                    }
                    ret[i] = subarray;
                }
                nulls >>>= 1;
                ++i;
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    protected final long[] segmentRecids;
    protected final ReentrantReadWriteLock[] segmentLocks = new ReentrantReadWriteLock[16];
    private final Set<K> _keySet;
    private final Collection<V> _values;
    private final Set<Map.Entry<K, V>> _entrySet;
    protected final Object modListenersLock;
    protected Bind.MapListener<K, V>[] modListeners;

    public HTreeMap(Engine engine, long counterRecid, int hashSalt, long[] segmentRecids, Serializer<K> keySerializer, Serializer<V> valueSerializer, long expireTimeStart, long expire, long expireAccess, long expireMaxSize, long expireStoreSize, long[] expireHeads, long[] expireTails, Fun.Function1<V, K> valueCreator, Hasher hasher, boolean disableLocks) {
        int i = 0;
        while (i < 16) {
            this.segmentLocks[i] = new ReentrantReadWriteLock(false);
            ++i;
        }
        this._keySet = new KeySet();
        this._values = new AbstractCollection<V>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return HTreeMap.this.containsValue(o);
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }
        };
        this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object val = HTreeMap.this.get(e.getKey());
                    return val != null && val.equals(e.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                Object key = kvEntry.getKey();
                Object value = kvEntry.getValue();
                if (key == null || value == null) {
                    throw new NullPointerException();
                }
                HTreeMap.this.put(key, value);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object key = e.getKey();
                    if (key == null) {
                        return false;
                    }
                    return HTreeMap.this.remove(key, e.getValue());
                }
                return false;
            }

            @Override
            public void clear() {
                HTreeMap.this.clear();
            }
        };
        this.modListenersLock = new Object();
        this.modListeners = new Bind.MapListener[0];
        if (counterRecid < 0L) {
            throw new IllegalArgumentException();
        }
        if (engine == null) {
            throw new NullPointerException();
        }
        if (segmentRecids == null) {
            throw new NullPointerException();
        }
        if (keySerializer == null) {
            throw new NullPointerException();
        }
        SerializerBase.assertSerializable(keySerializer);
        boolean bl = this.hasValues = valueSerializer != null;
        if (this.hasValues) {
            SerializerBase.assertSerializable(valueSerializer);
        }
        if (segmentRecids.length != 16) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.hashSalt = hashSalt;
        this.segmentRecids = Arrays.copyOf(segmentRecids, 16);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        Hasher hasher2 = this.hasher = hasher != null ? hasher : Hasher.BASIC;
        if (expire == 0L && expireAccess != 0L) {
            expire = expireAccess;
        }
        if (expireMaxSize != 0L && counterRecid == 0L) {
            throw new IllegalArgumentException("expireMaxSize must have counter enabled");
        }
        this.expireFlag = expire != 0L || expireAccess != 0L || expireMaxSize != 0L || expireStoreSize != 0L;
        this.expire = expire;
        this.expireTimeStart = expireTimeStart;
        this.expireAccessFlag = expireAccess != 0L || expireMaxSize != 0L || expireStoreSize != 0L;
        this.expireAccess = expireAccess;
        this.expireHeads = expireHeads == null ? null : Arrays.copyOf(expireHeads, 16);
        this.expireTails = expireTails == null ? null : Arrays.copyOf(expireTails, 16);
        this.expireMaxSizeFlag = expireMaxSize != 0L;
        this.expireMaxSize = expireMaxSize;
        this.expireStoreSize = expireStoreSize;
        this.valueCreator = valueCreator;
        if (counterRecid != 0L) {
            this.counter = new Atomic.Long(engine, counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
        if (this.expireFlag) {
            Thread t = new Thread((Runnable)new ExpireRunnable(this), "HTreeMap expirator");
            t.setDaemon(true);
            t.start();
            engine.closeListenerRegister(this.closeListener);
        }
    }

    protected static long[] preallocateSegments(Engine engine) {
        long[] ret = new long[16];
        int i = 0;
        while (i < 16) {
            ret[i] = engine.put(new long[16][], DIR_SERIALIZER);
            ++i;
        }
        return ret;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getPeek(o) != null;
    }

    @Override
    public int size() {
        long size = this.sizeLong();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public long sizeLong() {
        if (this.counter != null) {
            return this.counter.get();
        }
        long counter = 0L;
        int i = 0;
        while (i < 16) {
            try {
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                counter += this.recursiveDirCount(dirRecid);
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
            ++i;
        }
        return counter;
    }

    private long recursiveDirCount(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        long counter = 0L;
        long[][] lArray = dir;
        int n = dir.length;
        int n2 = 0;
        while (n2 < n) {
            long[] subdir = lArray[n2];
            if (subdir != null) {
                long[] lArray2 = subdir;
                int n3 = subdir.length;
                int n4 = 0;
                while (n4 < n3) {
                    long recid = lArray2[n4];
                    if (recid != 0L) {
                        if ((recid & 1L) == 0L) {
                            counter += this.recursiveDirCount(recid >>>= 1);
                        } else {
                            recid >>>= 1;
                            while (recid != 0L) {
                                LinkedNode<K, V> n5 = this.engine.get(recid, this.LN_SERIALIZER);
                                if (n5 != null) {
                                    ++counter;
                                    recid = n5.next;
                                    continue;
                                }
                                recid = 0L;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return counter;
    }

    @Override
    public boolean isEmpty() {
        int i = 0;
        while (i < 16) {
            try {
                long[][] dir;
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                long[][] lArray = dir = this.engine.get(dirRecid, DIR_SERIALIZER);
                int n = dir.length;
                int n2 = 0;
                while (n2 < n) {
                    long[] d = lArray[n2];
                    if (d != null) {
                        return false;
                    }
                    ++n2;
                }
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
            ++i;
        }
        return true;
    }

    @Override
    public V get(Object o) {
        LinkedNode<K, V> ln;
        if (o == null) {
            return null;
        }
        int h = this.hash(o);
        int segment = h >>> 28;
        Lock lock = this.expireAccessFlag ? this.segmentLocks[segment].writeLock() : this.segmentLocks[segment].readLock();
        lock.lock();
        try {
            ln = this.getInner(o, h, segment);
            if (ln != null && this.expireAccessFlag) {
                this.expireLinkBump(segment, ln.expireLinkNodeRecid, true);
            }
        }
        finally {
            lock.unlock();
        }
        if (this.valueCreator == null || ln != null) {
            if (ln == null) {
                return null;
            }
            return ln.value;
        }
        V value = this.valueCreator.run(o);
        V prevVal = this.putIfAbsent(o, value);
        if (prevVal != null) {
            return prevVal;
        }
        return value;
    }

    public V getPeek(Object key) {
        if (key == null) {
            return null;
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        ReentrantReadWriteLock.ReadLock lock = this.segmentLocks[segment].readLock();
        lock.lock();
        try {
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln == null) {
                return null;
            }
            Object v = ln.value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    protected LinkedNode<K, V> getInner(Object o, int h, int segment) {
        long recid = this.segmentRecids[segment];
        int level = 3;
        while (level >= 0) {
            long[][] dir = this.engine.get(recid, DIR_SERIALIZER);
            if (dir == null) {
                return null;
            }
            int slot = h >>> level * 7 & 0x7F;
            assert (slot < 128);
            if (dir[slot >>> 3] == null) {
                return null;
            }
            recid = dir[slot >>> 3][slot & 7];
            if (recid == 0L) {
                return null;
            }
            if ((recid & 1L) != 0L) {
                recid >>>= 1;
                while (true) {
                    LinkedNode<K, V> ln;
                    if ((ln = this.engine.get(recid, this.LN_SERIALIZER)) == null) {
                        return null;
                    }
                    if (this.hasher.equals(ln.key, o)) {
                        assert (this.hash(ln.key) == h);
                        return ln;
                    }
                    if (ln.next == 0L) {
                        return null;
                    }
                    recid = ln.next;
                }
            }
            recid >>>= 1;
            --level;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        this.segmentLocks[segment].writeLock().lock();
        try {
            V v = this.putInner(key, value, h, segment);
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    private V putInner(K key, V value, int h, int segment) {
        long recid;
        int counter;
        int slot;
        Object dir;
        int level;
        long dirRecid;
        block12: {
            dirRecid = this.segmentRecids[segment];
            level = 3;
            while (true) {
                dir = this.engine.get(dirRecid, DIR_SERIALIZER);
                slot = h >>> 7 * level & 0x7F;
                assert (slot <= 127);
                if (dir == null) {
                    dir = new long[16][];
                }
                if (dir[slot >>> 3] == null) {
                    dir = (long[][])Arrays.copyOf(dir, 16);
                    dir[slot >>> 3] = new long[8];
                }
                counter = 0;
                recid = dir[slot >>> 3][slot & 7];
                if (recid == 0L) break block12;
                if ((recid & 1L) != 0L) break;
                dirRecid = recid >>> 1;
                --level;
            }
            LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
            while (ln != null) {
                if (this.hasher.equals(ln.key, key)) {
                    Object oldVal = ln.value;
                    ln = new LinkedNode(ln.next, ln.expireLinkNodeRecid, ln.key, value);
                    this.engine.update(recid, ln, this.LN_SERIALIZER);
                    if (this.expireFlag) {
                        this.expireLinkBump(segment, ln.expireLinkNodeRecid, false);
                    }
                    this.notify(key, oldVal, value);
                    return oldVal;
                }
                recid = ln.next;
                ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
                ++counter;
            }
        }
        if (counter >= 4 && level >= 1) {
            long[][] nextDir = new long[16][];
            long expireNodeRecid = this.expireFlag ? this.engine.preallocate() : 0L;
            LinkedNode<K, V> node = new LinkedNode<K, V>(0L, expireNodeRecid, key, value);
            long newRecid = this.engine.put(node, this.LN_SERIALIZER);
            int pos = h >>> 7 * (level - 1) & 0x7F;
            nextDir[pos >>> 3] = new long[8];
            nextDir[pos >>> 3][pos & 7] = newRecid << 1 | 1L;
            if (this.expireFlag) {
                this.expireLinkAdd(segment, expireNodeRecid, newRecid, h);
            }
            long nodeRecid = dir[slot >>> 3][slot & 7] >>> 1;
            while (nodeRecid != 0L) {
                LinkedNode<K, V> n = this.engine.get(nodeRecid, this.LN_SERIALIZER);
                long nextRecid = n.next;
                pos = this.hash(n.key) >>> 7 * (level - 1) & 0x7F;
                if (nextDir[pos >>> 3] == null) {
                    nextDir[pos >>> 3] = new long[8];
                }
                n = new LinkedNode(nextDir[pos >>> 3][pos & 7] >>> 1, n.expireLinkNodeRecid, n.key, n.value);
                nextDir[pos >>> 3][pos & 7] = nodeRecid << 1 | 1L;
                this.engine.update(nodeRecid, n, this.LN_SERIALIZER);
                nodeRecid = nextRecid;
            }
            long nextDirRecid = this.engine.put(nextDir, DIR_SERIALIZER);
            int parentPos = h >>> 7 * level & 0x7F;
            dir = (long[][])Arrays.copyOf(dir, 16);
            dir[parentPos >>> 3] = Arrays.copyOf(dir[parentPos >>> 3], 8);
            dir[parentPos >>> 3][parentPos & 7] = nextDirRecid << 1 | 0L;
            this.engine.update(dirRecid, dir, DIR_SERIALIZER);
            this.notify(key, null, value);
            return null;
        }
        recid = dir[slot >>> 3][slot & 7] >>> 1;
        long expireNodeRecid = this.expireFlag ? this.engine.put(ExpireLinkNode.EMPTY, ExpireLinkNode.SERIALIZER) : 0L;
        long newRecid = this.engine.put(new LinkedNode<K, V>(recid, expireNodeRecid, key, value), this.LN_SERIALIZER);
        dir = (long[][])Arrays.copyOf(dir, 16);
        dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
        dir[slot >>> 3][slot & 7] = newRecid << 1 | 1L;
        this.engine.update(dirRecid, dir, DIR_SERIALIZER);
        if (this.expireFlag) {
            this.expireLinkAdd(segment, expireNodeRecid, newRecid, h);
        }
        this.notify(key, null, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        int h = this.hash(key);
        int segment = h >>> 28;
        this.segmentLocks[segment].writeLock().lock();
        try {
            V v = this.removeInternal(key, segment, h, true);
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    protected V removeInternal(Object key, int segment, int h, boolean removeExpire) {
        block13: {
            long recid;
            int slot;
            Object dir;
            long[] dirRecids = new long[4];
            int level = 3;
            dirRecids[level] = this.segmentRecids[segment];
            assert (segment == h >>> 28);
            while (true) {
                dir = this.engine.get(dirRecids[level], DIR_SERIALIZER);
                slot = h >>> 7 * level & 0x7F;
                assert (slot <= 127);
                if (dir == null) {
                    dir = new long[16][];
                }
                if (dir[slot >>> 3] == null) {
                    dir = (long[][])Arrays.copyOf(dir, 16);
                    dir[slot >>> 3] = new long[8];
                }
                if ((recid = dir[slot >>> 3][slot & 7]) == 0L) break block13;
                if ((recid & 1L) != 0L) break;
                dirRecids[--level] = recid >>> 1;
            }
            LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
            LinkedNode<K, V> prevLn = null;
            long prevRecid = 0L;
            while (ln != null) {
                if (this.hasher.equals(ln.key, key)) {
                    if (prevLn == null) {
                        if (ln.next == 0L) {
                            this.recursiveDirDelete(h, level, dirRecids, (long[][])dir, slot);
                        } else {
                            dir = (long[][])Arrays.copyOf(dir, 16);
                            dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
                            dir[slot >>> 3][slot & 7] = ln.next << 1 | 1L;
                            this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
                        }
                    } else {
                        prevLn = new LinkedNode(ln.next, prevLn.expireLinkNodeRecid, prevLn.key, prevLn.value);
                        this.engine.update(prevRecid, prevLn, this.LN_SERIALIZER);
                    }
                    assert (this.hash(ln.key) == h);
                    this.engine.delete(recid, this.LN_SERIALIZER);
                    if (removeExpire && this.expireFlag) {
                        this.expireLinkRemove(segment, ln.expireLinkNodeRecid);
                    }
                    this.notify(key, ln.value, null);
                    return ln.value;
                }
                prevRecid = recid;
                prevLn = ln;
                recid = ln.next;
                LinkedNode<K, V> linkedNode = ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
            }
            return null;
        }
        return null;
    }

    private void recursiveDirDelete(int h, int level, long[] dirRecids, long[][] dir, int slot) {
        dir = (long[][])Arrays.copyOf(dir, 16);
        dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
        dir[slot >>> 3][slot & 7] = 0L;
        boolean allZero = true;
        long[] lArray = dir[slot >>> 3];
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            if (l != 0L) {
                allZero = false;
                break;
            }
            ++n2;
        }
        if (allZero) {
            dir[slot >>> 3] = null;
        }
        allZero = true;
        long[][] lArray2 = dir;
        n2 = dir.length;
        int n3 = 0;
        while (n3 < n2) {
            long[] l = lArray2[n3];
            if (l != null) {
                allZero = false;
                break;
            }
            ++n3;
        }
        if (allZero) {
            if (level == 3) {
                this.engine.update(dirRecids[level], new long[16][], DIR_SERIALIZER);
            } else {
                this.engine.delete(dirRecids[level], DIR_SERIALIZER);
                long[][] parentDir = this.engine.get(dirRecids[level + 1], DIR_SERIALIZER);
                int parentPos = h >>> 7 * (level + 1) & 0x7F;
                this.recursiveDirDelete(h, level + 1, dirRecids, parentDir, parentPos);
            }
        } else {
            this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
        }
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < 16) {
            try {
                this.segmentLocks[i].writeLock().lock();
                long dirRecid = this.segmentRecids[i];
                this.recursiveDirClear(dirRecid);
                this.engine.update(dirRecid, new long[16][], DIR_SERIALIZER);
                if (this.expireFlag) {
                    while (this.expireLinkRemoveLast(i) != null) {
                    }
                }
            }
            finally {
                this.segmentLocks[i].writeLock().unlock();
            }
            ++i;
        }
    }

    private void recursiveDirClear(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        if (dir == null) {
            return;
        }
        long[][] lArray = dir;
        int n = dir.length;
        int n2 = 0;
        while (n2 < n) {
            long[] subdir = lArray[n2];
            if (subdir != null) {
                long[] lArray2 = subdir;
                int n3 = subdir.length;
                int n4 = 0;
                while (n4 < n3) {
                    long recid = lArray2[n4];
                    if (recid != 0L) {
                        if ((recid & 1L) == 0L) {
                            this.recursiveDirClear(recid >>>= 1);
                            this.engine.delete(recid, DIR_SERIALIZER);
                        } else {
                            recid >>>= 1;
                            while (recid != 0L) {
                                LinkedNode<K, V> n5 = this.engine.get(recid, this.LN_SERIALIZER);
                                this.engine.delete(recid, this.LN_SERIALIZER);
                                this.notify(n5.key, n5.value, null);
                                recid = n5.next;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this._keySet;
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    protected int hash(Object key) {
        int h = this.hasher.hashCode(key) ^ this.hashSalt;
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln == null) {
                V v = this.put(key, value);
                return v;
            }
            Object v = ln.value;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> otherVal = this.getInner(key, h, segment);
            if (otherVal != null && otherVal.value.equals(value)) {
                this.removeInternal(key, segment, h, true);
                return true;
            }
            return false;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln != null && ln.value.equals(oldValue)) {
                this.putInner(key, newValue, h, segment);
                return true;
            }
            return false;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (this.getInner(key, h, segment) != null) {
                V v = this.putInner(key, value, h, segment);
                return v;
            }
            return null;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    protected void expireLinkAdd(int segment, long expireNodeRecid, long keyRecid, int hash) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        assert (expireNodeRecid > 0L);
        assert (keyRecid > 0L);
        long time = this.expire == 0L ? 0L : this.expire + System.currentTimeMillis() - this.expireTimeStart;
        long head = this.engine.get(this.expireHeads[segment], Serializer.LONG);
        if (head == 0L) {
            ExpireLinkNode n = new ExpireLinkNode(0L, 0L, keyRecid, time, hash);
            this.engine.update(expireNodeRecid, n, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], expireNodeRecid, Serializer.LONG);
            this.engine.update(this.expireTails[segment], expireNodeRecid, Serializer.LONG);
        } else {
            ExpireLinkNode n = new ExpireLinkNode(head, 0L, keyRecid, time, hash);
            this.engine.update(expireNodeRecid, n, ExpireLinkNode.SERIALIZER);
            ExpireLinkNode oldHead = this.engine.get(head, ExpireLinkNode.SERIALIZER);
            oldHead = oldHead.copyNext(expireNodeRecid);
            this.engine.update(head, oldHead, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], expireNodeRecid, Serializer.LONG);
        }
    }

    protected void expireLinkBump(int segment, long nodeRecid, boolean access) {
        long newTime;
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        ExpireLinkNode n = this.engine.get(nodeRecid, ExpireLinkNode.SERIALIZER);
        long l = access ? (this.expireAccess == 0L ? n.time : this.expireAccess + System.currentTimeMillis() - this.expireTimeStart) : (newTime = this.expire == 0L ? n.time : this.expire + System.currentTimeMillis() - this.expireTimeStart);
        if (n.next == 0L) {
            n = n.copyTime(newTime);
            this.engine.update(nodeRecid, n, ExpireLinkNode.SERIALIZER);
        } else {
            if (n.prev != 0L) {
                ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
                prev = prev.copyNext(n.next);
                this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
            } else {
                this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
            }
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(n.prev);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            long oldHeadRecid = this.engine.get(this.expireHeads[segment], Serializer.LONG);
            ExpireLinkNode oldHead = this.engine.get(oldHeadRecid, ExpireLinkNode.SERIALIZER);
            oldHead = oldHead.copyNext(nodeRecid);
            this.engine.update(oldHeadRecid, oldHead, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], nodeRecid, Serializer.LONG);
            n = new ExpireLinkNode(oldHeadRecid, 0L, n.keyRecid, newTime, n.hash);
            this.engine.update(nodeRecid, n, ExpireLinkNode.SERIALIZER);
        }
    }

    protected ExpireLinkNode expireLinkRemoveLast(int segment) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        long tail = this.engine.get(this.expireTails[segment], Serializer.LONG);
        if (tail == 0L) {
            return null;
        }
        ExpireLinkNode n = this.engine.get(tail, ExpireLinkNode.SERIALIZER);
        if (n.next == 0L) {
            this.engine.update(this.expireHeads[segment], 0L, Serializer.LONG);
            this.engine.update(this.expireTails[segment], 0L, Serializer.LONG);
        } else {
            this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(0L);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
        }
        this.engine.delete(tail, ExpireLinkNode.SERIALIZER);
        return n;
    }

    protected ExpireLinkNode expireLinkRemove(int segment, long nodeRecid) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        ExpireLinkNode n = this.engine.get(nodeRecid, ExpireLinkNode.SERIALIZER);
        this.engine.delete(nodeRecid, ExpireLinkNode.SERIALIZER);
        if (n.next == 0L && n.prev == 0L) {
            this.engine.update(this.expireHeads[segment], 0L, Serializer.LONG);
            this.engine.update(this.expireTails[segment], 0L, Serializer.LONG);
        } else if (n.next == 0L) {
            ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
            prev = prev.copyNext(0L);
            this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], n.prev, Serializer.LONG);
        } else if (n.prev == 0L) {
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(0L);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
        } else {
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(n.prev);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
            prev = prev.copyNext(n.next);
            this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
        }
        return n;
    }

    public long getMaxExpireTime() {
        if (!this.expireFlag) {
            return 0L;
        }
        long ret = 0L;
        int segment = 0;
        while (segment < 16) {
            this.segmentLocks[segment].readLock().lock();
            try {
                ExpireLinkNode ln;
                long head = this.engine.get(this.expireHeads[segment], Serializer.LONG);
                if (head != 0L && (ln = this.engine.get(head, ExpireLinkNode.SERIALIZER)) != null && ln.time != 0L) {
                    ret = Math.max(ret, ln.time + this.expireTimeStart);
                }
            }
            finally {
                this.segmentLocks[segment].readLock().unlock();
            }
            ++segment;
        }
        return ret;
    }

    public long getMinExpireTime() {
        if (!this.expireFlag) {
            return 0L;
        }
        long ret = Long.MAX_VALUE;
        int segment = 0;
        while (segment < 16) {
            this.segmentLocks[segment].readLock().lock();
            try {
                ExpireLinkNode ln;
                long tail = this.engine.get(this.expireTails[segment], Serializer.LONG);
                if (tail != 0L && (ln = this.engine.get(tail, ExpireLinkNode.SERIALIZER)) != null && ln.time != 0L) {
                    ret = Math.min(ret, ln.time + this.expireTimeStart);
                }
            }
            finally {
                this.segmentLocks[segment].readLock().unlock();
            }
            ++segment;
        }
        if (ret == Long.MAX_VALUE) {
            ret = 0L;
        }
        return ret;
    }

    protected void expirePurge() {
        Store store;
        long size;
        if (!this.expireFlag) {
            return;
        }
        long removePerSegment = 0L;
        if (this.expireMaxSizeFlag && (size = this.counter.get()) > this.expireMaxSize) {
            removePerSegment = 1L + (size - this.expireMaxSize) / 16L;
        }
        if (this.expireStoreSize != 0L && removePerSegment == 0L && this.expireStoreSize < (store = Store.forEngine(this.engine)).getCurrSize() - store.getFreeSize()) {
            removePerSegment = 640L;
        }
        int seg = 0;
        while (seg < 16) {
            if (this.closeLatch.getCount() < 2L) {
                return;
            }
            this.expirePurgeSegment(seg, removePerSegment);
            ++seg;
        }
    }

    protected void expirePurgeSegment(int seg, long removePerSegment) {
        this.segmentLocks[seg].writeLock().lock();
        try {
            long recid = this.engine.get(this.expireTails[seg], Serializer.LONG);
            long counter = 0L;
            ExpireLinkNode last = null;
            ExpireLinkNode n = null;
            while (recid != 0L) {
                boolean remove;
                n = this.engine.get(recid, ExpireLinkNode.SERIALIZER);
                assert (n != ExpireLinkNode.EMPTY);
                assert (n.hash >>> 28 == seg);
                boolean bl = remove = ++counter < removePerSegment || (this.expire != 0L || this.expireAccess != 0L) && n.time + this.expireTimeStart < System.currentTimeMillis();
                if (!remove) break;
                this.engine.delete(recid, ExpireLinkNode.SERIALIZER);
                LinkedNode<K, V> ln = this.engine.get(n.keyRecid, this.LN_SERIALIZER);
                this.removeInternal(ln.key, seg, n.hash, false);
                last = n;
                recid = n.next;
            }
            if (last != null) {
                if (recid == 0L) {
                    this.engine.update(this.expireTails[seg], 0L, Serializer.LONG);
                    this.engine.update(this.expireHeads[seg], 0L, Serializer.LONG);
                } else {
                    this.engine.update(this.expireTails[seg], recid, Serializer.LONG);
                    n = this.engine.get(recid, ExpireLinkNode.SERIALIZER);
                    n = n.copyPrev(0L);
                    this.engine.update(recid, n, ExpireLinkNode.SERIALIZER);
                }
            }
        }
        finally {
            this.segmentLocks[seg].writeLock().unlock();
        }
    }

    protected void expireCheckSegment(int segment) {
        long current = this.engine.get(this.expireTails[segment], Serializer.LONG);
        if (current == 0L) {
            if (this.engine.get(this.expireHeads[segment], Serializer.LONG) != 0L) {
                throw new AssertionError((Object)"head not 0");
            }
            return;
        }
        long prev = 0L;
        while (current != 0L) {
            ExpireLinkNode curr = this.engine.get(current, ExpireLinkNode.SERIALIZER);
            assert (curr.prev == prev) : "wrong prev " + curr.prev + " - " + prev;
            prev = current;
            current = curr.next;
        }
        if (this.engine.get(this.expireHeads[segment], Serializer.LONG) != prev) {
            throw new AssertionError((Object)"wrong head");
        }
    }

    public Map<K, V> snapshot() {
        Engine snapshot = TxEngine.createSnapshotFor(this.engine);
        return new HTreeMap<K, V>(snapshot, this.counter == null ? 0L : this.counter.recid, this.hashSalt, this.segmentRecids, this.keySerializer, this.valueSerializer, 0L, 0L, 0L, 0L, 0L, null, null, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerAdd(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modificationListenerRemove(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            int i = 0;
            while (i < this.modListeners.length) {
                if (this.modListeners[i] == listener) {
                    this.modListeners[i] = null;
                }
                ++i;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        assert (this.segmentLocks[this.hash(key) >>> 28].isWriteLockedByCurrentThread());
        Bind.MapListener<K, V>[] mapListenerArray = modListeners2 = this.modListeners;
        int n = modListeners2.length;
        int n2 = 0;
        while (n2 < n) {
            Bind.MapListener<K, V> listener = mapListenerArray[n2];
            if (listener != null) {
                listener.update(key, oldValue, newValue);
            }
            ++n2;
        }
    }

    public void close() {
        this.engine.close();
    }

    public Engine getEngine() {
        return this.engine;
    }

    class Entry2
    implements Map.Entry<K, V> {
        private final K key;

        Entry2(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return HTreeMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return HTreeMap.this.put(this.key, value);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && HTreeMap.this.hasher.equals(this.key, ((Map.Entry)o).getKey());
        }

        @Override
        public int hashCode() {
            Object value = HTreeMap.this.get(this.key);
            return (this.key == null ? 0 : HTreeMap.this.hasher.hashCode(this.key)) ^ (value == null ? 0 : value.hashCode());
        }
    }

    class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos].key;
            this.moveToNext();
            return new Entry2(key);
        }
    }

    protected static final class ExpireLinkNode {
        public static final ExpireLinkNode EMPTY = new ExpireLinkNode(0L, 0L, 0L, 0L, 0);
        public static final Serializer<ExpireLinkNode> SERIALIZER = new Serializer<ExpireLinkNode>(){

            @Override
            public void serialize(DataOutput out, ExpireLinkNode value) throws IOException {
                if (value == EMPTY) {
                    return;
                }
                DataOutput2.packLong(out, value.prev);
                DataOutput2.packLong(out, value.next);
                DataOutput2.packLong(out, value.keyRecid);
                DataOutput2.packLong(out, value.time);
                out.writeInt(value.hash);
            }

            @Override
            public ExpireLinkNode deserialize(DataInput in, int available) throws IOException {
                if (available == 0) {
                    return EMPTY;
                }
                return new ExpireLinkNode(DataInput2.unpackLong(in), DataInput2.unpackLong(in), DataInput2.unpackLong(in), DataInput2.unpackLong(in), in.readInt());
            }

            @Override
            public int fixedSize() {
                return -1;
            }
        };
        public final long prev;
        public final long next;
        public final long keyRecid;
        public final long time;
        public final int hash;

        public ExpireLinkNode(long prev, long next, long keyRecid, long time, int hash) {
            this.prev = prev;
            this.next = next;
            this.keyRecid = keyRecid;
            this.time = time;
            this.hash = hash;
        }

        public ExpireLinkNode copyNext(long next2) {
            return new ExpireLinkNode(this.prev, next2, this.keyRecid, this.time, this.hash);
        }

        public ExpireLinkNode copyPrev(long prev2) {
            return new ExpireLinkNode(prev2, this.next, this.keyRecid, this.time, this.hash);
        }

        public ExpireLinkNode copyTime(long time2) {
            return new ExpireLinkNode(this.prev, this.next, this.keyRecid, time2, this.hash);
        }
    }

    protected static class ExpireRunnable
    implements Runnable {
        final WeakReference<HTreeMap> mapRef;

        public ExpireRunnable(HTreeMap map) {
            this.mapRef = new WeakReference<HTreeMap>(map);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            pause = false;
            while (true) {
                try {
                    if (pause) {
                        Thread.sleep(1000L);
                    }
                    if ((map = (HTreeMap)this.mapRef.get()) == null || map.engine.isClosed() || map.closeLatch.getCount() < 2L) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    m = (HTreeMap)this.mapRef.get();
                    if (m != null) {
                        m.closeLatch.countDown();
                    }
                    this.mapRef.clear();
                    return;
                }
                catch (Throwable var3_8) {
                    m = (HTreeMap)this.mapRef.get();
                    if (m != null) {
                        m.closeLatch.countDown();
                    }
                    this.mapRef.clear();
                    throw var3_8;
                }
                m = (HTreeMap)this.mapRef.get();
                if (m != null) {
                    m.closeLatch.countDown();
                }
                this.mapRef.clear();
                return;
lbl-1000:
                // 1 sources

                {
                    map.expirePurge();
                    if (!map.engine.isClosed() && map.closeLatch.getCount() >= 2L) ** GOTO lbl-1000
                }
                m = (HTreeMap)this.mapRef.get();
                if (m != null) {
                    m.closeLatch.countDown();
                }
                this.mapRef.clear();
                return;
lbl-1000:
                // 1 sources

                {
                    pause = !(map.expireMaxSizeFlag != false && (long)map.size() >= map.expireMaxSize || map.expireStoreSize != 0L && Store.forEngine(map.engine).getCurrSize() - Store.forEngine(map.engine).getFreeSize() >= map.expireStoreSize);
                    continue;
                }
                break;
            }
        }
    }

    abstract class HashIterator {
        protected LinkedNode[] currentLinkedList = this.findNextLinkedNode(0);
        protected int currentLinkedListPos = 0;
        private K lastReturnedKey = null;
        private int lastSegment = 0;

        HashIterator() {
        }

        public void remove() {
            Object keyToRemove = this.lastReturnedKey;
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.lastReturnedKey = null;
            HTreeMap.this.remove(keyToRemove);
        }

        public boolean hasNext() {
            return this.currentLinkedList != null && this.currentLinkedListPos < this.currentLinkedList.length;
        }

        protected void moveToNext() {
            this.lastReturnedKey = this.currentLinkedList[this.currentLinkedListPos].key;
            ++this.currentLinkedListPos;
            if (this.currentLinkedListPos == this.currentLinkedList.length) {
                int lastHash = HTreeMap.this.hash(this.lastReturnedKey);
                this.currentLinkedList = this.advance(lastHash);
                this.currentLinkedListPos = 0;
            }
        }

        private LinkedNode[] advance(int lastHash) {
            int segment = lastHash >>> 28;
            try {
                HTreeMap.this.segmentLocks[segment].readLock().lock();
                long dirRecid = HTreeMap.this.segmentRecids[segment];
                int level = 3;
                while (true) {
                    int pos;
                    long[][] dir;
                    if ((dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER))[(pos = lastHash >>> 7 * level & 0x7F) >>> 3] == null || dir[pos >>> 3][pos & 7] == 0L || (dir[pos >>> 3][pos & 7] & 1L) == 1L) {
                        lastHash = level != 0 ? (lastHash >>> 7 * level) + 1 << 7 * level : ++lastHash;
                        if (lastHash == 0) {
                            return null;
                        }
                        break;
                    }
                    dirRecid = dir[pos >>> 3][pos & 7] >>> 1;
                    --level;
                }
            }
            finally {
                HTreeMap.this.segmentLocks[segment].readLock().unlock();
            }
            return this.findNextLinkedNode(lastHash);
        }

        private LinkedNode[] findNextLinkedNode(int hash) {
            int segment = Math.max(hash >>> 28, this.lastSegment);
            while (segment < 16) {
                Lock lock = HTreeMap.this.expireAccessFlag ? HTreeMap.this.segmentLocks[segment].writeLock() : HTreeMap.this.segmentLocks[segment].readLock();
                lock.lock();
                try {
                    LinkedNode ln;
                    int n;
                    int n2;
                    LinkedNode[] linkedNodeArray;
                    this.lastSegment = Math.max(segment, this.lastSegment);
                    long dirRecid = HTreeMap.this.segmentRecids[segment];
                    LinkedNode[] ret = this.findNextLinkedNodeRecur(dirRecid, hash, 3);
                    if (ret != null) {
                        linkedNodeArray = ret;
                        n2 = ret.length;
                        n = 0;
                        while (n < n2) {
                            ln = linkedNodeArray[n];
                            assert (HTreeMap.this.hash(ln.key) >>> 28 == segment);
                            ++n;
                        }
                    }
                    if (ret != null) {
                        if (HTreeMap.this.expireAccessFlag) {
                            linkedNodeArray = ret;
                            n2 = ret.length;
                            n = 0;
                            while (n < n2) {
                                ln = linkedNodeArray[n];
                                HTreeMap.this.expireLinkBump(segment, ln.expireLinkNodeRecid, true);
                                ++n;
                            }
                        }
                        LinkedNode[] linkedNodeArray2 = ret;
                        return linkedNodeArray2;
                    }
                    hash = 0;
                }
                finally {
                    lock.unlock();
                }
                ++segment;
            }
            return null;
        }

        private LinkedNode[] findNextLinkedNodeRecur(long dirRecid, int newHash, int level) {
            long[][] dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER);
            if (dir == null) {
                return null;
            }
            int pos = newHash >>> level * 7 & 0x7F;
            boolean first = true;
            while (pos < 128) {
                long recid;
                if (dir[pos >>> 3] != null && (recid = dir[pos >>> 3][pos & 7]) != 0L) {
                    if ((recid & 1L) == 1L) {
                        recid >>= 1;
                        LinkedNode[] array = new LinkedNode[1];
                        int arrayPos = 0;
                        while (recid != 0L) {
                            LinkedNode ln = HTreeMap.this.engine.get(recid, HTreeMap.this.LN_SERIALIZER);
                            if (ln == null) {
                                recid = 0L;
                                continue;
                            }
                            if (arrayPos == array.length) {
                                array = Arrays.copyOf(array, array.length + 1);
                            }
                            array[arrayPos++] = ln;
                            recid = ln.next;
                        }
                        return array;
                    }
                    LinkedNode[] ret = this.findNextLinkedNodeRecur(recid >>= 1, first ? newHash : 0, level - 1);
                    if (ret != null) {
                        return ret;
                    }
                }
                first = false;
                ++pos;
            }
            return null;
        }
    }

    class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos].key;
            this.moveToNext();
            return key;
        }
    }

    public class KeySet
    extends AbstractSet<K> {
        @Override
        public int size() {
            return HTreeMap.this.size();
        }

        public long sizeLong() {
            return HTreeMap.this.sizeLong();
        }

        @Override
        public boolean isEmpty() {
            return HTreeMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return HTreeMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean add(K k) {
            if (HTreeMap.this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return HTreeMap.this.put(k, BTreeMap.EMPTY) == null;
        }

        @Override
        public boolean remove(Object o) {
            return HTreeMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            HTreeMap.this.clear();
        }

        public HTreeMap<K, V> parent() {
            return HTreeMap.this;
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (Object k : this) {
                result += HTreeMap.this.hasher.hashCode(k);
            }
            return result;
        }
    }

    protected static final class LinkedNode<K, V> {
        public final long next;
        public final long expireLinkNodeRecid;
        public final K key;
        public final V value;

        public LinkedNode(long next, long expireLinkNodeRecid, K key, V value) {
            this.key = key;
            this.expireLinkNodeRecid = expireLinkNodeRecid;
            this.value = value;
            this.next = next;
        }
    }

    class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object value = this.currentLinkedList[this.currentLinkedListPos].value;
            this.moveToNext();
            return value;
        }
    }
}

