/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DataOutput2
extends OutputStream
implements DataOutput {
    public byte[] buf;
    public volatile int pos = 0;

    public DataOutput2() {
        this.buf = new byte[16];
    }

    public DataOutput2(byte[] buf) {
        this.buf = buf;
    }

    public byte[] copyBytes() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public void ensureAvail(int n) {
        if (this.pos + n >= this.buf.length) {
            int newSize = Math.max(this.pos + n, this.buf.length * 2);
            this.buf = Arrays.copyOf(this.buf, newSize);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureAvail(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureAvail(1);
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureAvail(2);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeInt(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvail(4);
        this.buf[this.pos++] = (byte)(0xFF & v >> 24);
        this.buf[this.pos++] = (byte)(0xFF & v >> 16);
        this.buf[this.pos++] = (byte)(0xFF & v >> 8);
        this.buf[this.pos++] = (byte)(0xFF & v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvail(8);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 56);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 48);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 40);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 32);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 24);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 16);
        this.buf[this.pos++] = (byte)(0xFFL & v >> 8);
        this.buf[this.pos++] = (byte)(0xFFL & v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = s.length();
        DataOutput2.packInt(this, len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            DataOutput2.packInt(this, c);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void packLong(DataOutput out, long value) throws IOException {
        if (DataOutput2.$assertionsDisabled || value >= 0L) ** GOTO lbl5
        throw new AssertionError((Object)("negative value: " + value));
lbl-1000:
        // 1 sources

        {
            out.write((int)value & 127 | 128);
            value >>>= 7;
lbl5:
            // 2 sources

            ** while ((value & -128L) != 0L)
        }
lbl6:
        // 1 sources

        out.write((byte)value);
    }

    /*
     * Unable to fully structure code
     */
    public static void packInt(DataOutput in, int value) throws IOException {
        if (DataOutput2.$assertionsDisabled || value >= 0) ** GOTO lbl5
        throw new AssertionError((Object)("negative value: " + value));
lbl-1000:
        // 1 sources

        {
            in.write(value & 127 | 128);
            value >>>= 7;
lbl5:
            // 2 sources

            ** while ((value & -128) != 0)
        }
lbl6:
        // 1 sources

        in.write((byte)value);
    }
}

