/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.websocket;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.cdi.websocket.WebSocketCdiListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;

public class WebSocketCdiInitializer
implements ServletContainerInitializer {
    public static void configureContext(ServletContextHandler context) throws ServletException {
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());){
            WebSocketCdiInitializer.addListeners((ContainerLifeCycle)context);
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        ContextHandler handler = ContextHandler.getContextHandler((ServletContext)context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, WebSocket+CDI support unavailable");
        }
        if (!(handler instanceof ServletContextHandler)) {
            throw new ServletException("Not running in Jetty ServletContextHandler, WebSocket+CDI support unavailable");
        }
        ServletContextHandler jettyContext = (ServletContextHandler)handler;
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());){
            WebSocketCdiInitializer.addListeners((ContainerLifeCycle)jettyContext);
        }
    }

    private static void addListeners(ContainerLifeCycle container) {
        WebSocketCdiListener listener = new WebSocketCdiListener();
        container.addLifeCycleListener((LifeCycle.Listener)listener);
        container.addEventListener((Container.Listener)listener);
    }
}

