package utils;

public class Converter {


	private final static char[] hexChars = { '0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f' };
	
	public static String toHex(byte[] bytes)
	{
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; i++) {
            chars[i * 2] = hexChars[((bytes[i] >> 4) & 0xF)];
            chars[i * 2 + 1] = hexChars[(bytes[i] & 0xF)];
        }
        return String.valueOf(chars);
	}
	
	public static byte[] parseHexString(String hex) {
		if (hex == null) {
			return null;
		}
		byte[] bytes = new byte[hex.length() / 2];
		for (int i = 0; i < bytes.length; i++) {
			int char1 = hex.charAt(i * 2);
			char1 = char1 > 0x60 ? char1 - 0x57 : char1 - 0x30;
			int char2 = hex.charAt(i * 2 + 1);
			char2 = char2 > 0x60 ? char2 - 0x57 : char2 - 0x30;
			if (char1 < 0 || char2 < 0 || char1 > 15 || char2 > 15) {
				throw new NumberFormatException("Invalid hex number: " + hex);
			}
			bytes[i] = (byte)((char1 << 4) + char2);
		}
		return bytes;
	}
	
}
