/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.FastPushbackReader;
import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonParser;
import com.cedarsoftware.util.io.MapResolver;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.ObjectResolver;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.Resolver;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JsonReader
implements Closeable {
    public static final String CUSTOM_READER_MAP = "CUSTOM_READERS";
    public static final String NOT_CUSTOM_READER_MAP = "NOT_CUSTOM_READERS";
    public static final String USE_MAPS = "USE_MAPS";
    public static final String UNKNOWN_OBJECT = "UNKNOWN_OBJECT";
    public static final String JSON_READER = "JSON_READER";
    public static final String OBJECT_RESOLVER = "OBJECT_RESOLVER";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String MISSING_FIELD_HANDLER = "MISSING_FIELD_HANDLER";
    public static final String CLASSLOADER = "CLASSLOADER";
    static final String TYPE_NAME_MAP_REVERSE = "TYPE_NAME_MAP_REVERSE";
    protected final ConcurrentMap<Class, JsonClassReaderBase> readers = new ConcurrentHashMap<Class, JsonClassReaderBase>();
    protected MissingFieldHandler missingFieldHandler;
    protected final Set<Class> notCustom = new HashSet<Class>();
    private static final Map<Class, Factory> factory = new ConcurrentHashMap<Class, Factory>();
    private final Map<Long, JsonObject> objsRead = new HashMap<Long, JsonObject>();
    private final FastPushbackReader input;
    private final Map<String, Object> args = new HashMap<String, Object>();

    static {
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, colFactory);
        JsonReader.assignInstantiator(List.class, colFactory);
        JsonReader.assignInstantiator(Set.class, colFactory);
        JsonReader.assignInstantiator(SortedSet.class, colFactory);
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, mapFactory);
    }

    public static void assignInstantiator(Class c, Factory f) {
        factory.put(c, f);
    }

    public void addReader(Class c, JsonClassReaderBase reader) {
        this.readers.put(c, reader);
    }

    public void addNotCustomReader(Class c) {
        this.notCustom.add(c);
    }

    MissingFieldHandler getMissingFieldHandler() {
        return this.missingFieldHandler;
    }

    public void setMissingFieldHandler(MissingFieldHandler handler) {
        this.missingFieldHandler = handler;
    }

    public Map getArgs() {
        return this.args;
    }

    public static Object jsonToJava(String json) {
        return JsonReader.jsonToJava(json, null);
    }

    public static Object jsonToJava(String json, Map<String, Object> optionalArgs) {
        ByteArrayInputStream ba;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
            optionalArgs.put(USE_MAPS, false);
        }
        if (!optionalArgs.containsKey(USE_MAPS)) {
            optionalArgs.put(USE_MAPS, false);
        }
        try {
            ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Could not convert JSON to Maps because your JVM does not support UTF-8", e);
        }
        JsonReader jr = new JsonReader((InputStream)ba, optionalArgs);
        Object obj = jr.readObject();
        jr.close();
        return obj;
    }

    public static Object jsonToJava(InputStream inputStream, Map<String, Object> optionalArgs) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
            optionalArgs.put(USE_MAPS, false);
        }
        if (!optionalArgs.containsKey(USE_MAPS)) {
            optionalArgs.put(USE_MAPS, false);
        }
        JsonReader jr = new JsonReader(inputStream, optionalArgs);
        Object obj = jr.readObject();
        jr.close();
        return obj;
    }

    public static Map jsonToMaps(String json) {
        return JsonReader.jsonToMaps(json, null);
    }

    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs) {
        try {
            if (optionalArgs == null) {
                optionalArgs = new HashMap<String, Object>();
            }
            optionalArgs.put(USE_MAPS, true);
            ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes("UTF-8"));
            JsonReader jr = new JsonReader((InputStream)ba, optionalArgs);
            Object ret = jr.readObject();
            jr.close();
            return JsonReader.adjustOutputMap(ret);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Could not convert JSON to Maps because your JVM does not support UTF-8", e);
        }
    }

    public static Map jsonToMaps(InputStream inputStream, Map<String, Object> optionalArgs) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        optionalArgs.put(USE_MAPS, true);
        JsonReader jr = new JsonReader(inputStream, optionalArgs);
        Object ret = jr.readObject();
        jr.close();
        return JsonReader.adjustOutputMap(ret);
    }

    private static Map adjustOutputMap(Object ret) {
        if (ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret.getClass().isArray()) {
            JsonObject<String, Object> retMap = new JsonObject<String, Object>();
            retMap.put("@items", ret);
            return retMap;
        }
        JsonObject<String, Object[]> retMap = new JsonObject<String, Object[]>();
        retMap.put("@items", new Object[]{ret});
        return retMap;
    }

    public JsonReader() {
        this.addReader(String.class, new Readers.StringReader());
        this.addReader(java.util.Date.class, new Readers.DateReader());
        this.addReader(BigInteger.class, new Readers.BigIntegerReader());
        this.addReader(BigDecimal.class, new Readers.BigDecimalReader());
        this.addReader(Date.class, new Readers.SqlDateReader());
        this.addReader(Timestamp.class, new Readers.TimestampReader());
        this.addReader(Calendar.class, new Readers.CalendarReader());
        this.addReader(TimeZone.class, new Readers.TimeZoneReader());
        this.addReader(Locale.class, new Readers.LocaleReader());
        this.addReader(Class.class, new Readers.ClassReader());
        this.addReader(StringBuilder.class, new Readers.StringBuilderReader());
        this.addReader(StringBuffer.class, new Readers.StringBufferReader());
        this.input = null;
        this.getArgs().put(USE_MAPS, false);
        this.getArgs().put(CLASSLOADER, JsonReader.class.getClassLoader());
    }

    public JsonReader(InputStream inp) {
        this(inp, false);
    }

    public JsonReader(Map<String, Object> optionalArgs) {
        this((InputStream)new ByteArrayInputStream(new byte[0]), optionalArgs);
    }

    static Map makeArgMap(Map<String, Object> args, boolean useMaps) {
        args.put(USE_MAPS, useMaps);
        return args;
    }

    public JsonReader(InputStream inp, boolean useMaps) {
        this(inp, JsonReader.makeArgMap(new HashMap<String, Object>(), useMaps));
    }

    public JsonReader(InputStream inp, Map<String, Object> optionalArgs) {
        Iterable notCustomReaders;
        Map typeNames;
        this.addReader(String.class, new Readers.StringReader());
        this.addReader(java.util.Date.class, new Readers.DateReader());
        this.addReader(BigInteger.class, new Readers.BigIntegerReader());
        this.addReader(BigDecimal.class, new Readers.BigDecimalReader());
        this.addReader(Date.class, new Readers.SqlDateReader());
        this.addReader(Timestamp.class, new Readers.TimestampReader());
        this.addReader(Calendar.class, new Readers.CalendarReader());
        this.addReader(TimeZone.class, new Readers.TimeZoneReader());
        this.addReader(Locale.class, new Readers.LocaleReader());
        this.addReader(Class.class, new Readers.ClassReader());
        this.addReader(StringBuilder.class, new Readers.StringBuilderReader());
        this.addReader(StringBuffer.class, new Readers.StringBufferReader());
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        Map args = this.getArgs();
        args.putAll(optionalArgs);
        args.put(JSON_READER, this);
        if (!args.containsKey(CLASSLOADER)) {
            args.put(CLASSLOADER, JsonReader.class.getClassLoader());
        }
        if ((typeNames = (Map)args.get(TYPE_NAME_MAP)) != null) {
            HashMap<String, String> typeNameMap = new HashMap<String, String>();
            for (Map.Entry entry : typeNames.entrySet()) {
                typeNameMap.put((String)entry.getValue(), (String)entry.getKey());
            }
            args.put(TYPE_NAME_MAP_REVERSE, typeNameMap);
        }
        this.setMissingFieldHandler((MissingFieldHandler)args.get(MISSING_FIELD_HANDLER));
        Map customReaders = (Map)args.get(CUSTOM_READER_MAP);
        if (customReaders != null) {
            for (Map.Entry entry : customReaders.entrySet()) {
                this.addReader((Class)entry.getKey(), (JsonClassReaderBase)entry.getValue());
            }
        }
        if ((notCustomReaders = (Iterable)args.get(NOT_CUSTOM_READER_MAP)) != null) {
            for (Class c : notCustomReaders) {
                this.addNotCustomReader(c);
            }
        }
        try {
            this.input = new FastPushbackReader(new InputStreamReader(inp, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("Your JVM does not support UTF-8.  Get a better JVM.", e);
        }
    }

    public Map<Long, JsonObject> getObjectsRead() {
        return this.objsRead;
    }

    public Object getRefTarget(JsonObject jObj) {
        if (!jObj.isReference()) {
            return jObj;
        }
        Long id = jObj.getReferenceId();
        JsonObject target = this.objsRead.get(id);
        if (target == null) {
            throw new IllegalStateException("The JSON input had an @ref to an object that does not exist.");
        }
        return this.getRefTarget(target);
    }

    public Object readObject() {
        Object graph;
        Object o;
        JsonParser parser = new JsonParser(this.input, this.objsRead, this.getArgs());
        JsonObject<String, Object> root = new JsonObject<String, Object>();
        try {
            o = parser.readValue(root);
            if (o == "~!o~") {
                return new JsonObject();
            }
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            Object object = graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps()) {
            return o;
        }
        return graph;
    }

    public Object jsonObjectsToJava(JsonObject root) {
        this.getArgs().put(USE_MAPS, false);
        return this.convertParsedMapsToJava(root);
    }

    protected boolean useMaps() {
        return Boolean.TRUE.equals(this.getArgs().get(USE_MAPS));
    }

    ClassLoader getClassLoader() {
        return (ClassLoader)this.args.get(CLASSLOADER);
    }

    protected Object convertParsedMapsToJava(JsonObject root) {
        try {
            Resolver resolver = this.useMaps() ? new MapResolver(this) : new ObjectResolver(this, (ClassLoader)this.args.get(CLASSLOADER));
            resolver.createJavaObjectInstance(Object.class, root);
            Object graph = resolver.convertMapsToObjects(root);
            resolver.cleanup();
            this.readers.clear();
            return graph;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
    }

    public static Object newInstance(Class c) {
        if (factory.containsKey(c)) {
            ClassFactory cf = (ClassFactory)factory.get(c);
            return cf.newInstance(c);
        }
        return MetaUtils.newInstance(c);
    }

    public static Object newInstance(Class c, JsonObject jsonObject) {
        if (factory.containsKey(c)) {
            Factory cf = factory.get(c);
            if (cf instanceof ClassFactoryEx) {
                HashMap<String, JsonObject> args = new HashMap<String, JsonObject>();
                args.put("jsonObj", jsonObject);
                return ((ClassFactoryEx)cf).newInstance(c, args);
            }
            if (cf instanceof ClassFactory) {
                return ((ClassFactory)cf).newInstance(c);
            }
            throw new JsonIoException("Unknown instantiator (Factory) class.  Must subclass ClassFactoryEx or ClassFactory, found: " + cf.getClass().getName());
        }
        return MetaUtils.newInstance(c);
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return String.valueOf(msg) + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.line + ", col: " + this.input.col;
        }
        return msg;
    }

    public static interface ClassFactory
    extends Factory {
        public Object newInstance(Class var1);
    }

    public static interface ClassFactoryEx
    extends Factory {
        public Object newInstance(Class var1, Map var2);
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface Factory {
    }

    public static interface JsonClassReader
    extends JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2);
    }

    public static interface JsonClassReaderBase {
    }

    public static interface JsonClassReaderEx
    extends JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2, Map<String, Object> var3);

        public static class Support {
            public static JsonReader getReader(Map<String, Object> args) {
                return (JsonReader)args.get(JsonReader.JSON_READER);
            }
        }
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }
}

