/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.parser;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.FunctionOrMacroNameNode;
import com.mitchellbosecke.pebble.node.NamedArgumentNode;
import com.mitchellbosecke.pebble.node.PositionalArgumentNode;
import com.mitchellbosecke.pebble.node.TestInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.ArrayExpression;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.node.expression.BlockFunctionExpression;
import com.mitchellbosecke.pebble.node.expression.ContextVariableExpression;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.node.expression.FilterExpression;
import com.mitchellbosecke.pebble.node.expression.FilterInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.FunctionOrMacroInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.GetAttributeExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralBooleanExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralDoubleExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralLongExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralNullExpression;
import com.mitchellbosecke.pebble.node.expression.LiteralStringExpression;
import com.mitchellbosecke.pebble.node.expression.MapExpression;
import com.mitchellbosecke.pebble.node.expression.NegativeTestExpression;
import com.mitchellbosecke.pebble.node.expression.ParentFunctionExpression;
import com.mitchellbosecke.pebble.node.expression.PositiveTestExpression;
import com.mitchellbosecke.pebble.node.expression.TernaryExpression;
import com.mitchellbosecke.pebble.node.expression.UnaryExpression;
import com.mitchellbosecke.pebble.operator.Associativity;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.parser.Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExpressionParser {
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("true", "false", "null", "none"));
    private final Parser parser;
    private TokenStream stream;
    private Map<String, BinaryOperator> binaryOperators;
    private Map<String, UnaryOperator> unaryOperators;

    public ExpressionParser(Parser parser, Map<String, BinaryOperator> binaryOperators, Map<String, UnaryOperator> unaryOperators) {
        this.parser = parser;
        this.binaryOperators = binaryOperators;
        this.unaryOperators = unaryOperators;
    }

    public Expression<?> parseExpression() throws ParserException {
        return this.parseExpression(0);
    }

    private Expression<?> parseExpression(int minPrecedence) throws ParserException {
        Object operator;
        this.stream = this.parser.getStream();
        Token token = this.stream.current();
        Expression<Object> expression = null;
        if (this.isUnary(token)) {
            operator = this.unaryOperators.get(token.getValue());
            this.stream.next();
            expression = this.parseExpression(operator.getPrecedence());
            UnaryExpression unaryExpression = null;
            Class<? extends UnaryExpression> operatorNodeClass = operator.getNodeClass();
            try {
                unaryExpression = operatorNodeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            unaryExpression.setChildExpression(expression);
            expression = unaryExpression;
        } else if (token.test(Token.Type.PUNCTUATION, "(")) {
            this.stream.next();
            expression = this.parseExpression();
            this.stream.expect(Token.Type.PUNCTUATION, ")");
            expression = this.parsePostfixExpression(expression);
        } else {
            expression = token.test(Token.Type.PUNCTUATION, "[") ? this.parseArrayDefinitionExpression() : (token.test(Token.Type.PUNCTUATION, "{") ? this.parseMapDefinitionExpression() : this.subparseExpression());
        }
        token = this.stream.current();
        while (this.isBinary(token) && this.binaryOperators.get(token.getValue()).getPrecedence() >= minPrecedence) {
            operator = this.binaryOperators.get(token.getValue());
            this.stream.next();
            Expression<Object> expressionRight = null;
            expressionRight = FilterExpression.class.equals(operator.getNodeClass()) ? this.parseFilterInvocationExpression() : (PositiveTestExpression.class.equals(operator.getNodeClass()) || NegativeTestExpression.class.equals(operator.getNodeClass()) ? this.parseTestInvocationExpression() : this.parseExpression(Associativity.LEFT.equals((Object)operator.getAssociativity()) ? operator.getPrecedence() + 1 : operator.getPrecedence()));
            BinaryExpression<Object> finalExpression = null;
            Class<BinaryExpression<?>> operatorNodeClass = operator.getNodeClass();
            try {
                finalExpression = operatorNodeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new ParserException((Throwable)e, "Error instantiating operator node [" + operatorNodeClass.getName() + "]", token.getLineNumber(), this.stream.getFilename());
            }
            finalExpression.setLeft(expression);
            finalExpression.setRight(expressionRight);
            expression = finalExpression;
            token = this.stream.current();
        }
        if (minPrecedence == 0) {
            return this.parseTernaryExpression(expression);
        }
        return expression;
    }

    private boolean isUnary(Token token) {
        return token.test(Token.Type.OPERATOR) && this.unaryOperators.containsKey(token.getValue());
    }

    private boolean isBinary(Token token) {
        return token.test(Token.Type.OPERATOR) && this.binaryOperators.containsKey(token.getValue());
    }

    private Expression<?> subparseExpression() throws ParserException {
        Token token = this.stream.current();
        Expression<String> node = null;
        block0 : switch (token.getType()) {
            case NAME: {
                switch (token.getValue()) {
                    case "true": 
                    case "TRUE": {
                        node = new LiteralBooleanExpression(true);
                        break block0;
                    }
                    case "false": 
                    case "FALSE": {
                        node = new LiteralBooleanExpression(false);
                        break block0;
                    }
                    case "none": 
                    case "NONE": 
                    case "null": 
                    case "NULL": {
                        node = new LiteralNullExpression();
                        break block0;
                    }
                }
                if (this.stream.peek().test(Token.Type.PUNCTUATION, "(")) {
                    node = new FunctionOrMacroNameNode(token.getValue());
                    break;
                }
                node = new ContextVariableExpression(token.getValue());
                break;
            }
            case NUMBER: {
                String numberValue = token.getValue();
                if (numberValue.contains(".")) {
                    node = new LiteralDoubleExpression(Double.valueOf(numberValue));
                    break;
                }
                node = new LiteralLongExpression(Long.valueOf(numberValue));
                break;
            }
            case STRING: {
                node = new LiteralStringExpression(token.getValue());
                break;
            }
            default: {
                throw new ParserException(null, String.format("Unexpected token \"%s\" of value \"%s\"", token.getType().toString(), token.getValue()), token.getLineNumber(), this.stream.getFilename());
            }
        }
        this.stream.next();
        return this.parsePostfixExpression(node);
    }

    private Expression<?> parseTernaryExpression(Expression<?> expression) throws ParserException {
        while (this.stream.current().test(Token.Type.PUNCTUATION, "?")) {
            this.stream.next();
            Expression<?> expression2 = null;
            Expression<?> expression3 = null;
            if (!this.stream.current().test(Token.Type.PUNCTUATION, ":")) {
                expression2 = this.parseExpression();
                if (this.stream.current().test(Token.Type.PUNCTUATION, ":")) {
                    this.stream.next();
                    expression3 = this.parseExpression();
                }
            } else {
                this.stream.next();
                expression2 = expression;
                expression3 = this.parseExpression();
            }
            expression = new TernaryExpression(expression, expression2, expression3);
        }
        return expression;
    }

    private Expression<?> parsePostfixExpression(Expression<?> node) throws ParserException {
        while (true) {
            Token current;
            if ((current = this.stream.current()).test(Token.Type.PUNCTUATION, ".") || current.test(Token.Type.PUNCTUATION, "[")) {
                node = this.parseBeanAttributeExpression(node);
                continue;
            }
            if (!current.test(Token.Type.PUNCTUATION, "(")) break;
            node = this.parseFunctionOrMacroInvocation(node);
        }
        return node;
    }

    private Expression<?> parseFunctionOrMacroInvocation(Expression<?> node) throws ParserException {
        String functionName = ((FunctionOrMacroNameNode)node).getName();
        ArgumentsNode args = this.parseArguments();
        switch (functionName) {
            case "parent": {
                return new ParentFunctionExpression(this.parser.peekBlockStack(), this.stream.current().getLineNumber());
            }
            case "block": {
                return new BlockFunctionExpression(args);
            }
        }
        return new FunctionOrMacroInvocationExpression(functionName, args);
    }

    public FilterInvocationExpression parseFilterInvocationExpression() throws ParserException {
        TokenStream stream = this.parser.getStream();
        Token filterToken = stream.expect(Token.Type.NAME);
        ArgumentsNode args = null;
        args = stream.current().test(Token.Type.PUNCTUATION, "(") ? this.parseArguments() : new ArgumentsNode(null, null);
        return new FilterInvocationExpression(filterToken.getValue(), args);
    }

    private Expression<?> parseTestInvocationExpression() throws ParserException {
        TokenStream stream = this.parser.getStream();
        int lineNumber = stream.current().getLineNumber();
        Token testToken = stream.expect(Token.Type.NAME);
        ArgumentsNode args = null;
        args = stream.current().test(Token.Type.PUNCTUATION, "(") ? this.parseArguments() : new ArgumentsNode(null, null);
        return new TestInvocationExpression(lineNumber, testToken.getValue(), args);
    }

    private Expression<?> parseBeanAttributeExpression(Expression<?> node) throws ParserException {
        TokenStream stream = this.parser.getStream();
        if (stream.current().test(Token.Type.PUNCTUATION, ".")) {
            stream.next();
            Token token = stream.expect(Token.Type.NAME);
            ArgumentsNode args = null;
            if (stream.current().test(Token.Type.PUNCTUATION, "(") && !(args = this.parseArguments()).getNamedArgs().isEmpty()) {
                throw new ParserException(null, "Can not use named arguments when calling a bean method", stream.current().getLineNumber(), stream.getFilename());
            }
            node = new GetAttributeExpression(node, token.getValue(), args);
        } else if (stream.current().test(Token.Type.PUNCTUATION, "[")) {
            stream.next();
            Token token = stream.current();
            if (!token.test(Token.Type.STRING) && !token.test(Token.Type.NUMBER)) {
                throw new ParserException(null, "Only strings and numbers allowed within square brackets.", token.getLineNumber(), stream.getFilename());
            }
            node = new GetAttributeExpression(node, token.getValue());
            stream.next();
            stream.expect(Token.Type.PUNCTUATION, "]");
        }
        return node;
    }

    public ArgumentsNode parseArguments() throws ParserException {
        return this.parseArguments(false);
    }

    public ArgumentsNode parseArguments(boolean isMacroDefinition) throws ParserException {
        ArrayList<PositionalArgumentNode> positionalArgs = new ArrayList<PositionalArgumentNode>();
        ArrayList<NamedArgumentNode> namedArgs = new ArrayList<NamedArgumentNode>();
        this.stream = this.parser.getStream();
        this.stream.expect(Token.Type.PUNCTUATION, "(");
        while (!this.stream.current().test(Token.Type.PUNCTUATION, ")")) {
            String argumentName = null;
            Expression<?> argumentValue = null;
            if (!namedArgs.isEmpty() || !positionalArgs.isEmpty()) {
                this.stream.expect(Token.Type.PUNCTUATION, ",");
            }
            if (isMacroDefinition) {
                argumentName = this.parseNewVariableName();
                if (this.stream.current().test(Token.Type.PUNCTUATION, "=")) {
                    this.stream.expect(Token.Type.PUNCTUATION, "=");
                    argumentValue = this.parseExpression();
                }
            } else {
                if (this.stream.peek().test(Token.Type.PUNCTUATION, "=")) {
                    argumentName = this.parseNewVariableName();
                    this.stream.expect(Token.Type.PUNCTUATION, "=");
                }
                argumentValue = this.parseExpression();
            }
            if (argumentName == null) {
                if (!namedArgs.isEmpty()) {
                    throw new ParserException(null, "Positional arguments must be declared before any named arguments.", this.stream.current().getLineNumber(), this.stream.getFilename());
                }
                positionalArgs.add(new PositionalArgumentNode(argumentValue));
                continue;
            }
            namedArgs.add(new NamedArgumentNode(argumentName, argumentValue));
        }
        this.stream.expect(Token.Type.PUNCTUATION, ")");
        return new ArgumentsNode(positionalArgs, namedArgs);
    }

    public String parseNewVariableName() throws ParserException {
        this.stream = this.parser.getStream();
        Token token = this.stream.current();
        token.test(Token.Type.NAME);
        if (RESERVED_KEYWORDS.contains(token.getValue())) {
            throw new ParserException(null, String.format("Can not assign a value to %s", token.getValue()), token.getLineNumber(), this.stream.getFilename());
        }
        this.stream.next();
        return token.getValue();
    }

    private Expression<?> parseArrayDefinitionExpression() throws ParserException {
        TokenStream stream = this.parser.getStream();
        stream.expect(Token.Type.PUNCTUATION, "[");
        if (stream.current().test(Token.Type.PUNCTUATION, "]")) {
            stream.next();
            return new ArrayExpression();
        }
        ArrayList elements = new ArrayList();
        while (true) {
            Expression<?> expr = this.parseExpression();
            elements.add(expr);
            if (stream.current().test(Token.Type.PUNCTUATION, "]")) break;
            stream.expect(Token.Type.PUNCTUATION, ",");
        }
        stream.expect(Token.Type.PUNCTUATION, "]");
        return new ArrayExpression(elements);
    }

    private Expression<?> parseMapDefinitionExpression() throws ParserException {
        TokenStream stream = this.parser.getStream();
        stream.expect(Token.Type.PUNCTUATION, "{");
        if (stream.current().test(Token.Type.PUNCTUATION, "}")) {
            stream.next();
            return new MapExpression();
        }
        HashMap elements = new HashMap();
        while (true) {
            Expression<?> keyExpr = this.parseExpression();
            stream.expect(Token.Type.PUNCTUATION, ":");
            Expression<?> valueExpr = this.parseExpression();
            elements.put(keyExpr, valueExpr);
            if (stream.current().test(Token.Type.PUNCTUATION, "}")) break;
            stream.expect(Token.Type.PUNCTUATION, ",");
        }
        stream.expect(Token.Type.PUNCTUATION, "}");
        return new MapExpression(elements);
    }
}

