/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Fun;
import org.mapdb.LongHashMap;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Volume;

public class StoreDirect
extends Store {
    protected static final long MASK_OFFSET = 0xFFFFFFFFFFF0L;
    protected static final long MASK_LINKED = 8L;
    protected static final long MASK_DISCARD = 4L;
    protected static final long MASK_ARCHIVE = 2L;
    protected static final int HEADER = 234243482;
    protected static final short STORE_VERSION = 10000;
    protected static final int MAX_REC_SIZE = 65535;
    protected static final int PHYS_FREE_SLOTS_COUNT = 4096;
    protected static final int IO_INDEX_SIZE = 8;
    protected static final int IO_PHYS_SIZE = 16;
    protected static final int IO_FREE_SIZE = 24;
    protected static final int IO_INDEX_SUM = 32;
    protected static final int IO_FREE_RECID = 120;
    protected static final int IO_USER_START = 32896;
    public static final String DATA_FILE_EXT = ".p";
    protected static final int LONG_STACK_PREF_COUNT = 204;
    protected static final long LONG_STACK_PREF_SIZE = 1232L;
    protected static final int LONG_STACK_PREF_COUNT_ALTER = 212;
    protected static final long LONG_STACK_PREF_SIZE_ALTER = 1280L;
    protected Volume index;
    protected Volume phys;
    protected long physSize;
    protected long indexSize;
    protected long freeSize;
    protected final boolean deleteFilesAfterClose;
    protected final boolean readOnly;
    protected final boolean syncOnCommitDisabled;
    protected final boolean spaceReclaimReuse;
    protected final boolean spaceReclaimSplit;
    protected final boolean spaceReclaimTrack;
    protected final long sizeLimit;
    protected long maxUsedIoList = 0L;

    public StoreDirect(Volume.Factory volFac, boolean readOnly, boolean deleteFilesAfterClose, int spaceReclaimMode, boolean syncOnCommitDisabled, long sizeLimit, boolean checksum, boolean compress, byte[] password, boolean disableLocks, int sizeIncrement) {
        super(checksum, compress, password, disableLocks);
        this.readOnly = readOnly;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.syncOnCommitDisabled = syncOnCommitDisabled;
        this.sizeLimit = sizeLimit;
        this.spaceReclaimSplit = spaceReclaimMode > 4;
        this.spaceReclaimReuse = spaceReclaimMode > 2;
        this.spaceReclaimTrack = spaceReclaimMode > 0;
        boolean allGood = false;
        try {
            this.index = volFac.createIndexVolume();
            this.phys = volFac.createPhysVolume();
            if (this.index.isEmpty()) {
                this.createStructure();
            } else {
                this.checkHeaders();
                this.indexSize = this.index.getLong(8L);
                this.physSize = this.index.getLong(16L);
                this.freeSize = this.index.getLong(24L);
                this.maxUsedIoList = 32888L;
                while (this.index.getLong(this.maxUsedIoList) != 0L && this.maxUsedIoList > 120L) {
                    this.maxUsedIoList -= 8L;
                }
            }
            allGood = true;
        }
        finally {
            block28: {
                if (!allGood) {
                    try {
                        if (this.index == null) break block28;
                        try {
                            this.index.sync();
                        }
                        finally {
                            this.index.close();
                        }
                        this.index = null;
                    }
                    finally {
                        if (this.phys != null) {
                            try {
                                this.phys.sync();
                            }
                            finally {
                                this.phys.close();
                            }
                            this.phys = null;
                        }
                    }
                }
            }
        }
    }

    public StoreDirect(Volume.Factory volFac) {
        this(volFac, false, false, 5, false, 0L, false, false, null, false, 0);
    }

    protected void checkHeaders() {
        if (this.index.getInt(0L) != 234243482 || this.phys.getInt(0L) != 234243482) {
            throw new IOError(new IOException("storage has invalid header"));
        }
        if (this.index.getUnsignedShort(4L) > 10000 || this.phys.getUnsignedShort(4L) > 10000) {
            throw new IOError(new IOException("New store format version, please use newer MapDB version"));
        }
        int masks = this.index.getUnsignedShort(6L);
        if (masks != this.phys.getUnsignedShort(6L)) {
            throw new IllegalArgumentException("Index and Phys file have different feature masks");
        }
        if (masks != this.expectedMasks()) {
            throw new IllegalArgumentException("File created with different features. Please check compression, checksum or encryption");
        }
        long checksum = this.index.getLong(32L);
        if (checksum != this.indexHeaderChecksum()) {
            throw new IOError(new IOException("Wrong index checksum, store was not closed properly and could be corrupted."));
        }
    }

    protected void createStructure() {
        this.indexSize = 32960L;
        assert (this.indexSize > 32896L);
        this.index.ensureAvailable(this.indexSize);
        int i = 0;
        while ((long)i < this.indexSize) {
            this.index.putLong(i, 0L);
            i += 8;
        }
        this.index.putInt(0L, 234243482);
        this.index.putUnsignedShort(4L, 10000);
        this.index.putUnsignedShort(6L, this.expectedMasks());
        this.index.putLong(8L, this.indexSize);
        this.physSize = 16L;
        this.index.putLong(16L, this.physSize);
        this.phys.ensureAvailable(this.physSize);
        this.phys.putInt(0L, 234243482);
        this.phys.putUnsignedShort(4L, 10000);
        this.phys.putUnsignedShort(6L, this.expectedMasks());
        this.freeSize = 0L;
        this.index.putLong(24L, this.freeSize);
        this.index.putLong(32L, this.indexHeaderChecksum());
    }

    protected long indexHeaderChecksum() {
        long ret = 0L;
        long offset = 0L;
        while (offset < 32896L) {
            if (offset != 32L) {
                long indexVal = this.index.getLong(offset);
                ret |= indexVal | (long)LongHashMap.longHash(indexVal | offset);
            }
            offset += 8L;
        }
        return ret;
    }

    @Override
    public long preallocate() {
        this.newRecidLock.readLock().lock();
        try {
            long ioRecid;
            this.structuralLock.lock();
            try {
                ioRecid = this.freeIoRecidTake(true);
            }
            finally {
                this.structuralLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
            lock.lock();
            try {
                this.index.putLong(ioRecid, 4L);
            }
            finally {
                lock.unlock();
            }
            long recid = (ioRecid - 32896L) / 8L;
            assert (recid > 0L);
            long l = recid;
            return l;
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
    }

    @Override
    public void preallocate(long[] recids) {
        this.newRecidLock.readLock().lock();
        try {
            int i;
            this.structuralLock.lock();
            try {
                i = 0;
                while (i < recids.length) {
                    recids[i] = this.freeIoRecidTake(true);
                    ++i;
                }
            }
            finally {
                this.structuralLock.unlock();
            }
            i = 0;
            while (i < recids.length) {
                long ioRecid = recids[i];
                ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
                lock.lock();
                try {
                    this.index.putLong(ioRecid, 4L);
                }
                finally {
                    lock.unlock();
                }
                recids[i] = (ioRecid - 32896L) / 8L;
                assert (recids[i] > 0L);
                ++i;
            }
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long ioRecid;
        assert (value != null);
        DataOutput2 out = this.serialize(value, serializer);
        this.newRecidLock.readLock().lock();
        try {
            long[] indexVals;
            this.structuralLock.lock();
            try {
                ioRecid = this.freeIoRecidTake(true);
                indexVals = this.physAllocate(out.pos, true, false);
            }
            finally {
                this.structuralLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
            lock.lock();
            try {
                this.put2(out, ioRecid, indexVals);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
        long recid = (ioRecid - 32896L) / 8L;
        assert (recid > 0L);
        this.recycledDataOuts.offer(out);
        return recid;
    }

    protected void put2(DataOutput2 out, long ioRecid, long[] indexVals) {
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        this.index.putLong(ioRecid, indexVals[0] | 2L);
        if (indexVals.length == 1 || indexVals[1] == 0L) {
            this.phys.putData(indexVals[0] & 0xFFFFFFFFFFF0L, out.buf, 0, out.pos);
        } else {
            int outPos = 0;
            int i = 0;
            while (i < indexVals.length) {
                boolean isLast;
                int c = i == indexVals.length - 1 ? 0 : 8;
                long indexVal = indexVals[i];
                boolean bl = isLast = (indexVal & 8L) == 0L;
                assert (isLast == (i == indexVals.length - 1));
                int size = (int)(indexVal >>> 48);
                long offset = indexVal & 0xFFFFFFFFFFF0L;
                this.phys.putData(offset + (long)c, out.buf, outPos, size - c);
                outPos += size - c;
                if (c > 0) {
                    this.phys.putLong(offset, indexVals[i + 1]);
                }
                ++i;
            }
            if (outPos != out.pos) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.ReadLock lock = this.locks[Store.lockPos(ioRecid)].readLock();
        lock.lock();
        try {
            A a = this.get2(ioRecid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected <A> A get2(long ioRecid, Serializer<A> serializer) throws IOException {
        DataInput2 di;
        assert (this.locks[Store.lockPos(ioRecid)].getWriteHoldCount() == 0 || this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        long indexVal = this.index.getLong(ioRecid);
        if (indexVal == 4L) {
            return null;
        }
        int size = (int)(indexVal >>> 48);
        long offset = indexVal & 0xFFFFFFFFFFF0L;
        if ((indexVal & 8L) == 0L) {
            di = (DataInput2)this.phys.getDataInput(offset, size);
        } else {
            int pos = 0;
            int c = 8;
            byte[] buf = new byte[64];
            while (true) {
                DataInput2 in = (DataInput2)this.phys.getDataInput(offset + (long)c, size - c);
                if (buf.length < pos + size - c) {
                    buf = Arrays.copyOf(buf, Math.max(pos + size - c, buf.length * 2));
                }
                in.readFully(buf, pos, size - c);
                pos += size - c;
                if (c == 0) break;
                long next = this.phys.getLong(offset);
                offset = next & 0xFFFFFFFFFFF0L;
                size = (int)(next >>> 48);
                c = (next & 8L) == 0L ? 0 : 8;
            }
            di = new DataInput2(buf);
            size = pos;
        }
        return this.deserialize(serializer, size, di);
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        assert (value != null);
        assert (recid > 0L);
        DataOutput2 out = this.serialize(value, serializer);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            this.update2(out, ioRecid);
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
    }

    protected void update2(DataOutput2 out, long ioRecid) {
        boolean linked;
        long indexVal = this.index.getLong(ioRecid);
        int size = (int)(indexVal >>> 48);
        boolean bl = linked = (indexVal & 8L) != 0L;
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        if (!linked && out.pos > 0 && size > 0 && StoreDirect.size2ListIoRecid(size) == StoreDirect.size2ListIoRecid(out.pos)) {
            long offset = indexVal & 0xFFFFFFFFFFF0L;
            this.index.putLong(ioRecid, (long)out.pos << 48 | offset | 2L);
            this.phys.putData(offset, out.buf, 0, out.pos);
        } else {
            long[] indexVals = this.spaceReclaimTrack ? this.getLinkedRecordsIndexVals(indexVal) : null;
            this.structuralLock.lock();
            try {
                if (this.spaceReclaimTrack) {
                    if (size > 0) {
                        this.freePhysPut(indexVal, false);
                    }
                    if (indexVals != null) {
                        int i = 0;
                        while (i < indexVals.length && indexVals[i] != 0L) {
                            this.freePhysPut(indexVals[i], false);
                            ++i;
                        }
                    }
                }
                indexVals = this.physAllocate(out.pos, true, false);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.put2(out, ioRecid, indexVals);
        }
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        DataOutput2 out;
        assert (expectedOldValue != null && newValue != null);
        assert (recid > 0L);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            A oldVal = this.get2(ioRecid, serializer);
            if (oldVal == null && expectedOldValue != null || oldVal != null && !oldVal.equals(expectedOldValue)) {
                return false;
            }
            try {
                out = this.serialize(newValue, serializer);
                this.update2(out, ioRecid);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            long indexVal = this.index.getLong(ioRecid);
            this.index.putLong(ioRecid, 2L);
            if (!this.spaceReclaimTrack) {
                return;
            }
            long[] linkedRecords = this.getLinkedRecordsIndexVals(indexVal);
            this.structuralLock.lock();
            try {
                block13: {
                    int i;
                    block12: {
                        this.freeIoRecidPut(ioRecid);
                        if (indexVal >>> 48 > 0L) {
                            this.freePhysPut(indexVal, false);
                        }
                        if (linkedRecords == null) return;
                        i = 0;
                        if (!true) break block12;
                        if (i >= linkedRecords.length) return;
                        if (linkedRecords[i] == 0L) break block13;
                    }
                    do {
                        this.freePhysPut(linkedRecords[i], false);
                        ++i;
                        if (i >= linkedRecords.length) return;
                    } while (linkedRecords[i] != 0L);
                }
                return;
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected long[] getLinkedRecordsIndexVals(long indexVal) {
        long[] linkedRecords = null;
        int linkedPos = 0;
        if ((indexVal & 8L) != 0L) {
            linkedRecords = new long[2];
            long linkedVal = this.phys.getLong(indexVal & 0xFFFFFFFFFFF0L);
            while (true) {
                if (linkedPos == linkedRecords.length) {
                    linkedRecords = Arrays.copyOf(linkedRecords, linkedRecords.length * 2);
                }
                linkedRecords[linkedPos] = linkedVal;
                if ((linkedVal & 8L) == 0L) break;
                ++linkedPos;
                linkedVal = this.phys.getLong(linkedVal & 0xFFFFFFFFFFF0L);
            }
        }
        return linkedRecords;
    }

    protected long[] physAllocate(int size, boolean ensureAvail, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        if ((long)size == 0L) {
            return new long[1];
        }
        if (size < 65535) {
            long indexVal = this.freePhysTake(size, ensureAvail, recursive);
            return new long[]{indexVal |= (long)size << 48};
        }
        long[] ret = new long[2];
        int retPos = 0;
        int c = 8;
        while (size > 0) {
            if (retPos == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            int allocSize = Math.min(size, 65535);
            size -= allocSize - c;
            long indexVal = this.freePhysTake(allocSize, ensureAvail, recursive);
            indexVal |= (long)allocSize << 48;
            if (c != 0) {
                indexVal |= 8L;
            }
            ret[retPos++] = indexVal;
            int n = c = size <= 65535 ? 0 : 8;
        }
        if (size != 0) {
            throw new AssertionError();
        }
        return Arrays.copyOf(ret, retPos);
    }

    protected static long roundTo16(long offset) {
        long rem = offset & 0xFL;
        if (rem != 0L) {
            offset += 16L - rem;
        }
        return offset;
    }

    @Override
    public void close() {
        for (Runnable closeListener : this.closeListeners) {
            closeListener.run();
        }
        this.lockAllWrite();
        try {
            try {
                if (!this.readOnly) {
                    if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
                        this.serializerPojo.save(this);
                    }
                    this.index.putLong(16L, this.physSize);
                    this.index.putLong(8L, this.indexSize);
                    this.index.putLong(24L, this.freeSize);
                    this.index.putLong(32L, this.indexHeaderChecksum());
                }
                if (!this.deleteFilesAfterClose) {
                    this.index.sync();
                    this.phys.sync();
                }
            }
            finally {
                try {
                    this.index.close();
                }
                finally {
                    try {
                        this.phys.close();
                    }
                    finally {
                        if (this.deleteFilesAfterClose) {
                            this.index.deleteFile();
                            this.phys.deleteFile();
                        }
                        this.index = null;
                        this.phys = null;
                    }
                }
            }
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    public boolean isClosed() {
        return this.index == null;
    }

    @Override
    public void commit() {
        if (!this.readOnly) {
            if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
                this.serializerPojo.save(this);
            }
            this.index.putLong(16L, this.physSize);
            this.index.putLong(8L, this.indexSize);
            this.index.putLong(24L, this.freeSize);
            this.index.putLong(32L, this.indexHeaderChecksum());
        }
        if (!this.syncOnCommitDisabled) {
            this.index.sync();
            this.phys.sync();
        }
    }

    @Override
    public void rollback() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("rollback not supported with journal disabled");
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean canRollback() {
        return false;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void compact() {
        if (this.readOnly) {
            throw new IllegalAccessError();
        }
        File indexFile = this.index.getFile();
        File physFile = this.phys.getFile();
        int rafMode = this.index instanceof Volume.FileChannelVol ? 2 : (this.index instanceof Volume.MappedFileVol && this.phys instanceof Volume.FileChannelVol ? 1 : 0);
        this.lockAllWrite();
        try {
            try {
                File f1del = null;
                File compactedFile = new File((indexFile != null ? indexFile : (f1del = File.createTempFile("mapdb", "compact"))) + ".compact");
                boolean asyncWriteEnabled = this.index instanceof Volume.ByteBufferVol && ((Volume.ByteBufferVol)this.index).asyncWriteEnabled;
                Volume.Factory fab = Volume.fileFactory(compactedFile, rafMode, false, this.sizeLimit, 20, 0, new File(String.valueOf(compactedFile.getPath()) + DATA_FILE_EXT), new File(String.valueOf(compactedFile.getPath()) + ".t"), asyncWriteEnabled);
                StoreDirect store2 = new StoreDirect(fab, false, false, 5, false, 0L, this.checksum, this.compress, this.password, false, 0);
                this.compactPreUnderLock();
                this.index.putLong(16L, this.physSize);
                this.index.putLong(8L, this.indexSize);
                this.index.putLong(24L, this.freeSize);
                store2.lockAllWrite();
                long recid = this.longStackTake(120L, false);
                while (recid != 0L) {
                    store2.longStackPut(120L, recid, false);
                    recid = this.longStackTake(120L, false);
                }
                store2.index.putLong(8L, this.indexSize);
                long ioRecid = 32896L;
                while (ioRecid < this.indexSize) {
                    byte[] bb = this.get2(ioRecid, Serializer.BYTE_ARRAY_NOSIZE);
                    store2.index.ensureAvailable(ioRecid + 8L);
                    if (bb == null || bb.length == 0) {
                        store2.index.putLong(ioRecid, 0L);
                    } else {
                        DataOutput2 out = this.serialize(bb, Serializer.BYTE_ARRAY_NOSIZE);
                        long[] indexVals = store2.physAllocate(out.pos, true, false);
                        store2.put2(out, ioRecid, indexVals);
                    }
                    ioRecid += 8L;
                }
                File indexFile2 = store2.index.getFile();
                File physFile2 = store2.phys.getFile();
                store2.unlockAllWrite();
                boolean useDirectBuffer = this.index instanceof Volume.MemoryVol && ((Volume.MemoryVol)this.index).useDirectBuffer;
                this.index.sync();
                this.index.close();
                this.index = null;
                this.phys.sync();
                this.phys.close();
                this.phys = null;
                if (indexFile != null) {
                    long time = System.currentTimeMillis();
                    File indexFile_ = indexFile != null ? new File(String.valueOf(indexFile.getPath()) + "_" + time + "_orig") : null;
                    File physFile_ = physFile != null ? new File(String.valueOf(physFile.getPath()) + "_" + time + "_orig") : null;
                    store2.close();
                    if (!indexFile.renameTo(indexFile_)) {
                        throw new AssertionError((Object)"could not rename file");
                    }
                    if (!physFile.renameTo(physFile_)) {
                        throw new AssertionError((Object)"could not rename file");
                    }
                    if (!indexFile2.renameTo(indexFile)) {
                        throw new AssertionError((Object)"could not rename file");
                    }
                    if (!physFile2.renameTo(physFile)) {
                        throw new AssertionError((Object)"could not rename file");
                    }
                    Volume.Factory fac2 = Volume.fileFactory(indexFile, rafMode, false, this.sizeLimit, 20, 0, new File(String.valueOf(indexFile.getPath()) + DATA_FILE_EXT), new File(String.valueOf(indexFile.getPath()) + ".t"), asyncWriteEnabled);
                    this.index = fac2.createIndexVolume();
                    this.phys = fac2.createPhysVolume();
                    indexFile_.delete();
                    physFile_.delete();
                } else {
                    Volume.MemoryVol indexVol2 = new Volume.MemoryVol(useDirectBuffer, this.sizeLimit, 20);
                    Volume.volumeTransfer(this.indexSize, store2.index, indexVol2);
                    Volume.MemoryVol physVol2 = new Volume.MemoryVol(useDirectBuffer, this.sizeLimit, 20);
                    Volume.volumeTransfer(store2.physSize, store2.phys, physVol2);
                    File f1 = store2.index.getFile();
                    File f2 = store2.phys.getFile();
                    store2.close();
                    f1.delete();
                    f2.delete();
                    this.index = indexVol2;
                    this.phys = physVol2;
                }
                if (f1del != null) {
                    f1del.delete();
                }
                this.physSize = store2.physSize;
                this.freeSize = store2.freeSize;
                this.index.putLong(16L, this.physSize);
                this.index.putLong(8L, this.indexSize);
                this.index.putLong(24L, this.freeSize);
                this.index.putLong(32L, this.indexHeaderChecksum());
                this.maxUsedIoList = 32888L;
                while (this.index.getLong(this.maxUsedIoList) != 0L && this.maxUsedIoList > 120L) {
                    this.maxUsedIoList -= 8L;
                }
                this.compactPostUnderLock();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        finally {
            this.unlockAllWrite();
        }
    }

    protected void compactPreUnderLock() {
    }

    protected void compactPostUnderLock() {
    }

    protected long longStackTake(long ioList, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        assert (ioList >= 120L && ioList < 32896L) : "wrong ioList: " + ioList;
        long dataOffset = this.index.getLong(ioList);
        if (dataOffset == 0L) {
            return 0L;
        }
        long pos = dataOffset >>> 48;
        dataOffset &= 0xFFFFFFFFFFF0L;
        if (pos < 8L) {
            throw new AssertionError();
        }
        long ret = this.phys.getSixLong(dataOffset + pos);
        if (pos == 8L) {
            long next = this.phys.getLong(dataOffset);
            long size = next >>> 48;
            if ((next &= 0xFFFFFFFFFFF0L) != 0L) {
                long nextSize = this.phys.getUnsignedShort(next);
                assert ((nextSize - 8L) % 6L == 0L);
                this.index.putLong(ioList, nextSize - 6L << 48 | next);
            } else {
                this.index.putLong(ioList, 0L);
                if (this.maxUsedIoList == ioList) {
                    while (this.index.getLong(this.maxUsedIoList) == 0L && this.maxUsedIoList > 120L) {
                        this.maxUsedIoList -= 8L;
                    }
                }
            }
            this.freePhysPut(size << 48 | dataOffset, true);
        } else {
            this.index.putLong(ioList, (pos -= 6L) << 48 | dataOffset);
        }
        return ret;
    }

    protected void longStackPut(long ioList, long offset, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        assert (offset >>> 48 == 0L);
        assert (ioList >= 120L && ioList <= 32896L) : "wrong ioList: " + ioList;
        long dataOffset = this.index.getLong(ioList);
        long pos = dataOffset >>> 48;
        if ((dataOffset &= 0xFFFFFFFFFFF0L) == 0L) {
            long listPhysid = this.freePhysTake(1232, true, true) & 0xFFFFFFFFFFF0L;
            if (listPhysid == 0L) {
                throw new AssertionError();
            }
            this.phys.putLong(listPhysid, 0x4D0000000000000L);
            this.phys.putSixLong(listPhysid + 8L, offset);
            this.index.putLong(ioList, 0x8000000000000L | listPhysid);
            if (this.maxUsedIoList <= ioList) {
                this.maxUsedIoList = ioList;
            }
        } else {
            long next = this.phys.getLong(dataOffset);
            long size = next >>> 48;
            next &= 0xFFFFFFFFFFF0L;
            assert (pos + 6L <= size);
            if (pos + 6L == size) {
                long listPhysid;
                long newPageSize = 1232L;
                if (ioList == StoreDirect.size2ListIoRecid(1232L)) {
                    newPageSize = 1280L;
                }
                if ((listPhysid = this.freePhysTake((int)newPageSize, true, true) & 0xFFFFFFFFFFF0L) == 0L) {
                    throw new AssertionError();
                }
                this.phys.putLong(listPhysid, newPageSize << 48 | dataOffset & 0xFFFFFFFFFFF0L);
                this.phys.putSixLong(listPhysid + 8L, offset);
                this.index.putLong(ioList, 0x8000000000000L | listPhysid);
            } else {
                this.phys.putSixLong(dataOffset + (pos += 6L), offset);
                this.index.putLong(ioList, pos << 48 | dataOffset);
            }
        }
    }

    protected void freeIoRecidPut(long ioRecid) {
        assert (ioRecid > 32896L);
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        if (this.spaceReclaimTrack) {
            this.longStackPut(120L, ioRecid, false);
        }
    }

    protected long freeIoRecidTake(boolean ensureAvail) {
        long ioRecid;
        if (this.spaceReclaimTrack && (ioRecid = this.longStackTake(120L, false)) != 0L) {
            assert (ioRecid > 32896L);
            return ioRecid;
        }
        this.indexSize += 8L;
        if (ensureAvail) {
            this.index.ensureAvailable(this.indexSize);
        }
        assert (this.indexSize - 8L > 32896L);
        return this.indexSize - 8L;
    }

    protected static long size2ListIoRecid(long size) {
        return 128L + (size - 1L) / 16L * 8L;
    }

    protected void freePhysPut(long indexVal, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        long size = indexVal >>> 48;
        assert (size != 0L);
        if (this.physSize == (indexVal &= 0xFFFFFFFFFFF0L) + StoreDirect.roundTo16(size)) {
            this.physSize = indexVal;
            return;
        }
        this.freeSize += StoreDirect.roundTo16(size);
        this.longStackPut(StoreDirect.size2ListIoRecid(size), indexVal, recursive);
    }

    protected long freePhysTake(int size, boolean ensureAvail, boolean recursive) {
        long ret;
        assert (this.structuralLock.isHeldByCurrentThread());
        assert (size > 0);
        if (this.spaceReclaimReuse && (ret = this.longStackTake(StoreDirect.size2ListIoRecid(size), recursive)) != 0L) {
            this.freeSize -= StoreDirect.roundTo16(size);
            return ret;
        }
        if (!recursive && this.spaceReclaimSplit) {
            long s = StoreDirect.roundTo16(size) + 16L;
            while (s < 65535L) {
                long ioList = StoreDirect.size2ListIoRecid(s);
                if (ioList > this.maxUsedIoList) break;
                long ret2 = this.longStackTake(ioList, recursive);
                if (ret2 != 0L) {
                    long offset = ret2 & 0xFFFFFFFFFFF0L;
                    long remaining = s - StoreDirect.roundTo16(size);
                    long markFree = remaining << 48 | offset + s - remaining;
                    this.freePhysPut(markFree, recursive);
                    this.freeSize -= StoreDirect.roundTo16(s);
                    return (long)size << 48 | offset;
                }
                s += 16L;
            }
        }
        if ((this.physSize & 0xFFFFFL) + (long)size > 0x100000L) {
            this.physSize += 0x100000L - (this.physSize & 0xFFFFFL);
        }
        long physSize2 = this.physSize;
        this.physSize = StoreDirect.roundTo16(this.physSize + (long)size);
        if (ensureAvail) {
            this.phys.ensureAvailable(this.physSize);
        }
        return physSize2;
    }

    @Override
    public long getMaxRecid() {
        return (this.indexSize - 32896L) / 8L;
    }

    @Override
    public ByteBuffer getRaw(long recid) {
        byte[] bb = this.get(recid, Serializer.BYTE_ARRAY_NOSIZE);
        if (bb == null) {
            return null;
        }
        return ByteBuffer.wrap(bb);
    }

    @Override
    public Iterator<Long> getFreeRecids() {
        return Fun.EMPTY_ITERATOR;
    }

    @Override
    public void updateRaw(long recid, ByteBuffer data) {
        long ioRecid = recid * 8L + 32896L;
        if (ioRecid >= this.indexSize) {
            this.indexSize = ioRecid + 8L;
            this.index.ensureAvailable(this.indexSize);
        }
        byte[] b = null;
        if (data != null) {
            data = data.duplicate();
            b = new byte[data.remaining()];
            data.get(b);
        }
        this.update(recid, b, Serializer.BYTE_ARRAY_NOSIZE);
    }

    @Override
    public long getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public long getCurrSize() {
        return this.physSize;
    }

    @Override
    public long getFreeSize() {
        return this.freeSize;
    }

    @Override
    public String calculateStatistics() {
        String s = "";
        s = String.valueOf(s) + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "volume: \n";
        s = String.valueOf(s) + "  " + this.phys + "\n";
        s = String.valueOf(s) + "indexSize=" + this.indexSize + "\n";
        s = String.valueOf(s) + "physSize=" + this.physSize + "\n";
        s = String.valueOf(s) + "freeSize=" + this.freeSize + "\n";
        s = String.valueOf(s) + "num of freeRecids: " + this.countLongStackItems(120L) + "\n";
        int size = 16;
        while (size < 65545) {
            long sum = 0L;
            int ss = size / 2;
            while (ss < size) {
                sum += this.countLongStackItems(StoreDirect.size2ListIoRecid(ss)) * (long)ss;
                ss += 16;
            }
            s = String.valueOf(s) + "Size occupied by free records (size=" + size + ") = " + sum;
            size *= 2;
        }
        return s;
    }

    protected long countLongStackItems(long ioList) {
        long ret = 0L;
        long v = this.index.getLong(ioList);
        long next;
        while ((next = v & 0xFFFFFFFFFFF0L) != 0L) {
            ret += v >>> 48;
            v = this.phys.getLong(next);
        }
        return ret;
    }
}

