/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;

public class LongConcurrentHashMap<V>
extends LongMap<V>
implements Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected final long hashSalt = new Random().nextLong();
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<V>[] segments;

    final Segment<V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public LongConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int c;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        int ssize = 1;
        while (ssize < concurrencyLevel) {
            ++sshift;
            ssize <<= 1;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        int cap = 1;
        while (cap < c) {
            cap <<= 1;
        }
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new Segment(cap, loadFactor);
            ++i;
        }
    }

    public LongConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public LongConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    @Override
    public boolean isEmpty() {
        Segment<V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        int i = 0;
        while (i < segments.length) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
            ++i;
        }
        if (mcsum != 0) {
            i = 0;
            while (i < segments.length) {
                if (segments[i].count != 0 || mc[i] != segments[i].modCount) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        int k = 0;
        while (k < 2) {
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            int i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                ++i;
            }
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    check += (long)segments[i].count;
                    if (mc[i] != segments[i].modCount) {
                        check = -1L;
                        break;
                    }
                    ++i;
                }
            }
            if (check == sum) break;
            ++k;
        }
        if (check != sum) {
            sum = 0L;
            Segment<V>[] segmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment<V> segment = segmentArray[n2];
                segment.lock();
                ++n2;
            }
            segmentArray = segments;
            n = segments.length;
            n2 = 0;
            while (n2 < n) {
                Segment<V> segment = segmentArray[n2];
                sum += (long)segment.count;
                ++n2;
            }
            segmentArray = segments;
            n = segments.length;
            n2 = 0;
            while (n2 < n) {
                Segment<V> segment = segmentArray[n2];
                segment.unlock();
                ++n2;
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public Iterator<V> valuesIterator() {
        return new ValueIterator();
    }

    @Override
    public LongMap.LongMapIterator<V> longMapIterator() {
        return new MapIterator();
    }

    @Override
    public V get(long key) {
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(long key) {
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * Unable to fully structure code
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        segments = this.segments;
        mc = new int[segments.length];
        k = 0;
        while (k < 2) {
            mcsum = 0;
            i = 0;
            while (i < segments.length) {
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (segments[i].containsValue(value)) {
                    return true;
                }
                ++i;
            }
            cleanSweep = true;
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    if (mc[i] != segments[i].modCount) {
                        cleanSweep = false;
                        break;
                    }
                    ++i;
                }
            }
            if (cleanSweep) {
                return false;
            }
            ++k;
        }
        var7_12 = segments;
        var6_10 = segments.length;
        mcsum = 0;
        while (mcsum < var6_10) {
            segment = var7_12[mcsum];
            segment.lock();
            ++mcsum;
        }
        found = false;
        try {
            var8_14 = segments;
            var7_13 = segments.length;
            var6_10 = 0;
            while (var6_10 < var7_13) {
                segment = var8_14[var6_10];
                if (segment.containsValue(value)) {
                    found = true;
                }
                ++var6_10;
            }
        }
        finally {
            var13_17 = segments;
            var12_19 = segments.length;
            var11_21 = 0;
            ** while (var11_21 < var12_19)
        }
lbl-1000:
        // 1 sources

        {
            segment = var13_17[var11_21];
            segment.unlock();
            ++var11_21;
            continue;
        }
lbl59:
        // 1 sources

        return found;
    }

    @Override
    public V put(long key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    public V putIfAbsent(long key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public V remove(long key) {
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(long key, Object value) {
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return value != null && this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public boolean replace(long key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    public V replace(long key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = LongHashMap.longHash(key ^ this.hashSalt);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> segment = segmentArray[n2];
            segment.clear();
            ++n2;
        }
    }

    static final class HashEntry<V> {
        final long key;
        final int hash;
        volatile V value;
        final HashEntry<V> next;

        HashEntry(long key, int hash, HashEntry<V> next, V value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        static <V> HashEntry<V>[] newArray(int i) {
            return new HashEntry[i];
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<V>[] currentTable;
        HashEntry<V> nextEntry;
        HashEntry<V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = LongConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        /*
         * Unable to fully structure code
         */
        final void advance() {
            if (this.nextEntry == null || (this.nextEntry = this.nextEntry.next) == null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
lbl5:
                // 2 sources

                ** while (this.nextTableIndex >= 0)
            }
lbl6:
            // 3 sources

            while (this.nextSegmentIndex >= 0) {
                seg = LongConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                j = this.currentTable.length - 1;
                while (j >= 0) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry != null) {
                        this.nextTableIndex = j - 1;
                        return;
                    }
                    --j;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LongConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<Long> {
        KeyIterator() {
        }

        @Override
        public Long next() {
            return super.nextEntry().key;
        }
    }

    final class MapIterator
    extends HashIterator
    implements LongMap.LongMapIterator<V> {
        private long key;
        private V value;

        MapIterator() {
        }

        @Override
        public boolean moveToNext() {
            if (!this.hasNext()) {
                return false;
            }
            HashEntry next = this.nextEntry();
            this.key = next.key;
            this.value = next.value;
            return true;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    static final class Segment<V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<V>[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            super(false);
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static <V> Segment<V>[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(HashEntry<V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry<V> getFirst(int hash) {
            HashEntry<V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        V readValueUnderLock(HashEntry<V> e) {
            this.lock();
            try {
                Object v = e.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(long key, int hash) {
            if (this.count != 0) {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key == e.key) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        boolean containsKey(long key, int hash) {
            if (this.count != 0) {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key == e.key) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                HashEntry<V>[] tab;
                HashEntry<V>[] hashEntryArray = tab = this.table;
                int n = tab.length;
                int n2 = 0;
                while (n2 < n) {
                    HashEntry<V> aTab;
                    HashEntry<V> e = aTab = hashEntryArray[n2];
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                    ++n2;
                }
            }
            return false;
        }

        boolean replace(long key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        V replace(long key, int hash, V newValue) {
            this.lock();
            try {
                HashEntry<V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V put(long key, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                V oldValue;
                HashEntry<V> first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<V> e = first = tab[index];
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry<V>(key, hash, first, value);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry<V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry<V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            HashEntry<V>[] hashEntryArray = oldTable;
            int n = oldTable.length;
            int n2 = 0;
            while (n2 < n) {
                HashEntry<V> e = hashEntryArray[n2];
                if (e != null) {
                    HashEntry next = e.next;
                    int idx = e.hash & sizeMask;
                    if (next == null) {
                        newTable[idx] = e;
                    } else {
                        int k;
                        HashEntry<V> lastRun = e;
                        int lastIdx = idx;
                        HashEntry last = next;
                        while (last != null) {
                            k = last.hash & sizeMask;
                            if (k != lastIdx) {
                                lastIdx = k;
                                lastRun = last;
                            }
                            last = last.next;
                        }
                        newTable[lastIdx] = lastRun;
                        HashEntry<V> p = e;
                        while (p != lastRun) {
                            k = p.hash & sizeMask;
                            HashEntry n3 = newTable[k];
                            newTable[k] = new HashEntry(p.key, p.hash, n3, p.value);
                            p = p.next;
                        }
                    }
                }
                ++n2;
            }
            this.table = newTable;
        }

        V remove(long key, int hash, Object value) {
            this.lock();
            try {
                HashEntry<V> first;
                int c = this.count - 1;
                HashEntry<V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<V> e = first = tab[index];
                while (e != null && (e.hash != hash || key != e.key)) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry<V> p = first;
                        while (p != e) {
                            newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<V>[] tab = this.table;
                    int i = 0;
                    while (i < tab.length) {
                        tab[i] = null;
                        ++i;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }
    }
}

