/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mapdb.SerializerBase;

public final class DataInput2
extends InputStream
implements DataInput {
    public ByteBuffer buf;
    public int pos;

    public DataInput2(ByteBuffer buf, int pos) {
        this.buf = buf;
        this.pos = pos;
    }

    public DataInput2(byte[] b) {
        this(ByteBuffer.wrap(b), 0);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        ByteBuffer clone = this.buf.duplicate();
        clone.position(this.pos);
        this.pos += len;
        clone.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buf.get(this.pos++) == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf.get(this.pos++);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buf.get(this.pos++) & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        short ret = this.buf.getShort(this.pos);
        this.pos += 2;
        return ret;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (this.buf.get(this.pos++) & 0xFF) << 8 | this.buf.get(this.pos++) & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        int ret = this.buf.getInt(this.pos);
        this.pos += 4;
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = this.buf.getLong(this.pos);
        this.pos += 8;
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        float ret = this.buf.getFloat(this.pos);
        this.pos += 4;
        return ret;
    }

    @Override
    public double readDouble() throws IOException {
        double ret = this.buf.getDouble(this.pos);
        this.pos += 8;
        return ret;
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF() throws IOException {
        int size = DataInput2.unpackInt(this);
        return SerializerBase.deserializeString(this, size);
    }

    @Override
    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    public static int unpackInt(DataInput is) throws IOException {
        int offset = 0;
        int result = 0;
        while (offset < 32) {
            int b = is.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw new AssertionError((Object)"Malformed int.");
    }

    public static long unpackLong(DataInput in) throws IOException {
        long result = 0L;
        int offset = 0;
        while (offset < 64) {
            long b = in.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) == 0L) {
                return result;
            }
            offset += 7;
        }
        throw new AssertionError((Object)"Malformed long.");
    }
}

