/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class CompressLZF {
    private static final int HASH_SIZE = 16384;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private int[] cachedHashTable;

    private static int first(byte[] in, int inPos) {
        return in[inPos] << 8 | in[inPos + 1] & 0xFF;
    }

    private static int next(int v, byte[] in, int inPos) {
        return v << 8 | in[inPos + 2] & 0xFF;
    }

    private static int hash(int h) {
        return h * 2777 >> 9 & 0x3FFF;
    }

    public int compress(byte[] in, int inLen, byte[] out, int outPos) {
        int inPos = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] hashTab = this.cachedHashTable;
        int literals = 0;
        ++outPos;
        int future = CompressLZF.first(in, 0);
        while (inPos < inLen - 4) {
            byte p2 = in[inPos + 2];
            future = (future << 8) + (p2 & 0xFF);
            int off = CompressLZF.hash(future);
            int ref = hashTab[off];
            hashTab[off] = inPos;
            if (ref < inPos && ref > 0 && (off = inPos - ref - 1) < 8192 && in[ref + 2] == p2 && in[ref + 1] == (byte)(future >> 8) && in[ref] == (byte)(future >> 16)) {
                int maxLen = inLen - inPos - 2;
                if (maxLen > 264) {
                    maxLen = 264;
                }
                if (literals == 0) {
                    --outPos;
                } else {
                    out[outPos - literals - 1] = (byte)(literals - 1);
                    literals = 0;
                }
                int len = 3;
                while (len < maxLen && in[ref + len] == in[inPos + len]) {
                    ++len;
                }
                if ((len -= 2) < 7) {
                    out[outPos++] = (byte)((off >> 8) + (len << 5));
                } else {
                    out[outPos++] = (byte)((off >> 8) + 224);
                    out[outPos++] = (byte)(len - 7);
                }
                out[outPos++] = (byte)off;
                ++outPos;
                future = CompressLZF.first(in, inPos += len);
                future = CompressLZF.next(future, in, inPos);
                hashTab[CompressLZF.hash((int)future)] = inPos++;
                future = CompressLZF.next(future, in, inPos);
                hashTab[CompressLZF.hash((int)future)] = inPos++;
                continue;
            }
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        while (inPos < inLen) {
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        out[outPos - literals - 1] = (byte)(literals - 1);
        if (literals == 0) {
            --outPos;
        }
        return outPos;
    }

    public void expand(DataInput in, byte[] out, int outPos, int outLen) throws IOException {
        assert (outLen >= 0);
        do {
            int ctrl;
            if ((ctrl = in.readByte() & 0xFF) < 32) {
                in.readFully(out, outPos, ++ctrl);
                outPos += ctrl;
                continue;
            }
            int len = ctrl >> 5;
            if (len == 7) {
                len += in.readByte() & 0xFF;
            }
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            ctrl -= in.readByte() & 0xFF;
            ctrl += outPos;
            if (outPos + (len += 2) >= out.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int i = 0;
            while (i < len) {
                out[outPos++] = out[ctrl++];
                ++i;
            }
        } while (outPos < outLen);
    }

    public void expand(ByteBuffer in, int inPos, byte[] out, int outPos, int outLen) {
        ByteBuffer in2 = null;
        assert (outLen >= 0);
        do {
            int ctrl;
            if ((ctrl = in.get(inPos++) & 0xFF) < 32) {
                ++ctrl;
                if (in2 == null) {
                    in2 = in.duplicate();
                }
                in2.position(inPos);
                in2.get(out, outPos, ctrl);
                outPos += ctrl;
                inPos += ctrl;
                continue;
            }
            int len = ctrl >> 5;
            if (len == 7) {
                len += in.get(inPos++) & 0xFF;
            }
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            ctrl -= in.get(inPos++) & 0xFF;
            ctrl += outPos;
            if (outPos + (len += 2) >= out.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int i = 0;
            while (i < len) {
                out[outPos++] = out[ctrl++];
                ++i;
            }
        } while (outPos < outLen);
    }
}

