/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.Atomic;
import org.mapdb.Fun;

public final class Bind {
    private Bind() {
    }

    public static <K, V> void size(MapWithModificationListener<K, V> map, final Atomic.Long sizeCounter) {
        if (sizeCounter.get() == 0L) {
            long size = map.sizeLong();
            if (sizeCounter.get() != size) {
                sizeCounter.set(size);
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (oldVal == null && newVal != null) {
                    sizeCounter.incrementAndGet();
                } else if (oldVal != null && newVal == null) {
                    sizeCounter.decrementAndGet();
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValue(MapWithModificationListener<K, V> map, final Map<K, V2> secondary, final Fun.Function2<V2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(e.getKey(), fun.run(e.getKey(), e.getValue()));
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(key);
                } else {
                    secondary.put(key, fun.run(key, newVal));
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValues(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K, V2>> secondary, final Fun.Function2<V2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                V2[] v = fun.run(e.getKey(), e.getValue());
                if (v == null) continue;
                V2[] V2Array = v;
                int n = v.length;
                int n2 = 0;
                while (n2 < n) {
                    V2 v2 = V2Array[n2];
                    secondary.add(Fun.t2(e.getKey(), v2));
                    ++n2;
                }
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                block12: {
                    Object v6;
                    block13: {
                        block11: {
                            if (newVal != null) break block11;
                            Object[] v2 = (Object[])fun.run(key, oldVal);
                            if (v2 == null) break block12;
                            Object[] objectArray = v2;
                            int n = v2.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object v22 = objectArray[n2];
                                secondary.remove(Fun.t2(key, v22));
                                ++n2;
                            }
                            break block12;
                        }
                        if (oldVal != null) break block13;
                        Object[] v3 = (Object[])fun.run(key, newVal);
                        if (v3 == null) break block12;
                        Object[] objectArray = v3;
                        int n = v3.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object v2 = objectArray[n3];
                            secondary.add(Fun.t2(key, v2));
                            ++n3;
                        }
                        break block12;
                    }
                    Object[] oldv = (Object[])fun.run(key, oldVal);
                    Object[] newv = (Object[])fun.run(key, newVal);
                    if (oldv == null) {
                        if (newv != null) {
                            Object[] objectArray = newv;
                            int n = newv.length;
                            int n4 = 0;
                            while (n4 < n) {
                                Object v4 = objectArray[n4];
                                secondary.add(Fun.t2(key, v4));
                                ++n4;
                            }
                        }
                        return;
                    }
                    if (newv == null) {
                        Object[] objectArray = oldv;
                        int n = oldv.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Object v5 = objectArray[n5];
                            secondary.remove(Fun.t2(key, v5));
                            ++n5;
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldv);
                    Object[] objectArray = newv;
                    int n = newv.length;
                    int n6 = 0;
                    while (n6 < n) {
                        v6 = objectArray[n6];
                        if (!hashes.contains(v6)) {
                            secondary.add(Fun.t2(key, v6));
                        }
                        ++n6;
                    }
                    objectArray = newv;
                    n = newv.length;
                    n6 = 0;
                    while (n6 < n) {
                        v6 = objectArray[n6];
                        hashes.remove(v6);
                        ++n6;
                    }
                    for (Object v6 : hashes) {
                        secondary.remove(Fun.t2(key, v6));
                    }
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.add(Fun.t2(fun.run(e.getKey(), e.getValue()), e.getKey()));
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(Fun.t2(fun.run(key, oldVal), key));
                } else if (oldVal == null) {
                    secondary.add(Fun.t2(fun.run(key, newVal), key));
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(Fun.t2(oldKey, key));
                    secondary.add(Fun.t2(newKey, key));
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map, final Map<K2, K> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                secondary.put(fun.run(e.getKey(), e.getValue()), e.getKey());
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(fun.run(key, oldVal));
                } else if (oldVal == null) {
                    secondary.put(fun.run(key, newVal), key);
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key, oldVal);
                    if (oldKey == (newKey = fun.run(key, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(oldKey);
                    secondary.put(newKey, key);
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKeys(MapWithModificationListener<K, V> map, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e : map.entrySet()) {
                K2[] k2 = fun.run(e.getKey(), e.getValue());
                if (k2 == null) continue;
                K2[] K2Array = k2;
                int n = k2.length;
                int n2 = 0;
                while (n2 < n) {
                    K2 k22 = K2Array[n2];
                    secondary.add(Fun.t2(k22, e.getKey()));
                    ++n2;
                }
            }
        }
        map.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                block12: {
                    Object k24;
                    block13: {
                        block11: {
                            if (newVal != null) break block11;
                            Object[] k22 = (Object[])fun.run(key, oldVal);
                            if (k22 == null) break block12;
                            Object[] objectArray = k22;
                            int n = k22.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object k222 = objectArray[n2];
                                secondary.remove(Fun.t2(k222, key));
                                ++n2;
                            }
                            break block12;
                        }
                        if (oldVal != null) break block13;
                        Object[] k23 = (Object[])fun.run(key, newVal);
                        if (k23 == null) break block12;
                        Object[] objectArray = k23;
                        int n = k23.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object k22 = objectArray[n3];
                            secondary.add(Fun.t2(k22, key));
                            ++n3;
                        }
                        break block12;
                    }
                    Object[] oldk = (Object[])fun.run(key, oldVal);
                    Object[] newk = (Object[])fun.run(key, newVal);
                    if (oldk == null) {
                        if (newk != null) {
                            Object[] objectArray = newk;
                            int n = newk.length;
                            int n4 = 0;
                            while (n4 < n) {
                                Object k22 = objectArray[n4];
                                secondary.add(Fun.t2(k22, key));
                                ++n4;
                            }
                        }
                        return;
                    }
                    if (newk == null) {
                        Object[] objectArray = oldk;
                        int n = oldk.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Object k22 = objectArray[n5];
                            secondary.remove(Fun.t2(k22, key));
                            ++n5;
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldk);
                    Object[] objectArray = newk;
                    int n = newk.length;
                    int n6 = 0;
                    while (n6 < n) {
                        k24 = objectArray[n6];
                        if (!hashes.contains(k24)) {
                            secondary.add(Fun.t2(k24, key));
                        }
                        ++n6;
                    }
                    objectArray = newk;
                    n = newk.length;
                    n6 = 0;
                    while (n6 < n) {
                        k24 = objectArray[n6];
                        hashes.remove(k24);
                        ++n6;
                    }
                    for (Object k24 : hashes) {
                        secondary.remove(Fun.t2(k24, key));
                    }
                }
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Set<Fun.Tuple2<V, K>> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Map<V, K> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key, V value) {
                return value;
            }
        });
    }

    public static <K, V, C> void histogram(MapWithModificationListener<K, V> primary, final ConcurrentMap<C, Long> histogram, final Fun.Function2<C, K, V> entryToCategory) {
        MapListener listener = new MapListener<K, V>(){

            @Override
            public void update(K key, V oldVal, V newVal) {
                if (newVal == null) {
                    Object category = entryToCategory.run(key, oldVal);
                    this.incrementHistogram(category, -1L);
                } else if (oldVal == null) {
                    Object category = entryToCategory.run(key, newVal);
                    this.incrementHistogram(category, 1L);
                } else {
                    Object newCat;
                    Object oldCat = entryToCategory.run(key, oldVal);
                    if (oldCat == (newCat = entryToCategory.run(key, newVal)) || oldCat.equals(newCat)) {
                        return;
                    }
                    this.incrementHistogram(oldCat, -1L);
                    this.incrementHistogram(oldCat, 1L);
                }
            }

            private void incrementHistogram(C category, long i) {
                Long newCount;
                Long oldCount;
                while (!((oldCount = (Long)histogram.get(category)) == null ? histogram.putIfAbsent(category, i) == null : histogram.replace(category, oldCount, newCount = Long.valueOf(oldCount + i)))) {
                }
            }
        };
        primary.modificationListenerAdd(listener);
        if (histogram.isEmpty()) {
            for (Map.Entry e : primary.entrySet()) {
                listener.update(e.getKey(), null, e.getValue());
            }
        }
    }

    public static interface MapListener<K, V> {
        public void update(K var1, V var2, V var3);
    }

    public static interface MapWithModificationListener<K, V>
    extends Map<K, V> {
        public void modificationListenerAdd(MapListener<K, V> var1);

        public void modificationListenerRemove(MapListener<K, V> var1);

        public long sizeLong();
    }
}

