﻿using System.Text.Encodings.Web;
using System.Threading.Tasks;
using Fluid;

namespace Elsa.Scripting.Liquid.Services
{
    /// <summary>
    /// Provides services to render Liquid templates.
    /// </summary>
    public interface ILiquidTemplateManager
    {
        /// <summary>
        /// Renders a Liquid template as a <see cref="string"/>.
        /// </summary>
        Task<string?> RenderAsync(string template, TemplateContext context, TextEncoder encoder);

        /// <summary>
        /// Validates a Liquid template.
        /// </summary>
        bool Validate(string template, out string error);
    }
}
