using System;
using Elsa.Activities.Http.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;

namespace Elsa.Activities.Http.Options
{
    public class HttpActivityOptions
    {
        /// <summary>
        /// The base URL of the server. This should be set to the same value at which the Elsa Server is publicly available. It will be used when generating absolute URLs need to be generated by activities such as SendEmail. 
        /// </summary>
        public Uri BaseUrl { get; set; } = default!;

        /// <summary>
        /// The root path at which HTTP activities can be invoked.
        /// </summary>
        public PathString? BasePath { get; set; }

        public Func<IServiceProvider, IHttpEndpointAuthorizationHandler> HttpEndpointAuthorizationHandlerFactory { get; set; } = ActivatorUtilities.GetServiceOrCreateInstance<AuthenticationBasedHttpEndpointAuthorizationHandler>;
    }
}