/**
 * Generated by orval v7.13.2 🍺
 * Do not edit manually.
 * Prefect Prefect REST API
 * OpenAPI spec version: 0.1.0
 */
import * as zod from "zod";

/**
 * Record a batch of Events.

For more information, see https://docs.prefect.io/v3/concepts/events.
 * @summary Create Events
 */
export const createEventsEventsPostHeader = zod.object({
	"x-prefect-api-version": zod.string().optional(),
});

export const createEventsEventsPostBodyItem = zod
	.object({
		occurred: zod
			.string()
			.datetime({})
			.describe("When the event happened from the sender's perspective"),
		event: zod.string().describe("The name of the event that happened"),
		resource: zod
			.record(zod.string(), zod.string())
			.describe("An observable business object of interest to the user"),
		related: zod
			.array(
				zod
					.record(zod.string(), zod.string())
					.describe("A Resource with a specific role in an Event"),
			)
			.optional()
			.describe("A list of additional Resources involved in this event"),
		payload: zod
			.record(zod.string(), zod.any())
			.optional()
			.describe("An open-ended set of data describing what happened"),
		id: zod
			.string()
			.uuid()
			.describe("The client-provided identifier of this event"),
		follows: zod
			.union([zod.string().uuid(), zod.null()])
			.optional()
			.describe(
				"The ID of an event that is known to have occurred prior to this one. If set, this may be used to establish a more precise ordering of causally-related events when they occur close enough together in time that the system may receive them out-of-order.",
			),
	})
	.describe("The client-side view of an event that has happened to a Resource");
export const createEventsEventsPostBody = zod.array(
	createEventsEventsPostBodyItem,
);

/**
 * Queries for Events matching the given filter criteria in the given Account.  Returns
the first page of results, and the URL to request the next page (if there are more
results).
 * @summary Read Events
 */
export const readEventsEventsFilterPostHeader = zod.object({
	"x-prefect-api-version": zod.string().optional(),
});

export const readEventsEventsFilterPostBodyFilterResourceDistinctDefault = false;
export const readEventsEventsFilterPostBodyFilterTextQueryMax = 200;
export const readEventsEventsFilterPostBodyLimitDefault = 50;
export const readEventsEventsFilterPostBodyLimitMin = 0;
export const readEventsEventsFilterPostBodyLimitMax = 50;

export const readEventsEventsFilterPostBody = zod.object({
	filter: zod
		.union([
			zod.object({
				occurred: zod
					.object({
						since: zod
							.string()
							.datetime({})
							.optional()
							.describe("Only include events after this time (inclusive)"),
						until: zod
							.string()
							.datetime({})
							.optional()
							.describe("Only include events prior to this time (inclusive)"),
					})
					.optional(),
				event: zod
					.union([
						zod.object({
							prefix: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe("Only include events matching one of these prefixes"),
							exclude_prefix: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe("Exclude events matching one of these prefixes"),
							name: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe(
									"Only include events matching one of these names exactly",
								),
							exclude_name: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe("Exclude events matching one of these names exactly"),
						}),
						zod.null(),
					])
					.optional()
					.describe("Filter criteria for the event name"),
				resource: zod
					.union([
						zod.object({
							id: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe("Only include events for resources with these IDs"),
							id_prefix: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe(
									"Only include events for resources with IDs starting with these prefixes.",
								),
							labels: zod
								.union([
									zod.record(
										zod.string(),
										zod.union([zod.string(), zod.array(zod.string())]),
									),
									zod.null(),
								])
								.optional()
								.describe(
									"Only include events for resources with these labels",
								),
							distinct: zod
								.boolean()
								.optional()
								.describe("Only include events for distinct resources"),
						}),
						zod.null(),
					])
					.optional()
					.describe("Filter criteria for the resource of the event"),
				related: zod
					.union([
						zod.object({
							id: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe(
									"Only include events for related resources with these IDs",
								),
							role: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe(
									"Only include events for related resources in these roles",
								),
							resources_in_roles: zod
								.union([
									zod.array(zod.tuple([zod.string(), zod.string()])),
									zod.null(),
								])
								.optional()
								.describe(
									"Only include events with specific related resources in specific roles",
								),
							labels: zod
								.union([
									zod.record(
										zod.string(),
										zod.union([zod.string(), zod.array(zod.string())]),
									),
									zod.null(),
								])
								.optional()
								.describe(
									"Only include events for related resources with these labels",
								),
						}),
						zod.array(
							zod.object({
								id: zod
									.union([zod.array(zod.string()), zod.null()])
									.optional()
									.describe(
										"Only include events for related resources with these IDs",
									),
								role: zod
									.union([zod.array(zod.string()), zod.null()])
									.optional()
									.describe(
										"Only include events for related resources in these roles",
									),
								resources_in_roles: zod
									.union([
										zod.array(zod.tuple([zod.string(), zod.string()])),
										zod.null(),
									])
									.optional()
									.describe(
										"Only include events with specific related resources in specific roles",
									),
								labels: zod
									.union([
										zod.record(
											zod.string(),
											zod.union([zod.string(), zod.array(zod.string())]),
										),
										zod.null(),
									])
									.optional()
									.describe(
										"Only include events for related resources with these labels",
									),
							}),
						),
						zod.null(),
					])
					.optional()
					.describe("Filter criteria for the related resources of the event"),
				any_resource: zod
					.union([
						zod.object({
							id: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe("Only include events for resources with these IDs"),
							id_prefix: zod
								.union([zod.array(zod.string()), zod.null()])
								.optional()
								.describe(
									"Only include events for resources with IDs starting with these prefixes",
								),
							labels: zod
								.union([
									zod.record(
										zod.string(),
										zod.union([zod.string(), zod.array(zod.string())]),
									),
									zod.null(),
								])
								.optional()
								.describe(
									"Only include events for related resources with these labels",
								),
						}),
						zod.array(
							zod.object({
								id: zod
									.union([zod.array(zod.string()), zod.null()])
									.optional()
									.describe("Only include events for resources with these IDs"),
								id_prefix: zod
									.union([zod.array(zod.string()), zod.null()])
									.optional()
									.describe(
										"Only include events for resources with IDs starting with these prefixes",
									),
								labels: zod
									.union([
										zod.record(
											zod.string(),
											zod.union([zod.string(), zod.array(zod.string())]),
										),
										zod.null(),
									])
									.optional()
									.describe(
										"Only include events for related resources with these labels",
									),
							}),
						),
						zod.null(),
					])
					.optional()
					.describe("Filter criteria for any resource involved in the event"),
				id: zod
					.object({
						id: zod
							.union([zod.array(zod.string().uuid()), zod.null()])
							.optional()
							.describe("Only include events with one of these IDs"),
					})
					.optional(),
				text: zod
					.union([
						zod
							.object({
								query: zod
									.string()
									.max(readEventsEventsFilterPostBodyFilterTextQueryMax)
									.describe("Text search query string"),
							})
							.describe("Filter by text search across event content."),
						zod.null(),
					])
					.optional()
					.describe("Filter criteria for text search across event content"),
				order: zod.enum(["ASC", "DESC"]).optional(),
			}),
			zod.null(),
		])
		.optional()
		.describe(
			"Additional optional filter criteria to narrow down the set of Events",
		),
	limit: zod
		.number()
		.min(readEventsEventsFilterPostBodyLimitMin)
		.max(readEventsEventsFilterPostBodyLimitMax)
		.default(readEventsEventsFilterPostBodyLimitDefault)
		.describe("The number of events to return with each page"),
});

export const readEventsEventsFilterPostResponse = zod
	.object({
		events: zod
			.array(
				zod
					.object({
						occurred: zod
							.string()
							.datetime({})
							.describe(
								"When the event happened from the sender's perspective",
							),
						event: zod.string().describe("The name of the event that happened"),
						resource: zod
							.record(zod.string(), zod.string())
							.describe(
								"An observable business object of interest to the user",
							),
						related: zod
							.array(
								zod
									.record(zod.string(), zod.string())
									.describe("A Resource with a specific role in an Event"),
							)
							.optional()
							.describe(
								"A list of additional Resources involved in this event",
							),
						payload: zod
							.record(zod.string(), zod.any())
							.optional()
							.describe("An open-ended set of data describing what happened"),
						id: zod
							.string()
							.uuid()
							.describe("The client-provided identifier of this event"),
						follows: zod
							.union([zod.string().uuid(), zod.null()])
							.optional()
							.describe(
								"The ID of an event that is known to have occurred prior to this one. If set, this may be used to establish a more precise ordering of causally-related events when they occur close enough together in time that the system may receive them out-of-order.",
							),
						received: zod
							.string()
							.datetime({})
							.optional()
							.describe("When the event was received by Prefect Cloud"),
					})
					.describe(
						"The server-side view of an event that has happened to a Resource after it has\nbeen received by the server",
					),
			)
			.describe("The Events matching the query"),
		total: zod.number().describe("The total number of matching Events"),
		next_page: zod
			.union([zod.string().url().min(1), zod.null()])
			.describe("The URL for the next page of results, if there are more"),
	})
	.describe(
		"A single page of events returned from the API, with an optional link to the\nnext page of results",
	);

/**
 * Returns the next page of Events for a previous query against the given Account, and
the URL to request the next page (if there are more results).
 * @summary Read Account Events Page
 */
export const readAccountEventsPageEventsFilterNextGetQueryParams = zod.object({
	"page-token": zod.string(),
});

export const readAccountEventsPageEventsFilterNextGetHeader = zod.object({
	"x-prefect-api-version": zod.string().optional(),
});

export const readAccountEventsPageEventsFilterNextGetResponse = zod
	.object({
		events: zod
			.array(
				zod
					.object({
						occurred: zod
							.string()
							.datetime({})
							.describe(
								"When the event happened from the sender's perspective",
							),
						event: zod.string().describe("The name of the event that happened"),
						resource: zod
							.record(zod.string(), zod.string())
							.describe(
								"An observable business object of interest to the user",
							),
						related: zod
							.array(
								zod
									.record(zod.string(), zod.string())
									.describe("A Resource with a specific role in an Event"),
							)
							.optional()
							.describe(
								"A list of additional Resources involved in this event",
							),
						payload: zod
							.record(zod.string(), zod.any())
							.optional()
							.describe("An open-ended set of data describing what happened"),
						id: zod
							.string()
							.uuid()
							.describe("The client-provided identifier of this event"),
						follows: zod
							.union([zod.string().uuid(), zod.null()])
							.optional()
							.describe(
								"The ID of an event that is known to have occurred prior to this one. If set, this may be used to establish a more precise ordering of causally-related events when they occur close enough together in time that the system may receive them out-of-order.",
							),
						received: zod
							.string()
							.datetime({})
							.optional()
							.describe("When the event was received by Prefect Cloud"),
					})
					.describe(
						"The server-side view of an event that has happened to a Resource after it has\nbeen received by the server",
					),
			)
			.describe("The Events matching the query"),
		total: zod.number().describe("The total number of matching Events"),
		next_page: zod
			.union([zod.string().url().min(1), zod.null()])
			.describe("The URL for the next page of results, if there are more"),
	})
	.describe(
		"A single page of events returned from the API, with an optional link to the\nnext page of results",
	);

/**
 * Returns distinct objects and the count of events associated with them.  Objects
that can be counted include the day the event occurred, the type of event, or
the IDs of the resources associated with the event.
 * @summary Count Account Events
 */
export const countAccountEventsEventsCountByCountablePostParams = zod.object({
	countable: zod.enum(["day", "time", "event", "resource"]),
});

export const countAccountEventsEventsCountByCountablePostHeader = zod.object({
	"x-prefect-api-version": zod.string().optional(),
});

export const countAccountEventsEventsCountByCountablePostBodyFilterResourceDistinctDefault = false;
export const countAccountEventsEventsCountByCountablePostBodyFilterTextQueryMax = 200;
export const countAccountEventsEventsCountByCountablePostBodyTimeIntervalDefault = 1;
export const countAccountEventsEventsCountByCountablePostBodyTimeIntervalMin = 0.01;

export const countAccountEventsEventsCountByCountablePostBody = zod.object({
	filter: zod.object({
		occurred: zod
			.object({
				since: zod
					.string()
					.datetime({})
					.optional()
					.describe("Only include events after this time (inclusive)"),
				until: zod
					.string()
					.datetime({})
					.optional()
					.describe("Only include events prior to this time (inclusive)"),
			})
			.optional(),
		event: zod
			.union([
				zod.object({
					prefix: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe("Only include events matching one of these prefixes"),
					exclude_prefix: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe("Exclude events matching one of these prefixes"),
					name: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe(
							"Only include events matching one of these names exactly",
						),
					exclude_name: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe("Exclude events matching one of these names exactly"),
				}),
				zod.null(),
			])
			.optional()
			.describe("Filter criteria for the event name"),
		resource: zod
			.union([
				zod.object({
					id: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe("Only include events for resources with these IDs"),
					id_prefix: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe(
							"Only include events for resources with IDs starting with these prefixes.",
						),
					labels: zod
						.union([
							zod.record(
								zod.string(),
								zod.union([zod.string(), zod.array(zod.string())]),
							),
							zod.null(),
						])
						.optional()
						.describe("Only include events for resources with these labels"),
					distinct: zod
						.boolean()
						.optional()
						.describe("Only include events for distinct resources"),
				}),
				zod.null(),
			])
			.optional()
			.describe("Filter criteria for the resource of the event"),
		related: zod
			.union([
				zod.object({
					id: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe(
							"Only include events for related resources with these IDs",
						),
					role: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe(
							"Only include events for related resources in these roles",
						),
					resources_in_roles: zod
						.union([
							zod.array(zod.tuple([zod.string(), zod.string()])),
							zod.null(),
						])
						.optional()
						.describe(
							"Only include events with specific related resources in specific roles",
						),
					labels: zod
						.union([
							zod.record(
								zod.string(),
								zod.union([zod.string(), zod.array(zod.string())]),
							),
							zod.null(),
						])
						.optional()
						.describe(
							"Only include events for related resources with these labels",
						),
				}),
				zod.array(
					zod.object({
						id: zod
							.union([zod.array(zod.string()), zod.null()])
							.optional()
							.describe(
								"Only include events for related resources with these IDs",
							),
						role: zod
							.union([zod.array(zod.string()), zod.null()])
							.optional()
							.describe(
								"Only include events for related resources in these roles",
							),
						resources_in_roles: zod
							.union([
								zod.array(zod.tuple([zod.string(), zod.string()])),
								zod.null(),
							])
							.optional()
							.describe(
								"Only include events with specific related resources in specific roles",
							),
						labels: zod
							.union([
								zod.record(
									zod.string(),
									zod.union([zod.string(), zod.array(zod.string())]),
								),
								zod.null(),
							])
							.optional()
							.describe(
								"Only include events for related resources with these labels",
							),
					}),
				),
				zod.null(),
			])
			.optional()
			.describe("Filter criteria for the related resources of the event"),
		any_resource: zod
			.union([
				zod.object({
					id: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe("Only include events for resources with these IDs"),
					id_prefix: zod
						.union([zod.array(zod.string()), zod.null()])
						.optional()
						.describe(
							"Only include events for resources with IDs starting with these prefixes",
						),
					labels: zod
						.union([
							zod.record(
								zod.string(),
								zod.union([zod.string(), zod.array(zod.string())]),
							),
							zod.null(),
						])
						.optional()
						.describe(
							"Only include events for related resources with these labels",
						),
				}),
				zod.array(
					zod.object({
						id: zod
							.union([zod.array(zod.string()), zod.null()])
							.optional()
							.describe("Only include events for resources with these IDs"),
						id_prefix: zod
							.union([zod.array(zod.string()), zod.null()])
							.optional()
							.describe(
								"Only include events for resources with IDs starting with these prefixes",
							),
						labels: zod
							.union([
								zod.record(
									zod.string(),
									zod.union([zod.string(), zod.array(zod.string())]),
								),
								zod.null(),
							])
							.optional()
							.describe(
								"Only include events for related resources with these labels",
							),
					}),
				),
				zod.null(),
			])
			.optional()
			.describe("Filter criteria for any resource involved in the event"),
		id: zod
			.object({
				id: zod
					.union([zod.array(zod.string().uuid()), zod.null()])
					.optional()
					.describe("Only include events with one of these IDs"),
			})
			.optional(),
		text: zod
			.union([
				zod
					.object({
						query: zod
							.string()
							.max(
								countAccountEventsEventsCountByCountablePostBodyFilterTextQueryMax,
							)
							.describe("Text search query string"),
					})
					.describe("Filter by text search across event content."),
				zod.null(),
			])
			.optional()
			.describe("Filter criteria for text search across event content"),
		order: zod.enum(["ASC", "DESC"]).optional(),
	}),
	time_unit: zod.enum(["week", "day", "hour", "minute", "second"]).optional(),
	time_interval: zod
		.number()
		.min(countAccountEventsEventsCountByCountablePostBodyTimeIntervalMin)
		.default(
			countAccountEventsEventsCountByCountablePostBodyTimeIntervalDefault,
		),
});

export const countAccountEventsEventsCountByCountablePostResponseItem = zod
	.object({
		value: zod.string().describe("The value to use for filtering"),
		label: zod.string().describe("The value to display for this count"),
		count: zod.number().describe("The count of matching events"),
		start_time: zod
			.string()
			.datetime({})
			.describe("The start time of this group of events"),
		end_time: zod
			.string()
			.datetime({})
			.describe("The end time of this group of events"),
	})
	.describe("The count of events with the given filter value");
export const countAccountEventsEventsCountByCountablePostResponse = zod.array(
	countAccountEventsEventsCountByCountablePostResponseItem,
);
