import createClient, { type Middleware } from "openapi-fetch";
import type { paths } from "./prefect.ts"; // generated by openapi-typescript

const BASE_URL = import.meta.env.VITE_API_URL;

const throwOnError: Middleware = {
	async onResponse({ response }) {
		if (!response.ok) {
			const body = (await response.clone().json()) as Record<string, unknown>;
			throw new Error(body.detail as string | undefined);
		}
	},
};

let client: ReturnType<typeof createClient<paths>> | null = null;

export const getQueryService = () => {
	if (!BASE_URL) {
		throw new Error("'VITE_API_URL' not configured");
	}
	if (!client) {
		client = createClient<paths>({
			baseUrl: BASE_URL,
		});
		client.use(throwOnError);
	}
	return client;
};
