/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
    "/health": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Health Check */
        get: operations["health_check_health_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/version": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Server Version */
        get: operations["server_version_version_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flows/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Flow
         * @description Creates a new flow from the provided schema. If a flow with the
         *     same name already exists, the existing flow is returned.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/flows.
         */
        post: operations["create_flow_flows__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flows/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow
         * @description Get a flow by id.
         */
        get: operations["read_flow_flows__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Flow
         * @description Delete a flow by id.
         */
        delete: operations["delete_flow_flows__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Flow
         * @description Updates a flow.
         */
        patch: operations["update_flow_flows__id__patch"];
        trace?: never;
    };
    "/flows/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Flows
         * @description Count flows.
         */
        post: operations["count_flows_flows_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flows/name/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow By Name
         * @description Get a flow by name.
         */
        get: operations["read_flow_by_name_flows_name__name__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flows/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Flows
         * @description Query for flows.
         */
        post: operations["read_flows_flows_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flows/paginate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Paginate Flows
         * @description Pagination query for flows.
         */
        post: operations["paginate_flows_flows_paginate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Flow Run
         * @description Create a flow run. If a flow run with the same flow_id and
         *     idempotency key already exists, the existing flow run will be returned.
         *
         *     If no state is provided, the flow run will be created in a PENDING state.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/flows.
         */
        post: operations["create_flow_run_flow_runs__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run
         * @description Get a flow run by id.
         */
        get: operations["read_flow_run_flow_runs__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Flow Run
         * @description Delete a flow run by id.
         */
        delete: operations["delete_flow_run_flow_runs__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Flow Run
         * @description Updates a flow run.
         */
        patch: operations["update_flow_run_flow_runs__id__patch"];
        trace?: never;
    };
    "/flow_runs/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Flow Runs
         * @description Query for flow runs.
         */
        post: operations["count_flow_runs_flow_runs_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/lateness": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Average Flow Run Lateness
         * @description Query for average flow-run lateness in seconds.
         */
        post: operations["average_flow_run_lateness_flow_runs_lateness_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/history": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Flow Run History
         * @description Query for flow run history data across a given range and interval.
         */
        post: operations["flow_run_history_flow_runs_history_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/graph": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run Graph V1
         * @description Get a task run dependency map for a given flow run.
         */
        get: operations["read_flow_run_graph_v1_flow_runs__id__graph_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/graph-v2": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run Graph V2
         * @description Get a graph of the tasks and subflow runs for the given flow run
         */
        get: operations["read_flow_run_graph_v2_flow_runs__id__graph_v2_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/resume": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Resume Flow Run
         * @description Resume a paused flow run.
         */
        post: operations["resume_flow_run_flow_runs__id__resume_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Flow Runs
         * @description Query for flow runs.
         */
        post: operations["read_flow_runs_flow_runs_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/set_state": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Set Flow Run State
         * @description Set a flow run state, invoking any orchestration rules.
         */
        post: operations["set_flow_run_state_flow_runs__id__set_state_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/input": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Flow Run Input
         * @description Create a key/value input for a flow run.
         */
        post: operations["create_flow_run_input_flow_runs__id__input_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/input/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Filter Flow Run Input
         * @description Filter flow run inputs by key prefix
         */
        post: operations["filter_flow_run_input_flow_runs__id__input_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/input/{key}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run Input
         * @description Create a value from a flow run input
         */
        get: operations["read_flow_run_input_flow_runs__id__input__key__get"];
        put?: never;
        post?: never;
        /**
         * Delete Flow Run Input
         * @description Delete a flow run input
         */
        delete: operations["delete_flow_run_input_flow_runs__id__input__key__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/paginate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Paginate Flow Runs
         * @description Pagination query for flow runs.
         */
        post: operations["paginate_flow_runs_flow_runs_paginate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/logs/download": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Download Logs
         * @description Download all flow run logs as a CSV file, collecting all logs until there are no more logs to retrieve.
         */
        get: operations["download_logs_flow_runs__id__logs_download_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_runs/{id}/labels": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        /**
         * Update Flow Run Labels
         * @description Update the labels of a flow run.
         */
        patch: operations["update_flow_run_labels_flow_runs__id__labels_patch"];
        trace?: never;
    };
    "/task_runs/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Task Run
         * @description Create a task run. If a task run with the same flow_run_id,
         *     task_key, and dynamic_key already exists, the existing task
         *     run will be returned.
         *
         *     If no state is provided, the task run will be created in a PENDING state.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/tasks.
         */
        post: operations["create_task_run_task_runs__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_runs/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Task Run
         * @description Get a task run by id.
         */
        get: operations["read_task_run_task_runs__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Task Run
         * @description Delete a task run by id.
         */
        delete: operations["delete_task_run_task_runs__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Task Run
         * @description Updates a task run.
         */
        patch: operations["update_task_run_task_runs__id__patch"];
        trace?: never;
    };
    "/task_runs/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Task Runs
         * @description Count task runs.
         */
        post: operations["count_task_runs_task_runs_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_runs/history": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Task Run History
         * @description Query for task run history data across a given range and interval.
         */
        post: operations["task_run_history_task_runs_history_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_runs/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Task Runs
         * @description Query for task runs.
         */
        post: operations["read_task_runs_task_runs_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_runs/paginate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Paginate Task Runs
         * @description Pagination query for task runs.
         */
        post: operations["paginate_task_runs_task_runs_paginate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_runs/{id}/set_state": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Set Task Run State
         * @description Set a task run state, invoking any orchestration rules.
         */
        post: operations["set_task_run_state_task_runs__id__set_state_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_run_states/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run State
         * @description Get a flow run state by id.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/flows#final-state-determination.
         */
        get: operations["read_flow_run_state_flow_run_states__id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/flow_run_states/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Flow Run States
         * @description Get states associated with a flow run.
         */
        get: operations["read_flow_run_states_flow_run_states__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_run_states/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Task Run State
         * @description Get a task run state by id.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/tasks.
         */
        get: operations["read_task_run_state_task_run_states__id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_run_states/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Task Run States
         * @description Get states associated with a task run.
         */
        get: operations["read_task_run_states_task_run_states__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Deployment
         * @description Creates a new deployment from the provided schema. If a deployment with
         *     the same name and flow_id already exists, the deployment is updated.
         *
         *     If the deployment has an active schedule, flow runs will be scheduled.
         *     When upserting, any scheduled runs from the existing deployment will be deleted.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/deployments.
         */
        post: operations["create_deployment_deployments__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Deployment
         * @description Get a deployment by id.
         */
        get: operations["read_deployment_deployments__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Deployment
         * @description Delete a deployment by id.
         */
        delete: operations["delete_deployment_deployments__id__delete"];
        options?: never;
        head?: never;
        /** Update Deployment */
        patch: operations["update_deployment_deployments__id__patch"];
        trace?: never;
    };
    "/deployments/name/{flow_name}/{deployment_name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Deployment By Name
         * @description Get a deployment using the name of the flow and the deployment.
         */
        get: operations["read_deployment_by_name_deployments_name__flow_name___deployment_name__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Deployments
         * @description Query for deployments.
         */
        post: operations["read_deployments_deployments_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/paginate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Paginate Deployments
         * @description Pagination query for flow runs.
         */
        post: operations["paginate_deployments_deployments_paginate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/get_scheduled_flow_runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Get Scheduled Flow Runs For Deployments
         * @description Get scheduled runs for a set of deployments. Used by a runner to poll for work.
         */
        post: operations["get_scheduled_flow_runs_for_deployments_deployments_get_scheduled_flow_runs_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Deployments
         * @description Count deployments.
         */
        post: operations["count_deployments_deployments_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/schedule": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Schedule Deployment
         * @description Schedule runs for a deployment. For backfills, provide start/end times in the past.
         *
         *     This function will generate the minimum number of runs that satisfy the min
         *     and max times, and the min and max counts. Specifically, the following order
         *     will be respected.
         *
         *         - Runs will be generated starting on or after the `start_time`
         *         - No more than `max_runs` runs will be generated
         *         - No runs will be generated after `end_time` is reached
         *         - At least `min_runs` runs will be generated
         *         - Runs will be generated until at least `start_time + min_time` is reached
         */
        post: operations["schedule_deployment_deployments__id__schedule_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/resume_deployment": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Resume Deployment
         * @description Set a deployment schedule to active. Runs will be scheduled immediately.
         */
        post: operations["resume_deployment_deployments__id__resume_deployment_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/pause_deployment": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Pause Deployment
         * @description Set a deployment schedule to inactive. Any auto-scheduled runs still in a Scheduled
         *     state will be deleted.
         */
        post: operations["pause_deployment_deployments__id__pause_deployment_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/create_flow_run": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Flow Run From Deployment
         * @description Create a flow run from a deployment.
         *
         *     Any parameters not provided will be inferred from the deployment's parameters.
         *     If tags are not provided, the deployment's tags will be used.
         *
         *     If no state is provided, the flow run will be created in a SCHEDULED state.
         */
        post: operations["create_flow_run_from_deployment_deployments__id__create_flow_run_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/work_queue_check": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Work Queue Check For Deployment
         * @deprecated
         * @description Get list of work-queues that are able to pick up the specified deployment.
         *
         *     This endpoint is intended to be used by the UI to provide users warnings
         *     about deployments that are unable to be executed because there are no work
         *     queues that will pick up their runs, based on existing filter criteria. It
         *     may be deprecated in the future because there is not a strict relationship
         *     between work queues and deployments.
         */
        get: operations["work_queue_check_for_deployment_deployments__id__work_queue_check_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/schedules": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Deployment Schedules */
        get: operations["read_deployment_schedules_deployments__id__schedules_get"];
        put?: never;
        /** Create Deployment Schedules */
        post: operations["create_deployment_schedules_deployments__id__schedules_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/deployments/{id}/schedules/{schedule_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        /** Delete Deployment Schedule */
        delete: operations["delete_deployment_schedule_deployments__id__schedules__schedule_id__delete"];
        options?: never;
        head?: never;
        /** Update Deployment Schedule */
        patch: operations["update_deployment_schedule_deployments__id__schedules__schedule_id__patch"];
        trace?: never;
    };
    "/saved_searches/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        /**
         * Create Saved Search
         * @description Creates a new saved search from the provided schema.
         *
         *     If a saved search with the same name already exists, the saved search's fields are
         *     replaced.
         */
        put: operations["create_saved_search_saved_searches__put"];
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/saved_searches/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Saved Search
         * @description Get a saved search by id.
         */
        get: operations["read_saved_search_saved_searches__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Saved Search
         * @description Delete a saved search by id.
         */
        delete: operations["delete_saved_search_saved_searches__id__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/saved_searches/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Saved Searches
         * @description Query for saved searches.
         */
        post: operations["read_saved_searches_saved_searches_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/logs/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Logs
         * @description Create new logs from the provided schema.
         *
         *     For more information, see https://docs.prefect.io/v3/how-to-guides/workflows/add-logging.
         */
        post: operations["create_logs_logs__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/logs/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Logs
         * @description Query for logs.
         */
        post: operations["read_logs_logs_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Concurrency Limit
         * @description Create a task run concurrency limit.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/tag-based-concurrency-limits.
         */
        post: operations["create_concurrency_limit_concurrency_limits__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Concurrency Limit
         * @description Get a concurrency limit by id.
         *
         *     The `active slots` field contains a list of TaskRun IDs currently using a
         *     concurrency slot for the specified tag.
         */
        get: operations["read_concurrency_limit_concurrency_limits__id__get"];
        put?: never;
        post?: never;
        /** Delete Concurrency Limit */
        delete: operations["delete_concurrency_limit_concurrency_limits__id__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/tag/{tag}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Concurrency Limit By Tag
         * @description Get a concurrency limit by tag.
         *
         *     The `active slots` field contains a list of TaskRun IDs currently using a
         *     concurrency slot for the specified tag.
         */
        get: operations["read_concurrency_limit_by_tag_concurrency_limits_tag__tag__get"];
        put?: never;
        post?: never;
        /** Delete Concurrency Limit By Tag */
        delete: operations["delete_concurrency_limit_by_tag_concurrency_limits_tag__tag__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Concurrency Limits
         * @description Query for concurrency limits.
         *
         *     For each concurrency limit the `active slots` field contains a list of TaskRun IDs
         *     currently using a concurrency slot for the specified tag.
         */
        post: operations["read_concurrency_limits_concurrency_limits_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/tag/{tag}/reset": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Reset Concurrency Limit By Tag */
        post: operations["reset_concurrency_limit_by_tag_concurrency_limits_tag__tag__reset_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/increment": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Increment Concurrency Limits V1
         * @description Increment concurrency limits for the given tags.
         *
         *     During migration, this handles both V1 and V2 limits to support mixed states.
         *     Post-migration, it only uses V2 with lease-based concurrency.
         */
        post: operations["increment_concurrency_limits_v1_concurrency_limits_increment_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/concurrency_limits/decrement": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Decrement Concurrency Limits V1
         * @description Decrement concurrency limits for the given tags.
         *
         *     Finds and revokes the lease for V2 limits or decrements V1 active slots.
         *     Returns the list of limits that were decremented.
         */
        post: operations["decrement_concurrency_limits_v1_concurrency_limits_decrement_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Concurrency Limit V2
         * @description Create a task run concurrency limit.
         *
         *     For more information, see https://docs.prefect.io/v3/how-to-guides/workflows/global-concurrency-limits.
         */
        post: operations["create_concurrency_limit_v2_v2_concurrency_limits__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/{id_or_name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Concurrency Limit V2 */
        get: operations["read_concurrency_limit_v2_v2_concurrency_limits__id_or_name__get"];
        put?: never;
        post?: never;
        /** Delete Concurrency Limit V2 */
        delete: operations["delete_concurrency_limit_v2_v2_concurrency_limits__id_or_name__delete"];
        options?: never;
        head?: never;
        /** Update Concurrency Limit V2 */
        patch: operations["update_concurrency_limit_v2_v2_concurrency_limits__id_or_name__patch"];
        trace?: never;
    };
    "/v2/concurrency_limits/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read All Concurrency Limits V2 */
        post: operations["read_all_concurrency_limits_v2_v2_concurrency_limits_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/increment": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Bulk Increment Active Slots */
        post: operations["bulk_increment_active_slots_v2_concurrency_limits_increment_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/increment-with-lease": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Bulk Increment Active Slots With Lease */
        post: operations["bulk_increment_active_slots_with_lease_v2_concurrency_limits_increment_with_lease_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/decrement": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Bulk Decrement Active Slots */
        post: operations["bulk_decrement_active_slots_v2_concurrency_limits_decrement_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/decrement-with-lease": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Bulk Decrement Active Slots With Lease */
        post: operations["bulk_decrement_active_slots_with_lease_v2_concurrency_limits_decrement_with_lease_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/concurrency_limits/leases/{lease_id}/renew": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Renew Concurrency Lease */
        post: operations["renew_concurrency_lease_v2_concurrency_limits_leases__lease_id__renew_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Block Type
         * @description Create a new block type.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/blocks.
         */
        post: operations["create_block_type_block_types__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Block Type By Id
         * @description Get a block type by ID.
         */
        get: operations["read_block_type_by_id_block_types__id__get"];
        put?: never;
        post?: never;
        /** Delete Block Type */
        delete: operations["delete_block_type_block_types__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Block Type
         * @description Update a block type.
         */
        patch: operations["update_block_type_block_types__id__patch"];
        trace?: never;
    };
    "/block_types/slug/{slug}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Block Type By Slug
         * @description Get a block type by name.
         */
        get: operations["read_block_type_by_slug_block_types_slug__slug__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Block Types
         * @description Gets all block types. Optionally limit return with limit and offset.
         */
        post: operations["read_block_types_block_types_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/slug/{slug}/block_documents": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Block Documents For Block Type */
        get: operations["read_block_documents_for_block_type_block_types_slug__slug__block_documents_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/slug/{slug}/block_documents/name/{block_document_name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Block Document By Name For Block Type */
        get: operations["read_block_document_by_name_for_block_type_block_types_slug__slug__block_documents_name__block_document_name__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_types/install_system_block_types": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Install System Block Types */
        post: operations["install_system_block_types_block_types_install_system_block_types_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_documents/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Block Document
         * @description Create a new block document.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/blocks.
         */
        post: operations["create_block_document_block_documents__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_documents/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Block Documents
         * @description Query for block documents.
         */
        post: operations["read_block_documents_block_documents_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_documents/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Block Documents
         * @description Count block documents.
         */
        post: operations["count_block_documents_block_documents_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_documents/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Block Document By Id */
        get: operations["read_block_document_by_id_block_documents__id__get"];
        put?: never;
        post?: never;
        /** Delete Block Document */
        delete: operations["delete_block_document_block_documents__id__delete"];
        options?: never;
        head?: never;
        /** Update Block Document Data */
        patch: operations["update_block_document_data_block_documents__id__patch"];
        trace?: never;
    };
    "/work_pools/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Work Pool
         * @description Creates a new work pool. If a work pool with the same
         *     name already exists, an error will be raised.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/work-pools.
         */
        post: operations["create_work_pool_work_pools__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Work Pool
         * @description Read a work pool by name
         */
        get: operations["read_work_pool_work_pools__name__get"];
        put?: never;
        post?: never;
        /**
         * Delete Work Pool
         * @description Delete a work pool
         */
        delete: operations["delete_work_pool_work_pools__name__delete"];
        options?: never;
        head?: never;
        /**
         * Update Work Pool
         * @description Update a work pool
         */
        patch: operations["update_work_pool_work_pools__name__patch"];
        trace?: never;
    };
    "/work_pools/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Work Pools
         * @description Read multiple work pools
         */
        post: operations["read_work_pools_work_pools_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Work Pools
         * @description Count work pools
         */
        post: operations["count_work_pools_work_pools_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{name}/get_scheduled_flow_runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Get Scheduled Flow Runs
         * @description Load scheduled runs for a worker
         */
        post: operations["get_scheduled_flow_runs_work_pools__name__get_scheduled_flow_runs_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{work_pool_name}/queues": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Work Queue
         * @description Creates a new work pool queue. If a work pool queue with the same
         *     name already exists, an error will be raised.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/work-pools#work-queues.
         */
        post: operations["create_work_queue_work_pools__work_pool_name__queues_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{work_pool_name}/queues/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Work Queue
         * @description Read a work pool queue
         */
        get: operations["read_work_queue_work_pools__work_pool_name__queues__name__get"];
        put?: never;
        post?: never;
        /**
         * Delete Work Queue
         * @description Delete a work pool queue
         */
        delete: operations["delete_work_queue_work_pools__work_pool_name__queues__name__delete"];
        options?: never;
        head?: never;
        /**
         * Update Work Queue
         * @description Update a work pool queue
         */
        patch: operations["update_work_queue_work_pools__work_pool_name__queues__name__patch"];
        trace?: never;
    };
    "/work_pools/{work_pool_name}/queues/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Work Queues
         * @description Read all work pool queues
         */
        post: operations["read_work_queues_work_pools__work_pool_name__queues_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{work_pool_name}/workers/heartbeat": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Worker Heartbeat */
        post: operations["worker_heartbeat_work_pools__work_pool_name__workers_heartbeat_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{work_pool_name}/workers/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Workers
         * @description Read all worker processes
         */
        post: operations["read_workers_work_pools__work_pool_name__workers_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_pools/{work_pool_name}/workers/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        /**
         * Delete Worker
         * @description Delete a work pool's worker
         */
        delete: operations["delete_worker_work_pools__work_pool_name__workers__name__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/task_workers/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Task Workers
         * @description Read active task workers. Optionally filter by task keys.
         *
         *     For more information, see https://docs.prefect.io/v3/how-to-guides/workflows/run-background-tasks.
         */
        post: operations["read_task_workers_task_workers_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_queues/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Work Queue
         * @description Creates a new work queue.
         *
         *     If a work queue with the same name already exists, an error
         *     will be raised.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/work-pools#work-queues.
         */
        post: operations["create_work_queue_work_queues__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_queues/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Work Queue
         * @description Get a work queue by id.
         */
        get: operations["read_work_queue_work_queues__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Work Queue
         * @description Delete a work queue by id.
         */
        delete: operations["delete_work_queue_work_queues__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Work Queue
         * @description Updates an existing work queue.
         */
        patch: operations["update_work_queue_work_queues__id__patch"];
        trace?: never;
    };
    "/work_queues/name/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Work Queue By Name
         * @description Get a work queue by id.
         */
        get: operations["read_work_queue_by_name_work_queues_name__name__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_queues/{id}/get_runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Work Queue Runs
         * @description Get flow runs from the work queue.
         */
        post: operations["read_work_queue_runs_work_queues__id__get_runs_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_queues/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Work Queues
         * @description Query for work queues.
         */
        post: operations["read_work_queues_work_queues_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/work_queues/{id}/status": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Work Queue Status
         * @description Get the status of a work queue.
         */
        get: operations["read_work_queue_status_work_queues__id__status_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Artifact
         * @description Create an artifact.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/artifacts.
         */
        post: operations["create_artifact_artifacts__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Artifact
         * @description Retrieve an artifact from the database.
         */
        get: operations["read_artifact_artifacts__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Artifact
         * @description Delete an artifact from the database.
         */
        delete: operations["delete_artifact_artifacts__id__delete"];
        options?: never;
        head?: never;
        /**
         * Update Artifact
         * @description Update an artifact in the database.
         */
        patch: operations["update_artifact_artifacts__id__patch"];
        trace?: never;
    };
    "/artifacts/{key}/latest": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Latest Artifact
         * @description Retrieve the latest artifact from the artifact table.
         */
        get: operations["read_latest_artifact_artifacts__key__latest_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Artifacts
         * @description Retrieve artifacts from the database.
         */
        post: operations["read_artifacts_artifacts_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/latest/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Latest Artifacts
         * @description Retrieve artifacts from the database.
         */
        post: operations["read_latest_artifacts_artifacts_latest_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Artifacts
         * @description Count artifacts from the database.
         */
        post: operations["count_artifacts_artifacts_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/artifacts/latest/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Latest Artifacts
         * @description Count artifacts from the database.
         */
        post: operations["count_latest_artifacts_artifacts_latest_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_schemas/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Block Schema
         * @description Create a block schema.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/blocks.
         */
        post: operations["create_block_schema_block_schemas__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_schemas/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Block Schema By Id
         * @description Get a block schema by id.
         */
        get: operations["read_block_schema_by_id_block_schemas__id__get"];
        put?: never;
        post?: never;
        /**
         * Delete Block Schema
         * @description Delete a block schema by id.
         */
        delete: operations["delete_block_schema_block_schemas__id__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_schemas/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Block Schemas
         * @description Read all block schemas, optionally filtered by type
         */
        post: operations["read_block_schemas_block_schemas_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_schemas/checksum/{checksum}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Block Schema By Checksum */
        get: operations["read_block_schema_by_checksum_block_schemas_checksum__checksum__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/block_capabilities/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Available Block Capabilities
         * @description Get available block capabilities.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/blocks.
         */
        get: operations["read_available_block_capabilities_block_capabilities__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/collections/views/{view}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read View Content
         * @description Reads the content of a view from the prefect-collection-registry.
         */
        get: operations["read_view_content_collections_views__view__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/variables/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Variable
         * @description Create a variable.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/variables.
         */
        post: operations["create_variable_variables__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/variables/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Variable */
        get: operations["read_variable_variables__id__get"];
        put?: never;
        post?: never;
        /** Delete Variable */
        delete: operations["delete_variable_variables__id__delete"];
        options?: never;
        head?: never;
        /** Update Variable */
        patch: operations["update_variable_variables__id__patch"];
        trace?: never;
    };
    "/variables/name/{name}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Variable By Name */
        get: operations["read_variable_by_name_variables_name__name__get"];
        put?: never;
        post?: never;
        /** Delete Variable By Name */
        delete: operations["delete_variable_by_name_variables_name__name__delete"];
        options?: never;
        head?: never;
        /** Update Variable By Name */
        patch: operations["update_variable_by_name_variables_name__name__patch"];
        trace?: never;
    };
    "/variables/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read Variables */
        post: operations["read_variables_variables_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/variables/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Count Variables */
        post: operations["count_variables_variables_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/csrf-token": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Create Csrf Token
         * @description Create or update a CSRF token for a client
         */
        get: operations["create_csrf_token_csrf_token_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/events": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Events
         * @description Record a batch of Events.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/events.
         */
        post: operations["create_events_events_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/events/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Read Events
         * @description Queries for Events matching the given filter criteria in the given Account.  Returns
         *     the first page of results, and the URL to request the next page (if there are more
         *     results).
         */
        post: operations["read_events_events_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/events/filter/next": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Account Events Page
         * @description Returns the next page of Events for a previous query against the given Account, and
         *     the URL to request the next page (if there are more results).
         */
        get: operations["read_account_events_page_events_filter_next_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/events/count-by/{countable}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Account Events
         * @description Returns distinct objects and the count of events associated with them.  Objects
         *     that can be counted include the day the event occurred, the type of event, or
         *     the IDs of the resources associated with the event.
         */
        post: operations["count_account_events_events_count_by__countable__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Automation
         * @description Create an automation.
         *
         *     For more information, see https://docs.prefect.io/v3/concepts/automations.
         */
        post: operations["create_automation_automations__post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Automation */
        get: operations["read_automation_automations__id__get"];
        /** Update Automation */
        put: operations["update_automation_automations__id__put"];
        post?: never;
        /** Delete Automation */
        delete: operations["delete_automation_automations__id__delete"];
        options?: never;
        head?: never;
        /** Patch Automation */
        patch: operations["patch_automation_automations__id__patch"];
        trace?: never;
    };
    "/automations/filter": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read Automations */
        post: operations["read_automations_automations_filter_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Count Automations */
        post: operations["count_automations_automations_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/related-to/{resource_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Read Automations Related To Resource */
        get: operations["read_automations_related_to_resource_automations_related_to__resource_id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/owned-by/{resource_id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        post?: never;
        /** Delete Automations Owned By Resource */
        delete: operations["delete_automations_owned_by_resource_automations_owned_by__resource_id__delete"];
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/templates/validate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Validate Template */
        post: operations["validate_template_templates_validate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/automations/templates/validate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Validate Template */
        post: operations["validate_template_automations_templates_validate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/flows/count-deployments": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Deployments By Flow
         * @description Get deployment counts by flow id.
         */
        post: operations["count_deployments_by_flow_ui_flows_count_deployments_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/flows/next-runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Next Runs By Flow
         * @description Get the next flow run by flow id.
         */
        post: operations["next_runs_by_flow_ui_flows_next_runs_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/flow_runs/history": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read Flow Run History */
        post: operations["read_flow_run_history_ui_flow_runs_history_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/flow_runs/count-task-runs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Count Task Runs By Flow Run
         * @description Get task run counts by flow run id.
         */
        post: operations["count_task_runs_by_flow_run_ui_flow_runs_count_task_runs_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/schemas/validate": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Validate Obj */
        post: operations["validate_obj_ui_schemas_validate_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/task_runs/dashboard/counts": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read Dashboard Task Run Counts */
        post: operations["read_dashboard_task_run_counts_ui_task_runs_dashboard_counts_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/task_runs/count": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** Read Task Run Counts By State */
        post: operations["read_task_run_counts_by_state_ui_task_runs_count_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ui/task_runs/{id}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Task Run With Flow Run Name
         * @description Get a task run by id.
         */
        get: operations["read_task_run_with_flow_run_name_ui_task_runs__id__get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/admin/settings": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Settings
         * @description Get the current Prefect REST API settings.
         *
         *     Secret setting values will be obfuscated.
         */
        get: operations["read_settings_admin_settings_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/admin/version": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Read Version
         * @description Returns the Prefect version number
         */
        get: operations["read_version_admin_version_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/admin/database/clear": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Clear Database
         * @description Clear all database tables without dropping them.
         */
        post: operations["clear_database_admin_database_clear_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/admin/database/drop": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Drop Database
         * @description Drop all database objects.
         */
        post: operations["drop_database_admin_database_drop_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/admin/database/create": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /**
         * Create Database
         * @description Create all database objects.
         */
        post: operations["create_database_admin_database_create_post"];
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/hello": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /**
         * Hello
         * @description Say hello!
         */
        get: operations["hello_hello_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/ready": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** Perform Readiness Check */
        get: operations["perform_readiness_check_ready_get"];
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
}
export type webhooks = Record<string, never>;
export interface components {
    schemas: {
        /**
         * APISettings
         * @description Settings for interacting with the Prefect API
         */
        APISettings: {
            /**
             * Url
             * @description The URL of the Prefect API. If not set, the client will attempt to infer it.
             */
            url?: string | null;
            /**
             * Auth String
             * @description The auth string used for basic authentication with a self-hosted Prefect API. Should be kept secret.
             */
            auth_string?: string | null;
            /**
             * Key
             * @description The API key used for authentication with the Prefect API. Should be kept secret.
             */
            key?: string | null;
            /**
             * Tls Insecure Skip Verify
             * @description If `True`, disables SSL checking to allow insecure requests. Setting to False is recommended only during development. For example, when using self-signed certificates.
             * @default false
             */
            tls_insecure_skip_verify: boolean;
            /**
             * Ssl Cert File
             * @description This configuration settings option specifies the path to an SSL certificate file.
             */
            ssl_cert_file?: string | null;
            /**
             * Enable Http2
             * @description If true, enable support for HTTP/2 for communicating with an API. If the API does not support HTTP/2, this will have no effect and connections will be made via HTTP/1.1.
             * @default false
             */
            enable_http2: boolean;
            /**
             * Request Timeout
             * @description The default timeout for requests to the API
             * @default 60
             */
            request_timeout: number;
        };
        /** Artifact */
        Artifact: {
            /**
             * Id
             * Format: uuid
             */
            id?: string;
            /** Created */
            created?: string | null;
            /** Updated */
            updated?: string | null;
            /**
             * Key
             * @description An optional unique reference key for this artifact.
             */
            key?: string | null;
            /**
             * Type
             * @description An identifier that describes the shape of the data field. e.g. 'result', 'table', 'markdown'
             */
            type?: string | null;
            /**
             * Description
             * @description A markdown-enabled description of the artifact.
             */
            description?: string | null;
            /**
             * Data
             * @description Data associated with the artifact, e.g. a result.; structure depends on the artifact type.
             */
            data?: {
                [key: string]: unknown;
            } | unknown | null;
            /**
             * Metadata
             * @description User-defined artifact metadata. Content must be string key and value pairs.
             */
            metadata_?: {
                [key: string]: string;
            } | null;
            /**
             * Flow Run Id
             * @description The flow run associated with the artifact.
             */
            flow_run_id?: string | null;
            /**
             * Task Run Id
             * @description The task run associated with the artifact.
             */
            task_run_id?: string | null;
        };
        /** ArtifactCollection */
        ArtifactCollection: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Key
             * @description An optional unique reference key for this artifact.
             */
            key: string;
            /**
             * Latest Id
             * Format: uuid
             * @description The latest artifact ID associated with the key.
             */
            latest_id: string;
            /**
             * Type
             * @description An identifier that describes the shape of the data field. e.g. 'result', 'table', 'markdown'
             */
            type?: string | null;
            /**
             * Description
             * @description A markdown-enabled description of the artifact.
             */
            description?: string | null;
            /**
             * Data
             * @description Data associated with the artifact, e.g. a result.; structure depends on the artifact type.
             */
            data?: {
                [key: string]: unknown;
            } | unknown | null;
            /**
             * Metadata
             * @description User-defined artifact metadata. Content must be string key and value pairs.
             */
            metadata_?: {
                [key: string]: string;
            } | null;
            /**
             * Flow Run Id
             * @description The flow run associated with the artifact.
             */
            flow_run_id?: string | null;
            /**
             * Task Run Id
             * @description The task run associated with the artifact.
             */
            task_run_id?: string | null;
        };
        /**
         * ArtifactCollectionFilter
         * @description Filter artifact collections. Only artifact collections matching all criteria will be returned
         */
        ArtifactCollectionFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Artifact.id` */
            latest_id?: components["schemas"]["ArtifactCollectionFilterLatestId"] | null;
            /** @description Filter criteria for `Artifact.key` */
            key?: components["schemas"]["ArtifactCollectionFilterKey"] | null;
            /** @description Filter criteria for `Artifact.flow_run_id` */
            flow_run_id?: components["schemas"]["ArtifactCollectionFilterFlowRunId"] | null;
            /** @description Filter criteria for `Artifact.task_run_id` */
            task_run_id?: components["schemas"]["ArtifactCollectionFilterTaskRunId"] | null;
            /** @description Filter criteria for `Artifact.type` */
            type?: components["schemas"]["ArtifactCollectionFilterType"] | null;
        };
        /**
         * ArtifactCollectionFilterFlowRunId
         * @description Filter by `ArtifactCollection.flow_run_id`.
         */
        ArtifactCollectionFilterFlowRunId: {
            /**
             * Any
             * @description A list of flow run IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactCollectionFilterKey
         * @description Filter by `ArtifactCollection.key`.
         */
        ArtifactCollectionFilterKey: {
            /**
             * Any
             * @description A list of artifact keys to include
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A string to match artifact keys against. This can include SQL wildcard characters like `%` and `_`.
             * @example my-artifact-%
             */
            like_?: string | null;
            /**
             * Exists
             * @description If `true`, only include artifacts with a non-null key. If `false`, only include artifacts with a null key. Should return all rows in the ArtifactCollection table if specified.
             */
            exists_?: boolean | null;
        };
        /**
         * ArtifactCollectionFilterLatestId
         * @description Filter by `ArtifactCollection.latest_id`.
         */
        ArtifactCollectionFilterLatestId: {
            /**
             * Any
             * @description A list of artifact ids to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactCollectionFilterTaskRunId
         * @description Filter by `ArtifactCollection.task_run_id`.
         */
        ArtifactCollectionFilterTaskRunId: {
            /**
             * Any
             * @description A list of task run IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactCollectionFilterType
         * @description Filter by `ArtifactCollection.type`.
         */
        ArtifactCollectionFilterType: {
            /**
             * Any
             * @description A list of artifact types to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of artifact types to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * ArtifactCollectionSort
         * @description Defines artifact collection sorting options.
         * @enum {string}
         */
        ArtifactCollectionSort: "CREATED_DESC" | "UPDATED_DESC" | "ID_DESC" | "KEY_DESC" | "KEY_ASC";
        /**
         * ArtifactCreate
         * @description Data used by the Prefect REST API to create an artifact.
         */
        ArtifactCreate: {
            /**
             * Key
             * @description An optional unique reference key for this artifact.
             */
            key?: string | null;
            /**
             * Type
             * @description An identifier that describes the shape of the data field. e.g. 'result', 'table', 'markdown'
             */
            type?: string | null;
            /**
             * Description
             * @description A markdown-enabled description of the artifact.
             */
            description?: string | null;
            /**
             * Data
             * @description Data associated with the artifact, e.g. a result.; structure depends on the artifact type.
             */
            data?: {
                [key: string]: unknown;
            } | unknown | null;
            /**
             * Metadata
             * @description User-defined artifact metadata. Content must be string key and value pairs.
             */
            metadata_?: {
                [key: string]: string;
            } | null;
            /**
             * Flow Run Id
             * @description The flow run associated with the artifact.
             */
            flow_run_id?: string | null;
            /**
             * Task Run Id
             * @description The task run associated with the artifact.
             */
            task_run_id?: string | null;
        };
        /**
         * ArtifactFilter
         * @description Filter artifacts. Only artifacts matching all criteria will be returned
         */
        ArtifactFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Artifact.id` */
            id?: components["schemas"]["ArtifactFilterId"] | null;
            /** @description Filter criteria for `Artifact.key` */
            key?: components["schemas"]["ArtifactFilterKey"] | null;
            /** @description Filter criteria for `Artifact.flow_run_id` */
            flow_run_id?: components["schemas"]["ArtifactFilterFlowRunId"] | null;
            /** @description Filter criteria for `Artifact.task_run_id` */
            task_run_id?: components["schemas"]["ArtifactFilterTaskRunId"] | null;
            /** @description Filter criteria for `Artifact.type` */
            type?: components["schemas"]["ArtifactFilterType"] | null;
        };
        /**
         * ArtifactFilterFlowRunId
         * @description Filter by `Artifact.flow_run_id`.
         */
        ArtifactFilterFlowRunId: {
            /**
             * Any
             * @description A list of flow run IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactFilterId
         * @description Filter by `Artifact.id`.
         */
        ArtifactFilterId: {
            /**
             * Any
             * @description A list of artifact ids to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactFilterKey
         * @description Filter by `Artifact.key`.
         */
        ArtifactFilterKey: {
            /**
             * Any
             * @description A list of artifact keys to include
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A string to match artifact keys against. This can include SQL wildcard characters like `%` and `_`.
             * @example my-artifact-%
             */
            like_?: string | null;
            /**
             * Exists
             * @description If `true`, only include artifacts with a non-null key. If `false`, only include artifacts with a null key.
             */
            exists_?: boolean | null;
        };
        /**
         * ArtifactFilterTaskRunId
         * @description Filter by `Artifact.task_run_id`.
         */
        ArtifactFilterTaskRunId: {
            /**
             * Any
             * @description A list of task run IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * ArtifactFilterType
         * @description Filter by `Artifact.type`.
         */
        ArtifactFilterType: {
            /**
             * Any
             * @description A list of artifact types to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of artifact types to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * ArtifactSort
         * @description Defines artifact sorting options.
         * @enum {string}
         */
        ArtifactSort: "CREATED_DESC" | "UPDATED_DESC" | "ID_DESC" | "KEY_DESC" | "KEY_ASC";
        /**
         * ArtifactUpdate
         * @description Data used by the Prefect REST API to update an artifact.
         */
        ArtifactUpdate: {
            /** Data */
            data?: {
                [key: string]: unknown;
            } | unknown | null;
            /** Description */
            description?: string | null;
            /** Metadata */
            metadata_?: {
                [key: string]: string;
            } | null;
        };
        /** Automation */
        Automation: {
            /**
             * Name
             * @description The name of this automation
             */
            name: string;
            /**
             * Description
             * @description A longer description of this automation
             * @default
             */
            description: string;
            /**
             * Enabled
             * @description Whether this automation will be evaluated
             * @default true
             */
            enabled: boolean;
            /**
             * Tags
             * @description A list of tags associated with this automation
             */
            tags?: string[];
            /**
             * Trigger
             * @description The criteria for which events this Automation covers and how it will respond to the presence or absence of those events
             */
            trigger: components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Output"] | components["schemas"]["SequenceTrigger-Output"];
            /**
             * Actions
             * @description The actions to perform when this Automation triggers
             */
            actions: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Trigger
             * @description The actions to perform when an Automation goes into a triggered state
             */
            actions_on_trigger?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Resolve
             * @description The actions to perform when an Automation goes into a resolving state
             */
            actions_on_resolve?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
        };
        /** AutomationCreate */
        AutomationCreate: {
            /**
             * Name
             * @description The name of this automation
             */
            name: string;
            /**
             * Description
             * @description A longer description of this automation
             * @default
             */
            description: string;
            /**
             * Enabled
             * @description Whether this automation will be evaluated
             * @default true
             */
            enabled: boolean;
            /**
             * Tags
             * @description A list of tags associated with this automation
             */
            tags?: string[];
            /**
             * Trigger
             * @description The criteria for which events this Automation covers and how it will respond to the presence or absence of those events
             */
            trigger: components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Input"] | components["schemas"]["SequenceTrigger-Input"];
            /**
             * Actions
             * @description The actions to perform when this Automation triggers
             */
            actions: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Trigger
             * @description The actions to perform when an Automation goes into a triggered state
             */
            actions_on_trigger?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Resolve
             * @description The actions to perform when an Automation goes into a resolving state
             */
            actions_on_resolve?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Owner Resource
             * @description The resource to which this automation belongs
             */
            owner_resource?: string | null;
        };
        /** AutomationFilter */
        AutomationFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Automation.name` */
            name?: components["schemas"]["AutomationFilterName"] | null;
            /** @description Filter criteria for `Automation.created` */
            created?: components["schemas"]["AutomationFilterCreated"] | null;
            /** @description Filter criteria for `Automation.tags` */
            tags?: components["schemas"]["AutomationFilterTags"] | null;
        };
        /**
         * AutomationFilterCreated
         * @description Filter by `Automation.created`.
         */
        AutomationFilterCreated: {
            /**
             * Before
             * @description Only include automations created before this datetime
             */
            before_?: string | null;
        };
        /**
         * AutomationFilterName
         * @description Filter by `Automation.created`.
         */
        AutomationFilterName: {
            /**
             * Any
             * @description Only include automations with names that match any of these strings
             */
            any_?: string[] | null;
        };
        /**
         * AutomationFilterTags
         * @description Filter by `Automation.tags`.
         */
        AutomationFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Automations will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Any
             * @description A list of tags. Automations will be returned if their tags contain any of the tags in the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include automations without tags
             */
            is_null_?: boolean | null;
        };
        /** AutomationPartialUpdate */
        AutomationPartialUpdate: {
            /**
             * Enabled
             * @description Whether this automation will be evaluated
             * @default true
             */
            enabled: boolean;
        };
        /**
         * AutomationSort
         * @description Defines automations sorting options.
         * @enum {string}
         */
        AutomationSort: "CREATED_DESC" | "UPDATED_DESC" | "NAME_ASC" | "NAME_DESC";
        /** AutomationUpdate */
        AutomationUpdate: {
            /**
             * Name
             * @description The name of this automation
             */
            name: string;
            /**
             * Description
             * @description A longer description of this automation
             * @default
             */
            description: string;
            /**
             * Enabled
             * @description Whether this automation will be evaluated
             * @default true
             */
            enabled: boolean;
            /**
             * Tags
             * @description A list of tags associated with this automation
             */
            tags?: string[];
            /**
             * Trigger
             * @description The criteria for which events this Automation covers and how it will respond to the presence or absence of those events
             */
            trigger: components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Input"] | components["schemas"]["SequenceTrigger-Input"];
            /**
             * Actions
             * @description The actions to perform when this Automation triggers
             */
            actions: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Trigger
             * @description The actions to perform when an Automation goes into a triggered state
             */
            actions_on_trigger?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
            /**
             * Actions On Resolve
             * @description The actions to perform when an Automation goes into a resolving state
             */
            actions_on_resolve?: (components["schemas"]["DoNothing"] | components["schemas"]["RunDeployment"] | components["schemas"]["PauseDeployment"] | components["schemas"]["ResumeDeployment"] | components["schemas"]["CancelFlowRun"] | components["schemas"]["ChangeFlowRunState"] | components["schemas"]["PauseWorkQueue"] | components["schemas"]["ResumeWorkQueue"] | components["schemas"]["SendNotification"] | components["schemas"]["CallWebhook"] | components["schemas"]["PauseAutomation"] | components["schemas"]["ResumeAutomation"] | components["schemas"]["SuspendFlowRun"] | components["schemas"]["ResumeFlowRun"] | components["schemas"]["PauseWorkPool"] | components["schemas"]["ResumeWorkPool"])[];
        };
        /**
         * BlockDocument
         * @description An ORM representation of a block document.
         */
        BlockDocument: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The block document's name. Not required for anonymous block documents.
             */
            name?: string | null;
            /**
             * Data
             * @description The block document's data
             */
            data?: {
                [key: string]: unknown;
            };
            /**
             * Block Schema Id
             * Format: uuid
             * @description A block schema ID
             */
            block_schema_id: string;
            /** @description The associated block schema */
            block_schema?: components["schemas"]["BlockSchema"] | null;
            /**
             * Block Type Id
             * Format: uuid
             * @description A block type ID
             */
            block_type_id: string;
            /**
             * Block Type Name
             * @description The associated block type's name
             */
            block_type_name?: string | null;
            /** @description The associated block type */
            block_type?: components["schemas"]["BlockType"] | null;
            /**
             * Block Document References
             * @description Record of the block document's references
             */
            block_document_references?: {
                [key: string]: {
                    [key: string]: unknown;
                };
            };
            /**
             * Is Anonymous
             * @description Whether the block is anonymous (anonymous blocks are usually created by Prefect automatically)
             * @default false
             */
            is_anonymous: boolean;
        };
        /**
         * BlockDocumentCreate
         * @description Data used by the Prefect REST API to create a block document.
         */
        BlockDocumentCreate: {
            /**
             * Name
             * @description The block document's name. Not required for anonymous block documents.
             */
            name?: string | null;
            /**
             * Data
             * @description The block document's data
             */
            data?: {
                [key: string]: unknown;
            };
            /**
             * Block Schema Id
             * Format: uuid
             * @description A block schema ID
             */
            block_schema_id: string;
            /**
             * Block Type Id
             * Format: uuid
             * @description A block type ID
             */
            block_type_id: string;
            /**
             * Is Anonymous
             * @description Whether the block is anonymous (anonymous blocks are usually created by Prefect automatically)
             * @default false
             */
            is_anonymous: boolean;
        };
        /**
         * BlockDocumentFilter
         * @description Filter BlockDocuments. Only BlockDocuments matching all criteria will be returned
         */
        BlockDocumentFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `BlockDocument.id` */
            id?: components["schemas"]["BlockDocumentFilterId"] | null;
            /**
             * @description Filter criteria for `BlockDocument.is_anonymous`. Defaults to excluding anonymous blocks.
             * @default {
             *       "eq_": false
             *     }
             */
            is_anonymous: components["schemas"]["BlockDocumentFilterIsAnonymous"] | null;
            /** @description Filter criteria for `BlockDocument.block_type_id` */
            block_type_id?: components["schemas"]["BlockDocumentFilterBlockTypeId"] | null;
            /** @description Filter criteria for `BlockDocument.name` */
            name?: components["schemas"]["BlockDocumentFilterName"] | null;
        };
        /**
         * BlockDocumentFilterBlockTypeId
         * @description Filter by `BlockDocument.block_type_id`.
         */
        BlockDocumentFilterBlockTypeId: {
            /**
             * Any
             * @description A list of block type ids to include
             */
            any_?: string[] | null;
        };
        /**
         * BlockDocumentFilterId
         * @description Filter by `BlockDocument.id`.
         */
        BlockDocumentFilterId: {
            /**
             * Any
             * @description A list of block ids to include
             */
            any_?: string[] | null;
        };
        /**
         * BlockDocumentFilterIsAnonymous
         * @description Filter by `BlockDocument.is_anonymous`.
         */
        BlockDocumentFilterIsAnonymous: {
            /**
             * Eq
             * @description Filter block documents for only those that are or are not anonymous.
             */
            eq_?: boolean | null;
        };
        /**
         * BlockDocumentFilterName
         * @description Filter by `BlockDocument.name`.
         */
        BlockDocumentFilterName: {
            /**
             * Any
             * @description A list of block names to include
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A string to match block names against. This can include SQL wildcard characters like `%` and `_`.
             * @example my-block%
             */
            like_?: string | null;
        };
        /**
         * BlockDocumentSort
         * @description Defines block document sorting options.
         * @enum {string}
         */
        BlockDocumentSort: "NAME_DESC" | "NAME_ASC" | "BLOCK_TYPE_AND_NAME_ASC";
        /**
         * BlockDocumentUpdate
         * @description Data used by the Prefect REST API to update a block document.
         */
        BlockDocumentUpdate: {
            /**
             * Block Schema Id
             * @description A block schema ID
             */
            block_schema_id?: string | null;
            /**
             * Data
             * @description The block document's data
             */
            data?: {
                [key: string]: unknown;
            };
            /**
             * Merge Existing Data
             * @default true
             */
            merge_existing_data: boolean;
        };
        /**
         * BlockSchema
         * @description An ORM representation of a block schema.
         */
        BlockSchema: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Checksum
             * @description The block schema's unique checksum
             */
            checksum: string;
            /**
             * Fields
             * @description The block schema's field schema
             */
            fields?: {
                [key: string]: unknown;
            };
            /**
             * Block Type Id
             * @description A block type ID
             */
            block_type_id: string | null;
            /** @description The associated block type */
            block_type?: components["schemas"]["BlockType"] | null;
            /**
             * Capabilities
             * @description A list of Block capabilities
             */
            capabilities?: string[];
            /**
             * Version
             * @description Human readable identifier for the block schema
             * @default non-versioned
             */
            version: string;
        };
        /**
         * BlockSchemaCreate
         * @description Data used by the Prefect REST API to create a block schema.
         */
        BlockSchemaCreate: {
            /**
             * Fields
             * @description The block schema's field schema
             */
            fields?: {
                [key: string]: unknown;
            };
            /**
             * Block Type Id
             * Format: uuid
             * @description A block type ID
             */
            block_type_id: string;
            /**
             * Capabilities
             * @description A list of Block capabilities
             */
            capabilities?: string[];
            /**
             * Version
             * @description Human readable identifier for the block schema
             * @default non-versioned
             */
            version: string;
        };
        /**
         * BlockSchemaFilter
         * @description Filter BlockSchemas
         */
        BlockSchemaFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `BlockSchema.block_type_id` */
            block_type_id?: components["schemas"]["BlockSchemaFilterBlockTypeId"] | null;
            /** @description Filter criteria for `BlockSchema.capabilities` */
            block_capabilities?: components["schemas"]["BlockSchemaFilterCapabilities"] | null;
            /** @description Filter criteria for `BlockSchema.id` */
            id?: components["schemas"]["BlockSchemaFilterId"] | null;
            /** @description Filter criteria for `BlockSchema.version` */
            version?: components["schemas"]["BlockSchemaFilterVersion"] | null;
        };
        /**
         * BlockSchemaFilterBlockTypeId
         * @description Filter by `BlockSchema.block_type_id`.
         */
        BlockSchemaFilterBlockTypeId: {
            /**
             * Any
             * @description A list of block type ids to include
             */
            any_?: string[] | null;
        };
        /**
         * BlockSchemaFilterCapabilities
         * @description Filter by `BlockSchema.capabilities`
         */
        BlockSchemaFilterCapabilities: {
            /**
             * All
             * @description A list of block capabilities. Block entities will be returned only if an associated block schema has a superset of the defined capabilities.
             * @example [
             *       "write-storage",
             *       "read-storage"
             *     ]
             */
            all_?: string[] | null;
        };
        /**
         * BlockSchemaFilterId
         * @description Filter by BlockSchema.id
         */
        BlockSchemaFilterId: {
            /**
             * Any
             * @description A list of IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * BlockSchemaFilterVersion
         * @description Filter by `BlockSchema.capabilities`
         */
        BlockSchemaFilterVersion: {
            /**
             * Any
             * @description A list of block schema versions.
             * @example [
             *       "2.0.0",
             *       "2.1.0"
             *     ]
             */
            any_?: string[] | null;
        };
        /**
         * BlockType
         * @description An ORM representation of a block type
         */
        BlockType: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description A block type's name
             */
            name: string;
            /**
             * Slug
             * @description A block type's slug
             */
            slug: string;
            /**
             * Logo Url
             * @description Web URL for the block type's logo
             */
            logo_url?: string | null;
            /**
             * Documentation Url
             * @description Web URL for the block type's documentation
             */
            documentation_url?: string | null;
            /**
             * Description
             * @description A short blurb about the corresponding block's intended use
             */
            description?: string | null;
            /**
             * Code Example
             * @description A code snippet demonstrating use of the corresponding block
             */
            code_example?: string | null;
            /**
             * Is Protected
             * @description Protected block types cannot be modified via API.
             * @default false
             */
            is_protected: boolean;
        };
        /**
         * BlockTypeCreate
         * @description Data used by the Prefect REST API to create a block type.
         */
        BlockTypeCreate: {
            /**
             * Name
             * @description A block type's name
             */
            name: string;
            /**
             * Slug
             * @description A block type's slug
             */
            slug: string;
            /**
             * Logo Url
             * @description Web URL for the block type's logo
             */
            logo_url?: string | null;
            /**
             * Documentation Url
             * @description Web URL for the block type's documentation
             */
            documentation_url?: string | null;
            /**
             * Description
             * @description A short blurb about the corresponding block's intended use
             */
            description?: string | null;
            /**
             * Code Example
             * @description A code snippet demonstrating use of the corresponding block
             */
            code_example?: string | null;
        };
        /**
         * BlockTypeFilter
         * @description Filter BlockTypes
         */
        BlockTypeFilter: {
            /** @description Filter criteria for `BlockType.name` */
            name?: components["schemas"]["BlockTypeFilterName"] | null;
            /** @description Filter criteria for `BlockType.slug` */
            slug?: components["schemas"]["BlockTypeFilterSlug"] | null;
        };
        /**
         * BlockTypeFilterName
         * @description Filter by `BlockType.name`
         */
        BlockTypeFilterName: {
            /**
             * Like
             * @description A case-insensitive partial match. For example,  passing 'marvin' will match 'marvin', 'sad-Marvin', and 'marvin-robot'.
             * @example marvin
             */
            like_?: string | null;
        };
        /**
         * BlockTypeFilterSlug
         * @description Filter by `BlockType.slug`
         */
        BlockTypeFilterSlug: {
            /**
             * Any
             * @description A list of slugs to match
             */
            any_?: string[] | null;
        };
        /**
         * BlockTypeUpdate
         * @description Data used by the Prefect REST API to update a block type.
         */
        BlockTypeUpdate: {
            /** Logo Url */
            logo_url?: string | null;
            /** Documentation Url */
            documentation_url?: string | null;
            /** Description */
            description?: string | null;
            /** Code Example */
            code_example?: string | null;
        };
        /** Body_average_flow_run_lateness_flow_runs_lateness_post */
        Body_average_flow_run_lateness_flow_runs_lateness_post: {
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
        };
        /** Body_bulk_decrement_active_slots_v2_concurrency_limits_decrement_post */
        Body_bulk_decrement_active_slots_v2_concurrency_limits_decrement_post: {
            /** Slots */
            slots: number;
            /** Names */
            names: string[];
            /** Occupancy Seconds */
            occupancy_seconds?: number | null;
            /**
             * Create If Missing
             * @deprecated
             */
            create_if_missing?: boolean;
        };
        /** Body_bulk_decrement_active_slots_with_lease_v2_concurrency_limits_decrement_with_lease_post */
        Body_bulk_decrement_active_slots_with_lease_v2_concurrency_limits_decrement_with_lease_post: {
            /**
             * Lease Id
             * Format: uuid
             * @description The ID of the lease corresponding to the concurrency limits to decrement.
             */
            lease_id: string;
        };
        /** Body_bulk_increment_active_slots_v2_concurrency_limits_increment_post */
        Body_bulk_increment_active_slots_v2_concurrency_limits_increment_post: {
            /** Slots */
            slots: number;
            /** Names */
            names: string[];
            /**
             * Mode
             * @default concurrency
             * @enum {string}
             */
            mode: "concurrency" | "rate_limit";
            /**
             * Create If Missing
             * @deprecated
             */
            create_if_missing?: boolean | null;
        };
        /** Body_bulk_increment_active_slots_with_lease_v2_concurrency_limits_increment_with_lease_post */
        Body_bulk_increment_active_slots_with_lease_v2_concurrency_limits_increment_with_lease_post: {
            /** Slots */
            slots: number;
            /** Names */
            names: string[];
            /**
             * Mode
             * @default concurrency
             * @enum {string}
             */
            mode: "concurrency" | "rate_limit";
            /**
             * Lease Duration
             * @description The duration of the lease in seconds.
             * @default 300
             */
            lease_duration: number;
            /** @description The holder of the lease with type (flow_run, task_run, or deployment) and id. */
            holder?: components["schemas"]["ConcurrencyLeaseHolder"] | null;
        };
        /** Body_clear_database_admin_database_clear_post */
        Body_clear_database_admin_database_clear_post: {
            /**
             * Confirm
             * @description Pass confirm=True to confirm you want to modify the database.
             * @default false
             */
            confirm: boolean;
        };
        /** Body_count_account_events_events_count_by__countable__post */
        Body_count_account_events_events_count_by__countable__post: {
            filter: components["schemas"]["EventFilter"];
            /** @default day */
            time_unit: components["schemas"]["TimeUnit"];
            /**
             * Time Interval
             * @default 1
             */
            time_interval: number;
        };
        /** Body_count_artifacts_artifacts_count_post */
        Body_count_artifacts_artifacts_count_post: {
            artifacts?: components["schemas"]["ArtifactFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            flows?: components["schemas"]["FlowFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
        };
        /** Body_count_block_documents_block_documents_count_post */
        Body_count_block_documents_block_documents_count_post: {
            block_documents?: components["schemas"]["BlockDocumentFilter"] | null;
            block_types?: components["schemas"]["BlockTypeFilter"] | null;
            block_schemas?: components["schemas"]["BlockSchemaFilter"] | null;
        };
        /** Body_count_deployments_by_flow_ui_flows_count_deployments_post */
        Body_count_deployments_by_flow_ui_flows_count_deployments_post: {
            /** Flow Ids */
            flow_ids: string[];
        };
        /** Body_count_deployments_deployments_count_post */
        Body_count_deployments_deployments_count_post: {
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
        };
        /** Body_count_flow_runs_flow_runs_count_post */
        Body_count_flow_runs_flow_runs_count_post: {
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
        };
        /** Body_count_flows_flows_count_post */
        Body_count_flows_flows_count_post: {
            flows?: components["schemas"]["FlowFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
            work_pools?: components["schemas"]["WorkPoolFilter"];
        };
        /** Body_count_latest_artifacts_artifacts_latest_count_post */
        Body_count_latest_artifacts_artifacts_latest_count_post: {
            artifacts?: components["schemas"]["ArtifactCollectionFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            flows?: components["schemas"]["FlowFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
        };
        /** Body_count_task_runs_by_flow_run_ui_flow_runs_count_task_runs_post */
        Body_count_task_runs_by_flow_run_ui_flow_runs_count_task_runs_post: {
            /** Flow Run Ids */
            flow_run_ids: string[];
        };
        /** Body_count_task_runs_task_runs_count_post */
        Body_count_task_runs_task_runs_count_post: {
            flows?: components["schemas"]["FlowFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
        };
        /** Body_count_variables_variables_count_post */
        Body_count_variables_variables_count_post: {
            variables?: components["schemas"]["VariableFilter"] | null;
        };
        /** Body_count_work_pools_work_pools_count_post */
        Body_count_work_pools_work_pools_count_post: {
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
        };
        /** Body_create_database_admin_database_create_post */
        Body_create_database_admin_database_create_post: {
            /**
             * Confirm
             * @description Pass confirm=True to confirm you want to modify the database.
             * @default false
             */
            confirm: boolean;
        };
        /** Body_create_flow_run_input_flow_runs__id__input_post */
        Body_create_flow_run_input_flow_runs__id__input_post: {
            /**
             * Key
             * @description The input key
             */
            key: string;
            /**
             * Value
             * Format: binary
             * @description The value of the input
             */
            value: string;
            /**
             * Sender
             * @description The sender of the input
             */
            sender?: string | null;
        };
        /** Body_decrement_concurrency_limits_v1_concurrency_limits_decrement_post */
        Body_decrement_concurrency_limits_v1_concurrency_limits_decrement_post: {
            /**
             * Names
             * @description The tags to release a slot for
             */
            names: string[];
            /**
             * Task Run Id
             * Format: uuid
             * @description The ID of the task run releasing the slot
             */
            task_run_id: string;
        };
        /** Body_drop_database_admin_database_drop_post */
        Body_drop_database_admin_database_drop_post: {
            /**
             * Confirm
             * @description Pass confirm=True to confirm you want to modify the database.
             * @default false
             */
            confirm: boolean;
        };
        /** Body_filter_flow_run_input_flow_runs__id__input_filter_post */
        Body_filter_flow_run_input_flow_runs__id__input_filter_post: {
            /**
             * Prefix
             * @description The input key prefix
             */
            prefix: string;
            /**
             * Limit
             * @description The maximum number of results to return
             * @default 1
             */
            limit: number;
            /**
             * Exclude Keys
             * @description Exclude inputs with these keys
             * @default []
             */
            exclude_keys: string[];
        };
        /** Body_flow_run_history_flow_runs_history_post */
        Body_flow_run_history_flow_runs_history_post: {
            /**
             * History Start
             * Format: date-time
             * @description The history's start time.
             */
            history_start: string;
            /**
             * History End
             * Format: date-time
             * @description The history's end time.
             */
            history_end: string;
            /**
             * History Interval Seconds
             * Format: time-delta
             * @description The size of each history interval, in seconds. Must be at least 1 second.
             */
            history_interval_seconds: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_queues?: components["schemas"]["WorkQueueFilter"] | null;
        };
        /** Body_get_scheduled_flow_runs_for_deployments_deployments_get_scheduled_flow_runs_post */
        Body_get_scheduled_flow_runs_for_deployments_deployments_get_scheduled_flow_runs_post: {
            /**
             * Deployment Ids
             * @description The deployment IDs to get scheduled runs for
             */
            deployment_ids: string[];
            /**
             * Scheduled Before
             * Format: date-time
             * @description The maximum time to look for scheduled flow runs
             */
            scheduled_before?: string;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_get_scheduled_flow_runs_work_pools__name__get_scheduled_flow_runs_post */
        Body_get_scheduled_flow_runs_work_pools__name__get_scheduled_flow_runs_post: {
            /**
             * Work Queue Names
             * @description The names of work pool queues
             */
            work_queue_names?: string[];
            /**
             * Scheduled Before
             * Format: date-time
             * @description The maximum time to look for scheduled flow runs
             */
            scheduled_before?: string;
            /**
             * Scheduled After
             * Format: date-time
             * @description The minimum time to look for scheduled flow runs
             */
            scheduled_after?: string;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_increment_concurrency_limits_v1_concurrency_limits_increment_post */
        Body_increment_concurrency_limits_v1_concurrency_limits_increment_post: {
            /**
             * Names
             * @description The tags to acquire a slot for
             */
            names: string[];
            /**
             * Task Run Id
             * Format: uuid
             * @description The ID of the task run acquiring the slot
             */
            task_run_id: string;
        };
        /** Body_next_runs_by_flow_ui_flows_next_runs_post */
        Body_next_runs_by_flow_ui_flows_next_runs_post: {
            /** Flow Ids */
            flow_ids: string[];
        };
        /** Body_paginate_deployments_deployments_paginate_post */
        Body_paginate_deployments_deployments_paginate_post: {
            /**
             * Page
             * @default 1
             */
            page: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
            /** @default NAME_ASC */
            sort: components["schemas"]["DeploymentSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_paginate_flow_runs_flow_runs_paginate_post */
        Body_paginate_flow_runs_flow_runs_paginate_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["FlowRunSort"];
            /**
             * Page
             * @default 1
             */
            page: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_paginate_flows_flows_paginate_post */
        Body_paginate_flows_flows_paginate_post: {
            /**
             * Page
             * @default 1
             */
            page: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            /** @default NAME_ASC */
            sort: components["schemas"]["FlowSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_paginate_task_runs_task_runs_paginate_post */
        Body_paginate_task_runs_task_runs_paginate_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["TaskRunSort"];
            /**
             * Page
             * @default 1
             */
            page: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_all_concurrency_limits_v2_v2_concurrency_limits_filter_post */
        Body_read_all_concurrency_limits_v2_v2_concurrency_limits_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_artifacts_artifacts_filter_post */
        Body_read_artifacts_artifacts_filter_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["ArtifactSort"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            artifacts?: components["schemas"]["ArtifactFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            flows?: components["schemas"]["FlowFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_automations_automations_filter_post */
        Body_read_automations_automations_filter_post: {
            /** @default NAME_ASC */
            sort: components["schemas"]["AutomationSort"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            automations?: components["schemas"]["AutomationFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_block_documents_block_documents_filter_post */
        Body_read_block_documents_block_documents_filter_post: {
            block_documents?: components["schemas"]["BlockDocumentFilter"] | null;
            block_types?: components["schemas"]["BlockTypeFilter"] | null;
            block_schemas?: components["schemas"]["BlockSchemaFilter"] | null;
            /**
             * Include Secrets
             * @description Whether to include sensitive values in the block document.
             * @default false
             */
            include_secrets: boolean;
            /** @default NAME_ASC */
            sort: components["schemas"]["BlockDocumentSort"] | null;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_block_schemas_block_schemas_filter_post */
        Body_read_block_schemas_block_schemas_filter_post: {
            block_schemas?: components["schemas"]["BlockSchemaFilter"] | null;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_block_types_block_types_filter_post */
        Body_read_block_types_block_types_filter_post: {
            block_types?: components["schemas"]["BlockTypeFilter"] | null;
            block_schemas?: components["schemas"]["BlockSchemaFilter"] | null;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_concurrency_limits_concurrency_limits_filter_post */
        Body_read_concurrency_limits_concurrency_limits_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_dashboard_task_run_counts_ui_task_runs_dashboard_counts_post */
        Body_read_dashboard_task_run_counts_ui_task_runs_dashboard_counts_post: {
            task_runs: components["schemas"]["TaskRunFilter"];
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_queues?: components["schemas"]["WorkQueueFilter"] | null;
        };
        /** Body_read_deployments_deployments_filter_post */
        Body_read_deployments_deployments_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
            /** @default NAME_ASC */
            sort: components["schemas"]["DeploymentSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_events_events_filter_post */
        Body_read_events_events_filter_post: {
            /** @description Additional optional filter criteria to narrow down the set of Events */
            filter?: components["schemas"]["EventFilter"] | null;
            /**
             * Limit
             * @description The number of events to return with each page
             * @default 50
             */
            limit: number;
        };
        /** Body_read_flow_run_history_ui_flow_runs_history_post */
        Body_read_flow_run_history_ui_flow_runs_history_post: {
            /** @default EXPECTED_START_TIME_DESC */
            sort: components["schemas"]["FlowRunSort"];
            /**
             * Limit
             * @default 1000
             */
            limit: number;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            flows?: components["schemas"]["FlowFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
            work_pools?: components["schemas"]["WorkPoolFilter"];
        };
        /** Body_read_flow_runs_flow_runs_filter_post */
        Body_read_flow_runs_flow_runs_filter_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["FlowRunSort"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            work_pool_queues?: components["schemas"]["WorkQueueFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_flows_flows_filter_post */
        Body_read_flows_flows_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            flows?: components["schemas"]["FlowFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
            work_pools?: components["schemas"]["WorkPoolFilter"];
            /** @default NAME_ASC */
            sort: components["schemas"]["FlowSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_latest_artifacts_artifacts_latest_filter_post */
        Body_read_latest_artifacts_artifacts_latest_filter_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["ArtifactCollectionSort"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            artifacts?: components["schemas"]["ArtifactCollectionFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            flows?: components["schemas"]["FlowFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_logs_logs_filter_post */
        Body_read_logs_logs_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            logs?: components["schemas"]["LogFilter"] | null;
            /** @default TIMESTAMP_ASC */
            sort: components["schemas"]["LogSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_saved_searches_saved_searches_filter_post */
        Body_read_saved_searches_saved_searches_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_task_run_counts_by_state_ui_task_runs_count_post */
        Body_read_task_run_counts_by_state_ui_task_runs_count_post: {
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
        };
        /** Body_read_task_runs_task_runs_filter_post */
        Body_read_task_runs_task_runs_filter_post: {
            /** @default ID_DESC */
            sort: components["schemas"]["TaskRunSort"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            flows?: components["schemas"]["FlowFilter"] | null;
            flow_runs?: components["schemas"]["FlowRunFilter"] | null;
            task_runs?: components["schemas"]["TaskRunFilter"] | null;
            deployments?: components["schemas"]["DeploymentFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_task_workers_task_workers_filter_post */
        Body_read_task_workers_task_workers_filter_post: {
            /** @description The task worker filter */
            task_worker_filter?: components["schemas"]["TaskWorkerFilter"] | null;
        };
        /** Body_read_variables_variables_filter_post */
        Body_read_variables_variables_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            variables?: components["schemas"]["VariableFilter"] | null;
            /** @default NAME_ASC */
            sort: components["schemas"]["VariableSort"];
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_work_pools_work_pools_filter_post */
        Body_read_work_pools_work_pools_filter_post: {
            work_pools?: components["schemas"]["WorkPoolFilter"] | null;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_work_queue_runs_work_queues__id__get_runs_post */
        Body_read_work_queue_runs_work_queues__id__get_runs_post: {
            /**
             * Scheduled Before
             * Format: date-time
             * @description Only flow runs scheduled to start before this time will be returned.
             */
            scheduled_before?: string;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_work_queues_work_pools__work_pool_name__queues_filter_post */
        Body_read_work_queues_work_pools__work_pool_name__queues_filter_post: {
            work_queues?: components["schemas"]["WorkQueueFilter"];
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_work_queues_work_queues_filter_post */
        Body_read_work_queues_work_queues_filter_post: {
            /**
             * Offset
             * @default 0
             */
            offset: number;
            work_queues?: components["schemas"]["WorkQueueFilter"] | null;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_read_workers_work_pools__work_pool_name__workers_filter_post */
        Body_read_workers_work_pools__work_pool_name__workers_filter_post: {
            workers?: components["schemas"]["WorkerFilter"] | null;
            /**
             * Offset
             * @default 0
             */
            offset: number;
            /**
             * Limit
             * @description Defaults to PREFECT_API_DEFAULT_LIMIT if not provided.
             */
            limit?: number;
        };
        /** Body_renew_concurrency_lease_v2_concurrency_limits_leases__lease_id__renew_post */
        Body_renew_concurrency_lease_v2_concurrency_limits_leases__lease_id__renew_post: {
            /**
             * Lease Duration
             * @description The duration of the lease in seconds.
             * @default 300
             */
            lease_duration: number;
        };
        /** Body_reset_concurrency_limit_by_tag_concurrency_limits_tag__tag__reset_post */
        Body_reset_concurrency_limit_by_tag_concurrency_limits_tag__tag__reset_post: {
            /**
             * Slot Override
             * @description Manual override for active concurrency limit slots.
             */
            slot_override?: string[] | null;
        };
        /** Body_resume_flow_run_flow_runs__id__resume_post */
        Body_resume_flow_run_flow_runs__id__resume_post: {
            /** Run Input */
            run_input?: {
                [key: string]: unknown;
            } | null;
        };
        /** Body_schedule_deployment_deployments__id__schedule_post */
        Body_schedule_deployment_deployments__id__schedule_post: {
            /**
             * Start Time
             * Format: date-time
             * @description The earliest date to schedule
             */
            start_time?: string;
            /**
             * End Time
             * Format: date-time
             * @description The latest date to schedule
             */
            end_time?: string;
            /**
             * Min Time
             * Format: time-delta
             * @description Runs will be scheduled until at least this long after the `start_time`
             */
            min_time?: number;
            /**
             * Min Runs
             * @description The minimum number of runs to schedule
             */
            min_runs?: number;
            /**
             * Max Runs
             * @description The maximum number of runs to schedule
             */
            max_runs?: number;
        };
        /** Body_set_flow_run_state_flow_runs__id__set_state_post */
        Body_set_flow_run_state_flow_runs__id__set_state_post: {
            /** @description The intended state. */
            state: components["schemas"]["StateCreate"];
            /**
             * Force
             * @description If false, orchestration rules will be applied that may alter or prevent the state transition. If True, orchestration rules are not applied.
             * @default false
             */
            force: boolean;
        };
        /** Body_set_task_run_state_task_runs__id__set_state_post */
        Body_set_task_run_state_task_runs__id__set_state_post: {
            /** @description The intended state. */
            state: components["schemas"]["StateCreate"];
            /**
             * Force
             * @description If false, orchestration rules will be applied that may alter or prevent the state transition. If True, orchestration rules are not applied.
             * @default false
             */
            force: boolean;
        };
        /** Body_task_run_history_task_runs_history_post */
        Body_task_run_history_task_runs_history_post: {
            /**
             * History Start
             * Format: date-time
             * @description The history's start time.
             */
            history_start: string;
            /**
             * History End
             * Format: date-time
             * @description The history's end time.
             */
            history_end: string;
            /**
             * History Interval Seconds
             * Format: time-delta
             * @description The size of each history interval, in seconds. Must be at least 1 second.
             */
            history_interval_seconds: number;
            flows?: components["schemas"]["FlowFilter"];
            flow_runs?: components["schemas"]["FlowRunFilter"];
            task_runs?: components["schemas"]["TaskRunFilter"];
            deployments?: components["schemas"]["DeploymentFilter"];
        };
        /** Body_validate_obj_ui_schemas_validate_post */
        Body_validate_obj_ui_schemas_validate_post: {
            /** Schema */
            schema: {
                [key: string]: unknown;
            };
            /** Values */
            values: {
                [key: string]: unknown;
            };
        };
        /** Body_worker_heartbeat_work_pools__work_pool_name__workers_heartbeat_post */
        Body_worker_heartbeat_work_pools__work_pool_name__workers_heartbeat_post: {
            /**
             * Name
             * @description The worker process name
             */
            name: string;
            /**
             * Heartbeat Interval Seconds
             * @description The worker's heartbeat interval in seconds
             */
            heartbeat_interval_seconds?: number | null;
        };
        /**
         * CLISettings
         * @description Settings for controlling CLI behavior
         */
        CLISettings: {
            /**
             * Colors
             * @description If True, use colors in CLI output. If `False`, output will not include colors codes.
             * @default true
             */
            colors: boolean;
            /**
             * Prompt
             * @description If `True`, use interactive prompts in CLI commands. If `False`, no interactive prompts will be used. If `None`, the value will be dynamically determined based on the presence of an interactive-enabled terminal.
             */
            prompt?: boolean | null;
            /**
             * Wrap Lines
             * @description If `True`, wrap text by inserting new lines in long lines in CLI output. If `False`, output will not be wrapped.
             * @default true
             */
            wrap_lines: boolean;
        };
        /**
         * CallWebhook
         * @description Call a webhook when an Automation is triggered.
         */
        CallWebhook: {
            /**
             * Type
             * @default call-webhook
             * @constant
             */
            type: "call-webhook";
            /**
             * Block Document Id
             * Format: uuid
             * @description The identifier of the webhook block to use
             */
            block_document_id: string;
            /**
             * Payload
             * @description An optional templatable payload to send when calling the webhook.
             * @default
             */
            payload: string;
        };
        /**
         * CancelFlowRun
         * @description Cancels a flow run associated with the trigger
         */
        CancelFlowRun: {
            /**
             * Type
             * @default cancel-flow-run
             * @constant
             */
            type: "cancel-flow-run";
        };
        /**
         * ChangeFlowRunState
         * @description Changes the state of a flow run associated with the trigger
         */
        ChangeFlowRunState: {
            /**
             * Type
             * @default change-flow-run-state
             * @constant
             */
            type: "change-flow-run-state";
            /**
             * Name
             * @description The name of the state to change the flow run to
             */
            name?: string | null;
            /** @description The type of the state to change the flow run to */
            state: components["schemas"]["StateType"];
            /**
             * Message
             * @description An optional message to associate with the state change
             */
            message?: string | null;
        };
        /**
         * ClientMetricsSettings
         * @description Settings for controlling metrics reporting from the client
         */
        ClientMetricsSettings: {
            /**
             * Enabled
             * @description Whether or not to enable Prometheus metrics in the client.
             * @default false
             */
            enabled: boolean;
            /**
             * Port
             * @description The port to expose the client Prometheus metrics on.
             * @default 4201
             */
            port: number;
        };
        /**
         * ClientSettings
         * @description Settings for controlling API client behavior
         */
        ClientSettings: {
            /**
             * Max Retries
             * @description The maximum number of retries to perform on failed HTTP requests.
             *             Defaults to 5. Set to 0 to disable retries.
             *             See `PREFECT_CLIENT_RETRY_EXTRA_CODES` for details on which HTTP status codes are
             *             retried.
             * @default 5
             */
            max_retries: number;
            /**
             * Retry Jitter Factor
             * @description A value greater than or equal to zero to control the amount of jitter added to retried
             *             client requests. Higher values introduce larger amounts of jitter.
             *             Set to 0 to disable jitter. See `clamped_poisson_interval` for details on the how jitter
             *             can affect retry lengths.
             * @default 0.2
             */
            retry_jitter_factor: number;
            /**
             * Retry Extra Codes
             * @description A list of extra HTTP status codes to retry on. Defaults to an empty list.
             *             429, 502 and 503 are always retried. Please note that not all routes are idempotent and retrying
             *             may result in unexpected behavior.
             * @example 404,429,503
             * @example 429
             * @example [
             *       404,
             *       429,
             *       503
             *     ]
             */
            retry_extra_codes?: string | number | number[] | null;
            /**
             * Csrf Support Enabled
             * @description Determines if CSRF token handling is active in the Prefect client for API
             *             requests.
             *
             *             When enabled (`True`), the client automatically manages CSRF tokens by
             *             retrieving, storing, and including them in applicable state-changing requests
             * @default true
             */
            csrf_support_enabled: boolean;
            /**
             * Custom Headers
             * @description Custom HTTP headers to include with every API request to the Prefect server.
             *             Headers are specified as key-value pairs. Note that headers like 'User-Agent'
             *             and CSRF-related headers are managed by Prefect and cannot be overridden.
             * @example {
             *       "X-Custom-Header": "value"
             *     }
             * @example {
             *       "Authorization": "Bearer token"
             *     }
             */
            custom_headers?: {
                [key: string]: string;
            };
            metrics?: components["schemas"]["ClientMetricsSettings"];
        };
        /**
         * CloudSettings
         * @description Settings for interacting with Prefect Cloud
         */
        CloudSettings: {
            /**
             * Api Url
             * @description API URL for Prefect Cloud. Used for authentication with Prefect Cloud.
             * @default https://api.prefect.cloud/api
             */
            api_url: string;
            /**
             * Enable Orchestration Telemetry
             * @description Whether or not to enable orchestration telemetry.
             * @default true
             */
            enable_orchestration_telemetry: boolean;
            /**
             * Max Log Size
             * @description Maximum size in characters for a single log when sending logs to Prefect Cloud.
             * @default 25000
             */
            max_log_size: number;
            /**
             * Ui Url
             * @description The URL of the Prefect Cloud UI. If not set, the client will attempt to infer it.
             */
            ui_url?: string | null;
        };
        /**
         * CompoundTrigger
         * @description A composite trigger that requires some number of triggers to have
         *     fired within the given time period
         */
        "CompoundTrigger-Input": {
            /**
             * Type
             * @default compound
             * @constant
             */
            type: "compound";
            /**
             * Id
             * Format: uuid
             * @description The unique ID of this trigger
             */
            id?: string;
            /** Triggers */
            triggers: (components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Input"] | components["schemas"]["SequenceTrigger-Input"])[];
            /** Within */
            within: number | null;
            /** Require */
            require: number | ("any" | "all");
        };
        /**
         * CompoundTrigger
         * @description A composite trigger that requires some number of triggers to have
         *     fired within the given time period
         */
        "CompoundTrigger-Output": {
            /**
             * Type
             * @default compound
             * @constant
             */
            type: "compound";
            /**
             * Id
             * Format: uuid
             * @description The unique ID of this trigger
             */
            id?: string;
            /** Triggers */
            triggers: (components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Output"] | components["schemas"]["SequenceTrigger-Output"])[];
            /** Within */
            within: number | null;
            /** Require */
            require: number | ("any" | "all");
        };
        /**
         * ConcurrencyLeaseHolder
         * @description Model for validating concurrency lease holder information.
         */
        ConcurrencyLeaseHolder: {
            /**
             * Type
             * @enum {string}
             */
            type: "flow_run" | "task_run" | "deployment";
            /**
             * Id
             * Format: uuid
             */
            id: string;
        };
        /**
         * ConcurrencyLimit
         * @description An ORM representation of a concurrency limit.
         */
        ConcurrencyLimit: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Tag
             * @description A tag the concurrency limit is applied to.
             */
            tag: string;
            /**
             * Concurrency Limit
             * @description The concurrency limit.
             */
            concurrency_limit: number;
            /**
             * Active Slots
             * @description A list of active run ids using a concurrency slot
             */
            active_slots?: string[];
        };
        /**
         * ConcurrencyLimitCreate
         * @description Data used by the Prefect REST API to create a concurrency limit.
         */
        ConcurrencyLimitCreate: {
            /**
             * Tag
             * @description A tag the concurrency limit is applied to.
             */
            tag: string;
            /**
             * Concurrency Limit
             * @description The concurrency limit.
             */
            concurrency_limit: number;
        };
        /**
         * ConcurrencyLimitStrategy
         * @description Enumeration of concurrency collision strategies.
         * @enum {string}
         */
        ConcurrencyLimitStrategy: "ENQUEUE" | "CANCEL_NEW";
        /**
         * ConcurrencyLimitV2
         * @description An ORM representation of a v2 concurrency limit.
         */
        ConcurrencyLimitV2: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Active
             * @description Whether the concurrency limit is active.
             * @default true
             */
            active: boolean;
            /**
             * Name
             * @description The name of the concurrency limit.
             */
            name: string;
            /**
             * Limit
             * @description The concurrency limit.
             */
            limit: number;
            /**
             * Active Slots
             * @description The number of active slots.
             * @default 0
             */
            active_slots: number;
            /**
             * Denied Slots
             * @description The number of denied slots.
             * @default 0
             */
            denied_slots: number;
            /**
             * Slot Decay Per Second
             * @description The decay rate for active slots when used as a rate limit.
             * @default 0
             */
            slot_decay_per_second: number;
            /**
             * Avg Slot Occupancy Seconds
             * @description The average amount of time a slot is occupied.
             * @default 2
             */
            avg_slot_occupancy_seconds: number;
        };
        /**
         * ConcurrencyLimitV2Create
         * @description Data used by the Prefect REST API to create a v2 concurrency limit.
         */
        ConcurrencyLimitV2Create: {
            /**
             * Active
             * @description Whether the concurrency limit is active.
             * @default true
             */
            active: boolean;
            /**
             * Name
             * @description The name of the concurrency limit.
             */
            name: string;
            /**
             * Limit
             * @description The concurrency limit.
             */
            limit: number;
            /**
             * Active Slots
             * @description The number of active slots.
             * @default 0
             */
            active_slots: number;
            /**
             * Denied Slots
             * @description The number of denied slots.
             * @default 0
             */
            denied_slots: number;
            /**
             * Slot Decay Per Second
             * @description The decay rate for active slots when used as a rate limit.
             * @default 0
             */
            slot_decay_per_second: number;
        };
        /**
         * ConcurrencyLimitV2Update
         * @description Data used by the Prefect REST API to update a v2 concurrency limit.
         */
        ConcurrencyLimitV2Update: {
            /** Active */
            active?: boolean | null;
            /** Name */
            name?: string | null;
            /** Limit */
            limit?: number | null;
            /** Active Slots */
            active_slots?: number | null;
            /** Denied Slots */
            denied_slots?: number | null;
            /** Slot Decay Per Second */
            slot_decay_per_second?: number | null;
        };
        /** ConcurrencyLimitWithLeaseResponse */
        ConcurrencyLimitWithLeaseResponse: {
            /**
             * Lease Id
             * Format: uuid
             */
            lease_id: string;
            /** Limits */
            limits: components["schemas"]["MinimalConcurrencyLimitResponse"][];
        };
        /**
         * ConcurrencyOptions
         * @description Class for storing the concurrency config in database.
         */
        ConcurrencyOptions: {
            collision_strategy: components["schemas"]["ConcurrencyLimitStrategy"];
            /**
             * Grace Period Seconds
             * @description Grace period in seconds for infrastructure to start before concurrency slots are revoked. If not set, falls back to server setting.
             */
            grace_period_seconds?: number | null;
        };
        /**
         * Constant
         * @description Represents constant input value to a task run.
         */
        Constant: {
            /**
             * Input Type
             * @default constant
             * @constant
             */
            input_type: "constant";
            /** Type */
            type: string;
        };
        /** CountByState */
        CountByState: {
            /**
             * Completed
             * @default 0
             */
            COMPLETED: number;
            /**
             * Pending
             * @default 0
             */
            PENDING: number;
            /**
             * Running
             * @default 0
             */
            RUNNING: number;
            /**
             * Failed
             * @default 0
             */
            FAILED: number;
            /**
             * Cancelled
             * @default 0
             */
            CANCELLED: number;
            /**
             * Crashed
             * @default 0
             */
            CRASHED: number;
            /**
             * Paused
             * @default 0
             */
            PAUSED: number;
            /**
             * Cancelling
             * @default 0
             */
            CANCELLING: number;
            /**
             * Scheduled
             * @default 0
             */
            SCHEDULED: number;
        };
        /**
         * Countable
         * @enum {string}
         */
        Countable: "day" | "time" | "event" | "resource";
        /** CreatedBy */
        CreatedBy: {
            /**
             * Id
             * @description The id of the creator of the object.
             */
            id?: string | null;
            /**
             * Type
             * @description The type of the creator of the object.
             */
            type?: string | null;
            /**
             * Display Value
             * @description The display value for the creator.
             */
            display_value?: string | null;
        };
        /**
         * CronSchedule
         * @description Cron schedule
         *
         *     NOTE: If the timezone is a DST-observing one, then the schedule will adjust
         *     itself appropriately. Cron's rules for DST are based on schedule times, not
         *     intervals. This means that an hourly cron schedule will fire on every new
         *     schedule hour, not every elapsed hour; for example, when clocks are set back
         *     this will result in a two-hour pause as the schedule will fire *the first
         *     time* 1am is reached and *the first time* 2am is reached, 120 minutes later.
         *     Longer schedules, such as one that fires at 9am every morning, will
         *     automatically adjust for DST.
         *
         *     Args:
         *         cron (str): a valid cron string
         *         timezone (str): a valid timezone string in IANA tzdata format (for example,
         *             America/New_York).
         *         day_or (bool, optional): Control how croniter handles `day` and `day_of_week`
         *             entries. Defaults to True, matching cron which connects those values using
         *             OR. If the switch is set to False, the values are connected using AND. This
         *             behaves like fcron and enables you to e.g. define a job that executes each
         *             2nd friday of a month by setting the days of month and the weekday.
         */
        CronSchedule: {
            /**
             * Cron
             * @example 0 0 * * *
             */
            cron: string;
            /**
             * Timezone
             * @example America/New_York
             */
            timezone?: string | null;
            /**
             * Day Or
             * @description Control croniter behavior for handling day and day_of_week entries.
             * @default true
             */
            day_or: boolean;
        };
        /** CsrfToken */
        CsrfToken: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Token
             * @description The CSRF token
             */
            token: string;
            /**
             * Client
             * @description The client id associated with the CSRF token
             */
            client: string;
            /**
             * Expiration
             * Format: date-time
             * @description The expiration time of the CSRF token
             */
            expiration: string;
        };
        /** DependencyResult */
        DependencyResult: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Name */
            name: string;
            /** Upstream Dependencies */
            upstream_dependencies: components["schemas"]["TaskRunResult"][];
            state: components["schemas"]["State"] | null;
            /** Expected Start Time */
            expected_start_time: string | null;
            /** Start Time */
            start_time: string | null;
            /** End Time */
            end_time: string | null;
            /** Total Run Time */
            total_run_time: number | null;
            /** Estimated Run Time */
            estimated_run_time: number | null;
            /** Untrackable Result */
            untrackable_result: boolean;
        };
        /**
         * DeploymentCreate
         * @description Data used by the Prefect REST API to create a deployment.
         */
        DeploymentCreate: {
            /**
             * Name
             * @description The name of the deployment.
             * @example my-deployment
             */
            name: string;
            /**
             * Flow Id
             * Format: uuid
             * @description The ID of the flow associated with the deployment.
             */
            flow_id: string;
            /**
             * Paused
             * @description Whether or not the deployment is paused.
             * @default false
             */
            paused: boolean;
            /**
             * Schedules
             * @description A list of schedules for the deployment.
             */
            schedules?: components["schemas"]["DeploymentScheduleCreate"][];
            /**
             * Concurrency Limit
             * @description The deployment's concurrency limit.
             */
            concurrency_limit?: number | null;
            /** @description The deployment's concurrency options. */
            concurrency_options?: components["schemas"]["ConcurrencyOptions"] | null;
            /**
             * Global Concurrency Limit Id
             * @description The ID of the global concurrency limit to apply to the deployment.
             */
            global_concurrency_limit_id?: string | null;
            /**
             * Enforce Parameter Schema
             * @description Whether or not the deployment should enforce the parameter schema.
             * @default true
             */
            enforce_parameter_schema: boolean;
            /**
             * Parameter Openapi Schema
             * @description The parameter schema of the flow, including defaults.
             */
            parameter_openapi_schema?: {
                [key: string]: unknown;
            } | {
                [key: string]: unknown;
            } | null;
            /**
             * Parameters
             * @description Parameters for flow runs scheduled by the deployment.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Tags
             * @description A list of deployment tags.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /** Pull Steps */
            pull_steps?: {
                [key: string]: unknown;
            }[] | null;
            /** Work Queue Name */
            work_queue_name?: string | null;
            /**
             * Work Pool Name
             * @description The name of the deployment's work pool.
             * @example my-work-pool
             */
            work_pool_name?: string | null;
            /** Storage Document Id */
            storage_document_id?: string | null;
            /** Infrastructure Document Id */
            infrastructure_document_id?: string | null;
            /** Description */
            description?: string | null;
            /** Path */
            path?: string | null;
            /** Version */
            version?: string | null;
            /** Entrypoint */
            entrypoint?: string | null;
            /**
             * Job Variables
             * @description Overrides for the flow's infrastructure configuration.
             */
            job_variables?: {
                [key: string]: unknown;
            };
            /** @description A description of this version of the deployment. */
            version_info?: components["schemas"]["VersionInfo"] | null;
        };
        /**
         * DeploymentFilter
         * @description Filter for deployments. Only deployments matching all criteria will be returned.
         */
        DeploymentFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Deployment.id` */
            id?: components["schemas"]["DeploymentFilterId"] | null;
            /** @description Filter criteria for `Deployment.name` */
            name?: components["schemas"]["DeploymentFilterName"] | null;
            /** @description Filter criteria for `Deployment.name` or `Flow.name` */
            flow_or_deployment_name?: components["schemas"]["DeploymentOrFlowNameFilter"] | null;
            /** @description Filter criteria for `Deployment.paused` */
            paused?: components["schemas"]["DeploymentFilterPaused"] | null;
            /** @description Filter criteria for `Deployment.tags` */
            tags?: components["schemas"]["DeploymentFilterTags"] | null;
            /** @description Filter criteria for `Deployment.work_queue_name` */
            work_queue_name?: components["schemas"]["DeploymentFilterWorkQueueName"] | null;
            /**
             * @deprecated
             * @description DEPRECATED: Prefer `Deployment.concurrency_limit_id` over `Deployment.concurrency_limit`. If provided, will be ignored for backwards-compatibility. Will be removed after December 2024.
             */
            concurrency_limit?: components["schemas"]["DeploymentFilterConcurrencyLimit"] | null;
        };
        /**
         * DeploymentFilterConcurrencyLimit
         * @description DEPRECATED: Prefer `Deployment.concurrency_limit_id` over `Deployment.concurrency_limit`.
         */
        DeploymentFilterConcurrencyLimit: {
            /**
             * Ge
             * @description Only include deployments with a concurrency limit greater than or equal to this value
             */
            ge_?: number | null;
            /**
             * Le
             * @description Only include deployments with a concurrency limit less than or equal to this value
             */
            le_?: number | null;
            /**
             * Is Null
             * @description If true, only include deployments without a concurrency limit
             */
            is_null_?: boolean | null;
        };
        /**
         * DeploymentFilterId
         * @description Filter by `Deployment.id`.
         */
        DeploymentFilterId: {
            /**
             * Any
             * @description A list of deployment ids to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of deployment ids to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * DeploymentFilterName
         * @description Filter by `Deployment.name`.
         */
        DeploymentFilterName: {
            /**
             * Any
             * @description A list of deployment names to include
             * @example [
             *       "my-deployment-1",
             *       "my-deployment-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A case-insensitive partial match. For example,  passing 'marvin' will match 'marvin', 'sad-Marvin', and 'marvin-robot'.
             * @example marvin
             */
            like_?: string | null;
        };
        /**
         * DeploymentFilterPaused
         * @description Filter by `Deployment.paused`.
         */
        DeploymentFilterPaused: {
            /**
             * Eq
             * @description Only returns where deployment is/is not paused
             */
            eq_?: boolean | null;
        };
        /**
         * DeploymentFilterTags
         * @description Filter by `Deployment.tags`.
         */
        DeploymentFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Deployments will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Any
             * @description A list of tags to include
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include deployments without tags
             */
            is_null_?: boolean | null;
        };
        /**
         * DeploymentFilterWorkQueueName
         * @description Filter by `Deployment.work_queue_name`.
         */
        DeploymentFilterWorkQueueName: {
            /**
             * Any
             * @description A list of work queue names to include
             * @example [
             *       "work_queue_1",
             *       "work_queue_2"
             *     ]
             */
            any_?: string[] | null;
        };
        /**
         * DeploymentFlowRunCreate
         * @description Data used by the Prefect REST API to create a flow run from a deployment.
         */
        DeploymentFlowRunCreate: {
            /** @description The state of the flow run to create */
            state?: components["schemas"]["StateCreate"] | null;
            /**
             * Name
             * @description The name of the flow run. Defaults to a random slug if not specified.
             * @example my-flow-run
             */
            name?: string;
            /** Parameters */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Enforce Parameter Schema
             * @description Whether or not to enforce the parameter schema on this run.
             */
            enforce_parameter_schema?: boolean | null;
            /** Context */
            context?: {
                [key: string]: unknown;
            };
            /** Infrastructure Document Id */
            infrastructure_document_id?: string | null;
            /** @description The empirical policy for the flow run. */
            empirical_policy?: components["schemas"]["FlowRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the flow run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Idempotency Key
             * @description An optional idempotency key. If a flow run with the same idempotency key has already been created, the existing flow run will be returned.
             */
            idempotency_key?: string | null;
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /** Parent Task Run Id */
            parent_task_run_id?: string | null;
            /** Work Queue Name */
            work_queue_name?: string | null;
            /** Job Variables */
            job_variables?: {
                [key: string]: unknown;
            } | {
                [key: string]: unknown;
            } | null;
        };
        /**
         * DeploymentOrFlowNameFilter
         * @description Filter by `Deployment.name` or `Flow.name` with a single input string for ilike filtering.
         */
        DeploymentOrFlowNameFilter: {
            /**
             * Like
             * @description A case-insensitive partial match on deployment or flow names. For example, passing 'example' might match deployments or flows with 'example' in their names.
             */
            like_?: string | null;
        };
        /** DeploymentPaginationResponse */
        DeploymentPaginationResponse: {
            /** Results */
            results: components["schemas"]["DeploymentResponse"][];
            /** Count */
            count: number;
            /** Limit */
            limit: number;
            /** Pages */
            pages: number;
            /** Page */
            page: number;
        };
        /** DeploymentResponse */
        DeploymentResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the deployment.
             */
            name: string;
            /**
             * Version
             * @description An optional version for the deployment.
             */
            version?: string | null;
            /**
             * Description
             * @description A description for the deployment.
             */
            description?: string | null;
            /**
             * Flow Id
             * Format: uuid
             * @description The flow id associated with the deployment.
             */
            flow_id: string;
            /**
             * Paused
             * @description Whether or not the deployment is paused.
             * @default false
             */
            paused: boolean;
            /**
             * Schedules
             * @description A list of schedules for the deployment.
             */
            schedules?: components["schemas"]["DeploymentSchedule"][];
            /**
             * Concurrency Limit
             * @deprecated
             * @description DEPRECATED: Prefer `global_concurrency_limit`. Will always be None for backwards compatibility. Will be removed after December 2024.
             */
            concurrency_limit?: number | null;
            /** @description The global concurrency limit object for enforcing the maximum number of flow runs that can be active at once. */
            global_concurrency_limit?: components["schemas"]["GlobalConcurrencyLimitResponse"] | null;
            /** @description The concurrency options for the deployment. */
            concurrency_options?: components["schemas"]["ConcurrencyOptions"] | null;
            /**
             * Job Variables
             * @description Overrides to apply to the base infrastructure block at runtime.
             */
            job_variables?: {
                [key: string]: unknown;
            };
            /**
             * Parameters
             * @description Parameters for flow runs scheduled by the deployment.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Tags
             * @description A list of tags for the deployment
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            };
            /**
             * Work Queue Name
             * @description The work queue for the deployment. If no work queue is set, work will not be scheduled.
             */
            work_queue_name?: string | null;
            /**
             * Work Queue Id
             * @description The id of the work pool queue to which this deployment is assigned.
             */
            work_queue_id?: string | null;
            /**
             * Last Polled
             * @description The last time the deployment was polled for status updates.
             */
            last_polled?: string | null;
            /**
             * Parameter Openapi Schema
             * @description The parameter schema of the flow, including defaults.
             */
            parameter_openapi_schema?: {
                [key: string]: unknown;
            } | {
                [key: string]: unknown;
            } | null;
            /**
             * Path
             * @description The path to the working directory for the workflow, relative to remote storage or an absolute path.
             */
            path?: string | null;
            /**
             * Pull Steps
             * @description Pull steps for cloning and running this deployment.
             */
            pull_steps?: {
                [key: string]: unknown;
            }[] | null;
            /**
             * Entrypoint
             * @description The path to the entrypoint for the workflow, relative to the `path`.
             */
            entrypoint?: string | null;
            /**
             * Storage Document Id
             * @description The block document defining storage used for this flow.
             */
            storage_document_id?: string | null;
            /**
             * Infrastructure Document Id
             * @description The block document defining infrastructure to use for flow runs.
             */
            infrastructure_document_id?: string | null;
            /** @description Optional information about the creator of this deployment. */
            created_by?: components["schemas"]["CreatedBy"] | null;
            /** @description Optional information about the updater of this deployment. */
            updated_by?: components["schemas"]["UpdatedBy"] | null;
            /**
             * Work Pool Name
             * @description The name of the deployment's work pool.
             */
            work_pool_name?: string | null;
            /**
             * @description Whether the deployment is ready to run flows.
             * @default NOT_READY
             */
            status: components["schemas"]["DeploymentStatus"] | null;
            /**
             * Enforce Parameter Schema
             * @description Whether or not the deployment should enforce the parameter schema.
             * @default true
             */
            enforce_parameter_schema: boolean;
        };
        /** DeploymentSchedule */
        DeploymentSchedule: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Deployment Id
             * @description The deployment id associated with this schedule.
             */
            deployment_id?: string | null;
            /**
             * Schedule
             * @description The schedule for the deployment.
             */
            schedule: components["schemas"]["IntervalSchedule"] | components["schemas"]["CronSchedule"] | components["schemas"]["RRuleSchedule"];
            /**
             * Active
             * @description Whether or not the schedule is active.
             * @default true
             */
            active: boolean;
            /**
             * Max Scheduled Runs
             * @description The maximum number of scheduled runs for the schedule.
             */
            max_scheduled_runs?: number | null;
            /**
             * Parameters
             * @description A dictionary of parameter value overrides.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Slug
             * @description A unique slug for the schedule.
             */
            slug?: string | null;
        };
        /** DeploymentScheduleCreate */
        DeploymentScheduleCreate: {
            /**
             * Active
             * @description Whether or not the schedule is active.
             * @default true
             */
            active: boolean;
            /**
             * Schedule
             * @description The schedule for the deployment.
             */
            schedule: components["schemas"]["IntervalSchedule"] | components["schemas"]["CronSchedule"] | components["schemas"]["RRuleSchedule"];
            /**
             * Max Scheduled Runs
             * @description The maximum number of scheduled runs for the schedule.
             */
            max_scheduled_runs?: number | null;
            /**
             * Parameters
             * @description A dictionary of parameter value overrides.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Slug
             * @description A unique identifier for the schedule.
             */
            slug?: string | null;
        };
        /** DeploymentScheduleUpdate */
        DeploymentScheduleUpdate: {
            /**
             * Active
             * @description Whether or not the schedule is active.
             */
            active?: boolean | null;
            /**
             * Schedule
             * @description The schedule for the deployment.
             */
            schedule?: components["schemas"]["IntervalSchedule"] | components["schemas"]["CronSchedule"] | components["schemas"]["RRuleSchedule"] | null;
            /**
             * Max Scheduled Runs
             * @description The maximum number of scheduled runs for the schedule.
             */
            max_scheduled_runs?: number | null;
            /**
             * Parameters
             * @description A dictionary of parameter value overrides.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Slug
             * @description A unique identifier for the schedule.
             */
            slug?: string | null;
        };
        /**
         * DeploymentSort
         * @description Defines deployment sorting options.
         * @enum {string}
         */
        DeploymentSort: "CREATED_DESC" | "UPDATED_DESC" | "NAME_ASC" | "NAME_DESC";
        /**
         * DeploymentStatus
         * @description Enumeration of deployment statuses.
         * @enum {string}
         */
        DeploymentStatus: "READY" | "NOT_READY";
        /**
         * DeploymentUpdate
         * @description Data used by the Prefect REST API to update a deployment.
         */
        DeploymentUpdate: {
            /** Version */
            version?: string | null;
            /** Description */
            description?: string | null;
            /**
             * Paused
             * @description Whether or not the deployment is paused.
             * @default false
             */
            paused: boolean;
            /**
             * Schedules
             * @description A list of schedules for the deployment.
             */
            schedules?: components["schemas"]["DeploymentScheduleUpdate"][];
            /**
             * Concurrency Limit
             * @description The deployment's concurrency limit.
             */
            concurrency_limit?: number | null;
            /** @description The deployment's concurrency options. */
            concurrency_options?: components["schemas"]["ConcurrencyOptions"] | null;
            /**
             * Global Concurrency Limit Id
             * @description The ID of the global concurrency limit to apply to the deployment.
             */
            global_concurrency_limit_id?: string | null;
            /**
             * Parameters
             * @description Parameters for flow runs scheduled by the deployment.
             */
            parameters?: {
                [key: string]: unknown;
            } | null;
            /**
             * Parameter Openapi Schema
             * @description The parameter schema of the flow, including defaults.
             */
            parameter_openapi_schema?: {
                [key: string]: unknown;
            } | null;
            /**
             * Tags
             * @description A list of deployment tags.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /** Work Queue Name */
            work_queue_name?: string | null;
            /**
             * Work Pool Name
             * @description The name of the deployment's work pool.
             * @example my-work-pool
             */
            work_pool_name?: string | null;
            /** Path */
            path?: string | null;
            /**
             * Job Variables
             * @description Overrides for the flow's infrastructure configuration.
             */
            job_variables?: {
                [key: string]: unknown;
            } | null;
            /** Pull Steps */
            pull_steps?: {
                [key: string]: unknown;
            }[] | null;
            /** Entrypoint */
            entrypoint?: string | null;
            /** Storage Document Id */
            storage_document_id?: string | null;
            /** Infrastructure Document Id */
            infrastructure_document_id?: string | null;
            /**
             * Enforce Parameter Schema
             * @description Whether or not the deployment should enforce the parameter schema.
             */
            enforce_parameter_schema?: boolean | null;
            /** @description A description of this version of the deployment. */
            version_info?: components["schemas"]["VersionInfo"] | null;
        };
        /**
         * DeploymentsSettings
         * @description Settings for configuring deployments defaults
         */
        DeploymentsSettings: {
            /**
             * Default Work Pool Name
             * @description The default work pool to use when creating deployments.
             */
            default_work_pool_name?: string | null;
            /**
             * Default Docker Build Namespace
             * @description The default Docker namespace to use when building images.
             * @example my-dockerhub-registry
             * @example 4999999999999.dkr.ecr.us-east-2.amazonaws.com/my-ecr-repo
             */
            default_docker_build_namespace?: string | null;
        };
        /**
         * DoNothing
         * @description Do nothing when an Automation is triggered
         */
        DoNothing: {
            /**
             * Type
             * @default do-nothing
             * @constant
             */
            type: "do-nothing";
        };
        /** Edge */
        Edge: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
        };
        /**
         * Event
         * @description The client-side view of an event that has happened to a Resource
         */
        Event: {
            /**
             * Occurred
             * Format: date-time
             * @description When the event happened from the sender's perspective
             */
            occurred: string;
            /**
             * Event
             * @description The name of the event that happened
             */
            event: string;
            /** @description The primary Resource this event concerns */
            resource: components["schemas"]["Resource"];
            /**
             * Related
             * @description A list of additional Resources involved in this event
             */
            related?: components["schemas"]["RelatedResource"][];
            /**
             * Payload
             * @description An open-ended set of data describing what happened
             */
            payload?: {
                [key: string]: unknown;
            };
            /**
             * Id
             * Format: uuid
             * @description The client-provided identifier of this event
             */
            id: string;
            /**
             * Follows
             * @description The ID of an event that is known to have occurred prior to this one. If set, this may be used to establish a more precise ordering of causally-related events when they occur close enough together in time that the system may receive them out-of-order.
             */
            follows?: string | null;
        };
        /** EventAnyResourceFilter */
        EventAnyResourceFilter: {
            /**
             * Id
             * @description Only include events for resources with these IDs
             */
            id?: string[] | null;
            /**
             * Id Prefix
             * @description Only include events for resources with IDs starting with these prefixes
             */
            id_prefix?: string[] | null;
            /** @description Only include events for related resources with these labels */
            labels?: components["schemas"]["ResourceSpecification"] | null;
        };
        /**
         * EventCount
         * @description The count of events with the given filter value
         */
        EventCount: {
            /**
             * Value
             * @description The value to use for filtering
             */
            value: string;
            /**
             * Label
             * @description The value to display for this count
             */
            label: string;
            /**
             * Count
             * @description The count of matching events
             */
            count: number;
            /**
             * Start Time
             * Format: date-time
             * @description The start time of this group of events
             */
            start_time: string;
            /**
             * End Time
             * Format: date-time
             * @description The end time of this group of events
             */
            end_time: string;
        };
        /** EventFilter */
        EventFilter: {
            /** @description Filter criteria for when the events occurred */
            occurred?: components["schemas"]["EventOccurredFilter"];
            /** @description Filter criteria for the event name */
            event?: components["schemas"]["EventNameFilter"] | null;
            /** @description Filter criteria for the resource of the event */
            resource?: components["schemas"]["EventResourceFilter"] | null;
            /**
             * Related
             * @description Filter criteria for the related resources of the event
             */
            related?: components["schemas"]["EventRelatedFilter"] | components["schemas"]["EventRelatedFilter"][] | null;
            /**
             * Any Resource
             * @description Filter criteria for any resource involved in the event
             */
            any_resource?: components["schemas"]["EventAnyResourceFilter"] | components["schemas"]["EventAnyResourceFilter"][] | null;
            /** @description Filter criteria for the events' ID */
            id?: components["schemas"]["EventIDFilter"];
            /** @description Filter criteria for text search across event content */
            text?: components["schemas"]["EventTextFilter"] | null;
            /**
             * @description The order to return filtered events
             * @default DESC
             */
            order: components["schemas"]["EventOrder"];
        };
        /** EventIDFilter */
        EventIDFilter: {
            /**
             * Id
             * @description Only include events with one of these IDs
             */
            id?: string[] | null;
        };
        /** EventNameFilter */
        EventNameFilter: {
            /**
             * Prefix
             * @description Only include events matching one of these prefixes
             */
            prefix?: string[] | null;
            /**
             * Exclude Prefix
             * @description Exclude events matching one of these prefixes
             */
            exclude_prefix?: string[] | null;
            /**
             * Name
             * @description Only include events matching one of these names exactly
             */
            name?: string[] | null;
            /**
             * Exclude Name
             * @description Exclude events matching one of these names exactly
             */
            exclude_name?: string[] | null;
        };
        /** EventOccurredFilter */
        EventOccurredFilter: {
            /**
             * Since
             * Format: date-time
             * @description Only include events after this time (inclusive)
             */
            since?: string;
            /**
             * Until
             * Format: date-time
             * @description Only include events prior to this time (inclusive)
             */
            until?: string;
        };
        /**
         * EventOrder
         * @enum {string}
         */
        EventOrder: "ASC" | "DESC";
        /**
         * EventPage
         * @description A single page of events returned from the API, with an optional link to the
         *     next page of results
         */
        EventPage: {
            /**
             * Events
             * @description The Events matching the query
             */
            events: components["schemas"]["ReceivedEvent"][];
            /**
             * Total
             * @description The total number of matching Events
             */
            total: number;
            /**
             * Next Page
             * @description The URL for the next page of results, if there are more
             */
            next_page: string | null;
        };
        /** EventRelatedFilter */
        EventRelatedFilter: {
            /**
             * Id
             * @description Only include events for related resources with these IDs
             */
            id?: string[] | null;
            /**
             * Role
             * @description Only include events for related resources in these roles
             */
            role?: string[] | null;
            /**
             * Resources In Roles
             * @description Only include events with specific related resources in specific roles
             */
            resources_in_roles?: [
                string,
                string
            ][] | null;
            /** @description Only include events for related resources with these labels */
            labels?: components["schemas"]["ResourceSpecification"] | null;
        };
        /** EventResourceFilter */
        EventResourceFilter: {
            /**
             * Id
             * @description Only include events for resources with these IDs
             */
            id?: string[] | null;
            /**
             * Id Prefix
             * @description Only include events for resources with IDs starting with these prefixes.
             */
            id_prefix?: string[] | null;
            /** @description Only include events for resources with these labels */
            labels?: components["schemas"]["ResourceSpecification"] | null;
            /**
             * Distinct
             * @description Only include events for distinct resources
             * @default false
             */
            distinct: boolean;
        };
        /**
         * EventTextFilter
         * @description Filter by text search across event content.
         */
        EventTextFilter: {
            /**
             * Query
             * @description Text search query string
             * @example error
             * @example error -debug
             * @example "connection timeout"
             * @example +required -excluded
             */
            query: string;
        };
        /**
         * EventTrigger
         * @description A trigger that fires based on the presence or absence of events within a given
         *     period of time.
         */
        EventTrigger: {
            /**
             * Type
             * @default event
             * @constant
             */
            type: "event";
            /**
             * Id
             * Format: uuid
             * @description The unique ID of this trigger
             */
            id?: string;
            /** @description Labels for resources which this trigger will match. */
            match?: components["schemas"]["ResourceSpecification"];
            /**
             * Match Related
             * @description Labels for related resources which this trigger will match.
             */
            match_related?: components["schemas"]["ResourceSpecification"] | components["schemas"]["ResourceSpecification"][];
            /**
             * After
             * @description The event(s) which must first been seen to fire this trigger.  If empty, then fire this trigger immediately.  Events may include trailing wildcards, like `prefect.flow-run.*`
             */
            after?: string[];
            /**
             * Expect
             * @description The event(s) this trigger is expecting to see.  If empty, this trigger will match any event.  Events may include trailing wildcards, like `prefect.flow-run.*`
             */
            expect?: string[];
            /**
             * For Each
             * @description Evaluate the trigger separately for each distinct value of these labels on the resource.  By default, labels refer to the primary resource of the triggering event.  You may also refer to labels from related resources by specifying `related:<role>:<label>`.  This will use the value of that label for the first related resource in that role.  For example, `"for_each": ["related:flow:prefect.resource.id"]` would evaluate the trigger for each flow.
             */
            for_each?: string[];
            /**
             * Posture
             * @description The posture of this trigger, either Reactive or Proactive.  Reactive triggers respond to the _presence_ of the expected events, while Proactive triggers respond to the _absence_ of those expected events.
             * @enum {string}
             */
            posture: "Reactive" | "Proactive";
            /**
             * Threshold
             * @description The number of events required for this trigger to fire (for Reactive triggers), or the number of events expected (for Proactive triggers)
             * @default 1
             */
            threshold: number;
            /**
             * Within
             * @description The time period over which the events must occur.  For Reactive triggers, this may be as low as 0 seconds, but must be at least 10 seconds for Proactive triggers
             * @default 0
             */
            within: number;
        };
        /**
         * ExperimentsSettings
         * @description Settings for configuring experimental features
         */
        ExperimentsSettings: {
            /**
             * Warn
             * @description If `True`, warn on usage of experimental features.
             * @default true
             */
            warn: boolean;
            /** @description Settings for the experimental plugin system */
            plugins?: components["schemas"]["PluginsSettings"];
        };
        /**
         * Flow
         * @description An ORM representation of flow data.
         */
        Flow: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the flow
             * @example my-flow
             */
            name: string;
            /**
             * Tags
             * @description A list of flow tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
        };
        /**
         * FlowCreate
         * @description Data used by the Prefect REST API to create a flow.
         */
        FlowCreate: {
            /**
             * Name
             * @description The name of the flow
             * @example my-flow
             */
            name: string;
            /**
             * Tags
             * @description A list of flow tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
        };
        /**
         * FlowFilter
         * @description Filter for flows. Only flows matching all criteria will be returned.
         */
        FlowFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Flow.id` */
            id?: components["schemas"]["FlowFilterId"] | null;
            /** @description Filter criteria for Flow deployments */
            deployment?: components["schemas"]["FlowFilterDeployment"] | null;
            /** @description Filter criteria for `Flow.name` */
            name?: components["schemas"]["FlowFilterName"] | null;
            /** @description Filter criteria for `Flow.tags` */
            tags?: components["schemas"]["FlowFilterTags"] | null;
        };
        /**
         * FlowFilterDeployment
         * @description Filter by flows by deployment
         */
        FlowFilterDeployment: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Is Null
             * @description If true, only include flows without deployments
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowFilterId
         * @description Filter by `Flow.id`.
         */
        FlowFilterId: {
            /**
             * Any
             * @description A list of flow ids to include
             */
            any_?: string[] | null;
        };
        /**
         * FlowFilterName
         * @description Filter by `Flow.name`.
         */
        FlowFilterName: {
            /**
             * Any
             * @description A list of flow names to include
             * @example [
             *       "my-flow-1",
             *       "my-flow-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A case-insensitive partial match. For example,  passing 'marvin' will match 'marvin', 'sad-Marvin', and 'marvin-robot'.
             * @example marvin
             */
            like_?: string | null;
        };
        /**
         * FlowFilterTags
         * @description Filter by `Flow.tags`.
         */
        FlowFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Flows will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include flows without tags
             */
            is_null_?: boolean | null;
        };
        /** FlowPaginationResponse */
        FlowPaginationResponse: {
            /** Results */
            results: components["schemas"]["Flow"][];
            /** Count */
            count: number;
            /** Limit */
            limit: number;
            /** Pages */
            pages: number;
            /** Page */
            page: number;
        };
        /**
         * FlowRun
         * @description An ORM representation of flow run data.
         */
        FlowRun: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the flow run. Defaults to a random slug if not specified.
             * @example my-flow-run
             */
            name?: string;
            /**
             * Flow Id
             * Format: uuid
             * @description The id of the flow being run.
             */
            flow_id: string;
            /**
             * State Id
             * @description The id of the flow run's current state.
             */
            state_id?: string | null;
            /**
             * Deployment Id
             * @description The id of the deployment associated with this flow run, if available.
             */
            deployment_id?: string | null;
            /**
             * Deployment Version
             * @description The version of the deployment associated with this flow run.
             * @example 1.0
             */
            deployment_version?: string | null;
            /**
             * Work Queue Name
             * @description The work queue that handled this flow run.
             */
            work_queue_name?: string | null;
            /**
             * Flow Version
             * @description The version of the flow executed in this flow run.
             * @example 1.0
             */
            flow_version?: string | null;
            /**
             * Parameters
             * @description Parameters for the flow run.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Idempotency Key
             * @description An optional idempotency key for the flow run. Used to ensure the same flow run is not created multiple times.
             */
            idempotency_key?: string | null;
            /**
             * Context
             * @description Additional context for the flow run.
             * @example {
             *       "my_var": "my_value"
             *     }
             */
            context?: {
                [key: string]: unknown;
            };
            empirical_policy?: components["schemas"]["FlowRunPolicy"];
            /**
             * Tags
             * @description A list of tags on the flow run
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /**
             * Parent Task Run Id
             * @description If the flow run is a subflow, the id of the 'dummy' task in the parent flow used to track subflow state.
             */
            parent_task_run_id?: string | null;
            /** @description The type of the current flow run state. */
            state_type?: components["schemas"]["StateType"] | null;
            /**
             * State Name
             * @description The name of the current flow run state.
             */
            state_name?: string | null;
            /**
             * Run Count
             * @description The number of times the flow run was executed.
             * @default 0
             */
            run_count: number;
            /**
             * Expected Start Time
             * @description The flow run's expected start time.
             */
            expected_start_time?: string | null;
            /**
             * Next Scheduled Start Time
             * @description The next time the flow run is scheduled to start.
             */
            next_scheduled_start_time?: string | null;
            /**
             * Start Time
             * @description The actual start time.
             */
            start_time?: string | null;
            /**
             * End Time
             * @description The actual end time.
             */
            end_time?: string | null;
            /**
             * Total Run Time
             * @description Total run time. If the flow run was executed multiple times, the time of each run will be summed.
             * @default 0
             */
            total_run_time: number;
            /**
             * Estimated Run Time
             * @description A real-time estimate of the total run time.
             * @default 0
             */
            estimated_run_time: number;
            /**
             * Estimated Start Time Delta
             * @description The difference between actual and expected start time.
             * @default 0
             */
            estimated_start_time_delta: number;
            /**
             * Auto Scheduled
             * @description Whether or not the flow run was automatically scheduled.
             * @default false
             */
            auto_scheduled: boolean;
            /**
             * Infrastructure Document Id
             * @description The block document defining infrastructure to use this flow run.
             */
            infrastructure_document_id?: string | null;
            /**
             * Infrastructure Pid
             * @description The id of the flow run as returned by an infrastructure block.
             */
            infrastructure_pid?: string | null;
            /** @description Optional information about the creator of this flow run. */
            created_by?: components["schemas"]["CreatedBy"] | null;
            /**
             * Work Queue Id
             * @description The id of the run's work pool queue.
             */
            work_queue_id?: string | null;
            /** @description The current state of the flow run. */
            state?: components["schemas"]["State"] | null;
            /**
             * Job Variables
             * @description Variables used as overrides in the base job template
             */
            job_variables?: {
                [key: string]: unknown;
            } | null;
        };
        /**
         * FlowRunCreate
         * @description Data used by the Prefect REST API to create a flow run.
         */
        FlowRunCreate: {
            /** @description The state of the flow run to create */
            state?: components["schemas"]["StateCreate"] | null;
            /**
             * Name
             * @description The name of the flow run. Defaults to a random slug if not specified.
             * @example my-flow-run
             */
            name?: string;
            /**
             * Flow Id
             * Format: uuid
             * @description The id of the flow being run.
             */
            flow_id: string;
            /**
             * Flow Version
             * @description The version of the flow being run.
             */
            flow_version?: string | null;
            /** Parameters */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Context
             * @description The context of the flow run.
             */
            context?: {
                [key: string]: unknown;
            };
            /** Parent Task Run Id */
            parent_task_run_id?: string | null;
            /** Infrastructure Document Id */
            infrastructure_document_id?: string | null;
            /** @description The empirical policy for the flow run. */
            empirical_policy?: components["schemas"]["FlowRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the flow run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /**
             * Idempotency Key
             * @description An optional idempotency key. If a flow run with the same idempotency key has already been created, the existing flow run will be returned.
             */
            idempotency_key?: string | null;
            /**
             * Work Pool Name
             * @description The name of the work pool to run the flow run in.
             */
            work_pool_name?: string | null;
            /**
             * Work Queue Name
             * @description The name of the work queue to place the flow run in.
             */
            work_queue_name?: string | null;
            /**
             * Job Variables
             * @description The job variables to use when setting up flow run infrastructure.
             */
            job_variables?: {
                [key: string]: unknown;
            } | null;
            /**
             * Deployment Id
             * @deprecated
             * @description DEPRECATED: The id of the deployment associated with this flow run, if available.
             */
            deployment_id?: string | null;
        };
        /**
         * FlowRunFilter
         * @description Filter flow runs. Only flow runs matching all criteria will be returned
         */
        FlowRunFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `FlowRun.id` */
            id?: components["schemas"]["FlowRunFilterId"] | null;
            /** @description Filter criteria for `FlowRun.name` */
            name?: components["schemas"]["FlowRunFilterName"] | null;
            /** @description Filter criteria for `FlowRun.tags` */
            tags?: components["schemas"]["FlowRunFilterTags"] | null;
            /** @description Filter criteria for `FlowRun.deployment_id` */
            deployment_id?: components["schemas"]["FlowRunFilterDeploymentId"] | null;
            /** @description Filter criteria for `FlowRun.work_queue_name */
            work_queue_name?: components["schemas"]["FlowRunFilterWorkQueueName"] | null;
            /** @description Filter criteria for `FlowRun.state` */
            state?: components["schemas"]["FlowRunFilterState"] | null;
            /** @description Filter criteria for `FlowRun.flow_version` */
            flow_version?: components["schemas"]["FlowRunFilterFlowVersion"] | null;
            /** @description Filter criteria for `FlowRun.start_time` */
            start_time?: components["schemas"]["FlowRunFilterStartTime"] | null;
            /** @description Filter criteria for `FlowRun.end_time` */
            end_time?: components["schemas"]["FlowRunFilterEndTime"] | null;
            /** @description Filter criteria for `FlowRun.expected_start_time` */
            expected_start_time?: components["schemas"]["FlowRunFilterExpectedStartTime"] | null;
            /** @description Filter criteria for `FlowRun.next_scheduled_start_time` */
            next_scheduled_start_time?: components["schemas"]["FlowRunFilterNextScheduledStartTime"] | null;
            /** @description Filter criteria for subflows of the given flow runs */
            parent_flow_run_id?: components["schemas"]["FlowRunFilterParentFlowRunId"] | null;
            /** @description Filter criteria for `FlowRun.parent_task_run_id` */
            parent_task_run_id?: components["schemas"]["FlowRunFilterParentTaskRunId"] | null;
            /** @description Filter criteria for `FlowRun.idempotency_key` */
            idempotency_key?: components["schemas"]["FlowRunFilterIdempotencyKey"] | null;
        };
        /**
         * FlowRunFilterDeploymentId
         * @description Filter by `FlowRun.deployment_id`.
         */
        FlowRunFilterDeploymentId: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Any
             * @description A list of flow run deployment ids to include
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include flow runs without deployment ids
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowRunFilterEndTime
         * @description Filter by `FlowRun.end_time`.
         */
        FlowRunFilterEndTime: {
            /**
             * Before
             * @description Only include flow runs ending at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include flow runs ending at or after this time
             */
            after_?: string | null;
            /**
             * Is Null
             * @description If true, only return flow runs without an end time
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowRunFilterExpectedStartTime
         * @description Filter by `FlowRun.expected_start_time`.
         */
        FlowRunFilterExpectedStartTime: {
            /**
             * Before
             * @description Only include flow runs scheduled to start at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include flow runs scheduled to start at or after this time
             */
            after_?: string | null;
        };
        /**
         * FlowRunFilterFlowVersion
         * @description Filter by `FlowRun.flow_version`.
         */
        FlowRunFilterFlowVersion: {
            /**
             * Any
             * @description A list of flow run flow_versions to include
             */
            any_?: string[] | null;
        };
        /**
         * FlowRunFilterId
         * @description Filter by `FlowRun.id`.
         */
        FlowRunFilterId: {
            /**
             * Any
             * @description A list of flow run ids to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of flow run ids to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * FlowRunFilterIdempotencyKey
         * @description Filter by FlowRun.idempotency_key.
         */
        FlowRunFilterIdempotencyKey: {
            /**
             * Any
             * @description A list of flow run idempotency keys to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of flow run idempotency keys to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * FlowRunFilterName
         * @description Filter by `FlowRun.name`.
         */
        FlowRunFilterName: {
            /**
             * Any
             * @description A list of flow run names to include
             * @example [
             *       "my-flow-run-1",
             *       "my-flow-run-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A case-insensitive partial match. For example,  passing 'marvin' will match 'marvin', 'sad-Marvin', and 'marvin-robot'.
             * @example marvin
             */
            like_?: string | null;
        };
        /**
         * FlowRunFilterNextScheduledStartTime
         * @description Filter by `FlowRun.next_scheduled_start_time`.
         */
        FlowRunFilterNextScheduledStartTime: {
            /**
             * Before
             * @description Only include flow runs with a next_scheduled_start_time or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include flow runs with a next_scheduled_start_time at or after this time
             */
            after_?: string | null;
        };
        /**
         * FlowRunFilterParentFlowRunId
         * @description Filter for subflows of a given flow run
         */
        FlowRunFilterParentFlowRunId: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Any
             * @description A list of parent flow run ids to include
             */
            any_?: string[] | null;
        };
        /**
         * FlowRunFilterParentTaskRunId
         * @description Filter by `FlowRun.parent_task_run_id`.
         */
        FlowRunFilterParentTaskRunId: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Any
             * @description A list of flow run parent_task_run_ids to include
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include flow runs without parent_task_run_id
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowRunFilterStartTime
         * @description Filter by `FlowRun.start_time`.
         */
        FlowRunFilterStartTime: {
            /**
             * Before
             * @description Only include flow runs starting at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include flow runs starting at or after this time
             */
            after_?: string | null;
            /**
             * Is Null
             * @description If true, only return flow runs without a start time
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowRunFilterState
         * @description Filter by `FlowRun.state_type` and `FlowRun.state_name`.
         */
        FlowRunFilterState: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `FlowRun.state_type` */
            type?: components["schemas"]["FlowRunFilterStateType"] | null;
            /** @description Filter criteria for `FlowRun.state_name` */
            name?: components["schemas"]["FlowRunFilterStateName"] | null;
        };
        /**
         * FlowRunFilterStateName
         * @description Filter by `FlowRun.state_name`.
         */
        FlowRunFilterStateName: {
            /**
             * Any
             * @description A list of flow run state names to include
             */
            any_?: string[] | null;
            /**
             * Not Any
             * @description A list of flow run state names to exclude
             */
            not_any_?: string[] | null;
        };
        /**
         * FlowRunFilterStateType
         * @description Filter by `FlowRun.state_type`.
         */
        FlowRunFilterStateType: {
            /**
             * Any
             * @description A list of flow run state types to include
             */
            any_?: components["schemas"]["StateType"][] | null;
            /**
             * Not Any
             * @description A list of flow run state types to exclude
             */
            not_any_?: components["schemas"]["StateType"][] | null;
        };
        /**
         * FlowRunFilterTags
         * @description Filter by `FlowRun.tags`.
         */
        FlowRunFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Flow runs will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Any
             * @description A list of tags to include
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include flow runs without tags
             */
            is_null_?: boolean | null;
        };
        /**
         * FlowRunFilterWorkQueueName
         * @description Filter by `FlowRun.work_queue_name`.
         */
        FlowRunFilterWorkQueueName: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Any
             * @description A list of work queue names to include
             * @example [
             *       "work_queue_1",
             *       "work_queue_2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include flow runs without work queue names
             */
            is_null_?: boolean | null;
        };
        /** FlowRunInput */
        FlowRunInput: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Flow Run Id
             * Format: uuid
             * @description The flow run ID associated with the input.
             */
            flow_run_id: string;
            /**
             * Key
             * @description The key of the input.
             */
            key: string;
            /**
             * Value
             * @description The value of the input.
             */
            value: string;
            /**
             * Sender
             * @description The sender of the input.
             */
            sender?: string | null;
        };
        /** FlowRunPaginationResponse */
        FlowRunPaginationResponse: {
            /** Results */
            results: components["schemas"]["FlowRunResponse"][];
            /** Count */
            count: number;
            /** Limit */
            limit: number;
            /** Pages */
            pages: number;
            /** Page */
            page: number;
        };
        /**
         * FlowRunPolicy
         * @description Defines of how a flow run should retry.
         */
        FlowRunPolicy: {
            /**
             * Max Retries
             * @deprecated
             * @description The maximum number of retries. Field is not used. Please use `retries` instead.
             * @default 0
             */
            max_retries: number;
            /**
             * Retry Delay Seconds
             * @deprecated
             * @description The delay between retries. Field is not used. Please use `retry_delay` instead.
             * @default 0
             */
            retry_delay_seconds: number;
            /**
             * Retries
             * @description The number of retries.
             */
            retries?: number | null;
            /**
             * Retry Delay
             * @description The delay time between retries, in seconds.
             */
            retry_delay?: number | null;
            /**
             * Pause Keys
             * @description Tracks pauses this run has observed.
             */
            pause_keys?: string[] | null;
            /**
             * Resuming
             * @description Indicates if this run is resuming from a pause.
             * @default false
             */
            resuming: boolean | null;
            /**
             * Retry Type
             * @description The type of retry this run is undergoing.
             */
            retry_type?: ("in_process" | "reschedule") | null;
        };
        /** FlowRunResponse */
        FlowRunResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the flow run. Defaults to a random slug if not specified.
             * @example my-flow-run
             */
            name?: string;
            /**
             * Flow Id
             * Format: uuid
             * @description The id of the flow being run.
             */
            flow_id: string;
            /**
             * State Id
             * @description The id of the flow run's current state.
             */
            state_id?: string | null;
            /**
             * Deployment Id
             * @description The id of the deployment associated with this flow run, if available.
             */
            deployment_id?: string | null;
            /**
             * Deployment Version
             * @description The version of the deployment associated with this flow run.
             * @example 1.0
             */
            deployment_version?: string | null;
            /**
             * Work Queue Id
             * @description The id of the run's work pool queue.
             */
            work_queue_id?: string | null;
            /**
             * Work Queue Name
             * @description The work queue that handled this flow run.
             */
            work_queue_name?: string | null;
            /**
             * Flow Version
             * @description The version of the flow executed in this flow run.
             * @example 1.0
             */
            flow_version?: string | null;
            /**
             * Parameters
             * @description Parameters for the flow run.
             */
            parameters?: {
                [key: string]: unknown;
            };
            /**
             * Idempotency Key
             * @description An optional idempotency key for the flow run. Used to ensure the same flow run is not created multiple times.
             */
            idempotency_key?: string | null;
            /**
             * Context
             * @description Additional context for the flow run.
             * @example {
             *       "my_var": "my_val"
             *     }
             */
            context?: {
                [key: string]: unknown;
            };
            empirical_policy?: components["schemas"]["FlowRunPolicy"];
            /**
             * Tags
             * @description A list of tags on the flow run
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            };
            /**
             * Parent Task Run Id
             * @description If the flow run is a subflow, the id of the 'dummy' task in the parent flow used to track subflow state.
             */
            parent_task_run_id?: string | null;
            /** @description The type of the current flow run state. */
            state_type?: components["schemas"]["StateType"] | null;
            /**
             * State Name
             * @description The name of the current flow run state.
             */
            state_name?: string | null;
            /**
             * Run Count
             * @description The number of times the flow run was executed.
             * @default 0
             */
            run_count: number;
            /**
             * Expected Start Time
             * @description The flow run's expected start time.
             */
            expected_start_time?: string | null;
            /**
             * Next Scheduled Start Time
             * @description The next time the flow run is scheduled to start.
             */
            next_scheduled_start_time?: string | null;
            /**
             * Start Time
             * @description The actual start time.
             */
            start_time?: string | null;
            /**
             * End Time
             * @description The actual end time.
             */
            end_time?: string | null;
            /**
             * Total Run Time
             * @description Total run time. If the flow run was executed multiple times, the time of each run will be summed.
             * @default 0
             */
            total_run_time: number;
            /**
             * Estimated Run Time
             * @description A real-time estimate of the total run time.
             * @default 0
             */
            estimated_run_time: number;
            /**
             * Estimated Start Time Delta
             * @description The difference between actual and expected start time.
             * @default 0
             */
            estimated_start_time_delta: number;
            /**
             * Auto Scheduled
             * @description Whether or not the flow run was automatically scheduled.
             * @default false
             */
            auto_scheduled: boolean;
            /**
             * Infrastructure Document Id
             * @description The block document defining infrastructure to use this flow run.
             */
            infrastructure_document_id?: string | null;
            /**
             * Infrastructure Pid
             * @description The id of the flow run as returned by an infrastructure block.
             */
            infrastructure_pid?: string | null;
            /** @description Optional information about the creator of this flow run. */
            created_by?: components["schemas"]["CreatedBy"] | null;
            /**
             * Work Pool Id
             * @description The id of the flow run's work pool.
             */
            work_pool_id?: string | null;
            /**
             * Work Pool Name
             * @description The name of the flow run's work pool.
             * @example my-work-pool
             */
            work_pool_name?: string | null;
            /** @description The current state of the flow run. */
            state?: components["schemas"]["State"] | null;
            /**
             * Job Variables
             * @description Variables used as overrides in the base job template
             */
            job_variables?: {
                [key: string]: unknown;
            } | null;
        };
        /** FlowRunResult */
        FlowRunResult: {
            /**
             * Input Type
             * @default flow_run
             * @constant
             */
            input_type: "flow_run";
            /**
             * Id
             * Format: uuid
             */
            id: string;
        };
        /**
         * FlowRunSort
         * @description Defines flow run sorting options.
         * @enum {string}
         */
        FlowRunSort: "ID_DESC" | "START_TIME_ASC" | "START_TIME_DESC" | "EXPECTED_START_TIME_ASC" | "EXPECTED_START_TIME_DESC" | "NAME_ASC" | "NAME_DESC" | "NEXT_SCHEDULED_START_TIME_ASC" | "END_TIME_DESC";
        /**
         * FlowRunUpdate
         * @description Data used by the Prefect REST API to update a flow run.
         */
        FlowRunUpdate: {
            /** Name */
            name?: string | null;
            /** Flow Version */
            flow_version?: string | null;
            /** Parameters */
            parameters?: {
                [key: string]: unknown;
            };
            empirical_policy?: components["schemas"]["FlowRunPolicy"];
            /** Tags */
            tags?: string[];
            /** Infrastructure Pid */
            infrastructure_pid?: string | null;
            /** Job Variables */
            job_variables?: {
                [key: string]: unknown;
            } | null;
        };
        /**
         * FlowSort
         * @description Defines flow sorting options.
         * @enum {string}
         */
        FlowSort: "CREATED_DESC" | "UPDATED_DESC" | "NAME_ASC" | "NAME_DESC";
        /**
         * FlowUpdate
         * @description Data used by the Prefect REST API to update a flow.
         */
        FlowUpdate: {
            /**
             * Tags
             * @description A list of flow tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
        };
        /**
         * FlowsSettings
         * @description Settings for controlling flow behavior
         */
        FlowsSettings: {
            /**
             * Default Retries
             * @description This value sets the default number of retries for all flows.
             * @default 0
             */
            default_retries: number;
            /**
             * Default Retry Delay Seconds
             * @description This value sets the default retry delay seconds for all flows.
             * @default 0
             */
            default_retry_delay_seconds: number | number[];
        };
        /**
         * GlobalConcurrencyLimitResponse
         * @description A response object for global concurrency limits.
         */
        GlobalConcurrencyLimitResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Active
             * @description Whether the global concurrency limit is active.
             * @default true
             */
            active: boolean;
            /**
             * Name
             * @description The name of the global concurrency limit.
             */
            name: string;
            /**
             * Limit
             * @description The concurrency limit.
             */
            limit: number;
            /**
             * Active Slots
             * @description The number of active slots.
             */
            active_slots: number;
            /**
             * Slot Decay Per Second
             * @description The decay rate for active slots when used as a rate limit.
             * @default 2
             */
            slot_decay_per_second: number;
        };
        /** Graph */
        Graph: {
            /** Start Time */
            start_time: string | null;
            /** End Time */
            end_time: string | null;
            /** Root Node Ids */
            root_node_ids: string[];
            /** Nodes */
            nodes: [
                string,
                components["schemas"]["Node"]
            ][];
            /** Artifacts */
            artifacts: components["schemas"]["GraphArtifact"][];
            /** States */
            states: components["schemas"]["GraphState"][];
        };
        /** GraphArtifact */
        GraphArtifact: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /**
             * Created
             * Format: date-time
             */
            created: string;
            /** Key */
            key: string | null;
            /** Type */
            type: string | null;
            /** Is Latest */
            is_latest: boolean;
            /** Data */
            data: unknown | null;
        };
        /** GraphState */
        GraphState: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /**
             * Timestamp
             * Format: date-time
             */
            timestamp: string;
            type: components["schemas"]["StateType"];
            /** Name */
            name: string;
        };
        /** HTTPValidationError */
        HTTPValidationError: {
            /** Detail */
            detail?: components["schemas"]["ValidationError"][];
        };
        /**
         * HistoryResponse
         * @description Represents a history of aggregation states over an interval
         */
        HistoryResponse: {
            /**
             * Interval Start
             * Format: date-time
             * @description The start date of the interval.
             */
            interval_start: string;
            /**
             * Interval End
             * Format: date-time
             * @description The end date of the interval.
             */
            interval_end: string;
            /**
             * States
             * @description A list of state histories during the interval.
             */
            states: components["schemas"]["HistoryResponseState"][];
        };
        /**
         * HistoryResponseState
         * @description Represents a single state's history over an interval.
         */
        HistoryResponseState: {
            /** @description The state type. */
            state_type: components["schemas"]["StateType"];
            /**
             * State Name
             * @description The state name.
             */
            state_name: string;
            /**
             * Count Runs
             * @description The number of runs in the specified state during the interval.
             */
            count_runs: number;
            /**
             * Sum Estimated Run Time
             * @description The total estimated run time of all runs during the interval.
             */
            sum_estimated_run_time: number;
            /**
             * Sum Estimated Lateness
             * @description The sum of differences between actual and expected start time during the interval.
             */
            sum_estimated_lateness: number;
        };
        /** InternalSettings */
        InternalSettings: {
            /**
             * Logging Level
             * @description The default logging level for Prefect's internal machinery loggers.
             * @default ERROR
             * @enum {string}
             */
            logging_level: "DEBUG" | "INFO" | "WARNING" | "ERROR" | "CRITICAL";
        };
        /**
         * IntervalSchedule
         * @description A schedule formed by adding `interval` increments to an `anchor_date`. If no
         *     `anchor_date` is supplied, the current UTC time is used.  If a
         *     timezone-naive datetime is provided for `anchor_date`, it is assumed to be
         *     in the schedule's timezone (or UTC). Even if supplied with an IANA timezone,
         *     anchor dates are always stored as UTC offsets, so a `timezone` can be
         *     provided to determine localization behaviors like DST boundary handling. If
         *     none is provided it will be inferred from the anchor date.
         *
         *     NOTE: If the `IntervalSchedule` `anchor_date` or `timezone` is provided in a
         *     DST-observing timezone, then the schedule will adjust itself appropriately.
         *     Intervals greater than 24 hours will follow DST conventions, while intervals
         *     of less than 24 hours will follow UTC intervals. For example, an hourly
         *     schedule will fire every UTC hour, even across DST boundaries. When clocks
         *     are set back, this will result in two runs that *appear* to both be
         *     scheduled for 1am local time, even though they are an hour apart in UTC
         *     time. For longer intervals, like a daily schedule, the interval schedule
         *     will adjust for DST boundaries so that the clock-hour remains constant. This
         *     means that a daily schedule that always fires at 9am will observe DST and
         *     continue to fire at 9am in the local time zone.
         *
         *     Args:
         *         interval (datetime.timedelta): an interval to schedule on.
         *         anchor_date (DateTime, optional): an anchor date to schedule increments against;
         *             if not provided, the current timestamp will be used.
         *         timezone (str, optional): a valid timezone string.
         */
        IntervalSchedule: {
            /** Interval */
            interval: number;
            /**
             * Anchor Date
             * Format: date-time
             * @example 2020-01-01T00:00:00Z
             */
            anchor_date?: string;
            /**
             * Timezone
             * @example America/New_York
             */
            timezone?: string | null;
        };
        /**
         * Log
         * @description An ORM representation of log data.
         */
        Log: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The logger name.
             */
            name: string;
            /**
             * Level
             * @description The log level.
             */
            level: number;
            /**
             * Message
             * @description The log message.
             */
            message: string;
            /**
             * Timestamp
             * Format: date-time
             * @description The log timestamp.
             */
            timestamp: string;
            /**
             * Flow Run Id
             * @description The flow run ID associated with the log.
             */
            flow_run_id?: string | null;
            /**
             * Task Run Id
             * @description The task run ID associated with the log.
             */
            task_run_id?: string | null;
        };
        /**
         * LogCreate
         * @description Data used by the Prefect REST API to create a log.
         */
        LogCreate: {
            /**
             * Name
             * @description The logger name.
             */
            name: string;
            /**
             * Level
             * @description The log level.
             */
            level: number;
            /**
             * Message
             * @description The log message.
             */
            message: string;
            /**
             * Timestamp
             * Format: date-time
             * @description The log timestamp.
             */
            timestamp: string;
            /** Flow Run Id */
            flow_run_id?: string | null;
            /** Task Run Id */
            task_run_id?: string | null;
        };
        /**
         * LogFilter
         * @description Filter logs. Only logs matching all criteria will be returned
         */
        LogFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Log.level` */
            level?: components["schemas"]["LogFilterLevel"] | null;
            /** @description Filter criteria for `Log.timestamp` */
            timestamp?: components["schemas"]["LogFilterTimestamp"] | null;
            /** @description Filter criteria for `Log.flow_run_id` */
            flow_run_id?: components["schemas"]["LogFilterFlowRunId"] | null;
            /** @description Filter criteria for `Log.task_run_id` */
            task_run_id?: components["schemas"]["LogFilterTaskRunId"] | null;
            /** @description Filter criteria for text search across log content */
            text?: components["schemas"]["LogFilterTextSearch"] | null;
        };
        /**
         * LogFilterFlowRunId
         * @description Filter by `Log.flow_run_id`.
         */
        LogFilterFlowRunId: {
            /**
             * Any
             * @description A list of flow run IDs to include
             */
            any_?: string[] | null;
        };
        /**
         * LogFilterLevel
         * @description Filter by `Log.level`.
         */
        LogFilterLevel: {
            /**
             * Ge
             * @description Include logs with a level greater than or equal to this level
             * @example 20
             */
            ge_?: number | null;
            /**
             * Le
             * @description Include logs with a level less than or equal to this level
             * @example 50
             */
            le_?: number | null;
        };
        /**
         * LogFilterTaskRunId
         * @description Filter by `Log.task_run_id`.
         */
        LogFilterTaskRunId: {
            /**
             * Any
             * @description A list of task run IDs to include
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include logs without a task run id
             */
            is_null_?: boolean | null;
        };
        /**
         * LogFilterTextSearch
         * @description Filter by text search across log content.
         */
        LogFilterTextSearch: {
            /**
             * Query
             * @description Text search query string
             * @example error
             * @example error -debug
             * @example "connection timeout"
             * @example +required -excluded
             */
            query: string;
        };
        /**
         * LogFilterTimestamp
         * @description Filter by `Log.timestamp`.
         */
        LogFilterTimestamp: {
            /**
             * Before
             * @description Only include logs with a timestamp at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include logs with a timestamp at or after this time
             */
            after_?: string | null;
        };
        /**
         * LogSort
         * @description Defines log sorting options.
         * @enum {string}
         */
        LogSort: "TIMESTAMP_ASC" | "TIMESTAMP_DESC";
        /**
         * LoggingSettings
         * @description Settings for controlling logging behavior
         */
        LoggingSettings: {
            /**
             * Level
             * @description The default logging level for Prefect loggers.
             * @default INFO
             * @enum {string}
             */
            level: "DEBUG" | "INFO" | "WARNING" | "ERROR" | "CRITICAL";
            /**
             * Config Path
             * Format: path
             * @description A path to a logging configuration file. Defaults to $PREFECT_HOME/logging.yml
             */
            config_path?: string;
            /**
             * Extra Loggers
             * @description Additional loggers to attach to Prefect logging at runtime.
             */
            extra_loggers?: string | string[] | null;
            /**
             * Log Prints
             * @description If `True`, `print` statements in flows and tasks will be redirected to the Prefect logger for the given run.
             * @default false
             */
            log_prints: boolean;
            /**
             * Colors
             * @description If `True`, use colors in CLI output. If `False`, output will not include colors codes.
             * @default true
             */
            colors: boolean;
            /**
             * Markup
             * @description Whether to interpret strings wrapped in square brackets as a style.
             *             This allows styles to be conveniently added to log messages, e.g.
             *             `[red]This is a red message.[/red]`. However, the downside is, if enabled,
             *             strings that contain square brackets may be inaccurately interpreted and
             *             lead to incomplete output, e.g.
             *             `[red]This is a red message.[/red]` may be interpreted as
             *             `[red]This is a red message.[/red]`.
             * @default false
             */
            markup: boolean;
            to_api?: components["schemas"]["LoggingToAPISettings"];
        };
        /**
         * LoggingToAPISettings
         * @description Settings for controlling logging to the API
         */
        LoggingToAPISettings: {
            /**
             * Enabled
             * @description If `True`, logs will be sent to the API.
             * @default true
             */
            enabled: boolean;
            /**
             * Batch Interval
             * @description The number of seconds between batched writes of logs to the API.
             * @default 2
             */
            batch_interval: number;
            /**
             * Batch Size
             * @description The number of logs to batch before sending to the API.
             * @default 4000000
             */
            batch_size: number;
            /**
             * Max Log Size
             * @description The maximum size in characters for a single log. When connected to Prefect Cloud, this value is capped at `PREFECT_CLOUD_MAX_LOG_SIZE` (default 25,000).
             * @default 1000000
             */
            max_log_size: number;
            /**
             * When Missing Flow
             * @description Controls the behavior when loggers attempt to send logs to the API handler from outside of a flow.
             *
             *             All logs sent to the API must be associated with a flow run. The API log handler can
             *             only be used outside of a flow by manually providing a flow run identifier. Logs
             *             that are not associated with a flow run will not be sent to the API. This setting can
             *             be used to determine if a warning or error is displayed when the identifier is missing.
             *
             *             The following options are available:
             *
             *             - "warn": Log a warning message.
             *             - "error": Raise an error.
             *             - "ignore": Do not log a warning message or raise an error.
             * @default warn
             * @enum {string}
             */
            when_missing_flow: "warn" | "error" | "ignore";
        };
        /** MinimalConcurrencyLimitResponse */
        MinimalConcurrencyLimitResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Name */
            name: string;
            /** Limit */
            limit: number;
        };
        /** Node */
        Node: {
            /**
             * Kind
             * @enum {string}
             */
            kind: "flow-run" | "task-run";
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Label */
            label: string;
            state_type: components["schemas"]["StateType"];
            /**
             * Start Time
             * Format: date-time
             */
            start_time: string;
            /** End Time */
            end_time: string | null;
            /** Parents */
            parents: components["schemas"]["Edge"][];
            /** Children */
            children: components["schemas"]["Edge"][];
            /** Encapsulating */
            encapsulating: components["schemas"]["Edge"][];
            /** Artifacts */
            artifacts: components["schemas"]["GraphArtifact"][];
        };
        /**
         * Operator
         * @description Operators for combining filter criteria.
         * @enum {string}
         */
        Operator: "and_" | "or_";
        /**
         * OrchestrationResult
         * @description A container for the output of state orchestration.
         */
        OrchestrationResult: {
            state: components["schemas"]["State"] | null;
            status: components["schemas"]["SetStateStatus"];
            /** Details */
            details: components["schemas"]["StateAcceptDetails"] | components["schemas"]["StateWaitDetails"] | components["schemas"]["StateRejectDetails"] | components["schemas"]["StateAbortDetails"];
        };
        /**
         * Parameter
         * @description Represents a parameter input to a task run.
         */
        Parameter: {
            /**
             * Input Type
             * @default parameter
             * @constant
             */
            input_type: "parameter";
            /** Name */
            name: string;
        };
        /**
         * PauseAutomation
         * @description Pauses a Work Queue
         */
        PauseAutomation: {
            /**
             * Type
             * @default pause-automation
             * @constant
             */
            type: "pause-automation";
            /**
             * Source
             * @description Whether this Action applies to a specific selected automation (given by `automation_id`), or to an automation that is inferred from the triggering event.  If the source is 'inferred', the `automation_id` may not be set.  If the source is 'selected', the `automation_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Automation Id
             * @description The identifier of the automation to act on
             */
            automation_id?: string | null;
        };
        /**
         * PauseDeployment
         * @description Pauses the given Deployment
         */
        PauseDeployment: {
            /**
             * Type
             * @default pause-deployment
             * @constant
             */
            type: "pause-deployment";
            /**
             * Source
             * @description Whether this Action applies to a specific selected deployment (given by `deployment_id`), or to a deployment that is inferred from the triggering event.  If the source is 'inferred', the `deployment_id` may not be set.  If the source is 'selected', the `deployment_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Deployment Id
             * @description The identifier of the deployment
             */
            deployment_id?: string | null;
        };
        /**
         * PauseWorkPool
         * @description Pauses a Work Pool
         */
        PauseWorkPool: {
            /**
             * Type
             * @default pause-work-pool
             * @constant
             */
            type: "pause-work-pool";
            /**
             * Source
             * @description Whether this Action applies to a specific selected work pool (given by `work_pool_id`), or to a work pool that is inferred from the triggering event.  If the source is 'inferred', the `work_pool_id` may not be set.  If the source is 'selected', the `work_pool_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Work Pool Id
             * @description The identifier of the work pool to pause
             */
            work_pool_id?: string | null;
        };
        /**
         * PauseWorkQueue
         * @description Pauses a Work Queue
         */
        PauseWorkQueue: {
            /**
             * Type
             * @default pause-work-queue
             * @constant
             */
            type: "pause-work-queue";
            /**
             * Source
             * @description Whether this Action applies to a specific selected work queue (given by `work_queue_id`), or to a work queue that is inferred from the triggering event.  If the source is 'inferred', the `work_queue_id` may not be set.  If the source is 'selected', the `work_queue_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Work Queue Id
             * @description The identifier of the work queue to pause
             */
            work_queue_id?: string | null;
        };
        /**
         * PluginsSettings
         * @description Settings for configuring the experimental plugin system
         */
        PluginsSettings: {
            /**
             * Enabled
             * @description Enable the experimental plugin system.
             * @default false
             */
            enabled: boolean;
            /**
             * Allow
             * @description Comma-separated list of plugin names to allow. If set, only these plugins will be loaded.
             */
            allow?: string[] | null;
            /**
             * Deny
             * @description Comma-separated list of plugin names to deny. These plugins will not be loaded.
             */
            deny?: string[] | null;
            /**
             * Setup Timeout Seconds
             * @description Maximum time in seconds for all plugins to complete their setup hooks.
             * @default 20
             */
            setup_timeout_seconds: number;
            /**
             * Strict
             * @description If True, exit if a required plugin fails during setup.
             * @default false
             */
            strict: boolean;
            /**
             * Safe Mode
             * @description If True, load plugins but do not execute their hooks. Useful for testing.
             * @default false
             */
            safe_mode: boolean;
        };
        /**
         * QueueFilter
         * @description Filter criteria definition for a work queue.
         */
        QueueFilter: {
            /**
             * Tags
             * @description Only include flow runs with these tags in the work queue.
             */
            tags?: string[] | null;
            /**
             * Deployment Ids
             * @description Only include flow runs from these deployments in the work queue.
             */
            deployment_ids?: string[] | null;
        };
        /**
         * RRuleSchedule
         * @description RRule schedule, based on the iCalendar standard
         *     ([RFC 5545](https://datatracker.ietf.org/doc/html/rfc5545)) as
         *     implemented in `dateutils.rrule`.
         *
         *     RRules are appropriate for any kind of calendar-date manipulation, including
         *     irregular intervals, repetition, exclusions, week day or day-of-month
         *     adjustments, and more.
         *
         *     Note that as a calendar-oriented standard, `RRuleSchedules` are sensitive to
         *     to the initial timezone provided. A 9am daily schedule with a daylight saving
         *     time-aware start date will maintain a local 9am time through DST boundaries;
         *     a 9am daily schedule with a UTC start date will maintain a 9am UTC time.
         *
         *     Args:
         *         rrule (str): a valid RRule string
         *         timezone (str, optional): a valid timezone string
         */
        RRuleSchedule: {
            /** Rrule */
            rrule: string;
            /**
             * Timezone
             * @default UTC
             */
            timezone: string | null;
        };
        /**
         * ReceivedEvent
         * @description The server-side view of an event that has happened to a Resource after it has
         *     been received by the server
         */
        ReceivedEvent: {
            /**
             * Occurred
             * Format: date-time
             * @description When the event happened from the sender's perspective
             */
            occurred: string;
            /**
             * Event
             * @description The name of the event that happened
             */
            event: string;
            /** @description The primary Resource this event concerns */
            resource: components["schemas"]["Resource"];
            /**
             * Related
             * @description A list of additional Resources involved in this event
             */
            related?: components["schemas"]["RelatedResource"][];
            /**
             * Payload
             * @description An open-ended set of data describing what happened
             */
            payload?: {
                [key: string]: unknown;
            };
            /**
             * Id
             * Format: uuid
             * @description The client-provided identifier of this event
             */
            id: string;
            /**
             * Follows
             * @description The ID of an event that is known to have occurred prior to this one. If set, this may be used to establish a more precise ordering of causally-related events when they occur close enough together in time that the system may receive them out-of-order.
             */
            follows?: string | null;
            /**
             * Received
             * Format: date-time
             * @description When the event was received by Prefect Cloud
             */
            received?: string;
        };
        /**
         * RelatedResource
         * @description A Resource with a specific role in an Event
         */
        RelatedResource: {
            [key: string]: string;
        };
        /**
         * Resource
         * @description An observable business object of interest to the user
         */
        Resource: {
            [key: string]: string;
        };
        /** ResourceSpecification */
        ResourceSpecification: {
            [key: string]: string | string[];
        };
        /**
         * ResultsSettings
         * @description Settings for controlling result storage behavior
         */
        ResultsSettings: {
            /**
             * Default Serializer
             * @description The default serializer to use when not otherwise specified.
             * @default pickle
             */
            default_serializer: string;
            /**
             * Persist By Default
             * @description The default setting for persisting results when not otherwise specified.
             * @default false
             */
            persist_by_default: boolean;
            /**
             * Default Storage Block
             * @description The `block-type/block-document` slug of a block to use as the default result storage.
             */
            default_storage_block?: string | null;
            /**
             * Local Storage Path
             * Format: path
             * @description The default location for locally persisted results. Defaults to $PREFECT_HOME/storage.
             */
            local_storage_path?: string;
        };
        /**
         * ResumeAutomation
         * @description Resumes a Work Queue
         */
        ResumeAutomation: {
            /**
             * Type
             * @default resume-automation
             * @constant
             */
            type: "resume-automation";
            /**
             * Source
             * @description Whether this Action applies to a specific selected automation (given by `automation_id`), or to an automation that is inferred from the triggering event.  If the source is 'inferred', the `automation_id` may not be set.  If the source is 'selected', the `automation_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Automation Id
             * @description The identifier of the automation to act on
             */
            automation_id?: string | null;
        };
        /**
         * ResumeDeployment
         * @description Resumes the given Deployment
         */
        ResumeDeployment: {
            /**
             * Type
             * @default resume-deployment
             * @constant
             */
            type: "resume-deployment";
            /**
             * Source
             * @description Whether this Action applies to a specific selected deployment (given by `deployment_id`), or to a deployment that is inferred from the triggering event.  If the source is 'inferred', the `deployment_id` may not be set.  If the source is 'selected', the `deployment_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Deployment Id
             * @description The identifier of the deployment
             */
            deployment_id?: string | null;
        };
        /**
         * ResumeFlowRun
         * @description Resumes a paused or suspended flow run associated with the trigger
         */
        ResumeFlowRun: {
            /**
             * Type
             * @default resume-flow-run
             * @constant
             */
            type: "resume-flow-run";
        };
        /**
         * ResumeWorkPool
         * @description Resumes a Work Pool
         */
        ResumeWorkPool: {
            /**
             * Type
             * @default resume-work-pool
             * @constant
             */
            type: "resume-work-pool";
            /**
             * Source
             * @description Whether this Action applies to a specific selected work pool (given by `work_pool_id`), or to a work pool that is inferred from the triggering event.  If the source is 'inferred', the `work_pool_id` may not be set.  If the source is 'selected', the `work_pool_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Work Pool Id
             * @description The identifier of the work pool to pause
             */
            work_pool_id?: string | null;
        };
        /**
         * ResumeWorkQueue
         * @description Resumes a Work Queue
         */
        ResumeWorkQueue: {
            /**
             * Type
             * @default resume-work-queue
             * @constant
             */
            type: "resume-work-queue";
            /**
             * Source
             * @description Whether this Action applies to a specific selected work queue (given by `work_queue_id`), or to a work queue that is inferred from the triggering event.  If the source is 'inferred', the `work_queue_id` may not be set.  If the source is 'selected', the `work_queue_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Work Queue Id
             * @description The identifier of the work queue to pause
             */
            work_queue_id?: string | null;
        };
        /**
         * RunDeployment
         * @description Runs the given deployment with the given parameters
         */
        RunDeployment: {
            /**
             * Type
             * @default run-deployment
             * @constant
             */
            type: "run-deployment";
            /**
             * Source
             * @description Whether this Action applies to a specific selected deployment (given by `deployment_id`), or to a deployment that is inferred from the triggering event.  If the source is 'inferred', the `deployment_id` may not be set.  If the source is 'selected', the `deployment_id` must be set.
             * @default selected
             * @enum {string}
             */
            source: "selected" | "inferred";
            /**
             * Deployment Id
             * @description The identifier of the deployment
             */
            deployment_id?: string | null;
            /**
             * Parameters
             * @description The parameters to pass to the deployment, or None to use the deployment's default parameters
             */
            parameters?: {
                [key: string]: unknown;
            } | null;
            /**
             * Job Variables
             * @description The job variables to pass to the created flow run, or None to use the deployment's default job variables
             */
            job_variables?: {
                [key: string]: unknown;
            } | null;
            /**
             * Schedule After
             * @description The amount of time to wait before running the deployment. Defaults to running the deployment immediately.
             */
            schedule_after?: number;
        };
        /**
         * RunnerServerSettings
         * @description Settings for controlling runner server behavior
         */
        RunnerServerSettings: {
            /**
             * Enable
             * @description Whether or not to enable the runner's webserver.
             * @default false
             */
            enable: boolean;
            /**
             * Host
             * @description The host address the runner's webserver should bind to.
             * @default localhost
             */
            host: string;
            /**
             * Port
             * @description The port the runner's webserver should bind to.
             * @default 8080
             */
            port: number;
            /**
             * Log Level
             * @description The log level of the runner's webserver.
             * @default ERROR
             * @enum {string}
             */
            log_level: "DEBUG" | "INFO" | "WARNING" | "ERROR" | "CRITICAL";
            /**
             * Missed Polls Tolerance
             * @description Number of missed polls before a runner is considered unhealthy by its webserver.
             * @default 2
             */
            missed_polls_tolerance: number;
        };
        /**
         * RunnerSettings
         * @description Settings for controlling runner behavior
         */
        RunnerSettings: {
            /**
             * Process Limit
             * @description Maximum number of processes a runner will execute in parallel.
             * @default 5
             */
            process_limit: number;
            /**
             * Poll Frequency
             * @description Number of seconds a runner should wait between queries for scheduled work.
             * @default 10
             */
            poll_frequency: number;
            /**
             * Heartbeat Frequency
             * @description Number of seconds a runner should wait between heartbeats for flow runs.
             */
            heartbeat_frequency?: number | null;
            server?: components["schemas"]["RunnerServerSettings"];
        };
        /**
         * SQLAlchemyConnectArgsSettings
         * @description Settings for controlling SQLAlchemy connection behavior; note that these settings only take effect when
         *     using a PostgreSQL database.
         */
        SQLAlchemyConnectArgsSettings: {
            /**
             * Application Name
             * @description Controls the application_name field for connections opened from the connection pool when using a PostgreSQL database with the Prefect backend.
             */
            application_name?: string | null;
            /**
             * Search Path
             * @description PostgreSQL schema name to set in search_path when using a PostgreSQL database with the Prefect backend. Note: The public schema should be included in the search path (e.g. 'myschema, public') to ensure that pg_trgm and other extensions remain available.
             */
            search_path?: string | null;
            /**
             * Statement Cache Size
             * @description Controls statement cache size for PostgreSQL connections. Setting this to 0 is required when using PgBouncer in transaction mode. Defaults to None.
             */
            statement_cache_size?: number | null;
            /**
             * Prepared Statement Cache Size
             * @description Controls the size of the statement cache for PostgreSQL connections. When set to 0, statement caching is disabled. Defaults to None to use SQLAlchemy's default behavior.
             */
            prepared_statement_cache_size?: number | null;
            /** @description Settings for controlling SQLAlchemy mTLS behavior */
            tls?: components["schemas"]["SQLAlchemyTLSSettings"];
        };
        /**
         * SQLAlchemySettings
         * @description Settings for controlling SQLAlchemy behavior; note that these settings only take effect when
         *     using a PostgreSQL database.
         */
        SQLAlchemySettings: {
            /** @description Settings for controlling SQLAlchemy connection behavior */
            connect_args?: components["schemas"]["SQLAlchemyConnectArgsSettings"];
            /**
             * Pool Size
             * @description Controls connection pool size of database connection pools from the Prefect backend.
             * @default 5
             */
            pool_size: number;
            /**
             * Pool Recycle
             * @description This setting causes the pool to recycle connections after the given number of seconds has passed; set it to -1 to avoid recycling entirely.
             * @default 3600
             */
            pool_recycle: number;
            /**
             * Pool Timeout
             * @description Number of seconds to wait before giving up on getting a connection from the pool. Defaults to 30 seconds.
             * @default 30
             */
            pool_timeout: number | null;
            /**
             * Max Overflow
             * @description Controls maximum overflow of the connection pool. To prevent overflow, set to -1.
             * @default 10
             */
            max_overflow: number;
        };
        /**
         * SQLAlchemyTLSSettings
         * @description Settings for controlling SQLAlchemy mTLS context when
         *     using a PostgreSQL database.
         */
        SQLAlchemyTLSSettings: {
            /**
             * Enabled
             * @description Controls whether connected to mTLS enabled PostgreSQL when using a PostgreSQL database with the Prefect backend.
             * @default false
             */
            enabled: boolean;
            /**
             * Ca File
             * @description This configuration settings option specifies the path to PostgreSQL client certificate authority file.
             */
            ca_file?: string | null;
            /**
             * Cert File
             * @description This configuration settings option specifies the path to PostgreSQL client certificate file.
             */
            cert_file?: string | null;
            /**
             * Key File
             * @description This configuration settings option specifies the path to PostgreSQL client key file.
             */
            key_file?: string | null;
            /**
             * Check Hostname
             * @description This configuration settings option specifies whether to verify PostgreSQL server hostname.
             * @default true
             */
            check_hostname: boolean;
        };
        /**
         * SavedSearch
         * @description An ORM representation of saved search data. Represents a set of filter criteria.
         */
        SavedSearch: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the saved search.
             */
            name: string;
            /**
             * Filters
             * @description The filter set for the saved search.
             */
            filters?: components["schemas"]["SavedSearchFilter"][];
        };
        /**
         * SavedSearchCreate
         * @description Data used by the Prefect REST API to create a saved search.
         */
        SavedSearchCreate: {
            /**
             * Name
             * @description The name of the saved search.
             */
            name: string;
            /**
             * Filters
             * @description The filter set for the saved search.
             */
            filters?: components["schemas"]["SavedSearchFilter"][];
        };
        /**
         * SavedSearchFilter
         * @description A filter for a saved search model. Intended for use by the Prefect UI.
         */
        SavedSearchFilter: {
            /**
             * Object
             * @description The object over which to filter.
             */
            object: string;
            /**
             * Property
             * @description The property of the object on which to filter.
             */
            property: string;
            /**
             * Type
             * @description The type of the property.
             */
            type: string;
            /**
             * Operation
             * @description The operator to apply to the object. For example, `equals`.
             */
            operation: string;
            /**
             * Value
             * @description A JSON-compatible value for the filter.
             */
            value: unknown;
        };
        /** SchemaValueIndexError */
        SchemaValueIndexError: {
            /** Index */
            index: number;
            /** Errors */
            errors: (string | components["schemas"]["SchemaValuePropertyError"] | components["schemas"]["SchemaValueIndexError"])[];
        };
        /** SchemaValuePropertyError */
        SchemaValuePropertyError: {
            /** Property */
            property: string;
            /** Errors */
            errors: (string | components["schemas"]["SchemaValuePropertyError"] | components["schemas"]["SchemaValueIndexError"])[];
        };
        /** SchemaValuesValidationResponse */
        SchemaValuesValidationResponse: {
            /** Errors */
            errors: (string | components["schemas"]["SchemaValuePropertyError"] | components["schemas"]["SchemaValueIndexError"])[];
            /** Valid */
            valid: boolean;
        };
        /**
         * SendNotification
         * @description Send a notification when an Automation is triggered
         */
        SendNotification: {
            /**
             * Type
             * @default send-notification
             * @constant
             */
            type: "send-notification";
            /**
             * Block Document Id
             * Format: uuid
             * @description The identifier of the notification block to use
             */
            block_document_id: string;
            /**
             * Subject
             * @default Prefect automated notification
             */
            subject: string;
            /**
             * Body
             * @description The text of the notification to send
             */
            body: string;
        };
        /**
         * SequenceTrigger
         * @description A composite trigger that requires some number of triggers to have fired
         *     within the given time period in a specific order
         */
        "SequenceTrigger-Input": {
            /**
             * Type
             * @default sequence
             * @constant
             */
            type: "sequence";
            /**
             * Id
             * Format: uuid
             * @description The unique ID of this trigger
             */
            id?: string;
            /** Triggers */
            triggers: (components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Input"] | components["schemas"]["SequenceTrigger-Input"])[];
            /** Within */
            within: number | null;
        };
        /**
         * SequenceTrigger
         * @description A composite trigger that requires some number of triggers to have fired
         *     within the given time period in a specific order
         */
        "SequenceTrigger-Output": {
            /**
             * Type
             * @default sequence
             * @constant
             */
            type: "sequence";
            /**
             * Id
             * Format: uuid
             * @description The unique ID of this trigger
             */
            id?: string;
            /** Triggers */
            triggers: (components["schemas"]["EventTrigger"] | components["schemas"]["CompoundTrigger-Output"] | components["schemas"]["SequenceTrigger-Output"])[];
            /** Within */
            within: number | null;
        };
        /**
         * ServerAPISettings
         * @description Settings for controlling API server behavior
         */
        ServerAPISettings: {
            /**
             * Auth String
             * @description A string to use for basic authentication with the API in the form 'user:password'.
             */
            auth_string?: string | null;
            /**
             * Host
             * @description The API's host address (defaults to `127.0.0.1`).
             * @default 127.0.0.1
             */
            host: string;
            /**
             * Port
             * @description The API's port address (defaults to `4200`).
             * @default 4200
             */
            port: number;
            /**
             * Base Path
             * @description The base URL path to serve the API under.
             * @example /v2/api
             */
            base_path?: string | null;
            /**
             * Default Limit
             * @description The default limit applied to queries that can return multiple objects, such as `POST /flow_runs/filter`.
             * @default 200
             */
            default_limit: number;
            /**
             * Keepalive Timeout
             * @description The API's keep alive timeout (defaults to `5`).
             *             Refer to https://www.uvicorn.org/settings/#timeouts for details.
             *
             *             When the API is hosted behind a load balancer, you may want to set this to a value
             *             greater than the load balancer's idle timeout.
             *
             *             Note this setting only applies when calling `prefect server start`; if hosting the
             *             API with another tool you will need to configure this there instead.
             * @default 5
             */
            keepalive_timeout: number;
            /**
             * Csrf Protection Enabled
             * @description Controls the activation of CSRF protection for the Prefect server API.
             *
             *             When enabled (`True`), the server enforces CSRF validation checks on incoming
             *             state-changing requests (POST, PUT, PATCH, DELETE), requiring a valid CSRF
             *             token to be included in the request headers or body. This adds a layer of
             *             security by preventing unauthorized or malicious sites from making requests on
             *             behalf of authenticated users.
             *
             *             It is recommended to enable this setting in production environments where the
             *             API is exposed to web clients to safeguard against CSRF attacks.
             *
             *             Note: Enabling this setting requires corresponding support in the client for
             *             CSRF token management. See PREFECT_CLIENT_CSRF_SUPPORT_ENABLED for more.
             * @default false
             */
            csrf_protection_enabled: boolean;
            /**
             * Csrf Token Expiration
             * Format: duration
             * @description Specifies the duration for which a CSRF token remains valid after being issued
             *             by the server.
             *
             *             The default expiration time is set to 1 hour, which offers a reasonable
             *             compromise. Adjust this setting based on your specific security requirements
             *             and usage patterns.
             * @default PT1H
             */
            csrf_token_expiration: string;
            /**
             * Cors Allowed Origins
             * @description A comma-separated list of origins that are authorized to make cross-origin requests to the API.
             *
             *             By default, this is set to `*`, which allows requests from all origins.
             * @default *
             */
            cors_allowed_origins: string;
            /**
             * Cors Allowed Methods
             * @description A comma-separated list of methods that are authorized to make cross-origin requests to the API.
             *
             *             By default, this is set to `*`, which allows requests from all methods.
             * @default *
             */
            cors_allowed_methods: string;
            /**
             * Cors Allowed Headers
             * @description A comma-separated list of headers that are authorized to make cross-origin requests to the API.
             *
             *             By default, this is set to `*`, which allows requests from all headers.
             * @default *
             */
            cors_allowed_headers: string;
        };
        /** ServerConcurrencySettings */
        ServerConcurrencySettings: {
            /**
             * Lease Storage
             * @description The module to use for storing concurrency limit leases.
             * @default prefect.server.concurrency.lease_storage.memory
             */
            lease_storage: string;
            /**
             * Initial Deployment Lease Duration
             * @description Initial duration for deployment concurrency lease in seconds.
             * @default 300
             */
            initial_deployment_lease_duration: number;
            /**
             * Maximum Concurrency Slot Wait Seconds
             * @description The maximum number of seconds to wait before retrying when a concurrency slot cannot be acquired.
             * @default 30
             */
            maximum_concurrency_slot_wait_seconds: number;
        };
        /**
         * ServerDatabaseSettings
         * @description Settings for controlling server database behavior
         */
        ServerDatabaseSettings: {
            /** @description Settings for controlling SQLAlchemy behavior */
            sqlalchemy?: components["schemas"]["SQLAlchemySettings"];
            /**
             * Connection Url
             * @description A database connection URL in a SQLAlchemy-compatible
             *             format. Prefect currently supports SQLite and Postgres. Note that all
             *             Prefect database engines must use an async driver - for SQLite, use
             *             `sqlite+aiosqlite` and for Postgres use `postgresql+asyncpg`.
             *
             *             SQLite in-memory databases can be used by providing the url
             *             `sqlite+aiosqlite:///file::memory:?cache=shared&uri=true&check_same_thread=false`,
             *             which will allow the database to be accessed by multiple threads. Note
             *             that in-memory databases can not be accessed from multiple processes and
             *             should only be used for simple tests.
             */
            connection_url?: string | null;
            /**
             * Driver
             * @description The database driver to use when connecting to the database. If not set, the driver will be inferred from the connection URL.
             */
            driver?: ("postgresql+asyncpg" | "sqlite+aiosqlite") | null;
            /**
             * Host
             * @description The database server host.
             */
            host?: string | null;
            /**
             * Port
             * @description The database server port.
             */
            port?: number | null;
            /**
             * User
             * @description The user to use when connecting to the database.
             */
            user?: string | null;
            /**
             * Name
             * @description The name of the Prefect database on the remote server, or the path to the database file for SQLite.
             */
            name?: string | null;
            /**
             * Password
             * @description The password to use when connecting to the database. Should be kept secret.
             */
            password?: string | null;
            /**
             * Echo
             * @description If `True`, SQLAlchemy will log all SQL issued to the database. Defaults to `False`.
             * @default false
             */
            echo: boolean;
            /**
             * Migrate On Start
             * @description If `True`, the database will be migrated on application startup.
             * @default true
             */
            migrate_on_start: boolean;
            /**
             * Timeout
             * @description A statement timeout, in seconds, applied to all database interactions made by the Prefect backend. Defaults to 10 seconds.
             * @default 10
             */
            timeout: number | null;
            /**
             * Connection Timeout
             * @description A connection timeout, in seconds, applied to database connections. Defaults to `5`.
             * @default 5
             */
            connection_timeout: number | null;
        };
        /** ServerDeploymentsSettings */
        ServerDeploymentsSettings: {
            /**
             * Concurrency Slot Wait Seconds
             * @description The number of seconds to wait before retrying when a deployment flow run cannot secure a concurrency slot from the server.
             * @default 30
             */
            concurrency_slot_wait_seconds: number;
        };
        /**
         * ServerDocketSettings
         * @description Settings for controlling Docket behavior
         */
        ServerDocketSettings: {
            /**
             * Name
             * @description The name of the Docket instance.
             * @default prefect-server
             */
            name: string;
            /**
             * Url
             * @description The URL of the Redis server to use for Docket.
             * @default memory://
             */
            url: string;
        };
        /**
         * ServerEphemeralSettings
         * @description Settings for controlling ephemeral server behavior
         */
        ServerEphemeralSettings: {
            /**
             * Enabled
             * @description Controls whether or not a subprocess server can be started when no API URL is provided.
             * @default false
             */
            enabled: boolean;
            /**
             * Startup Timeout Seconds
             * @description The number of seconds to wait for the server to start when ephemeral mode is enabled.
             *             Defaults to `20`.
             * @default 20
             */
            startup_timeout_seconds: number;
        };
        /**
         * ServerEventsSettings
         * @description Settings for controlling behavior of the events subsystem
         */
        ServerEventsSettings: {
            /**
             * Stream Out Enabled
             * @description Whether or not to stream events out to the API via websockets.
             * @default true
             */
            stream_out_enabled: boolean;
            /**
             * Related Resource Cache Ttl
             * Format: duration
             * @description The number of seconds to cache related resources for in the API.
             * @default PT5M
             */
            related_resource_cache_ttl: string;
            /**
             * Maximum Labels Per Resource
             * @description The maximum number of labels a resource may have.
             * @default 500
             */
            maximum_labels_per_resource: number;
            /**
             * Maximum Related Resources
             * @description The maximum number of related resources an Event may have.
             * @default 100
             */
            maximum_related_resources: number;
            /**
             * Maximum Size Bytes
             * @description The maximum size of an Event when serialized to JSON
             * @default 1500000
             */
            maximum_size_bytes: number;
            /**
             * Expired Bucket Buffer
             * Format: duration
             * @description The amount of time to retain expired automation buckets
             * @default PT1M
             */
            expired_bucket_buffer: string;
            /**
             * Proactive Granularity
             * Format: duration
             * @description How frequently proactive automations are evaluated
             * @default PT5S
             */
            proactive_granularity: string;
            /**
             * Retention Period
             * Format: duration
             * @description The amount of time to retain events in the database.
             * @default P7D
             */
            retention_period: string;
            /**
             * Maximum Websocket Backfill
             * Format: duration
             * @description The maximum range to look back for backfilling events for a websocket subscriber.
             * @default PT15M
             */
            maximum_websocket_backfill: string;
            /**
             * Websocket Backfill Page Size
             * @description The page size for the queries to backfill events for websocket subscribers.
             * @default 250
             */
            websocket_backfill_page_size: number;
            /**
             * Messaging Broker
             * @description Which message broker implementation to use for the messaging system, should point to a module that exports a Publisher and Consumer class.
             * @default prefect.server.utilities.messaging.memory
             */
            messaging_broker: string;
            /**
             * Messaging Cache
             * @description Which cache implementation to use for the events system. Should point to a module that exports a Cache class.
             * @default prefect.server.utilities.messaging.memory
             */
            messaging_cache: string;
            /**
             * Causal Ordering
             * @description Which causal ordering implementation to use for the events system. Should point to a module that exports a CausalOrdering class.
             * @default prefect.server.events.ordering.memory
             */
            causal_ordering: string;
            /**
             * Maximum Event Name Length
             * @description The maximum length of an event name.
             * @default 1024
             */
            maximum_event_name_length: number;
        };
        /**
         * ServerFlowRunGraphSettings
         * @description Settings for controlling behavior of the flow run graph
         */
        ServerFlowRunGraphSettings: {
            /**
             * Max Nodes
             * @description The maximum size of a flow run graph on the v2 API
             * @default 10000
             */
            max_nodes: number;
            /**
             * Max Artifacts
             * @description The maximum number of artifacts to show on a flow run graph on the v2 API
             * @default 10000
             */
            max_artifacts: number;
        };
        /**
         * ServerLogsSettings
         * @description Settings for controlling behavior of the logs subsystem
         */
        ServerLogsSettings: {
            /**
             * Stream Out Enabled
             * @description Whether or not to stream logs out to the API via websockets.
             * @default false
             */
            stream_out_enabled: boolean;
            /**
             * Stream Publishing Enabled
             * @description Whether or not to publish logs to the streaming system.
             * @default false
             */
            stream_publishing_enabled: boolean;
        };
        /**
         * ServerServicesCancellationCleanupSettings
         * @description Settings for controlling the cancellation cleanup service
         */
        ServerServicesCancellationCleanupSettings: {
            /**
             * Enabled
             * @description Whether or not to start the cancellation cleanup service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The cancellation cleanup service will look for non-terminal tasks and subflows this often. Defaults to `20`.
             * @default 20
             */
            loop_seconds: number;
        };
        /**
         * ServerServicesEventLoggerSettings
         * @description Settings for controlling the event logger service
         */
        ServerServicesEventLoggerSettings: {
            /**
             * Enabled
             * @description Whether or not to start the event logger service in the server application.
             * @default false
             */
            enabled: boolean;
        };
        /**
         * ServerServicesEventPersisterSettings
         * @description Settings for controlling the event persister service
         */
        ServerServicesEventPersisterSettings: {
            /**
             * Enabled
             * @description Whether or not to start the event persister service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Batch Size
             * @description The number of events the event persister will attempt to insert in one batch.
             * @default 20
             */
            batch_size: number;
            /**
             * Read Batch Size
             * @description The number of events the event persister will attempt to read from the message broker in one batch.
             * @default 1
             */
            read_batch_size: number;
            /**
             * Flush Interval
             * @description The maximum number of seconds between flushes of the event persister.
             * @default 5
             */
            flush_interval: number;
            /**
             * Batch Size Delete
             * @description The number of expired events and event resources the event persister will attempt to delete in one batch.
             * @default 10000
             */
            batch_size_delete: number;
            /**
             * Queue Max Size
             * @description The maximum number of events that can be queued in memory for persistence. When the queue is full, new events will be dropped.
             * @default 50000
             */
            queue_max_size: number;
            /**
             * Max Flush Retries
             * @description The maximum number of consecutive flush failures before events are dropped instead of being re-queued.
             * @default 5
             */
            max_flush_retries: number;
        };
        /**
         * ServerServicesForemanSettings
         * @description Settings for controlling the foreman service
         */
        ServerServicesForemanSettings: {
            /**
             * Enabled
             * @description Whether or not to start the foreman service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The foreman service will check for offline workers this often. Defaults to `15`.
             * @default 15
             */
            loop_seconds: number;
            /**
             * Inactivity Heartbeat Multiple
             * @description The number of heartbeats that must be missed before a worker is marked as offline. Defaults to `3`.
             * @default 3
             */
            inactivity_heartbeat_multiple: number;
            /**
             * Fallback Heartbeat Interval Seconds
             * @description The number of seconds to use for online/offline evaluation if a worker's heartbeat
             *             interval is not set. Defaults to `30`.
             * @default 30
             */
            fallback_heartbeat_interval_seconds: number;
            /**
             * Deployment Last Polled Timeout Seconds
             * @description The number of seconds before a deployment is marked as not ready if it has not been
             *             polled. Defaults to `60`.
             * @default 60
             */
            deployment_last_polled_timeout_seconds: number;
            /**
             * Work Queue Last Polled Timeout Seconds
             * @description The number of seconds before a work queue is marked as not ready if it has not been
             *             polled. Defaults to `60`.
             * @default 60
             */
            work_queue_last_polled_timeout_seconds: number;
        };
        /**
         * ServerServicesLateRunsSettings
         * @description Settings for controlling the late runs service
         */
        ServerServicesLateRunsSettings: {
            /**
             * Enabled
             * @description Whether or not to start the late runs service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The late runs service will look for runs to mark as late this often. Defaults to `5`.
             * @default 5
             */
            loop_seconds: number;
            /**
             * After Seconds
             * Format: duration
             * @description The late runs service will mark runs as late after they have exceeded their scheduled start time by this many seconds. Defaults to `5` seconds.
             * @default PT15S
             */
            after_seconds: string;
        };
        /**
         * ServerServicesPauseExpirationsSettings
         * @description Settings for controlling the pause expiration service
         */
        ServerServicesPauseExpirationsSettings: {
            /**
             * Enabled
             * @description Whether or not to start the paused flow run expiration service in the server
             *             application. If disabled, paused flows that have timed out will remain in a Paused state
             *             until a resume attempt.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The pause expiration service will look for runs to mark as failed this often. Defaults to `5`.
             * @default 5
             */
            loop_seconds: number;
        };
        /**
         * ServerServicesRepossessorSettings
         * @description Settings for controlling the repossessor service
         */
        ServerServicesRepossessorSettings: {
            /**
             * Enabled
             * @description Whether or not to start the repossessor service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The repossessor service will look for expired leases this often. Defaults to `15`.
             * @default 15
             */
            loop_seconds: number;
        };
        /**
         * ServerServicesSchedulerSettings
         * @description Settings for controlling the scheduler service
         */
        ServerServicesSchedulerSettings: {
            /**
             * Enabled
             * @description Whether or not to start the scheduler service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Loop Seconds
             * @description The scheduler loop interval, in seconds. This determines
             *             how often the scheduler will attempt to schedule new flow runs, but has no
             *             impact on how quickly either flow runs or task runs are actually executed.
             *             Defaults to `60`.
             * @default 60
             */
            loop_seconds: number;
            /**
             * Deployment Batch Size
             * @description The number of deployments the scheduler will attempt to
             *             schedule in a single batch. If there are more deployments than the batch
             *             size, the scheduler immediately attempts to schedule the next batch; it
             *             does not sleep for `scheduler_loop_seconds` until it has visited every
             *             deployment once. Defaults to `100`.
             * @default 100
             */
            deployment_batch_size: number;
            /**
             * Max Runs
             * @description The scheduler will attempt to schedule up to this many
             *             auto-scheduled runs in the future. Note that runs may have fewer than
             *             this many scheduled runs, depending on the value of
             *             `scheduler_max_scheduled_time`.  Defaults to `100`.
             * @default 100
             */
            max_runs: number;
            /**
             * Min Runs
             * @description The scheduler will attempt to schedule at least this many
             *             auto-scheduled runs in the future. Note that runs may have more than
             *             this many scheduled runs, depending on the value of
             *             `scheduler_min_scheduled_time`.  Defaults to `3`.
             * @default 3
             */
            min_runs: number;
            /**
             * Max Scheduled Time
             * Format: duration
             * @description The scheduler will create new runs up to this far in the
             *             future. Note that this setting will take precedence over
             *             `scheduler_max_runs`: if a flow runs once a month and
             *             `scheduler_max_scheduled_time` is three months, then only three runs will be
             *             scheduled. Defaults to 100 days (`8640000` seconds).
             * @default P100D
             */
            max_scheduled_time: string;
            /**
             * Min Scheduled Time
             * Format: duration
             * @description The scheduler will create new runs at least this far in the
             *             future. Note that this setting will take precedence over `scheduler_min_runs`:
             *             if a flow runs every hour and `scheduler_min_scheduled_time` is three hours,
             *             then three runs will be scheduled even if `scheduler_min_runs` is 1. Defaults to
             * @default PT1H
             */
            min_scheduled_time: string;
            /**
             * Insert Batch Size
             * @description The number of runs the scheduler will attempt to insert in a single batch.
             *             Defaults to `500`.
             * @default 500
             */
            insert_batch_size: number;
            /**
             * Recent Deployments Loop Seconds
             * @description The number of seconds the recent deployments scheduler will wait between checking for recently updated deployments. Defaults to `5`.
             * @default 5
             */
            recent_deployments_loop_seconds: number;
        };
        /**
         * ServerServicesSettings
         * @description Settings for controlling server services
         */
        ServerServicesSettings: {
            cancellation_cleanup?: components["schemas"]["ServerServicesCancellationCleanupSettings"];
            event_persister?: components["schemas"]["ServerServicesEventPersisterSettings"];
            event_logger?: components["schemas"]["ServerServicesEventLoggerSettings"];
            foreman?: components["schemas"]["ServerServicesForemanSettings"];
            late_runs?: components["schemas"]["ServerServicesLateRunsSettings"];
            scheduler?: components["schemas"]["ServerServicesSchedulerSettings"];
            pause_expirations?: components["schemas"]["ServerServicesPauseExpirationsSettings"];
            repossessor?: components["schemas"]["ServerServicesRepossessorSettings"];
            task_run_recorder?: components["schemas"]["ServerServicesTaskRunRecorderSettings"];
            triggers?: components["schemas"]["ServerServicesTriggersSettings"];
        };
        /**
         * ServerServicesTaskRunRecorderSettings
         * @description Settings for controlling the task run recorder service
         */
        ServerServicesTaskRunRecorderSettings: {
            /**
             * Enabled
             * @description Whether or not to start the task run recorder service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Read Batch Size
             * @description The number of task runs the task run recorder will attempt to read from the message broker in one batch.
             * @default 1
             */
            read_batch_size: number;
            /**
             * Batch Size
             * @description The number of task runs the task run recorder will attempt to insert in one batch.
             * @default 1
             */
            batch_size: number;
            /**
             * Flush Interval
             * @description The maximum number of seconds between flushes of the task run recorder.
             * @default 5
             */
            flush_interval: number;
        };
        /**
         * ServerServicesTriggersSettings
         * @description Settings for controlling the triggers service
         */
        ServerServicesTriggersSettings: {
            /**
             * Enabled
             * @description Whether or not to start the triggers service in the server application.
             * @default true
             */
            enabled: boolean;
            /**
             * Read Batch Size
             * @description The number of events the triggers service will attempt to read from the message broker in one batch.
             * @default 1
             */
            read_batch_size: number;
            /**
             * Pg Notify Reconnect Interval Seconds
             * @description The number of seconds to wait before reconnecting to the PostgreSQL NOTIFY/LISTEN
             *             connection after an error. Only used when using PostgreSQL as the database.
             *             Defaults to `10`.
             * @default 10
             */
            pg_notify_reconnect_interval_seconds: number;
            /**
             * Pg Notify Heartbeat Interval Seconds
             * @description The number of seconds between heartbeat checks for the PostgreSQL NOTIFY/LISTEN
             *             connection to ensure it's still alive. Only used when using PostgreSQL as the database.
             *             Defaults to `5`.
             * @default 5
             */
            pg_notify_heartbeat_interval_seconds: number;
        };
        /**
         * ServerSettings
         * @description Settings for controlling server behavior
         */
        ServerSettings: {
            /**
             * Logging Level
             * @description The default logging level for the Prefect API server.
             * @default WARNING
             * @enum {string}
             */
            logging_level: "DEBUG" | "INFO" | "WARNING" | "ERROR" | "CRITICAL";
            /**
             * Analytics Enabled
             * @description When enabled, Prefect sends anonymous data (e.g. count of flow runs, package version)
             *             on server startup to help us improve our product.
             * @default true
             */
            analytics_enabled: boolean;
            /**
             * Metrics Enabled
             * @description Whether or not to enable Prometheus metrics in the API.
             * @default false
             */
            metrics_enabled: boolean;
            /**
             * Log Retryable Errors
             * @description If `True`, log retryable errors in the API and it's services.
             * @default false
             */
            log_retryable_errors: boolean;
            /**
             * Register Blocks On Start
             * @description If set, any block types that have been imported will be registered with the backend on application startup. If not set, block types must be manually registered.
             * @default true
             */
            register_blocks_on_start: boolean;
            /**
             * Memoize Block Auto Registration
             * @description Controls whether or not block auto-registration on start
             * @default true
             */
            memoize_block_auto_registration: boolean;
            /**
             * Memo Store Path
             * Format: path
             * @description Path to the memo store file. Defaults to $PREFECT_HOME/memo_store.toml
             */
            memo_store_path?: string;
            /**
             * Deployment Schedule Max Scheduled Runs
             * @description The maximum number of scheduled runs to create for a deployment.
             * @default 50
             */
            deployment_schedule_max_scheduled_runs: number;
            api?: components["schemas"]["ServerAPISettings"];
            /** @description Settings for controlling server-side concurrency limit handling */
            concurrency?: components["schemas"]["ServerConcurrencySettings"];
            database?: components["schemas"]["ServerDatabaseSettings"];
            /** @description Settings for controlling server deployments behavior */
            deployments?: components["schemas"]["ServerDeploymentsSettings"];
            /** @description Settings for controlling server Docket behavior */
            docket?: components["schemas"]["ServerDocketSettings"];
            ephemeral?: components["schemas"]["ServerEphemeralSettings"];
            /** @description Settings for controlling server events behavior */
            events?: components["schemas"]["ServerEventsSettings"];
            /** @description Settings for controlling flow run graph behavior */
            flow_run_graph?: components["schemas"]["ServerFlowRunGraphSettings"];
            /** @description Settings for controlling server logs behavior */
            logs?: components["schemas"]["ServerLogsSettings"];
            /** @description Settings for controlling server services behavior */
            services?: components["schemas"]["ServerServicesSettings"];
            /** @description Settings for controlling server tasks behavior */
            tasks?: components["schemas"]["ServerTasksSettings"];
            /** @description Settings for controlling server UI behavior */
            ui?: components["schemas"]["ServerUISettings"];
        };
        /**
         * ServerTasksSchedulingSettings
         * @description Settings for controlling server-side behavior related to task scheduling
         */
        ServerTasksSchedulingSettings: {
            /**
             * Max Scheduled Queue Size
             * @description The maximum number of scheduled tasks to queue for submission.
             * @default 1000
             */
            max_scheduled_queue_size: number;
            /**
             * Max Retry Queue Size
             * @description The maximum number of retries to queue for submission.
             * @default 100
             */
            max_retry_queue_size: number;
            /**
             * Pending Task Timeout
             * Format: duration
             * @description How long before a PENDING task are made available to another task worker.
             * @default PT0S
             */
            pending_task_timeout: string;
        };
        /**
         * ServerTasksSettings
         * @description Settings for controlling server-side behavior related to tasks
         */
        ServerTasksSettings: {
            /**
             * Tag Concurrency Slot Wait Seconds
             * @description The number of seconds to wait before retrying when a task run cannot secure a concurrency slot from the server.
             * @default 30
             */
            tag_concurrency_slot_wait_seconds: number;
            /**
             * Max Cache Key Length
             * @description The maximum number of characters allowed for a task run cache key.
             * @default 2000
             */
            max_cache_key_length: number;
            scheduling?: components["schemas"]["ServerTasksSchedulingSettings"];
        };
        /** ServerUISettings */
        ServerUISettings: {
            /**
             * Enabled
             * @description Whether or not to serve the Prefect UI.
             * @default true
             */
            enabled: boolean;
            /**
             * Api Url
             * @description The connection url for communication from the UI to the API. Defaults to `PREFECT_API_URL` if set. Otherwise, the default URL is generated from `PREFECT_SERVER_API_HOST` and `PREFECT_SERVER_API_PORT`.
             */
            api_url?: string | null;
            /**
             * Serve Base
             * @description The base URL path to serve the Prefect UI from.
             * @default /
             */
            serve_base: string;
            /**
             * Static Directory
             * @description The directory to serve static files from. This should be used when running into permissions issues when attempting to serve the UI from the default directory (for example when running in a Docker container).
             */
            static_directory?: string | null;
            /**
             * Show Promotional Content
             * @description Whether or not to display promotional content in the UI, including upgrade prompts and marketing banners.
             * @default true
             */
            show_promotional_content: boolean;
        };
        /**
         * SetStateStatus
         * @description Enumerates return statuses for setting run states.
         * @enum {string}
         */
        SetStateStatus: "ACCEPT" | "REJECT" | "ABORT" | "WAIT";
        /**
         * Settings
         * @description Settings for Prefect using Pydantic settings.
         *
         *     See https://docs.pydantic.dev/latest/concepts/pydantic_settings
         */
        Settings: {
            /**
             * Home
             * Format: path
             * @description The path to the Prefect home directory. Defaults to ~/.prefect
             * @default ~/.prefect
             */
            home: string;
            /**
             * Profiles Path
             * Format: path
             * @description The path to a profiles configuration file. Supports \$PREFECT_HOME templating. Defaults to \$PREFECT_HOME/profiles.toml.
             */
            profiles_path?: string;
            /**
             * Debug Mode
             * @description If True, enables debug mode which may provide additional logging and debugging features.
             * @default false
             */
            debug_mode: boolean;
            api?: components["schemas"]["APISettings"];
            cli?: components["schemas"]["CLISettings"];
            client?: components["schemas"]["ClientSettings"];
            cloud?: components["schemas"]["CloudSettings"];
            deployments?: components["schemas"]["DeploymentsSettings"];
            /** @description Settings for controlling experimental features */
            experiments?: components["schemas"]["ExperimentsSettings"];
            flows?: components["schemas"]["FlowsSettings"];
            /** @description Settings for internal Prefect machinery */
            internal?: components["schemas"]["InternalSettings"];
            logging?: components["schemas"]["LoggingSettings"];
            results?: components["schemas"]["ResultsSettings"];
            runner?: components["schemas"]["RunnerSettings"];
            server?: components["schemas"]["ServerSettings"];
            /** @description Settings for controlling task behavior */
            tasks?: components["schemas"]["TasksSettings"];
            /** @description Settings used during testing */
            testing?: components["schemas"]["TestingSettings"];
            /** @description Settings for controlling worker behavior */
            worker?: components["schemas"]["WorkerSettings"];
            /**
             * Ui Url
             * @description The URL of the Prefect UI. If not set, the client will attempt to infer it.
             */
            ui_url?: string | null;
            /**
             * Silence Api Url Misconfiguration
             * @description If `True`, disable the warning when a user accidentally misconfigure its `PREFECT_API_URL`
             *             Sometimes when a user manually set `PREFECT_API_URL` to a custom url,reverse-proxy for example,
             *             we would like to silence this warning so we will set it to `FALSE`.
             * @default false
             */
            silence_api_url_misconfiguration: boolean;
        };
        /** SimpleFlowRun */
        SimpleFlowRun: {
            /**
             * Id
             * Format: uuid
             * @description The flow run id.
             */
            id: string;
            /** @description The state type. */
            state_type: components["schemas"]["StateType"];
            /**
             * Timestamp
             * Format: date-time
             * @description The start time of the run, or the expected start time if it hasn't run yet.
             */
            timestamp: string;
            /**
             * Duration
             * @description The total run time of the run.
             */
            duration: number;
            /**
             * Lateness
             * @description The delay between the expected and actual start time.
             */
            lateness: number;
        };
        /** SimpleNextFlowRun */
        SimpleNextFlowRun: {
            /**
             * Id
             * Format: uuid
             * @description The flow run id.
             */
            id: string;
            /**
             * Flow Id
             * Format: uuid
             * @description The flow id.
             */
            flow_id: string;
            /**
             * Name
             * @description The flow run name
             */
            name: string;
            /**
             * State Name
             * @description The state name.
             */
            state_name: string;
            /** @description The state type. */
            state_type: components["schemas"]["StateType"];
            /**
             * Next Scheduled Start Time
             * Format: date-time
             * @description The next scheduled start time
             */
            next_scheduled_start_time: string;
        };
        /**
         * State
         * @description Represents the state of a run.
         */
        State: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            type: components["schemas"]["StateType"];
            /** Name */
            name?: string | null;
            /**
             * Timestamp
             * Format: date-time
             */
            timestamp?: string;
            /**
             * Message
             * @example Run started
             */
            message?: string | null;
            /**
             * Data
             * @description Data associated with the state, e.g. a result. Content must be storable as JSON.
             */
            data?: unknown | null;
            state_details?: components["schemas"]["StateDetails"];
        };
        /**
         * StateAbortDetails
         * @description Details associated with an ABORT state transition.
         */
        StateAbortDetails: {
            /**
             * Type
             * @description The type of state transition detail. Used to ensure pydantic does not coerce into a different type.
             * @default abort_details
             * @constant
             */
            type: "abort_details";
            /**
             * Reason
             * @description The reason why the state transition was aborted.
             */
            reason?: string | null;
        };
        /**
         * StateAcceptDetails
         * @description Details associated with an ACCEPT state transition.
         */
        StateAcceptDetails: {
            /**
             * Type
             * @description The type of state transition detail. Used to ensure pydantic does not coerce into a different type.
             * @default accept_details
             * @constant
             */
            type: "accept_details";
        };
        /**
         * StateCreate
         * @description Data used by the Prefect REST API to create a new state.
         */
        StateCreate: {
            /** @description The type of the state to create */
            type: components["schemas"]["StateType"];
            /**
             * Name
             * @description The name of the state to create
             */
            name?: string | null;
            /**
             * Message
             * @description The message of the state to create
             */
            message?: string | null;
            /**
             * Data
             * @description The data of the state to create
             */
            data?: unknown | null;
            /** @description The details of the state to create */
            state_details?: components["schemas"]["StateDetails"];
        };
        /** StateDetails */
        StateDetails: {
            /** Flow Run Id */
            flow_run_id?: string | null;
            /** Task Run Id */
            task_run_id?: string | null;
            /** Child Flow Run Id */
            child_flow_run_id?: string | null;
            /** Scheduled Time */
            scheduled_time?: string | null;
            /** Cache Key */
            cache_key?: string | null;
            /** Cache Expiration */
            cache_expiration?: string | null;
            /**
             * Deferred
             * @default false
             */
            deferred: boolean | null;
            /**
             * Untrackable Result
             * @default false
             */
            untrackable_result: boolean;
            /** Pause Timeout */
            pause_timeout?: string | null;
            /**
             * Pause Reschedule
             * @default false
             */
            pause_reschedule: boolean;
            /** Pause Key */
            pause_key?: string | null;
            /** Run Input Keyset */
            run_input_keyset?: {
                [key: string]: string;
            } | null;
            /** Refresh Cache */
            refresh_cache?: boolean | null;
            /** Retriable */
            retriable?: boolean | null;
            /** Transition Id */
            transition_id?: string | null;
            /** Task Parameters Id */
            task_parameters_id?: string | null;
            /** Traceparent */
            traceparent?: string | null;
            /** Deployment Concurrency Lease Id */
            deployment_concurrency_lease_id?: string | null;
        };
        /**
         * StateRejectDetails
         * @description Details associated with a REJECT state transition.
         */
        StateRejectDetails: {
            /**
             * Type
             * @description The type of state transition detail. Used to ensure pydantic does not coerce into a different type.
             * @default reject_details
             * @constant
             */
            type: "reject_details";
            /**
             * Reason
             * @description The reason why the state transition was rejected.
             */
            reason?: string | null;
        };
        /**
         * StateType
         * @description Enumeration of state types.
         * @enum {string}
         */
        StateType: "SCHEDULED" | "PENDING" | "RUNNING" | "COMPLETED" | "FAILED" | "CANCELLED" | "CRASHED" | "PAUSED" | "CANCELLING";
        /**
         * StateWaitDetails
         * @description Details associated with a WAIT state transition.
         */
        StateWaitDetails: {
            /**
             * Type
             * @description The type of state transition detail. Used to ensure pydantic does not coerce into a different type.
             * @default wait_details
             * @constant
             */
            type: "wait_details";
            /**
             * Delay Seconds
             * @description The length of time in seconds the client should wait before transitioning states.
             */
            delay_seconds: number;
            /**
             * Reason
             * @description The reason why the state transition should wait.
             */
            reason?: string | null;
        };
        /**
         * SuspendFlowRun
         * @description Suspends a flow run associated with the trigger
         */
        SuspendFlowRun: {
            /**
             * Type
             * @default suspend-flow-run
             * @constant
             */
            type: "suspend-flow-run";
        };
        /**
         * TaskRun
         * @description An ORM representation of task run data.
         */
        TaskRun: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @example my-task-run
             */
            name?: string;
            /**
             * Flow Run Id
             * @description The flow run id of the task run.
             */
            flow_run_id?: string | null;
            /**
             * Task Key
             * @description A unique identifier for the task being run.
             */
            task_key: string;
            /**
             * Dynamic Key
             * @description A dynamic key used to differentiate between multiple runs of the same task within the same flow run.
             */
            dynamic_key: string;
            /**
             * Cache Key
             * @description An optional cache key. If a COMPLETED state associated with this cache key is found, the cached COMPLETED state will be used instead of executing the task run.
             */
            cache_key?: string | null;
            /**
             * Cache Expiration
             * @description Specifies when the cached state should expire.
             */
            cache_expiration?: string | null;
            /**
             * Task Version
             * @description The version of the task being run.
             */
            task_version?: string | null;
            empirical_policy?: components["schemas"]["TaskRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the task run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /**
             * State Id
             * @description The id of the current task run state.
             */
            state_id?: string | null;
            /**
             * Task Inputs
             * @description Tracks the source of inputs to a task run. Used for internal bookkeeping.
             */
            task_inputs?: {
                [key: string]: (components["schemas"]["TaskRunResult"] | components["schemas"]["FlowRunResult"] | components["schemas"]["Parameter"] | components["schemas"]["Constant"])[];
            };
            /** @description The type of the current task run state. */
            state_type?: components["schemas"]["StateType"] | null;
            /**
             * State Name
             * @description The name of the current task run state.
             */
            state_name?: string | null;
            /**
             * Run Count
             * @description The number of times the task run has been executed.
             * @default 0
             */
            run_count: number;
            /**
             * Flow Run Run Count
             * @description If the parent flow has retried, this indicates the flow retry this run is associated with.
             * @default 0
             */
            flow_run_run_count: number;
            /**
             * Expected Start Time
             * @description The task run's expected start time.
             */
            expected_start_time?: string | null;
            /**
             * Next Scheduled Start Time
             * @description The next time the task run is scheduled to start.
             */
            next_scheduled_start_time?: string | null;
            /**
             * Start Time
             * @description The actual start time.
             */
            start_time?: string | null;
            /**
             * End Time
             * @description The actual end time.
             */
            end_time?: string | null;
            /**
             * Total Run Time
             * @description Total run time. If the task run was executed multiple times, the time of each run will be summed.
             * @default 0
             */
            total_run_time: number;
            /**
             * Estimated Run Time
             * @description A real-time estimate of total run time.
             * @default 0
             */
            estimated_run_time: number;
            /**
             * Estimated Start Time Delta
             * @description The difference between actual and expected start time.
             * @default 0
             */
            estimated_start_time_delta: number;
            /** @description The current task run state. */
            state?: components["schemas"]["State"] | null;
        };
        TaskRunCount: {
            [key: string]: number;
        };
        /**
         * TaskRunCreate
         * @description Data used by the Prefect REST API to create a task run
         */
        TaskRunCreate: {
            /**
             * Id
             * @description The ID to assign to the task run. If not provided, a random UUID will be generated.
             */
            id?: string | null;
            /** @description The state of the task run to create */
            state?: components["schemas"]["StateCreate"] | null;
            /**
             * Name
             * @example my-task-run
             */
            name?: string;
            /**
             * Flow Run Id
             * @description The flow run id of the task run.
             */
            flow_run_id?: string | null;
            /**
             * Task Key
             * @description A unique identifier for the task being run.
             */
            task_key: string;
            /**
             * Dynamic Key
             * @description A dynamic key used to differentiate between multiple runs of the same task within the same flow run.
             */
            dynamic_key: string;
            /**
             * Cache Key
             * @description An optional cache key. If a COMPLETED state associated with this cache key is found, the cached COMPLETED state will be used instead of executing the task run.
             */
            cache_key?: string | null;
            /**
             * Cache Expiration
             * @description Specifies when the cached state should expire.
             */
            cache_expiration?: string | null;
            /**
             * Task Version
             * @description The version of the task being run.
             */
            task_version?: string | null;
            empirical_policy?: components["schemas"]["TaskRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the task run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /**
             * Task Inputs
             * @description The inputs to the task run.
             */
            task_inputs?: {
                [key: string]: (components["schemas"]["TaskRunResult"] | components["schemas"]["FlowRunResult"] | components["schemas"]["Parameter"] | components["schemas"]["Constant"])[];
            };
        };
        /**
         * TaskRunFilter
         * @description Filter task runs. Only task runs matching all criteria will be returned
         */
        TaskRunFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `TaskRun.id` */
            id?: components["schemas"]["TaskRunFilterId"] | null;
            /** @description Filter criteria for `TaskRun.name` */
            name?: components["schemas"]["TaskRunFilterName"] | null;
            /** @description Filter criteria for `TaskRun.tags` */
            tags?: components["schemas"]["TaskRunFilterTags"] | null;
            /** @description Filter criteria for `TaskRun.state` */
            state?: components["schemas"]["TaskRunFilterState"] | null;
            /** @description Filter criteria for `TaskRun.start_time` */
            start_time?: components["schemas"]["TaskRunFilterStartTime"] | null;
            /** @description Filter criteria for `TaskRun.expected_start_time` */
            expected_start_time?: components["schemas"]["TaskRunFilterExpectedStartTime"] | null;
            /** @description Filter criteria for `TaskRun.subflow_run` */
            subflow_runs?: components["schemas"]["TaskRunFilterSubFlowRuns"] | null;
            /** @description Filter criteria for `TaskRun.flow_run_id` */
            flow_run_id?: components["schemas"]["TaskRunFilterFlowRunId"] | null;
        };
        /**
         * TaskRunFilterExpectedStartTime
         * @description Filter by `TaskRun.expected_start_time`.
         */
        TaskRunFilterExpectedStartTime: {
            /**
             * Before
             * @description Only include task runs expected to start at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include task runs expected to start at or after this time
             */
            after_?: string | null;
        };
        /**
         * TaskRunFilterFlowRunId
         * @description Filter by `TaskRun.flow_run_id`.
         */
        TaskRunFilterFlowRunId: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * Any
             * @description A list of task run flow run ids to include
             */
            any_?: string[] | null;
            /**
             * Is Null
             * @description Filter for task runs with None as their flow run id
             * @default false
             */
            is_null_: boolean | null;
        };
        /**
         * TaskRunFilterId
         * @description Filter by `TaskRun.id`.
         */
        TaskRunFilterId: {
            /**
             * Any
             * @description A list of task run ids to include
             */
            any_?: string[] | null;
        };
        /**
         * TaskRunFilterName
         * @description Filter by `TaskRun.name`.
         */
        TaskRunFilterName: {
            /**
             * Any
             * @description A list of task run names to include
             * @example [
             *       "my-task-run-1",
             *       "my-task-run-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A case-insensitive partial match. For example,  passing 'marvin' will match 'marvin', 'sad-Marvin', and 'marvin-robot'.
             * @example marvin
             */
            like_?: string | null;
        };
        /**
         * TaskRunFilterStartTime
         * @description Filter by `TaskRun.start_time`.
         */
        TaskRunFilterStartTime: {
            /**
             * Before
             * @description Only include task runs starting at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include task runs starting at or after this time
             */
            after_?: string | null;
            /**
             * Is Null
             * @description If true, only return task runs without a start time
             */
            is_null_?: boolean | null;
        };
        /**
         * TaskRunFilterState
         * @description Filter by `TaskRun.type` and `TaskRun.name`.
         */
        TaskRunFilterState: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `TaskRun.state_type` */
            type?: components["schemas"]["TaskRunFilterStateType"] | null;
            /** @description Filter criteria for `TaskRun.state_name` */
            name?: components["schemas"]["TaskRunFilterStateName"] | null;
        };
        /**
         * TaskRunFilterStateName
         * @description Filter by `TaskRun.state_name`.
         */
        TaskRunFilterStateName: {
            /**
             * Any
             * @description A list of task run state names to include
             */
            any_?: string[] | null;
        };
        /**
         * TaskRunFilterStateType
         * @description Filter by `TaskRun.state_type`.
         */
        TaskRunFilterStateType: {
            /**
             * Any
             * @description A list of task run state types to include
             */
            any_?: components["schemas"]["StateType"][] | null;
        };
        /**
         * TaskRunFilterSubFlowRuns
         * @description Filter by `TaskRun.subflow_run`.
         */
        TaskRunFilterSubFlowRuns: {
            /**
             * Exists
             * @description If true, only include task runs that are subflow run parents; if false, exclude parent task runs
             */
            exists_?: boolean | null;
        };
        /**
         * TaskRunFilterTags
         * @description Filter by `TaskRun.tags`.
         */
        TaskRunFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Task runs will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include task runs without tags
             */
            is_null_?: boolean | null;
        };
        /** TaskRunPaginationResponse */
        TaskRunPaginationResponse: {
            /** Results */
            results: components["schemas"]["TaskRunResponse"][];
            /** Count */
            count: number;
            /** Limit */
            limit: number;
            /** Pages */
            pages: number;
            /** Page */
            page: number;
        };
        /**
         * TaskRunPolicy
         * @description Defines of how a task run should retry.
         */
        TaskRunPolicy: {
            /**
             * Max Retries
             * @deprecated
             * @description The maximum number of retries. Field is not used. Please use `retries` instead.
             * @default 0
             */
            max_retries: number;
            /**
             * Retry Delay Seconds
             * @deprecated
             * @description The delay between retries. Field is not used. Please use `retry_delay` instead.
             * @default 0
             */
            retry_delay_seconds: number;
            /**
             * Retries
             * @description The number of retries.
             */
            retries?: number | null;
            /**
             * Retry Delay
             * @description A delay time or list of delay times between retries, in seconds.
             */
            retry_delay?: number | number[] | number[] | null;
            /**
             * Retry Jitter Factor
             * @description Determines the amount a retry should jitter
             */
            retry_jitter_factor?: number | null;
        };
        /** TaskRunResponse */
        TaskRunResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the task run. Defaults to a random slug if not specified.
             * @example my-task-run
             */
            name?: string;
            /**
             * Flow Run Id
             * @description The id of the flow run this task run belongs to.
             */
            flow_run_id?: string | null;
            /**
             * Task Key
             * @description The key of the task this run represents.
             */
            task_key: string;
            /**
             * State Id
             * @description The id of the task run's current state.
             */
            state_id?: string | null;
            /** @description The current state of the task run. */
            state?: components["schemas"]["State"] | null;
            /**
             * Task Version
             * @description The version of the task executed in this task run.
             * @example 1.0
             */
            task_version?: string | null;
            /**
             * Task Inputs
             * @description Inputs provided to the task run.
             */
            task_inputs?: {
                [key: string]: (components["schemas"]["TaskRunResult"] | components["schemas"]["FlowRunResult"] | components["schemas"]["Parameter"] | components["schemas"]["Constant"])[];
            };
            /** @description The task run's empirical retry policy. */
            empirical_policy?: components["schemas"]["TaskRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the task run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
        };
        /**
         * TaskRunResult
         * @description Represents a task run result input to another task run.
         */
        TaskRunResult: {
            /**
             * Input Type
             * @default task_run
             * @constant
             */
            input_type: "task_run";
            /**
             * Id
             * Format: uuid
             */
            id: string;
        };
        /**
         * TaskRunSort
         * @description Defines task run sorting options.
         * @enum {string}
         */
        TaskRunSort: "ID_DESC" | "EXPECTED_START_TIME_ASC" | "EXPECTED_START_TIME_DESC" | "NAME_ASC" | "NAME_DESC" | "NEXT_SCHEDULED_START_TIME_ASC" | "END_TIME_DESC";
        /**
         * TaskRunUpdate
         * @description Data used by the Prefect REST API to update a task run
         */
        TaskRunUpdate: {
            /**
             * Name
             * @example my-task-run
             */
            name?: string;
        };
        /** TaskWorkerFilter */
        TaskWorkerFilter: {
            /** Task Keys */
            task_keys: string[];
        };
        /** TaskWorkerResponse */
        TaskWorkerResponse: {
            /** Identifier */
            identifier: string;
            /** Task Keys */
            task_keys: string[];
            /**
             * Timestamp
             * Format: date-time
             */
            timestamp: string;
        };
        /** TasksRunnerSettings */
        TasksRunnerSettings: {
            /**
             * Thread Pool Max Workers
             * @description The maximum number of workers for ThreadPoolTaskRunner.
             */
            thread_pool_max_workers?: number | null;
            /**
             * Process Pool Max Workers
             * @description The maximum number of workers for ProcessPoolTaskRunner.
             */
            process_pool_max_workers?: number | null;
        };
        /** TasksSchedulingSettings */
        TasksSchedulingSettings: {
            /**
             * Default Storage Block
             * @description The `block-type/block-document` slug of a block to use as the default storage for autonomous tasks.
             */
            default_storage_block?: string | null;
            /**
             * Delete Failed Submissions
             * @description Whether or not to delete failed task submissions from the database.
             * @default true
             */
            delete_failed_submissions: boolean;
        };
        /** TasksSettings */
        TasksSettings: {
            /**
             * Refresh Cache
             * @description If `True`, enables a refresh of cached results: re-executing the task will refresh the cached results.
             * @default false
             */
            refresh_cache: boolean;
            /**
             * Default No Cache
             * @description If `True`, sets the default cache policy on all tasks to `NO_CACHE`.
             * @default false
             */
            default_no_cache: boolean;
            /**
             * Disable Caching
             * @description If `True`, disables caching on all tasks regardless of cache policy.
             * @default false
             */
            disable_caching: boolean;
            /**
             * Default Retries
             * @description This value sets the default number of retries for all tasks.
             * @default 0
             */
            default_retries: number;
            /**
             * Default Retry Delay Seconds
             * @description This value sets the default retry delay seconds for all tasks.
             * @default 0
             */
            default_retry_delay_seconds: string | number | number[] | null;
            /**
             * Default Persist Result
             * @description If `True`, results will be persisted by default for all tasks. Set to `False` to disable persistence by default. Note that setting to `False` will override the behavior set by a parent flow or task.
             */
            default_persist_result?: boolean | null;
            /** @description Settings for controlling task runner behavior */
            runner?: components["schemas"]["TasksRunnerSettings"];
            /** @description Settings for controlling client-side task scheduling behavior */
            scheduling?: components["schemas"]["TasksSchedulingSettings"];
        };
        /** TestingSettings */
        TestingSettings: {
            /**
             * Test Mode
             * @description If `True`, places the API in test mode. This may modify behavior to facilitate testing.
             * @default false
             */
            test_mode: boolean;
            /**
             * Unit Test Mode
             * @description This setting only exists to facilitate unit testing. If `True`, code is executing in a unit test context. Defaults to `False`.
             * @default false
             */
            unit_test_mode: boolean;
            /**
             * Unit Test Loop Debug
             * @description If `True` turns on debug mode for the unit testing event loop.
             * @default true
             */
            unit_test_loop_debug: boolean;
            /**
             * Test Setting
             * @description This setting only exists to facilitate unit testing. If in test mode, this setting will return its value. Otherwise, it returns `None`.
             * @default FOO
             */
            test_setting: unknown | null;
        };
        /**
         * TimeUnit
         * @enum {string}
         */
        TimeUnit: "week" | "day" | "hour" | "minute" | "second";
        /**
         * UITaskRun
         * @description A task run with additional details for display in the UI.
         */
        UITaskRun: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @example my-task-run
             */
            name?: string;
            /**
             * Flow Run Id
             * @description The flow run id of the task run.
             */
            flow_run_id?: string | null;
            /**
             * Task Key
             * @description A unique identifier for the task being run.
             */
            task_key: string;
            /**
             * Dynamic Key
             * @description A dynamic key used to differentiate between multiple runs of the same task within the same flow run.
             */
            dynamic_key: string;
            /**
             * Cache Key
             * @description An optional cache key. If a COMPLETED state associated with this cache key is found, the cached COMPLETED state will be used instead of executing the task run.
             */
            cache_key?: string | null;
            /**
             * Cache Expiration
             * @description Specifies when the cached state should expire.
             */
            cache_expiration?: string | null;
            /**
             * Task Version
             * @description The version of the task being run.
             */
            task_version?: string | null;
            empirical_policy?: components["schemas"]["TaskRunPolicy"];
            /**
             * Tags
             * @description A list of tags for the task run.
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
            /**
             * Labels
             * @description A dictionary of key-value labels. Values can be strings, numbers, or booleans.
             * @example {
             *       "key": "value1",
             *       "key2": 42
             *     }
             */
            labels?: {
                [key: string]: boolean | number | string;
            } | null;
            /**
             * State Id
             * @description The id of the current task run state.
             */
            state_id?: string | null;
            /**
             * Task Inputs
             * @description Tracks the source of inputs to a task run. Used for internal bookkeeping.
             */
            task_inputs?: {
                [key: string]: (components["schemas"]["TaskRunResult"] | components["schemas"]["FlowRunResult"] | components["schemas"]["Parameter"] | components["schemas"]["Constant"])[];
            };
            /** @description The type of the current task run state. */
            state_type?: components["schemas"]["StateType"] | null;
            /**
             * State Name
             * @description The name of the current task run state.
             */
            state_name?: string | null;
            /**
             * Run Count
             * @description The number of times the task run has been executed.
             * @default 0
             */
            run_count: number;
            /**
             * Flow Run Run Count
             * @description If the parent flow has retried, this indicates the flow retry this run is associated with.
             * @default 0
             */
            flow_run_run_count: number;
            /**
             * Expected Start Time
             * @description The task run's expected start time.
             */
            expected_start_time?: string | null;
            /**
             * Next Scheduled Start Time
             * @description The next time the task run is scheduled to start.
             */
            next_scheduled_start_time?: string | null;
            /**
             * Start Time
             * @description The actual start time.
             */
            start_time?: string | null;
            /**
             * End Time
             * @description The actual end time.
             */
            end_time?: string | null;
            /**
             * Total Run Time
             * @description Total run time. If the task run was executed multiple times, the time of each run will be summed.
             * @default 0
             */
            total_run_time: number;
            /**
             * Estimated Run Time
             * @description A real-time estimate of total run time.
             * @default 0
             */
            estimated_run_time: number;
            /**
             * Estimated Start Time Delta
             * @description The difference between actual and expected start time.
             * @default 0
             */
            estimated_start_time_delta: number;
            /** @description The current task run state. */
            state?: components["schemas"]["State"] | null;
            /** Flow Run Name */
            flow_run_name?: string | null;
        };
        /** UpdatedBy */
        UpdatedBy: {
            /**
             * Id
             * @description The id of the updater of the object.
             */
            id?: string | null;
            /**
             * Type
             * @description The type of the updater of the object.
             */
            type?: string | null;
            /**
             * Display Value
             * @description The display value for the updater.
             */
            display_value?: string | null;
        };
        /** ValidationError */
        ValidationError: {
            /** Location */
            loc: (string | number)[];
            /** Message */
            msg: string;
            /** Error Type */
            type: string;
        };
        /** Variable */
        Variable: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the variable
             * @example my-variable
             */
            name: string;
            /**
             * Value
             * @description The value of the variable
             * @example my-value
             */
            value: string | number | boolean | {
                [key: string]: unknown;
            } | unknown[] | null;
            /**
             * Tags
             * @description A list of variable tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
        };
        /**
         * VariableCreate
         * @description Data used by the Prefect REST API to create a Variable.
         */
        VariableCreate: {
            /**
             * Name
             * @description The name of the variable
             * @example my_variable
             */
            name: string;
            /**
             * Value
             * @description The value of the variable
             * @example my-value
             */
            value: string | number | boolean | {
                [key: string]: unknown;
            } | unknown[] | null;
            /**
             * Tags
             * @description A list of variable tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[];
        };
        /**
         * VariableFilter
         * @description Filter variables. Only variables matching all criteria will be returned
         */
        VariableFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Variable.id` */
            id?: components["schemas"]["VariableFilterId"] | null;
            /** @description Filter criteria for `Variable.name` */
            name?: components["schemas"]["VariableFilterName"] | null;
            /** @description Filter criteria for `Variable.tags` */
            tags?: components["schemas"]["VariableFilterTags"] | null;
        };
        /**
         * VariableFilterId
         * @description Filter by `Variable.id`.
         */
        VariableFilterId: {
            /**
             * Any
             * @description A list of variable ids to include
             */
            any_?: string[] | null;
        };
        /**
         * VariableFilterName
         * @description Filter by `Variable.name`.
         */
        VariableFilterName: {
            /**
             * Any
             * @description A list of variables names to include
             */
            any_?: string[] | null;
            /**
             * Like
             * @description A string to match variable names against. This can include SQL wildcard characters like `%` and `_`.
             * @example my_variable_%
             */
            like_?: string | null;
        };
        /**
         * VariableFilterTags
         * @description Filter by `Variable.tags`.
         */
        VariableFilterTags: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /**
             * All
             * @description A list of tags. Variables will be returned only if their tags are a superset of the list
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            all_?: string[] | null;
            /**
             * Is Null
             * @description If true, only include Variables without tags
             */
            is_null_?: boolean | null;
        };
        /**
         * VariableSort
         * @description Defines variables sorting options.
         * @enum {string}
         */
        VariableSort: "CREATED_DESC" | "UPDATED_DESC" | "NAME_DESC" | "NAME_ASC";
        /**
         * VariableUpdate
         * @description Data used by the Prefect REST API to update a Variable.
         */
        VariableUpdate: {
            /** Name */
            name?: string | null;
            /**
             * Value
             * @description The value of the variable
             * @example my-value
             */
            value?: string | number | boolean | {
                [key: string]: unknown;
            } | unknown[] | null;
            /**
             * Tags
             * @description A list of variable tags
             * @example [
             *       "tag-1",
             *       "tag-2"
             *     ]
             */
            tags?: string[] | null;
        };
        /** VersionInfo */
        VersionInfo: {
            /**
             * Type
             * @description The type of version info.
             */
            type: string;
            /**
             * Version
             * @description The version of the deployment.
             */
            version: string;
        } & {
            [key: string]: unknown;
        };
        /**
         * WorkPool
         * @description An ORM representation of a work pool
         */
        WorkPool: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the work pool.
             */
            name: string;
            /**
             * Description
             * @description A description of the work pool.
             */
            description?: string | null;
            /**
             * Type
             * @description The work pool type.
             */
            type: string;
            /**
             * Base Job Template
             * @description The work pool's base job template.
             */
            base_job_template?: {
                [key: string]: unknown;
            };
            /**
             * Is Paused
             * @description Pausing the work pool stops the delivery of all work.
             * @default false
             */
            is_paused: boolean;
            /**
             * Concurrency Limit
             * @description A concurrency limit for the work pool.
             */
            concurrency_limit?: number | null;
            /** @description The current status of the work pool. */
            status?: components["schemas"]["WorkPoolStatus"] | null;
            /**
             * Default Queue Id
             * @description The id of the pool's default queue.
             */
            default_queue_id?: string | null;
            /** @description The storage configuration for the work pool. */
            storage_configuration?: components["schemas"]["WorkPoolStorageConfiguration"];
        };
        /**
         * WorkPoolCreate
         * @description Data used by the Prefect REST API to create a work pool.
         */
        WorkPoolCreate: {
            /**
             * Name
             * @description The name of the work pool.
             */
            name: string;
            /**
             * Description
             * @description The work pool description.
             */
            description?: string | null;
            /**
             * Type
             * @description The work pool type.
             * @default prefect-agent
             */
            type: string;
            /**
             * Base Job Template
             * @description The work pool's base job template.
             */
            base_job_template?: {
                [key: string]: unknown;
            };
            /**
             * Is Paused
             * @description Pausing the work pool stops the delivery of all work.
             * @default false
             */
            is_paused: boolean;
            /**
             * Concurrency Limit
             * @description A concurrency limit for the work pool.
             */
            concurrency_limit?: number | null;
            /** @description The storage configuration for the work pool. */
            storage_configuration?: components["schemas"]["WorkPoolStorageConfiguration"];
        };
        /**
         * WorkPoolFilter
         * @description Filter work pools. Only work pools matching all criteria will be returned
         */
        WorkPoolFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `WorkPool.id` */
            id?: components["schemas"]["WorkPoolFilterId"] | null;
            /** @description Filter criteria for `WorkPool.name` */
            name?: components["schemas"]["WorkPoolFilterName"] | null;
            /** @description Filter criteria for `WorkPool.type` */
            type?: components["schemas"]["WorkPoolFilterType"] | null;
        };
        /**
         * WorkPoolFilterId
         * @description Filter by `WorkPool.id`.
         */
        WorkPoolFilterId: {
            /**
             * Any
             * @description A list of work pool ids to include
             */
            any_?: string[] | null;
        };
        /**
         * WorkPoolFilterName
         * @description Filter by `WorkPool.name`.
         */
        WorkPoolFilterName: {
            /**
             * Any
             * @description A list of work pool names to include
             */
            any_?: string[] | null;
        };
        /**
         * WorkPoolFilterType
         * @description Filter by `WorkPool.type`.
         */
        WorkPoolFilterType: {
            /**
             * Any
             * @description A list of work pool types to include
             */
            any_?: string[] | null;
        };
        /**
         * WorkPoolStatus
         * @description Enumeration of work pool statuses.
         * @enum {string}
         */
        WorkPoolStatus: "READY" | "NOT_READY" | "PAUSED";
        /**
         * WorkPoolStorageConfiguration
         * @description A representation of a work pool's storage configuration
         */
        WorkPoolStorageConfiguration: {
            /**
             * Bundle Upload Step
             * @description The step to use for uploading bundles to storage.
             */
            bundle_upload_step?: {
                [key: string]: unknown;
            } | null;
            /**
             * Bundle Execution Step
             * @description The step to use for executing bundles.
             */
            bundle_execution_step?: {
                [key: string]: unknown;
            } | null;
            /**
             * Default Result Storage Block Id
             * @description The block document ID of the default result storage block.
             */
            default_result_storage_block_id?: string | null;
        };
        /**
         * WorkPoolUpdate
         * @description Data used by the Prefect REST API to update a work pool.
         */
        WorkPoolUpdate: {
            /** Description */
            description?: string | null;
            /** Is Paused */
            is_paused?: boolean | null;
            /** Base Job Template */
            base_job_template?: {
                [key: string]: unknown;
            } | null;
            /** Concurrency Limit */
            concurrency_limit?: number | null;
            /** @description The storage configuration for the work pool. */
            storage_configuration?: components["schemas"]["WorkPoolStorageConfiguration"] | null;
        };
        /**
         * WorkQueue
         * @description An ORM representation of a work queue
         */
        WorkQueue: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the work queue.
             */
            name: string;
            /**
             * Description
             * @description An optional description for the work queue.
             * @default
             */
            description: string | null;
            /**
             * Is Paused
             * @description Whether or not the work queue is paused.
             * @default false
             */
            is_paused: boolean;
            /**
             * Concurrency Limit
             * @description An optional concurrency limit for the work queue.
             */
            concurrency_limit?: number | null;
            /**
             * Priority
             * @description The queue's priority. Lower values are higher priority (1 is the highest).
             * @default 1
             */
            priority: number;
            /**
             * Work Pool Id
             * @description The work pool with which the queue is associated.
             */
            work_pool_id?: string | null;
            /**
             * @deprecated
             * @description DEPRECATED: Filter criteria for the work queue.
             */
            filter?: components["schemas"]["QueueFilter"] | null;
            /**
             * Last Polled
             * @description The last time an agent polled this queue for work.
             */
            last_polled?: string | null;
        };
        /**
         * WorkQueueCreate
         * @description Data used by the Prefect REST API to create a work queue.
         */
        WorkQueueCreate: {
            /**
             * Name
             * @description The name of the work queue.
             */
            name: string;
            /**
             * Description
             * @description An optional description for the work queue.
             * @default
             */
            description: string | null;
            /**
             * Is Paused
             * @description Whether or not the work queue is paused.
             * @default false
             */
            is_paused: boolean;
            /**
             * Concurrency Limit
             * @description The work queue's concurrency limit.
             */
            concurrency_limit?: number | null;
            /**
             * Priority
             * @description The queue's priority. Lower values are higher priority (1 is the highest).
             */
            priority?: number | null;
            /**
             * @deprecated
             * @description DEPRECATED: Filter criteria for the work queue.
             */
            filter?: components["schemas"]["QueueFilter"] | null;
        };
        /**
         * WorkQueueFilter
         * @description Filter work queues. Only work queues matching all criteria will be
         *     returned
         */
        WorkQueueFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `WorkQueue.id` */
            id?: components["schemas"]["WorkQueueFilterId"] | null;
            /** @description Filter criteria for `WorkQueue.name` */
            name?: components["schemas"]["WorkQueueFilterName"] | null;
        };
        /**
         * WorkQueueFilterId
         * @description Filter by `WorkQueue.id`.
         */
        WorkQueueFilterId: {
            /**
             * Any
             * @description A list of work queue ids to include
             */
            any_?: string[] | null;
        };
        /**
         * WorkQueueFilterName
         * @description Filter by `WorkQueue.name`.
         */
        WorkQueueFilterName: {
            /**
             * Any
             * @description A list of work queue names to include
             * @example [
             *       "wq-1",
             *       "wq-2"
             *     ]
             */
            any_?: string[] | null;
            /**
             * Startswith
             * @description A list of case-insensitive starts-with matches. For example,  passing 'marvin' will match 'marvin', and 'Marvin-robot', but not 'sad-marvin'.
             * @example [
             *       "marvin",
             *       "Marvin-robot"
             *     ]
             */
            startswith_?: string[] | null;
        };
        /** WorkQueueHealthPolicy */
        WorkQueueHealthPolicy: {
            /**
             * Maximum Late Runs
             * @description The maximum number of late runs in the work queue before it is deemed unhealthy. Defaults to `0`.
             * @default 0
             */
            maximum_late_runs: number | null;
            /**
             * Maximum Seconds Since Last Polled
             * @description The maximum number of time in seconds elapsed since work queue has been polled before it is deemed unhealthy. Defaults to `60`.
             * @default 60
             */
            maximum_seconds_since_last_polled: number | null;
        };
        /** WorkQueueResponse */
        WorkQueueResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the work queue.
             */
            name: string;
            /**
             * Description
             * @description An optional description for the work queue.
             * @default
             */
            description: string | null;
            /**
             * Is Paused
             * @description Whether or not the work queue is paused.
             * @default false
             */
            is_paused: boolean;
            /**
             * Concurrency Limit
             * @description An optional concurrency limit for the work queue.
             */
            concurrency_limit?: number | null;
            /**
             * Priority
             * @description The queue's priority. Lower values are higher priority (1 is the highest).
             * @default 1
             */
            priority: number;
            /**
             * Work Pool Id
             * @description The work pool with which the queue is associated.
             */
            work_pool_id?: string | null;
            /**
             * @deprecated
             * @description DEPRECATED: Filter criteria for the work queue.
             */
            filter?: components["schemas"]["QueueFilter"] | null;
            /**
             * Last Polled
             * @description The last time an agent polled this queue for work.
             */
            last_polled?: string | null;
            /**
             * Work Pool Name
             * @description The name of the work pool the work pool resides within.
             */
            work_pool_name?: string | null;
            /** @description The queue status. */
            status?: components["schemas"]["WorkQueueStatus"] | null;
        };
        /**
         * WorkQueueStatus
         * @description Enumeration of work queue statuses.
         * @enum {string}
         */
        WorkQueueStatus: "READY" | "NOT_READY" | "PAUSED";
        /** WorkQueueStatusDetail */
        WorkQueueStatusDetail: {
            /**
             * Healthy
             * @description Whether or not the work queue is healthy.
             */
            healthy: boolean;
            /**
             * Late Runs Count
             * @description The number of late flow runs in the work queue.
             * @default 0
             */
            late_runs_count: number;
            /**
             * Last Polled
             * @description The last time an agent polled this queue for work.
             */
            last_polled?: string | null;
            /** @description The policy used to determine whether or not the work queue is healthy. */
            health_check_policy: components["schemas"]["WorkQueueHealthPolicy"];
        };
        /**
         * WorkQueueUpdate
         * @description Data used by the Prefect REST API to update a work queue.
         */
        WorkQueueUpdate: {
            /** Name */
            name?: string | null;
            /** Description */
            description?: string | null;
            /**
             * Is Paused
             * @description Whether or not the work queue is paused.
             * @default false
             */
            is_paused: boolean;
            /** Concurrency Limit */
            concurrency_limit?: number | null;
            /** Priority */
            priority?: number | null;
            /** Last Polled */
            last_polled?: string | null;
            /**
             * @deprecated
             * @description DEPRECATED: Filter criteria for the work queue.
             */
            filter?: components["schemas"]["QueueFilter"] | null;
        };
        /**
         * WorkerFilter
         * @description Filter by `Worker.last_heartbeat_time`.
         */
        WorkerFilter: {
            /**
             * @description Operator for combining filter criteria. Defaults to 'and_'.
             * @default and_
             */
            operator: components["schemas"]["Operator"];
            /** @description Filter criteria for `Worker.last_heartbeat_time` */
            last_heartbeat_time?: components["schemas"]["WorkerFilterLastHeartbeatTime"] | null;
            /** @description Filter criteria for `Worker.status` */
            status?: components["schemas"]["WorkerFilterStatus"] | null;
        };
        /**
         * WorkerFilterLastHeartbeatTime
         * @description Filter by `Worker.last_heartbeat_time`.
         */
        WorkerFilterLastHeartbeatTime: {
            /**
             * Before
             * @description Only include processes whose last heartbeat was at or before this time
             */
            before_?: string | null;
            /**
             * After
             * @description Only include processes whose last heartbeat was at or after this time
             */
            after_?: string | null;
        };
        /**
         * WorkerFilterStatus
         * @description Filter by `Worker.status`.
         */
        WorkerFilterStatus: {
            /**
             * Any
             * @description A list of worker statuses to include
             */
            any_?: components["schemas"]["WorkerStatus"][] | null;
            /**
             * Not Any
             * @description A list of worker statuses to exclude
             */
            not_any_?: components["schemas"]["WorkerStatus"][] | null;
        };
        /** WorkerFlowRunResponse */
        WorkerFlowRunResponse: {
            /**
             * Work Pool Id
             * Format: uuid
             */
            work_pool_id: string;
            /**
             * Work Queue Id
             * Format: uuid
             */
            work_queue_id: string;
            flow_run: components["schemas"]["FlowRun"];
        };
        /** WorkerResponse */
        WorkerResponse: {
            /**
             * Id
             * Format: uuid
             */
            id: string;
            /** Created */
            created: string | null;
            /** Updated */
            updated: string | null;
            /**
             * Name
             * @description The name of the worker.
             */
            name: string;
            /**
             * Work Pool Id
             * Format: uuid
             * @description The work pool with which the queue is associated.
             */
            work_pool_id: string;
            /**
             * Last Heartbeat Time
             * @description The last time the worker process sent a heartbeat.
             */
            last_heartbeat_time?: string | null;
            /**
             * Heartbeat Interval Seconds
             * @description The number of seconds to expect between heartbeats sent by the worker.
             */
            heartbeat_interval_seconds?: number | null;
            /**
             * @description Current status of the worker.
             * @default OFFLINE
             */
            status: components["schemas"]["WorkerStatus"];
        };
        /** WorkerSettings */
        WorkerSettings: {
            /**
             * Heartbeat Seconds
             * @description Number of seconds a worker should wait between sending a heartbeat.
             * @default 30
             */
            heartbeat_seconds: number;
            /**
             * Query Seconds
             * @description Number of seconds a worker should wait between queries for scheduled work.
             * @default 10
             */
            query_seconds: number;
            /**
             * Prefetch Seconds
             * @description The number of seconds into the future a worker should query for scheduled work.
             * @default 10
             */
            prefetch_seconds: number;
            /** @description Settings for a worker's webserver */
            webserver?: components["schemas"]["WorkerWebserverSettings"];
        };
        /**
         * WorkerStatus
         * @description Enumeration of worker statuses.
         * @enum {string}
         */
        WorkerStatus: "ONLINE" | "OFFLINE";
        /** WorkerWebserverSettings */
        WorkerWebserverSettings: {
            /**
             * Host
             * @description The host address the worker's webserver should bind to.
             * @default 0.0.0.0
             */
            host: string;
            /**
             * Port
             * @description The port the worker's webserver should bind to.
             * @default 8080
             */
            port: number;
        };
    };
    responses: never;
    parameters: never;
    requestBodies: never;
    headers: never;
    pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
    health_check_health_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": boolean;
                };
            };
        };
    };
    server_version_version_get: {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": string;
                };
            };
        };
    };
    create_flow_flows__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["FlowCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Flow"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_flows__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Flow"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_flow_flows__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_flow_flows__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["FlowUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_flows_flows_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_flows_flows_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_by_name_flows_name__name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The name of the flow */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Flow"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flows_flows_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_flows_flows_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Flow"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    paginate_flows_flows_paginate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_paginate_flows_flows_paginate_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowPaginationResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_flow_run_flow_runs__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["FlowRunCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_flow_runs__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_flow_run_flow_runs__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_flow_run_flow_runs__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["FlowRunUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_flow_runs_flow_runs_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_flow_runs_flow_runs_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    average_flow_run_lateness_flow_runs_lateness_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_average_flow_run_lateness_flow_runs_lateness_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number | null;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    flow_run_history_flow_runs_history_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_flow_run_history_flow_runs_history_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HistoryResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_graph_v1_flow_runs__id__graph_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DependencyResult"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_graph_v2_flow_runs__id__graph_v2_get: {
        parameters: {
            query?: {
                /** @description Only include runs that start or end after this time. */
                since?: string;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Graph"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    resume_flow_run_flow_runs__id__resume_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_resume_flow_run_flow_runs__id__resume_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["OrchestrationResult"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_runs_flow_runs_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_flow_runs_flow_runs_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    set_flow_run_state_flow_runs__id__set_state_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_set_flow_run_state_flow_runs__id__set_state_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["OrchestrationResult"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_flow_run_input_flow_runs__id__input_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_create_flow_run_input_flow_runs__id__input_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    filter_flow_run_input_flow_runs__id__input_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_filter_flow_run_input_flow_runs__id__input_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunInput"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_input_flow_runs__id__input__key__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
                /** @description The input key */
                key: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_flow_run_input_flow_runs__id__input__key__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
                /** @description The input key */
                key: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    paginate_flow_runs_flow_runs_paginate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_paginate_flow_runs_flow_runs_paginate_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunPaginationResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    download_logs_flow_runs__id__logs_download_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_flow_run_labels_flow_runs__id__labels_patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": {
                    [key: string]: unknown;
                };
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_task_run_task_runs__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["TaskRunCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_run_task_runs__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_task_run_task_runs__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_task_run_task_runs__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["TaskRunUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_task_runs_task_runs_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_task_runs_task_runs_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    task_run_history_task_runs_history_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_task_run_history_task_runs_history_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HistoryResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_runs_task_runs_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_task_runs_task_runs_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRun"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    paginate_task_runs_task_runs_paginate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_paginate_task_runs_task_runs_paginate_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRunPaginationResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    set_task_run_state_task_runs__id__set_state_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_set_task_run_state_task_runs__id__set_state_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["OrchestrationResult"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_state_flow_run_states__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The flow run state id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["State"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_states_flow_run_states__get: {
        parameters: {
            query: {
                flow_run_id: string;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["State"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_run_state_task_run_states__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run state id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["State"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_run_states_task_run_states__get: {
        parameters: {
            query: {
                task_run_id: string;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["State"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_deployment_deployments__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DeploymentCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_deployment_deployments__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_deployment_deployments__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_deployment_deployments__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DeploymentUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_deployment_by_name_deployments_name__flow_name___deployment_name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The name of the flow */
                flow_name: string;
                /** @description The name of the deployment */
                deployment_name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_deployments_deployments_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_deployments_deployments_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    paginate_deployments_deployments_paginate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_paginate_deployments_deployments_paginate_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentPaginationResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_scheduled_flow_runs_for_deployments_deployments_get_scheduled_flow_runs_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_get_scheduled_flow_runs_for_deployments_deployments_get_scheduled_flow_runs_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_deployments_deployments_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_deployments_deployments_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    schedule_deployment_deployments__id__schedule_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_schedule_deployment_deployments__id__schedule_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    resume_deployment_deployments__id__resume_deployment_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    pause_deployment_deployments__id__pause_deployment_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_flow_run_from_deployment_deployments__id__create_flow_run_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DeploymentFlowRunCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    work_queue_check_for_deployment_deployments__id__work_queue_check_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueue"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_deployment_schedules_deployments__id__schedules_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentSchedule"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_deployment_schedules_deployments__id__schedules_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DeploymentScheduleCreate"][];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["DeploymentSchedule"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_deployment_schedule_deployments__id__schedules__schedule_id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
                /** @description The schedule id */
                schedule_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_deployment_schedule_deployments__id__schedules__schedule_id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The deployment id */
                id: string;
                /** @description The schedule id */
                schedule_id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["DeploymentScheduleUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_saved_search_saved_searches__put: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["SavedSearchCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["SavedSearch"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_saved_search_saved_searches__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The saved search id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["SavedSearch"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_saved_search_saved_searches__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The saved search id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_saved_searches_saved_searches_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_saved_searches_saved_searches_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["SavedSearch"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_logs_logs__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["LogCreate"][];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_logs_logs_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_logs_logs_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Log"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_concurrency_limit_concurrency_limits__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["ConcurrencyLimitCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimit"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_concurrency_limit_concurrency_limits__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The concurrency limit id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimit"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_concurrency_limit_concurrency_limits__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The concurrency limit id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_concurrency_limit_by_tag_concurrency_limits_tag__tag__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The tag name */
                tag: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimit"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_concurrency_limit_by_tag_concurrency_limits_tag__tag__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The tag name */
                tag: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_concurrency_limits_concurrency_limits_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_concurrency_limits_concurrency_limits_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimit"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    reset_concurrency_limit_by_tag_concurrency_limits_tag__tag__reset_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The tag name */
                tag: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_reset_concurrency_limit_by_tag_concurrency_limits_tag__tag__reset_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    increment_concurrency_limits_v1_concurrency_limits_increment_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_increment_concurrency_limits_v1_concurrency_limits_increment_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["MinimalConcurrencyLimitResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    decrement_concurrency_limits_v1_concurrency_limits_decrement_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_decrement_concurrency_limits_v1_concurrency_limits_decrement_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["MinimalConcurrencyLimitResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_concurrency_limit_v2_v2_concurrency_limits__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["ConcurrencyLimitV2Create"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimitV2"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_concurrency_limit_v2_v2_concurrency_limits__id_or_name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID or name of the concurrency limit */
                id_or_name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["GlobalConcurrencyLimitResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_concurrency_limit_v2_v2_concurrency_limits__id_or_name__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID or name of the concurrency limit */
                id_or_name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_concurrency_limit_v2_v2_concurrency_limits__id_or_name__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID or name of the concurrency limit */
                id_or_name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["ConcurrencyLimitV2Update"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_all_concurrency_limits_v2_v2_concurrency_limits_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_all_concurrency_limits_v2_v2_concurrency_limits_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["GlobalConcurrencyLimitResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    bulk_increment_active_slots_v2_concurrency_limits_increment_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_bulk_increment_active_slots_v2_concurrency_limits_increment_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["MinimalConcurrencyLimitResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    bulk_increment_active_slots_with_lease_v2_concurrency_limits_increment_with_lease_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_bulk_increment_active_slots_with_lease_v2_concurrency_limits_increment_with_lease_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ConcurrencyLimitWithLeaseResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    bulk_decrement_active_slots_v2_concurrency_limits_decrement_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_bulk_decrement_active_slots_v2_concurrency_limits_decrement_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["MinimalConcurrencyLimitResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    bulk_decrement_active_slots_with_lease_v2_concurrency_limits_decrement_with_lease_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_bulk_decrement_active_slots_with_lease_v2_concurrency_limits_decrement_with_lease_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    renew_concurrency_lease_v2_concurrency_limits_leases__lease_id__renew_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID of the lease to renew */
                lease_id: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_renew_concurrency_lease_v2_concurrency_limits_leases__lease_id__renew_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_block_type_block_types__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["BlockTypeCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockType"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_type_by_id_block_types__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type ID */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockType"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_block_type_block_types__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type ID */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_block_type_block_types__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type ID */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["BlockTypeUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_type_by_slug_block_types_slug__slug__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type name */
                slug: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockType"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_types_block_types_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_block_types_block_types_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockType"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_documents_for_block_type_block_types_slug__slug__block_documents_get: {
        parameters: {
            query?: {
                /** @description Whether to include sensitive values in the block document. */
                include_secrets?: boolean;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type name */
                slug: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockDocument"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_document_by_name_for_block_type_block_types_slug__slug__block_documents_name__block_document_name__get: {
        parameters: {
            query?: {
                /** @description Whether to include sensitive values in the block document. */
                include_secrets?: boolean;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block type name */
                slug: string;
                /** @description The block type name */
                block_document_name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockDocument"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    install_system_block_types_block_types_install_system_block_types_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_block_document_block_documents__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["BlockDocumentCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockDocument"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_documents_block_documents_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_block_documents_block_documents_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockDocument"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_block_documents_block_documents_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_block_documents_block_documents_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_document_by_id_block_documents__id__get: {
        parameters: {
            query?: {
                /** @description Whether to include sensitive values in the block document. */
                include_secrets?: boolean;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block document id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockDocument"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_block_document_block_documents__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block document id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_block_document_data_block_documents__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block document id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["BlockDocumentUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_work_pool_work_pools__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkPoolCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkPool"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_pool_work_pools__name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkPool"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_work_pool_work_pools__name__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_work_pool_work_pools__name__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkPoolUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_pools_work_pools_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_work_pools_work_pools_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkPool"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_work_pools_work_pools_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_work_pools_work_pools_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    get_scheduled_flow_runs_work_pools__name__get_scheduled_flow_runs_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_get_scheduled_flow_runs_work_pools__name__get_scheduled_flow_runs_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkerFlowRunResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_work_queue_work_pools__work_pool_name__queues_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkQueueCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queue_work_pools__work_pool_name__queues__name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
                /** @description The work pool queue name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_work_queue_work_pools__work_pool_name__queues__name__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
                /** @description The work pool queue name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_work_queue_work_pools__work_pool_name__queues__name__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
                /** @description The work pool queue name */
                name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkQueueUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queues_work_pools__work_pool_name__queues_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_work_queues_work_pools__work_pool_name__queues_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    worker_heartbeat_work_pools__work_pool_name__workers_heartbeat_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_worker_heartbeat_work_pools__work_pool_name__workers_heartbeat_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_workers_work_pools__work_pool_name__workers_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_workers_work_pools__work_pool_name__workers_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkerResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_worker_work_pools__work_pool_name__workers__name__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work pool name */
                work_pool_name: string;
                /** @description The work pool's worker name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_workers_task_workers_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_task_workers_task_workers_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskWorkerResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_work_queue_work_queues__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkQueueCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queue_work_queues__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_work_queue_work_queues__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_work_queue_work_queues__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue id */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["WorkQueueUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queue_by_name_work_queues_name__name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue name */
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queue_runs_work_queues__id__get_runs_post: {
        parameters: {
            query?: never;
            header?: {
                /** @description A header to indicate this request came from the Prefect UI. */
                "x-prefect-ui"?: boolean | null;
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_work_queue_runs_work_queues__id__get_runs_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["FlowRunResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queues_work_queues_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_work_queues_work_queues_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueResponse"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_work_queue_status_work_queues__id__status_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The work queue id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["WorkQueueStatusDetail"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_artifact_artifacts__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["ArtifactCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Artifact"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_artifact_artifacts__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID of the artifact to retrieve. */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Artifact"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_artifact_artifacts__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID of the artifact to delete. */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_artifact_artifacts__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The ID of the artifact to update. */
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["ArtifactUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_latest_artifact_artifacts__key__latest_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The key of the artifact to retrieve. */
                key: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Artifact"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_artifacts_artifacts_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_artifacts_artifacts_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Artifact"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_latest_artifacts_artifacts_latest_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_latest_artifacts_artifacts_latest_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["ArtifactCollection"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_artifacts_artifacts_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_artifacts_artifacts_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_latest_artifacts_artifacts_latest_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_latest_artifacts_artifacts_latest_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_block_schema_block_schemas__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["BlockSchemaCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockSchema"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_schema_by_id_block_schemas__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block schema id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockSchema"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_block_schema_block_schemas__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block schema id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_schemas_block_schemas_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_block_schemas_block_schemas_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockSchema"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_block_schema_by_checksum_block_schemas_checksum__checksum__get: {
        parameters: {
            query?: {
                /** @description Version of block schema. If not provided the most recently created block schema with the matching checksum will be returned. */
                version?: string | null;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The block schema checksum */
                checksum: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["BlockSchema"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_available_block_capabilities_block_capabilities__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": string[];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_view_content_collections_views__view__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                view: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        [key: string]: unknown;
                    };
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_variable_variables__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["VariableCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Variable"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_variable_variables__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Variable"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_variable_variables__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_variable_variables__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["VariableUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_variable_by_name_variables_name__name__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Variable"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_variable_by_name_variables_name__name__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                name: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_variable_by_name_variables_name__name__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                name: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["VariableUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_variables_variables_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_variables_variables_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Variable"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_variables_variables_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_count_variables_variables_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_csrf_token_csrf_token_get: {
        parameters: {
            query: {
                /** @description The client to create a CSRF token for */
                client: string;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["CsrfToken"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_events_events_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Event"][];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_events_events_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_events_events_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["EventPage"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_account_events_page_events_filter_next_get: {
        parameters: {
            query: {
                "page-token": string;
            };
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["EventPage"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_account_events_events_count_by__countable__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                countable: components["schemas"]["Countable"];
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_count_account_events_events_count_by__countable__post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["EventCount"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_automation_automations__post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["AutomationCreate"];
            };
        };
        responses: {
            /** @description Successful Response */
            201: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Automation"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_automation_automations__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Automation"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    update_automation_automations__id__put: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["AutomationUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_automation_automations__id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    patch_automation_automations__id__patch: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                id: string;
            };
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["AutomationPartialUpdate"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_automations_automations_filter_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_automations_automations_filter_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Automation"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_automations_automations_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": number;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_automations_related_to_resource_automations_related_to__resource_id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                resource_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Automation"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    delete_automations_owned_by_resource_automations_owned_by__resource_id__delete: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                resource_id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            202: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    validate_template_templates_validate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": string;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    validate_template_automations_templates_validate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": string;
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_deployments_by_flow_ui_flows_count_deployments_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_count_deployments_by_flow_ui_flows_count_deployments_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        [key: string]: number;
                    };
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    next_runs_by_flow_ui_flows_next_runs_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_next_runs_by_flow_ui_flows_next_runs_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        [key: string]: components["schemas"]["SimpleNextFlowRun"] | null;
                    };
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_flow_run_history_ui_flow_runs_history_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_flow_run_history_ui_flow_runs_history_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["SimpleFlowRun"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    count_task_runs_by_flow_run_ui_flow_runs_count_task_runs_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_count_task_runs_by_flow_run_ui_flow_runs_count_task_runs_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": {
                        [key: string]: number;
                    };
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    validate_obj_ui_schemas_validate_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_validate_obj_ui_schemas_validate_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["SchemaValuesValidationResponse"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_dashboard_task_run_counts_ui_task_runs_dashboard_counts_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody: {
            content: {
                "application/json": components["schemas"]["Body_read_dashboard_task_run_counts_ui_task_runs_dashboard_counts_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["TaskRunCount"][];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_run_counts_by_state_ui_task_runs_count_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_read_task_run_counts_by_state_ui_task_runs_count_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["CountByState"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_task_run_with_flow_run_name_ui_task_runs__id__get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path: {
                /** @description The task run id */
                id: string;
            };
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["UITaskRun"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_settings_admin_settings_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["Settings"];
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    read_version_admin_version_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": string;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    clear_database_admin_database_clear_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_clear_database_admin_database_clear_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    drop_database_admin_database_drop_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_drop_database_admin_database_drop_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    create_database_admin_database_create_post: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: {
            content: {
                "application/json": components["schemas"]["Body_create_database_admin_database_create_post"];
            };
        };
        responses: {
            /** @description Successful Response */
            204: {
                headers: {
                    [name: string]: unknown;
                };
                content?: never;
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    hello_hello_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": string;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
    perform_readiness_check_ready_get: {
        parameters: {
            query?: never;
            header?: {
                "x-prefect-api-version"?: string;
            };
            path?: never;
            cookie?: never;
        };
        requestBody?: never;
        responses: {
            /** @description Successful Response */
            200: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": unknown;
                };
            };
            /** @description Validation Error */
            422: {
                headers: {
                    [name: string]: unknown;
                };
                content: {
                    "application/json": components["schemas"]["HTTPValidationError"];
                };
            };
        };
    };
}
