# API Directory

This directory contains API-related code including query options factories and mutation hooks.

## Directory Structure

- **prefect.ts** - Auto-generated TypeScript types from the Prefect API schema. **DO NOT MODIFY** - this file is generated by `npm run service-sync`
- **subdirectories/** - Domain-specific API code organized by resource (flows, deployments, etc.)

## Auto-Generated Types

**IMPORTANT**: `prefect.ts` is auto-generated from the backend OpenAPI schema. Never edit this file directly. Always prefer using types from this file over creating new types.

- Use types from `prefect.ts` for all API-related operations
- Regenerate types with `npm run service-sync` when the backend schema changes
- Import types like: `import type { components } from '@/api/prefect'`

## Tanstack Query Guidelines

- ALWAYS put `queryOptions` factories and mutation hooks in this directory
- Use `useSuspenseQuery` over `useQuery` for declarative code
- Don't create custom hooks for each query - use `useSuspenseQuery` with query options factories
- When mutating, create custom hooks for each mutation
- Don't perform data transformation in queryOptions factories - do it in components

## Query Key Factory Pattern

Organize react-query keys using a queryKey factory:

```ts
export const queryKeyFactory = {
	all: () => ["some_resource"] as const,
	lists: () => [...queryKeyFactory.all(), "list"] as const,
	listsPaginate: () => [...queryKeyFactory.lists(), "paginate"] as const,
	listPaginate: (filter: Filter) => [...queryKeyFactory.listsPaginate(), filter] as const,
	details: () => [...queryKeyFactory.all(), "details"] as const,
	detail: (id: string) => [...queryKeyFactory.details(), id] as const,
};
```

## Mutation Guidelines

- Prefer using `mutate` over `mutateAsync`
- Use `onSuccess` and `onError` callbacks to handle success and error states
- For invalidation:
  - Create: invalidate `lists()` + `counts()`
  - Delete: invalidate `lists()` + `counts()`
  - Update: invalidate `lists()` + `detail(id)`

## Query Key Factory Scope

- Start with only what is strictly necessary
- Add more query key factory methods later as needed
