/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.reflection.GetDeclaredField;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.BasicQueue;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import sun.misc.Unsafe;

public class ArrayQueue<E>
implements BasicQueue<E> {
    final int capacity;
    final int mask;
    volatile int p001;
    volatile int p002;
    volatile int p003;
    volatile int p004;
    volatile int p005;
    volatile int p006;
    volatile int p007;
    volatile long head;
    volatile long p101;
    volatile long p102;
    volatile long p103;
    volatile long p104;
    volatile long p105;
    volatile long p106;
    volatile long p107;
    volatile long tail;
    volatile long p201;
    volatile long p202;
    volatile long p203;
    volatile long p204;
    volatile long p205;
    volatile long p206;
    volatile long p207;
    private long cachedHead;
    volatile long p301;
    volatile long p302;
    volatile long p303;
    volatile long p304;
    volatile long p305;
    volatile long p306;
    volatile long p307;
    private long cachedTail;
    volatile Object p401;
    volatile Object p402;
    volatile Object p403;
    volatile Object p404;
    volatile Object p405;
    volatile Object p406;
    volatile Object p407;
    private final Object[] array;
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final int base;
    private static final int shift;
    private static final long headOffset;
    private static final long tailOffset;

    public ArrayQueue(int capacity) {
        this.capacity = ArrayQueue.nextPowerOfTwo(capacity);
        this.mask = this.capacity - 1;
        this.array = new Object[this.capacity];
    }

    private static int nextPowerOfTwo(int v) {
        assert (v >= 0);
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean enq(E item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        long i = this.preEnq();
        if (i < 0L) {
            return false;
        }
        this.set((int)i & this.mask, item);
        return true;
    }

    private long preEnq() {
        long t;
        do {
            long w;
            if (this.cachedHead > (w = (t = this.tail) - (long)this.capacity)) continue;
            this.cachedHead = this.head;
            if (this.cachedHead > w) continue;
            return -1L;
        } while (!this.compareAndSetTail(t, t + 1L));
        return t;
    }

    @Override
    public E poll() {
        long h;
        E v;
        do {
            if ((h = this.head) < this.cachedTail) continue;
            this.cachedTail = this.tail;
            if (h < this.cachedTail) continue;
            return null;
        } while ((v = this.get((int)h & this.mask)) == null || !this.compareAndSetHead(h, h + 1L));
        this.cas((int)h & this.mask, v, null);
        return v;
    }

    @Override
    public int size() {
        return (int)(this.tail - this.head);
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    int next(int i) {
        return i + 1 & this.mask;
    }

    int prev(int i) {
        return --i & this.mask;
    }

    private boolean compareAndSetTail(long expect, long update) {
        return UNSAFE.compareAndSwapLong(this, tailOffset, expect, update);
    }

    private boolean compareAndSetHead(long expect, long update) {
        return UNSAFE.compareAndSwapLong(this, headOffset, expect, update);
    }

    private void orderedSetHead(long value) {
        UNSAFE.putOrderedLong(this, headOffset, value);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    private void set(int i, E value) {
        UNSAFE.putObjectVolatile(this.array, ArrayQueue.byteOffset(i), value);
    }

    private void orderedSet(int i, E value) {
        UNSAFE.putOrderedObject(this.array, ArrayQueue.byteOffset(i), value);
    }

    private E get(int i) {
        return (E)UNSAFE.getObjectVolatile(this.array, ArrayQueue.byteOffset(i));
    }

    private boolean cas(int i, E expected, E update) {
        return UNSAFE.compareAndSwapObject(this.array, ArrayQueue.byteOffset(i), expected, update);
    }

    static {
        try {
            headOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(ArrayQueue.class, "head")));
            tailOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(ArrayQueue.class, "tail")));
            base = UNSAFE.arrayBaseOffset(Object[].class);
            int scale = UNSAFE.arrayIndexScale(Object[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (PrivilegedActionException ex) {
            throw new Error(ex.getCause());
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

